// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscaletrue24.h"

ColorScaleTrueColor24::ColorScaleTrueColor24(int s, Visual* visual, int msb)
  : ColorScale(s), TrueColor24(visual)
{
  colors_ = new unsigned char[s*3];

  // we need to check to byteswap when we have cross platforms
  if ((!msb && lsb()) || (msb && !lsb())) {
    for (int i=0; i<s; i++) {
      unsigned int r = psColors_[i*3+2];
      unsigned int g = psColors_[i*3+1];
      unsigned int b = psColors_[i*3];
      unsigned int a = 0;
      a |= r << rs_;
      a |= g << gs_;
      a |= b << bs_;

      memcpy(colors_+i*3, &a, 3);
    }
  }
  else {
    for (int i=0; i<s; i++) {
      unsigned int r = psColors_[i*3+2];
      unsigned int g = psColors_[i*3+1];
      unsigned int b = psColors_[i*3];
      unsigned int a = 0;
      a |= r << rs_;
      a |= g << gs_;
      a |= b << bs_;

      unsigned char* rr = (unsigned char*)(&a);
      *(colors_+i*3) = *(rr+3);
      *(colors_+i*3+1) = *(rr+2);
      *(colors_+i*3+2) = *(rr+1);
    }
  }
}

ColorScaleTrueColor24::~ColorScaleTrueColor24()
{
  if (colors_)
    delete [] colors_;
}

LinearScaleTrueColor24::LinearScaleTrueColor24(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count, 
					       Visual* visual, int msb)
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, visual, msb),
    ColorScale(s) {}

LogScaleTrueColor24::LogScaleTrueColor24(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, double exp,
					 Visual* visual, int msb)
  : LogScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor24(s, visual, msb), 
    ColorScale(s) {}

PowScaleTrueColor24::PowScaleTrueColor24(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, double exp,
					 Visual* visual, int msb)
  : PowScale(s, indexCells, colorCells, count, exp), 
    ColorScaleTrueColor24(s, visual, msb), 
    ColorScale(s) {}

SqrtScaleTrueColor24::SqrtScaleTrueColor24(int s,
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, 
					   Visual* visual, int msb)
  : SqrtScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, visual, msb),
    ColorScale(s) {}

SquaredScaleTrueColor24::SquaredScaleTrueColor24(int s,
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 Visual* visual, int msb)
  : SquaredScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, visual, msb),
    ColorScale(s) {}

AsinhScaleTrueColor24::AsinhScaleTrueColor24(int s,
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count, 
					     Visual* visual, int msb)
  : AsinhScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, visual, msb),
    ColorScale(s) {}

SinhScaleTrueColor24::SinhScaleTrueColor24(int s,
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, 
					   Visual* visual, int msb)
  : SinhScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, visual, msb),
    ColorScale(s) {}

IISScaleTrueColor24::IISScaleTrueColor24(unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, 
					 Visual* visual, int msb)
  : IISScale(indexCells, colorCells, count),
    ColorScaleTrueColor24(IISSIZE, visual, msb),
    ColorScale(IISSIZE) {}

HistEquScaleTrueColor24::HistEquScaleTrueColor24(int s, 
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 double* hist, int histsize,
						 Visual* visual, int msb)
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScaleTrueColor24(s, visual, msb),
    ColorScale(s) {}

