// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __frametruecolor_h__
#define __frametruecolor_h__

#include "frame.h"
#include "frametrue.h"

class FrameTrueColor : public virtual FrameBase, public Frame, public FrameTrue {
 protected:
  long* colormapData;

 private:
  unsigned char* blend(unsigned char*, unsigned char*, int, int);
  void buildXImage(XImage*, Coord::InternalSystem);
  unsigned char* fillImage(int, int,  Coord::InternalSystem);
  unsigned char* fillMask(FitsMask*, int, int,  Coord::InternalSystem);

  void pushMatrices();
  void pushMagnifierMatrices();
  void pushPannerMatrices();
  void pushPSMatrices(float, int, int);

 public:
  FrameTrueColor(Tcl_Interp*, Tk_Canvas, Tk_Item*);
  virtual ~FrameTrueColor();

  void colormapCmd(int, float, float, int, unsigned short*, 
		   unsigned char*, int);
  void colormapBeginCmd();
  void colormapMotionCmd(int, float, float, int, unsigned short*, 
			 unsigned char*, int);
  void colormapEndCmd();
};

#endif
