#  Copyright (C) 1999-2014
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc ImexamDef {} {
    global imexam

    set imexam(button) 0
    set imexam(key) 0
    set imexam(any) 0
    set imexam(frame) {}
    set imexam(x) {}
    set imexam(y) {}
    set imexam(event) {}
    set imexam(mode) {}
}

# Cmds

proc ProcessSendImexamCmd {proc id param} {
    global imexam

    global icursor
    global current

    set imexam(frame) {}
    set imexam(x) {}
    set imexam(y) {}
    set imexam(event) {}
    set imexam(mode) $current(mode)

    set current(mode) imexam

    set imexam(button) 0
    set imexam(key) 0
    set imexam(any) 0

    # turn on blinking cursor
    set icursor(timer) 1
    CursorTimer

    switch -- [string tolower [lindex $param 0]] {
	key {
	    set imexam(key) 1
	    set varname {imexam(key)}
	    set param [lreplace $param 0 0]
	}
	any {
	    set imexam(any) 1
	    set varname {imexam(any)}
	    set param [lreplace $param 0 0]
	}
	default {
	    set imexam(button) 1
	    set varname {imexam(button)}
	}
    }

    switch -- [string tolower [lindex $param 0]] {
	value -
	data {
	    vwait $varname
	    set w [lindex $param 1]
	    set h [lindex $param 2]
	    if {$w == {}} {
		set w 1
	    }
	    if {$h == {}} {
		set h 1
	    }
	    $proc $id "$imexam(event) [$imexam(frame) get data canvas $imexam(x) $imexam(y) $w $h]\n"
	}
	coordinate {
	    set sys [lindex $param 1]
	    set sky [lindex $param 2]
	    set skyformat [lindex $param 3]
	    switch -- $skyformat {
		{} {set skyformat degrees}
	    }
	    switch -- $sky {
		{} {set sky fk5}
	    }
	    switch -- $sys {
		{} {set sys physical}
		fk4 -
		fk5 -
		icrs -
		galactic -
		ecliptic {set sky $sys; set sys wcs}
	    }

	    vwait $varname
	    $proc $id "$imexam(event) [$imexam(frame) get coordinates $imexam(x) $imexam(y) $sys $sky $skyformat]\n"
	}
    }

    # turn off blinking cursor
    set icursor(timer) 0

    set current(mode) $imexam(mode)

    set imexam(button) 0
    set imexam(key) 0

    set imexam(frame) {}
    set imexam(x) {}
    set imexam(y) {}
    set imexam(event) {}
    set imexam(mode) {}
}

