/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * This is a dummy file used for sticking strings from
 * scummvm.appdata.xml into our translation system
 *
 */

#include "common/translation.h"  // For catching the file during POTFILES revies

static const char *summary =
// I18N: One line summary as shown in *nix distributions
_s("Interpreter for numerous adventure games and role-playing games");


static const char *par1 =
// I18N: 1 of 3 paragraph of ScummVM description in *nix distributions
_s("ScummVM is a program which allows you to run a wide variety of classic "
   "graphical point-and-click adventure games and role-playing games, "
   "provided you already have their data files. The clever part about this: "
   "ScummVM just replaces the executables shipped with the game, "
   "allowing you to play them on systems for which they were never designed!");

static const char *par2 =
// I18N: 2 of 3 paragraph of ScummVM description in *nix distributions
_s("Currently, ScummVM supports a huge library of adventures with over 4000 games in total. "
   "It supports many classics published by legendary studios like LucasArts, Sierra On-Line, "
   "Revolution Software, Cyan, Inc. and Westwood Studios.");

static const char *par3 =
// I18N: 3 of 3 paragraph of ScummVM description in *nix distributions
_s("Next to ground-breaking titles like the Monkey Island series, Broken Sword, "
   "Myst, Blade Runner and countless other games you will find "
   "some really obscure adventures and truly hidden gems to explore.");
