// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_BASIC_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_BASIC_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace debug {

//____________________________________________________________________________
// Check

class Check;       	// "projects/library/seqan/basic/basic_debug.h"(254)

//____________________________________________________________________________
// Checkpoint

struct Checkpoint;       	// "projects/library/seqan/basic/basic_debug.h"(330)

//____________________________________________________________________________
// CheckpointLess

struct CheckpointLess;       	// "projects/library/seqan/basic/basic_debug.h"(336)

//____________________________________________________________________________
// CheckpointStore

template <typename T > struct CheckpointStore;       	// "projects/library/seqan/basic/basic_debug.h"(346)

//____________________________________________________________________________
// Report

class Report;       	// "projects/library/seqan/basic/basic_debug.h"(258)

} //namespace debug
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AdaptorIterator

template <typename TIterator, typename TSpec > struct AdaptorIterator;       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(43)

//____________________________________________________________________________
// AllocateStorage_

struct AllocateStorage_;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(97)

//____________________________________________________________________________
// AllocateTemp_

struct AllocateTemp_;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(94)

//____________________________________________________________________________
// AllocateUnspecified_

struct AllocateUnspecified_;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(91)

//____________________________________________________________________________
// Allocator

template <typename TSpec> struct Allocator;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(62)

//____________________________________________________________________________
// AminoAcid_

struct AminoAcid_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1204)

//____________________________________________________________________________
// And

template <typename TBool1, typename TBool2> struct And;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(86)

//____________________________________________________________________________
// BandedGotoh_

struct BandedGotoh_;       	// "projects/library/seqan/basic/basic_tag.h"(131)

//____________________________________________________________________________
// BandedNeedlemanWunsch_

struct BandedNeedlemanWunsch_;       	// "projects/library/seqan/basic/basic_tag.h"(110)

//____________________________________________________________________________
// BandedSmithWaterman_

struct BandedSmithWaterman_;       	// "projects/library/seqan/basic/basic_tag.h"(202)

//____________________________________________________________________________
// BandedWatermanEggert_

struct BandedWatermanEggert_;       	// "projects/library/seqan/basic/basic_tag.h"(227)

//____________________________________________________________________________
// BaseAlphabet

template <typename TValue> struct BaseAlphabet;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1527)

//____________________________________________________________________________
// BitCompressed

template <unsigned BITSIZE1 , unsigned BITSIZE2 > struct BitCompressed;       	// "projects/library/seqan/basic/basic_aggregates.h"(45)

//____________________________________________________________________________
// BitVector_

template <unsigned char _size > struct BitVector_;       	// "projects/library/seqan/basic/basic_aggregates.h"(399)

//____________________________________________________________________________
// BitsPerValue

template <typename TValue> struct BitsPerValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(878)

//____________________________________________________________________________
// Blat_

struct Blat_;       	// "projects/library/seqan/basic/basic_tag.h"(243)

//____________________________________________________________________________
// BytesPerValue

template <typename TValue> struct BytesPerValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(904)

//____________________________________________________________________________
// Cargo

template <typename T> struct Cargo;       	// "projects/library/seqan/basic/basic_type.h"(312)

//____________________________________________________________________________
// Case

template <int tag_,class Type_,class Next_ > struct Case;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(146)

//____________________________________________________________________________
// ChunkPool

template <size_t SIZE, size_t MAX_COUNT , typename TParentAllocator > struct ChunkPool;       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(69)

//____________________________________________________________________________
// ChunkPool2

template <typename TValue, size_t MAX_COUNT , typename TParentAllocator > struct ChunkPool2;       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(261)

//____________________________________________________________________________
// ClassIdentifier_

template <typename T> struct ClassIdentifier_;       	// "projects/library/seqan/basic/basic_definition.h"(291)

//____________________________________________________________________________
// CompareType

template <typename TLeft, typename TRight> struct CompareType;       	// "projects/library/seqan/basic/basic_compare.h"(42)
template <typename TLeft, typename TRight> struct CompareType;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(565)

//____________________________________________________________________________
// Compressed_

struct Compressed_;       	// "projects/library/seqan/basic/basic_aggregates.h"(41)

//____________________________________________________________________________
// ConstParameter_

template <typename T> struct ConstParameter_;       	// "projects/library/seqan/basic/basic_type.h"(501)

//____________________________________________________________________________
// Container

template <typename T> struct Container;       	// "projects/library/seqan/basic/basic_iterator_base.h"(168)
template <typename T> struct Container;       	// "projects/library/seqan/basic/basic_iterator.h"(164)

//____________________________________________________________________________
// Convert

template <typename TTarget, typename TSource > struct Convert;       	// "projects/library/seqan/basic/basic_converter.h"(65)

//____________________________________________________________________________
// CopyConst_

template <typename TFrom, typename TTo> struct CopyConst_;       	// "projects/library/seqan/basic/basic_definition.h"(192)

//____________________________________________________________________________
// CountedPtr

template <typename Type > struct CountedPtr;       	// "projects/library/seqan/basic/basic_counted_ptr.h"(46)

//____________________________________________________________________________
// DeepestSpec

template <typename T> struct DeepestSpec;       	// "projects/library/seqan/basic/basic_type.h"(250)

//____________________________________________________________________________
// DefaultGetIteratorSpec

template <typename T> struct DefaultGetIteratorSpec;       	// "projects/library/seqan/basic/basic_iterator.h"(109)

//____________________________________________________________________________
// DefaultIteratorSpec

template <typename T> struct DefaultIteratorSpec;       	// "projects/library/seqan/basic/basic_iterator.h"(86)

//____________________________________________________________________________
// Default_

struct Default_;       	// "projects/library/seqan/basic/basic_definition.h"(133)

//____________________________________________________________________________
// Difference

template <typename T> struct Difference;       	// "projects/library/seqan/basic/basic_type.h"(154)

//____________________________________________________________________________
// Dna5Q_

struct Dna5Q_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1580)

//____________________________________________________________________________
// Dna5_

struct Dna5_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1101)

//____________________________________________________________________________
// DnaQ_

struct DnaQ_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1550)

//____________________________________________________________________________
// Dna_

struct Dna_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1076)

//____________________________________________________________________________
// DotDrawing_

struct DotDrawing_;       	// "projects/library/seqan/basic/basic_tag.h"(49)

//____________________________________________________________________________
// Eval

template <bool b> struct Eval;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(53)

//____________________________________________________________________________
// False

struct False;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(49)

//____________________________________________________________________________
// Finite

template <unsigned SIZE> struct Finite;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1225)

//____________________________________________________________________________
// GetValue

template <typename T> struct GetValue;       	// "projects/library/seqan/basic/basic_type.h"(83)

//____________________________________________________________________________
// GoEnd_

struct GoEnd_;       	// "projects/library/seqan/basic/basic_definition.h"(160)

//____________________________________________________________________________
// Gotoh_

struct Gotoh_;       	// "projects/library/seqan/basic/basic_tag.h"(121)

//____________________________________________________________________________
// HammingDistance_

struct HammingDistance_;       	// "projects/library/seqan/basic/basic_tag.h"(67)

//____________________________________________________________________________
// Hirschberg_

struct Hirschberg_;       	// "projects/library/seqan/basic/basic_tag.h"(162)

//____________________________________________________________________________
// Holder

template <typename TValue, typename TSpec > struct Holder;       	// "projects/library/seqan/basic/basic_holder.h"(73)

//____________________________________________________________________________
// Host

template <typename T> struct Host;       	// "projects/library/seqan/basic/basic_type.h"(200)

//____________________________________________________________________________
// Id

template <typename T> struct Id;       	// "projects/library/seqan/basic/basic_type.h"(359)

//____________________________________________________________________________
// If

template <bool Flag,class Type1, class Type2> struct If;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(105)

//____________________________________________________________________________
// IntegralForValue

template <typename TValue> struct IntegralForValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(963)

//____________________________________________________________________________
// IntegralForValueImpl_

template <int SIZE> struct IntegralForValueImpl_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(936)

//____________________________________________________________________________
// InternalValueSize_

template <typename TValue> struct InternalValueSize_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(991)

//____________________________________________________________________________
// IsIntegral

template <typename T> struct IsIntegral;       	// "projects/library/seqan/basic/basic_type.h"(675)

//____________________________________________________________________________
// IsSameType

template <class Type1, class Type2> struct IsSameType;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(124)

//____________________________________________________________________________
// IsSimple

template <typename T> struct IsSimple;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(69)
template <typename T> struct IsSimple;       	// "projects/library/seqan/basic/basic_holder.h"(49)

//____________________________________________________________________________
// IsSimple_

template <typename T> struct IsSimple_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(63)

//____________________________________________________________________________
// Iter

template <typename TContainer, typename TSpec> class Iter;       	// "projects/library/seqan/basic/basic_iterator_base.h"(54)

//____________________________________________________________________________
// IterComplementConst

template <typename TIterator> struct IterComplementConst;       	// "projects/library/seqan/basic/basic_iterator_base.h"(66)

//____________________________________________________________________________
// IterMakeConst

template <typename TIterator> struct IterMakeConst;       	// "projects/library/seqan/basic/basic_iterator_base.h"(93)

//____________________________________________________________________________
// Iterator

template <typename T, typename TSpec > struct Iterator;       	// "projects/library/seqan/basic/basic_iterator.h"(145)

//____________________________________________________________________________
// IteratorProxy

template <typename TIterator> struct IteratorProxy;       	// "projects/library/seqan/basic/basic_proxy.h"(79)
template <typename TIterator> struct IteratorProxy;       	// "projects/library/seqan/basic/basic_proxy.h"(190)

//____________________________________________________________________________
// Iterator_Default_Imp

template <typename T, typename TSpec> struct Iterator_Default_Imp;       	// "projects/library/seqan/basic/basic_iterator.h"(135)

//____________________________________________________________________________
// Iupac_

struct Iupac_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1176)

//____________________________________________________________________________
// Key

template <typename T > struct Key;       	// "projects/library/seqan/basic/basic_type.h"(383)

//____________________________________________________________________________
// LENGTH

template <typename T> struct LENGTH;       	// "projects/library/seqan/basic/basic_type.h"(627)

//____________________________________________________________________________
// Lcs_

struct Lcs_;       	// "projects/library/seqan/basic/basic_tag.h"(172)

//____________________________________________________________________________
// Length

template <typename T> struct Length;       	// "projects/library/seqan/basic/basic_definition.h"(49)

//____________________________________________________________________________
// LevenshteinDistance_

struct LevenshteinDistance_;       	// "projects/library/seqan/basic/basic_tag.h"(68)

//____________________________________________________________________________
// Log2

template <__int64 numerus > struct Log2;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(236)

//____________________________________________________________________________
// Log2Floor

template <__int64 numerus > struct Log2Floor;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(241)

//____________________________________________________________________________
// Log2Impl_

template <int BITS_MAX> struct Log2Impl_;       	// "projects/library/seqan/basic/basic_definition.h"(315)

//____________________________________________________________________________
// LogProb

template <typename TValue , typename TSpec > class LogProb;       	// "projects/library/seqan/basic/basic_logvalue.h"(48)
template <typename TValue, typename TSpec> class LogProb;       	// "projects/library/seqan/basic/basic_logvalue.h"(54)

//____________________________________________________________________________
// Loop

template <typename Worker, int I> class Loop;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(191)

//____________________________________________________________________________
// LoopReverse

template <typename Worker, int I> class LoopReverse;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(214)

//____________________________________________________________________________
// MakeSigned_

template <typename T> struct MakeSigned_;       	// "projects/library/seqan/basic/basic_definition.h"(265)

//____________________________________________________________________________
// MakeUnsigned_

template <typename T> struct MakeUnsigned_;       	// "projects/library/seqan/basic/basic_definition.h"(241)

//____________________________________________________________________________
// MaxValue

template <typename T, typename TParent > struct MaxValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1066)

//____________________________________________________________________________
// MaximumValueDouble_

template <typename T > struct MaximumValueDouble_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1005)

//____________________________________________________________________________
// MaximumValueFloat_

template <typename T > struct MaximumValueFloat_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1003)

//____________________________________________________________________________
// MaximumValueSigned_

template <typename T > struct MaximumValueSigned_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1000)

//____________________________________________________________________________
// MaximumValueUnsigned_

template <typename T > struct MaximumValueUnsigned_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(998)

//____________________________________________________________________________
// MemsetConstValueWorker

template <unsigned SIZE, bool direct, unsigned char c> struct MemsetConstValueWorker;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(319)

//____________________________________________________________________________
// MemsetWorker

template <unsigned SIZE, bool direct> struct MemsetWorker;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(273)

//____________________________________________________________________________
// MinValue

template <typename T, typename TParent > struct MinValue;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1098)

//____________________________________________________________________________
// MinimalCtor_

struct MinimalCtor_;       	// "projects/library/seqan/basic/basic_definition.h"(167)

//____________________________________________________________________________
// MinimumValueDouble_

template <typename T > struct MinimumValueDouble_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1015)

//____________________________________________________________________________
// MinimumValueFloat_

template <typename T > struct MinimumValueFloat_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1013)

//____________________________________________________________________________
// MinimumValueSigned_

template <typename T > struct MinimumValueSigned_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1010)

//____________________________________________________________________________
// MinimumValueUnsigned_

template <typename T > struct MinimumValueUnsigned_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(1008)

//____________________________________________________________________________
// Move_

struct Move_;       	// "projects/library/seqan/basic/basic_definition.h"(154)

//____________________________________________________________________________
// MultiPool

template <typename TParentAllocator , unsigned int BLOCKING_LIMIT > struct MultiPool;       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(63)

//____________________________________________________________________________
// MyersBitVector_

struct MyersBitVector_;       	// "projects/library/seqan/basic/basic_tag.h"(142)

//____________________________________________________________________________
// MyersHirschberg_

struct MyersHirschberg_;       	// "projects/library/seqan/basic/basic_tag.h"(152)

//____________________________________________________________________________
// NeedlemanWunsch_

struct NeedlemanWunsch_;       	// "projects/library/seqan/basic/basic_tag.h"(100)

//____________________________________________________________________________
// NilCase

struct NilCase;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(142)

//____________________________________________________________________________
// NonConstPointer_

template <typename T> struct NonConstPointer_;       	// "projects/library/seqan/basic/basic_type.h"(572)

//____________________________________________________________________________
// NonMinimalCtor_

struct NonMinimalCtor_;       	// "projects/library/seqan/basic/basic_definition.h"(171)

//____________________________________________________________________________
// Nothing

struct Nothing;       	// "projects/library/seqan/basic/basic_definition.h"(183)

//____________________________________________________________________________
// Nussinov_

struct Nussinov_;       	// "projects/library/seqan/basic/basic_tag.h"(238)

//____________________________________________________________________________
// Object

template <typename T> struct Object;       	// "projects/library/seqan/basic/basic_type.h"(403)

//____________________________________________________________________________
// Or

template <typename TBool1, typename TBool2> struct Or;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(69)

//____________________________________________________________________________
// Pair

template <typename T1_, typename T2_ , typename TSpec > struct Pair;       	// "projects/library/seqan/basic/basic_aggregates.h"(77)

//____________________________________________________________________________
// Parameter_

template <typename T> struct Parameter_;       	// "projects/library/seqan/basic/basic_type.h"(443)

//____________________________________________________________________________
// Pointer_

template <typename T> struct Pointer_;       	// "projects/library/seqan/basic/basic_type.h"(546)

//____________________________________________________________________________
// Position

template <typename T> struct Position;       	// "projects/library/seqan/basic/basic_type.h"(179)

//____________________________________________________________________________
// PositionIterator

struct PositionIterator;       	// "projects/library/seqan/basic/basic_iterator_position.h"(41)

//____________________________________________________________________________
// Power

template <__int64 base, __int64 exponent > struct Power;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(256)

//____________________________________________________________________________
// ProfileType

template <typename TValue, typename TCount , typename TSpec > class ProfileType;       	// "projects/library/seqan/basic/basic_profchar.h"(46)
template <typename TValue, typename TCount, typename TSpec> class ProfileType;       	// "projects/library/seqan/basic/basic_profchar.h"(55)

//____________________________________________________________________________
// Proxy

template <typename TSpec> struct Proxy;       	// "projects/library/seqan/basic/basic_proxy.h"(61)
template <typename TSpec> struct Proxy;       	// "projects/library/seqan/basic/basic_transport.h"(80)

//____________________________________________________________________________
// QualityValueSize

template <typename TValue> struct QualityValueSize;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1596)

//____________________________________________________________________________
// Reference

template <typename T> struct Reference;       	// "projects/library/seqan/basic/basic_type.h"(106)

//____________________________________________________________________________
// RemoveConst_

template <typename T> struct RemoveConst_;       	// "projects/library/seqan/basic/basic_definition.h"(210)

//____________________________________________________________________________
// Rna5_

struct Rna5_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1151)

//____________________________________________________________________________
// Rna_

struct Rna_;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1126)

//____________________________________________________________________________
// Rooted_

struct Rooted_;       	// "projects/library/seqan/basic/basic_iterator.h"(61)

//____________________________________________________________________________
// Simple

struct Simple;       	// "projects/library/seqan/basic/basic_holder.h"(45)

//____________________________________________________________________________
// SimpleAlloc

template <typename TParentAllocator > struct SimpleAlloc;       	// "projects/library/seqan/basic/basic_allocator_simple.h"(59)

//____________________________________________________________________________
// SimpleIterator

struct SimpleIterator;       	// "projects/library/seqan/basic/basic_iterator_simple.h"(42)

//____________________________________________________________________________
// SimpleType

template <typename TValue, typename TSpec> struct SimpleType;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(77)

//____________________________________________________________________________
// SinglePool

template <size_t SIZE, typename TParentAllocator > struct SinglePool;       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(63)

//____________________________________________________________________________
// SinglePool2

template <typename TValue, typename TParentAllocator > struct SinglePool2;       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(239)

//____________________________________________________________________________
// Size

template <typename T> struct Size;       	// "projects/library/seqan/basic/basic_type.h"(129)

//____________________________________________________________________________
// SmithWatermanClump_

struct SmithWatermanClump_;       	// "projects/library/seqan/basic/basic_tag.h"(214)

//____________________________________________________________________________
// SmithWaterman_

struct SmithWaterman_;       	// "projects/library/seqan/basic/basic_tag.h"(192)

//____________________________________________________________________________
// Source

template <typename TSpec > struct Source;       	// "projects/library/seqan/basic/basic_type.h"(419)

//____________________________________________________________________________
// SourceValue

template <typename T> struct SourceValue;       	// "projects/library/seqan/basic/basic_profchar.h"(129)

//____________________________________________________________________________
// Spec

template <typename T> struct Spec;       	// "projects/library/seqan/basic/basic_type.h"(220)

//____________________________________________________________________________
// Standard_

struct Standard_;       	// "projects/library/seqan/basic/basic_iterator.h"(64)

//____________________________________________________________________________
// StdAllocator

template <typename T, typename TData> struct StdAllocator;       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(178)

//____________________________________________________________________________
// StdContainerIterator

template <typename TStdContainer> struct StdContainerIterator;       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(80)

//____________________________________________________________________________
// StdIteratorAdaptor

struct StdIteratorAdaptor;       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(102)

//____________________________________________________________________________
// Switch

template <int tag,class Case> class Switch;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(154)

//____________________________________________________________________________
// Tag

template <typename T> struct Tag;       	// "projects/library/seqan/basic/basic_definition.h"(43)

//____________________________________________________________________________
// TagList

template <typename TTag , typename TSubList > struct TagList;       	// "projects/library/seqan/basic/basic_definition.h"(72)

//____________________________________________________________________________
// TagSelector

template <typename TTagList > struct TagSelector;       	// "projects/library/seqan/basic/basic_definition.h"(88)

//____________________________________________________________________________
// ToStdAllocator

template <typename THost, typename TValue> struct ToStdAllocator;       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(61)

//____________________________________________________________________________
// TranslateTableAAToAscii_

template <typename T > struct TranslateTableAAToAscii_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(489)

//____________________________________________________________________________
// TranslateTableAsciiToAA_

template <typename T > struct TranslateTableAsciiToAA_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(526)

//____________________________________________________________________________
// TranslateTableAsciiToDna5_

template <typename T > struct TranslateTableAsciiToDna5_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(200)

//____________________________________________________________________________
// TranslateTableAsciiToDna_

template <typename T > struct TranslateTableAsciiToDna_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(162)

//____________________________________________________________________________
// TranslateTableAsciiToIupac_

template <typename T > struct TranslateTableAsciiToIupac_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(311)

//____________________________________________________________________________
// TranslateTableAsciiToRna5_

template <typename T > struct TranslateTableAsciiToRna5_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(274)

//____________________________________________________________________________
// TranslateTableAsciiToRna_

template <typename T > struct TranslateTableAsciiToRna_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(237)

//____________________________________________________________________________
// TranslateTableByteToAA_

template <typename T > struct TranslateTableByteToAA_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(564)

//____________________________________________________________________________
// TranslateTableByteToDna5_

template <typename T > struct TranslateTableByteToDna5_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(377)

//____________________________________________________________________________
// TranslateTableByteToDna_

template <typename T > struct TranslateTableByteToDna_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(348)

//____________________________________________________________________________
// TranslateTableByteToIupac_

template <typename T > struct TranslateTableByteToIupac_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(460)

//____________________________________________________________________________
// TranslateTableByteToRna5_

template <typename T > struct TranslateTableByteToRna5_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(432)

//____________________________________________________________________________
// TranslateTableByteToRna_

template <typename T > struct TranslateTableByteToRna_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(404)

//____________________________________________________________________________
// TranslateTableDna5ToAscii_

template <typename T > struct TranslateTableDna5ToAscii_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(45)

//____________________________________________________________________________
// TranslateTableDna5ToIupac_

template <typename T > struct TranslateTableDna5ToIupac_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(55)

//____________________________________________________________________________
// TranslateTableIupacToAscii_

template <typename T > struct TranslateTableIupacToAscii_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(77)

//____________________________________________________________________________
// TranslateTableIupacToDna5_

template <typename T > struct TranslateTableIupacToDna5_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(134)

//____________________________________________________________________________
// TranslateTableIupacToDna_

template <typename T > struct TranslateTableIupacToDna_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(105)

//____________________________________________________________________________
// TranslateTableRna5ToAscii_

template <typename T > struct TranslateTableRna5ToAscii_;       	// "projects/library/seqan/basic/basic_alphabet_simple_tabs.h"(67)

//____________________________________________________________________________
// Triple

template <typename T1_, typename T2_ , typename T3_ , typename TSpec > struct Triple;       	// "projects/library/seqan/basic/basic_aggregates.h"(242)

//____________________________________________________________________________
// Tristate

struct Tristate;       	// "projects/library/seqan/basic/basic_holder.h"(46)

//____________________________________________________________________________
// Tristate2

struct Tristate2;       	// "projects/library/seqan/basic/basic_holder.h"(1309)

//____________________________________________________________________________
// True

struct True;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(48)

//____________________________________________________________________________
// Tuple

template <typename T_, unsigned _size, typename TSpec > struct Tuple;       	// "projects/library/seqan/basic/basic_aggregates.h"(370)

//____________________________________________________________________________
// TupleShiftLeftWorker_

struct TupleShiftLeftWorker_;       	// "projects/library/seqan/basic/basic_aggregates.h"(585)

//____________________________________________________________________________
// TupleShiftRightWorker_

struct TupleShiftRightWorker_;       	// "projects/library/seqan/basic/basic_aggregates.h"(592)

//____________________________________________________________________________
// Value

template <typename T, const int i > struct Value;       	// "projects/library/seqan/basic/basic_type.h"(56)

//____________________________________________________________________________
// ValueConstructorProxy_

struct ValueConstructorProxy_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(131)

//____________________________________________________________________________
// ValueConstructor_

struct ValueConstructor_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(98)

//____________________________________________________________________________
// ValueDestructorProxy_

struct ValueDestructorProxy_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(161)

//____________________________________________________________________________
// ValueDestructor_

struct ValueDestructor_;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(145)

//____________________________________________________________________________
// ValueSize

template <typename T> struct ValueSize;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(982)

//____________________________________________________________________________
// VertexDescriptor

template <typename T> struct VertexDescriptor;       	// "projects/library/seqan/basic/basic_type.h"(336)

//____________________________________________________________________________
// VoidHolder

class VoidHolder;       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(42)

//____________________________________________________________________________
// VolatilePtr

template <typename Type > struct VolatilePtr;       	// "projects/library/seqan/basic/basic_volatile_ptr.h"(52)

//____________________________________________________________________________
// WEIGHT

template <typename T> struct WEIGHT;       	// "projects/library/seqan/basic/basic_type.h"(650)

//____________________________________________________________________________
// WorkerNothing

struct WorkerNothing;       	// "projects/library/seqan/basic/basic_metaprogramming.h"(185)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AminoAcid

typedef SimpleType<unsigned char, AminoAcid_> AminoAcid;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1205)

//____________________________________________________________________________
// Ascii

typedef char Ascii;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(77)

//____________________________________________________________________________
// BandedGotoh

typedef Tag<BandedGotoh_> BandedGotoh;       	// "projects/library/seqan/basic/basic_tag.h"(132)

//____________________________________________________________________________
// BandedNeedlemanWunsch

typedef Tag<BandedNeedlemanWunsch_> BandedNeedlemanWunsch;       	// "projects/library/seqan/basic/basic_tag.h"(111)

//____________________________________________________________________________
// BandedSmithWaterman

typedef Tag<BandedSmithWaterman_> const BandedSmithWaterman;       	// "projects/library/seqan/basic/basic_tag.h"(203)

//____________________________________________________________________________
// BandedSmithWatermanClump

typedef Tag<BandedWatermanEggert_> const BandedSmithWatermanClump;       	// "projects/library/seqan/basic/basic_tag.h"(228)

//____________________________________________________________________________
// BandedWatermanEggert

typedef Tag<BandedWatermanEggert_> const BandedWatermanEggert;       	// "projects/library/seqan/basic/basic_tag.h"(229)

//____________________________________________________________________________
// Blat

typedef Tag<Blat_> const Blat;       	// "projects/library/seqan/basic/basic_tag.h"(244)

//____________________________________________________________________________
// Compressed

typedef Tag<Compressed_> Compressed;       	// "projects/library/seqan/basic/basic_aggregates.h"(42)

//____________________________________________________________________________
// Default

typedef Tag<Default_> const Default;       	// "projects/library/seqan/basic/basic_definition.h"(134)

//____________________________________________________________________________
// Dna

typedef SimpleType<unsigned char,Dna_> Dna;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1077)

//____________________________________________________________________________
// Dna5

typedef SimpleType<unsigned char, Dna5_> Dna5;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1102)

//____________________________________________________________________________
// Dna5Q

typedef SimpleType <unsigned char, Dna5Q_> Dna5Q;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1581)

//____________________________________________________________________________
// DnaQ

typedef SimpleType <unsigned char, DnaQ_> DnaQ;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1551)

//____________________________________________________________________________
// DotDrawing

typedef Tag<DotDrawing_> const DotDrawing;       	// "projects/library/seqan/basic/basic_tag.h"(50)

//____________________________________________________________________________
// EditDistance

typedef Tag<LevenshteinDistance_> EditDistance;       	// "projects/library/seqan/basic/basic_tag.h"(72)

//____________________________________________________________________________
// GoEnd

typedef Tag<GoEnd_> const GoEnd;       	// "projects/library/seqan/basic/basic_definition.h"(161)

//____________________________________________________________________________
// Gotoh

typedef Tag<Gotoh_> Gotoh;       	// "projects/library/seqan/basic/basic_tag.h"(122)

//____________________________________________________________________________
// HammingDistance

typedef Tag<HammingDistance_> HammingDistance;       	// "projects/library/seqan/basic/basic_tag.h"(70)

//____________________________________________________________________________
// Hirschberg

typedef Tag<Hirschberg_> const Hirschberg;       	// "projects/library/seqan/basic/basic_tag.h"(163)

//____________________________________________________________________________
// Iupac

typedef SimpleType<unsigned char, Iupac_> Iupac;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1177)

//____________________________________________________________________________
// Lcs

typedef Tag<Lcs_> const Lcs;       	// "projects/library/seqan/basic/basic_tag.h"(173)

//____________________________________________________________________________
// LevenshteinDistance

typedef Tag<LevenshteinDistance_> LevenshteinDistance;       	// "projects/library/seqan/basic/basic_tag.h"(71)

//____________________________________________________________________________
// MinimalCtor

typedef Tag<MinimalCtor_> const MinimalCtor;       	// "projects/library/seqan/basic/basic_definition.h"(168)

//____________________________________________________________________________
// Move

typedef Tag<Move_> const Move;       	// "projects/library/seqan/basic/basic_definition.h"(155)

//____________________________________________________________________________
// MyersBitVector

typedef Tag<MyersBitVector_> const MyersBitVector;       	// "projects/library/seqan/basic/basic_tag.h"(143)

//____________________________________________________________________________
// MyersHirschberg

typedef Tag<MyersHirschberg_> const MyersHirschberg;       	// "projects/library/seqan/basic/basic_tag.h"(153)

//____________________________________________________________________________
// NeedlemanWunsch

typedef Tag<NeedlemanWunsch_> NeedlemanWunsch;       	// "projects/library/seqan/basic/basic_tag.h"(101)

//____________________________________________________________________________
// NonMinimalCtor

typedef Tag<NonMinimalCtor_> const NonMinimalCtor;       	// "projects/library/seqan/basic/basic_definition.h"(172)

//____________________________________________________________________________
// Nussinov

typedef Tag<Nussinov_> const Nussinov;       	// "projects/library/seqan/basic/basic_tag.h"(239)

//____________________________________________________________________________
// PoolAllocator

typedef Allocator<MultiPool<Allocator<SimpleAlloc<Default> >, 0x100> > PoolAllocator;       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(67)

//____________________________________________________________________________
// Rna

typedef SimpleType<unsigned char,Rna_> Rna;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1127)

//____________________________________________________________________________
// Rna5

typedef SimpleType<unsigned char, Rna5_> Rna5;       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1152)

//____________________________________________________________________________
// Rooted

typedef Tag<Rooted_> const Rooted;       	// "projects/library/seqan/basic/basic_iterator.h"(62)

//____________________________________________________________________________
// SimpleAllocator

typedef Allocator<SimpleAlloc<Default> > SimpleAllocator;       	// "projects/library/seqan/basic/basic_allocator_simple.h"(64)

//____________________________________________________________________________
// SmithWaterman

typedef Tag<SmithWaterman_> const SmithWaterman;       	// "projects/library/seqan/basic/basic_tag.h"(193)

//____________________________________________________________________________
// SmithWatermanClump

typedef Tag<SmithWatermanClump_> const SmithWatermanClump;       	// "projects/library/seqan/basic/basic_tag.h"(215)

//____________________________________________________________________________
// Standard

typedef Tag<Standard_> const Standard;       	// "projects/library/seqan/basic/basic_iterator.h"(65)

//____________________________________________________________________________
// TagAllocateStorage

typedef Tag<AllocateStorage_> const TagAllocateStorage;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(98)

//____________________________________________________________________________
// TagAllocateTemp

typedef Tag<AllocateTemp_> const TagAllocateTemp;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(95)

//____________________________________________________________________________
// TagAllocateUnspecified

typedef Tag<AllocateUnspecified_> const TagAllocateUnspecified;       	// "projects/library/seqan/basic/basic_allocator_interface.h"(92)

//____________________________________________________________________________
// Unicode

typedef wchar_t Unicode;       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(79)

//____________________________________________________________________________
// WatermanEggert

typedef Tag<SmithWatermanClump_> const WatermanEggert;       	// "projects/library/seqan/basic/basic_tag.h"(216)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {
namespace debug {

//____________________________________________________________________________
// Error

template <typename TAction> void Error(const char * file, int line, const char * comment);       	// "projects/library/seqan/basic/basic_debug.h"(266)
template <typename TAction> void Error(const char * file, int line);       	// "projects/library/seqan/basic/basic_debug.h"(273)

//____________________________________________________________________________
// Message

template <typename TAction> void Message(const char * file, int line, const char * comment);       	// "projects/library/seqan/basic/basic_debug.h"(282)
template <typename TAction> void Message(const char * file, int line);       	// "projects/library/seqan/basic/basic_debug.h"(288)

//____________________________________________________________________________
// Result

template <typename TAction> void Result(const char * file, int line, const char * comment);       	// "projects/library/seqan/basic/basic_debug.h"(297)
template <typename TAction> void Result(const char * file, int line);       	// "projects/library/seqan/basic/basic_debug.h"(303)

//____________________________________________________________________________
// checkpoint

inline bool checkpoint(unsigned int line, char const* file);       	// "projects/library/seqan/basic/basic_debug.h"(355)

//____________________________________________________________________________
// testCheckpoint

inline void testCheckpoint(char const* file, unsigned int line);       	// "projects/library/seqan/basic/basic_debug.h"(371)

//____________________________________________________________________________
// verifyCheckpoints

inline void verifyCheckpoints(char const* file);       	// "projects/library/seqan/basic/basic_debug.h"(379)

} //namespace debug
} //namespace SEQAN_NAMESPACE_MAIN
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// TValue

template <typename TValue, size_t I> inline void setValue(Holder<TValue *, Tristate> & me, TValue (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(922)
template <typename TValue, size_t I> inline void setValue(Holder<TValue * const, Tristate> & me, TValue (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(944)

//____________________________________________________________________________
// _abs

template <typename T> inline T _abs(T const & x);       	// "projects/library/seqan/basic/basic_definition.h"(408)

//____________________________________________________________________________
// _allocatorBlockNumber

template <typename TParentAllocator, unsigned int BLOCKING_LIMIT> inline unsigned int _allocatorBlockNumber(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > &, size_t size_);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(153)

//____________________________________________________________________________
// _arrayClearSpaceDefault

template <typename TIterator> void _arrayClearSpaceDefault(TIterator array_begin, size_t array_length, size_t keep_from, size_t move_to);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(814)

//____________________________________________________________________________
// _arrayClearSpacePointer

template <typename TValue> inline void _arrayClearSpacePointer(TValue * array_begin, size_t array_length, size_t keep_from, size_t move_to, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(365)
template <typename TValue> inline void _arrayClearSpacePointer(TValue * array_begin, size_t array_length, size_t keep_from, size_t move_to, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(377)

//____________________________________________________________________________
// _arrayConstructCopyDefault

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayConstructCopyDefault(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(379)

//____________________________________________________________________________
// _arrayConstructCopyPointer

template <typename TValueSource, typename TValueTarget> inline void _arrayConstructCopyPointer(TValueSource * source_begin, TValueSource * source_end, TValueTarget * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(112)
template <typename TValueSource, typename TValueTarget> inline void _arrayConstructCopyPointer(TValueSource * source_begin, TValueSource * source_end, TValueTarget const* target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(122)
template <typename TValueSource, typename TValueTarget> inline void _arrayConstructCopyPointer(TValueSource * source_begin, TValueSource * source_end, TValueTarget * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(133)

//____________________________________________________________________________
// _arrayConstructDefault

template <typename TIterator1, typename TIterator2> inline void _arrayConstructDefault(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(309)
template <typename TIterator1, typename TIterator2, typename TParam> inline void _arrayConstructDefault(TIterator1 begin_, TIterator2 end_, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(333)

//____________________________________________________________________________
// _arrayConstructMoveDefault

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayConstructMoveDefault(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(428)

//____________________________________________________________________________
// _arrayConstructMovePointer

template <typename TValue> inline void _arrayConstructMovePointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(157)
template <typename TValue> inline void _arrayConstructMovePointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(167)

//____________________________________________________________________________
// _arrayConstructPointer

template <typename TIterator> inline void _arrayConstructPointer(TIterator, TIterator, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(48)
template <typename TIterator> inline void _arrayConstructPointer(TIterator begin_, TIterator end_, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(57)
template <typename TIterator, typename TParam> inline void _arrayConstructPointer(TIterator begin_, TIterator end_, TParam const & param_, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(78)
template <typename TIterator, typename TParam> inline void _arrayConstructPointer(TIterator begin_, TIterator end_, TParam const & param_, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(88)

//____________________________________________________________________________
// _arrayCopyBackwardDefault

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayCopyBackwardDefault(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(582)

//____________________________________________________________________________
// _arrayCopyBackwardPointer

template <typename TValue> inline void _arrayCopyBackwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(262)
template <typename TValue> inline void _arrayCopyBackwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(272)

//____________________________________________________________________________
// _arrayCopyForwardDefault

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayCopyForwardDefault(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(538)

//____________________________________________________________________________
// _arrayCopyForwardPointer

template <typename TValue> inline void _arrayCopyForwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(228)
template <typename TValue> inline void _arrayCopyForwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(238)

//____________________________________________________________________________
// _arrayDestructDefault

template <typename TIterator1, typename TIterator2> inline void _arrayDestructDefault(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(468)

//____________________________________________________________________________
// _arrayDestructPointer

template <typename TValue> inline void _arrayDestructPointer(TValue * , TValue * , True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(190)
template <typename TValue> inline void _arrayDestructPointer(TValue * begin_, TValue * end_, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(199)

//____________________________________________________________________________
// _arrayMoveBackwardDefault

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayMoveBackwardDefault(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(717)

//____________________________________________________________________________
// _arrayMoveBackwardPointer

template <typename TValue> inline void _arrayMoveBackwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(330)
template <typename TValue> inline void _arrayMoveBackwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(340)

//____________________________________________________________________________
// _arrayMoveForwardDefault

template <typename TTarget, typename TSource1, typename TSource2> inline void _arrayMoveForwardDefault(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(667)

//____________________________________________________________________________
// _arrayMoveForwardPointer

template <typename TValue> inline void _arrayMoveForwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, True);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(296)
template <typename TValue> inline void _arrayMoveForwardPointer(TValue * source_begin, TValue * source_end, TValue * target_begin, False);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(306)

//____________________________________________________________________________
// _dataValue

template <typename TValue> inline typename Reference<Holder<TValue, Tristate> >::Type _dataValue(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(479)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate> const>::Type _dataValue(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(485)
template <typename TValue> inline typename Reference<Holder<TValue *, Tristate> >::Type _dataValue(Holder<TValue *, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(492)
template <typename TValue> inline typename Reference<Holder<TValue *, Tristate> const>::Type _dataValue(Holder<TValue *, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(498)
template <typename TValue> inline typename Reference<Holder<TValue * const, Tristate> >::Type _dataValue(Holder<TValue * const, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(505)
template <typename TValue> inline typename Reference<Holder<TValue * const, Tristate> const>::Type _dataValue(Holder<TValue * const, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(511)

//____________________________________________________________________________
// _getMaxIndex

template <typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline typename Size<ProfileType<TSourceValue, TSourceCount, TSourceSpec> const >::Type _getMaxIndex(ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(162)

//____________________________________________________________________________
// _holderAllocateObject

template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type * _holderAllocateObject(THolder & me, TValue const & data);       	// "projects/library/seqan/basic/basic_holder.h"(549)

//____________________________________________________________________________
// _holderAllocatePointer

template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type _holderAllocatePointer(THolder & me, TValue * data, True);       	// "projects/library/seqan/basic/basic_holder.h"(559)
template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type _holderAllocatePointer(THolder & , TValue * data, False);       	// "projects/library/seqan/basic/basic_holder.h"(570)
template <typename THolder, typename TValue> inline typename Value<THolder, 0>::Type _holderAllocatePointer(THolder & me, TValue * data);       	// "projects/library/seqan/basic/basic_holder.h"(577)

//____________________________________________________________________________
// _holderDeallocate

template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & me, TValue const & data);       	// "projects/library/seqan/basic/basic_holder.h"(586)
template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & me, TValue * data, True);       	// "projects/library/seqan/basic/basic_holder.h"(594)
template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & , TValue * , False);       	// "projects/library/seqan/basic/basic_holder.h"(603)
template <typename THolder, typename TValue> inline void _holderDeallocate(THolder & me, TValue * data);       	// "projects/library/seqan/basic/basic_holder.h"(609)

//____________________________________________________________________________
// _intPow

template <typename TValue, typename TExponent> inline TValue _intPow(TValue a, TExponent b);       	// "projects/library/seqan/basic/basic_definition.h"(357)

//____________________________________________________________________________
// _isSameType

template <typename T1, typename T2> inline bool _isSameType();       	// "projects/library/seqan/basic/basic_definition.h"(420)

//____________________________________________________________________________
// _max

template <typename Ty_> inline const Ty_& _max(const Ty_& _Left, const Ty_& Right_);       	// "projects/library/seqan/basic/basic_definition.h"(390)
template <typename Tx_, typename Ty_> inline Tx_ _max(const Tx_& _Left, const Ty_& Right_);       	// "projects/library/seqan/basic/basic_definition.h"(399)

//____________________________________________________________________________
// _min

template <typename Tx_> inline const Tx_& _min(const Tx_& _Left, const Tx_& Right_);       	// "projects/library/seqan/basic/basic_definition.h"(375)
template <typename Tx_, typename Ty_> inline Tx_ _min(const Tx_& _Left, const Ty_& Right_);       	// "projects/library/seqan/basic/basic_definition.h"(384)

//____________________________________________________________________________
// _toParameter

template <typename T> typename Parameter_<T>::Type _toParameter(T * _object);       	// "projects/library/seqan/basic/basic_type.h"(474)
template <typename T> typename Parameter_<T>::Type _toParameter(T _object);       	// "projects/library/seqan/basic/basic_type.h"(481)

//____________________________________________________________________________
// _toPointer

template <typename T> typename NonConstPointer_<T>::Type _toPointer(T & _object);       	// "projects/library/seqan/basic/basic_type.h"(593)
template <typename T> typename NonConstPointer_<T const>::Type _toPointer(T const & _object);       	// "projects/library/seqan/basic/basic_type.h"(600)
template <typename T> typename NonConstPointer_<T *>::Type _toPointer(T * _object);       	// "projects/library/seqan/basic/basic_type.h"(608)

//____________________________________________________________________________
// allocate

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me, TValue * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(186)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void allocate(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me, TValue2 * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(315)
template <size_t SIZE, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<SinglePool<SIZE, TParentAllocator> > & me, TValue * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(175)
template <typename TValue, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void allocate(Allocator<SinglePool2<TValue, TParentAllocator> > & me, TValue2 * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(292)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me, TValue * & data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(178)
template <typename T, typename TValue, typename TSize> inline void allocate(T const & me, TValue * & data, TSize count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(143)
template <typename T, typename TValue, typename TSize> inline void allocate(T & me, TValue * & data, TSize count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(151)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void allocate(T const &, TValue * & data, TSize count, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(161)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void allocate(T &, TValue * & data, TSize count, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(187)
template <typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void allocate(Allocator<SimpleAlloc<TParentAllocator> > & me, TValue * & data, TSize count, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(160)

//____________________________________________________________________________
// arrayClearSpace

template <typename TIterator> void arrayClearSpace(TIterator array_begin, size_t array_length, size_t keep_from, size_t move_to);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(858)
template <typename TValue> void arrayClearSpace(TValue * array_begin, size_t array_length, size_t keep_from, size_t move_to);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(385)

//____________________________________________________________________________
// arrayConstruct

template <typename TIterator1, typename TIterator2> inline void arrayConstruct(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(321)
template <typename TIterator1, typename TIterator2, typename TParam> inline void arrayConstruct(TIterator1 begin_, TIterator2 end_, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(346)
template <typename TValue> inline void arrayConstruct(TValue * begin_, TValue * end_);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(65)
template <typename TValue, typename TParam> inline void arrayConstruct(TValue * begin_, TValue * end_, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(97)

//____________________________________________________________________________
// arrayConstructCopy

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayConstructCopy(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(394)
template <typename TValueSource, typename TValueTarget> inline void arrayConstructCopy(TValueSource * source_begin, TValueSource * source_end, TValueTarget * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(142)

//____________________________________________________________________________
// arrayConstructMove

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayConstructMove(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(443)
template <typename TValue> inline void arrayConstructMove(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(176)

//____________________________________________________________________________
// arrayCopy

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayCopy(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(627)

//____________________________________________________________________________
// arrayCopyBackward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayCopyBackward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(591)
template <typename TValue> inline void arrayCopyBackward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(281)

//____________________________________________________________________________
// arrayCopyForward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayCopyForward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(547)
template <typename TValue> inline void arrayCopyForward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(247)

//____________________________________________________________________________
// arrayDestruct

template <typename TIterator1, typename TIterator2> inline void arrayDestruct(TIterator1 begin_, TIterator2 end_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(480)
template <typename TValue> inline void arrayDestruct(TValue * begin_, TValue * end_);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(207)

//____________________________________________________________________________
// arrayFill

template <typename TIterator1, typename TIterator2, typename TValue> inline void arrayFill(TIterator1 begin_, TIterator2 end_, TValue const & value);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(507)

//____________________________________________________________________________
// arrayMove

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayMove(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(771)

//____________________________________________________________________________
// arrayMoveBackward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayMoveBackward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(732)
template <typename TValue> inline void arrayMoveBackward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(349)

//____________________________________________________________________________
// arrayMoveForward

template <typename TTarget, typename TSource1, typename TSource2> inline void arrayMoveForward(TSource1 source_begin, TSource2 source_end, TTarget target_begin);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(681)
template <typename TValue> inline void arrayMoveForward(TValue * source_begin, TValue * source_end, TValue * target_begin);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(315)

//____________________________________________________________________________
// assign

template <typename TTargetContainer, typename TIterator, typename TSpec, typename TSource> inline void assign(Iter<TTargetContainer, AdaptorIterator<TIterator, TSpec> > & target, TSource const & source);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(577)
template <typename TValue> inline void assign(VoidHolder & me, TValue const & val);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(200)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(183)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(65)
template <typename TTarget, typename TSource> inline void assign(TTarget & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(73)
template <typename TTargetSpec, typename TSource> inline void assign(Proxy<TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(86)
template <typename TTargetSpec, typename TSource> inline void assign(Proxy<TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(95)
template <typename TValue> inline void assign(Holder<TValue, Tristate> & target_, Holder<TValue, Tristate> const & source_);       	// "projects/library/seqan/basic/basic_holder.h"(1062)
template <typename TValue> inline void assign(Holder<TValue, Simple> & target_, Holder<TValue, Simple> const & source_);       	// "projects/library/seqan/basic/basic_holder.h"(1293)
template <typename TValue> inline void assign(Holder<TValue, Tristate2> & target_, Holder<TValue, Tristate2> const & source_);       	// "projects/library/seqan/basic/basic_holder.h"(1609)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, SimpleType<TSourceValue, TSourceSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(323)
template <typename TTargetValue, typename TTargetSpec, typename TSourceValue, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, SimpleType<TSourceValue, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(331)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, TSource & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(342)
template <typename TTargetValue, typename TTargetSpec, typename TSource> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(350)
template <typename TTargetValue, typename TTargetSpec, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, Proxy<TSourceSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(363)
template <typename TTargetValue, typename TTargetSpec, typename TSourceSpec> inline void assign(SimpleType<TTargetValue, TTargetSpec> & target, Proxy<TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(372)
template <typename TValue, typename TSpec> inline void assign(__int64 & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(387)
template <typename TValue, typename TSpec> inline void assign(__int64 & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(395)
template <typename TValue, typename TSpec> inline void assign(__uint64 & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(405)
template <typename TValue, typename TSpec> inline void assign(__uint64 & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(413)
template <typename TValue, typename TSpec> inline void assign(int & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(423)
template <typename TValue, typename TSpec> inline void assign(int & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(431)
template <typename TValue, typename TSpec> inline void assign(unsigned int & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(441)
template <typename TValue, typename TSpec> inline void assign(unsigned int & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(449)
template <typename TValue, typename TSpec> inline void assign(short & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(459)
template <typename TValue, typename TSpec> inline void assign(short & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(467)
template <typename TValue, typename TSpec> inline void assign(unsigned short & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(477)
template <typename TValue, typename TSpec> inline void assign(unsigned short & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(485)
template <typename TValue, typename TSpec> inline void assign(char & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(495)
template <typename TValue, typename TSpec> inline void assign(char & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(503)
template <typename TValue, typename TSpec> inline void assign(signed char & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(513)
template <typename TValue, typename TSpec> inline void assign(signed char & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(521)
template <typename TValue, typename TSpec> inline void assign(unsigned char & c_target, SimpleType<TValue, TSpec> & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(531)
template <typename TValue, typename TSpec> inline void assign(unsigned char & c_target, SimpleType<TValue, TSpec> const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(539)
inline void assign(Ascii & c_target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1238)
inline void assign(Ascii & c_target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1246)
inline void assign(Ascii& target, Rna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1254)
inline void assign(Ascii& target, Rna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1262)
inline void assign(Ascii & c_target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1269)
inline void assign(Ascii & c_target, AminoAcid const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1276)
inline void assign(Dna & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1287)
inline void assign(Dna & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1296)
inline void assign(Dna & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1305)
inline void assign(Dna & target, Dna5 const & c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1314)
inline void assign(Dna & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1323)
inline void assign(Dna5 & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1334)
inline void assign(Dna5 & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1343)
inline void assign(Dna5 & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1352)
inline void assign(Dna5 & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1361)
inline void assign(Dna5 & target, Dna const & c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1370)
inline void assign(Rna & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1381)
inline void assign(Rna & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1390)
inline void assign(Rna & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1399)
inline void assign(Rna & target, Rna5 const & c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1408)
inline void assign(Rna5 & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1419)
inline void assign(Rna5 & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1428)
inline void assign(Rna5 & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1437)
inline void assign(Rna5 & target, Rna const & c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1446)
inline void assign(Iupac & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1457)
inline void assign(Iupac & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1466)
inline void assign(Iupac & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1475)
inline void assign(Iupac & target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1482)
inline void assign(Iupac & target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1489)
inline void assign(AminoAcid & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1500)
inline void assign(AminoAcid & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1509)
inline void assign(AminoAcid & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1518)
inline void assign(DnaQ & target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1646)
inline void assign(DnaQ & target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1680)
inline void assign(Dna5Q & target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1691)
inline void assign(Dna5 & target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1701)
inline void assign(Dna5Q & target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1733)
inline void assign(Dna & target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1753)
inline void assign(DnaQ & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1764)
inline void assign(DnaQ & target, Dna5 const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1775)
inline void assign(DnaQ & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1783)
inline void assign(DnaQ & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1792)
inline void assign(DnaQ & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1801)
inline void assign(DnaQ & target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1809)
template <typename TSource> inline void assign(DnaQ & target, TSource const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1817)
inline void assign(Dna5Q & target, Dna const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1827)
inline void assign(Dna & target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1838)
inline void assign(Dna5 & target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1847)
inline void assign(Dna5Q & target, __uint8 c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1858)
inline void assign(Dna5Q & target, Ascii c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1867)
inline void assign(Dna5Q & target, Unicode c_source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1876)
inline void assign(Dna5Q & target, Iupac const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1885)
inline void assign(Dna5Q & target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1892)
template <typename TSource> inline void assign(Dna5Q & target, TSource const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1899)
inline void assign(__int64 & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1914)
inline void assign(__int64 & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1922)
inline void assign(__uint64 & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1932)
inline void assign(__uint64 & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1940)
inline void assign(int & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1950)
inline void assign(int & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1958)
inline void assign(unsigned int & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1968)
inline void assign(unsigned int & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1976)
inline void assign(short & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1987)
inline void assign(short & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1995)
inline void assign(unsigned short & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2005)
inline void assign(unsigned short & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2013)
inline void assign(char & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2023)
inline void assign(char & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2031)
inline void assign(signed char & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2041)
inline void assign(signed char & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2049)
inline void assign(unsigned char & c_target, DnaQ & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2059)
inline void assign(unsigned char & c_target, DnaQ const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2067)
inline void assign(__int64 & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2078)
inline void assign(__int64 & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2086)
inline void assign(__uint64 & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2096)
inline void assign(__uint64 & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2104)
inline void assign(int & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2114)
inline void assign(int & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2122)
inline void assign(unsigned int & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2132)
inline void assign(unsigned int & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2140)
inline void assign(short & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2151)
inline void assign(short & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2159)
inline void assign(unsigned short & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2169)
inline void assign(unsigned short & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2177)
inline void assign(char & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2187)
inline void assign(char & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2195)
inline void assign(signed char & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2205)
inline void assign(signed char & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2213)
inline void assign(unsigned char & c_target, Dna5Q & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2223)
inline void assign(unsigned char & c_target, Dna5Q const & source);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2231)
template <typename TTargetContainer, typename TSource> inline void assign(Iter<TTargetContainer, StdIteratorAdaptor> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(440)
template <typename TTargetContainer, typename TSource> inline void assign(Iter<TTargetContainer, PositionIterator> & target, TSource const & source);       	// "projects/library/seqan/basic/basic_iterator_position.h"(469)

//____________________________________________________________________________
// assignHost

template <typename T, typename THost> inline void assignHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(147)
template <typename T, typename THost> inline void assignHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(155)

//____________________________________________________________________________
// assignQualities

template <typename TDest, typename TSource> void assignQualities(TDest &dst, TSource const &src);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2342)

//____________________________________________________________________________
// assignQualityValue

inline void assignQualityValue(DnaQ &c, int q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2290)
inline void assignQualityValue(Dna5Q &c, int q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2300)
inline void assignQualityValue(DnaQ &c, Ascii q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2310)
inline void assignQualityValue(Dna5Q &c, Ascii q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2320)

//____________________________________________________________________________
// assignValue

template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(307)
template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void assignValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(315)
template <typename TValue, typename TSource> inline void assignValue(Holder<TValue, Tristate> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1020)
template <typename TValue, typename TSource> inline void assignValue(Holder<TValue, Simple> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1271)
template <typename TValue, typename TSource> inline void assignValue(Holder<TValue, Tristate2> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1567)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(178)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue const & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(185)
template <typename T, typename TValue> inline void assignValue(T & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(278)
template <typename T, typename TValue> inline void assignValue(T const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(288)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, PositionIterator> & me, TValue _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(207)
template <typename TContainer, typename TValue> inline void assignValue(Iter<TContainer, PositionIterator> const & me, TValue _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(215)

//____________________________________________________________________________
// assignValueAt

template <typename TObject, typename TPos, typename TSource> inline TSource & assignValueAt(TObject &me, TPos k, TSource &source);       	// "projects/library/seqan/basic/basic_aggregates.h"(517)
template <typename TObject, typename TPos, typename TSource> inline TSource const & assignValueAt(TObject &me, TPos k, TSource const &source);       	// "projects/library/seqan/basic/basic_aggregates.h"(524)
template <typename T_, unsigned _size, typename tmpS, typename TPos> inline tmpS const assignValueAt(Tuple<T_, _size, void> &me, TPos k, tmpS const source);       	// "projects/library/seqan/basic/basic_aggregates.h"(530)
template <typename T_, unsigned _size, typename tmpS, typename TPos> inline tmpS const assignValueAt(Tuple<T_, _size, Compressed> &me, TPos k, tmpS const source);       	// "projects/library/seqan/basic/basic_aggregates.h"(535)
template <typename T_, typename tmpS, typename Spec_, unsigned _size, typename TPos> inline SimpleType<tmpS, Spec_> const & assignValueAt(Tuple<T_, _size, Compressed> &me, TPos k, SimpleType<tmpS, Spec_> const &source);       	// "projects/library/seqan/basic/basic_aggregates.h"(543)

//____________________________________________________________________________
// assignValueI1

template <typename T1, typename T2, typename TSpec, typename T> inline void assignValueI1(Pair<T1, T2, TSpec> &pair, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(677)
template <typename T1, typename T2, typename T3, typename TSpec, typename T> inline T const assignValueI1(Triple<T1, T2, T3, TSpec> &triple, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(689)

//____________________________________________________________________________
// assignValueI2

template <typename T1, typename T2, typename TSpec, typename T> inline void assignValueI2(Pair<T1, T2, TSpec> &pair, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(682)
template <typename T1, typename T2, typename T3, typename TSpec, typename T> inline T const assignValueI2(Triple<T1, T2, T3, TSpec> &triple, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(694)

//____________________________________________________________________________
// assignValueI3

template <typename T1, typename T2, typename T3, typename TSpec, typename T> inline T const assignValueI3(Triple<T1, T2, T3, TSpec> &triple, T const &_i);       	// "projects/library/seqan/basic/basic_aggregates.h"(699)

//____________________________________________________________________________
// atBegin

template <typename T, typename TContainer> inline bool atBegin(T const & it, TContainer const & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(418)
template <typename T, typename TContainer> inline bool atBegin(T const & it, TContainer & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(426)
template <typename T, typename TContainer> inline bool atBegin(T & it, TContainer & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(434)
template <typename T, typename TContainer> inline bool atBegin(T & it, TContainer const & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(442)
template <typename T> inline bool atBegin(T const & it);       	// "projects/library/seqan/basic/basic_iterator.h"(451)

//____________________________________________________________________________
// atEnd

template <typename TContainer, typename TIterator, typename TSpec> inline bool atEnd(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(556)
template <typename TContainer, typename TIterator, typename TSpec> inline bool atEnd(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(564)
template <typename T, typename TContainer> inline bool atEnd(T & it, TContainer const & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(483)
template <typename T, typename TContainer> inline bool atEnd(T const & it, TContainer const & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(491)
template <typename T, typename TContainer> inline bool atEnd(T & it, TContainer & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(500)
template <typename T, typename TContainer> inline bool atEnd(T const & it, TContainer & cont);       	// "projects/library/seqan/basic/basic_iterator.h"(508)
template <typename T> inline bool atEnd(T & it);       	// "projects/library/seqan/basic/basic_iterator.h"(517)
template <typename T> inline bool atEnd(T const & it);       	// "projects/library/seqan/basic/basic_iterator.h"(524)

//____________________________________________________________________________
// atNil

template <typename TIterator> inline bool atNil(TIterator & me);       	// "projects/library/seqan/basic/basic_iterator.h"(787)
template <typename TIterator> inline bool atNil(TIterator * me);       	// "projects/library/seqan/basic/basic_iterator.h"(796)

//____________________________________________________________________________
// clear

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator> void clear(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(170)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator> void clear(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(302)
template <size_t SIZE, typename TParentAllocator> void clear(Allocator<SinglePool<SIZE, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(159)
template <typename TValue, typename TParentAllocator> void clear(Allocator<SinglePool2<TValue, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(279)
inline void clear(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(122)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT> void clear(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(138)
template <typename T_, unsigned _size, typename TSpec> inline void clear(Tuple<T_, _size, TSpec> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(554)
template <typename T_, unsigned _size> inline void clear(Tuple<T_, _size, Compressed> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(558)
template <typename TValue> inline void clear(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(623)
template <typename TValue> inline void clear(Holder<TValue, Simple> & );       	// "projects/library/seqan/basic/basic_holder.h"(1204)
template <typename TValue> inline void clear(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1422)
template <typename TParentAllocator> void clear(Allocator<SimpleAlloc<TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(140)

//____________________________________________________________________________
// clearHost

template <typename T> inline void clearHost(T & me);       	// "projects/library/seqan/basic/basic_host.h"(71)

//____________________________________________________________________________
// const

template <typename TValue, size_t I> inline void setValue(Holder<TValue *, Tristate> & me, TValue const (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(933)
template <typename TValue, size_t I> inline void setValue(Holder<TValue * const, Tristate> & me, TValue const (& value_)[I]);       	// "projects/library/seqan/basic/basic_holder.h"(955)

//____________________________________________________________________________
// container

template <typename TContainer, typename TIterator, typename TSpec> inline typename Parameter_<TContainer>::Type container(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(182)
template <typename TContainer, typename TIterator, typename TSpec> inline typename Parameter_<TContainer>::Type container(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(189)
template <typename T> inline typename Container<T>::Type & container(T me);       	// "projects/library/seqan/basic/basic_iterator.h"(350)
template <typename TContainer> inline typename Parameter_<TContainer>::Type container(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(130)
template <typename TContainer> inline typename Parameter_<TContainer>::Type container(Iter<TContainer, PositionIterator> const & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(137)

//____________________________________________________________________________
// convert

template <typename TTarget, typename TSource> inline typename Convert<TTarget, TSource>::Type convert(TSource const & source);       	// "projects/library/seqan/basic/basic_converter.h"(121)

//____________________________________________________________________________
// convertImpl

template <typename TTarget, typename T, typename TSpec> inline typename Convert<TTarget, Proxy<TSpec> >::Type convertImpl(Convert<TTarget, T> const, Proxy<TSpec> & source);       	// "projects/library/seqan/basic/basic_proxy.h"(290)
template <typename TTarget, typename T, typename TSpec> inline typename Convert<TTarget, Proxy<TSpec> const>::Type convertImpl(Convert<TTarget, T> const, Proxy<TSpec> const & source);       	// "projects/library/seqan/basic/basic_proxy.h"(297)
template <typename TTarget, typename T, typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline typename Convert<TTarget, ProfileType<TSourceValue, TSourceCount, TSourceSpec> >::Type convertImpl(Convert<TTarget, T> const, ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(193)
template <typename TTarget, typename T, typename TSource> inline typename Convert<TTarget, TSource>::Type convertImpl(Convert<TTarget, T> const, TSource const & source);       	// "projects/library/seqan/basic/basic_converter.h"(95)
template <typename TTarget, typename T, typename TSourceValue, typename TSourceSpec> inline typename RemoveConst_<TTarget>::Type convertImpl(Convert<TTarget, T> const, SimpleType<TSourceValue, TSourceSpec> const & source_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(276)

//____________________________________________________________________________
// convertQuality

inline void convertQuality(Ascii & c, int q);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2269)

//____________________________________________________________________________
// create

template <typename TValue> inline TValue & create(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(146)
template <typename TValue> inline void create(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(671)
template <typename TValue> inline void create(Holder<TValue *, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(699)
template <typename TValue> inline void create(Holder<TValue * const, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(725)
template <typename TValue, typename TValue2> inline void create(Holder<TValue, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(754)
template <typename TValue, typename TValue2> inline void create(Holder<TValue const, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(772)
template <typename TValue, typename TValue2> inline void create(Holder<TValue *, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(784)
template <typename TValue, typename TValue2> inline void create(Holder<TValue * const, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(796)
template <typename TValue> inline void create(Holder<TValue, Simple> & );       	// "projects/library/seqan/basic/basic_holder.h"(1213)
template <typename TValue> inline void create(Holder<TValue, Simple> & me, TValue const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1223)
template <typename TValue> inline void create(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1452)
template <typename TValue> inline void create(Holder<TValue, Tristate2> & me, TValue const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1485)

//____________________________________________________________________________
// createHost

template <typename T> inline void createHost(T & me);       	// "projects/library/seqan/basic/basic_host.h"(81)
template <typename T, typename THost> inline void createHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(92)
template <typename T, typename THost> inline void createHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(100)

//____________________________________________________________________________
// deallocate

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me, TValue * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(235)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void deallocate(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me, TValue2 * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(326)
template <size_t SIZE, typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<SinglePool<SIZE, TParentAllocator> > & me, TValue * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(215)
template <typename TValue, typename TParentAllocator, typename TValue2, typename TSize, typename TUsage> inline void deallocate(Allocator<SinglePool2<TValue, TParentAllocator> > & me, TValue2 * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(303)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me, TValue * data, TSize count, Tag<TUsage> const tag_);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(220)
template <typename T, typename TValue, typename TSize> inline void deallocate(T const & me, TValue * data, TSize const count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(243)
template <typename T, typename TValue, typename TSize> inline void deallocate(T & me, TValue * data, TSize const count);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(251)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void deallocate( T const & , TValue * data, TSize count, TSize, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(266)
template <typename T, typename TValue, typename TSize, typename TUsage> inline void deallocate( T & , TValue * data, TSize count, TSize, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_interface.h"(290)
template <typename TParentAllocator, typename TValue, typename TSize, typename TUsage> inline void deallocate(Allocator<SimpleAlloc<TParentAllocator> > & me, TValue * data, TSize, Tag<TUsage> const);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(195)

//____________________________________________________________________________
// dependent

template <typename TValue> inline bool dependent(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(534)
template <typename TValue> inline bool dependent(Holder<TValue, Simple> const & );       	// "projects/library/seqan/basic/basic_holder.h"(1194)
template <typename TValue> inline bool dependent(Holder<TValue, Tristate2> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1408)

//____________________________________________________________________________
// dependentHost

template <typename T> inline bool dependentHost(T const & me);       	// "projects/library/seqan/basic/basic_host.h"(61)

//____________________________________________________________________________
// destroy

template <typename TValue> inline void destroy(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(158)

//____________________________________________________________________________
// detach

template <typename TValue> inline void detach(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(826)
template <typename TValue> inline void detach(Holder<TValue, Simple> & );       	// "projects/library/seqan/basic/basic_holder.h"(1233)
template <typename TValue> inline void detach(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1506)

//____________________________________________________________________________
// difference

template <typename TIterator> inline typename Difference<TIterator>::Type difference( TIterator const & begin, TIterator const & end);       	// "projects/library/seqan/basic/basic_iterator.h"(728)

//____________________________________________________________________________
// empty

inline bool empty(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(109)
inline bool empty(VoidHolder const & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(114)
template <typename TSourceValue, typename TSourceCount, typename TSourceSpec> inline bool empty(ProfileType<TSourceValue, TSourceCount, TSourceSpec> const & source);       	// "projects/library/seqan/basic/basic_profchar.h"(148)
template <typename TValue> inline bool empty(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(522)
template <typename TValue> inline bool empty(Holder<TValue, Simple> const & );       	// "projects/library/seqan/basic/basic_holder.h"(1184)
template <typename TValue> inline bool empty(Holder<TValue, Tristate2> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1396)

//____________________________________________________________________________
// emptyHost

template <typename T> inline bool emptyHost(T const & me);       	// "projects/library/seqan/basic/basic_host.h"(51)

//____________________________________________________________________________
// gapValue

template <typename T> inline T gapValue();       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(104)

//____________________________________________________________________________
// gapValueImpl

template <typename T> inline T const & gapValueImpl(T *);       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(63)
inline char const & gapValueImpl(char *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(424)
inline char const & gapValueImpl(char const *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(431)

//____________________________________________________________________________
// getQualityValue

inline int getQualityValue(DnaQ const &c);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2237)
inline int getQualityValue(Dna5Q const &c);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(2242)

//____________________________________________________________________________
// getValue

template <typename TValue> inline TValue & getValue(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(184)
template <typename TValue> inline TValue const & getValue(VoidHolder const & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(190)
template <typename TSpec> typename GetValue<Proxy<TSpec> >::Type getValue(Proxy<TSpec> & me);       	// "projects/library/seqan/basic/basic_proxy.h"(164)
template <typename TSpec> typename GetValue<Proxy<TSpec> const>::Type getValue(Proxy<TSpec> const & me);       	// "projects/library/seqan/basic/basic_proxy.h"(170)
template <typename T> inline typename GetValue<T>::Type getValue(T & me);       	// "projects/library/seqan/basic/basic_iterator.h"(229)
template <typename T> inline typename GetValue<T const>::Type getValue(T const & me);       	// "projects/library/seqan/basic/basic_iterator.h"(236)
template <typename T> inline T & getValue(T * me);       	// "projects/library/seqan/basic/basic_iterator.h"(244)

//____________________________________________________________________________
// getValueI1

template <typename T1, typename T2, typename TSpec> inline T1 getValueI1(Pair<T1, T2, TSpec> const &pair);       	// "projects/library/seqan/basic/basic_aggregates.h"(647)
template <typename T1, typename T2, typename T3, typename TSpec> inline T1 getValueI1(Triple<T1, T2, T3, TSpec> const &triple);       	// "projects/library/seqan/basic/basic_aggregates.h"(659)

//____________________________________________________________________________
// getValueI2

template <typename T1, typename T2, typename TSpec> inline T2 getValueI2(Pair<T1, T2, TSpec> const &pair);       	// "projects/library/seqan/basic/basic_aggregates.h"(652)
template <typename T1, typename T2, typename T3, typename TSpec> inline T2 getValueI2(Triple<T1, T2, T3, TSpec> const &triple);       	// "projects/library/seqan/basic/basic_aggregates.h"(664)

//____________________________________________________________________________
// getValueI3

template <typename T1, typename T2, typename T3, typename TSpec> inline T3 getValueI3(Triple<T1, T2, T3, TSpec> const &triple);       	// "projects/library/seqan/basic/basic_aggregates.h"(669)

//____________________________________________________________________________
// goBegin

template <typename TIterator, typename TContainer> inline void goBegin(TIterator & it, TContainer & container);       	// "projects/library/seqan/basic/basic_iterator.h"(554)
template <typename TIterator> inline void goBegin(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(572)

//____________________________________________________________________________
// goEnd

template <typename TIterator, typename TContainer> inline void goEnd(TIterator & it, TContainer & container);       	// "projects/library/seqan/basic/basic_iterator.h"(603)
template <typename TIterator, typename TContainer> inline void goEnd(TIterator & it, TContainer const & container);       	// "projects/library/seqan/basic/basic_iterator.h"(611)
template <typename TIterator> inline void goEnd(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(619)

//____________________________________________________________________________
// goFurther

template <typename TIterator, typename TDiff> inline void goFurther(TIterator & it, TDiff steps);       	// "projects/library/seqan/basic/basic_iterator.h"(671)

//____________________________________________________________________________
// goNext

template <typename TContainer, typename TIterator, typename TSpec> inline void goNext(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(410)
template <typename TContainer> inline void goNext(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(293)
template <typename TIterator> inline void goNext(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(644)
template <typename TContainer> inline void goNext(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(324)

//____________________________________________________________________________
// goNil

template <typename TIterator> inline void goNil(TIterator & me);       	// "projects/library/seqan/basic/basic_iterator.h"(753)
template <typename TIterator> inline void goNil(TIterator * & me);       	// "projects/library/seqan/basic/basic_iterator.h"(761)

//____________________________________________________________________________
// goPrevious

template <typename TContainer, typename TIterator, typename TSpec> inline void goPrevious(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(422)
template <typename TContainer> inline void goPrevious(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(305)
template <typename TIterator> inline void goPrevious(TIterator & it);       	// "projects/library/seqan/basic/basic_iterator.h"(696)
template <typename TContainer> inline void goPrevious(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(336)

//____________________________________________________________________________
// host

template <typename T> inline typename Host<T>::Type & host(T & me);       	// "projects/library/seqan/basic/basic_host.h"(129)
template <typename T> inline typename Host<T const>::Type & host(T const & me);       	// "projects/library/seqan/basic/basic_host.h"(136)
template <typename THost, typename TValue> THost & host(ToStdAllocator<THost, TValue> & me);       	// "projects/library/seqan/basic/basic_allocator_to_std.h"(166)

//____________________________________________________________________________
// hostIterator

template <typename TContainer, typename TIterator, typename TSpec> inline TIterator & hostIterator(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(218)
template <typename TContainer, typename TIterator, typename TSpec> inline TIterator const & hostIterator(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(225)
template <typename TContainer> inline typename StdContainerIterator<TContainer>::Type & hostIterator(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(142)
template <typename TContainer> inline typename StdContainerIterator<TContainer>::Type const & hostIterator(Iter<TContainer, StdIteratorAdaptor> const & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(148)

//____________________________________________________________________________
// infimumValueImpl

template <typename T> inline T const & infimumValueImpl(T *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(466)
inline float const & infimumValueImpl(float *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(705)
inline double const & infimumValueImpl(double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(732)
inline long double const & infimumValueImpl(long double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(759)

//____________________________________________________________________________
// iter

template <typename TIterator> inline TIterator & iter(Proxy<IteratorProxy<TIterator> > & me);       	// "projects/library/seqan/basic/basic_proxy.h"(260)
template <typename TIterator> inline TIterator const & iter(Proxy<IteratorProxy<TIterator> > const & me);       	// "projects/library/seqan/basic/basic_proxy.h"(266)

//____________________________________________________________________________
// length

template <typename T_, unsigned _size, typename TSpec> inline unsigned length(Tuple<T_, _size, TSpec> const &);       	// "projects/library/seqan/basic/basic_aggregates.h"(503)

//____________________________________________________________________________
// lexLess

template <typename T_> inline bool lexLess(const T_& _Left, const T_& Right_);       	// "projects/library/seqan/basic/basic_compare.h"(66)
template <typename T_, typename TSpec> inline bool lexLess(SimpleType<T_, TSpec> const &_Left, SimpleType<T_, TSpec> const &Right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1013)

//____________________________________________________________________________
// log2

template <typename T> inline unsigned int log2(T val);       	// "projects/library/seqan/basic/basic_definition.h"(345)

//____________________________________________________________________________
// maxValue

template <typename T> inline T const & maxValue();       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(166)
template <typename T> inline T const & maxValue(T);       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(175)

//____________________________________________________________________________
// memset

template <unsigned SIZE> finline void memset(void* ptr, unsigned char c);       	// "projects/library/seqan/basic/basic_metaprogramming.h"(309)
template <unsigned SIZE, unsigned char c> finline void memset(void* ptr);       	// "projects/library/seqan/basic/basic_metaprogramming.h"(355)

//____________________________________________________________________________
// minValue

template <typename T> inline T const & minValue();       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(228)
template <typename T> inline T const & minValue(T);       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(237)

//____________________________________________________________________________
// move

template <typename TTarget, typename TSource> inline void move(TTarget & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(122)
template <typename TTarget, typename TSource> inline void move(TTarget const & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(130)
template <typename TTarget, typename TSource> inline void move(TTarget & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(138)
template <typename TTarget, typename TSource> inline void move(TTarget const & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(146)

//____________________________________________________________________________
// moveHost

template <typename T, typename THost> inline void moveHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(165)
template <typename T, typename THost> inline void moveHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(173)

//____________________________________________________________________________
// moveValue

template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(328)
template <typename TContainer, typename TIterator, typename TSpec, typename TValue> inline void moveValue(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(336)
template <typename TValue, typename TSource> inline void moveValue(Holder<TValue, Tristate> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1041)
template <typename TValue, typename TSource> inline void moveValue(Holder<TValue, Simple> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1282)
template <typename TValue, typename TSource> inline void moveValue(Holder<TValue, Tristate2> & me, TSource const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1588)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(197)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, StdIteratorAdaptor> & me, TValue const & val);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(204)
template <typename T, typename TValue> inline void moveValue(T & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(318)
template <typename T, typename TValue> inline void moveValue(T const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator.h"(327)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, PositionIterator> & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(234)
template <typename TContainer, typename TValue> inline void moveValue(Iter<TContainer, PositionIterator> const & me, TValue const & _value);       	// "projects/library/seqan/basic/basic_iterator_position.h"(242)

//____________________________________________________________________________
// nukeCopies

template <typename TValue> inline void nukeCopies(TValue* &);       	// "projects/library/seqan/basic/basic_volatile_ptr.h"(164)
template <typename TValue> inline void nukeCopies(VolatilePtr<TValue> &ptr);       	// "projects/library/seqan/basic/basic_volatile_ptr.h"(167)

//____________________________________________________________________________
// operator!=

template <typename TContainer, typename TIterator, typename TSpec> inline bool operator!= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(380)
template <typename TContainer, typename TIterator, typename TSpec> inline bool operator!= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, typename IterComplementConst<TIterator>::Type const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(389)
template <typename TContainer, typename TIterator, typename TSpec> inline bool operator!= (typename IterComplementConst<TIterator>::Type const & left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(398)
template <typename TSpec, typename TRight> inline bool operator!= (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(354)
template <typename TLeft, typename TSpec> inline bool operator!= (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(365)
template <typename TLeftSpec, typename TRightSpec> inline bool operator!= (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(376)
template <typename TSpec> inline bool operator!= (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(388)
template <typename T_, unsigned _sizeL, unsigned _sizeR> inline bool operator!=(Tuple<T_, _sizeL, Compressed> const &_left, Tuple<T_, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(578)
template <typename L1, typename L2, typename LCompression, typename R1, typename R2, typename RCompression> inline bool operator!=(Pair<L1, L2, LCompression> const &_left, Pair<R1, R2, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(711)
template <typename L1, typename L2, typename L3, typename LCompression, typename R1, typename R2, typename R3, typename RCompression> inline bool operator!=(Triple<L1, L2, L3, LCompression> const &_left, Triple<R1, R2, R3, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(726)
template <typename TValue, typename TSpec, typename TRight> inline bool operator!= (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(659)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator!= (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(670)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator!= (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(681)
template <typename TValue, typename TSpec> inline bool operator!= (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(693)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator!= (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(703)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator!= (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(714)
template <typename TContainer> inline bool operator!= (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(229)
template <typename TContainer> inline bool operator!= (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(268)

//____________________________________________________________________________
// operator*

template <typename TContainer, typename TSpec> inline typename Reference<Iter<TContainer, TSpec> >::Type operator* (Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(205)
template <typename TContainer, typename TSpec> inline typename Reference<Iter<TContainer, TSpec> const>::Type operator* (Iter<TContainer, TSpec> const & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(212)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename TSpec, typename TSize> inline Iter<TContainer, TSpec> operator+ (Iter<TContainer, TSpec> const & me, TSize size);       	// "projects/library/seqan/basic/basic_iterator_base.h"(280)
template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(435)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(444)
template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (TIntegral left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(453)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator+ (int left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(462)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> operator+ (Iter<TContainer, StdIteratorAdaptor> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(318)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> operator+ (Iter<TContainer, StdIteratorAdaptor> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(327)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> operator+ (TIntegral left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(336)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> operator+ (int left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(345)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> operator+ (Iter<TContainer, PositionIterator> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(348)
template <typename TContainer> inline Iter<TContainer, PositionIterator> operator+ (Iter<TContainer, PositionIterator> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(357)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> operator+ (TIntegral left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(366)
template <typename TContainer> inline Iter<TContainer, PositionIterator> operator+ (int left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(375)

//____________________________________________________________________________
// operator++

template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> const & operator++ (Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(224)
template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> operator++ (Iter<TContainer, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_iterator_base.h"(233)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> & operator++ (SimpleType<TValue, TSpec> & me);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1023)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> operator++ (SimpleType<TValue, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1031)

//____________________________________________________________________________
// operator+=

template <typename TContainer, typename TSpec, typename TSize> inline Iter<TContainer, TSpec> const & operator+= (Iter<TContainer, TSpec> & me, TSize size);       	// "projects/library/seqan/basic/basic_iterator_base.h"(290)
template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator+= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(475)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator+= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(485)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> & operator+= (Iter<TContainer, StdIteratorAdaptor> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(358)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> & operator+= (Iter<TContainer, StdIteratorAdaptor> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(368)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> & operator+= (Iter<TContainer, PositionIterator> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(388)
template <typename TContainer> inline Iter<TContainer, PositionIterator> & operator+= (Iter<TContainer, PositionIterator> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(398)

//____________________________________________________________________________
// operator-

template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator- (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(499)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > operator- (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(508)
template <typename TContainer, typename TIterator, typename TSpec, typename TContainer2, typename TIterator2, typename TSpec2> inline typename Difference<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > >::Type operator- (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, Iter<TContainer2, AdaptorIterator<TIterator2, TSpec2> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(519)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> operator- (Iter<TContainer, StdIteratorAdaptor> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(382)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> operator- (Iter<TContainer, StdIteratorAdaptor> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(391)
template <typename TContainer> inline typename Difference<Iter<TContainer, StdIteratorAdaptor> >::Type operator- (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(402)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> operator- (Iter<TContainer, PositionIterator> const & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(412)
template <typename TContainer> inline Iter<TContainer, PositionIterator> operator- (Iter<TContainer, PositionIterator> const & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(421)
template <typename TContainer> inline typename Difference<TContainer>::Type operator- (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(432)

//____________________________________________________________________________
// operator--

template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> const & operator-- (Iter<TContainer, TSpec> & me);       	// "projects/library/seqan/basic/basic_iterator_base.h"(247)
template <typename TContainer, typename TSpec> inline Iter<TContainer, TSpec> operator-- (Iter<TContainer, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_iterator_base.h"(256)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> & operator-- (SimpleType<TValue, TSpec> & me);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1042)
template <typename TValue, typename TSpec> inline SimpleType<TValue, TSpec> operator-- (SimpleType<TValue, TSpec> & me, int);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(1050)

//____________________________________________________________________________
// operator-=

template <typename TContainer, typename TIterator, typename TSpec, typename TIntegral> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator-= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(532)
template <typename TContainer, typename TIterator, typename TSpec> inline Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & operator-= (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(542)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, StdIteratorAdaptor> & operator-= (Iter<TContainer, StdIteratorAdaptor> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(415)
template <typename TContainer> inline Iter<TContainer, StdIteratorAdaptor> & operator-= (Iter<TContainer, StdIteratorAdaptor> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(425)
template <typename TContainer, typename TIntegral> inline Iter<TContainer, PositionIterator> & operator-= (Iter<TContainer, PositionIterator> & left, TIntegral right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(445)
template <typename TContainer> inline Iter<TContainer, PositionIterator> & operator-= (Iter<TContainer, PositionIterator> & left, int right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(455)

//____________________________________________________________________________
// operator<

template <typename TSpec, typename TRight> inline bool operator< (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(402)
template <typename TLeft, typename TSpec> inline bool operator< (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(413)
template <typename TLeftSpec, typename TRightSpec> inline bool operator< (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(424)
template <typename TSpec> inline bool operator< (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(436)
template <typename T_, unsigned _sizeL, unsigned _sizeR> inline bool operator<(Tuple<T_, _sizeL, Compressed> const &_left, Tuple<T_, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(566)
template <typename TValue, typename TSpec, typename TRight> inline bool operator< (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(730)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator< (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(741)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator< (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(752)
template <typename TValue, typename TSpec> inline bool operator< (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(764)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator< (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(774)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator< (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(785)
template <typename TContainer> inline bool operator< (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(242)
template <typename TContainer> inline bool operator< (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(281)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & strm, Proxy<TSpec> & proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(617)
template <typename TStream, typename TSpec> inline TStream & operator<< (TStream & strm, Proxy<TSpec> const & proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(624)
template <typename TStream, typename TValue, typename TSpec> TStream& operator<<(TStream& os, LogProb<TValue, TSpec> const& rhs);       	// "projects/library/seqan/basic/basic_logvalue.h"(323)
template <typename TStream, typename TValue, typename TCount, typename TSpec> inline TStream& operator<<(TStream& os, ProfileType<TValue, TCount, TSpec> const& rhs);       	// "projects/library/seqan/basic/basic_profchar.h"(201)
template <typename T1_, typename T2_, typename TSpec> std::ostream& operator<<(std::ostream &out, Pair<T1_,T2_,TSpec> const &p);       	// "projects/library/seqan/basic/basic_aggregates.h"(170)
template <typename T1_, typename T2_, typename T3_, typename TSpec> std::ostream& operator<<(std::ostream &out, Triple<T1_,T2_,T3_,TSpec> const &t);       	// "projects/library/seqan/basic/basic_aggregates.h"(327)
template <typename T_, unsigned _size, typename TSpec> std::ostream& operator<<(std::ostream& out, Tuple<T_,_size,TSpec> const &a);       	// "projects/library/seqan/basic/basic_aggregates.h"(623)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator<< (TStream & stream, SimpleType<TValue, TSpec> const & data);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(291)

//____________________________________________________________________________
// operator<=

template <typename TSpec, typename TRight> inline bool operator<= (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(449)
template <typename TLeft, typename TSpec> inline bool operator<= (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(460)
template <typename TLeftSpec, typename TRightSpec> inline bool operator<= (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(471)
template <typename TSpec> inline bool operator<= (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(483)
template <typename TValue, typename TSpec, typename TRight> inline bool operator<= (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(801)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator<= (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(812)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator<= (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(823)
template <typename TValue, typename TSpec> inline bool operator<= (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(835)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator<= (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(845)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator<= (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(856)
template <typename TContainer> inline bool operator<= (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(268)
template <typename TContainer> inline bool operator<= (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(303)

//____________________________________________________________________________
// operator==

template <typename TContainer, typename TIterator, typename TSpec> inline bool operator== (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(349)
template <typename TContainer, typename TIterator, typename TSpec> inline bool operator== (Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & left, typename IterComplementConst<TIterator>::Type const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(358)
template <typename TContainer, typename TIterator, typename TSpec> inline bool operator== (typename IterComplementConst<TIterator>::Type const & left, Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & right);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(367)
template <typename TSpec, typename TRight> inline bool operator== (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(307)
template <typename TLeft, typename TSpec> inline bool operator== (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(318)
template <typename TLeftSpec, typename TRightSpec> inline bool operator== (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(329)
template <typename TSpec> inline bool operator== (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(341)
template <typename T_, unsigned _sizeL, unsigned _sizeR> inline bool operator==(Tuple<T_, _sizeL, Compressed> const &_left, Tuple<T_, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(574)
template <typename L1, typename L2, typename LCompression, typename R1, typename R2, typename RCompression> inline bool operator==(Pair<L1, L2, LCompression> const &_left, Pair<R1, R2, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(707)
template <typename L1, typename L2, typename L3, typename LCompression, typename R1, typename R2, typename R3, typename RCompression> inline bool operator==(Triple<L1, L2, L3, LCompression> const &_left, Triple<R1, R2, R3, RCompression> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(720)
template <typename TValue, typename TSpec, typename TRight> inline bool operator== (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(588)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator== (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(599)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator== (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(610)
template <typename TValue, typename TSpec> inline bool operator== (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(622)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator== (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(632)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator== (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(643)
template <typename TContainer> inline bool operator== (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(216)
template <typename TContainer> inline bool operator== (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(255)

//____________________________________________________________________________
// operator>

template <typename TSpec, typename TRight> inline bool operator> (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(497)
template <typename TLeft, typename TSpec> inline bool operator> (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(508)
template <typename TLeftSpec, typename TRightSpec> inline bool operator> (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(519)
template <typename TSpec> inline bool operator> (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(531)
template <typename T_, unsigned _sizeL, unsigned _sizeR> inline bool operator>(Tuple<T_, _sizeL, Compressed> const &_left, Tuple<T_, _sizeR, Compressed> const &_right);       	// "projects/library/seqan/basic/basic_aggregates.h"(570)
template <typename TValue, typename TSpec, typename TRight> inline bool operator> (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(873)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator> (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(884)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator> (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(895)
template <typename TValue, typename TSpec> inline bool operator> (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(907)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator> (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(917)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator> (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(928)
template <typename TContainer> inline bool operator> (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(255)
template <typename TContainer> inline bool operator> (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(290)

//____________________________________________________________________________
// operator>=

template <typename TSpec, typename TRight> inline bool operator>= (Proxy<TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(545)
template <typename TLeft, typename TSpec> inline bool operator>= (TLeft const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(556)
template <typename TLeftSpec, typename TRightSpec> inline bool operator>= (Proxy<TLeftSpec> const & left_, Proxy<TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(567)
template <typename TSpec> inline bool operator>= (Proxy<TSpec> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_proxy.h"(579)
template <typename TValue, typename TSpec, typename TRight> inline bool operator>= (SimpleType<TValue, TSpec> const & left_, TRight const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(944)
template <typename TLeft, typename TValue, typename TSpec> inline bool operator>= (TLeft const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(955)
template <typename TLeftValue, typename TLeftSpec, typename TRightValue, typename TRightSpec> inline bool operator>= (SimpleType<TLeftValue, TLeftSpec> const & left_, SimpleType<TRightValue, TRightSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(966)
template <typename TValue, typename TSpec> inline bool operator>= (SimpleType<TValue, TSpec> const & left_, SimpleType<TValue, TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(978)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator>= (Proxy<TSpec> const & left_, SimpleType<TValue, TSpec2> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(988)
template <typename TSpec, typename TValue, typename TSpec2> inline bool operator>= (SimpleType<TValue, TSpec2> const & left_, Proxy<TSpec> const & right_);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(999)
template <typename TContainer> inline bool operator>= (Iter<TContainer, StdIteratorAdaptor> const & left, Iter<TContainer, StdIteratorAdaptor> const & right);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(281)
template <typename TContainer> inline bool operator>= (Iter<TContainer, PositionIterator> const & left, Iter<TContainer, PositionIterator> const & right);       	// "projects/library/seqan/basic/basic_iterator_position.h"(312)

//____________________________________________________________________________
// operator>>

template <typename TStream, typename TSpec> inline TStream & operator>> (TStream & strm, Proxy<TSpec> & proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(591)
template <typename TStream, typename TSpec> inline TStream & operator>> (TStream & strm, Proxy<TSpec> const& proxy);       	// "projects/library/seqan/basic/basic_proxy.h"(603)
template <typename TStream, typename TValue, typename TSpec> inline TStream & operator>> (TStream & stream, SimpleType<TValue, TSpec> & data);       	// "projects/library/seqan/basic/basic_alphabet_simple.h"(303)

//____________________________________________________________________________
// parentAllocator

template <size_t SIZE, size_t MAX_COUNT, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<ChunkPool<SIZE, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(160)
template <typename TValue, size_t MAX_COUNT, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<ChunkPool2<TValue, MAX_COUNT, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_chunkpool.h"(292)
template <size_t SIZE, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<SinglePool<SIZE, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(149)
template <typename TValue, typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<SinglePool2<TValue, TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_singlepool.h"(269)
template <typename TParentAllocator, unsigned int BLOCKING_LIMIT> inline TParentAllocator & parentAllocator(Allocator<MultiPool<TParentAllocator, BLOCKING_LIMIT> > & me);       	// "projects/library/seqan/basic/basic_allocator_multipool.h"(128)
template <typename TParentAllocator> inline TParentAllocator & parentAllocator(Allocator<SimpleAlloc<TParentAllocator> > & me);       	// "projects/library/seqan/basic/basic_allocator_simple.h"(116)

//____________________________________________________________________________
// position

template <typename TContainer, typename TSpec, typename TContainer2> inline typename Position<Iter<TContainer, TSpec> const>::Type position(Iter<TContainer, TSpec> const & me, TContainer2 const &);       	// "projects/library/seqan/basic/basic_iterator_base.h"(339)
template <typename TContainer, typename TIterator, typename TSpec> inline typename Position<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(251)
template <typename TContainer, typename TIterator, typename TSpec, typename TContainer2> inline typename Position<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const>::Type position(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me, TContainer2 const &);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(262)
template <typename TContainer, typename TContainer2> inline typename Position<Iter<TContainer, SimpleIterator> const>::Type position(Iter<TContainer, SimpleIterator> const & me, TContainer2 const & cont);       	// "projects/library/seqan/basic/basic_iterator_simple.h"(121)
template <typename T> inline typename Position<T>::Type position(T * );       	// "projects/library/seqan/basic/basic_iterator.h"(377)
template <typename TContainer, typename TIterator> inline typename Position<TContainer>::Type position(TIterator const & it, TContainer const & me);       	// "projects/library/seqan/basic/basic_iterator.h"(386)
template <typename TContainer> inline typename Position<TContainer>::Type & position(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(159)
template <typename TContainer> inline typename Position<TContainer>::Type const & position(Iter<TContainer, PositionIterator> const & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(166)

//____________________________________________________________________________
// resize

template <typename TSize> inline void resize(VoidHolder & me, TSize length);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(132)

//____________________________________________________________________________
// set

template <typename TTarget, typename TSource> inline void set(TTarget & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(175)
template <typename TTarget, typename TSource> inline void set(TTarget const & target, TSource & source);       	// "projects/library/seqan/basic/basic_transport.h"(183)
template <typename TTarget, typename TSource> inline void set(TTarget & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(191)
template <typename TTarget, typename TSource> inline void set(TTarget const & target, TSource const & source);       	// "projects/library/seqan/basic/basic_transport.h"(199)

//____________________________________________________________________________
// setContainer

template <typename TContainer, typename TIterator, typename TSpec> inline void setContainer(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, typename Parameter_<TContainer>::Type container_);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(198)
template <typename TContainer> inline void setContainer(Iter<TContainer, PositionIterator> & me, typename Parameter_<TContainer>::Type container_);       	// "projects/library/seqan/basic/basic_iterator_position.h"(146)

//____________________________________________________________________________
// setHost

template <typename T, typename THost> inline void setHost(T & me, THost & host_);       	// "projects/library/seqan/basic/basic_host.h"(111)
template <typename T, typename THost> inline void setHost(T & me, THost const & host_);       	// "projects/library/seqan/basic/basic_host.h"(119)

//____________________________________________________________________________
// setPosition

template <typename TContainer, typename TIterator, typename TSpec, typename TPosition> inline void setPosition(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me, TPosition pos_);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(275)
template <typename TContainer, typename TPosition> inline void setPosition(Iter<TContainer, PositionIterator> & me, TPosition position_);       	// "projects/library/seqan/basic/basic_iterator_position.h"(175)

//____________________________________________________________________________
// setValue

template <typename TValue> inline void setValue(Holder<TValue, Tristate> & me, TValue & value_);       	// "projects/library/seqan/basic/basic_holder.h"(850)
template <typename TValue> inline void setValue(Holder<TValue const, Tristate> & me, TValue & value_);       	// "projects/library/seqan/basic/basic_holder.h"(863)
template <typename TValue> inline void setValue(Holder<TValue *, Tristate> & me, TValue * & value_);       	// "projects/library/seqan/basic/basic_holder.h"(876)
template <typename TValue> inline void setValue(Holder<TValue *, Tristate> & me, TValue * const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(887)
template <typename TValue> inline void setValue(Holder<TValue * const, Tristate> & me, TValue * & value_);       	// "projects/library/seqan/basic/basic_holder.h"(898)
template <typename TValue> inline void setValue(Holder<TValue * const, Tristate> & me, TValue * const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(909)
template <typename TValue, typename TValue2> inline void setValue(Holder<TValue, Tristate> & me, TValue2 & value_);       	// "projects/library/seqan/basic/basic_holder.h"(968)
template <typename TValue, typename TValue2> inline void setValue(Holder<TValue, Tristate> & me, TValue2 const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(977)
template <typename TValue> inline void setValue(Holder<TValue, Simple> & me, TValue const & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1243)
template <typename TValue> inline void setValue(Holder<TValue, Tristate2> & me, TValue & value_);       	// "projects/library/seqan/basic/basic_holder.h"(1518)

//____________________________________________________________________________
// shiftLeft

template <typename T_, unsigned _size, typename TSpec> inline void shiftLeft(Tuple<T_, _size, TSpec> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(600)
template <typename T_, unsigned _size> inline void shiftLeft(Tuple<T_, _size, Compressed> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(610)

//____________________________________________________________________________
// shiftRight

template <typename T_, unsigned _size, typename TSpec> inline void shiftRight(Tuple<T_, _size, TSpec> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(605)
template <typename T_, unsigned _size> inline void shiftRight(Tuple<T_, _size, Compressed> &me);       	// "projects/library/seqan/basic/basic_aggregates.h"(615)

//____________________________________________________________________________
// supremumValueImpl

template <typename T> inline T const & supremumValueImpl(T *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(459)
inline float const & supremumValueImpl(float *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(694)
inline double const & supremumValueImpl(double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(721)
inline long double const & supremumValueImpl(long double *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(748)

//____________________________________________________________________________
// unknownValue

template <typename T> inline T unknownValue();       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(113)

//____________________________________________________________________________
// unknownValueImpl

template <typename T> inline T unknownValueImpl(T *);       	// "projects/library/seqan/basic/basic_alphabet_interface2.h"(72)
inline char const & unknownValueImpl(char *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(439)
inline char const & unknownValueImpl(char const *);       	// "projects/library/seqan/basic/basic_alphabet_trait_basic.h"(446)

//____________________________________________________________________________
// value

template <typename TContainer, typename TIterator, typename TSpec> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > >::Type value(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(287)
template <typename TContainer, typename TIterator, typename TSpec> inline typename Reference<Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const>::Type value(Iter<TContainer, AdaptorIterator<TIterator, TSpec> > const & me);       	// "projects/library/seqan/basic/basic_iterator_adaptor.h"(294)
template <typename TValue> inline TValue & value(VoidHolder & me);       	// "projects/library/seqan/basic/basic_holder_dynamic.h"(171)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate> >::Type value(Holder<TValue, Tristate> & me);       	// "projects/library/seqan/basic/basic_holder.h"(990)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate> const>::Type value(Holder<TValue, Tristate> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1005)
template <typename TValue> inline typename Reference<Holder<TValue, Simple> >::Type value(Holder<TValue, Simple> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1253)
template <typename TValue> inline typename Reference<Holder<TValue, Simple> const>::Type value(Holder<TValue, Simple> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1260)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate2> >::Type value(Holder<TValue, Tristate2> & me);       	// "projects/library/seqan/basic/basic_holder.h"(1534)
template <typename TValue> inline typename Reference<Holder<TValue, Tristate2> const>::Type value(Holder<TValue, Tristate2> const & me);       	// "projects/library/seqan/basic/basic_holder.h"(1551)
template <typename TContainer> inline typename Reference<Iter<TContainer, StdIteratorAdaptor> >::Type value(Iter<TContainer, StdIteratorAdaptor> & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(159)
template <typename TContainer> inline typename Reference<Iter<TContainer, StdIteratorAdaptor> const>::Type value(Iter<TContainer, StdIteratorAdaptor> const & me);       	// "projects/library/seqan/basic/basic_iterator_adapt_std.h"(165)
template <typename T> inline typename Reference<T>::Type value(T & me);       	// "projects/library/seqan/basic/basic_iterator.h"(189)
template <typename T> inline typename Reference<T const>::Type value(T const & me);       	// "projects/library/seqan/basic/basic_iterator.h"(196)
template <typename T> inline T & value(T * me);       	// "projects/library/seqan/basic/basic_iterator.h"(205)
template <typename TContainer> inline typename Reference<Iter<TContainer, PositionIterator> >::Type value(Iter<TContainer, PositionIterator> & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(187)
template <typename TContainer> inline typename Reference<Iter<TContainer, PositionIterator> >::Type value(Iter<TContainer, PositionIterator> const & me);       	// "projects/library/seqan/basic/basic_iterator_position.h"(194)

//____________________________________________________________________________
// valueConstruct

template <typename TIterator> inline void valueConstruct(TIterator it);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(171)
template <typename TIterator, typename TParam> inline void valueConstruct(TIterator it, TParam const & param_);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(191)
template <typename TIterator, typename TParam> inline void valueConstruct(TIterator it, TParam const & param_, Move tag);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(212)

//____________________________________________________________________________
// valueConstructMove

template <typename TIterator, typename TValue> inline void valueConstructMove(TIterator it, TValue const & value);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(276)

//____________________________________________________________________________
// valueDestruct

template <typename TIterator> inline void valueDestruct(TIterator it);       	// "projects/library/seqan/basic/basic_alphabet_interface.h"(243)

} //namespace SEQAN_NAMESPACE_MAIN

//____________________________________________________________________________
// _compareBinaryFiles

inline bool _compareBinaryFiles(const char * file1, const char * file2);       	// "projects/library/seqan/basic/basic_debug.h"(131)

//____________________________________________________________________________
// _compareTextFiles

inline bool _compareTextFiles(const char * file1, const char * file2);       	// "projects/library/seqan/basic/basic_debug.h"(197)

//____________________________________________________________________________
// _compareTextFilesReadChar

inline void _compareTextFilesReadChar(FILE * fl, char & c, int & num_lb, bool & is_eof);       	// "projects/library/seqan/basic/basic_debug.h"(165)

#endif

