// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_GRAPH_ALGORITHMS_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_GRAPH_ALGORITHMS_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// HeapTree

template <typename TValue , typename TPredicate , typename TSpec > class HeapTree;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(58)

//____________________________________________________________________________
// KeyedHeap

template <typename TSpec > struct KeyedHeap;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(48)

//____________________________________________________________________________
// KeylessHeap

template <typename TSpec > struct KeylessHeap;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(44)

//____________________________________________________________________________
// LessPairI1_

template <typename TWeight, typename TPair> struct LessPairI1_;       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(619)

//____________________________________________________________________________
// LessPairI2WithFunctor

template <typename TKey, typename TValue, typename TPredicate> struct LessPairI2WithFunctor;       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(341)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _backwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TBackwardMatrix> inline TProbability _backwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq, TBackwardMatrix& bMat);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(349)

//____________________________________________________________________________
// _baumWelchAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TSize> inline TProbability _baumWelchAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec > >& hmm, StringSet<TSequence> const& seqSet, TSize maxIter, TProbability epsilon);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(811)

//____________________________________________________________________________
// _buildResidualGraph

template <typename TSpec, typename TCapMap, typename TFlowMap, typename TResidualGraph> void _buildResidualGraph(Graph<TSpec> const& g, TCapMap const& capacity, TFlowMap const& flow, TResidualGraph& rG);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1414)

//____________________________________________________________________________
// _collectEdges

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor1, typename TVertexDescriptor2, typename TEdgeSet> inline bool _collectEdges(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor1 const source, TVertexDescriptor2 const v, TEdgeSet& edgeSet);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(769)
template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor, typename TEdgeSet> inline bool _collectEdges(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor const source, TEdgeSet& edgeSet);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(788)

//____________________________________________________________________________
// _connectedComponentVisit

template <typename TSpec, typename TVertexDescriptor, typename TTokenMap, typename TComponents, typename TVal> void _connectedComponentVisit(Graph<TSpec> const& g, TVertexDescriptor const u, TTokenMap& tokenMap, TComponents& components, TVal& label);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(406)

//____________________________________________________________________________
// _dfsVisit

template <typename TSpec, typename TVertexDescriptor, typename TTokenMap, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap, typename TVal> void _dfsVisit(Graph<TSpec> const& g, TVertexDescriptor const u, TTokenMap& tokenMap, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish, TVal& time);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(165)

//____________________________________________________________________________
// _extendShortestPaths

template <typename TMatrix, typename TPredecessor, typename TInfDist> void _extendShortestPaths(TMatrix& local, TMatrix& w, TPredecessor& predecessor, TInfDist const infDist);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1209)

//____________________________________________________________________________
// _fillHmmRandom

template <typename TAlphabet, typename TProbability, typename TSpec, typename TRNG> inline void _fillHmmRandom(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm, TRNG & rng);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(752)

//____________________________________________________________________________
// _fillHmmUniform

template <typename TAlphabet, typename TProbability, typename TSpec> inline void _fillHmmUniform(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(722)

//____________________________________________________________________________
// _forwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TForwardMatrix> inline TProbability _forwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq, TForwardMatrix& fMat);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(229)

//____________________________________________________________________________
// _getMinimumAug

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor> inline typename Size<Graph<TSpec> >::Type _getMinimumAug(Graph<TSpec> const& rG, TPredecessorMap& predecessor, TVertexDescriptor const source, TVertexDescriptor sink);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1454)

//____________________________________________________________________________
// _initializeAllPairs

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void _initializeAllPairs(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& matrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1165)

//____________________________________________________________________________
// _initializeSingleSource

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> inline void _initializeSingleSource(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(810)

//____________________________________________________________________________
// _insertObject

template <typename TValue, typename TPredicate, typename TSpec, typename TIndex, typename TObject> inline void _insertObject(HeapTree<TValue, TPredicate, KeylessHeap<TSpec> >& mHeap, TIndex i, TObject obj);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(270)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TIndex, typename TObject> inline void _insertObject(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TIndex i, TObject obj);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(432)

//____________________________________________________________________________
// _left

template <typename TSize> inline TSize _left(TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(128)

//____________________________________________________________________________
// _nextInSortedSequence

template <typename TSortedSequence, typename TIterator> inline typename TSortedSequence::const_iterator _nextInSortedSequence(TSortedSequence const& list, TIterator const& prev);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(76)

//____________________________________________________________________________
// _parameterEstimator

template <typename TAlphabet, typename TProbability, typename TSpec,typename TEmissionCounter, typename TTransitionCounter> inline void _parameterEstimator(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm, TEmissionCounter const& emission, TTransitionCounter const& transition);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(626)

//____________________________________________________________________________
// _parent

template <typename TSize> inline TSize _parent(TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(144)

//____________________________________________________________________________
// _previousInSortedSequence

template <typename TSortedSequence, typename TKey> inline typename TSortedSequence::const_iterator _previousInSortedSequence(TSortedSequence const& list, TKey const key);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(47)

//____________________________________________________________________________
// _printAllPairsShortestPath

template <typename TSpec, typename TPredecessor, typename TVertexDescriptor> inline void _printAllPairsShortestPath(Graph<TSpec> const& g, TPredecessor& predecessor, TVertexDescriptor const i, TVertexDescriptor const j);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1143)

//____________________________________________________________________________
// _printPath

template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor, typename TNameMap> inline void _printPath(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor const source, TVertexDescriptor const v, TNameMap const& nameMap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(730)
template <typename TSpec, typename TPredecessorMap, typename TVertexDescriptor1, typename TVertexDescriptor2> inline void _printPath(Graph<TSpec> const& g, TPredecessorMap const& predecessor, TVertexDescriptor1 const source, TVertexDescriptor2 const v);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(749)

//____________________________________________________________________________
// _relax

template <typename TSpec, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap, typename TVertexDescriptor, typename TEdgeDescriptor> inline void _relax(Graph<TSpec> const& g, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance, TVertexDescriptor const u, TEdgeDescriptor const e);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(836)

//____________________________________________________________________________
// _right

template <typename TSize> inline TSize _right(TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(136)

//____________________________________________________________________________
// _swapObjects

template <typename TValue, typename TPredicate, typename TSpec, typename TIndex1, typename TIndex2> inline void _swapObjects(HeapTree<TValue, TPredicate, KeylessHeap<TSpec> >& mHeap, TIndex1 i, TIndex2 j);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(256)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TIndex1, typename TIndex2> inline void _swapObjects(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TIndex1 i, TIndex2 j);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(406)

//____________________________________________________________________________
// _weightedBipartiteMatching

template <typename TSpec, typename TVertexMap, typename TWeightMap, typename TEdges> inline typename Value<TWeightMap>::Type _weightedBipartiteMatching(Graph<TSpec>& g, TVertexMap& vertMap, TWeightMap& weightMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1737)

//____________________________________________________________________________
// allPairsShortestPath

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void allPairsShortestPath(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1267)

//____________________________________________________________________________
// backwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence> inline TProbability backwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(499)

//____________________________________________________________________________
// baumWelchAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence> inline TProbability baumWelchAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec > >& hmm, StringSet<TSequence> const& seqSet);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(926)

//____________________________________________________________________________
// bellmanFordAlgorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> bool bellmanFordAlgorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(943)

//____________________________________________________________________________
// bipartiteMatching

template <typename TSpec, typename TVertexMap, typename TEdges> inline typename Size<Graph<TSpec> >::Type bipartiteMatching(Graph<TSpec>& g, TVertexMap& vertMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1683)

//____________________________________________________________________________
// breadthFirstSearch

template <typename TSpec, typename TVertexDescriptor, typename TPredecessorMap, typename TDistanceMap> void breadthFirstSearch(Graph<TSpec> const& g, TVertexDescriptor const source, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(103)

//____________________________________________________________________________
// buildHeap

template <typename TValue, typename TPredicate, typename TSpec, typename TITBegin, typename TITEnd> inline void buildHeap(HeapTree<TValue, TPredicate, TSpec>& mHeap, TITBegin itBeg, TITEnd itEnd);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(234)

//____________________________________________________________________________
// clear

template <typename TValue, typename TPredicate, typename TSpec> inline void clear(HeapTree<TValue, TPredicate, TSpec>& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(294)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec> inline void clear(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(504)

//____________________________________________________________________________
// connectedComponents

template <typename TSpec, typename TComponents> typename Size<Graph<TSpec> >::Type connectedComponents(Graph<TSpec> const& g_source, TComponents& components);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(441)

//____________________________________________________________________________
// dagShortestPath

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dagShortestPath(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(879)

//____________________________________________________________________________
// depthFirstSearch

template <typename TSpec, typename TPredecessorMap, typename TDiscoveryTimeMap, typename TFinishingTimeMap> void depthFirstSearch(Graph<TSpec> const& g, TPredecessorMap& predecessor, TDiscoveryTimeMap& disc, TFinishingTimeMap& finish);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(215)

//____________________________________________________________________________
// dijkstra

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap, typename TDistanceMap> void dijkstra(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor, TDistanceMap& distance);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1016)

//____________________________________________________________________________
// empty

template <typename TValue, typename TPredicate, typename TSpec> inline bool empty(HeapTree<TValue, TPredicate, TSpec> const& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(154)

//____________________________________________________________________________
// estimationWithStates

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequenceSet, typename TStateSeqSet> inline void estimationWithStates(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm, TSequenceSet& sequences, TStateSeqSet& states);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(663)

//____________________________________________________________________________
// floydWarshallAlgorithm

template <typename TSpec, typename TWeightMap, typename TMatrix, typename TPredecessor> void floydWarshallAlgorithm(Graph<TSpec> const& g, TWeightMap const& weight, TMatrix& distMatrix, TPredecessor& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1317)

//____________________________________________________________________________
// fordFulkersonAlgorithm

template <typename TSpec, typename TVertexDescriptor, typename TCapMap, typename TFlowMap> typename Value<TFlowMap>::Type fordFulkersonAlgorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TVertexDescriptor const sink, TCapMap const& capacity, TFlowMap& flow);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1514)

//____________________________________________________________________________
// forwardAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence> inline TProbability forwardAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(336)

//____________________________________________________________________________
// generateSequence

template <typename TAlphabet, typename TProbability, typename TSpec,typename TSequenceSet, typename TStateSeqSet, typename TSize> inline void generateSequence(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequenceSet& sequences, TStateSeqSet& states, TSize numSeq, TSize maxLength);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(532)
template <typename TAlphabet, typename TProbability, typename TSpec,typename TSequenceSet, typename TSize> inline void generateSequence(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequenceSet& sequences, TSize numSeq, TSize maxLength);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(604)

//____________________________________________________________________________
// globalAlignment

template <typename TAlign, typename TStringSet> inline int globalAlignment(TAlign& align, TStringSet const& str, Lcs);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(240)

//____________________________________________________________________________
// heapChangeValue

template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TKey1, typename TValue2> inline void heapChangeValue(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TKey1 key, TValue2 val);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(467)

//____________________________________________________________________________
// heapExtractRoot

template <typename TValue, typename TPredicate, typename TSpec> inline TValue heapExtractRoot(HeapTree<TValue, TPredicate, KeylessHeap<TSpec> >& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(280)
template <typename TKey, typename TValue, typename TPredicate, typename TSpec> inline Pair<TKey, TValue> heapExtractRoot(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(447)

//____________________________________________________________________________
// heapGetValue

template <typename TKey, typename TValue, typename TPredicate, typename TSpec, typename TKey1> inline TValue heapGetValue(HeapTree<Pair<TKey, TValue>, TPredicate, KeyedHeap<TSpec> >& mHeap, TKey1 key);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(491)

//____________________________________________________________________________
// heapInsert

template <typename TValue, typename TPredicate, typename TSpec, typename TObject> inline void heapInsert(HeapTree<TValue, TPredicate, TSpec>& mHeap, TObject object);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(193)

//____________________________________________________________________________
// heapRoot

template <typename TValue, typename TPredicate, typename TSpec> inline TValue heapRoot(HeapTree<TValue, TPredicate, TSpec>& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(174)
template <typename TValue, typename TPredicate, typename TSpec> inline TValue heapRoot(HeapTree<TValue, TPredicate, TSpec> const& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(183)

//____________________________________________________________________________
// heapSort

template <typename TITBegin, typename TITEnd, typename TPredicate> inline void heapSort(TITBegin itBeg, TITEnd itEnd, TPredicate);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(306)
template <typename TITBegin, typename TITEnd> inline void heapSort(TITBegin itBeg, TITEnd itEnd);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(329)

//____________________________________________________________________________
// heapify

template <typename TValue, typename TPredicate, typename TSpec, typename TSize> inline void heapify(HeapTree<TValue, TPredicate, TSpec>& mHeap, TSize i);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(214)

//____________________________________________________________________________
// heaviestIncreasingSubsequence

template <typename TString, typename TWeightMap, typename TPositions> inline typename Value<TWeightMap>::Type heaviestIncreasingSubsequence(TString const& str, TWeightMap const& weights, TPositions& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(321)

//____________________________________________________________________________
// kruskalsAlgorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TEdges> void kruskalsAlgorithm(Graph<TSpec> const& g, TVertexDescriptor const, TWeightMap const& weight, TEdges& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(648)

//____________________________________________________________________________
// length

template <typename TValue, typename TPredicate, typename TSpec> inline typename Size<HeapTree<TValue, TPredicate, TSpec> >::Type length(HeapTree<TValue, TPredicate, TSpec> const& mHeap);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_heap_tree.h"(164)

//____________________________________________________________________________
// longestCommonSubsequence

template <typename TString1, typename TString2, typename TNeighborhoodSize, typename TFinalPos> inline void longestCommonSubsequence(TString1 const& str1, TString2 const& str2, TNeighborhoodSize nSize, TFinalPos& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(185)

//____________________________________________________________________________
// longestIncreasingSubsequence

template <typename TString, typename TPositions> inline void longestIncreasingSubsequence(TString const& str, TPositions& pos);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_lis_his.h"(105)

//____________________________________________________________________________
// pathGrowingAlgorithm

template <typename TSpec, typename TWeightMap, typename TEdgeMap> typename Value<TWeightMap>::Type pathGrowingAlgorithm(Graph<TSpec>& g, TWeightMap const& weightMap, TEdgeMap& edgeMap1);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1605)

//____________________________________________________________________________
// primsAlgorithm

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap> void primsAlgorithm(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(505)

//____________________________________________________________________________
// primsAlgorithmSpaceEfficient

template <typename TSpec, typename TVertexDescriptor, typename TWeightMap, typename TPredecessorMap> void primsAlgorithmSpaceEfficient(Graph<TSpec> const& g, TVertexDescriptor const source, TWeightMap const& weight, TPredecessorMap& predecessor);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(562)

//____________________________________________________________________________
// randomizeHmm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TRNG> inline void randomizeHmm(Graph<Hmm<TAlphabet, TProbability, TSpec> >& hmm, TRNG & );       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(798)

//____________________________________________________________________________
// stronglyConnectedComponents

template <typename TSpec, typename TComponents> void stronglyConnectedComponents(Graph<TSpec> const& g_source, TComponents& components);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(327)

//____________________________________________________________________________
// topologicalSort

template <typename TSpec, typename TVertexDescriptor> void topologicalSort(Graph<TSpec> const& g, String<TVertexDescriptor>& topSort);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(273)

//____________________________________________________________________________
// transitiveClosure

template <typename TSpec, typename TMatrix> void transitiveClosure(Graph<TSpec> const& g, TMatrix& closure);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1368)

//____________________________________________________________________________
// viterbiAlgorithm

template <typename TAlphabet, typename TProbability, typename TSpec, typename TSequence, typename TPath> inline TProbability viterbiAlgorithm(Graph<Hmm<TAlphabet, TProbability, TSpec> > const& hmm, TSequence const& seq, TPath& path);       	// "projects/library/seqan/graph_algorithms/graph_algorithm_hmm.h"(66)

//____________________________________________________________________________
// weightedBipartiteMatching

template <typename TSpec, typename TVertexMap, typename TWeightMap, typename TEdges> inline typename Value<TWeightMap>::Type weightedBipartiteMatching(Graph<TSpec>& g, TVertexMap& vertMap, TWeightMap& weightMap, String<TEdges>& edges);       	// "projects/library/seqan/graph_algorithms/graph_algorithm.h"(1903)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

