# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012 Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_DAL_SubstituteAndInsert
  class SI
    def initialize(md,data)
      @md,@data=md,data
      @skin=SiSU_Env::InfoSkin.new(@md)
    end
    def substitutions_and_insertions?
      data=@data
      data_expand=[]
      if data[0] =~ /^#!\s*(?:\/usr\/bin\/env sisu|\/usr\/bin\/sisu)/ # remove bang from top #! (however file is stripped, so will be removed provided no content precedes it)
        data[0]=data[0].gsub(/^#!\s*\/usr\/bin\/sisu/,'').
          gsub(/^#!\s*\/usr\/bin\/env sisu/,'')
      end
      if data[0] =~ /^(SiSU\s+[\d.]*|sisu-[\d.]+)$/ # SiSU identifier
        data[0]=data[0].gsub(/^(SiSU\s*[\d.]*)$/,'% \1').
          gsub(/^(sisu-[\d.]+)$/,'% \1')
      end
      data.each do |para|
        if para =~/<:(insert\d+)!?>/ \
        and para !~/^%\s+/
          @skin.select
          ins=SiSU_Viz::Inserts.new
          case para
          when /^\s*<:(insert1)>\s*$/
            i=$1
            if defined? ins.insert1
              para=[]
              ins.insert1.split(/\n\n/).each {|x| para << x }
            else p "skin #{i} not found in #{@skin.select}"
            end
          when /^\s*<:(insert2)>\s*$/
            i=$1
            if defined? ins.insert2
              para=[]
              ins.insert2.split(/\n\n/).each {|x| para << x }
            else p "skin #{i} not found in #{@skin.select}"
            end
          when /^\s*<:(insert3)>\s*$/
            i=$1
            if defined? ins.insert3
              para=[]
              ins.insert3.split(/\n\n/).each {|x| para << x << "\n"}
            else p "skin #{i} not found in #{@skin.select}"
            end
          when /^\s*<:(insert4)>\s*$/
            i=$1
            if defined? ins.insert4
              para=[]
              ins.insert4.split(/\n\n/).each {|x| para << x << "\n"}
            else p "skin #{i} not found in #{@skin.select}"
            end
          when /^\s*<:(insert5)>\s*$/
            i=$1
            if defined? ins.insert5
              para=[]
              ins.insert5.split(/\n\n/).each {|x| para << x << "\n"}
            else p "skin #{i} not found in #{@skin.select}"
            end
          when /^\s*<:(insert6)>\s*$/
            i=$1
            if defined? ins.insert6
              para=[]
              ins.insert6.split(/\n\n/).each {|x| para << x << "\n"}
            else p "skin #{i} not found in #{@skin.select}"
            end
          when /^\s*<:(insert7)>\s*$/
            i=$1
            if defined? ins.insert7
              para=[]
              ins.insert7.split(/\n\n/).each {|x| para << x << "\n"}
            else p "skin #{i} not found in #{@skin.select}"
            end
          end
          para.each {|x| data_expand << x }
        else data_expand << para
        end
        data_expand=data_expand.flatten.compact
      end
      data_new=[]
      data_expand.each do |para|
        para=if @md.markup_version.determined >= 0.38
          SiSU_DAL_DocumentStructureExtract::Structure.new(@md,para).structure_markup_normalize
        else
          SiSU_DAL_DocumentStructureExtract::Structure.new(@md,para).structure_marks
        end
        para=para.gsub(/^(:?A~)\s*$/,'\1~ @title @author').                                    #conditional header
          gsub(/^((?:[1-9]|:?[A-C])~\S*)\s*$/,'\1~ [Note: heading marker::required title missing]~#')    #conditional header for incorporated document 2004w12
        if para =~/^@\S+?:/
          para=para.gsub(/^@(\S+?):(\s+|$)/,"#{Mx[:meta_o]}\\1#{Mx[:meta_c]}\\2").
            gsub(/^@(\S+?):([+-])(\s+|$)/,"#{Mx[:meta_o]}\\1\\2#{Mx[:meta_c]}\\3")
        end
        data_new << para
      end
      data_new
    end
  end
end
__END__
