# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v5/utils.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, debug related

=end
module SiSU_Utils
  class CodeMarker
    def initialize(line,file,color=:red)
      @line,@file,@color=line.to_s,file,color
    end
    def ansi(color=nil)
      @color=color ? color : @color
      c={}
      c[:on]=case @color
      when :red         then ANSI_C[:red]
      when :green       then ANSI_C[:green]
      when :yellow      then ANSI_C[:yellow]
      when :blue        then ANSI_C[:blue]
      when :fuchsia     then ANSI_C[:fuchsia]
      when :cyan        then ANSI_C[:cyan]
      when :inv_red     then ANSI_C[:inv_red]
      when :inv_green   then ANSI_C[:inv_green]
      when :inv_yellow  then ANSI_C[:inv_yellow]
      when :inv_blue    then ANSI_C[:inv_blue]
      when :inv_fuchsia then ANSI_C[:inv_fuchsia]
      when :inv_cyan    then ANSI_C[:inv_cyan]
      when :b_red       then ANSI_C[:b_red]
      when :b_green     then ANSI_C[:b_green]
      when :b_yellow    then ANSI_C[:b_yellow]
      when :b_blue      then ANSI_C[:b_blue]
      when :b_fuchsia   then ANSI_C[:b_fuchsia]
      when :b_cyan      then ANSI_C[:b_cyan]
      else                   ANSI_C[:red]
      end
      c[:off]= ANSI_C[:off]
      #ansi_color + @line.to_s + ansi_color_off + ' ' + @file.gsub(/([^\/]+$)/,"#{ansi_color}\\1#{ansi_color_off}")
      c
    end
    def var(v,x)
      h={ c: nil, m: '' }
      if v.is_a?(Hash)
        h[:c] = (defined? v[:c]) ? v[:c] : ''
        h[:m] = (defined? v[:m]) ? v[:m] : ''
      elsif (v.is_a?(Symbol) \
      and x.is_a?(String))
        if v.is_a?(Symbol)
          h[:c]=v
        elsif v.is_a?(String)
          h[:m]=v
        end
        if x.is_a?(String)
          h[:m]=x
        end
      elsif (v.is_a?(Symbol) \
      or v.is_a?(String))
        if v.is_a?(Symbol)
          h[:c]=v
        elsif v.is_a?(String)
          h[:m]=v
        end
      end
      h[:c] = (defined? h[:c]) ? h[:c] : ''
      h[:m] = (defined? h[:m]) ? h[:m] : ''
      h[:c]=ansi(h[:c])
      h[:m]=message(h[:m])
      h
    end
    def message(msg='')
      @message=(msg.nil? || msg.empty?) \
      ? ''
      : ' ' + msg
    end
    def set(v=nil,x=nil)
      v=var(v,x)
      file,path=File.basename(@file),File.dirname(@file)
      v[:c][:on] + @line + v[:c][:off] + ' ' + path + '/' "#{v[:c][:on]}#{file}#{v[:c][:off]}" + v[:m]
    end
    def mark(v=nil,x=nil)
      puts set(v,x)
    end
    def ok(v=nil,x=nil)
      if (v.is_a?(Symbol) \
      and x.is_a?(String))
        x= '*OK* ' + x
      elsif v.is_a?(String)
        v='*OK* ' + v
        x=nil
      else
        v,x='*OK*',nil
      end
      puts set(v,x)
    end
    def warn(v=nil,x=nil)
      if (v.is_a?(Symbol) \
      and x.is_a?(String))
        x= '*WARN* ' + x
      elsif v.is_a?(String)
        v='*WARN* ' + v
        x=nil
      else
        v,x='*WARN*',nil
      end
      puts set(v,x)
    end
    def error(v=nil,x=nil)
      if (v.is_a?(Symbol) \
      and x.is_a?(String))
        x= '*ERROR* ' + x
      elsif v.is_a?(String)
        v='*ERROR* ' + v
        x=nil
      else
        v,x='*ERROR*',nil
      end
      STDERR.puts set(v,x)
    end
  end
  class Path
    def initialize(dir=Dir.pwd)
      @dir=dir
    end
    def base_markup(call_path=nil)
      call_path = call_path \
      ? call_path \
      : Dir.pwd
      (/(\S+?)(?:\/(?:#{Px[:lng_lst_rgx]}))?$/).match(call_path)[1]
    end
    def base_markup_stub
      m=/.+\/(?:src\/)?(\S+)/im
      base_markup[m,1]
    end
    def image_src
      if base_markup =~/sisupod\/doc[\/]?$/
        base_markup.gsub(/\/doc[\/]?$/,'/image')
      elsif FileTest.directory?("#{base_markup}/_sisu/image")
        "#{base_markup}/_sisu/image"
      end
    end
    def bmd
      base_markup
    end
  end
end
__END__
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:green).mark({ m: %{
  code: #{@@flag[:code]}, <-- close "#{t_o}"
}})
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark({ m: %{
  code: #{@@flag['code']}, <-- close "#{t_o}"
}, c: :green})
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:green).mark({ m: %{
  code: #{@@flag['code']}, open --> "#{t_o}"
}}) if t_o=~/^```/m
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:green).mark(%{ code: #{@@flag['code']}, open --> "#{t_o}" }) \
if t_o=~/^```/m
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:green).mark("open -->")
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).mark("open -->")
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark("open -->",:green)
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark(:green,"open -->")
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark("open -->")
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark(:green)
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:green).mark
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:green).mark("open -->")
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).mark('open -->',:green)
SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:red).mark
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:red).set
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).set('',:green)
puts SiSU_Utils::CodeMarker.new(__LINE__,__FILE__).set('',:fuchsia)
puts ANSI_C[:red] + __LINE__.to_s + ANSI_C[:off] + ' ' + __FILE__
puts "#{ANSI_C[:red]} #{__LINE__.to_s} #{ANSI_C[:off]} #{__FILE__}"
puts ANSI_C[:fuchsia] + __LINE__.to_s + ANSI_C[:off] + ' ' + __FILE__.gsub(/([^\/]+$)/,"#{ANSI_C[:fuchsia]}\\1#{ANSI_C[:off]}")
puts ANSI_C[:red] + __LINE__.to_s + ANSI_C[:off] + ' ' + __FILE__.gsub(/([^\/]+$)/,"#{ANSI_C[:red]}\\1#{ANSI_C[:off]}")
