/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.MapMath;
import com.jhlabs.map.proj.Projection;
import java.awt.geom.Point2D;

public class NellProjection
extends Projection {
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        double k = 2.0 * Math.sin(lpphi);
        double V = lpphi * lpphi;
        out.y *= 1.00371 + V * (-0.0935382 + V * -0.011412);
        for (int i = 10; i > 0; --i) {
            V = (lpphi + Math.sin(lpphi) - k) / (1.0 + Math.cos(lpphi));
            out.y -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        out.x = 0.5 * lplam * (1.0 + Math.cos(lpphi));
        out.y = lpphi;
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        out.x = 2.0 * xyx / (1.0 + Math.cos(xyy));
        out.y = MapMath.asin(0.5 * (xyy + Math.sin(xyy)));
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Nell";
    }
}

