/*
 * Decompiled with CFR 0.152.
 */
package classes;

import classes.ProjectElement;
import enums.SelectionCount;
import enums.SelectionType;
import interfaces.DrawableLayer;
import interfaces.ModifiedCollectionListener;
import interfaces.SelectionChangedListener;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Layer<E extends ProjectElement>
implements Serializable,
DrawableLayer {
    private transient List<ModifiedCollectionListener> modifiedCollectionListeners = null;
    private transient List<SelectionChangedListener> selectionChangedListeners = null;
    protected final List<E> elements = new ArrayList();
    protected final List<E> selectedElements = new ArrayList();

    public final void addModifiedCollectionListener(ModifiedCollectionListener listener) {
        if (this.modifiedCollectionListeners == null) {
            this.modifiedCollectionListeners = new ArrayList<ModifiedCollectionListener>();
        }
        this.modifiedCollectionListeners.add(listener);
    }

    public final void removeModifiedCollectionListener(ModifiedCollectionListener listener) {
        if (this.modifiedCollectionListeners != null && this.modifiedCollectionListeners.contains(listener)) {
            this.modifiedCollectionListeners.remove(listener);
        }
    }

    protected final void NotifyCollectionModified() {
        for (ModifiedCollectionListener m : this.modifiedCollectionListeners) {
            m.CollectionModified();
        }
    }

    public final void addSelectionChangedListener(SelectionChangedListener listener) {
        if (this.selectionChangedListeners == null) {
            this.selectionChangedListeners = new ArrayList<SelectionChangedListener>();
        }
        this.selectionChangedListeners.add(listener);
    }

    public final void removeSelectionChangedListener(SelectionChangedListener listener) {
        if (this.selectionChangedListeners != null && this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    protected final void NotifySelectionChanged(List<? extends ProjectElement> selectedItems) {
        if (this.selectionChangedListeners == null) {
            return;
        }
        for (SelectionChangedListener selectionChangedListener : this.selectionChangedListeners) {
            switch (selectedItems.size()) {
                case 0: {
                    selectionChangedListener.SelectionChanged(SelectionCount.None, null);
                    break;
                }
                case 1: {
                    selectionChangedListener.SelectionChanged(SelectionCount.Single, selectedItems.get(0));
                    break;
                }
                default: {
                    selectionChangedListener.SelectionChanged(SelectionCount.Multiple, null);
                }
            }
        }
    }

    protected void NotifySelectionChanged() {
        this.NotifySelectionChanged(this.selectedElements);
    }

    public List<E> getElements() {
        ArrayList<E> result = new ArrayList<E>();
        result.addAll(this.elements);
        result.addAll(this.selectedElements);
        return result;
    }

    public boolean SelectElement(E element) {
        this.elements.addAll(this.selectedElements);
        this.selectedElements.clear();
        if (this.elements.contains(element)) {
            this.selectedElements.add(element);
            this.elements.remove(element);
            return true;
        }
        return false;
    }

    public void SelectNoneElements() {
        this.elements.addAll(this.selectedElements);
        this.selectedElements.clear();
    }

    public void SelectInverseElements() {
        ArrayList<E> temp = new ArrayList<E>();
        temp.addAll(this.elements);
        this.elements.clear();
        this.elements.addAll(this.selectedElements);
        this.selectedElements.clear();
        this.selectedElements.addAll(temp);
    }

    public void SelectAllElements() {
        this.selectedElements.addAll(this.elements);
        this.elements.clear();
    }

    public void AddElements(List<? extends E> elementsToAdd) {
        for (ProjectElement element : elementsToAdd) {
            this.elements.add(element);
        }
    }

    public final E PointHitTest(Point2D p) {
        Point tp = new Point((int)Math.round(p.getX()), (int)Math.round(p.getY()));
        for (ProjectElement e : this.getElements()) {
            if (!e.Hit(tp)) continue;
            return (E)e;
        }
        return null;
    }

    protected List<E> RectangleHitTest(Rectangle r, List<E> elementList) {
        ArrayList<ProjectElement> hitElements = new ArrayList<ProjectElement>();
        for (ProjectElement e : elementList) {
            if (!e.Hit(r)) continue;
            hitElements.add(e);
        }
        return hitElements;
    }

    public abstract void DeleteSelectedElements();

    @Override
    public abstract void Draw(Graphics2D var1, double var2);

    protected final void RemoveFromSelection(Rectangle r) {
        List<E> newlyDeselectedElements = this.RectangleHitTest(r, this.selectedElements);
        if (newlyDeselectedElements.size() > 0) {
            this.elements.addAll(newlyDeselectedElements);
            this.selectedElements.removeAll(newlyDeselectedElements);
        }
    }

    protected final void AddToSelection(Rectangle r) {
        List<E> newlySelectedElements = this.RectangleHitTest(r, this.elements);
        if (newlySelectedElements.size() > 0) {
            this.elements.removeAll(newlySelectedElements);
            this.selectedElements.addAll(newlySelectedElements);
        }
    }

    public abstract void AlterSelection(Rectangle var1, SelectionType var2);

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.SelectNoneElements();
        out.defaultWriteObject();
    }
}

