/*
 * Decompiled with CFR 0.152.
 */
package ui;

import classes.Layer;
import classes.Project;
import classes.ProjectElement;
import enums.TrafficDefinitionLayerType;
import helpers.Broadcaster;
import interfaces.CurrentLayerChangedListener;
import interfaces.ProjectChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import roadnetwork.RoadNetwork;
import trafficdefinition.TrafficDefinitionLayer;
import ui.controls.JTrafficLayerTree;
import ui.controls.JTrafficLayerTreeModel;
import ui.controls.ProjectTreeCellRenderer;

public class PnlLayers
extends JPanel
implements TreeSelectionListener,
ProjectChangedListener,
TreeWillExpandListener {
    private static final long serialVersionUID = 1L;
    private JButton btnDelete = null;
    private JButton btnDuplicate = null;
    private JButton btnNew = null;
    private List<CurrentLayerChangedListener> currentLayerChangedListeners = new ArrayList<CurrentLayerChangedListener>();
    private Project project = null;
    private JScrollPane scrlLayerList = null;
    private JToolBar tlbLayers = null;
    private JTrafficLayerTree treeLayers = null;

    public PnlLayers() {
        this.initialize();
        Broadcaster.addProjectChangedListener(this);
        this.treeLayers.addTreeWillExpandListener(this);
    }

    public void addCurrentLayerChangedListener(CurrentLayerChangedListener currentLayerChangedListener) {
        this.currentLayerChangedListeners.add(currentLayerChangedListener);
    }

    public void NotifyCurrentLayerChanged(Layer<? extends ProjectElement> currentLayer) {
        for (CurrentLayerChangedListener currentLayerChangedListener : this.currentLayerChangedListeners) {
            currentLayerChangedListener.CurrentLayerChanged(currentLayer);
        }
    }

    @Override
    public void ProjectChanged(Project p) {
        this.project = p;
        if (this.project == null) {
            this.treeLayers.removeTreeSelectionListener(this);
            this.treeLayers.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No project loaded")));
            this.treeLayers.updateUI();
            this.btnDelete.setEnabled(false);
            this.btnDuplicate.setEnabled(false);
            this.btnNew.setEnabled(false);
        } else {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Project");
            DefaultMutableTreeNode mapNode = new DefaultMutableTreeNode(this.project.getRoadNetwork());
            DefaultMutableTreeNode layersNode = new DefaultMutableTreeNode("Traffic Layers");
            root.add(mapNode);
            for (TrafficDefinitionLayer layer : this.project.getTrafficLayers()) {
                DefaultMutableTreeNode layerNode = new DefaultMutableTreeNode(layer);
                layersNode.add(layerNode);
            }
            root.add(layersNode);
            JTrafficLayerTreeModel dtm = new JTrafficLayerTreeModel(root);
            this.treeLayers.setModel(dtm);
            DefaultMutableTreeNode initialSelection = mapNode;
            TreePath initialSelectionPath = new TreePath(((DefaultTreeModel)this.treeLayers.getModel()).getPathToRoot(initialSelection));
            this.treeLayers.addTreeSelectionListener(this);
            this.treeLayers.setSelectionPath(initialSelectionPath);
        }
    }

    public void removeCurrentLayerChangedListener(CurrentLayerChangedListener currentLayerChangedListener) {
        if (this.currentLayerChangedListeners.contains(currentLayerChangedListener)) {
            this.currentLayerChangedListeners.remove(currentLayerChangedListener);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        throw new ExpandVetoException(e);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object newObject = ((DefaultMutableTreeNode)e.getNewLeadSelectionPath().getLastPathComponent()).getUserObject();
        if (newObject instanceof TrafficDefinitionLayer) {
            this.NotifyCurrentLayerChanged((TrafficDefinitionLayer)newObject);
            this.btnDelete.setEnabled(true);
            this.btnNew.setEnabled(true);
            this.btnDuplicate.setEnabled(true);
        } else if (newObject instanceof RoadNetwork) {
            this.NotifyCurrentLayerChanged((RoadNetwork)newObject);
            this.btnDelete.setEnabled(false);
            this.btnNew.setEnabled(false);
            this.btnDuplicate.setEnabled(false);
        } else if (newObject instanceof String) {
            String o = (String)newObject;
            if (o.equals("Project")) {
                this.treeLayers.setSelectionPath(e.getOldLeadSelectionPath());
                return;
            }
            if (o.equals("Traffic Layers")) {
                TreePath tp = e.getNewLeadSelectionPath();
                DefaultMutableTreeNode firstLayerNode = ((DefaultMutableTreeNode)tp.getLastPathComponent()).getFirstLeaf();
                TreePath selectionPath = new TreePath(((DefaultTreeModel)this.treeLayers.getModel()).getPathToRoot(firstLayerNode));
                this.treeLayers.setSelectionPath(selectionPath);
            }
        }
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/deletelayer.png")));
            this.btnDelete.setToolTipText("Delete layer");
            this.btnDelete.setEnabled(false);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlLayers.this.DeleteCurrentTrafficLayer();
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnDuplicate() {
        if (this.btnDuplicate == null) {
            this.btnDuplicate = new JButton();
            this.btnDuplicate.setEnabled(false);
            this.btnDuplicate.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/duplicatelayer.png")));
            this.btnDuplicate.setToolTipText("Duplicate layer");
            this.btnDuplicate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlLayers.this.DuplicateCurrentTrafficLayer();
                }
            });
        }
        return this.btnDuplicate;
    }

    private JButton getBtnNew() {
        if (this.btnNew == null) {
            this.btnNew = new JButton();
            this.btnNew.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/addlayer.png")));
            this.btnNew.setToolTipText("Add new layer");
            this.btnNew.setSize(new Dimension(28, 20));
            this.btnNew.setEnabled(false);
            this.btnNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlLayers.this.CreateNewTrafficLayer(null);
                }
            });
        }
        return this.btnNew;
    }

    private JScrollPane getScrlLayerList() {
        if (this.scrlLayerList == null) {
            this.scrlLayerList = new JScrollPane();
            this.scrlLayerList.setPreferredSize(new Dimension(100, 100));
            this.scrlLayerList.setViewportView(this.getTreeLayers());
        }
        return this.scrlLayerList;
    }

    private JToolBar getTlbLayers() {
        if (this.tlbLayers == null) {
            this.tlbLayers = new JToolBar();
            this.tlbLayers.setSize(new Dimension(211, 30));
            this.tlbLayers.setFloatable(false);
            this.tlbLayers.setPreferredSize(new Dimension(18, 26));
            this.tlbLayers.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.tlbLayers.add(this.getBtnNew());
            this.tlbLayers.add(this.getBtnDelete());
            this.tlbLayers.add(this.getBtnDuplicate());
        }
        return this.tlbLayers;
    }

    private JTree getTreeLayers() {
        if (this.treeLayers == null) {
            this.treeLayers = new JTrafficLayerTree();
            this.treeLayers.setShowsRootHandles(false);
            this.treeLayers.setToggleClickCount(-1);
            this.treeLayers.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No project loaded")));
            this.treeLayers.setEditable(true);
            this.treeLayers.setCellRenderer(new ProjectTreeCellRenderer());
            this.treeLayers.getSelectionModel().setSelectionMode(1);
        }
        return this.treeLayers;
    }

    private void initialize() {
        this.setSize(162, 200);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getScrlLayerList(), "Center");
        this.add((Component)this.getTlbLayers(), "South");
    }

    protected void CreateNewTrafficLayer(TrafficDefinitionLayerType type) {
        if (type == null) {
            String s = (String)JOptionPane.showInputDialog(this, "Select the type of the new layer", "Create new traffic definition layer", 1, new ImageIcon(this.getClass().getResource("/resources/icons/addlayer.png")), new String[]{"User-defined", "Activity-based", "Random"}, "User-Defined");
            if (s != null && s.length() > 0) {
                if (s.equals("User-defined")) {
                    type = TrafficDefinitionLayerType.UserDefined;
                } else if (s.equals("Activity-based")) {
                    type = TrafficDefinitionLayerType.ActivityBased;
                } else if (s.equals("Random")) {
                    type = TrafficDefinitionLayerType.Random;
                }
            } else {
                return;
            }
        }
        TrafficDefinitionLayer newLayer = this.project.createNewLayer(type);
        DefaultMutableTreeNode newLayerNode = new DefaultMutableTreeNode(newLayer);
        DefaultMutableTreeNode layersNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.treeLayers.getModel().getRoot()).getChildAt(1);
        layersNode.add(newLayerNode);
        this.treeLayers.setSelectionPath(new TreePath(newLayerNode.getPath()));
        this.treeLayers.updateUI();
    }

    protected void DeleteCurrentTrafficLayer() {
        DefaultMutableTreeNode selectedLayerNode = (DefaultMutableTreeNode)this.treeLayers.getSelectionPath().getLastPathComponent();
        TrafficDefinitionLayer selectedLayer = (TrafficDefinitionLayer)selectedLayerNode.getUserObject();
        if (JOptionPane.showConfirmDialog(this, "Delete layer " + selectedLayer.getName() + " ?") == 0) {
            this.project.DeleteLayer((TrafficDefinitionLayer)selectedLayerNode.getUserObject());
            if (selectedLayerNode.getSiblingCount() == 1) {
                JOptionPane.showMessageDialog(this, "The project must have at least one traffic layer. An empty layer will be inserted to the project.");
                this.CreateNewTrafficLayer(TrafficDefinitionLayerType.UserDefined);
            }
            DefaultMutableTreeNode layersNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.treeLayers.getModel().getRoot()).getChildAt(1);
            layersNode.remove(selectedLayerNode);
            this.treeLayers.setSelectionPath(new TreePath(((DefaultMutableTreeNode)layersNode.getFirstChild()).getPath()));
            this.treeLayers.updateUI();
        }
    }

    protected void DuplicateCurrentTrafficLayer() {
        DefaultMutableTreeNode selectedLayerNode = (DefaultMutableTreeNode)this.treeLayers.getSelectionPath().getLastPathComponent();
        TrafficDefinitionLayer newLayer = this.project.createDuplicateLayer((TrafficDefinitionLayer)selectedLayerNode.getUserObject());
        DefaultMutableTreeNode newLayerNode = new DefaultMutableTreeNode(newLayer);
        DefaultMutableTreeNode layersNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.treeLayers.getModel().getRoot()).getChildAt(1);
        layersNode.add(newLayerNode);
        this.treeLayers.setSelectionPath(new TreePath(newLayerNode.getPath()));
        this.treeLayers.updateUI();
    }
}

