/*
 * Decompiled with CFR 0.152.
 */
package ui.propertypanels;

import classes.Project;
import classes.TypeSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import simulation.VehicleType;
import trafficdefinition.HotSpot;
import ui.controls.SimTimeEdit;
import ui.dialogs.DlgSelectTypes;

public class PnlHotSpotProperties
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnChangeColor = null;
    private JButton btnSelectVehicleTypes = null;
    private JCheckBox chkDirectionIn = null;
    private JCheckBox chkDirectionOut = null;
    private HotSpot currentHotSpot = null;
    private ButtonGroup IncomingTimeTypeGroup = new ButtonGroup();
    private JLabel lblColorTitle = null;
    private JLabel lblIncomingEndTime = null;
    private JLabel lblInIcon = null;
    private JLabel lblNameTitle = null;
    private JLabel lblNumberOfVehiclesTitle = null;
    private JLabel lblOutgoingBeginTime = null;
    private JLabel lblOutgoingEndTime = null;
    private JLabel lblOutIcon = null;
    private JRadioButton rbIncomingTypeArrival = null;
    private JRadioButton rbIncomingTypeDeparture = null;
    private JSpinner spnNumberOfVehicles = null;
    private SimTimeEdit steIncomingBeginTime = null;
    private SimTimeEdit steIncomingEndTime = null;
    private SimTimeEdit steOutgoingBeginTime = null;
    private SimTimeEdit steOutgoingEndTime = null;
    private JTextField txtName = null;
    private JCheckBox chkEnabled = null;
    private JLabel lblIncomingBeginTime = null;

    public PnlHotSpotProperties() {
        this.initialize();
    }

    public void setHotSpot(HotSpot hotSpot) {
        this.currentHotSpot = hotSpot;
        this.txtName.setText(this.currentHotSpot.getName());
        this.spnNumberOfVehicles.setValue(this.currentHotSpot.getNumberOfVehicles());
        this.btnChangeColor.setBackground(this.currentHotSpot.getColor());
        this.chkDirectionIn.setSelected(this.currentHotSpot.isDirectionIn());
        this.chkDirectionOut.setSelected(this.currentHotSpot.isDirectionOut());
        if (this.currentHotSpot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfArrivalToDestination) {
            this.rbIncomingTypeArrival.setSelected(true);
            this.rbIncomingTypeDeparture.setSelected(false);
        } else if (this.currentHotSpot.getDirectionInType() == HotSpot.DirectionInTimeType.TimeOfDepartureFromSource) {
            this.rbIncomingTypeArrival.setSelected(false);
            this.rbIncomingTypeDeparture.setSelected(true);
        }
        this.steIncomingBeginTime.setValue(this.currentHotSpot.getDirectionInBeginTime());
        this.steIncomingEndTime.setValue(this.currentHotSpot.getDirectionInEndTime());
        this.steOutgoingBeginTime.setValue(this.currentHotSpot.getDirectionOutBeginTime());
        this.steOutgoingEndTime.setValue(this.currentHotSpot.getDirectionOutEndTime());
        this.chkEnabled.setSelected(this.currentHotSpot.isEnabled());
    }

    private JButton getBtnChangeColor() {
        if (this.btnChangeColor == null) {
            this.btnChangeColor = new JButton();
            this.btnChangeColor.setPreferredSize(new Dimension(86, 20));
            this.btnChangeColor.setText("");
            this.btnChangeColor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlHotSpotProperties.this.ChangeColor();
                }
            });
        }
        return this.btnChangeColor;
    }

    private JButton getBtnSelectVehicleTypes() {
        if (this.btnSelectVehicleTypes == null) {
            this.btnSelectVehicleTypes = new JButton();
            this.btnSelectVehicleTypes.setPreferredSize(new Dimension(150, 20));
            this.btnSelectVehicleTypes.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/vehicletypes.png")));
            this.btnSelectVehicleTypes.setText("Vehicle types...");
            this.btnSelectVehicleTypes.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PnlHotSpotProperties.this.SelectVehicleTypes();
                }
            });
        }
        return this.btnSelectVehicleTypes;
    }

    private JCheckBox getChkDirectionIn() {
        if (this.chkDirectionIn == null) {
            this.chkDirectionIn = new JCheckBox();
            this.chkDirectionIn.setText("Incoming");
            this.chkDirectionIn.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PnlHotSpotProperties.this.DisableEnableIncomingControls(true);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionIn(true);
                    } else {
                        PnlHotSpotProperties.this.DisableEnableIncomingControls(false);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionIn(false);
                    }
                }
            });
        }
        return this.chkDirectionIn;
    }

    private JCheckBox getChkDirectionOut() {
        if (this.chkDirectionOut == null) {
            this.chkDirectionOut = new JCheckBox();
            this.chkDirectionOut.setText("Outgoing");
            this.chkDirectionOut.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PnlHotSpotProperties.this.DisableEnableOutgoingControls(true);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionOut(true);
                    } else {
                        PnlHotSpotProperties.this.DisableEnableOutgoingControls(false);
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionOut(false);
                    }
                }
            });
        }
        return this.chkDirectionOut;
    }

    private JRadioButton getRbIncomingTypeArrival() {
        if (this.rbIncomingTypeArrival == null) {
            this.rbIncomingTypeArrival = new JRadioButton();
            this.rbIncomingTypeArrival.setText("Time of arrival to destination");
            this.rbIncomingTypeArrival.setEnabled(false);
            this.rbIncomingTypeArrival.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfArrivalToDestination);
                    } else {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfDepartureFromSource);
                    }
                }
            });
        }
        return this.rbIncomingTypeArrival;
    }

    private JRadioButton getRbIncomingTypeDeparture() {
        if (this.rbIncomingTypeDeparture == null) {
            this.rbIncomingTypeDeparture = new JRadioButton();
            this.rbIncomingTypeDeparture.setText("Time of departure from source");
            this.rbIncomingTypeDeparture.setEnabled(false);
            this.rbIncomingTypeDeparture.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfDepartureFromSource);
                    } else {
                        PnlHotSpotProperties.this.currentHotSpot.setDirectionInType(HotSpot.DirectionInTimeType.TimeOfArrivalToDestination);
                    }
                }
            });
        }
        return this.rbIncomingTypeDeparture;
    }

    private JSpinner getSpnNumberOfVehicles() {
        if (this.spnNumberOfVehicles == null) {
            this.spnNumberOfVehicles = new JSpinner();
            this.spnNumberOfVehicles.setPreferredSize(new Dimension(70, 20));
            this.spnNumberOfVehicles.setModel(new SpinnerNumberModel(1, 1, 1000000, 1));
            this.spnNumberOfVehicles.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlHotSpotProperties.this.currentHotSpot.setNumberOfVehicles((Integer)PnlHotSpotProperties.this.spnNumberOfVehicles.getValue());
                }
            });
        }
        return this.spnNumberOfVehicles;
    }

    private SimTimeEdit getSteIncomingBeginTime() {
        if (this.steIncomingBeginTime == null) {
            this.steIncomingBeginTime = new SimTimeEdit();
            this.steIncomingBeginTime.setEnabled(false);
            this.steIncomingBeginTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionInBeginTime(PnlHotSpotProperties.this.steIncomingBeginTime.getValue());
                }
            });
        }
        return this.steIncomingBeginTime;
    }

    private SimTimeEdit getSteIncomingEndTime() {
        if (this.steIncomingEndTime == null) {
            this.steIncomingEndTime = new SimTimeEdit();
            this.steIncomingEndTime.setEnabled(false);
            this.steIncomingEndTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionInEndTime(PnlHotSpotProperties.this.steIncomingEndTime.getValue());
                }
            });
        }
        return this.steIncomingEndTime;
    }

    private SimTimeEdit getSteOutgoingBeginTime() {
        if (this.steOutgoingBeginTime == null) {
            this.steOutgoingBeginTime = new SimTimeEdit();
            this.steOutgoingBeginTime.setEnabled(false);
            this.steOutgoingBeginTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionOutBeginTime(PnlHotSpotProperties.this.steOutgoingBeginTime.getValue());
                }
            });
        }
        return this.steOutgoingBeginTime;
    }

    private SimTimeEdit getSteOutgoingEndTime() {
        if (this.steOutgoingEndTime == null) {
            this.steOutgoingEndTime = new SimTimeEdit();
            this.steOutgoingEndTime.setEnabled(false);
            this.steOutgoingEndTime.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PnlHotSpotProperties.this.currentHotSpot.setDirectionOutEndTime(PnlHotSpotProperties.this.steOutgoingEndTime.getValue());
                }
            });
        }
        return this.steOutgoingEndTime;
    }

    private JTextField getTxtName() {
        if (this.txtName == null) {
            this.txtName = new JTextField();
            this.txtName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PnlHotSpotProperties.this.currentHotSpot.setName(PnlHotSpotProperties.this.txtName.getText());
                }
            });
        }
        return this.txtName;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints4.anchor = 12;
        gridBagConstraints4.gridy = 8;
        this.lblIncomingBeginTime = new JLabel();
        this.lblIncomingBeginTime.setText("Begin Time:");
        this.lblIncomingBeginTime.setEnabled(false);
        GridBagConstraints gridBagConstraints33 = new GridBagConstraints();
        gridBagConstraints33.gridx = 0;
        gridBagConstraints33.fill = 1;
        gridBagConstraints33.gridy = 8;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.gridy = 3;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridy = 11;
        this.lblOutIcon = new JLabel();
        this.lblOutIcon.setText("");
        this.lblOutIcon.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/hotspotout.png")));
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.gridx = 1;
        gridBagConstraints21.anchor = 17;
        gridBagConstraints21.gridy = 5;
        this.lblInIcon = new JLabel();
        this.lblInIcon.setText("");
        this.lblInIcon.setIcon(new ImageIcon(this.getClass().getResource("/resources/icons/hotspotin.png")));
        GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
        gridBagConstraints19.gridx = 0;
        gridBagConstraints19.anchor = 12;
        gridBagConstraints19.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints19.gridy = 13;
        this.lblOutgoingEndTime = new JLabel();
        this.lblOutgoingEndTime.setText("End time:");
        this.lblOutgoingEndTime.setEnabled(false);
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.anchor = 12;
        gridBagConstraints18.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints18.gridy = 12;
        this.lblOutgoingBeginTime = new JLabel();
        this.lblOutgoingBeginTime.setText("Begin time:");
        this.lblOutgoingBeginTime.setEnabled(false);
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.anchor = 12;
        gridBagConstraints17.insets = new Insets(5, 0, 0, 10);
        gridBagConstraints17.gridy = 9;
        this.lblIncomingEndTime = new JLabel();
        this.lblIncomingEndTime.setText("End time:");
        this.lblIncomingEndTime.setEnabled(false);
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.gridx = 0;
        gridBagConstraints16.anchor = 12;
        gridBagConstraints16.insets = new Insets(10, 0, 0, 5);
        gridBagConstraints16.gridy = 7;
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.anchor = 18;
        gridBagConstraints14.gridx = 1;
        gridBagConstraints14.gridy = 13;
        gridBagConstraints14.weighty = 1.0;
        gridBagConstraints14.insets = new Insets(5, 10, 0, 0);
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.anchor = 12;
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 13;
        gridBagConstraints13.weighty = 1.0;
        gridBagConstraints13.insets = new Insets(5, 0, 0, 10);
        GridBagConstraints gridBagConstraints121 = new GridBagConstraints();
        gridBagConstraints121.insets = new Insets(5, 10, 2, 0);
        gridBagConstraints121.gridy = 12;
        gridBagConstraints121.anchor = 18;
        gridBagConstraints121.gridx = 1;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.anchor = 12;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 12;
        gridBagConstraints11.insets = new Insets(5, 0, 0, 10);
        GridBagConstraints gridBagConstraints101 = new GridBagConstraints();
        gridBagConstraints101.anchor = 18;
        gridBagConstraints101.gridx = 1;
        gridBagConstraints101.gridy = 9;
        gridBagConstraints101.insets = new Insets(5, 10, 2, 0);
        GridBagConstraints gridBagConstraints91 = new GridBagConstraints();
        gridBagConstraints91.anchor = 12;
        gridBagConstraints91.gridx = 0;
        gridBagConstraints91.gridy = 9;
        gridBagConstraints91.insets = new Insets(5, 0, 0, 10);
        GridBagConstraints gridBagConstraints81 = new GridBagConstraints();
        gridBagConstraints81.insets = new Insets(10, 10, 2, 0);
        gridBagConstraints81.gridy = 8;
        gridBagConstraints81.anchor = 18;
        gridBagConstraints81.gridx = 1;
        GridBagConstraints gridBagConstraints61 = new GridBagConstraints();
        gridBagConstraints61.anchor = 17;
        gridBagConstraints61.gridx = 0;
        gridBagConstraints61.gridy = 7;
        gridBagConstraints61.gridwidth = 2;
        gridBagConstraints61.insets = new Insets(0, 20, 0, 0);
        GridBagConstraints gridBagConstraints51 = new GridBagConstraints();
        gridBagConstraints51.anchor = 17;
        gridBagConstraints51.gridx = 0;
        gridBagConstraints51.gridy = 6;
        gridBagConstraints51.weightx = 0.0;
        gridBagConstraints51.gridwidth = 2;
        gridBagConstraints51.insets = new Insets(0, 20, 0, 0);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 11;
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.anchor = 17;
        gridBagConstraints12.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints12.gridy = 5;
        GridBagConstraints gridBagConstraints32 = new GridBagConstraints();
        gridBagConstraints32.gridx = 1;
        gridBagConstraints32.anchor = 17;
        gridBagConstraints32.gridy = 1;
        GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
        gridBagConstraints41.gridx = 0;
        gridBagConstraints41.insets = new Insets(10, 2, 10, 2);
        gridBagConstraints41.anchor = 11;
        gridBagConstraints41.gridwidth = 2;
        gridBagConstraints41.gridy = 4;
        GridBagConstraints gridBagConstraints31 = new GridBagConstraints();
        gridBagConstraints31.gridx = 1;
        gridBagConstraints31.insets = new Insets(2, 0, 2, 10);
        gridBagConstraints31.fill = 1;
        gridBagConstraints31.gridy = 2;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.insets = new Insets(0, 10, 0, 0);
        gridBagConstraints7.gridy = 2;
        this.lblColorTitle = new JLabel();
        this.lblColorTitle.setText("Color:");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.insets = new Insets(0, 10, 0, 5);
        gridBagConstraints5.gridy = 1;
        this.lblNumberOfVehiclesTitle = new JLabel();
        this.lblNumberOfVehiclesTitle.setText("Number of vehicles:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(10, 0, 0, 10);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.gridy = 0;
        this.lblNameTitle = new JLabel();
        this.lblNameTitle.setText("Name:");
        this.setSize(315, 433);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.lblNameTitle, gridBagConstraints);
        this.add((Component)this.getTxtName(), gridBagConstraints1);
        this.add((Component)this.lblNumberOfVehiclesTitle, gridBagConstraints5);
        this.add((Component)this.lblColorTitle, gridBagConstraints7);
        this.add((Component)this.getBtnChangeColor(), gridBagConstraints31);
        this.add((Component)this.getBtnSelectVehicleTypes(), gridBagConstraints41);
        this.add((Component)this.getSpnNumberOfVehicles(), gridBagConstraints32);
        this.add((Component)this.getChkDirectionIn(), gridBagConstraints12);
        this.add((Component)this.getChkDirectionOut(), gridBagConstraints2);
        this.add((Component)this.getRbIncomingTypeDeparture(), gridBagConstraints51);
        this.add((Component)this.getRbIncomingTypeArrival(), gridBagConstraints61);
        this.add((Component)this.getSteIncomingBeginTime(), gridBagConstraints81);
        this.add((Component)this.getSteIncomingEndTime(), gridBagConstraints101);
        this.add((Component)this.getSteOutgoingBeginTime(), gridBagConstraints121);
        this.add((Component)this.getSteOutgoingEndTime(), gridBagConstraints14);
        this.add((Component)this.lblInIcon, gridBagConstraints21);
        this.add((Component)this.lblOutIcon, gridBagConstraints3);
        this.add((Component)this.getChkEnabled(), gridBagConstraints6);
        this.add((Component)this.lblIncomingBeginTime, gridBagConstraints4);
        this.add((Component)this.lblIncomingEndTime, gridBagConstraints17);
        this.add((Component)this.lblOutgoingBeginTime, gridBagConstraints18);
        this.add((Component)this.lblOutgoingEndTime, gridBagConstraints19);
        this.IncomingTimeTypeGroup.add(this.rbIncomingTypeArrival);
        this.IncomingTimeTypeGroup.add(this.rbIncomingTypeDeparture);
    }

    protected void ChangeColor() {
        Color newColor = JColorChooser.showDialog(this, "Select flow color", this.currentHotSpot.getColor());
        if (newColor != null) {
            this.currentHotSpot.setColor(newColor);
            this.btnChangeColor.setBackground(newColor);
        }
    }

    protected void DisableEnableIncomingControls(boolean b) {
        this.rbIncomingTypeArrival.setEnabled(b);
        this.rbIncomingTypeDeparture.setEnabled(b);
        this.lblIncomingBeginTime.setEnabled(b);
        this.lblIncomingEndTime.setEnabled(b);
        this.steIncomingBeginTime.setEnabled(b);
        this.steIncomingEndTime.setEnabled(b);
    }

    protected void DisableEnableOutgoingControls(boolean b) {
        this.lblOutgoingBeginTime.setEnabled(b);
        this.lblOutgoingEndTime.setEnabled(b);
        this.steOutgoingBeginTime.setEnabled(b);
        this.steOutgoingEndTime.setEnabled(b);
    }

    protected void SelectVehicleTypes() {
        TypeSelection<VehicleType> projectVehicleTypes = new TypeSelection<VehicleType>(Project.getCurrentlyLoadedProject().getVehicleTypes());
        TypeSelection<VehicleType> hotspotVehicleTypes = new TypeSelection<VehicleType>(this.currentHotSpot.getVehicleSelection());
        hotspotVehicleTypes.addTypesNotInSelection(projectVehicleTypes);
        DlgSelectTypes<VehicleType> dlg = new DlgSelectTypes<VehicleType>(hotspotVehicleTypes);
        dlg.setVisible(true);
        if (dlg.getAnswer() == 0) {
            hotspotVehicleTypes.removeTypesWithZeroPercentage();
            this.currentHotSpot.setVehicleSelection(hotspotVehicleTypes);
        }
    }

    private JCheckBox getChkEnabled() {
        if (this.chkEnabled == null) {
            this.chkEnabled = new JCheckBox();
            this.chkEnabled.setText("Enabled");
            this.chkEnabled.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PnlHotSpotProperties.this.currentHotSpot.setEnabled(PnlHotSpotProperties.this.chkEnabled.isSelected());
                }
            });
        }
        return this.chkEnabled;
    }
}

