/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math;

import cadyts.utilities.math.Matrix;
import cadyts.utilities.math.Vector;

public class Cholesky {
    private Matrix result = null;

    public boolean valid() {
        return this.result != null;
    }

    public Matrix getResult() {
        return this.result;
    }

    private void checkNonNull(Matrix _A) {
        if (_A == null) {
            this.result = null;
            throw new IllegalArgumentException("matrix must not be null");
        }
    }

    private void checkQuadratic(Matrix _A) {
        if (_A.rowSize() != _A.columnSize()) {
            this.result = null;
            throw new IllegalArgumentException("this is not a quadratic matrix");
        }
    }

    public boolean calculateSquareRoot(Matrix _A) {
        this.checkNonNull(_A);
        this.checkQuadratic(_A);
        this.result = new Matrix(_A.rowSize(), _A.columnSize());
        int i = 0;
        while (i < this.result.rowSize()) {
            Vector result_i = this.result.getRow(i);
            Vector _A_i = _A.getRow(i);
            int j = 0;
            while (j <= i) {
                Vector result_j = this.result.getRow(j);
                double s = _A_i.get(j);
                int k = 0;
                while (k < j) {
                    s -= result_i.get(k) * result_j.get(k);
                    ++k;
                }
                if (j < i) {
                    result_i.set(j, s / result_j.get(j));
                } else {
                    if (s <= 0.0) {
                        this.result = null;
                        return this.valid();
                    }
                    result_i.set(i, Math.sqrt(s));
                }
                ++j;
            }
            ++i;
        }
        return this.valid();
    }

    Matrix invertLowerTriangular(Matrix _L) {
        Matrix _S = new Matrix(_L.rowSize(), _L.columnSize());
        int i = 0;
        while (i < _S.rowSize()) {
            Vector _L_i = _L.getRow(i);
            double _L_ii = _L_i.get(i);
            Vector _S_i = _S.getRow(i);
            _S_i.set(i, 1.0 / _L_ii);
            int j = 0;
            while (j < i) {
                double s = 0.0;
                int k = 0;
                while (k < i) {
                    s += _L_i.get(k) * _S.getRow(k).get(j);
                    ++k;
                }
                _S_i.set(j, -s / _L_ii);
                ++j;
            }
            ++i;
        }
        return _S;
    }

    public boolean invert(Matrix _A) {
        if (this.calculateSquareRoot(_A)) {
            Matrix _L_inv = this.invertLowerTriangular(this.result);
            this.result = Matrix.product(_L_inv.newTransposed(), _L_inv);
        }
        return this.valid();
    }
}

