/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.math.networks;

import cadyts.supply.network.Node;
import cadyts.utilities.math.networks.Router;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

class UnsettledNodes
implements Comparator<Node> {
    private final Map<Node, Double> treeCost = new HashMap<Node, Double>();
    private final SortedSet<Node> nodes = new TreeSet<Node>(this);

    UnsettledNodes() {
    }

    boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    int size() {
        return this.nodes.size();
    }

    Node first() {
        return this.nodes.first();
    }

    void remove(Node node) {
        this.nodes.remove(node);
    }

    void update(Node node, double cost) {
        this.nodes.remove(node);
        if (!Double.isInfinite(cost)) {
            this.treeCost.put(node, cost);
        }
        this.nodes.add(node);
    }

    Double cost(Node node) {
        return Router.treeCost(node, this.treeCost);
    }

    Map<Node, Double> cost() {
        return this.treeCost;
    }

    @Override
    public int compare(Node n1, Node n2) {
        int costResult = Double.compare(this.cost(n1), this.cost(n2));
        if (costResult != 0) {
            return costResult;
        }
        return n1.getId().toString().compareTo(n2.getId().toString());
    }
}

