/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.visualization.network;

import java.io.File;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class VisConfig
extends DefaultHandler {
    private static final String LOGO_ELEMENT = "logo";
    private static final String DELAY_ELEMENT = "delay";
    private static final String LINKWIDTH_ELEMENT = "linkwidth";
    private static final String SHOWNODELABELS_ELEMENT = "shownodelabels";
    private static final String SHOWLINKLABELS_ELEMENT = "showlinklabels";
    private static final String COLOR_ELEMENT = "color";
    private static final String NETWORK_ELEMENT = "network";
    private static final String LINKDATA_ELEMENT = "linkdata";
    private static final String VALUE_ATTR = "value";
    private static final String FILE_ATTR = "file";
    private static final String NETWORK_TYPE_ATTR = "type";
    private static final String MULTILANE_ELEMENT = "multilane";
    private final String defaultPath;
    private String logo = "";
    private int delay_ms = 1000;
    private int linkWidthFactor = 1;
    private boolean showNodeLabels = false;
    private boolean showLinkLabels = false;
    private boolean useAntiAliasing = false;
    private String colorDef = "BLUE -1 WHITE 0 GREEN 0.1 YELLOW 0.3 RED 1";
    private String networkFile = null;
    private NetworkType networkType = null;
    private String linkDataFile = null;
    private boolean multiLane = false;

    public VisConfig() {
        this.defaultPath = null;
    }

    public VisConfig(String configFile, String defaultPath) {
        this.defaultPath = defaultPath;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(this);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.parse(configFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        if (LOGO_ELEMENT.equals(qName)) {
            this.setLogo(attrs.getValue(VALUE_ATTR));
        } else if (DELAY_ELEMENT.equals(qName)) {
            this.setDelay_ms(Integer.parseInt(attrs.getValue(VALUE_ATTR)));
        } else if (LINKWIDTH_ELEMENT.equals(qName)) {
            this.setLinkWidthFactor(Integer.parseInt(attrs.getValue(VALUE_ATTR)));
        } else if (SHOWNODELABELS_ELEMENT.equals(qName)) {
            this.setShowNodeLabels(Boolean.parseBoolean(attrs.getValue(VALUE_ATTR)));
        } else if (SHOWLINKLABELS_ELEMENT.equals(qName)) {
            this.setShowLinkLabels(Boolean.parseBoolean(attrs.getValue(VALUE_ATTR)));
        } else if (COLOR_ELEMENT.equals(qName)) {
            this.setColorDef(attrs.getValue(VALUE_ATTR));
        } else if (NETWORK_ELEMENT.equals(qName)) {
            this.setNetworkFile(attrs.getValue(FILE_ATTR));
            this.setNetworkType(NetworkType.valueOf(attrs.getValue(NETWORK_TYPE_ATTR)));
        } else if (LINKDATA_ELEMENT.equals(qName)) {
            this.setLinkDataFile(attrs.getValue(FILE_ATTR));
        } else if (MULTILANE_ELEMENT.equals(qName)) {
            this.setMultiLane(Boolean.parseBoolean(attrs.getValue(VALUE_ATTR)));
        }
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setDelay_ms(int delay_ms) {
        this.delay_ms = delay_ms;
    }

    public int getDelay_ms() {
        return this.delay_ms;
    }

    public void setLinkWidthFactor(int linkWidthFactor) {
        this.linkWidthFactor = linkWidthFactor;
    }

    public int getLinkWidthFactor() {
        return this.linkWidthFactor;
    }

    public void setShowNodeLabels(boolean showNodeLabels) {
        this.showNodeLabels = showNodeLabels;
    }

    public boolean getShowNodeLabels() {
        return this.showNodeLabels;
    }

    public void setShowLinkLabels(boolean showLinkLabels) {
        this.showLinkLabels = showLinkLabels;
    }

    public boolean getShowLinkLabels() {
        return this.showLinkLabels;
    }

    public void setUseAntiAliasing(boolean useAntiAliasing) {
        this.useAntiAliasing = useAntiAliasing;
    }

    public boolean getUseAntiAliasing() {
        return this.useAntiAliasing;
    }

    public void setColorDef(String colorDef) {
        this.colorDef = colorDef;
    }

    public String getColorDef() {
        return this.colorDef;
    }

    public void setNetworkFile(String networkFile) {
        if (new File(networkFile).exists()) {
            this.networkFile = networkFile;
        } else if (new File(String.valueOf(this.defaultPath) + networkFile).exists()) {
            this.networkFile = String.valueOf(this.defaultPath) + networkFile;
        } else {
            throw new IllegalArgumentException("cannot find network file " + networkFile);
        }
    }

    public String getNetworkFile() {
        return this.networkFile;
    }

    public void setNetworkType(NetworkType networkType) {
        this.networkType = networkType;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public void setLinkDataFile(String linkDataFile) {
        if (new File(linkDataFile).exists()) {
            this.linkDataFile = linkDataFile;
        } else if (new File(String.valueOf(this.defaultPath) + linkDataFile).exists()) {
            this.linkDataFile = String.valueOf(this.defaultPath) + linkDataFile;
        } else {
            throw new IllegalArgumentException("cannot find link data file " + linkDataFile);
        }
    }

    public String getLinkDataFile() {
        return this.linkDataFile;
    }

    public void setMultiLane(boolean multiLane) {
        this.multiLane = multiLane;
    }

    public boolean getMultiLane() {
        return this.multiLane;
    }

    public static enum NetworkType {
        MATSIM,
        BIOROUTE;

    }
}

