/*
 * Decompiled with CFR 0.152.
 */
package bioroute.analysis;

import cadyts.supply.network.Link;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.io.tabularFileParser.TabularFileHandler;
import cadyts.utilities.io.tabularFileParser.TabularFileParser;
import cadyts.utilities.math.networks.LinkCost;
import cadyts.utilities.math.networks.Router;
import cadyts.utilities.misc.DynamicData;
import cadyts.utilities.misc.DynamicDataXMLFileIO;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class LinkCoverageAnalyzer
extends DynamicDataXMLFileIO<Link>
implements TabularFileHandler {
    private static final long serialVersionUID = 1L;
    private final Network network;
    private final LinkCost linkCost;
    private Node origin = null;
    private Node destination = null;
    private String toFile = null;
    private Set<Link> allLinks = new HashSet<Link>();

    public LinkCoverageAnalyzer(Network network, LinkCost linkCost) {
        if (network == null) {
            throw new IllegalArgumentException("network is null");
        }
        if (linkCost == null) {
            throw new IllegalArgumentException("link cost ist null");
        }
        this.network = network;
        this.linkCost = linkCost;
    }

    public void run(Node origin, Node destination, String fromFile, String toFile) throws IOException {
        if (origin == null) {
            throw new IllegalArgumentException("origin is null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("destination is null");
        }
        if (fromFile == null) {
            throw new IllegalArgumentException("from file is null");
        }
        this.origin = origin;
        this.destination = destination;
        this.toFile = toFile;
        TabularFileParser parser = new TabularFileParser();
        parser.setDelimiterRegex("\\s");
        parser.parse(fromFile, this);
    }

    public DynamicData<Link> getResult() {
        DynamicData<Link> result = new DynamicData<Link>(0, 1, 1);
        for (Link link : this.network.getLinks()) {
            result.put(link, 0, 1.0);
        }
        for (Link link : this.allLinks) {
            result.put(link, 0, 2.0);
        }
        Router router = new Router(this.linkCost);
        LinkedList<Node> nodeSP = router.bestRoute(this.origin, this.destination);
        for (Link link : Router.toLinkRoute(nodeSP)) {
            result.put(link, 0, 3.0);
        }
        return result;
    }

    @Override
    public void startDocument() {
        this.allLinks = new HashSet<Link>();
    }

    @Override
    public String preprocess(String line) {
        int semicolonIndex = line.indexOf(";");
        return line.substring(0, semicolonIndex);
    }

    @Override
    public void startRow(String[] row) {
        LinkedList<Node> nodeRoute = new LinkedList<Node>();
        String[] stringArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            nodeRoute.add(this.network.getNode(element));
            ++n2;
        }
        List<Link> linkRoute = Router.toLinkRoute(nodeRoute);
        this.allLinks.addAll(linkRoute);
    }

    @Override
    public void endDocument() {
        if (this.toFile != null) {
            try {
                this.write(this.toFile, this.getResult());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected Link attrValue2key(String id) {
        return this.network.getLink(id);
    }

    @Override
    protected String key2attrValue(Link link) {
        return link.getId().toString();
    }
}

