/*
 * Decompiled with CFR 0.152.
 */
package bioroute.pathgenerator.metropolishastings;

import bioroute.PathGenerator;
import bioroute.PathWriter;
import bioroute.pathgenerator.metropolishastings.MHLinkCostPathWeight;
import bioroute.pathgenerator.metropolishastings.MHPath;
import bioroute.pathgenerator.metropolishastings.MHPathProposal;
import bioroute.pathgenerator.metropolishastings.MHPathWriterWrapper;
import cadyts.supply.network.Network;
import cadyts.supply.network.Node;
import cadyts.utilities.config.Config;
import cadyts.utilities.math.metropolishastings.MHAlgorithm;
import cadyts.utilities.math.networks.NetworkReducer;
import cadyts.utilities.math.networks.Router;
import cadyts.utilities.math.networks.UpdateRouter;
import java.util.HashSet;
import java.util.Random;

public class MHPathGenerator
implements PathGenerator {
    public static final String VERBOSE_ELEMENT = "verbose";
    public static final String TOTALITERATIONS_ELEMENT = "totaliterations";
    public static final String SCALE_ELEMENT = "scale";
    public static final String CUTOFFPROBABILITY_ELEMENT = "cutoffprobability";
    public static final String PATHWEIGHT_ELEMENT = "pathweight";
    private Boolean verbose = null;
    private Integer totalIterations = null;
    private Double scale = null;
    private Double cutOffProbability = null;
    private Network network = null;
    private MHLinkCostPathWeight pathWeight = null;
    private PathWriter pathWriter = null;

    @Override
    public void configure(Config config) {
        this.verbose = Boolean.parseBoolean(config.get("pathgenerator", VERBOSE_ELEMENT));
        this.totalIterations = Integer.parseInt(config.get("pathgenerator", TOTALITERATIONS_ELEMENT));
        this.scale = Double.parseDouble(config.get("pathgenerator", SCALE_ELEMENT));
        this.cutOffProbability = Double.parseDouble(config.get("pathgenerator", CUTOFFPROBABILITY_ELEMENT));
        this.pathWeight = new MHLinkCostPathWeight();
        this.pathWeight.configure(config.newSubConfig("pathgenerator"));
    }

    @Override
    public void setNetwork(Network network) {
        this.network = network;
        this.pathWeight.initialize(network);
    }

    @Override
    public void setPathWriter(PathWriter pathWriter) {
        this.pathWriter = pathWriter;
    }

    @Override
    public void run(Node origin, Node destination) {
        Network preparedNetwork = new Network(this.network);
        if (this.cutOffProbability > 0.0) {
            HashSet<Node> destinations = new HashSet<Node>();
            destinations.add(destination);
            double costSP = new Router(this.pathWeight).fwdCost(origin, destinations).get(destination);
            double expansion = 1.0 - Math.log(this.cutOffProbability) / this.scale / costSP;
            new NetworkReducer(origin, destination, this.pathWeight, expansion).reduce(preparedNetwork);
        }
        UpdateRouter router = new UpdateRouter(this.pathWeight);
        Random rnd = new Random();
        MHPathProposal proposal = new MHPathProposal(origin, destination, preparedNetwork, router, this.scale, rnd);
        MHAlgorithm<MHPath> algo = new MHAlgorithm<MHPath>(proposal, this.pathWeight, rnd);
        if (this.verbose.booleanValue()) {
            algo.setMsgInterval(1000);
        } else {
            algo.setMsgInterval(Integer.MAX_VALUE);
        }
        algo.addStateProcessor(new MHPathWriterWrapper(this.pathWriter));
        algo.run(this.totalIterations);
    }
}

