/*
 * Decompiled with CFR 0.152.
 */
package cadyts.measurements;

import cadyts.calibrators.Calibrator;
import cadyts.demand.Demand;
import cadyts.demand.Plan;
import cadyts.demand.PlanStep;
import cadyts.supply.LinkLoading;
import cadyts.supply.SimResults;
import cadyts.utilities.math.SignalSmoother;
import cadyts.utilities.misc.TimedElement;
import java.io.Serializable;
import java.util.Set;
import java.util.logging.Logger;

public class SingleLinkMeasurement<L>
extends TimedElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TYPE type;
    private final double measValue;
    private final double measVariance;
    private final L link;
    private LinkLoading<L> loading;
    private SignalSmoother avgLinkFeature;
    private double lastLL = 0.0;
    private double lastLLPredErr = 0.0;
    private double lastLinkFeaturePredErr = 0.0;

    public SingleLinkMeasurement(L link, double measValue, double measVariance, int startTime_s, int endTime_s, TYPE type) {
        super(startTime_s, endTime_s);
        if (link == null) {
            throw new IllegalArgumentException("link is null");
        }
        if (Double.isNaN(measValue) || Double.isInfinite(measValue)) {
            throw new IllegalArgumentException("infeasible measurement value: " + measValue);
        }
        if (measVariance <= 0.0 || Double.isNaN(measVariance) || Double.isInfinite(measVariance)) {
            throw new IllegalArgumentException("infeasible variance value: " + measVariance);
        }
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        this.link = link;
        this.measValue = measValue;
        this.measVariance = measVariance;
        this.type = type;
        this.loading = null;
        this.avgLinkFeature = null;
    }

    public void init(Calibrator<L> calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator must not be null");
        }
        if (this.loading != null) {
            Logger.getLogger(this.getClass().getName()).warning("init(..) has already been called; this call is ignored");
        } else {
            this.loading = calibrator.newLinkLoading(this.getLink(), this.getStartTime_s(), this.getEndTime_s(), this.getType());
            this.avgLinkFeature = new SignalSmoother(1.0 - calibrator.getRegressionInertia());
        }
    }

    public L getLink() {
        return this.link;
    }

    public double getMeasValue() {
        return this.measValue;
    }

    public double getMeasVariance() {
        return this.measVariance;
    }

    public double getMeasStddev() {
        return Math.sqrt(this.getMeasVariance());
    }

    public TYPE getType() {
        return this.type;
    }

    public Set<L> getRelevantLinks() {
        return this.loading.getRelevantLinks();
    }

    public boolean isPlanListening() {
        return this.loading.isPlanListening();
    }

    public void notifyPlanChoice(Plan<L> plan) {
        this.loading.notifyPlanChoice(plan);
    }

    public void freeze() {
        this.loading.freeze();
        this.avgLinkFeature.freeze();
    }

    protected double ll(double simValue) {
        double e = simValue - this.getMeasValue();
        return -1.0 * e * e / 2.0 / this.getMeasVariance();
    }

    protected double dll_dAvgLinkFeature() {
        return (this.getMeasValue() - this.avgLinkFeature.getSmoothedValue()) / this.getMeasVariance();
    }

    public void update(Demand<L> demand, SimResults<L> simResults) {
        double linkFeature = simResults.getSimValue(this.getLink(), this.getStartTime_s(), this.getEndTime_s(), this.getType());
        double predLinkFeature = this.loading.predictLinkFeature(demand);
        this.lastLL = this.ll(linkFeature);
        this.lastLLPredErr = this.lastLL - this.ll(predLinkFeature);
        this.lastLinkFeaturePredErr = linkFeature - predLinkFeature;
        this.avgLinkFeature.addValue(linkFeature);
        this.loading.update(demand, linkFeature);
    }

    public double getLambdaCoefficient(L link) {
        double result = this.dll_dAvgLinkFeature() * this.loading.get_dLinkFeature_dDemand(link);
        return result;
    }

    public double getLambda(PlanStep<L> step) {
        if (step.getEntryTime_s() < this.getStartTime_s() || step.getEntryTime_s() >= this.getEndTime_s()) {
            return 0.0;
        }
        return this.getLambdaCoefficient(step.getLink());
    }

    public double getLastLL() {
        return this.lastLL;
    }

    public double getLastLLPredErr() {
        return this.lastLLPredErr;
    }

    public double getLastLinkFeaturePredErr() {
        return this.lastLinkFeaturePredErr;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getSimpleName());
        result.append("(");
        result.append("type = ");
        result.append((Object)this.getType());
        result.append(", link = ");
        result.append(this.getLink());
        result.append(", start_s = ");
        result.append(this.getStartTime_s());
        result.append(", dur_s = ");
        result.append(this.getDuration_s());
        result.append(", value = ");
        result.append(this.getMeasValue());
        result.append(", stddev = ");
        result.append(this.getMeasStddev());
        result.append(")");
        return result.toString();
    }

    public static enum TYPE {
        FLOW_VEH_H,
        COUNT_VEH;

    }
}

