/*
 * Decompiled with CFR 0.152.
 */
package cadyts.utilities.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config {
    private Map<List<String>, List<String>> key2value = new HashMap<List<String>, List<String>>();

    private List<String> key(String ... keysAndValue) {
        ArrayList<String> result = new ArrayList<String>(keysAndValue.length - 1);
        int i = 0;
        while (i < keysAndValue.length - 1) {
            result.add(keysAndValue[i]);
            ++i;
        }
        return result;
    }

    private String value(String ... keysAndValue) {
        return keysAndValue[keysAndValue.length - 1];
    }

    private List<String> existingValueList(List<String> key) {
        List<String> result = this.key2value.get(key);
        if (result == null) {
            result = new ArrayList<String>(1);
            this.key2value.put(key, result);
        }
        return result;
    }

    public void clear() {
        this.key2value.clear();
    }

    public int size() {
        int result = 0;
        for (List<String> values : this.key2value.values()) {
            result += values.size();
        }
        return result;
    }

    public void add(List<String> key, String value) {
        this.existingValueList(key).add(value);
    }

    public void add(String ... keysAndValue) {
        this.add(this.key(keysAndValue), this.value(keysAndValue));
    }

    public int size(List<String> keys) {
        if (this.key2value.containsKey(keys)) {
            return this.key2value.get(keys).size();
        }
        return 0;
    }

    public int size(String ... keys) {
        return this.size(Arrays.asList(keys));
    }

    public String get(int index, String ... keys) {
        return this.key2value.get(Arrays.asList(keys)).get(index);
    }

    public String get(String ... keys) {
        return this.get(0, keys);
    }

    public String get(List<String> keys) {
        return this.key2value.get(keys).get(0);
    }

    public List<String> getListView(String ... keys) {
        return Collections.unmodifiableList(this.key2value.get(Arrays.asList(keys)));
    }

    public Config newSubConfig(List<String> parentKeysList) {
        int parentKeysSize = parentKeysList.size();
        Config result = new Config();
        for (Map.Entry<List<String>, List<String>> entry : this.key2value.entrySet()) {
            List<String> key = entry.getKey();
            if (key.size() < parentKeysSize || !key.subList(0, parentKeysSize).equals(parentKeysList)) continue;
            result.key2value.put(key.subList(parentKeysSize - 1, key.size()), entry.getValue());
        }
        return result;
    }

    public Config newSubConfig(String ... parentKeys) {
        return this.newSubConfig(Arrays.asList(parentKeys));
    }
}

