/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.map.proj;

import com.jhlabs.map.proj.Projection;
import java.awt.geom.Point2D;

public class FaheyProjection
extends Projection {
    private static final double TOL = 1.0E-6;

    public Point2D.Double project(double lplam, double lpphi, Point2D.Double out) {
        out.x = Math.tan(0.5 * lpphi);
        out.y = 1.819152 * out.x;
        out.x = 0.819152 * lplam * this.asqrt(1.0 - out.x * out.x);
        return out;
    }

    public Point2D.Double projectInverse(double xyx, double xyy, Point2D.Double out) {
        double d;
        out.y = 2.0 * Math.atan(out.y /= 1.819152);
        out.y = 1.0 - xyy * xyy;
        out.x = Math.abs(d) < 1.0E-6 ? 0.0 : xyx / (0.819152 * Math.sqrt(xyy));
        return out;
    }

    private double asqrt(double v) {
        return v <= 0.0 ? 0.0 : Math.sqrt(v);
    }

    public boolean hasInverse() {
        return true;
    }

    public String toString() {
        return "Fahey";
    }
}

