---
title: District
---

## districts2poly.py

Transform
[districts](../Demand/Importing_O/D_Matrices.md#describing_the_taz)
into polygons for visualization in [sumo-gui](../sumo-gui.md).
Using the options **--hue, --saturation, --brightness** the colors can be controlled. Each of these options
supports values from \[0, 1\] as well as the special value *random*.

```
python tools/districts2poly.py <net-file> <route-file>
```

!!! caution
    Only districts using the attribute `edges` are currently supported

## edgesInDistricts.py

Parses a network and a list of polygons and writes a taz file with all the edges which are inside the respective polygonal shape.
The taz-shape-files must be in the format generated by
[polyconvert](../polyconvert.md).

```
python tools/edgesInDistricts.py -n <net-file> -t <taz-files>
```


Call option **--help** for additional details.

## filterDistricts.py

Filter a taz (district) file using a network file and a vehicle class so
that only edges which allow the given vehicle class are included in the
taz definitions.

```
python tools/district/filterDistricts.py -n <net-file> -t <taz-file> -o <output-file> --vclass passenger
```

Call option **--help** for additional details.

## generateBidiDistricts.py

Finds edges that are opposites of each other and puts them in a common
district (TAZ). This can be used to improve routing in conjunction with
[trip attributes fromTaz and
toTaz](../Definition_of_Vehicles,_Vehicle_Types,_and_Routes.md#traffic_assignement_zones_taz).

```
python tools/generateBidiDistricts.py <net-file>
```

Call option **--help** for additional details.

### Example usage

When applied to a typical OSM network, and edge and the edge with the
negated id describe opposite direction edges of the same road. The
generated bidi-taz would look like this:

```
<taz id="-123" edges="-123 123"/>
<taz id="123" edges="-123 123"/>
```

The `<trip>` definitions that would typically use attributes *from* and *to*
instead use the attributes *fromTaz* and *toTaz*:

```
<trip id="someTrip" from="123" to="456" depart="0"/>
<trip id="someTripWithBidiTaz fromTaz="123" toTaz="456"/>
```

The second definition would allow departure from either edge *123*' or
*-123* **due to the way the taz *123* ** is defined. This can prevent
unwanted turn-arounds and the beginning and end of generated trips and
thus simplifies trips created from mapping of geo-coordinates.


## gridDistricts.py

Generates a grid of districts (TAZ) with a given width (in m) for a given network file. 

```
python tools/district/gridDistricts.py -n <net-file> -o <output-file> -w 300
```
