/* game-view.c generated by valac 0.29.2.13-e9504, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cogl/cogl.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_TILE_ACTOR (tile_actor_get_type ())
#define TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE_ACTOR, TileActor))
#define TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE_ACTOR, TileActorClass))
#define IS_TILE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE_ACTOR))
#define IS_TILE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE_ACTOR))
#define TILE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE_ACTOR, TileActorClass))

typedef struct _TileActor TileActor;
typedef struct _TileActorClass TileActorClass;

#define TYPE_CURSOR_ACTOR (cursor_actor_get_type ())
#define CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CURSOR_ACTOR, CursorActor))
#define CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CURSOR_ACTOR, CursorActorClass))
#define IS_CURSOR_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CURSOR_ACTOR))
#define IS_CURSOR_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CURSOR_ACTOR))
#define CURSOR_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CURSOR_ACTOR, CursorActorClass))

typedef struct _CursorActor CursorActor;
typedef struct _CursorActorClass CursorActorClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _ThemePrivate ThemePrivate;
typedef struct _TilePrivate TilePrivate;
typedef struct _TileActorPrivate TileActorPrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SCORE_ACTOR (score_actor_get_type ())
#define SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_ACTOR, ScoreActor))
#define SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_ACTOR, ScoreActorClass))
#define IS_SCORE_ACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_ACTOR))
#define IS_SCORE_ACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_ACTOR))
#define SCORE_ACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_ACTOR, ScoreActorClass))

typedef struct _ScoreActor ScoreActor;
typedef struct _ScoreActorClass ScoreActorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __vala_ClutterPoint_free0(var) ((var == NULL) ? NULL : (var = (_vala_ClutterPoint_free (var), NULL)))
typedef struct _CursorActorPrivate CursorActorPrivate;
typedef struct _ScoreActorPrivate ScoreActorPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
	gboolean is_zealous;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	TileActor* highlighted;
	CursorActor* cursor;
	gboolean cursor_active;
	gint _cursor_x;
	gint _cursor_y;
	TileActor** tiles;
	gint tiles_length1;
	gint tiles_length2;
	ClutterActor* game_actors;
	Game* _game;
	GHashTable* themes;
	gchar* _theme_name;
	gint tile_size;
};

struct _Theme {
	GObject parent_instance;
	ThemePrivate * priv;
	ClutterImage** textures;
	gint textures_length1;
	ClutterImage* cursor;
};

struct _ThemeClass {
	GObjectClass parent_class;
};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint grid_x;
	gint grid_y;
	gint color;
	gboolean visited;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _TileActor {
	ClutterActor parent_instance;
	TileActorPrivate * priv;
	Tile* tile;
};

struct _TileActorClass {
	ClutterActorClass parent_class;
};

struct _CursorActor {
	ClutterActor parent_instance;
	CursorActorPrivate * priv;
};

struct _CursorActorClass {
	ClutterActorClass parent_class;
};

struct _ScoreActor {
	ClutterGroup parent_instance;
	ScoreActorPrivate * priv;
};

struct _ScoreActorClass {
	ClutterGroupClass parent_class;
};

struct _ScoreActorPrivate {
	ClutterText* label;
	gfloat scene_width;
	gfloat scene_height;
	gint game_size;
};


static gpointer game_view_parent_class = NULL;
static gpointer theme_parent_class = NULL;
static gpointer tile_actor_parent_class = NULL;
static gpointer cursor_actor_parent_class = NULL;
static gpointer score_actor_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType tile_actor_get_type (void) G_GNUC_CONST;
GType cursor_actor_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
GType theme_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_CURSOR_X,
	GAME_VIEW_CURSOR_Y,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME_NAME
};
static void game_view_remove_tiles (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_columns (Game* self);
gint game_get_rows (Game* self);
static void game_view_place_tiles (GameView* self);
const gchar* game_view_get_theme_name (GameView* self);
GType tile_get_type (void) G_GNUC_CONST;
Tile* game_get_tile (Game* self, gint x, gint y);
gboolean tile_get_closed (Tile* self);
TileActor* tile_actor_new (Tile* tile, ClutterImage* texture, gint size);
TileActor* tile_actor_construct (GType object_type, Tile* tile, ClutterImage* texture, gint size);
void game_view_move_cb (GameView* self, gint old_x, gint old_y, gint new_x, gint new_y);
static void _game_view_move_cb_tile_move (Tile* _sender, gint old_x, gint old_y, gint new_x, gint new_y, gpointer self);
void game_view_close_cb (GameView* self, gint grid_x, gint grid_y);
static void _game_view_close_cb_tile_close (Tile* _sender, gint grid_x, gint grid_y, gpointer self);
static void game_view_remove_region_cb (GameView* self, ClutterTapAction* tap, ClutterActor* actor);
static void _game_view_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self);
static gboolean game_view_tile_entered_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event);
static gboolean _game_view_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self);
static gboolean game_view_tile_left_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event);
static gboolean _game_view_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self);
CursorActor* cursor_actor_new (ClutterContent* texture, gint size);
CursorActor* cursor_actor_construct (GType object_type, ClutterContent* texture, gint size);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
Theme* theme_new (const gchar* name);
Theme* theme_construct (GType object_type, const gchar* name);
void tile_actor_animate_out (TileActor* self);
void tile_actor_animate_to (TileActor* self, gdouble new_x, gdouble new_y, gboolean is_zealous);
static void game_view_opacity_for_connected_tiles (GameView* self, TileActor* actor, gint opacity);
GList* game_connected_tiles (Game* self, Tile* li);
static void _g_list_free__g_object_unref0_ (GList* self);
void game_view_set_cursor_x (GameView* self, gint value);
void game_view_set_cursor_y (GameView* self, gint value);
gboolean game_remove_connected_tiles (Game* self, Tile* tile);
gboolean game_view_board_left_cb (GameView* self);
void game_reset_visit (Game* self);
static TileActor* game_view_find_tile_at_position (GameView* self, gint position_x, gint position_y);
void game_view_cursor_move (GameView* self, gint x, gint y);
gint game_view_get_cursor_x (GameView* self);
gint game_view_get_cursor_y (GameView* self);
void game_view_cursor_click (GameView* self);
void game_view_update_score_cb (GameView* self, gint points_awarded);
GType score_actor_get_type (void) G_GNUC_CONST;
ScoreActor* score_actor_new (gint game_size, gdouble width, gdouble height);
ScoreActor* score_actor_construct (GType object_type, gint game_size, gdouble width, gdouble height);
void score_actor_animate_score (ScoreActor* self, gint points);
void game_view_game_complete_cb (GameView* self);
void score_actor_animate_final_score (ScoreActor* self, guint points);
gint game_get_score (Game* self);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self);
static void _game_view_update_score_cb_game_update_score (Game* _sender, gint points_awarded, gpointer self);
void game_view_set_theme_name (GameView* self, const gchar* value);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	THEME_DUMMY_PROPERTY
};
static void theme_finalize (GObject* obj);
enum  {
	TILE_ACTOR_DUMMY_PROPERTY
};
static void _vala_ClutterPoint_free (ClutterPoint* self);
static void tile_actor_hide_tile_cb (TileActor* self);
static void _tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void tile_actor_finalize (GObject* obj);
enum  {
	CURSOR_ACTOR_DUMMY_PROPERTY
};
#define SCORE_ACTOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCORE_ACTOR, ScoreActorPrivate))
enum  {
	SCORE_ACTOR_DUMMY_PROPERTY
};
static void __lambda4_ (ScoreActor* self);
static void ___lambda4__clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self);
static void score_actor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 303 "game-view.c"
}


static void game_view_remove_tiles (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	CursorActor* _tmp28_ = NULL;
#line 95 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 97 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 97 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 97 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 98 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return;
#line 321 "game-view.c"
	}
	{
		gint x = 0;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		x = 0;
#line 327 "game-view.c"
		{
			gboolean _tmp2_ = FALSE;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			_tmp2_ = TRUE;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			while (TRUE) {
#line 334 "game-view.c"
				gint _tmp4_ = 0;
				Game* _tmp5_ = NULL;
				Game* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				if (!_tmp2_) {
#line 342 "game-view.c"
					gint _tmp3_ = 0;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp3_ = x;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					x = _tmp3_ + 1;
#line 348 "game-view.c"
				}
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp2_ = FALSE;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp4_ = x;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp5_ = game_view_get_game (self);
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp6_ = _tmp5_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp7_ = game_get_columns (_tmp6_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp8_ = _tmp7_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 100 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					break;
#line 366 "game-view.c"
				}
				{
					gint y = 0;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					y = 0;
#line 372 "game-view.c"
					{
						gboolean _tmp9_ = FALSE;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						_tmp9_ = TRUE;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						while (TRUE) {
#line 379 "game-view.c"
							gint _tmp11_ = 0;
							Game* _tmp12_ = NULL;
							Game* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							TileActor* tile = NULL;
							TileActor** _tmp16_ = NULL;
							gint _tmp16__length1 = 0;
							gint _tmp16__length2 = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							TileActor* _tmp19_ = NULL;
							TileActor* _tmp20_ = NULL;
							TileActor* _tmp21_ = NULL;
							TileActor** _tmp22_ = NULL;
							gint _tmp22__length1 = 0;
							gint _tmp22__length2 = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							TileActor* _tmp25_ = NULL;
							TileActor* _tmp26_ = NULL;
							TileActor* _tmp27_ = NULL;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							if (!_tmp9_) {
#line 404 "game-view.c"
								gint _tmp10_ = 0;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_tmp10_ = y;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								y = _tmp10_ + 1;
#line 410 "game-view.c"
							}
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp9_ = FALSE;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp11_ = y;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp12_ = game_view_get_game (self);
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp13_ = _tmp12_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp14_ = game_get_rows (_tmp13_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp15_ = _tmp14_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							if (!(_tmp11_ < _tmp15_)) {
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								break;
#line 428 "game-view.c"
							}
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp16_ = self->priv->tiles;
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp16__length1 = self->priv->tiles_length1;
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp16__length2 = self->priv->tiles_length2;
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp17_ = x;
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp18_ = y;
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp20_ = _g_object_ref0 (_tmp19_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							tile = _tmp20_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp21_ = tile;
#line 105 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							if (_tmp21_ == NULL) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_g_object_unref0 (tile);
#line 106 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								continue;
#line 454 "game-view.c"
							}
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp22_ = self->priv->tiles;
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp22__length1 = self->priv->tiles_length1;
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp22__length2 = self->priv->tiles_length2;
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp23_ = x;
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp24_ = y;
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_g_object_unref0 (_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_]);
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_] = NULL;
#line 107 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 109 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp26_ = tile;
#line 109 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_signal_handlers_disconnect_matched (_tmp26_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 110 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp27_ = tile;
#line 110 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							clutter_actor_destroy ((ClutterActor*) _tmp27_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_g_object_unref0 (tile);
#line 482 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 114 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp28_ = self->priv->cursor;
#line 114 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_destroy ((ClutterActor*) _tmp28_);
#line 493 "game-view.c"
}


static void _game_view_move_cb_tile_move (Tile* _sender, gint old_x, gint old_y, gint new_x, gint new_y, gpointer self) {
#line 137 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_move_cb ((GameView*) self, old_x, old_y, new_x, new_y);
#line 500 "game-view.c"
}


static void _game_view_close_cb_tile_close (Tile* _sender, gint grid_x, gint grid_y, gpointer self) {
#line 138 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_close_cb ((GameView*) self, grid_x, grid_y);
#line 507 "game-view.c"
}


static void _game_view_remove_region_cb_clutter_tap_action_tap (ClutterTapAction* _sender, ClutterActor* actor, gpointer self) {
#line 150 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_remove_region_cb ((GameView*) self, _sender, actor);
#line 514 "game-view.c"
}


static gboolean _game_view_tile_entered_cb_clutter_actor_enter_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self) {
	gboolean result;
	result = game_view_tile_entered_cb ((GameView*) self, _sender, event);
#line 151 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 523 "game-view.c"
}


static gboolean _game_view_tile_left_cb_clutter_actor_leave_event (ClutterActor* _sender, ClutterCrossingEvent* event, gpointer self) {
	gboolean result;
	result = game_view_tile_left_cb ((GameView*) self, _sender, event);
#line 152 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 532 "game-view.c"
}


static void game_view_place_tiles (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Theme* theme = NULL;
	GHashTable* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	Theme* _tmp6_ = NULL;
	Theme* _tmp7_ = NULL;
	Theme* _tmp71_ = NULL;
	ClutterImage* _tmp72_ = NULL;
	gint _tmp73_ = 0;
	CursorActor* _tmp74_ = NULL;
	ClutterActor* _tmp75_ = NULL;
	CursorActor* _tmp76_ = NULL;
	CursorActor* _tmp77_ = NULL;
#line 117 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 119 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 119 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 120 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return;
#line 563 "game-view.c"
	}
#line 122 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = self->priv->themes;
#line 122 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = game_view_get_theme_name (self);
#line 122 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = g_hash_table_lookup (_tmp2_, _tmp4_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = _g_object_ref0 ((Theme*) _tmp5_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	theme = _tmp6_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = theme;
#line 123 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp7_ == NULL) {
#line 581 "game-view.c"
		GHashTable* _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		Theme* _tmp10_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp8_ = self->priv->themes;
#line 124 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp9_ = g_hash_table_lookup (_tmp8_, "shapesandcolors");
#line 124 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp10_ = _g_object_ref0 ((Theme*) _tmp9_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_object_unref0 (theme);
#line 124 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		theme = _tmp10_;
#line 595 "game-view.c"
	}
	{
		gint x = 0;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		x = 0;
#line 601 "game-view.c"
		{
			gboolean _tmp11_ = FALSE;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			_tmp11_ = TRUE;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			while (TRUE) {
#line 608 "game-view.c"
				gint _tmp13_ = 0;
				Game* _tmp14_ = NULL;
				Game* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				if (!_tmp11_) {
#line 616 "game-view.c"
					gint _tmp12_ = 0;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp12_ = x;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					x = _tmp12_ + 1;
#line 622 "game-view.c"
				}
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp11_ = FALSE;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp13_ = x;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp14_ = game_view_get_game (self);
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp15_ = _tmp14_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp16_ = game_get_columns (_tmp15_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp17_ = _tmp16_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				if (!(_tmp13_ < _tmp17_)) {
#line 126 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					break;
#line 640 "game-view.c"
				}
				{
					gint y = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					y = 0;
#line 646 "game-view.c"
					{
						gboolean _tmp18_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						_tmp18_ = TRUE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						while (TRUE) {
#line 653 "game-view.c"
							gint _tmp20_ = 0;
							Game* _tmp21_ = NULL;
							Game* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							Tile* l = NULL;
							Game* _tmp25_ = NULL;
							Game* _tmp26_ = NULL;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							Tile* _tmp29_ = NULL;
							gboolean _tmp30_ = FALSE;
							Tile* _tmp31_ = NULL;
							TileActor* tile = NULL;
							Tile* _tmp35_ = NULL;
							Theme* _tmp36_ = NULL;
							ClutterImage** _tmp37_ = NULL;
							gint _tmp37__length1 = 0;
							Tile* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							ClutterImage* _tmp40_ = NULL;
							gint _tmp41_ = 0;
							TileActor* _tmp42_ = NULL;
							Tile* _tmp43_ = NULL;
							Tile* _tmp44_ = NULL;
							gfloat xx = 0.0F;
							gfloat yy = 0.0F;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							Game* _tmp47_ = NULL;
							Game* _tmp48_ = NULL;
							gint _tmp49_ = 0;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							gint _tmp52_ = 0;
							TileActor* _tmp53_ = NULL;
							gfloat _tmp54_ = 0.0F;
							gfloat _tmp55_ = 0.0F;
							TileActor* _tmp56_ = NULL;
							ClutterTapAction* tap = NULL;
							ClutterTapAction* _tmp57_ = NULL;
							TileActor* _tmp58_ = NULL;
							ClutterTapAction* _tmp59_ = NULL;
							ClutterTapAction* _tmp60_ = NULL;
							TileActor* _tmp61_ = NULL;
							TileActor* _tmp62_ = NULL;
							TileActor** _tmp63_ = NULL;
							gint _tmp63__length1 = 0;
							gint _tmp63__length2 = 0;
							gint _tmp64_ = 0;
							gint _tmp65_ = 0;
							TileActor* _tmp66_ = NULL;
							TileActor* _tmp67_ = NULL;
							TileActor* _tmp68_ = NULL;
							ClutterActor* _tmp69_ = NULL;
							TileActor* _tmp70_ = NULL;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							if (!_tmp18_) {
#line 712 "game-view.c"
								gint _tmp19_ = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_tmp19_ = y;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								y = _tmp19_ + 1;
#line 718 "game-view.c"
							}
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp18_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp20_ = y;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp21_ = game_view_get_game (self);
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp22_ = _tmp21_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp23_ = game_get_rows (_tmp22_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp24_ = _tmp23_;
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							if (!(_tmp20_ < _tmp24_)) {
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								break;
#line 736 "game-view.c"
							}
#line 131 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp25_ = game_view_get_game (self);
#line 131 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp26_ = _tmp25_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp27_ = x;
#line 131 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp28_ = y;
#line 131 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp29_ = game_get_tile (_tmp26_, _tmp27_, _tmp28_);
#line 131 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							l = _tmp29_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp31_ = l;
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							if (_tmp31_ == NULL) {
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_tmp30_ = TRUE;
#line 756 "game-view.c"
							} else {
								Tile* _tmp32_ = NULL;
								gboolean _tmp33_ = FALSE;
								gboolean _tmp34_ = FALSE;
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_tmp32_ = l;
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_tmp33_ = tile_get_closed (_tmp32_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_tmp34_ = _tmp33_;
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_tmp30_ = _tmp34_;
#line 769 "game-view.c"
							}
#line 132 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							if (_tmp30_) {
#line 133 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								_g_object_unref0 (l);
#line 133 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
								continue;
#line 777 "game-view.c"
							}
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp35_ = l;
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp36_ = theme;
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp37_ = _tmp36_->textures;
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp37__length1 = _tmp36_->textures_length1;
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp38_ = l;
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp39_ = _tmp38_->color;
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp40_ = _tmp37_[_tmp39_];
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp41_ = self->priv->tile_size;
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp42_ = tile_actor_new (_tmp35_, _tmp40_, _tmp41_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_object_ref_sink (_tmp42_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							tile = _tmp42_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp43_ = l;
#line 137 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_signal_connect_object (_tmp43_, "move", (GCallback) _game_view_move_cb_tile_move, self, 0);
#line 138 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp44_ = l;
#line 138 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_signal_connect_object (_tmp44_, "close", (GCallback) _game_view_close_cb_tile_close, self, 0);
#line 142 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp45_ = x;
#line 142 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp46_ = self->priv->tile_size;
#line 142 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							xx = (gfloat) (_tmp45_ * _tmp46_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp47_ = game_view_get_game (self);
#line 143 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp48_ = _tmp47_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp49_ = game_get_rows (_tmp48_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp50_ = _tmp49_;
#line 143 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp51_ = y;
#line 143 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp52_ = self->priv->tile_size;
#line 143 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							yy = (gfloat) (((_tmp50_ - _tmp51_) - 1) * _tmp52_);
#line 144 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp53_ = tile;
#line 144 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp54_ = xx;
#line 144 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp55_ = yy;
#line 144 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							clutter_actor_set_position ((ClutterActor*) _tmp53_, _tmp54_, _tmp55_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp56_ = tile;
#line 147 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							clutter_actor_set_reactive ((ClutterActor*) _tmp56_, TRUE);
#line 148 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp57_ = (ClutterTapAction*) clutter_tap_action_new ();
#line 148 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_object_ref_sink (_tmp57_);
#line 148 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							tap = _tmp57_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp58_ = tile;
#line 149 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp59_ = tap;
#line 149 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							clutter_actor_add_action ((ClutterActor*) _tmp58_, (ClutterAction*) _tmp59_);
#line 150 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp60_ = tap;
#line 150 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_signal_connect_object (_tmp60_, "tap", (GCallback) _game_view_remove_region_cb_clutter_tap_action_tap, self, 0);
#line 151 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp61_ = tile;
#line 151 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_signal_connect_object ((ClutterActor*) _tmp61_, "enter-event", (GCallback) _game_view_tile_entered_cb_clutter_actor_enter_event, self, 0);
#line 152 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp62_ = tile;
#line 152 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							g_signal_connect_object ((ClutterActor*) _tmp62_, "leave-event", (GCallback) _game_view_tile_left_cb_clutter_actor_leave_event, self, 0);
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp63_ = self->priv->tiles;
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp63__length1 = self->priv->tiles_length1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp63__length2 = self->priv->tiles_length2;
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp64_ = x;
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp65_ = y;
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp66_ = tile;
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp67_ = _g_object_ref0 (_tmp66_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_g_object_unref0 (_tmp63_[(_tmp64_ * _tmp63__length2) + _tmp65_]);
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp63_[(_tmp64_ * _tmp63__length2) + _tmp65_] = _tmp67_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp68_ = _tmp63_[(_tmp64_ * _tmp63__length2) + _tmp65_];
#line 155 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp69_ = self->priv->game_actors;
#line 155 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_tmp70_ = tile;
#line 155 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							clutter_actor_add_child (_tmp69_, (ClutterActor*) _tmp70_);
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_g_object_unref0 (tap);
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_g_object_unref0 (tile);
#line 128 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
							_g_object_unref0 (l);
#line 897 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp71_ = theme;
#line 159 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp72_ = _tmp71_->cursor;
#line 159 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp73_ = self->priv->tile_size;
#line 159 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp74_ = cursor_actor_new ((ClutterContent*) _tmp72_, _tmp73_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_ref_sink (_tmp74_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->cursor);
#line 159 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->cursor = _tmp74_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp75_ = self->priv->game_actors;
#line 160 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp76_ = self->priv->cursor;
#line 160 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_add_child (_tmp75_, (ClutterActor*) _tmp76_);
#line 161 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp77_ = self->priv->cursor;
#line 161 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_hide ((ClutterActor*) _tmp77_);
#line 117 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (theme);
#line 930 "game-view.c"
}


static void _g_free0_ (gpointer var) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	var = (g_free (var), NULL);
#line 937 "game-view.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 944 "game-view.c"
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	Theme* theme = NULL;
	Theme* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Theme* _tmp6_ = NULL;
	Theme* _tmp7_ = NULL;
	Theme* _tmp8_ = NULL;
	GHashTable* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	Theme* _tmp11_ = NULL;
	Theme* _tmp12_ = NULL;
#line 166 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 169 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = g_str_hash;
#line 169 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = g_str_equal;
#line 169 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
#line 169 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_hash_table_unref0 (self->priv->themes);
#line 169 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->themes = _tmp2_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = theme_new ("colors");
#line 170 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	theme = _tmp3_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = self->priv->themes;
#line 171 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = g_strdup ("colors");
#line 171 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = theme;
#line 171 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 171 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = theme_new ("shapesandcolors");
#line 173 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (theme);
#line 173 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	theme = _tmp8_;
#line 174 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = self->priv->themes;
#line 174 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = g_strdup ("shapesandcolors");
#line 174 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = theme;
#line 174 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_hash_table_insert (_tmp9_, _tmp10_, _tmp12_);
#line 166 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (theme);
#line 166 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return self;
#line 1010 "game-view.c"
}


GameView* game_view_new (void) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 1017 "game-view.c"
}


void game_view_close_cb (GameView* self, gint grid_x, gint grid_y) {
	TileActor** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TileActor* _tmp3_ = NULL;
#line 178 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 180 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->tiles;
#line 180 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0__length1 = self->priv->tiles_length1;
#line 180 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0__length2 = self->priv->tiles_length2;
#line 180 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = grid_x;
#line 180 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = grid_y;
#line 180 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 180 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile_actor_animate_out (_tmp3_);
#line 1044 "game-view.c"
}


void game_view_move_cb (GameView* self, gint old_x, gint old_y, gint new_x, gint new_y) {
	TileActor* tile = NULL;
	TileActor** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	TileActor* _tmp3_ = NULL;
	TileActor* _tmp4_ = NULL;
	TileActor** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	TileActor* _tmp8_ = NULL;
	TileActor* _tmp9_ = NULL;
	gint new_xx = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint new_yy = 0;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean _tmp18_ = FALSE;
#line 184 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->tiles;
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0__length1 = self->priv->tiles_length1;
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0__length2 = self->priv->tiles_length2;
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = old_x;
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = old_y;
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile = _tmp4_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = self->priv->tiles;
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5__length1 = self->priv->tiles_length1;
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5__length2 = self->priv->tiles_length2;
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = new_x;
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = new_y;
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = _g_object_ref0 (tile);
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (_tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_]);
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_] = _tmp8_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 188 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = new_x;
#line 188 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = self->priv->tile_size;
#line 188 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	new_xx = _tmp10_ * _tmp11_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = game_view_get_game (self);
#line 189 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp13_ = _tmp12_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp14_ = game_get_rows (_tmp13_);
#line 189 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp15_ = _tmp14_;
#line 189 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp16_ = new_y;
#line 189 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp17_ = self->priv->tile_size;
#line 189 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	new_yy = ((_tmp15_ - _tmp16_) - 1) * _tmp17_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp18_ = self->is_zealous;
#line 191 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile_actor_animate_to (tile, (gdouble) new_xx, (gdouble) new_yy, _tmp18_);
#line 184 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (tile);
#line 1137 "game-view.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 195 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 195 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_list_free (self);
#line 1146 "game-view.c"
}


static void game_view_opacity_for_connected_tiles (GameView* self, TileActor* actor, gint opacity) {
	TileActor* _tmp0_ = NULL;
	GList* connected_tiles = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	Tile* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
#line 195 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 197 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = actor;
#line 197 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp0_ == NULL) {
#line 198 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return;
#line 1167 "game-view.c"
	}
#line 200 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = game_view_get_game (self);
#line 200 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 200 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = actor;
#line 200 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = _tmp3_->tile;
#line 200 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = game_connected_tiles (_tmp2_, _tmp4_);
#line 200 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	connected_tiles = _tmp5_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = connected_tiles;
#line 1183 "game-view.c"
	{
		GList* l_collection = NULL;
		GList* l_it = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		l_collection = _tmp6_;
#line 201 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		for (l_it = l_collection; l_it != NULL; l_it = l_it->next) {
#line 1191 "game-view.c"
			Tile* _tmp7_ = NULL;
			Tile* l = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			_tmp7_ = _g_object_ref0 ((Tile*) l_it->data);
#line 201 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			l = _tmp7_;
#line 1198 "game-view.c"
			{
				TileActor** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp8__length2 = 0;
				Tile* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				Tile* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				TileActor* _tmp13_ = NULL;
				gint _tmp14_ = 0;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp8_ = self->priv->tiles;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp8__length1 = self->priv->tiles_length1;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp8__length2 = self->priv->tiles_length2;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp9_ = l;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp10_ = _tmp9_->grid_x;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp11_ = l;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp12_ = _tmp11_->grid_y;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp13_ = _tmp8_[(_tmp10_ * _tmp8__length2) + _tmp12_];
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp14_ = opacity;
#line 202 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				clutter_actor_set_opacity ((ClutterActor*) _tmp13_, (guint) _tmp14_);
#line 201 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_g_object_unref0 (l);
#line 1231 "game-view.c"
			}
		}
	}
#line 195 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__g_list_free__g_object_unref0_0 (connected_tiles);
#line 1237 "game-view.c"
}


static gboolean game_view_tile_entered_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TileActor* tile = NULL;
	ClutterActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
	TileActor* _tmp4_ = NULL;
	TileActor* _tmp5_ = NULL;
#line 206 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 206 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (actor != NULL, FALSE);
#line 206 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 208 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->cursor_active;
#line 208 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp0_) {
#line 209 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		result = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return result;
#line 1264 "game-view.c"
	}
#line 211 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = actor;
#line 211 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TILE_ACTOR, TileActor));
#line 211 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile = _tmp2_;
#line 213 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = tile;
#line 213 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_opacity_for_connected_tiles (self, _tmp3_, 255);
#line 214 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = tile;
#line 214 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->highlighted);
#line 214 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->highlighted = _tmp5_;
#line 216 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = FALSE;
#line 216 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (tile);
#line 216 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 1290 "game-view.c"
}


static gboolean game_view_tile_left_cb (GameView* self, ClutterActor* actor, ClutterCrossingEvent* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	TileActor* tile = NULL;
	ClutterActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	TileActor* _tmp3_ = NULL;
#line 220 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 220 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (actor != NULL, FALSE);
#line 220 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 222 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->cursor_active;
#line 222 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp0_) {
#line 223 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		result = FALSE;
#line 223 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return result;
#line 1315 "game-view.c"
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = actor;
#line 225 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TILE_ACTOR, TileActor));
#line 225 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile = _tmp2_;
#line 227 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = tile;
#line 227 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_opacity_for_connected_tiles (self, _tmp3_, 180);
#line 229 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = FALSE;
#line 229 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (tile);
#line 229 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 1333 "game-view.c"
}


static void game_view_remove_region_cb (GameView* self, ClutterTapAction* tap, ClutterActor* actor) {
	TileActor* tile = NULL;
	ClutterActor* _tmp0_ = NULL;
	TileActor* _tmp1_ = NULL;
	TileActor* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	TileActor* _tmp5_ = NULL;
	Tile* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	TileActor* _tmp8_ = NULL;
	Tile* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	Game* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	TileActor* _tmp13_ = NULL;
	Tile* _tmp14_ = NULL;
#line 233 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 233 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (tap != NULL);
#line 233 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (actor != NULL);
#line 235 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = actor;
#line 235 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_TILE_ACTOR, TileActor));
#line 235 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile = _tmp1_;
#line 237 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = self->priv->highlighted;
#line 237 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_opacity_for_connected_tiles (self, _tmp2_, 180);
#line 239 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = self->priv->cursor_active;
#line 239 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp3_) {
#line 1373 "game-view.c"
		CursorActor* _tmp4_ = NULL;
#line 241 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		self->priv->cursor_active = FALSE;
#line 242 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp4_ = self->priv->cursor;
#line 242 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		clutter_actor_hide ((ClutterActor*) _tmp4_);
#line 1381 "game-view.c"
	}
#line 246 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = tile;
#line 246 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = _tmp5_->tile;
#line 246 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = _tmp6_->grid_x;
#line 246 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_set_cursor_x (self, _tmp7_);
#line 247 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = tile;
#line 247 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = _tmp8_->tile;
#line 247 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = _tmp9_->grid_y;
#line 247 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_set_cursor_y (self, _tmp10_);
#line 249 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = game_view_get_game (self);
#line 249 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = _tmp11_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp13_ = tile;
#line 249 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp14_ = _tmp13_->tile;
#line 249 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_remove_connected_tiles (_tmp12_, _tmp14_);
#line 233 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (tile);
#line 1411 "game-view.c"
}


gboolean game_view_board_left_cb (GameView* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	TileActor** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
#line 253 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 255 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 255 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 255 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_reset_visit (_tmp1_);
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = self->priv->tiles;
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2__length1 = self->priv->tiles_length1;
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2__length2 = self->priv->tiles_length2;
#line 1436 "game-view.c"
	{
		TileActor** tile_collection = NULL;
		gint tile_collection_length1 = 0;
		gint tile_collection_length2 = 0;
		gint tile_it = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		tile_collection = _tmp2_;
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		tile_collection_length1 = _tmp2__length1 * _tmp2__length2;
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		for (tile_it = 0; tile_it < (_tmp2__length1 * _tmp2__length2); tile_it = tile_it + 1) {
#line 1448 "game-view.c"
			TileActor* _tmp3_ = NULL;
			TileActor* tile = NULL;
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			_tmp3_ = _g_object_ref0 (tile_collection[tile_it]);
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			tile = _tmp3_;
#line 1455 "game-view.c"
			{
				TileActor* _tmp4_ = NULL;
#line 258 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp4_ = tile;
#line 258 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				clutter_actor_set_opacity ((ClutterActor*) _tmp4_, (guint) 180);
#line 257 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_g_object_unref0 (tile);
#line 1464 "game-view.c"
			}
		}
	}
#line 260 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 1472 "game-view.c"
}


static TileActor* game_view_find_tile_at_position (GameView* self, gint position_x, gint position_y) {
	TileActor* result = NULL;
	TileActor** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
#line 263 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->tiles;
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0__length1 = self->priv->tiles_length1;
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0__length2 = self->priv->tiles_length2;
#line 1489 "game-view.c"
	{
		TileActor** actor_collection = NULL;
		gint actor_collection_length1 = 0;
		gint actor_collection_length2 = 0;
		gint actor_it = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		actor_collection = _tmp0_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		actor_collection_length1 = _tmp0__length1 * _tmp0__length2;
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		for (actor_it = 0; actor_it < (_tmp0__length1 * _tmp0__length2); actor_it = actor_it + 1) {
#line 1501 "game-view.c"
			TileActor* _tmp1_ = NULL;
			TileActor* actor = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			_tmp1_ = _g_object_ref0 (actor_collection[actor_it]);
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			actor = _tmp1_;
#line 1508 "game-view.c"
			{
				gboolean _tmp2_ = FALSE;
				TileActor* _tmp3_ = NULL;
				Tile* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 266 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp3_ = actor;
#line 266 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp4_ = _tmp3_->tile;
#line 266 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp5_ = _tmp4_->grid_x;
#line 266 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp6_ = position_x;
#line 266 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				if (_tmp5_ == _tmp6_) {
#line 1525 "game-view.c"
					TileActor* _tmp7_ = NULL;
					Tile* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
#line 267 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp7_ = actor;
#line 267 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp8_ = _tmp7_->tile;
#line 267 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp9_ = _tmp8_->grid_y;
#line 267 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp10_ = position_y;
#line 267 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp2_ = _tmp9_ == _tmp10_;
#line 1540 "game-view.c"
				} else {
#line 266 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp2_ = FALSE;
#line 1544 "game-view.c"
				}
#line 266 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				if (_tmp2_) {
#line 268 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					result = actor;
#line 268 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					return result;
#line 1552 "game-view.c"
				}
#line 265 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_g_object_unref0 (actor);
#line 1556 "game-view.c"
			}
		}
	}
#line 269 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = NULL;
#line 269 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 1564 "game-view.c"
}


void game_view_cursor_move (GameView* self, gint x, gint y) {
	TileActor* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	TileActor* _tmp11_ = NULL;
	TileActor* _tmp12_ = NULL;
	gfloat xx = 0.0F;
	gfloat yy = 0.0F;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	Game* _tmp17_ = NULL;
	Game* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	CursorActor* _tmp24_ = NULL;
	CursorActor* _tmp25_ = NULL;
#line 273 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 275 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->cursor_active = TRUE;
#line 277 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->highlighted;
#line 277 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_opacity_for_connected_tiles (self, _tmp0_, 180);
#line 278 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = game_view_get_cursor_x (self);
#line 278 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 278 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = x;
#line 278 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_set_cursor_x (self, _tmp2_ + _tmp3_);
#line 279 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = game_view_get_cursor_y (self);
#line 279 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 279 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = y;
#line 279 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_set_cursor_y (self, _tmp5_ + _tmp6_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = game_view_get_cursor_x (self);
#line 280 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = _tmp7_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = game_view_get_cursor_y (self);
#line 280 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = _tmp9_;
#line 280 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = game_view_find_tile_at_position (self, _tmp8_, _tmp10_);
#line 280 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->highlighted);
#line 280 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->highlighted = _tmp11_;
#line 282 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = self->priv->highlighted;
#line 282 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp12_ != NULL) {
#line 1638 "game-view.c"
		TileActor* _tmp13_ = NULL;
#line 283 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp13_ = self->priv->highlighted;
#line 283 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		game_view_opacity_for_connected_tiles (self, _tmp13_, 255);
#line 1644 "game-view.c"
	}
#line 286 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp14_ = game_view_get_cursor_x (self);
#line 286 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp15_ = _tmp14_;
#line 286 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp16_ = self->priv->tile_size;
#line 286 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	xx = (gfloat) (_tmp15_ * _tmp16_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp17_ = game_view_get_game (self);
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp18_ = _tmp17_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp19_ = game_get_rows (_tmp18_);
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp20_ = _tmp19_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp21_ = game_view_get_cursor_y (self);
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp22_ = _tmp21_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp23_ = self->priv->tile_size;
#line 287 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	yy = (gfloat) (((_tmp20_ - 1) - _tmp22_) * _tmp23_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp24_ = self->priv->cursor;
#line 288 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_position ((ClutterActor*) _tmp24_, xx, yy);
#line 289 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp25_ = self->priv->cursor;
#line 289 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_show ((ClutterActor*) _tmp25_);
#line 1678 "game-view.c"
}


void game_view_cursor_click (GameView* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	TileActor** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	TileActor* _tmp7_ = NULL;
	Tile* _tmp8_ = NULL;
	TileActor** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	TileActor* _tmp14_ = NULL;
	TileActor* _tmp15_ = NULL;
	TileActor* _tmp16_ = NULL;
#line 293 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = self->priv->tiles;
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2__length1 = self->priv->tiles_length1;
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2__length2 = self->priv->tiles_length2;
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = game_view_get_cursor_x (self);
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = game_view_get_cursor_y (self);
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = _tmp2_[(_tmp4_ * _tmp2__length2) + _tmp6_];
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = _tmp7_->tile;
#line 295 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_remove_connected_tiles (_tmp1_, _tmp8_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = self->priv->tiles;
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9__length1 = self->priv->tiles_length1;
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9__length2 = self->priv->tiles_length2;
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = game_view_get_cursor_x (self);
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = game_view_get_cursor_y (self);
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp13_ = _tmp12_;
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp14_ = _tmp9_[(_tmp11_ * _tmp9__length2) + _tmp13_];
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->highlighted);
#line 296 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->highlighted = _tmp15_;
#line 297 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp16_ = self->priv->highlighted;
#line 297 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_opacity_for_connected_tiles (self, _tmp16_, 255);
#line 1756 "game-view.c"
}


void game_view_update_score_cb (GameView* self, gint points_awarded) {
	gboolean _tmp0_ = FALSE;
#line 301 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 303 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->is_zealous;
#line 303 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp0_) {
#line 1768 "game-view.c"
		ScoreActor* text = NULL;
		Game* _tmp1_ = NULL;
		Game* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gfloat _tmp5_ = 0.0F;
		gfloat _tmp6_ = 0.0F;
		gfloat _tmp7_ = 0.0F;
		gfloat _tmp8_ = 0.0F;
		ScoreActor* _tmp9_ = NULL;
		ClutterActor* _tmp10_ = NULL;
		ScoreActor* _tmp11_ = NULL;
		ScoreActor* _tmp12_ = NULL;
		ClutterAlignConstraint* _tmp13_ = NULL;
		ClutterAlignConstraint* _tmp14_ = NULL;
		ScoreActor* _tmp15_ = NULL;
		gint _tmp16_ = 0;
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp1_ = game_view_get_game (self);
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp2_ = _tmp1_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp3_ = game_get_rows (_tmp2_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp5_ = clutter_actor_get_width ((ClutterActor*) self);
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp6_ = _tmp5_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp7_ = clutter_actor_get_height ((ClutterActor*) self);
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp9_ = score_actor_new (_tmp4_ / 5, (gdouble) _tmp6_, (gdouble) _tmp8_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_object_ref_sink (_tmp9_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		text = _tmp9_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp10_ = self->priv->game_actors;
#line 306 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp11_ = text;
#line 306 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		clutter_actor_add_child (_tmp10_, (ClutterActor*) _tmp11_);
#line 307 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp12_ = text;
#line 307 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp13_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
#line 307 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_object_ref_sink (_tmp13_);
#line 307 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp14_ = _tmp13_;
#line 307 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		clutter_actor_add_constraint ((ClutterActor*) _tmp12_, (ClutterConstraint*) _tmp14_);
#line 307 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_object_unref0 (_tmp14_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp15_ = text;
#line 308 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp16_ = points_awarded;
#line 308 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		score_actor_animate_score (_tmp15_, _tmp16_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_object_unref0 (text);
#line 1834 "game-view.c"
	}
}


void game_view_game_complete_cb (GameView* self) {
	ScoreActor* text = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gfloat _tmp4_ = 0.0F;
	gfloat _tmp5_ = 0.0F;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	ScoreActor* _tmp8_ = NULL;
	ClutterActor* _tmp9_ = NULL;
	ClutterAlignConstraint* _tmp10_ = NULL;
	ClutterAlignConstraint* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
#line 313 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = game_get_rows (_tmp1_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = clutter_actor_get_width ((ClutterActor*) self);
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = clutter_actor_get_height ((ClutterActor*) self);
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = score_actor_new (_tmp3_ / 5, (gdouble) _tmp5_, (gdouble) _tmp7_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_ref_sink (_tmp8_);
#line 315 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	text = _tmp8_;
#line 316 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = self->priv->game_actors;
#line 316 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_add_child (_tmp9_, (ClutterActor*) text);
#line 317 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_BOTH, 0.5f);
#line 317 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_ref_sink (_tmp10_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 317 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_add_constraint ((ClutterActor*) text, (ClutterConstraint*) _tmp11_);
#line 317 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (_tmp11_);
#line 318 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = game_view_get_game (self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp13_ = _tmp12_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp14_ = game_get_score (_tmp13_);
#line 318 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp15_ = _tmp14_;
#line 318 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	score_actor_animate_final_score (text, (guint) _tmp15_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (text);
#line 1907 "game-view.c"
}


gint game_view_get_cursor_x (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 27 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->_cursor_x;
#line 27 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = _tmp0_;
#line 27 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 1922 "game-view.c"
}


void game_view_set_cursor_x (GameView* self, gint value) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = value;
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = game_view_get_game (self);
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = game_get_columns (_tmp2_);
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = CLAMP (_tmp0_, 0, _tmp4_ - 1);
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->_cursor_x = _tmp5_;
#line 28 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_notify ((GObject *) self, "cursor-x");
#line 1951 "game-view.c"
}


gint game_view_get_cursor_y (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
#line 34 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 34 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->_cursor_y;
#line 34 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = _tmp0_;
#line 34 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 1966 "game-view.c"
}


void game_view_set_cursor_y (GameView* self, gint value) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = value;
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = game_view_get_game (self);
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = game_get_rows (_tmp2_);
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = CLAMP (_tmp0_, 0, _tmp4_ - 1);
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->_cursor_y = _tmp5_;
#line 35 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_notify ((GObject *) self, "cursor-y");
#line 1995 "game-view.c"
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 48 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 48 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 48 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = _tmp0_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 2010 "game-view.c"
}


static void _game_view_game_complete_cb_game_complete (Game* _sender, gpointer self) {
#line 62 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_game_complete_cb ((GameView*) self);
#line 2017 "game-view.c"
}


static void _game_view_update_score_cb_game_update_score (Game* _sender, gint points_awarded, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_update_score_cb ((GameView*) self, points_awarded);
#line 2024 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	ClutterActor* _tmp0_ = NULL;
	ClutterActor* _tmp2_ = NULL;
	ClutterActor* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	Game* _tmp10_ = NULL;
	Game* _tmp11_ = NULL;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	Game* _tmp14_ = NULL;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	Game* _tmp18_ = NULL;
	Game* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	TileActor** _tmp22_ = NULL;
	gint _tmp23_ = 0;
	Game* _tmp24_ = NULL;
	Game* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	Game* _tmp29_ = NULL;
	Game* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
#line 49 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->game_actors;
#line 51 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp0_ != NULL) {
#line 2065 "game-view.c"
		ClutterActor* _tmp1_ = NULL;
#line 52 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp1_ = self->priv->game_actors;
#line 52 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		clutter_actor_destroy (_tmp1_);
#line 2071 "game-view.c"
	}
#line 53 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = clutter_actor_new ();
#line 53 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_ref_sink (_tmp2_);
#line 53 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->game_actors);
#line 53 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->game_actors = _tmp2_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = self->priv->game_actors;
#line 54 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) self, _tmp3_);
#line 57 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_remove_tiles (self);
#line 59 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = game_view_get_game (self);
#line 59 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 59 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp5_ != NULL) {
#line 2093 "game-view.c"
		Game* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
#line 60 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp6_ = game_view_get_game (self);
#line 60 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp7_ = _tmp6_;
#line 60 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_DATA, (guint) 0, (GQuark) 0, NULL, NULL, self);
#line 2102 "game-view.c"
	}
#line 61 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = value;
#line 61 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 61 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->_game = _tmp9_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = game_view_get_game (self);
#line 62 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_signal_connect_object (_tmp11_, "complete", (GCallback) _game_view_game_complete_cb_game_complete, self, 0);
#line 63 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = game_view_get_game (self);
#line 63 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp13_ = _tmp12_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_signal_connect_object (_tmp13_, "update-score", (GCallback) _game_view_update_score_cb_game_update_score, self, 0);
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp14_ = game_view_get_game (self);
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp15_ = _tmp14_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp16_ = game_get_columns (_tmp15_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp17_ = _tmp16_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp18_ = game_view_get_game (self);
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp19_ = _tmp18_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp20_ = game_get_rows (_tmp19_);
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp21_ = _tmp20_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp22_ = g_new0 (TileActor*, (_tmp17_ * _tmp21_) + 1);
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->tiles = _tmp22_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->tiles_length1 = _tmp17_;
#line 66 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->tiles_length2 = _tmp21_;
#line 67 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_place_tiles (self);
#line 69 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp23_ = self->priv->tile_size;
#line 69 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp24_ = game_view_get_game (self);
#line 69 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp25_ = _tmp24_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp26_ = game_get_columns (_tmp25_);
#line 69 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp27_ = _tmp26_;
#line 69 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) (_tmp23_ * _tmp27_));
#line 70 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp28_ = self->priv->tile_size;
#line 70 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp29_ = game_view_get_game (self);
#line 70 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp30_ = _tmp29_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp31_ = game_get_rows (_tmp30_);
#line 70 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp32_ = _tmp31_;
#line 70 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) (_tmp28_ * _tmp32_));
#line 49 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 2178 "game-view.c"
}


const gchar* game_view_get_theme_name (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 81 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 81 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->_theme_name;
#line 81 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	result = _tmp0_;
#line 81 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return result;
#line 2193 "game-view.c"
}


void game_view_set_theme_name (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
#line 82 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 84 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = game_view_get_theme_name (self);
#line 84 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 84 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = value;
#line 84 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
#line 85 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return;
#line 2215 "game-view.c"
	}
#line 86 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = value;
#line 86 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_free0 (self->priv->_theme_name);
#line 86 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->_theme_name = _tmp4_;
#line 87 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_remove_tiles (self);
#line 88 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_place_tiles (self);
#line 82 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme-name");
#line 2231 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_CURSOR_X, g_param_spec_int ("cursor-x", "cursor-x", "cursor-x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_CURSOR_Y, g_param_spec_int ("cursor-y", "cursor-y", "cursor-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_NAME, g_param_spec_string ("theme-name", "theme-name", "theme-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2254 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
	gchar* _tmp0_ = NULL;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 20 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->highlighted = NULL;
#line 23 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->cursor_active = FALSE;
#line 42 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->game_actors = NULL;
#line 45 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->_game = NULL;
#line 78 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = g_strdup ("shapesandcolors");
#line 78 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->_theme_name = _tmp0_;
#line 93 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->tile_size = 50;
#line 2276 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 20 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->highlighted);
#line 22 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->cursor);
#line 39 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->tiles = (_vala_array_free (self->priv->tiles, self->priv->tiles_length1 * self->priv->tiles_length2, (GDestroyNotify) g_object_unref), NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->game_actors);
#line 45 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 75 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_hash_table_unref0 (self->priv->themes);
#line 78 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_free0 (self->priv->_theme_name);
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 2300 "game-view.c"
}


/**
 *  This class defines the view of a game. All clutter related stuff goes here. It follows the
 *  principle of MVC framework. This class deals with the presentation (view) layer. It communicates
 *  with the model class by composite relation and with the control layer by means of signals and
 *  events.
 */
GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	switch (property_id) {
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_CURSOR_X:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_value_set_int (value, game_view_get_cursor_x (self));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_CURSOR_Y:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_value_set_int (value, game_view_get_cursor_y (self));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_THEME_NAME:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_value_set_string (value, game_view_get_theme_name (self));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 2351 "game-view.c"
		default:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 2357 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	switch (property_id) {
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_CURSOR_X:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		game_view_set_cursor_x (self, g_value_get_int (value));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_CURSOR_Y:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		game_view_set_cursor_y (self, g_value_get_int (value));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		case GAME_VIEW_THEME_NAME:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		game_view_set_theme_name (self, g_value_get_string (value));
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 2391 "game-view.c"
		default:
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 18 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		break;
#line 2397 "game-view.c"
	}
}


Theme* theme_construct (GType object_type, const gchar* name) {
	Theme * self = NULL;
	ClutterImage** _tmp0_ = NULL;
	gchar** colors = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
	gint colors_length1 = 0;
	gint _colors_size_ = 0;
	GError * _inner_error_ = NULL;
#line 331 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 331 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = (Theme*) g_object_new (object_type, NULL);
#line 333 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = g_new0 (ClutterImage*, 4 + 1);
#line 333 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
#line 333 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->textures = _tmp0_;
#line 333 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->textures_length1 = 4;
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = g_strdup ("blue");
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = g_strdup ("green");
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = g_strdup ("yellow");
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = g_strdup ("red");
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = g_new0 (gchar*, 4 + 1);
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_[0] = _tmp1_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_[1] = _tmp2_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_[2] = _tmp3_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_[3] = _tmp4_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	colors = _tmp5_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	colors_length1 = 4;
#line 334 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_colors_size_ = colors_length1;
#line 2450 "game-view.c"
	{
		GdkPixbuf* pixbuf = NULL;
		const gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		GdkPixbuf* _tmp37_ = NULL;
		GdkPixbuf* _tmp38_ = NULL;
		ClutterImage* _tmp39_ = NULL;
		ClutterImage* _tmp40_ = NULL;
		GdkPixbuf* _tmp41_ = NULL;
		guint8* _tmp42_ = NULL;
		GdkPixbuf* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		GdkPixbuf* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		GdkPixbuf* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		{
			gint i = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			i = 0;
#line 2472 "game-view.c"
			{
				gboolean _tmp6_ = FALSE;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				_tmp6_ = TRUE;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
				while (TRUE) {
#line 2479 "game-view.c"
					gint _tmp8_ = 0;
					GdkPixbuf* pixbuf = NULL;
					const gchar* _tmp9_ = NULL;
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					gint _tmp11_ = 0;
					const gchar* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					GdkPixbuf* _tmp17_ = NULL;
					GdkPixbuf* _tmp18_ = NULL;
					ClutterImage** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					gint _tmp20_ = 0;
					ClutterImage* _tmp21_ = NULL;
					ClutterImage* _tmp22_ = NULL;
					ClutterImage** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					gint _tmp24_ = 0;
					ClutterImage* _tmp25_ = NULL;
					GdkPixbuf* _tmp26_ = NULL;
					guint8* _tmp27_ = NULL;
					GdkPixbuf* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					GdkPixbuf* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					GdkPixbuf* _tmp32_ = NULL;
					gint _tmp33_ = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					if (!_tmp6_) {
#line 2512 "game-view.c"
						gint _tmp7_ = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						_tmp7_ = i;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						i = _tmp7_ + 1;
#line 2518 "game-view.c"
					}
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp6_ = FALSE;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp8_ = i;
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					if (!(_tmp8_ < 4)) {
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						break;
#line 2528 "game-view.c"
					}
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp9_ = name;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp10_ = colors;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp10__length1 = colors_length1;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp11_ = i;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp12_ = _tmp10_[_tmp11_];
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp13_ = g_strconcat (_tmp12_, ".svg", NULL);
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp14_ = _tmp13_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp15_ = g_build_filename (DATADIR, "themes", _tmp9_, _tmp14_, NULL);
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp16_ = _tmp15_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp17_ = gdk_pixbuf_new_from_file (_tmp16_, &_inner_error_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp18_ = _tmp17_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_g_free0 (_tmp16_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_g_free0 (_tmp14_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					pixbuf = _tmp18_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 340 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 2562 "game-view.c"
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
#line 341 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp19_ = self->textures;
#line 341 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp19__length1 = self->textures_length1;
#line 341 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp20_ = i;
#line 341 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp21_ = clutter_image_new ();
#line 341 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_g_object_unref0 (_tmp19_[_tmp20_]);
#line 341 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp19_[_tmp20_] = _tmp21_;
#line 341 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp22_ = _tmp19_[_tmp20_];
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp23_ = self->textures;
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp23__length1 = self->textures_length1;
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp24_ = i;
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp25_ = _tmp23_[_tmp24_];
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp26_ = pixbuf;
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp27_ = gdk_pixbuf_get_pixels (_tmp26_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp28_ = pixbuf;
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp29_ = gdk_pixbuf_get_width (_tmp28_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp30_ = pixbuf;
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp31_ = gdk_pixbuf_get_height (_tmp30_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp32_ = pixbuf;
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_tmp33_ = gdk_pixbuf_get_rowstride (_tmp32_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					clutter_image_set_data (_tmp25_, _tmp27_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) _tmp29_, (guint) _tmp31_, (guint) _tmp33_, &_inner_error_);
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						_g_object_unref0 (pixbuf);
#line 342 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
						if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 2613 "game-view.c"
							goto __catch0_clutter_texture_error;
						}
						goto __catch0_g_error;
					}
#line 339 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
					_g_object_unref0 (pixbuf);
#line 2620 "game-view.c"
				}
			}
		}
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp34_ = name;
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp35_ = g_build_filename (DATADIR, "themes", _tmp34_, "highlight.svg", NULL);
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp36_ = _tmp35_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp37_ = gdk_pixbuf_new_from_file (_tmp36_, &_inner_error_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp38_ = _tmp37_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_free0 (_tmp36_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		pixbuf = _tmp38_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 345 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 2642 "game-view.c"
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
#line 346 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp39_ = clutter_image_new ();
#line 346 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_object_unref0 (self->cursor);
#line 346 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		self->cursor = _tmp39_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp40_ = self->cursor;
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp41_ = pixbuf;
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp42_ = gdk_pixbuf_get_pixels (_tmp41_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp43_ = pixbuf;
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp44_ = gdk_pixbuf_get_width (_tmp43_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp45_ = pixbuf;
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp46_ = gdk_pixbuf_get_height (_tmp45_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp47_ = pixbuf;
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp48_ = gdk_pixbuf_get_rowstride (_tmp47_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		clutter_image_set_data (_tmp40_, _tmp42_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) _tmp44_, (guint) _tmp46_, (guint) _tmp48_, &_inner_error_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			_g_object_unref0 (pixbuf);
#line 347 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
#line 2679 "game-view.c"
				goto __catch0_clutter_texture_error;
			}
			goto __catch0_g_error;
		}
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_object_unref0 (pixbuf);
#line 2686 "game-view.c"
	}
	goto __finally0;
	__catch0_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		e = _inner_error_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_inner_error_ = NULL;
#line 352 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp49_ = e;
#line 352 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp50_ = _tmp49_->message;
#line 352 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_warning ("game-view.vala:352: Failed to load textures: %s", _tmp50_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_error_free0 (e);
#line 2706 "game-view.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		e = _inner_error_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_inner_error_ = NULL;
#line 356 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp51_ = e;
#line 356 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp52_ = _tmp51_->message;
#line 356 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_warning ("game-view.vala:356: Failed to load textures: %s", _tmp52_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_g_error_free0 (e);
#line 2726 "game-view.c"
	}
	__finally0:
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 337 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return NULL;
#line 2739 "game-view.c"
	}
#line 331 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	colors = (_vala_array_free (colors, colors_length1, (GDestroyNotify) g_free), NULL);
#line 331 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return self;
#line 2745 "game-view.c"
}


Theme* theme_new (const gchar* name) {
#line 331 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return theme_construct (TYPE_THEME, name);
#line 2752 "game-view.c"
}


static void theme_class_init (ThemeClass * klass) {
#line 326 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	theme_parent_class = g_type_class_peek_parent (klass);
#line 326 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = theme_finalize;
#line 2761 "game-view.c"
}


static void theme_instance_init (Theme * self) {
}


static void theme_finalize (GObject* obj) {
	Theme * self;
#line 326 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEME, Theme);
#line 328 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->textures = (_vala_array_free (self->textures, self->textures_length1, (GDestroyNotify) g_object_unref), NULL);
#line 329 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->cursor);
#line 326 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (theme_parent_class)->finalize (obj);
#line 2779 "game-view.c"
}


/**
 *  This class holds the textures for a specific theme. These textures are used for creating light
 *  actors and cursor actor.
 */
GType theme_get_type (void) {
	static volatile gsize theme_type_id__volatile = 0;
	if (g_once_init_enter (&theme_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ThemeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) theme_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Theme), 0, (GInstanceInitFunc) theme_instance_init, NULL };
		GType theme_type_id;
		theme_type_id = g_type_register_static (G_TYPE_OBJECT, "Theme", &g_define_type_info, 0);
		g_once_init_leave (&theme_type_id__volatile, theme_type_id);
	}
	return theme_type_id__volatile;
}


static void _vala_ClutterPoint_free (ClutterPoint* self) {
#line 378 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_boxed_free (clutter_point_get_type (), self);
#line 2802 "game-view.c"
}


TileActor* tile_actor_construct (GType object_type, Tile* tile, ClutterImage* texture, gint size) {
	TileActor * self = NULL;
	Tile* _tmp0_ = NULL;
	Tile* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	ClutterImage* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	ClutterPoint* _tmp9_ = NULL;
	ClutterPoint* _tmp10_ = NULL;
#line 369 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (tile != NULL, NULL);
#line 369 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (texture != NULL, NULL);
#line 369 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = (TileActor*) g_object_new (object_type, NULL);
#line 371 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = tile;
#line 371 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 371 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->tile);
#line 371 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->tile = _tmp1_;
#line 372 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 180);
#line 373 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = size;
#line 373 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = size;
#line 373 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp2_, (gfloat) _tmp3_);
#line 374 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = texture;
#line 374 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_content ((ClutterActor*) self, (ClutterContent*) _tmp4_);
#line 376 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
#line 378 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp5_, NULL);
#line 378 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 378 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 378 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_->x = 0.5f;
#line 378 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__vala_ClutterPoint_free0 (_tmp7_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp8_, NULL);
#line 379 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = _tmp9_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_->y = 0.5f;
#line 379 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__vala_ClutterPoint_free0 (_tmp10_);
#line 369 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return self;
#line 2869 "game-view.c"
}


TileActor* tile_actor_new (Tile* tile, ClutterImage* texture, gint size) {
#line 369 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return tile_actor_construct (TYPE_TILE_ACTOR, tile, texture, size);
#line 2876 "game-view.c"
}


static void _tile_actor_hide_tile_cb_clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
#line 390 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile_actor_hide_tile_cb ((TileActor*) self);
#line 2883 "game-view.c"
}


void tile_actor_animate_out (TileActor* self) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 386 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_LINEAR);
#line 387 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
#line 388 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_scale ((ClutterActor*) self, 2.0, 2.0);
#line 389 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 390 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) _tile_actor_hide_tile_cb_clutter_actor_transitions_completed, self, 0);
#line 2900 "game-view.c"
}


static void tile_actor_hide_tile_cb (TileActor* self) {
#line 393 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 395 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_hide ((ClutterActor*) self);
#line 2909 "game-view.c"
}


void tile_actor_animate_to (TileActor* self, gdouble new_x, gdouble new_y, gboolean is_zealous) {
	ClutterAnimationMode _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ClutterAnimationMode anim_mode = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
#line 399 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 401 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = is_zealous;
#line 401 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp1_) {
#line 401 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp0_ = CLUTTER_EASE_OUT_BOUNCE;
#line 2927 "game-view.c"
	} else {
#line 401 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		_tmp0_ = CLUTTER_EASE_OUT_QUAD;
#line 2931 "game-view.c"
	}
#line 401 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	anim_mode = _tmp0_;
#line 402 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, anim_mode);
#line 403 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 500);
#line 404 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = new_x;
#line 404 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = new_y;
#line 404 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_position ((ClutterActor*) self, (gfloat) _tmp2_, (gfloat) _tmp3_);
#line 2945 "game-view.c"
}


static void tile_actor_class_init (TileActorClass * klass) {
#line 364 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	tile_actor_parent_class = g_type_class_peek_parent (klass);
#line 364 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = tile_actor_finalize;
#line 2954 "game-view.c"
}


static void tile_actor_instance_init (TileActor * self) {
}


static void tile_actor_finalize (GObject* obj) {
	TileActor * self;
#line 364 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE_ACTOR, TileActor);
#line 367 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->tile);
#line 364 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (tile_actor_parent_class)->finalize (obj);
#line 2970 "game-view.c"
}


/**
 *  This class defines the view of a tile. All clutter related stuff goes here
 */
GType tile_actor_get_type (void) {
	static volatile gsize tile_actor_type_id__volatile = 0;
	if (g_once_init_enter (&tile_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TileActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TileActor), 0, (GInstanceInitFunc) tile_actor_instance_init, NULL };
		GType tile_actor_type_id;
		tile_actor_type_id = g_type_register_static (clutter_actor_get_type (), "TileActor", &g_define_type_info, 0);
		g_once_init_leave (&tile_actor_type_id__volatile, tile_actor_type_id);
	}
	return tile_actor_type_id__volatile;
}


CursorActor* cursor_actor_construct (GType object_type, ClutterContent* texture, gint size) {
	CursorActor * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	ClutterContent* _tmp2_ = NULL;
	ClutterPoint* _tmp3_ = NULL;
	ClutterPoint* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
#line 410 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_val_if_fail (texture != NULL, NULL);
#line 410 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = (CursorActor*) g_object_new (object_type, NULL);
#line 412 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 180);
#line 413 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = size;
#line 413 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = size;
#line 413 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_size ((ClutterActor*) self, (gfloat) _tmp0_, (gfloat) _tmp1_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = texture;
#line 414 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_content ((ClutterActor*) self, _tmp2_);
#line 416 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_content_gravity ((ClutterActor*) self, CLUTTER_CONTENT_GRAVITY_CENTER);
#line 418 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp3_, NULL);
#line 418 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_->x = 0.5f;
#line 418 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__vala_ClutterPoint_free0 (_tmp5_);
#line 419 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp6_, NULL);
#line 419 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 419 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = _tmp7_;
#line 419 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_->y = 0.5f;
#line 419 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__vala_ClutterPoint_free0 (_tmp8_);
#line 410 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return self;
#line 3040 "game-view.c"
}


CursorActor* cursor_actor_new (ClutterContent* texture, gint size) {
#line 410 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return cursor_actor_construct (TYPE_CURSOR_ACTOR, texture, size);
#line 3047 "game-view.c"
}


static void cursor_actor_class_init (CursorActorClass * klass) {
#line 408 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	cursor_actor_parent_class = g_type_class_peek_parent (klass);
#line 3054 "game-view.c"
}


static void cursor_actor_instance_init (CursorActor * self) {
}


GType cursor_actor_get_type (void) {
	static volatile gsize cursor_actor_type_id__volatile = 0;
	if (g_once_init_enter (&cursor_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CursorActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cursor_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CursorActor), 0, (GInstanceInitFunc) cursor_actor_instance_init, NULL };
		GType cursor_actor_type_id;
		cursor_actor_type_id = g_type_register_static (clutter_actor_get_type (), "CursorActor", &g_define_type_info, 0);
		g_once_init_leave (&cursor_actor_type_id__volatile, cursor_actor_type_id);
	}
	return cursor_actor_type_id__volatile;
}


ScoreActor* score_actor_construct (GType object_type, gint game_size, gdouble width, gdouble height) {
	ScoreActor * self = NULL;
	ClutterText* _tmp0_ = NULL;
	ClutterText* _tmp1_ = NULL;
	ClutterColor _tmp2_ = {0};
	ClutterText* _tmp3_ = NULL;
	ClutterPoint* _tmp4_ = NULL;
	ClutterPoint* _tmp5_ = NULL;
	ClutterPoint* _tmp6_ = NULL;
	ClutterPoint* _tmp7_ = NULL;
	ClutterPoint* _tmp8_ = NULL;
	ClutterPoint* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gint _tmp12_ = 0;
#line 433 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = (ScoreActor*) g_object_new (object_type, NULL);
#line 435 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = (ClutterText*) clutter_text_new ();
#line 435 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_ref_sink (_tmp0_);
#line 435 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->label);
#line 435 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->label = _tmp0_;
#line 436 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = self->priv->label;
#line 436 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_color_from_string (&_tmp2_, "rgba(255, 255, 255, 255)");
#line 436 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_text_set_color (_tmp1_, &_tmp2_);
#line 438 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = self->priv->label;
#line 438 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp3_);
#line 440 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp4_, NULL);
#line 440 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_->x = 0.5f;
#line 440 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__vala_ClutterPoint_free0 (_tmp6_);
#line 441 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_object_get ((ClutterActor*) self, "pivot-point", &_tmp7_, NULL);
#line 441 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = _tmp7_;
#line 441 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 441 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_->y = 0.5f;
#line 441 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__vala_ClutterPoint_free0 (_tmp9_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = width;
#line 443 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->scene_width = (gfloat) _tmp10_;
#line 444 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = height;
#line 444 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->scene_height = (gfloat) _tmp11_;
#line 445 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp12_ = game_size;
#line 445 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv->game_size = _tmp12_;
#line 433 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return self;
#line 3143 "game-view.c"
}


ScoreActor* score_actor_new (gint game_size, gdouble width, gdouble height) {
#line 433 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	return score_actor_construct (TYPE_SCORE_ACTOR, game_size, width, height);
#line 3150 "game-view.c"
}


static void __lambda4_ (ScoreActor* self) {
#line 465 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_destroy ((ClutterActor*) self);
#line 3157 "game-view.c"
}


static void ___lambda4__clutter_actor_transitions_completed (ClutterActor* _sender, gpointer self) {
#line 465 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	__lambda4_ ((ScoreActor*) self);
#line 3164 "game-view.c"
}


void score_actor_animate_score (ScoreActor* self, gint points) {
	gint _tmp0_ = 0;
	ClutterText* _tmp1_ = NULL;
	ClutterText* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
#line 448 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 450 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = points;
#line 450 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	if (_tmp0_ <= 0) {
#line 451 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
		return;
#line 3185 "game-view.c"
	}
#line 453 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = self->priv->label;
#line 453 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_text_set_font_name (_tmp1_, "Bitstrem Vera Sans Bold 30");
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = self->priv->label;
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = points;
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = g_strconcat ("+", _tmp5_, NULL);
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_text_set_text (_tmp2_, _tmp7_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_free0 (_tmp7_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_free0 (_tmp5_);
#line 458 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
#line 459 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_z_position ((ClutterActor*) self, 0.f);
#line 461 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_SINE);
#line 462 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 600);
#line 463 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_z_position ((ClutterActor*) self, 500.f);
#line 464 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 0);
#line 465 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_signal_connect_object ((ClutterActor*) self, "transitions-completed", (GCallback) ___lambda4__clutter_actor_transitions_completed, self, 0);
#line 3223 "game-view.c"
}


void score_actor_animate_final_score (ScoreActor* self, guint points) {
	ClutterText* _tmp0_ = NULL;
	gchar* points_label = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gchar* _tmp4_ = NULL;
	ClutterText* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	ClutterText* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
#line 468 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 470 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp0_ = self->priv->label;
#line 470 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_text_set_font_name (_tmp0_, "Bitstrem Vera Sans 40");
#line 471 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp1_ = points;
#line 471 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp2_ = ngettext ("%u point", "%u points", (gulong) _tmp1_);
#line 471 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp3_ = points;
#line 471 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp4_ = g_strdup_printf (_tmp2_, _tmp3_);
#line 471 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	points_label = _tmp4_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp5_ = self->priv->label;
#line 473 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp6_ = _ ("Game Over!");
#line 473 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp7_ = g_strdup_printf ("<b>%s</b>\n%s", _tmp6_, points_label);
#line 473 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp8_ = _tmp7_;
#line 473 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_text_set_markup (_tmp5_, _tmp8_);
#line 473 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_free0 (_tmp8_);
#line 474 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp9_ = self->priv->label;
#line 474 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_text_set_line_alignment (_tmp9_, PANGO_ALIGN_CENTER);
#line 478 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
#line 479 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp10_ = self->priv->game_size;
#line 479 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_z_position ((ClutterActor*) self, (-300.f) + (_tmp10_ * 100));
#line 481 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_ELASTIC);
#line 482 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_easing_duration ((ClutterActor*) self, (guint) 2000);
#line 483 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_tmp11_ = self->priv->game_size;
#line 483 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_z_position ((ClutterActor*) self, (gfloat) (-200 + (_tmp11_ * 150)));
#line 484 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	clutter_actor_set_opacity ((ClutterActor*) self, (guint8) 255);
#line 468 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_free0 (points_label);
#line 3291 "game-view.c"
}


static void score_actor_class_init (ScoreActorClass * klass) {
#line 426 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	score_actor_parent_class = g_type_class_peek_parent (klass);
#line 426 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (ScoreActorPrivate));
#line 426 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = score_actor_finalize;
#line 3302 "game-view.c"
}


static void score_actor_instance_init (ScoreActor * self) {
#line 426 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self->priv = SCORE_ACTOR_GET_PRIVATE (self);
#line 3309 "game-view.c"
}


static void score_actor_finalize (GObject* obj) {
	ScoreActor * self;
#line 426 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_ACTOR, ScoreActor);
#line 428 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	_g_object_unref0 (self->priv->label);
#line 426 "/home/mcatanzaro/jhbuild/checkout/swell-foop/src/game-view.vala"
	G_OBJECT_CLASS (score_actor_parent_class)->finalize (obj);
#line 3321 "game-view.c"
}


/**
 *  This class defines the view of a score. All clutter related stuff goes here
 */
GType score_actor_get_type (void) {
	static volatile gsize score_actor_type_id__volatile = 0;
	if (g_once_init_enter (&score_actor_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ScoreActorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_actor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreActor), 0, (GInstanceInitFunc) score_actor_instance_init, NULL };
		GType score_actor_type_id;
		score_actor_type_id = g_type_register_static (clutter_group_get_type (), "ScoreActor", &g_define_type_info, 0);
		g_once_init_leave (&score_actor_type_id__volatile, score_actor_type_id);
	}
	return score_actor_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



