/*----- PROTECTED REGION ID(TestCppTango1022::DynAttrUtils.cpp) ENABLED START -----*/
/* clang-format on */
//=============================================================================
//
// file :        TestCppTango1022DynAttrUtils.cpp
//
// description : Dynamic attributes utilities file for the TestCppTango1022 class
//
//
//
// This file is part of Tango device class.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// Copyright (C): 2022
//                European Synchrotron Radiation Facility
//                BP 220, Grenoble 38043
//                France
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================


#include "TestCppTango1022.h"
#include "TestCppTango1022Class.h"
/* clang-format off */
/*----- PROTECTED REGION END -----*/	//	TestCppTango1022::DynAttrUtils.cpp

//================================================================
//  Attributes managed is:
//================================================================
//  DoubleAttr  |  Tango::DevDouble	Scalar
//================================================================

//	For compatibility reason, this file (TestCppTango1022DynAttrUtils)
//	manage also the dynamic command utilities.
//================================================================
//  The following table gives the correspondence
//  between command and method names.
//
//  Command name  |  Method name
//================================================================
//================================================================

namespace TestCppTango1022_ns
{
//=============================================================
//	Add/Remove dynamic attribute methods
//=============================================================

//--------------------------------------------------------
/**
 *	Add a DoubleAttr dynamic attribute.
 *
 *  parameter attname: attribute name to be created and added.
 */
//--------------------------------------------------------
void TestCppTango1022::add_DoubleAttr_dynamic_attribute(std::string attname)
{
	//	Attribute : DoubleAttr
	DoubleAttrAttrib	*doubleattr = new DoubleAttrAttrib(attname);
	Tango::UserDefaultAttrProp	doubleattr_prop;
	//	description	not set for DoubleAttr
	//	label	not set for DoubleAttr
	//	unit	not set for DoubleAttr
	//	standard_unit	not set for DoubleAttr
	//	display_unit	not set for DoubleAttr
	//	format	not set for DoubleAttr
	//	max_value	not set for DoubleAttr
	//	min_value	not set for DoubleAttr
	//	max_alarm	not set for DoubleAttr
	//	min_alarm	not set for DoubleAttr
	//	max_warning	not set for DoubleAttr
	//	min_warning	not set for DoubleAttr
	//	delta_t	not set for DoubleAttr
	//	delta_val	not set for DoubleAttr
	/*----- PROTECTED REGION ID(TestCppTango1022::att_DoubleAttr_dynamic_attribute) ENABLED START -----*/
	/* clang-format on */
	//	Add your own code
	/* clang-format off */
	/*----- PROTECTED REGION END -----*/	//	TestCppTango1022::att_DoubleAttr_dynamic_attribute
	doubleattr->set_default_properties(doubleattr_prop);
	//	Not Polled
	doubleattr->set_disp_level(Tango::OPERATOR);
	//	Not Memorized
	DoubleAttr_data.insert(make_pair(attname, 0.0));
	add_attribute(doubleattr);
}
//--------------------------------------------------------
/**
 *	remove a DoubleAttr dynamic attribute.
 *
 *  parameter attname: attribute name to be removed.
 */
//--------------------------------------------------------
void TestCppTango1022::remove_DoubleAttr_dynamic_attribute(std::string attname)
{
	remove_attribute(attname, true, Tango::Util::instance()->_UseDb);
	std::map<std::string,Tango::DevDouble>::iterator ite;
	if ((ite=DoubleAttr_data.find(attname))!=DoubleAttr_data.end())
	{
		/*----- PROTECTED REGION ID(TestCppTango1022::remove_DoubleAttr_dynamic_attribute) ENABLED START -----*/
		/* clang-format on */
		//	Add your own code
		/* clang-format off */
		/*----- PROTECTED REGION END -----*/	//	TestCppTango1022::remove_DoubleAttr_dynamic_attribute
		DoubleAttr_data.erase(ite);
	}
}


//============================================================
//	Tool methods to get pointer on attribute data buffer
//============================================================
//--------------------------------------------------------
/**
 *	Return a pointer on DoubleAttr data.
 *
 *  parameter attname: the specified attribute name.
 */
//--------------------------------------------------------
Tango::DevDouble *TestCppTango1022::get_DoubleAttr_data_ptr(std::string &name)
{
	std::map<std::string,Tango::DevDouble>::iterator ite;
	if ((ite=DoubleAttr_data.find(name))==DoubleAttr_data.end())
	{
		TangoSys_OMemStream	tms;
		tms << "Dynamic attribute " << name << " has not been created";
		Tango::Except::throw_exception(
					(const char *)"ATTRIBUTE_NOT_FOUND",
					tms.str().c_str(),
					(const char *)"TestCppTango1022::get_DoubleAttr_data_ptr()");
	}
	return  &(ite->second);
}


//=============================================================
//	Add/Remove dynamic command methods
//=============================================================


} //	namespace
