#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-
################################################################################
##
## Copyright 2006 - 2015, Paul Beckingham, Federico Hernandez.
##
## Permission is hereby granted, free of charge, to any person obtaining a copy
## of this software and associated documentation files (the "Software"), to deal
## in the Software without restriction, including without limitation the rights
## to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
## copies of the Software, and to permit persons to whom the Software is
## furnished to do so, subject to the following conditions:
##
## The above copyright notice and this permission notice shall be included
## in all copies or substantial portions of the Software.
##
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
## OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
## THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
## LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
## OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.
##
## http://www.opensource.org/licenses/mit-license.php
##
################################################################################

import sys
import os
import unittest
# Ensure python finds the local simpletap module
sys.path.append(os.path.dirname(os.path.abspath(__file__)))

from basetest import Task, TestCase


class TestBug252(TestCase):
    def setUp(self):
        self.t = Task()

    def test_done_stop(self):
        """done should also stop a task timer"""
        command = ("add", "Timeit")
        code, out, err = self.t(command)

        # Starting the newly added task
        command = ("1", "start")
        code, out, err = self.t(command)

        notexpected = "Start deleted"
        self.assertNotIn(notexpected, out)

        # Completing the task should also stop the timer
        command = ("1", "done")
        code, out, err = self.t(command)

        # Confirm that "start" was removed
        command = ("1", "info")
        code, out, err = self.t(command)

        expected = "Start deleted"
        self.assertIn(expected, out)

        # Confirm that the timer was indeed stopped
        command = ("1", "stop")
        code, out, err = self.t.runError(command)

        expected = "Task 1 'Timeit' not started."
        self.assertIn(expected, out)
        expected = "Stopped 0 tasks."
        self.assertIn(expected, out)


if __name__ == "__main__":
    from simpletap import TAPTestRunner
    unittest.main(testRunner=TAPTestRunner())

# vim: ai sts=4 et sw=4
