#! /usr/bin/env perl
################################################################################
##
## Copyright 2010 - 2015, Göteborg Bit Factory.
##
## Permission is hereby granted, free of charge, to any person obtaining a copy
## of this software and associated documentation files (the "Software"), to deal
## in the Software without restriction, including without limitation the rights
## to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
## copies of the Software, and to permit persons to whom the Software is
## furnished to do so, subject to the following conditions:
##
## The above copyright notice and this permission notice shall be included
## in all copies or substantial portions of the Software.
##
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
## OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
## THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
## LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
## OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.
##
## http://www.opensource.org/licenses/mit-license.php
##
################################################################################

use strict;
use warnings;
use Test::More tests => 6;

# Bug #1397: existing org folder breaks init action in taskd
my $data = '1397.data';

# Running 'taskd init' twice exhibits the error.
qx{mkdir $data; chmod +x $data};
my $output = qx{../src/taskd init --data $data 2>&1};
unlike ($output, qr/^ERROR/, "'taskd init --data $data' - no errors");
ok (-d $data,                "$data exists and is a directory");
ok (-d $data.'/orgs',        "$data/orgs exists and is a directory");
ok (-f $data.'/config',      "$data/config exists and is a file");

$output = qx{../src/taskd init --data $data 2>&1};
unlike ($output, qr/^ERROR/, "'taskd init --data $data' - no errors");

# Cleanup.
qx{rm -rf $data};
ok (! -d $data, "Removed $data");

exit 0;

