'\"
'\" Generated from file 'stack\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "struct::stack" n 1\&.5\&.3 tcllib "Tcl Data Structures"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
struct::stack \- Create and manipulate stack objects
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fBstruct::stack  ?1\&.5\&.3?\fR
.sp
\fIstackName\fR \fBoption\fR ?\fIarg arg \&.\&.\&.\fR?
.sp
\fIstackName\fR \fBclear\fR
.sp
\fIstackName\fR \fBdestroy\fR
.sp
\fIstackName\fR \fBget\fR
.sp
\fIstackName\fR \fBgetr\fR
.sp
\fIstackName\fR \fBpeek\fR ?\fIcount\fR?
.sp
\fIstackName\fR \fBpeekr\fR ?\fIcount\fR?
.sp
\fIstackName\fR \fBtrim\fR ?\fInewsize\fR?
.sp
\fIstackName\fR \fBtrim*\fR ?\fInewsize\fR?
.sp
\fIstackName\fR \fBpop\fR ?\fIcount\fR?
.sp
\fIstackName\fR \fBpush\fR \fIitem\fR ?\fIitem\&.\&.\&.\fR?
.sp
\fIstackName\fR \fBsize\fR
.sp
.BE
.SH DESCRIPTION
The \fB::struct\fR namespace contains a commands for processing
finite stacks\&.
.PP
It exports a single command, \fB::struct::stack\fR\&. All functionality
provided here can be reached through a subcommand of this command\&.
.PP
\fINote:\fR As of version 1\&.3\&.3 of this package a critcl based C
implementation is available\&. This implementation however requires Tcl
8\&.4 to run\&.
.PP
The \fB::struct::stack\fR command creates a new stack object with an
associated global Tcl command whose name is \fIstackName\fR\&.  This
command may be used to invoke various operations on the stack\&.  It has
the following general form:
.TP
\fIstackName\fR \fBoption\fR ?\fIarg arg \&.\&.\&.\fR?
\fIOption\fR and the \fIarg\fRs determine the exact behavior of the
command\&.  The following commands are possible for stack objects:
.TP
\fIstackName\fR \fBclear\fR
Remove all items from the stack\&.
.TP
\fIstackName\fR \fBdestroy\fR
Destroy the stack, including its storage space and associated command\&.
.TP
\fIstackName\fR \fBget\fR
Returns the whole contents of the stack as a list, without removing
them from the stack\&.
.TP
\fIstackName\fR \fBgetr\fR
A variant of \fBget\fR, which returns the contents in reversed order\&.
.TP
\fIstackName\fR \fBpeek\fR ?\fIcount\fR?
Return the top \fIcount\fR items of the stack, without removing them from
the stack\&.  If \fIcount\fR is not specified, it defaults to 1\&.  If
\fIcount\fR is 1, the result is a simple string; otherwise, it is a
list\&.  If specified, \fIcount\fR must be greater than or equal to 1\&.
If there are not enoughs items on the stack to fulfull the request,
this command will throw an error\&.
.TP
\fIstackName\fR \fBpeekr\fR ?\fIcount\fR?
A variant of \fBpeek\fR, which returns the items in reversed order\&.
.TP
\fIstackName\fR \fBtrim\fR ?\fInewsize\fR?
Shrinks the stack to contain at most \fInewsize\fR elements and
returns a list containing the elements which were removed\&. Nothing is
done if the stack is already at the specified size, or smaller\&. In
that case the result is the empty list\&.
.TP
\fIstackName\fR \fBtrim*\fR ?\fInewsize\fR?
A variant of \fBtrim\fR which performs the shrinking, but does not
return the removed elements\&.
.TP
\fIstackName\fR \fBpop\fR ?\fIcount\fR?
Return the top \fIcount\fR items of the stack, and remove them
from the stack\&.  If \fIcount\fR is not specified, it defaults to 1\&.
If \fIcount\fR is 1, the result is a simple string; otherwise, it is a
list\&.  If specified, \fIcount\fR must be greater than or equal to 1\&.
If there are not enoughs items on the stack to fulfull the request,
this command will throw an error\&.
.TP
\fIstackName\fR \fBpush\fR \fIitem\fR ?\fIitem\&.\&.\&.\fR?
Push the \fIitem\fR or items specified onto the stack\&.  If more than
one \fIitem\fR is given, they will be pushed in the order they are
listed\&.
.TP
\fIstackName\fR \fBsize\fR
Return the number of items on the stack\&.
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIstruct :: stack\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
graph, matrix, queue, tree
.SH CATEGORY
Data structures