package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMonitoringAgentHosts invokes the cms.DescribeMonitoringAgentHosts API synchronously
func (client *Client) DescribeMonitoringAgentHosts(request *DescribeMonitoringAgentHostsRequest) (response *DescribeMonitoringAgentHostsResponse, err error) {
	response = CreateDescribeMonitoringAgentHostsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMonitoringAgentHostsWithChan invokes the cms.DescribeMonitoringAgentHosts API asynchronously
func (client *Client) DescribeMonitoringAgentHostsWithChan(request *DescribeMonitoringAgentHostsRequest) (<-chan *DescribeMonitoringAgentHostsResponse, <-chan error) {
	responseChan := make(chan *DescribeMonitoringAgentHostsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMonitoringAgentHosts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMonitoringAgentHostsWithCallback invokes the cms.DescribeMonitoringAgentHosts API asynchronously
func (client *Client) DescribeMonitoringAgentHostsWithCallback(request *DescribeMonitoringAgentHostsRequest, callback func(response *DescribeMonitoringAgentHostsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMonitoringAgentHostsResponse
		var err error
		defer close(result)
		response, err = client.DescribeMonitoringAgentHosts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMonitoringAgentHostsRequest is the request struct for api DescribeMonitoringAgentHosts
type DescribeMonitoringAgentHostsRequest struct {
	*requests.RpcRequest
	SerialNumbers    string           `position:"Query" name:"SerialNumbers"`
	PageNumber       requests.Integer `position:"Query" name:"PageNumber"`
	HostName         string           `position:"Query" name:"HostName"`
	InstanceRegionId string           `position:"Query" name:"InstanceRegionId"`
	PageSize         requests.Integer `position:"Query" name:"PageSize"`
	AliyunHost       requests.Boolean `position:"Query" name:"AliyunHost"`
	KeyWord          string           `position:"Query" name:"KeyWord"`
	InstanceIds      string           `position:"Query" name:"InstanceIds"`
	Status           string           `position:"Query" name:"Status"`
}

// DescribeMonitoringAgentHostsResponse is the response struct for api DescribeMonitoringAgentHosts
type DescribeMonitoringAgentHostsResponse struct {
	*responses.BaseResponse
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
	Success    bool   `json:"Success" xml:"Success"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageTotal  int    `json:"PageTotal" xml:"PageTotal"`
	Total      int    `json:"Total" xml:"Total"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	Hosts      Hosts  `json:"Hosts" xml:"Hosts"`
}

// CreateDescribeMonitoringAgentHostsRequest creates a request to invoke DescribeMonitoringAgentHosts API
func CreateDescribeMonitoringAgentHostsRequest() (request *DescribeMonitoringAgentHostsRequest) {
	request = &DescribeMonitoringAgentHostsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "DescribeMonitoringAgentHosts", "cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeMonitoringAgentHostsResponse creates a response to parse from DescribeMonitoringAgentHosts response
func CreateDescribeMonitoringAgentHostsResponse() (response *DescribeMonitoringAgentHostsResponse) {
	response = &DescribeMonitoringAgentHostsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
