// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/asset.proto

package v2

import (
	bytes "bytes"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	github_com_golang_protobuf_proto "github.com/golang/protobuf/proto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Asset defines an asset and optionally a list of assets (builds) that agents
// install as a dependency for a check, handler, mutator, etc.
type Asset struct {
	// URL is the location of the asset
	URL string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Sha512 is the SHA-512 checksum of the asset
	Sha512 string `protobuf:"bytes,3,opt,name=sha512,proto3" json:"sha512,omitempty"`
	// Filters are a collection of sensu queries, used by the system to
	// determine if the asset should be installed. If more than one filter is
	// present the queries are joined by the "AND" operator.
	Filters []string `protobuf:"bytes,5,rep,name=filters,proto3" json:"filters"`
	// AssetBuilds are a list of one or more assets to install.
	Builds []*AssetBuild `protobuf:"bytes,6,rep,name=builds,proto3" json:"builds"`
	// Metadata contains the name, namespace, labels and annotations of the
	// asset
	ObjectMeta `protobuf:"bytes,8,opt,name=metadata,proto3,embedded=metadata" json:"metadata,omitempty"`
	// Headers is a collection of key/value string pairs used as HTTP headers
	// for asset retrieval.
	Headers              map[string]string `protobuf:"bytes,9,rep,name=headers,proto3" json:"headers" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Asset) Reset()         { *m = Asset{} }
func (m *Asset) String() string { return proto.CompactTextString(m) }
func (*Asset) ProtoMessage()    {}
func (*Asset) Descriptor() ([]byte, []int) {
	return fileDescriptor_d39ff00b5fd89710, []int{0}
}
func (m *Asset) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Asset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Asset.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Asset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset.Merge(m, src)
}
func (m *Asset) XXX_Size() int {
	return m.Size()
}
func (m *Asset) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset.DiscardUnknown(m)
}

var xxx_messageInfo_Asset proto.InternalMessageInfo

// AssetBuild defines an individual asset that an asset can install as a
// dependency for a check, handler, mutator, etc.
type AssetBuild struct {
	// URL is the location of the asset
	URL string `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	// Sha512 is the SHA-512 checksum of the asset
	Sha512 string `protobuf:"bytes,3,opt,name=sha512,proto3" json:"sha512,omitempty"`
	// Filters are a collection of sensu queries, used by the system to
	// determine if the asset should be installed. If more than one filter is
	// present the queries are joined by the "AND" operator.
	Filters []string `protobuf:"bytes,5,rep,name=filters,proto3" json:"filters"`
	// Headers is a collection of key/value string pairs used as HTTP headers
	// for asset retrieval.
	Headers              map[string]string `protobuf:"bytes,9,rep,name=headers,proto3" json:"headers" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *AssetBuild) Reset()         { *m = AssetBuild{} }
func (m *AssetBuild) String() string { return proto.CompactTextString(m) }
func (*AssetBuild) ProtoMessage()    {}
func (*AssetBuild) Descriptor() ([]byte, []int) {
	return fileDescriptor_d39ff00b5fd89710, []int{1}
}
func (m *AssetBuild) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssetBuild) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssetBuild.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssetBuild) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssetBuild.Merge(m, src)
}
func (m *AssetBuild) XXX_Size() int {
	return m.Size()
}
func (m *AssetBuild) XXX_DiscardUnknown() {
	xxx_messageInfo_AssetBuild.DiscardUnknown(m)
}

var xxx_messageInfo_AssetBuild proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Asset)(nil), "sensu.core.v2.Asset")
	proto.RegisterMapType((map[string]string)(nil), "sensu.core.v2.Asset.HeadersEntry")
	proto.RegisterType((*AssetBuild)(nil), "sensu.core.v2.AssetBuild")
	proto.RegisterMapType((map[string]string)(nil), "sensu.core.v2.AssetBuild.HeadersEntry")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/asset.proto", fileDescriptor_d39ff00b5fd89710)
}

var fileDescriptor_d39ff00b5fd89710 = []byte{
	// 433 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x32, 0x4c, 0xcf, 0x2c, 0xc9,
	0x28, 0x4d, 0xd2, 0x4b, 0xce, 0xcf, 0xd5, 0x2f, 0x4e, 0xcd, 0x2b, 0x2e, 0x85, 0x90, 0xba, 0xe9,
	0xf9, 0xfa, 0x89, 0x05, 0x99, 0xfa, 0xc9, 0xf9, 0x45, 0xa9, 0xfa, 0x65, 0x46, 0xfa, 0x89, 0xc5,
	0xc5, 0xa9, 0x25, 0x7a, 0x05, 0x45, 0xf9, 0x25, 0xf9, 0x42, 0xbc, 0x60, 0x15, 0x7a, 0x20, 0x29,
	0xbd, 0x32, 0x23, 0x29, 0x13, 0x24, 0x13, 0xd2, 0xf3, 0xd3, 0xf3, 0xf5, 0xc1, 0xaa, 0x92, 0x4a,
	0xd3, 0x1c, 0xca, 0x0c, 0xf5, 0x8c, 0xf5, 0x0c, 0xc1, 0x82, 0x60, 0x31, 0x30, 0x0b, 0x62, 0x88,
	0x94, 0x01, 0x71, 0xf6, 0xe6, 0xa6, 0x96, 0x24, 0x42, 0x74, 0x28, 0xb5, 0x33, 0x73, 0xb1, 0x3a,
	0x82, 0x9c, 0x21, 0x24, 0xc9, 0xc5, 0x5c, 0x5a, 0x94, 0x23, 0xc1, 0xa4, 0xc0, 0xa8, 0xc1, 0xe9,
	0xc4, 0xfe, 0xe8, 0x9e, 0x3c, 0x73, 0x68, 0x90, 0x4f, 0x10, 0x48, 0x4c, 0x48, 0x8c, 0x8b, 0xad,
	0x38, 0x23, 0xd1, 0xd4, 0xd0, 0x48, 0x82, 0x19, 0x24, 0x1b, 0x04, 0xe5, 0x09, 0xa9, 0x72, 0xb1,
	0xa7, 0x65, 0xe6, 0x94, 0xa4, 0x16, 0x15, 0x4b, 0xb0, 0x2a, 0x30, 0x6b, 0x70, 0x3a, 0x71, 0xbf,
	0xba, 0x27, 0x0f, 0x13, 0x0a, 0x82, 0x31, 0x84, 0x6c, 0xb9, 0xd8, 0x92, 0x4a, 0x33, 0x73, 0x52,
	0x8a, 0x25, 0xd8, 0x14, 0x98, 0x35, 0xb8, 0x8d, 0x24, 0xf5, 0x50, 0xfc, 0xaa, 0x07, 0xb6, 0xdf,
	0x09, 0xa4, 0xc2, 0x89, 0xeb, 0xd5, 0x3d, 0x79, 0xa8, 0xe2, 0x20, 0x28, 0x2d, 0x14, 0xca, 0xc5,
	0x01, 0x72, 0x70, 0x4a, 0x62, 0x49, 0xa2, 0x04, 0x87, 0x02, 0x23, 0x16, 0x03, 0xfc, 0x93, 0xb2,
	0x52, 0x93, 0x4b, 0x7c, 0x53, 0x4b, 0x12, 0x9d, 0xe4, 0x4e, 0xdc, 0x93, 0x67, 0xb8, 0x70, 0x4f,
	0x9e, 0xf1, 0xd5, 0x3d, 0x79, 0x21, 0x98, 0x36, 0x9d, 0xfc, 0xdc, 0xcc, 0x92, 0xd4, 0xdc, 0x82,
	0x92, 0xca, 0x20, 0xb8, 0x51, 0x42, 0x1e, 0x5c, 0xec, 0x19, 0xa9, 0x89, 0x29, 0x20, 0xc7, 0x73,
	0x82, 0x9d, 0xa5, 0x88, 0xcd, 0x59, 0x7a, 0x1e, 0x10, 0x35, 0xae, 0x79, 0x25, 0x45, 0x95, 0x10,
	0xff, 0x41, 0x75, 0x05, 0xc1, 0x18, 0x52, 0x56, 0x5c, 0x3c, 0xc8, 0xaa, 0x84, 0x04, 0xb8, 0x98,
	0xb3, 0x53, 0x2b, 0x25, 0x18, 0xc1, 0x61, 0x05, 0x62, 0x0a, 0x89, 0x70, 0xb1, 0x96, 0x25, 0xe6,
	0x94, 0xa6, 0x42, 0x42, 0x37, 0x08, 0xc2, 0xb1, 0x62, 0xb2, 0x60, 0xb4, 0xe2, 0xe8, 0x58, 0x20,
	0xcf, 0xb0, 0x62, 0x81, 0x3c, 0xa3, 0xd2, 0x6f, 0x46, 0x2e, 0x2e, 0x44, 0x48, 0xd0, 0x30, 0x3a,
	0x7c, 0xd1, 0x3d, 0xae, 0x86, 0x33, 0x3e, 0xe8, 0xe6, 0x7b, 0x27, 0x85, 0x1f, 0x0f, 0xe5, 0x18,
	0x57, 0x3c, 0x92, 0x63, 0xdc, 0xf1, 0x48, 0x8e, 0xf1, 0xc4, 0x23, 0x39, 0xc6, 0x0b, 0x8f, 0xe4,
	0x18, 0x1f, 0x3c, 0x92, 0x63, 0x9c, 0xf1, 0x58, 0x8e, 0x21, 0x8a, 0xa9, 0xcc, 0x28, 0x89, 0x0d,
	0x9c, 0x60, 0x8d, 0x01, 0x01, 0x00, 0x00, 0xff, 0xff, 0x8b, 0x79, 0xce, 0x68, 0x5c, 0x03, 0x00,
	0x00,
}

func (this *Asset) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Asset)
	if !ok {
		that2, ok := that.(Asset)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.URL != that1.URL {
		return false
	}
	if this.Sha512 != that1.Sha512 {
		return false
	}
	if len(this.Filters) != len(that1.Filters) {
		return false
	}
	for i := range this.Filters {
		if this.Filters[i] != that1.Filters[i] {
			return false
		}
	}
	if len(this.Builds) != len(that1.Builds) {
		return false
	}
	for i := range this.Builds {
		if !this.Builds[i].Equal(that1.Builds[i]) {
			return false
		}
	}
	if !this.ObjectMeta.Equal(&that1.ObjectMeta) {
		return false
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if this.Headers[i] != that1.Headers[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *AssetBuild) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AssetBuild)
	if !ok {
		that2, ok := that.(AssetBuild)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.URL != that1.URL {
		return false
	}
	if this.Sha512 != that1.Sha512 {
		return false
	}
	if len(this.Filters) != len(that1.Filters) {
		return false
	}
	for i := range this.Filters {
		if this.Filters[i] != that1.Filters[i] {
			return false
		}
	}
	if len(this.Headers) != len(that1.Headers) {
		return false
	}
	for i := range this.Headers {
		if this.Headers[i] != that1.Headers[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

type AssetFace interface {
	Proto() github_com_golang_protobuf_proto.Message
	GetURL() string
	GetSha512() string
	GetFilters() []string
	GetBuilds() []*AssetBuild
	GetObjectMeta() ObjectMeta
	GetHeaders() map[string]string
}

func (this *Asset) Proto() github_com_golang_protobuf_proto.Message {
	return this
}

func (this *Asset) TestProto() github_com_golang_protobuf_proto.Message {
	return NewAssetFromFace(this)
}

func (this *Asset) GetURL() string {
	return this.URL
}

func (this *Asset) GetSha512() string {
	return this.Sha512
}

func (this *Asset) GetFilters() []string {
	return this.Filters
}

func (this *Asset) GetBuilds() []*AssetBuild {
	return this.Builds
}

func (this *Asset) GetObjectMeta() ObjectMeta {
	return this.ObjectMeta
}

func (this *Asset) GetHeaders() map[string]string {
	return this.Headers
}

func NewAssetFromFace(that AssetFace) *Asset {
	this := &Asset{}
	this.URL = that.GetURL()
	this.Sha512 = that.GetSha512()
	this.Filters = that.GetFilters()
	this.Builds = that.GetBuilds()
	this.ObjectMeta = that.GetObjectMeta()
	this.Headers = that.GetHeaders()
	return this
}

type AssetBuildFace interface {
	Proto() github_com_golang_protobuf_proto.Message
	GetURL() string
	GetSha512() string
	GetFilters() []string
	GetHeaders() map[string]string
}

func (this *AssetBuild) Proto() github_com_golang_protobuf_proto.Message {
	return this
}

func (this *AssetBuild) TestProto() github_com_golang_protobuf_proto.Message {
	return NewAssetBuildFromFace(this)
}

func (this *AssetBuild) GetURL() string {
	return this.URL
}

func (this *AssetBuild) GetSha512() string {
	return this.Sha512
}

func (this *AssetBuild) GetFilters() []string {
	return this.Filters
}

func (this *AssetBuild) GetHeaders() map[string]string {
	return this.Headers
}

func NewAssetBuildFromFace(that AssetBuildFace) *AssetBuild {
	this := &AssetBuild{}
	this.URL = that.GetURL()
	this.Sha512 = that.GetSha512()
	this.Filters = that.GetFilters()
	this.Headers = that.GetHeaders()
	return this
}

func (m *Asset) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Asset) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Asset) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Headers) > 0 {
		for k := range m.Headers {
			v := m.Headers[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAsset(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAsset(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAsset(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintAsset(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x42
	if len(m.Builds) > 0 {
		for iNdEx := len(m.Builds) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Builds[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintAsset(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.Filters) > 0 {
		for iNdEx := len(m.Filters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Filters[iNdEx])
			copy(dAtA[i:], m.Filters[iNdEx])
			i = encodeVarintAsset(dAtA, i, uint64(len(m.Filters[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Sha512) > 0 {
		i -= len(m.Sha512)
		copy(dAtA[i:], m.Sha512)
		i = encodeVarintAsset(dAtA, i, uint64(len(m.Sha512)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.URL) > 0 {
		i -= len(m.URL)
		copy(dAtA[i:], m.URL)
		i = encodeVarintAsset(dAtA, i, uint64(len(m.URL)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func (m *AssetBuild) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssetBuild) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssetBuild) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Headers) > 0 {
		for k := range m.Headers {
			v := m.Headers[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintAsset(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintAsset(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintAsset(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x4a
		}
	}
	if len(m.Filters) > 0 {
		for iNdEx := len(m.Filters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Filters[iNdEx])
			copy(dAtA[i:], m.Filters[iNdEx])
			i = encodeVarintAsset(dAtA, i, uint64(len(m.Filters[iNdEx])))
			i--
			dAtA[i] = 0x2a
		}
	}
	if len(m.Sha512) > 0 {
		i -= len(m.Sha512)
		copy(dAtA[i:], m.Sha512)
		i = encodeVarintAsset(dAtA, i, uint64(len(m.Sha512)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.URL) > 0 {
		i -= len(m.URL)
		copy(dAtA[i:], m.URL)
		i = encodeVarintAsset(dAtA, i, uint64(len(m.URL)))
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}

func encodeVarintAsset(dAtA []byte, offset int, v uint64) int {
	offset -= sovAsset(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedAsset(r randyAsset, easy bool) *Asset {
	this := &Asset{}
	this.URL = string(randStringAsset(r))
	this.Sha512 = string(randStringAsset(r))
	v1 := r.Intn(10)
	this.Filters = make([]string, v1)
	for i := 0; i < v1; i++ {
		this.Filters[i] = string(randStringAsset(r))
	}
	if r.Intn(5) != 0 {
		v2 := r.Intn(5)
		this.Builds = make([]*AssetBuild, v2)
		for i := 0; i < v2; i++ {
			this.Builds[i] = NewPopulatedAssetBuild(r, easy)
		}
	}
	v3 := NewPopulatedObjectMeta(r, easy)
	this.ObjectMeta = *v3
	if r.Intn(5) != 0 {
		v4 := r.Intn(10)
		this.Headers = make(map[string]string)
		for i := 0; i < v4; i++ {
			this.Headers[randStringAsset(r)] = randStringAsset(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAsset(r, 10)
	}
	return this
}

func NewPopulatedAssetBuild(r randyAsset, easy bool) *AssetBuild {
	this := &AssetBuild{}
	this.URL = string(randStringAsset(r))
	this.Sha512 = string(randStringAsset(r))
	v5 := r.Intn(10)
	this.Filters = make([]string, v5)
	for i := 0; i < v5; i++ {
		this.Filters[i] = string(randStringAsset(r))
	}
	if r.Intn(5) != 0 {
		v6 := r.Intn(10)
		this.Headers = make(map[string]string)
		for i := 0; i < v6; i++ {
			this.Headers[randStringAsset(r)] = randStringAsset(r)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedAsset(r, 10)
	}
	return this
}

type randyAsset interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneAsset(r randyAsset) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringAsset(r randyAsset) string {
	v7 := r.Intn(100)
	tmps := make([]rune, v7)
	for i := 0; i < v7; i++ {
		tmps[i] = randUTF8RuneAsset(r)
	}
	return string(tmps)
}
func randUnrecognizedAsset(r randyAsset, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldAsset(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldAsset(dAtA []byte, r randyAsset, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateAsset(dAtA, uint64(key))
		v8 := r.Int63()
		if r.Intn(2) == 0 {
			v8 *= -1
		}
		dAtA = encodeVarintPopulateAsset(dAtA, uint64(v8))
	case 1:
		dAtA = encodeVarintPopulateAsset(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateAsset(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateAsset(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateAsset(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateAsset(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Asset) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.URL)
	if l > 0 {
		n += 1 + l + sovAsset(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovAsset(uint64(l))
	}
	if len(m.Filters) > 0 {
		for _, s := range m.Filters {
			l = len(s)
			n += 1 + l + sovAsset(uint64(l))
		}
	}
	if len(m.Builds) > 0 {
		for _, e := range m.Builds {
			l = e.Size()
			n += 1 + l + sovAsset(uint64(l))
		}
	}
	l = m.ObjectMeta.Size()
	n += 1 + l + sovAsset(uint64(l))
	if len(m.Headers) > 0 {
		for k, v := range m.Headers {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAsset(uint64(len(k))) + 1 + len(v) + sovAsset(uint64(len(v)))
			n += mapEntrySize + 1 + sovAsset(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AssetBuild) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.URL)
	if l > 0 {
		n += 1 + l + sovAsset(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovAsset(uint64(l))
	}
	if len(m.Filters) > 0 {
		for _, s := range m.Filters {
			l = len(s)
			n += 1 + l + sovAsset(uint64(l))
		}
	}
	if len(m.Headers) > 0 {
		for k, v := range m.Headers {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovAsset(uint64(len(k))) + 1 + len(v) + sovAsset(uint64(len(v)))
			n += mapEntrySize + 1 + sovAsset(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovAsset(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozAsset(x uint64) (n int) {
	return sovAsset(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Asset) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAsset
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Asset: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Asset: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Builds", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Builds = append(m.Builds, &AssetBuild{})
			if err := m.Builds[len(m.Builds)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAsset
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAsset
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAsset
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAsset
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAsset
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAsset
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAsset
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAsset(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAsset
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Headers[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAsset(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAsset
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAsset
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssetBuild) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAsset
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssetBuild: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssetBuild: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field URL", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.URL = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Headers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAsset
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthAsset
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Headers == nil {
				m.Headers = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowAsset
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAsset
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthAsset
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthAsset
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowAsset
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthAsset
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthAsset
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipAsset(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthAsset
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Headers[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAsset(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAsset
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthAsset
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAsset(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAsset
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAsset
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthAsset
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupAsset
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthAsset
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthAsset        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAsset          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupAsset = fmt.Errorf("proto: unexpected end of group")
)
