// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: github.com/sensu/sensu-go/api/core/v2/check.proto

package v2

import (
	bytes "bytes"
	encoding_binary "encoding/binary"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	github_com_golang_protobuf_proto "github.com/golang/protobuf/proto"
	proto "github.com/golang/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// A CheckRequest represents a request to execute a check
type CheckRequest struct {
	// Config is the specification of a check.
	Config *CheckConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Assets are a list of assets required to execute check.
	Assets []Asset `protobuf:"bytes,2,rep,name=assets,proto3" json:"assets"`
	// Hooks are a list of hooks to be executed after a check.
	Hooks []HookConfig `protobuf:"bytes,3,rep,name=hooks,proto3" json:"hooks"`
	// Issued describes the time in which the check request was issued
	Issued int64 `protobuf:"varint,4,opt,name=Issued,proto3" json:"issued"`
	// HookAssets is a map of assets required to execute hooks.
	HookAssets map[string]*AssetList `protobuf:"bytes,5,rep,name=hook_assets,json=hookAssets,proto3" json:"hook_assets" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Secrets is a list of kv to be added to the env vars of a check.
	Secrets              []string `protobuf:"bytes,6,rep,name=secrets,proto3" json:"secrets,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckRequest) Reset()         { *m = CheckRequest{} }
func (m *CheckRequest) String() string { return proto.CompactTextString(m) }
func (*CheckRequest) ProtoMessage()    {}
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b843265b29f5373, []int{0}
}
func (m *CheckRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckRequest.Merge(m, src)
}
func (m *CheckRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckRequest proto.InternalMessageInfo

func (m *CheckRequest) GetConfig() *CheckConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *CheckRequest) GetAssets() []Asset {
	if m != nil {
		return m.Assets
	}
	return nil
}

func (m *CheckRequest) GetHooks() []HookConfig {
	if m != nil {
		return m.Hooks
	}
	return nil
}

func (m *CheckRequest) GetIssued() int64 {
	if m != nil {
		return m.Issued
	}
	return 0
}

func (m *CheckRequest) GetHookAssets() map[string]*AssetList {
	if m != nil {
		return m.HookAssets
	}
	return nil
}

func (m *CheckRequest) GetSecrets() []string {
	if m != nil {
		return m.Secrets
	}
	return nil
}

// An AssetList represents a list of assets for a CheckRequest.
type AssetList struct {
	// Assets are a list of assets required to execute check or hook.
	Assets               []Asset  `protobuf:"bytes,1,rep,name=assets,proto3" json:"assets"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AssetList) Reset()         { *m = AssetList{} }
func (m *AssetList) String() string { return proto.CompactTextString(m) }
func (*AssetList) ProtoMessage()    {}
func (*AssetList) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b843265b29f5373, []int{1}
}
func (m *AssetList) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *AssetList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_AssetList.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *AssetList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssetList.Merge(m, src)
}
func (m *AssetList) XXX_Size() int {
	return m.Size()
}
func (m *AssetList) XXX_DiscardUnknown() {
	xxx_messageInfo_AssetList.DiscardUnknown(m)
}

var xxx_messageInfo_AssetList proto.InternalMessageInfo

func (m *AssetList) GetAssets() []Asset {
	if m != nil {
		return m.Assets
	}
	return nil
}

// A ProxyRequests represents a request to execute a proxy check
type ProxyRequests struct {
	// EntityAttributes store serialized arbitrary JSON-encoded data to match
	// entities in the registry.
	EntityAttributes []string `protobuf:"bytes,1,rep,name=entity_attributes,json=entityAttributes,proto3" json:"entity_attributes"`
	// Splay indicates if proxy check requests should be splayed, published
	// evenly over a window of time.
	Splay bool `protobuf:"varint,2,opt,name=splay,proto3" json:"splay"`
	// SplayCoverage is the percentage used for proxy check request splay
	// calculation.
	SplayCoverage        uint32   `protobuf:"varint,3,opt,name=splay_coverage,json=splayCoverage,proto3" json:"splay_coverage"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ProxyRequests) Reset()         { *m = ProxyRequests{} }
func (m *ProxyRequests) String() string { return proto.CompactTextString(m) }
func (*ProxyRequests) ProtoMessage()    {}
func (*ProxyRequests) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b843265b29f5373, []int{2}
}
func (m *ProxyRequests) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ProxyRequests) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ProxyRequests.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ProxyRequests) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ProxyRequests.Merge(m, src)
}
func (m *ProxyRequests) XXX_Size() int {
	return m.Size()
}
func (m *ProxyRequests) XXX_DiscardUnknown() {
	xxx_messageInfo_ProxyRequests.DiscardUnknown(m)
}

var xxx_messageInfo_ProxyRequests proto.InternalMessageInfo

func (m *ProxyRequests) GetEntityAttributes() []string {
	if m != nil {
		return m.EntityAttributes
	}
	return nil
}

func (m *ProxyRequests) GetSplay() bool {
	if m != nil {
		return m.Splay
	}
	return false
}

func (m *ProxyRequests) GetSplayCoverage() uint32 {
	if m != nil {
		return m.SplayCoverage
	}
	return 0
}

// CheckConfig is the specification of a check.
type CheckConfig struct {
	// Command is the command to be executed.
	Command string `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	// Handlers are the event handler for the check (incidents and/or metrics).
	Handlers []string `protobuf:"bytes,3,rep,name=handlers,proto3" json:"handlers"`
	// HighFlapThreshold is the flap detection high threshold (% state change)
	// for the check. Sensu uses the same flap detection algorithm as Nagios.
	HighFlapThreshold uint32 `protobuf:"varint,4,opt,name=high_flap_threshold,json=highFlapThreshold,proto3" json:"high_flap_threshold"`
	// Interval is the interval, in seconds, at which the check should be run.
	Interval uint32 `protobuf:"varint,5,opt,name=interval,proto3" json:"interval"`
	// LowFlapThreshold is the flap detection low threshold (% state change) for
	// the check. Sensu uses the same flap detection algorithm as Nagios.
	LowFlapThreshold uint32 `protobuf:"varint,6,opt,name=low_flap_threshold,json=lowFlapThreshold,proto3" json:"low_flap_threshold"`
	// Publish indicates if check requests are published for the check
	Publish bool `protobuf:"varint,9,opt,name=publish,proto3" json:"publish"`
	// RuntimeAssets are a list of assets required to execute check.
	RuntimeAssets []string `protobuf:"bytes,10,rep,name=runtime_assets,json=runtimeAssets,proto3" json:"runtime_assets"`
	// Subscriptions is the list of subscribers for the check.
	Subscriptions []string `protobuf:"bytes,11,rep,name=subscriptions,proto3" json:"subscriptions"`
	// ExtendedAttributes store serialized arbitrary JSON-encoded data
	ExtendedAttributes []byte `protobuf:"bytes,12,opt,name=ExtendedAttributes,proto3" json:"-"`
	// Sources indicates the name of the entity representing an external
	// resource
	ProxyEntityName string `protobuf:"bytes,13,opt,name=proxy_entity_name,json=proxyEntityName,proto3" json:"proxy_entity_name"`
	// CheckHooks is the list of check hooks for the check
	CheckHooks []HookList `protobuf:"bytes,14,rep,name=check_hooks,json=checkHooks,proto3" json:"check_hooks"`
	// STDIN indicates if the check command accepts JSON via stdin from the
	// agent
	Stdin bool `protobuf:"varint,15,opt,name=stdin,proto3" json:"stdin"`
	// Subdue represents one or more time windows when the check should be
	// subdued.
	Subdue *TimeWindowWhen `protobuf:"bytes,16,opt,name=subdue,proto3" json:"subdue"`
	// Cron is the cron string at which the check should be run.
	Cron string `protobuf:"bytes,17,opt,name=cron,proto3" json:"cron,omitempty"`
	// TTL represents the length of time in seconds for which a check result is
	// valid.
	Ttl int64 `protobuf:"varint,18,opt,name=ttl,proto3" json:"ttl"`
	// Timeout is the timeout, in seconds, at which the check has to run
	Timeout uint32 `protobuf:"varint,19,opt,name=timeout,proto3" json:"timeout"`
	// ProxyRequests represents a request to execute a proxy check
	ProxyRequests *ProxyRequests `protobuf:"bytes,20,opt,name=proxy_requests,json=proxyRequests,proto3" json:"proxy_requests,omitempty"`
	// RoundRobin enables round-robin scheduling if set true.
	RoundRobin bool `protobuf:"varint,21,opt,name=round_robin,json=roundRobin,proto3" json:"round_robin"`
	// OutputOutputMetricFormat is the metric protocol that the check's output
	// will be expected to follow in order to be extracted.
	OutputMetricFormat string `protobuf:"bytes,22,opt,name=output_metric_format,json=outputMetricFormat,proto3" json:"output_metric_format"`
	// OutputOutputMetricHandlers is the list of event handlers that will
	// respond to metrics that have been extracted from the check.
	OutputMetricHandlers []string `protobuf:"bytes,23,rep,name=output_metric_handlers,json=outputMetricHandlers,proto3" json:"output_metric_handlers"`
	// EnvVars is the list of environment variables to set for the check's
	// execution environment.
	EnvVars []string `protobuf:"bytes,24,rep,name=env_vars,json=envVars,proto3" json:"env_vars"`
	// Metadata contains the name, namespace, labels and annotations of the
	// check
	ObjectMeta `protobuf:"bytes,26,opt,name=metadata,proto3,embedded=metadata" json:"metadata,omitempty"`
	// MaxOutputSize is the maximum size in bytes that will be stored for check
	// output. If check output is larger than MaxOutputSize, it will be
	// truncated when stored. Filters, mutators, and handlers will still have
	// access to the full check output at the time the event occurs.
	MaxOutputSize int64 `protobuf:"varint,27,opt,name=max_output_size,json=maxOutputSize,proto3" json:"max_output_size,omitempty"`
	// DiscardOutput causes agents to discard check output. No check output is
	// written to the backend, but metrics extraction is still performed.
	DiscardOutput bool `protobuf:"varint,28,opt,name=discard_output,json=discardOutput,proto3" json:"discard_output,omitempty"`
	// Secrets is the list of Sensu secrets to set for the check's
	// execution environment.
	Secrets []*Secret `protobuf:"bytes,29,rep,name=secrets,proto3" json:"secrets"`
	// OutputMetricTags is list of metric tags to apply to metrics extracted from check output.
	OutputMetricTags []*MetricTag `protobuf:"bytes,30,rep,name=output_metric_tags,json=outputMetricTags,proto3" json:"output_metric_tags,omitempty" yaml: "output_metric_tags,omitempty"`
	// Scheduler is the type of scheduler the check is scheduled by. The scheduler
	// can be "memory", "etcd", or "postgres". Scheduler is set by Sensu - any
	// setting by the user will be overridden.
	Scheduler            string   `protobuf:"bytes,31,opt,name=scheduler,proto3" json:"-" yaml: "-"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckConfig) Reset()         { *m = CheckConfig{} }
func (m *CheckConfig) String() string { return proto.CompactTextString(m) }
func (*CheckConfig) ProtoMessage()    {}
func (*CheckConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b843265b29f5373, []int{3}
}
func (m *CheckConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckConfig.Merge(m, src)
}
func (m *CheckConfig) XXX_Size() int {
	return m.Size()
}
func (m *CheckConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckConfig.DiscardUnknown(m)
}

var xxx_messageInfo_CheckConfig proto.InternalMessageInfo

// A Check is a check specification and optionally the results of the check's
// execution.
type Check struct {
	// Command is the command to be executed.
	Command string `protobuf:"bytes,1,opt,name=command,proto3" json:"command,omitempty"`
	// Handlers are the event handler for the check (incidents and/or metrics).
	Handlers []string `protobuf:"bytes,3,rep,name=handlers,proto3" json:"handlers"`
	// HighFlapThreshold is the flap detection high threshold (% state change)
	// for the check. Sensu uses the same flap detection algorithm as Nagios.
	HighFlapThreshold uint32 `protobuf:"varint,4,opt,name=high_flap_threshold,json=highFlapThreshold,proto3" json:"high_flap_threshold"`
	// Interval is the interval, in seconds, at which the check should be run.
	Interval uint32 `protobuf:"varint,5,opt,name=interval,proto3" json:"interval"`
	// LowFlapThreshold is the flap detection low threshold (% state change) for
	// the check. Sensu uses the same flap detection algorithm as Nagios.
	LowFlapThreshold uint32 `protobuf:"varint,6,opt,name=low_flap_threshold,json=lowFlapThreshold,proto3" json:"low_flap_threshold"`
	// Publish indicates if check requests are published for the check
	Publish bool `protobuf:"varint,9,opt,name=publish,proto3" json:"publish"`
	// RuntimeAssets are a list of assets required to execute check.
	RuntimeAssets []string `protobuf:"bytes,10,rep,name=runtime_assets,json=runtimeAssets,proto3" json:"runtime_assets"`
	// Subscriptions is the list of subscribers for the check.
	Subscriptions []string `protobuf:"bytes,11,rep,name=subscriptions,proto3" json:"subscriptions"`
	// Sources indicates the name of the entity representing an external
	// resource
	ProxyEntityName string `protobuf:"bytes,13,opt,name=proxy_entity_name,json=proxyEntityName,proto3" json:"proxy_entity_name"`
	// CheckHooks is the list of check hooks for the check
	CheckHooks []HookList `protobuf:"bytes,14,rep,name=check_hooks,json=checkHooks,proto3" json:"check_hooks"`
	// STDIN indicates if the check command accepts JSON via stdin from the
	// agent
	Stdin bool `protobuf:"varint,15,opt,name=stdin,proto3" json:"stdin"`
	// Subdue represents one or more time windows when the check should be
	// subdued.
	Subdue *TimeWindowWhen `protobuf:"bytes,16,opt,name=subdue,proto3" json:"subdue"`
	// Cron is the cron string at which the check should be run.
	Cron string `protobuf:"bytes,17,opt,name=cron,proto3" json:"cron,omitempty"`
	// TTL represents the length of time in seconds for which a check result is
	// valid.
	Ttl int64 `protobuf:"varint,18,opt,name=ttl,proto3" json:"ttl"`
	// Timeout is the timeout, in seconds, at which the check has to run
	Timeout uint32 `protobuf:"varint,19,opt,name=timeout,proto3" json:"timeout"`
	// ProxyRequests represents a request to execute a proxy check
	ProxyRequests *ProxyRequests `protobuf:"bytes,20,opt,name=proxy_requests,json=proxyRequests,proto3" json:"proxy_requests,omitempty"`
	// RoundRobin enables round-robin scheduling if set true.
	RoundRobin bool `protobuf:"varint,21,opt,name=round_robin,json=roundRobin,proto3" json:"round_robin"`
	// Duration of execution
	Duration float64 `protobuf:"fixed64,22,opt,name=duration,proto3" json:"duration,omitempty"`
	// Executed describes the time in which the check request was executed
	Executed int64 `protobuf:"varint,23,opt,name=executed,proto3" json:"executed"`
	// History is the check state history.
	History []CheckHistory `protobuf:"bytes,24,rep,name=history,proto3" json:"history"`
	// Issued describes the time in which the check request was issued
	Issued int64 `protobuf:"varint,25,opt,name=issued,proto3" json:"issued"`
	// Output from the execution of Command
	Output string `protobuf:"bytes,26,opt,name=output,proto3" json:"output"`
	// State provides handlers with more information about the state change
	State string `protobuf:"bytes,27,opt,name=state,proto3" json:"state,omitempty"`
	// Status is the exit status code produced by the check
	Status uint32 `protobuf:"varint,28,opt,name=status,proto3" json:"status"`
	// TotalStateChange indicates the total state change percentage for the
	// check's history
	TotalStateChange uint32 `protobuf:"varint,29,opt,name=total_state_change,json=totalStateChange,proto3" json:"total_state_change"`
	// LastOK displays last time this check was ok; if event status is 0 this is
	// set to timestamp
	LastOK int64 `protobuf:"varint,30,opt,name=last_ok,json=lastOk,proto3" json:"last_ok"`
	// Occurrences indicates the number of times an event has occurred for a
	// client/check pair with the same check status
	Occurrences int64 `protobuf:"varint,31,opt,name=occurrences,proto3" json:"occurrences"`
	// OccurrencesWatermark indicates the high water mark tracking number of
	// occurrences at the current severity
	OccurrencesWatermark int64 `protobuf:"varint,32,opt,name=occurrences_watermark,json=occurrencesWatermark,proto3" json:"occurrences_watermark"`
	// Silenced is a list of silenced entry ids (subscription and check name)
	Silenced []string `protobuf:"bytes,33,rep,name=silenced,proto3" json:"silenced,omitempty"`
	// Hooks describes the results of multiple hooks; if event is associated to
	// hook execution.
	Hooks []*Hook `protobuf:"bytes,34,rep,name=hooks,proto3" json:"hooks,omitempty"`
	// OutputMetricFormat is the metric protocol that the check's output
	// will be expected to follow in order to be extracted.
	OutputMetricFormat string `protobuf:"bytes,35,opt,name=output_metric_format,json=outputMetricFormat,proto3" json:"output_metric_format"`
	// OutputMetricHandlers is the list of event handlers that will
	// respond to metrics that have been extracted from the check.
	OutputMetricHandlers []string `protobuf:"bytes,36,rep,name=output_metric_handlers,json=outputMetricHandlers,proto3" json:"output_metric_handlers"`
	// EnvVars is the list of environment variables to set for the check's
	// execution environment.
	EnvVars []string `protobuf:"bytes,37,rep,name=env_vars,json=envVars,proto3" json:"env_vars"`
	// Metadata contains the name, namespace, labels and annotations of the
	// check
	ObjectMeta `protobuf:"bytes,38,opt,name=metadata,proto3,embedded=metadata" json:"metadata,omitempty"`
	// MaxOutputSize is the maximum size in bytes that will be stored for check
	// output. If check output is larger than MaxOutputSize, it will be
	// truncated when stored. Filters, mutators, and handlers will still have
	// access to the full check output at the time the event occurs.
	MaxOutputSize int64 `protobuf:"varint,39,opt,name=max_output_size,json=maxOutputSize,proto3" json:"max_output_size,omitempty"`
	// DiscardOutput causes agents to discard check output. No check output is
	// written to the backend, but metrics extraction is still performed.
	DiscardOutput bool `protobuf:"varint,40,opt,name=discard_output,json=discardOutput,proto3" json:"discard_output,omitempty"`
	// Secrets is the list of Sensu secrets to set for the check's
	// execution environment.
	Secrets []*Secret `protobuf:"bytes,41,rep,name=secrets,proto3" json:"secrets"`
	// IsSilenced indicates whether the check is silenced or not
	IsSilenced bool `protobuf:"varint,42,opt,name=is_silenced,json=isSilenced,proto3" json:"is_silenced"`
	// OutputMetricTags is list of metric tags to apply to metrics extracted from check output.
	OutputMetricTags []*MetricTag `protobuf:"bytes,43,rep,name=output_metric_tags,json=outputMetricTags,proto3" json:"output_metric_tags,omitempty" yaml: "output_metric_tags,omitempty"`
	// Scheduler is the type of scheduler the check is scheduled by. The scheduler
	// can be "memory", "etcd", or "postgres". Scheduler is set by Sensu - any
	// setting by the user will be overridden.
	Scheduler string `protobuf:"bytes,44,opt,name=scheduler,proto3" json:"scheduler"`
	// ExtendedAttributes store serialized arbitrary JSON-encoded data
	ExtendedAttributes   []byte   `protobuf:"bytes,99,opt,name=ExtendedAttributes,proto3" json:"-"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Check) Reset()         { *m = Check{} }
func (m *Check) String() string { return proto.CompactTextString(m) }
func (*Check) ProtoMessage()    {}
func (*Check) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b843265b29f5373, []int{4}
}
func (m *Check) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Check) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Check.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Check) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Check.Merge(m, src)
}
func (m *Check) XXX_Size() int {
	return m.Size()
}
func (m *Check) XXX_DiscardUnknown() {
	xxx_messageInfo_Check.DiscardUnknown(m)
}

var xxx_messageInfo_Check proto.InternalMessageInfo

// CheckHistory is a record of a check execution and its status
type CheckHistory struct {
	// Status is the exit status code produced by the check.
	Status uint32 `protobuf:"varint,1,opt,name=status,proto3" json:"status"`
	// Executed describes the time in which the check request was executed
	Executed int64 `protobuf:"varint,2,opt,name=executed,proto3" json:"executed"`
	// Flapping describes whether the check was flapping at this particular
	// point in time. Comparing this value to the current flapping status allows
	// filters to trigger only on start and end of flapping. NB! This has been
	// disabled for 5.x releases.
	Flapping             bool     `protobuf:"varint,3,opt,name=flapping,proto3" json:"-"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckHistory) Reset()         { *m = CheckHistory{} }
func (m *CheckHistory) String() string { return proto.CompactTextString(m) }
func (*CheckHistory) ProtoMessage()    {}
func (*CheckHistory) Descriptor() ([]byte, []int) {
	return fileDescriptor_6b843265b29f5373, []int{5}
}
func (m *CheckHistory) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckHistory) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckHistory.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckHistory) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckHistory.Merge(m, src)
}
func (m *CheckHistory) XXX_Size() int {
	return m.Size()
}
func (m *CheckHistory) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckHistory.DiscardUnknown(m)
}

var xxx_messageInfo_CheckHistory proto.InternalMessageInfo

func (m *CheckHistory) GetStatus() uint32 {
	if m != nil {
		return m.Status
	}
	return 0
}

func (m *CheckHistory) GetExecuted() int64 {
	if m != nil {
		return m.Executed
	}
	return 0
}

func (m *CheckHistory) GetFlapping() bool {
	if m != nil {
		return m.Flapping
	}
	return false
}

func init() {
	proto.RegisterType((*CheckRequest)(nil), "sensu.core.v2.CheckRequest")
	proto.RegisterMapType((map[string]*AssetList)(nil), "sensu.core.v2.CheckRequest.HookAssetsEntry")
	proto.RegisterType((*AssetList)(nil), "sensu.core.v2.AssetList")
	proto.RegisterType((*ProxyRequests)(nil), "sensu.core.v2.ProxyRequests")
	proto.RegisterType((*CheckConfig)(nil), "sensu.core.v2.CheckConfig")
	proto.RegisterType((*Check)(nil), "sensu.core.v2.Check")
	proto.RegisterType((*CheckHistory)(nil), "sensu.core.v2.CheckHistory")
}

func init() {
	proto.RegisterFile("github.com/sensu/sensu-go/api/core/v2/check.proto", fileDescriptor_6b843265b29f5373)
}

var fileDescriptor_6b843265b29f5373 = []byte{
	// 1640 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x58, 0xcf, 0x6f, 0x1b, 0xc7,
	0x15, 0xf6, 0x8a, 0x16, 0x45, 0x0e, 0x45, 0xfd, 0x18, 0x4b, 0xf6, 0x58, 0xb1, 0xb9, 0x0c, 0x1b,
	0x27, 0x6c, 0x1d, 0x53, 0xb6, 0xdc, 0x20, 0xa9, 0x91, 0x43, 0xbd, 0xaa, 0x5d, 0xa5, 0x4d, 0xe2,
	0x60, 0xac, 0xd6, 0x40, 0x81, 0x62, 0x31, 0xdc, 0x1d, 0x93, 0x5b, 0x2d, 0x77, 0xd9, 0x9d, 0x59,
	0x4a, 0xca, 0xa5, 0xd7, 0x1e, 0x7b, 0xec, 0x31, 0xc7, 0x14, 0x28, 0x90, 0x6b, 0xff, 0x84, 0x1c,
	0xf3, 0x17, 0x2c, 0x5a, 0xf5, 0xb6, 0xc7, 0x9c, 0x7a, 0x2c, 0xe6, 0xed, 0xec, 0x72, 0x49, 0x51,
	0x8e, 0x02, 0xa4, 0x68, 0x51, 0xe4, 0xc2, 0x9d, 0xf9, 0xe6, 0xbd, 0xf9, 0xf1, 0xe6, 0x9b, 0x6f,
	0xde, 0x10, 0x3d, 0x18, 0x78, 0x72, 0x18, 0xf7, 0x7b, 0x4e, 0x38, 0xda, 0x15, 0x3c, 0x10, 0x71,
	0xf6, 0x7b, 0x6f, 0x10, 0xee, 0xb2, 0xb1, 0xb7, 0xeb, 0x84, 0x11, 0xdf, 0x9d, 0xec, 0xed, 0x3a,
	0x43, 0xee, 0x1c, 0xf5, 0xc6, 0x51, 0x28, 0x43, 0xdc, 0x04, 0x8b, 0x9e, 0x6a, 0xea, 0x4d, 0xf6,
	0x76, 0x7e, 0x5c, 0xea, 0x61, 0x10, 0x0e, 0xc2, 0x5d, 0xb0, 0xea, 0xc7, 0x2f, 0x7f, 0x3a, 0x79,
	0xd0, 0x7b, 0xd8, 0x7b, 0x00, 0x20, 0x60, 0x50, 0xca, 0x3a, 0xd9, 0xb9, 0xe4, 0xb8, 0x4c, 0x08,
	0x2e, 0xb5, 0xcb, 0xfd, 0xcb, 0xb9, 0x0c, 0xc3, 0xf0, 0xe8, 0xdb, 0x79, 0x8c, 0xb8, 0x64, 0xda,
	0xe3, 0xdd, 0xcb, 0x79, 0x48, 0x6f, 0xc4, 0xed, 0x63, 0x2f, 0x70, 0xc3, 0x63, 0xed, 0xb8, 0x77,
	0x39, 0x47, 0xc1, 0x9d, 0xa8, 0x58, 0xd0, 0xc3, 0x4b, 0x4f, 0x2f, 0xf2, 0x1c, 0x91, 0x39, 0x75,
	0xfe, 0x52, 0x41, 0xab, 0xfb, 0x6a, 0x37, 0x28, 0xff, 0x7d, 0xcc, 0x85, 0xc4, 0xef, 0xa1, 0xaa,
	0x13, 0x06, 0x2f, 0xbd, 0x01, 0x31, 0xda, 0x46, 0xb7, 0xb1, 0xb7, 0xd3, 0x9b, 0xd9, 0x9f, 0x1e,
	0x18, 0xef, 0x83, 0x85, 0x75, 0xf5, 0xcb, 0xc4, 0x34, 0xa8, 0xb6, 0xc7, 0x7b, 0xa8, 0x0a, 0xf1,
	0x15, 0x64, 0xa9, 0x5d, 0xe9, 0x36, 0xf6, 0xb6, 0xe6, 0x3c, 0x1f, 0xab, 0x46, 0xf0, 0xb9, 0x42,
	0xb5, 0x25, 0x7e, 0x07, 0x2d, 0xab, 0x00, 0x0b, 0x52, 0x01, 0x97, 0x9b, 0x73, 0x2e, 0x07, 0x61,
	0x58, 0x1e, 0xeb, 0x0a, 0xcd, 0xac, 0x71, 0x07, 0x55, 0x3f, 0x10, 0x22, 0xe6, 0x2e, 0xb9, 0xda,
	0x36, 0xba, 0x15, 0x0b, 0xa5, 0x89, 0x59, 0xf5, 0x00, 0xa1, 0xba, 0x05, 0xff, 0x16, 0x35, 0x94,
	0xb1, 0xad, 0xe7, 0xb4, 0x0c, 0x03, 0xdc, 0x5d, 0xb4, 0x1a, 0xbd, 0x74, 0x18, 0x0d, 0x26, 0x29,
	0x9e, 0x04, 0x32, 0x3a, 0xb5, 0xd6, 0xd3, 0xc4, 0x2c, 0xf7, 0x41, 0xd1, 0xb0, 0xb0, 0xc0, 0x04,
	0xad, 0x64, 0xd1, 0x17, 0xa4, 0xda, 0xae, 0x74, 0xeb, 0x34, 0xaf, 0xee, 0xbc, 0x40, 0xeb, 0x73,
	0x3d, 0xe1, 0x0d, 0x54, 0x39, 0xe2, 0xa7, 0x10, 0xd1, 0x3a, 0x55, 0x45, 0xdc, 0x43, 0xcb, 0x13,
	0xe6, 0xc7, 0x9c, 0x2c, 0x41, 0x94, 0xc9, 0xa2, 0x58, 0x7d, 0xe8, 0x09, 0x49, 0x33, 0xb3, 0x47,
	0x4b, 0xef, 0x19, 0x9d, 0x0f, 0x50, 0xbd, 0xc0, 0xf1, 0xfb, 0x45, 0xb4, 0x8d, 0x57, 0x44, 0x7b,
	0x4d, 0x45, 0x4d, 0x05, 0x47, 0xaf, 0x40, 0x7f, 0x3b, 0x5f, 0x18, 0xa8, 0xf9, 0x49, 0x14, 0x9e,
	0x9c, 0xea, 0xb5, 0x0b, 0x6c, 0xa1, 0x4d, 0x1e, 0x48, 0x4f, 0x9e, 0xda, 0x4c, 0xca, 0xc8, 0xeb,
	0xc7, 0x92, 0x67, 0x5d, 0xd7, 0xad, 0xed, 0x34, 0x31, 0xcf, 0x37, 0xd2, 0x8d, 0x0c, 0x7a, 0x5c,
	0x20, 0xd8, 0x44, 0xcb, 0x62, 0xec, 0xb3, 0x53, 0x58, 0x54, 0xcd, 0xaa, 0xa7, 0x89, 0x99, 0x01,
	0x34, 0xfb, 0xe0, 0x9f, 0xa0, 0x35, 0x28, 0xd8, 0x4e, 0x38, 0xe1, 0x11, 0x1b, 0x70, 0x52, 0x69,
	0x1b, 0xdd, 0xa6, 0x85, 0xd3, 0xc4, 0x9c, 0x6b, 0xa1, 0x4d, 0xa8, 0xef, 0xeb, 0x6a, 0xe7, 0xaf,
	0xab, 0xa8, 0x51, 0xe2, 0x9e, 0x8a, 0xbf, 0x13, 0x8e, 0x46, 0x2c, 0x70, 0x75, 0x58, 0xf3, 0x2a,
	0xee, 0xa2, 0xda, 0x90, 0x05, 0xae, 0xcf, 0xa3, 0x8c, 0x56, 0x75, 0x6b, 0x35, 0x4d, 0xcc, 0x02,
	0xa3, 0x45, 0x09, 0xff, 0x1c, 0x5d, 0x1b, 0x7a, 0x83, 0xa1, 0xfd, 0xd2, 0x67, 0x63, 0x5b, 0x0e,
	0x23, 0x2e, 0x86, 0xa1, 0x9f, 0x71, 0xaa, 0x69, 0xdd, 0x48, 0x13, 0x73, 0x51, 0x33, 0xdd, 0x54,
	0xe0, 0x53, 0x9f, 0x8d, 0x0f, 0x73, 0x48, 0x0d, 0xe9, 0x05, 0x92, 0x47, 0x13, 0xe6, 0x93, 0x65,
	0xf0, 0x86, 0x21, 0x73, 0x8c, 0x16, 0x25, 0xfc, 0x33, 0x84, 0xfd, 0xf0, 0x78, 0x7e, 0xc4, 0x2a,
	0xf8, 0x5c, 0x4f, 0x13, 0x73, 0x41, 0x2b, 0xdd, 0xf0, 0xc3, 0xe3, 0xd9, 0xf1, 0xee, 0xa0, 0x95,
	0x71, 0xdc, 0xf7, 0x3d, 0x31, 0x24, 0x75, 0x08, 0x75, 0x23, 0x4d, 0xcc, 0x1c, 0xa2, 0x79, 0x41,
	0x85, 0x3b, 0x8a, 0x03, 0x50, 0x17, 0xcd, 0x15, 0x04, 0xf1, 0x80, 0x70, 0xcf, 0xb6, 0xd0, 0xa6,
	0xae, 0x6b, 0x7a, 0xbf, 0x8b, 0x9a, 0x22, 0xee, 0x0b, 0x27, 0xf2, 0xc6, 0xd2, 0x0b, 0x03, 0x41,
	0x1a, 0xe0, 0xb9, 0x99, 0x26, 0xe6, 0x6c, 0x03, 0x9d, 0xad, 0xe2, 0x77, 0x10, 0x7e, 0x72, 0x22,
	0x79, 0xe0, 0x72, 0x77, 0xca, 0x0c, 0xb2, 0xda, 0x36, 0xba, 0xab, 0xd6, 0x72, 0x9a, 0x98, 0xc6,
	0x3d, 0xba, 0xc0, 0x00, 0x1f, 0xa2, 0xcd, 0xb1, 0xe2, 0xa3, 0xad, 0x79, 0x16, 0xb0, 0x11, 0x27,
	0x4d, 0xb5, 0xb1, 0x56, 0xf7, 0x2c, 0x31, 0xd7, 0x81, 0xac, 0x4f, 0xa0, 0xed, 0x63, 0x36, 0xe2,
	0x8a, 0x91, 0xe7, 0xec, 0xe9, 0xfa, 0x78, 0xd6, 0x0a, 0x7f, 0x84, 0x1a, 0x70, 0xd5, 0xd8, 0x99,
	0xc8, 0xac, 0xc1, 0x49, 0xb9, 0xb1, 0x40, 0x64, 0xd4, 0x91, 0xb2, 0xae, 0xe9, 0xc3, 0x52, 0xf6,
	0xa1, 0x08, 0x2a, 0x07, 0x20, 0x3b, 0x8a, 0xdf, 0xd2, 0xf5, 0x02, 0xb2, 0x5e, 0xe2, 0xb7, 0x02,
	0x68, 0xf6, 0xc1, 0x8f, 0x51, 0x55, 0xc4, 0x7d, 0x37, 0xe6, 0x64, 0x03, 0x8e, 0xf5, 0xed, 0xb9,
	0xa1, 0x0e, 0xbd, 0x11, 0x7f, 0x01, 0x3a, 0xff, 0x62, 0xc8, 0x83, 0x4c, 0xb6, 0x32, 0x07, 0xaa,
	0xbf, 0x18, 0xa3, 0xab, 0x4e, 0x14, 0x06, 0x64, 0x13, 0x48, 0x0d, 0x65, 0x7c, 0x13, 0x55, 0xa4,
	0xf4, 0x09, 0x06, 0xad, 0x5b, 0x49, 0x13, 0x53, 0x55, 0xa9, 0xfa, 0x51, 0x4c, 0x50, 0xbb, 0x16,
	0xc6, 0x92, 0x5c, 0x03, 0x12, 0x01, 0x13, 0x34, 0x44, 0xf3, 0x02, 0xde, 0x47, 0x6b, 0x59, 0xb8,
	0x22, 0x7d, 0xde, 0xc9, 0x16, 0x4c, 0xf0, 0xd6, 0xdc, 0x04, 0x67, 0x34, 0x81, 0x36, 0xc7, 0x33,
	0x12, 0x71, 0x1f, 0x35, 0xa2, 0x30, 0x0e, 0x5c, 0x3b, 0x0a, 0xfb, 0x5e, 0x40, 0xb6, 0x21, 0x08,
	0x20, 0x92, 0x25, 0x98, 0x22, 0xa8, 0x50, 0x55, 0xc6, 0xbf, 0x40, 0x5b, 0x61, 0x2c, 0xc7, 0xb1,
	0xb4, 0xb3, 0x5b, 0xc7, 0x7e, 0x19, 0x46, 0x23, 0x26, 0xc9, 0x75, 0xd8, 0x58, 0x92, 0x26, 0xe6,
	0xc2, 0x76, 0x8a, 0x33, 0xf4, 0x23, 0x00, 0x9f, 0x02, 0x86, 0x3f, 0x41, 0xd7, 0x67, 0x6d, 0x8b,
	0x43, 0x7e, 0x03, 0xa8, 0xb9, 0x93, 0x26, 0xe6, 0x05, 0x16, 0x74, 0xab, 0xdc, 0xdf, 0x41, 0x7e,
	0xfc, 0xdf, 0x42, 0x35, 0x1e, 0x4c, 0xec, 0x09, 0x8b, 0x04, 0x21, 0x53, 0xa1, 0xc8, 0x31, 0xba,
	0xc2, 0x83, 0xc9, 0xaf, 0x59, 0x24, 0xf0, 0xaf, 0x50, 0x4d, 0x5d, 0xea, 0x2e, 0x93, 0x8c, 0xec,
	0x40, 0xdc, 0xe6, 0x2f, 0xaa, 0x67, 0xfd, 0xdf, 0x71, 0x47, 0xf5, 0xcf, 0xac, 0x96, 0x62, 0xd1,
	0x57, 0x89, 0x69, 0xa8, 0xd3, 0x9c, 0xbb, 0xbd, 0x1d, 0x8e, 0x3c, 0xc9, 0x47, 0x63, 0x79, 0x4a,
	0x8b, 0xae, 0xf0, 0x9b, 0x68, 0x7d, 0xc4, 0x4e, 0x6c, 0x3d, 0x67, 0xe1, 0x7d, 0xca, 0xc9, 0x6b,
	0x6a, 0x8b, 0x69, 0x73, 0xc4, 0x4e, 0x9e, 0x01, 0xfa, 0xdc, 0xfb, 0x94, 0xe3, 0x3b, 0x68, 0xcd,
	0xf5, 0x84, 0xc3, 0x22, 0x57, 0xdb, 0x92, 0x5b, 0x2a, 0xf4, 0xb4, 0xa9, 0xd1, 0xcc, 0x14, 0xbf,
	0x3f, 0xbd, 0x91, 0x6e, 0x03, 0xd1, 0xb7, 0xe7, 0x26, 0xf9, 0x1c, 0x5a, 0x33, 0x86, 0x68, 0xcb,
	0xe2, 0xd6, 0xc2, 0x7f, 0x32, 0x10, 0x9e, 0x8d, 0x9e, 0x64, 0x03, 0x41, 0x5a, 0xd0, 0xd3, 0xfc,
	0xf5, 0x94, 0x05, 0xf2, 0x90, 0x0d, 0xac, 0x83, 0x34, 0x31, 0x6f, 0x9d, 0xf7, 0x9b, 0xae, 0xf7,
	0xeb, 0xc4, 0x7c, 0xe3, 0x94, 0x8d, 0xfc, 0x47, 0xed, 0xce, 0xab, 0xcc, 0x3a, 0x74, 0xa3, 0xbc,
	0x47, 0x87, 0x6c, 0xa0, 0xf8, 0x56, 0x17, 0xce, 0x90, 0xbb, 0xb1, 0xcf, 0x23, 0x62, 0x02, 0x65,
	0x30, 0x28, 0xc8, 0xd7, 0x89, 0x59, 0xd7, 0x7d, 0xde, 0xeb, 0xd0, 0xa9, 0xd1, 0xa3, 0xda, 0x1f,
	0x3f, 0x33, 0xaf, 0x7c, 0xfe, 0x99, 0x69, 0x74, 0xbe, 0xd8, 0x44, 0xcb, 0x70, 0x5d, 0x7c, 0x7f,
	0x51, 0xfc, 0x8f, 0x5e, 0x14, 0xdf, 0x2b, 0xfe, 0xff, 0xa3, 0xe2, 0xef, 0xa0, 0x9a, 0x1b, 0x47,
	0x4c, 0x6d, 0x31, 0xa8, 0xbc, 0x41, 0x8b, 0xba, 0x22, 0x3f, 0x3f, 0xe1, 0x4e, 0x2c, 0xb9, 0x4b,
	0x6e, 0xc0, 0xca, 0x32, 0xbd, 0xd5, 0x18, 0x2d, 0x4a, 0xf8, 0x29, 0x5a, 0x19, 0x7a, 0x42, 0x86,
	0xd1, 0x29, 0x08, 0x73, 0x63, 0xef, 0xb5, 0x45, 0x79, 0xfb, 0x41, 0x66, 0x62, 0xad, 0xeb, 0x5d,
	0xcc, 0x7d, 0x68, 0x5e, 0x50, 0xef, 0x84, 0xec, 0x55, 0x40, 0x6e, 0x9e, 0x7f, 0x27, 0x64, 0x5f,
	0x65, 0xa3, 0x55, 0x75, 0x07, 0xc8, 0x07, 0x36, 0x19, 0x42, 0xf5, 0x17, 0x6f, 0x29, 0x1a, 0x30,
	0x99, 0xe9, 0x73, 0x9d, 0x66, 0x15, 0xe5, 0xa9, 0x0a, 0xb1, 0x00, 0x3d, 0x6e, 0xea, 0xcd, 0x05,
	0x84, 0xea, 0xaf, 0x3a, 0xc6, 0x32, 0x94, 0xcc, 0xb7, 0xc1, 0xc5, 0x76, 0x86, 0x2c, 0x18, 0x70,
	0x72, 0x7b, 0x7a, 0x8c, 0xcf, 0xb7, 0xd2, 0x0d, 0xc0, 0x9e, 0x2b, 0x68, 0x1f, 0x10, 0xdc, 0x43,
	0x2b, 0x3e, 0x13, 0xd2, 0x0e, 0x8f, 0x48, 0x0b, 0x16, 0xb2, 0x7d, 0x96, 0x98, 0xd5, 0x0f, 0x99,
	0x90, 0xcf, 0x7e, 0xa9, 0x16, 0xae, 0x1b, 0x69, 0x55, 0x15, 0x9e, 0x1d, 0xe1, 0x07, 0xa8, 0x11,
	0x3a, 0x4e, 0x1c, 0x45, 0x3c, 0x70, 0xb8, 0x00, 0xed, 0xac, 0x64, 0xfb, 0x56, 0x82, 0x69, 0xb9,
	0x82, 0x3f, 0x46, 0xdb, 0xa5, 0xaa, 0x7d, 0xcc, 0x24, 0x8f, 0x46, 0x2c, 0x3a, 0x22, 0x6d, 0x70,
	0xbe, 0x99, 0x26, 0xe6, 0x62, 0x03, 0xba, 0x55, 0x82, 0x5f, 0xe4, 0x28, 0x6e, 0xa3, 0x9a, 0xf0,
	0x7c, 0x05, 0xba, 0xe4, 0x75, 0x90, 0x84, 0xec, 0xb5, 0x58, 0xa0, 0x78, 0x37, 0x7f, 0xfb, 0x75,
	0x60, 0x8b, 0xaf, 0x2d, 0x38, 0xa4, 0xda, 0x47, 0xbf, 0xfa, 0x2e, 0xca, 0x26, 0x7e, 0xf0, 0x9d,
	0x66, 0x13, 0x6f, 0x7c, 0x07, 0xd9, 0xc4, 0x9d, 0xcb, 0x66, 0x13, 0x6f, 0xfe, 0x47, 0xb3, 0x89,
	0xb7, 0x2e, 0x97, 0x4d, 0x74, 0xbf, 0x21, 0x9b, 0xf8, 0xe1, 0xb7, 0xcf, 0x26, 0xee, 0xa3, 0x86,
	0x27, 0xec, 0x82, 0x00, 0x3f, 0x9a, 0x0a, 0x47, 0x09, 0xa6, 0xc8, 0x13, 0xcf, 0x73, 0x36, 0x5c,
	0x90, 0x7f, 0xdc, 0xfd, 0x2f, 0xe6, 0x1f, 0x77, 0xcb, 0xf9, 0xc7, 0xdb, 0x40, 0xb2, 0x66, 0x9a,
	0x98, 0x53, 0xb0, 0x94, 0x7a, 0x5c, 0xf0, 0xee, 0x71, 0xbe, 0xe1, 0xdd, 0x53, 0xca, 0x58, 0xfe,
	0xa0, 0xff, 0x88, 0x39, 0x98, 0x6a, 0x97, 0x56, 0x17, 0xe3, 0x42, 0x75, 0x29, 0x2b, 0xea, 0xd2,
	0x2b, 0x15, 0xf5, 0x75, 0x54, 0x53, 0xc9, 0xc2, 0xd8, 0x0b, 0x06, 0xf0, 0xe6, 0xae, 0xe5, 0x93,
	0x2a, 0x60, 0xab, 0xfd, 0xaf, 0x7f, 0xb4, 0x8c, 0xcf, 0xcf, 0x5a, 0xc6, 0xdf, 0xce, 0x5a, 0xc6,
	0x97, 0x67, 0x2d, 0xe3, 0xab, 0xb3, 0x96, 0xf1, 0xf7, 0xb3, 0x96, 0xf1, 0xe7, 0x7f, 0xb6, 0xae,
	0xfc, 0x66, 0x69, 0xb2, 0xd7, 0xaf, 0xc2, 0x7f, 0x46, 0x0f, 0xff, 0x1d, 0x00, 0x00, 0xff, 0xff,
	0x86, 0xc9, 0x19, 0x59, 0xe6, 0x13, 0x00, 0x00,
}

func (this *CheckRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CheckRequest)
	if !ok {
		that2, ok := that.(CheckRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	if len(this.Assets) != len(that1.Assets) {
		return false
	}
	for i := range this.Assets {
		if !this.Assets[i].Equal(&that1.Assets[i]) {
			return false
		}
	}
	if len(this.Hooks) != len(that1.Hooks) {
		return false
	}
	for i := range this.Hooks {
		if !this.Hooks[i].Equal(&that1.Hooks[i]) {
			return false
		}
	}
	if this.Issued != that1.Issued {
		return false
	}
	if len(this.HookAssets) != len(that1.HookAssets) {
		return false
	}
	for i := range this.HookAssets {
		if !this.HookAssets[i].Equal(that1.HookAssets[i]) {
			return false
		}
	}
	if len(this.Secrets) != len(that1.Secrets) {
		return false
	}
	for i := range this.Secrets {
		if this.Secrets[i] != that1.Secrets[i] {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *AssetList) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AssetList)
	if !ok {
		that2, ok := that.(AssetList)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Assets) != len(that1.Assets) {
		return false
	}
	for i := range this.Assets {
		if !this.Assets[i].Equal(&that1.Assets[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *ProxyRequests) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ProxyRequests)
	if !ok {
		that2, ok := that.(ProxyRequests)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.EntityAttributes) != len(that1.EntityAttributes) {
		return false
	}
	for i := range this.EntityAttributes {
		if this.EntityAttributes[i] != that1.EntityAttributes[i] {
			return false
		}
	}
	if this.Splay != that1.Splay {
		return false
	}
	if this.SplayCoverage != that1.SplayCoverage {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CheckConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CheckConfig)
	if !ok {
		that2, ok := that.(CheckConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Command != that1.Command {
		return false
	}
	if len(this.Handlers) != len(that1.Handlers) {
		return false
	}
	for i := range this.Handlers {
		if this.Handlers[i] != that1.Handlers[i] {
			return false
		}
	}
	if this.HighFlapThreshold != that1.HighFlapThreshold {
		return false
	}
	if this.Interval != that1.Interval {
		return false
	}
	if this.LowFlapThreshold != that1.LowFlapThreshold {
		return false
	}
	if this.Publish != that1.Publish {
		return false
	}
	if len(this.RuntimeAssets) != len(that1.RuntimeAssets) {
		return false
	}
	for i := range this.RuntimeAssets {
		if this.RuntimeAssets[i] != that1.RuntimeAssets[i] {
			return false
		}
	}
	if len(this.Subscriptions) != len(that1.Subscriptions) {
		return false
	}
	for i := range this.Subscriptions {
		if this.Subscriptions[i] != that1.Subscriptions[i] {
			return false
		}
	}
	if !bytes.Equal(this.ExtendedAttributes, that1.ExtendedAttributes) {
		return false
	}
	if this.ProxyEntityName != that1.ProxyEntityName {
		return false
	}
	if len(this.CheckHooks) != len(that1.CheckHooks) {
		return false
	}
	for i := range this.CheckHooks {
		if !this.CheckHooks[i].Equal(&that1.CheckHooks[i]) {
			return false
		}
	}
	if this.Stdin != that1.Stdin {
		return false
	}
	if !this.Subdue.Equal(that1.Subdue) {
		return false
	}
	if this.Cron != that1.Cron {
		return false
	}
	if this.Ttl != that1.Ttl {
		return false
	}
	if this.Timeout != that1.Timeout {
		return false
	}
	if !this.ProxyRequests.Equal(that1.ProxyRequests) {
		return false
	}
	if this.RoundRobin != that1.RoundRobin {
		return false
	}
	if this.OutputMetricFormat != that1.OutputMetricFormat {
		return false
	}
	if len(this.OutputMetricHandlers) != len(that1.OutputMetricHandlers) {
		return false
	}
	for i := range this.OutputMetricHandlers {
		if this.OutputMetricHandlers[i] != that1.OutputMetricHandlers[i] {
			return false
		}
	}
	if len(this.EnvVars) != len(that1.EnvVars) {
		return false
	}
	for i := range this.EnvVars {
		if this.EnvVars[i] != that1.EnvVars[i] {
			return false
		}
	}
	if !this.ObjectMeta.Equal(&that1.ObjectMeta) {
		return false
	}
	if this.MaxOutputSize != that1.MaxOutputSize {
		return false
	}
	if this.DiscardOutput != that1.DiscardOutput {
		return false
	}
	if len(this.Secrets) != len(that1.Secrets) {
		return false
	}
	for i := range this.Secrets {
		if !this.Secrets[i].Equal(that1.Secrets[i]) {
			return false
		}
	}
	if len(this.OutputMetricTags) != len(that1.OutputMetricTags) {
		return false
	}
	for i := range this.OutputMetricTags {
		if !this.OutputMetricTags[i].Equal(that1.OutputMetricTags[i]) {
			return false
		}
	}
	if this.Scheduler != that1.Scheduler {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Check) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Check)
	if !ok {
		that2, ok := that.(Check)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Command != that1.Command {
		return false
	}
	if len(this.Handlers) != len(that1.Handlers) {
		return false
	}
	for i := range this.Handlers {
		if this.Handlers[i] != that1.Handlers[i] {
			return false
		}
	}
	if this.HighFlapThreshold != that1.HighFlapThreshold {
		return false
	}
	if this.Interval != that1.Interval {
		return false
	}
	if this.LowFlapThreshold != that1.LowFlapThreshold {
		return false
	}
	if this.Publish != that1.Publish {
		return false
	}
	if len(this.RuntimeAssets) != len(that1.RuntimeAssets) {
		return false
	}
	for i := range this.RuntimeAssets {
		if this.RuntimeAssets[i] != that1.RuntimeAssets[i] {
			return false
		}
	}
	if len(this.Subscriptions) != len(that1.Subscriptions) {
		return false
	}
	for i := range this.Subscriptions {
		if this.Subscriptions[i] != that1.Subscriptions[i] {
			return false
		}
	}
	if this.ProxyEntityName != that1.ProxyEntityName {
		return false
	}
	if len(this.CheckHooks) != len(that1.CheckHooks) {
		return false
	}
	for i := range this.CheckHooks {
		if !this.CheckHooks[i].Equal(&that1.CheckHooks[i]) {
			return false
		}
	}
	if this.Stdin != that1.Stdin {
		return false
	}
	if !this.Subdue.Equal(that1.Subdue) {
		return false
	}
	if this.Cron != that1.Cron {
		return false
	}
	if this.Ttl != that1.Ttl {
		return false
	}
	if this.Timeout != that1.Timeout {
		return false
	}
	if !this.ProxyRequests.Equal(that1.ProxyRequests) {
		return false
	}
	if this.RoundRobin != that1.RoundRobin {
		return false
	}
	if this.Duration != that1.Duration {
		return false
	}
	if this.Executed != that1.Executed {
		return false
	}
	if len(this.History) != len(that1.History) {
		return false
	}
	for i := range this.History {
		if !this.History[i].Equal(&that1.History[i]) {
			return false
		}
	}
	if this.Issued != that1.Issued {
		return false
	}
	if this.Output != that1.Output {
		return false
	}
	if this.State != that1.State {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.TotalStateChange != that1.TotalStateChange {
		return false
	}
	if this.LastOK != that1.LastOK {
		return false
	}
	if this.Occurrences != that1.Occurrences {
		return false
	}
	if this.OccurrencesWatermark != that1.OccurrencesWatermark {
		return false
	}
	if len(this.Silenced) != len(that1.Silenced) {
		return false
	}
	for i := range this.Silenced {
		if this.Silenced[i] != that1.Silenced[i] {
			return false
		}
	}
	if len(this.Hooks) != len(that1.Hooks) {
		return false
	}
	for i := range this.Hooks {
		if !this.Hooks[i].Equal(that1.Hooks[i]) {
			return false
		}
	}
	if this.OutputMetricFormat != that1.OutputMetricFormat {
		return false
	}
	if len(this.OutputMetricHandlers) != len(that1.OutputMetricHandlers) {
		return false
	}
	for i := range this.OutputMetricHandlers {
		if this.OutputMetricHandlers[i] != that1.OutputMetricHandlers[i] {
			return false
		}
	}
	if len(this.EnvVars) != len(that1.EnvVars) {
		return false
	}
	for i := range this.EnvVars {
		if this.EnvVars[i] != that1.EnvVars[i] {
			return false
		}
	}
	if !this.ObjectMeta.Equal(&that1.ObjectMeta) {
		return false
	}
	if this.MaxOutputSize != that1.MaxOutputSize {
		return false
	}
	if this.DiscardOutput != that1.DiscardOutput {
		return false
	}
	if len(this.Secrets) != len(that1.Secrets) {
		return false
	}
	for i := range this.Secrets {
		if !this.Secrets[i].Equal(that1.Secrets[i]) {
			return false
		}
	}
	if this.IsSilenced != that1.IsSilenced {
		return false
	}
	if len(this.OutputMetricTags) != len(that1.OutputMetricTags) {
		return false
	}
	for i := range this.OutputMetricTags {
		if !this.OutputMetricTags[i].Equal(that1.OutputMetricTags[i]) {
			return false
		}
	}
	if this.Scheduler != that1.Scheduler {
		return false
	}
	if !bytes.Equal(this.ExtendedAttributes, that1.ExtendedAttributes) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *CheckHistory) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CheckHistory)
	if !ok {
		that2, ok := that.(CheckHistory)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Status != that1.Status {
		return false
	}
	if this.Executed != that1.Executed {
		return false
	}
	if this.Flapping != that1.Flapping {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}

type CheckConfigFace interface {
	Proto() github_com_golang_protobuf_proto.Message
	GetCommand() string
	GetHandlers() []string
	GetHighFlapThreshold() uint32
	GetInterval() uint32
	GetLowFlapThreshold() uint32
	GetPublish() bool
	GetRuntimeAssets() []string
	GetSubscriptions() []string
	GetExtendedAttributes() []byte
	GetProxyEntityName() string
	GetCheckHooks() []HookList
	GetStdin() bool
	GetSubdue() *TimeWindowWhen
	GetCron() string
	GetTtl() int64
	GetTimeout() uint32
	GetProxyRequests() *ProxyRequests
	GetRoundRobin() bool
	GetOutputMetricFormat() string
	GetOutputMetricHandlers() []string
	GetEnvVars() []string
	GetObjectMeta() ObjectMeta
	GetMaxOutputSize() int64
	GetDiscardOutput() bool
	GetSecrets() []*Secret
	GetOutputMetricTags() []*MetricTag
	GetScheduler() string
}

func (this *CheckConfig) Proto() github_com_golang_protobuf_proto.Message {
	return this
}

func (this *CheckConfig) TestProto() github_com_golang_protobuf_proto.Message {
	return NewCheckConfigFromFace(this)
}

func (this *CheckConfig) GetCommand() string {
	return this.Command
}

func (this *CheckConfig) GetHandlers() []string {
	return this.Handlers
}

func (this *CheckConfig) GetHighFlapThreshold() uint32 {
	return this.HighFlapThreshold
}

func (this *CheckConfig) GetInterval() uint32 {
	return this.Interval
}

func (this *CheckConfig) GetLowFlapThreshold() uint32 {
	return this.LowFlapThreshold
}

func (this *CheckConfig) GetPublish() bool {
	return this.Publish
}

func (this *CheckConfig) GetRuntimeAssets() []string {
	return this.RuntimeAssets
}

func (this *CheckConfig) GetSubscriptions() []string {
	return this.Subscriptions
}

func (this *CheckConfig) GetExtendedAttributes() []byte {
	return this.ExtendedAttributes
}

func (this *CheckConfig) GetProxyEntityName() string {
	return this.ProxyEntityName
}

func (this *CheckConfig) GetCheckHooks() []HookList {
	return this.CheckHooks
}

func (this *CheckConfig) GetStdin() bool {
	return this.Stdin
}

func (this *CheckConfig) GetSubdue() *TimeWindowWhen {
	return this.Subdue
}

func (this *CheckConfig) GetCron() string {
	return this.Cron
}

func (this *CheckConfig) GetTtl() int64 {
	return this.Ttl
}

func (this *CheckConfig) GetTimeout() uint32 {
	return this.Timeout
}

func (this *CheckConfig) GetProxyRequests() *ProxyRequests {
	return this.ProxyRequests
}

func (this *CheckConfig) GetRoundRobin() bool {
	return this.RoundRobin
}

func (this *CheckConfig) GetOutputMetricFormat() string {
	return this.OutputMetricFormat
}

func (this *CheckConfig) GetOutputMetricHandlers() []string {
	return this.OutputMetricHandlers
}

func (this *CheckConfig) GetEnvVars() []string {
	return this.EnvVars
}

func (this *CheckConfig) GetObjectMeta() ObjectMeta {
	return this.ObjectMeta
}

func (this *CheckConfig) GetMaxOutputSize() int64 {
	return this.MaxOutputSize
}

func (this *CheckConfig) GetDiscardOutput() bool {
	return this.DiscardOutput
}

func (this *CheckConfig) GetSecrets() []*Secret {
	return this.Secrets
}

func (this *CheckConfig) GetOutputMetricTags() []*MetricTag {
	return this.OutputMetricTags
}

func (this *CheckConfig) GetScheduler() string {
	return this.Scheduler
}

func NewCheckConfigFromFace(that CheckConfigFace) *CheckConfig {
	this := &CheckConfig{}
	this.Command = that.GetCommand()
	this.Handlers = that.GetHandlers()
	this.HighFlapThreshold = that.GetHighFlapThreshold()
	this.Interval = that.GetInterval()
	this.LowFlapThreshold = that.GetLowFlapThreshold()
	this.Publish = that.GetPublish()
	this.RuntimeAssets = that.GetRuntimeAssets()
	this.Subscriptions = that.GetSubscriptions()
	this.ExtendedAttributes = that.GetExtendedAttributes()
	this.ProxyEntityName = that.GetProxyEntityName()
	this.CheckHooks = that.GetCheckHooks()
	this.Stdin = that.GetStdin()
	this.Subdue = that.GetSubdue()
	this.Cron = that.GetCron()
	this.Ttl = that.GetTtl()
	this.Timeout = that.GetTimeout()
	this.ProxyRequests = that.GetProxyRequests()
	this.RoundRobin = that.GetRoundRobin()
	this.OutputMetricFormat = that.GetOutputMetricFormat()
	this.OutputMetricHandlers = that.GetOutputMetricHandlers()
	this.EnvVars = that.GetEnvVars()
	this.ObjectMeta = that.GetObjectMeta()
	this.MaxOutputSize = that.GetMaxOutputSize()
	this.DiscardOutput = that.GetDiscardOutput()
	this.Secrets = that.GetSecrets()
	this.OutputMetricTags = that.GetOutputMetricTags()
	this.Scheduler = that.GetScheduler()
	return this
}

type CheckFace interface {
	Proto() github_com_golang_protobuf_proto.Message
	GetCommand() string
	GetHandlers() []string
	GetHighFlapThreshold() uint32
	GetInterval() uint32
	GetLowFlapThreshold() uint32
	GetPublish() bool
	GetRuntimeAssets() []string
	GetSubscriptions() []string
	GetProxyEntityName() string
	GetCheckHooks() []HookList
	GetStdin() bool
	GetSubdue() *TimeWindowWhen
	GetCron() string
	GetTtl() int64
	GetTimeout() uint32
	GetProxyRequests() *ProxyRequests
	GetRoundRobin() bool
	GetDuration() float64
	GetExecuted() int64
	GetHistory() []CheckHistory
	GetIssued() int64
	GetOutput() string
	GetState() string
	GetStatus() uint32
	GetTotalStateChange() uint32
	GetLastOK() int64
	GetOccurrences() int64
	GetOccurrencesWatermark() int64
	GetSilenced() []string
	GetHooks() []*Hook
	GetOutputMetricFormat() string
	GetOutputMetricHandlers() []string
	GetEnvVars() []string
	GetObjectMeta() ObjectMeta
	GetMaxOutputSize() int64
	GetDiscardOutput() bool
	GetSecrets() []*Secret
	GetIsSilenced() bool
	GetOutputMetricTags() []*MetricTag
	GetScheduler() string
	GetExtendedAttributes() []byte
}

func (this *Check) Proto() github_com_golang_protobuf_proto.Message {
	return this
}

func (this *Check) TestProto() github_com_golang_protobuf_proto.Message {
	return NewCheckFromFace(this)
}

func (this *Check) GetCommand() string {
	return this.Command
}

func (this *Check) GetHandlers() []string {
	return this.Handlers
}

func (this *Check) GetHighFlapThreshold() uint32 {
	return this.HighFlapThreshold
}

func (this *Check) GetInterval() uint32 {
	return this.Interval
}

func (this *Check) GetLowFlapThreshold() uint32 {
	return this.LowFlapThreshold
}

func (this *Check) GetPublish() bool {
	return this.Publish
}

func (this *Check) GetRuntimeAssets() []string {
	return this.RuntimeAssets
}

func (this *Check) GetSubscriptions() []string {
	return this.Subscriptions
}

func (this *Check) GetProxyEntityName() string {
	return this.ProxyEntityName
}

func (this *Check) GetCheckHooks() []HookList {
	return this.CheckHooks
}

func (this *Check) GetStdin() bool {
	return this.Stdin
}

func (this *Check) GetSubdue() *TimeWindowWhen {
	return this.Subdue
}

func (this *Check) GetCron() string {
	return this.Cron
}

func (this *Check) GetTtl() int64 {
	return this.Ttl
}

func (this *Check) GetTimeout() uint32 {
	return this.Timeout
}

func (this *Check) GetProxyRequests() *ProxyRequests {
	return this.ProxyRequests
}

func (this *Check) GetRoundRobin() bool {
	return this.RoundRobin
}

func (this *Check) GetDuration() float64 {
	return this.Duration
}

func (this *Check) GetExecuted() int64 {
	return this.Executed
}

func (this *Check) GetHistory() []CheckHistory {
	return this.History
}

func (this *Check) GetIssued() int64 {
	return this.Issued
}

func (this *Check) GetOutput() string {
	return this.Output
}

func (this *Check) GetState() string {
	return this.State
}

func (this *Check) GetStatus() uint32 {
	return this.Status
}

func (this *Check) GetTotalStateChange() uint32 {
	return this.TotalStateChange
}

func (this *Check) GetLastOK() int64 {
	return this.LastOK
}

func (this *Check) GetOccurrences() int64 {
	return this.Occurrences
}

func (this *Check) GetOccurrencesWatermark() int64 {
	return this.OccurrencesWatermark
}

func (this *Check) GetSilenced() []string {
	return this.Silenced
}

func (this *Check) GetHooks() []*Hook {
	return this.Hooks
}

func (this *Check) GetOutputMetricFormat() string {
	return this.OutputMetricFormat
}

func (this *Check) GetOutputMetricHandlers() []string {
	return this.OutputMetricHandlers
}

func (this *Check) GetEnvVars() []string {
	return this.EnvVars
}

func (this *Check) GetObjectMeta() ObjectMeta {
	return this.ObjectMeta
}

func (this *Check) GetMaxOutputSize() int64 {
	return this.MaxOutputSize
}

func (this *Check) GetDiscardOutput() bool {
	return this.DiscardOutput
}

func (this *Check) GetSecrets() []*Secret {
	return this.Secrets
}

func (this *Check) GetIsSilenced() bool {
	return this.IsSilenced
}

func (this *Check) GetOutputMetricTags() []*MetricTag {
	return this.OutputMetricTags
}

func (this *Check) GetScheduler() string {
	return this.Scheduler
}

func (this *Check) GetExtendedAttributes() []byte {
	return this.ExtendedAttributes
}

func NewCheckFromFace(that CheckFace) *Check {
	this := &Check{}
	this.Command = that.GetCommand()
	this.Handlers = that.GetHandlers()
	this.HighFlapThreshold = that.GetHighFlapThreshold()
	this.Interval = that.GetInterval()
	this.LowFlapThreshold = that.GetLowFlapThreshold()
	this.Publish = that.GetPublish()
	this.RuntimeAssets = that.GetRuntimeAssets()
	this.Subscriptions = that.GetSubscriptions()
	this.ProxyEntityName = that.GetProxyEntityName()
	this.CheckHooks = that.GetCheckHooks()
	this.Stdin = that.GetStdin()
	this.Subdue = that.GetSubdue()
	this.Cron = that.GetCron()
	this.Ttl = that.GetTtl()
	this.Timeout = that.GetTimeout()
	this.ProxyRequests = that.GetProxyRequests()
	this.RoundRobin = that.GetRoundRobin()
	this.Duration = that.GetDuration()
	this.Executed = that.GetExecuted()
	this.History = that.GetHistory()
	this.Issued = that.GetIssued()
	this.Output = that.GetOutput()
	this.State = that.GetState()
	this.Status = that.GetStatus()
	this.TotalStateChange = that.GetTotalStateChange()
	this.LastOK = that.GetLastOK()
	this.Occurrences = that.GetOccurrences()
	this.OccurrencesWatermark = that.GetOccurrencesWatermark()
	this.Silenced = that.GetSilenced()
	this.Hooks = that.GetHooks()
	this.OutputMetricFormat = that.GetOutputMetricFormat()
	this.OutputMetricHandlers = that.GetOutputMetricHandlers()
	this.EnvVars = that.GetEnvVars()
	this.ObjectMeta = that.GetObjectMeta()
	this.MaxOutputSize = that.GetMaxOutputSize()
	this.DiscardOutput = that.GetDiscardOutput()
	this.Secrets = that.GetSecrets()
	this.IsSilenced = that.GetIsSilenced()
	this.OutputMetricTags = that.GetOutputMetricTags()
	this.Scheduler = that.GetScheduler()
	this.ExtendedAttributes = that.GetExtendedAttributes()
	return this
}

func (m *CheckRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Secrets) > 0 {
		for iNdEx := len(m.Secrets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Secrets[iNdEx])
			copy(dAtA[i:], m.Secrets[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.Secrets[iNdEx])))
			i--
			dAtA[i] = 0x32
		}
	}
	if len(m.HookAssets) > 0 {
		for k := range m.HookAssets {
			v := m.HookAssets[k]
			baseI := i
			if v != nil {
				{
					size, err := v.MarshalToSizedBuffer(dAtA[:i])
					if err != nil {
						return 0, err
					}
					i -= size
					i = encodeVarintCheck(dAtA, i, uint64(size))
				}
				i--
				dAtA[i] = 0x12
			}
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintCheck(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintCheck(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x2a
		}
	}
	if m.Issued != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Issued))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Hooks) > 0 {
		for iNdEx := len(m.Hooks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Hooks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Assets) > 0 {
		for iNdEx := len(m.Assets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Assets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x12
		}
	}
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCheck(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *AssetList) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AssetList) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *AssetList) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Assets) > 0 {
		for iNdEx := len(m.Assets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Assets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *ProxyRequests) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProxyRequests) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ProxyRequests) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.SplayCoverage != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.SplayCoverage))
		i--
		dAtA[i] = 0x18
	}
	if m.Splay {
		i--
		if m.Splay {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x10
	}
	if len(m.EntityAttributes) > 0 {
		for iNdEx := len(m.EntityAttributes) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EntityAttributes[iNdEx])
			copy(dAtA[i:], m.EntityAttributes[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.EntityAttributes[iNdEx])))
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *CheckConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Scheduler) > 0 {
		i -= len(m.Scheduler)
		copy(dAtA[i:], m.Scheduler)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Scheduler)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xfa
	}
	if len(m.OutputMetricTags) > 0 {
		for iNdEx := len(m.OutputMetricTags) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.OutputMetricTags[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xf2
		}
	}
	if len(m.Secrets) > 0 {
		for iNdEx := len(m.Secrets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Secrets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xea
		}
	}
	if m.DiscardOutput {
		i--
		if m.DiscardOutput {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe0
	}
	if m.MaxOutputSize != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.MaxOutputSize))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd8
	}
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintCheck(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x1
	i--
	dAtA[i] = 0xd2
	if len(m.EnvVars) > 0 {
		for iNdEx := len(m.EnvVars) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EnvVars[iNdEx])
			copy(dAtA[i:], m.EnvVars[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.EnvVars[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xc2
		}
	}
	if len(m.OutputMetricHandlers) > 0 {
		for iNdEx := len(m.OutputMetricHandlers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.OutputMetricHandlers[iNdEx])
			copy(dAtA[i:], m.OutputMetricHandlers[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.OutputMetricHandlers[iNdEx])))
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xba
		}
	}
	if len(m.OutputMetricFormat) > 0 {
		i -= len(m.OutputMetricFormat)
		copy(dAtA[i:], m.OutputMetricFormat)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.OutputMetricFormat)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb2
	}
	if m.RoundRobin {
		i--
		if m.RoundRobin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.ProxyRequests != nil {
		{
			size, err := m.ProxyRequests.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCheck(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.Timeout != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.Ttl != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Ttl))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if len(m.Cron) > 0 {
		i -= len(m.Cron)
		copy(dAtA[i:], m.Cron)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Cron)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.Subdue != nil {
		{
			size, err := m.Subdue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCheck(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.Stdin {
		i--
		if m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x78
	}
	if len(m.CheckHooks) > 0 {
		for iNdEx := len(m.CheckHooks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CheckHooks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.ProxyEntityName) > 0 {
		i -= len(m.ProxyEntityName)
		copy(dAtA[i:], m.ProxyEntityName)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.ProxyEntityName)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.ExtendedAttributes) > 0 {
		i -= len(m.ExtendedAttributes)
		copy(dAtA[i:], m.ExtendedAttributes)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.ExtendedAttributes)))
		i--
		dAtA[i] = 0x62
	}
	if len(m.Subscriptions) > 0 {
		for iNdEx := len(m.Subscriptions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Subscriptions[iNdEx])
			copy(dAtA[i:], m.Subscriptions[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.Subscriptions[iNdEx])))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.RuntimeAssets) > 0 {
		for iNdEx := len(m.RuntimeAssets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RuntimeAssets[iNdEx])
			copy(dAtA[i:], m.RuntimeAssets[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.RuntimeAssets[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if m.Publish {
		i--
		if m.Publish {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.LowFlapThreshold != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.LowFlapThreshold))
		i--
		dAtA[i] = 0x30
	}
	if m.Interval != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Interval))
		i--
		dAtA[i] = 0x28
	}
	if m.HighFlapThreshold != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.HighFlapThreshold))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Handlers) > 0 {
		for iNdEx := len(m.Handlers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Handlers[iNdEx])
			copy(dAtA[i:], m.Handlers[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.Handlers[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Command) > 0 {
		i -= len(m.Command)
		copy(dAtA[i:], m.Command)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Command)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *Check) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Check) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Check) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.ExtendedAttributes) > 0 {
		i -= len(m.ExtendedAttributes)
		copy(dAtA[i:], m.ExtendedAttributes)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.ExtendedAttributes)))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0x9a
	}
	if len(m.Scheduler) > 0 {
		i -= len(m.Scheduler)
		copy(dAtA[i:], m.Scheduler)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Scheduler)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xe2
	}
	if len(m.OutputMetricTags) > 0 {
		for iNdEx := len(m.OutputMetricTags) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.OutputMetricTags[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xda
		}
	}
	if m.IsSilenced {
		i--
		if m.IsSilenced {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xd0
	}
	if len(m.Secrets) > 0 {
		for iNdEx := len(m.Secrets) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Secrets[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xca
		}
	}
	if m.DiscardOutput {
		i--
		if m.DiscardOutput {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xc0
	}
	if m.MaxOutputSize != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.MaxOutputSize))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0xb8
	}
	{
		size, err := m.ObjectMeta.MarshalToSizedBuffer(dAtA[:i])
		if err != nil {
			return 0, err
		}
		i -= size
		i = encodeVarintCheck(dAtA, i, uint64(size))
	}
	i--
	dAtA[i] = 0x2
	i--
	dAtA[i] = 0xb2
	if len(m.EnvVars) > 0 {
		for iNdEx := len(m.EnvVars) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.EnvVars[iNdEx])
			copy(dAtA[i:], m.EnvVars[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.EnvVars[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xaa
		}
	}
	if len(m.OutputMetricHandlers) > 0 {
		for iNdEx := len(m.OutputMetricHandlers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.OutputMetricHandlers[iNdEx])
			copy(dAtA[i:], m.OutputMetricHandlers[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.OutputMetricHandlers[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0xa2
		}
	}
	if len(m.OutputMetricFormat) > 0 {
		i -= len(m.OutputMetricFormat)
		copy(dAtA[i:], m.OutputMetricFormat)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.OutputMetricFormat)))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x9a
	}
	if len(m.Hooks) > 0 {
		for iNdEx := len(m.Hooks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Hooks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x92
		}
	}
	if len(m.Silenced) > 0 {
		for iNdEx := len(m.Silenced) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Silenced[iNdEx])
			copy(dAtA[i:], m.Silenced[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.Silenced[iNdEx])))
			i--
			dAtA[i] = 0x2
			i--
			dAtA[i] = 0x8a
		}
	}
	if m.OccurrencesWatermark != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.OccurrencesWatermark))
		i--
		dAtA[i] = 0x2
		i--
		dAtA[i] = 0x80
	}
	if m.Occurrences != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Occurrences))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf8
	}
	if m.LastOK != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.LastOK))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xf0
	}
	if m.TotalStateChange != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.TotalStateChange))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe8
	}
	if m.Status != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xe0
	}
	if len(m.State) > 0 {
		i -= len(m.State)
		copy(dAtA[i:], m.State)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.State)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xda
	}
	if len(m.Output) > 0 {
		i -= len(m.Output)
		copy(dAtA[i:], m.Output)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Output)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xd2
	}
	if m.Issued != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Issued))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xc8
	}
	if len(m.History) > 0 {
		for iNdEx := len(m.History) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.History[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1
			i--
			dAtA[i] = 0xc2
		}
	}
	if m.Executed != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Executed))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb8
	}
	if m.Duration != 0 {
		i -= 8
		encoding_binary.LittleEndian.PutUint64(dAtA[i:], uint64(math.Float64bits(float64(m.Duration))))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xb1
	}
	if m.RoundRobin {
		i--
		if m.RoundRobin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa8
	}
	if m.ProxyRequests != nil {
		{
			size, err := m.ProxyRequests.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCheck(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa2
	}
	if m.Timeout != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Timeout))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.Ttl != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Ttl))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if len(m.Cron) > 0 {
		i -= len(m.Cron)
		copy(dAtA[i:], m.Cron)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Cron)))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x8a
	}
	if m.Subdue != nil {
		{
			size, err := m.Subdue.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintCheck(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x82
	}
	if m.Stdin {
		i--
		if m.Stdin {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x78
	}
	if len(m.CheckHooks) > 0 {
		for iNdEx := len(m.CheckHooks) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.CheckHooks[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintCheck(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x72
		}
	}
	if len(m.ProxyEntityName) > 0 {
		i -= len(m.ProxyEntityName)
		copy(dAtA[i:], m.ProxyEntityName)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.ProxyEntityName)))
		i--
		dAtA[i] = 0x6a
	}
	if len(m.Subscriptions) > 0 {
		for iNdEx := len(m.Subscriptions) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Subscriptions[iNdEx])
			copy(dAtA[i:], m.Subscriptions[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.Subscriptions[iNdEx])))
			i--
			dAtA[i] = 0x5a
		}
	}
	if len(m.RuntimeAssets) > 0 {
		for iNdEx := len(m.RuntimeAssets) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.RuntimeAssets[iNdEx])
			copy(dAtA[i:], m.RuntimeAssets[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.RuntimeAssets[iNdEx])))
			i--
			dAtA[i] = 0x52
		}
	}
	if m.Publish {
		i--
		if m.Publish {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x48
	}
	if m.LowFlapThreshold != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.LowFlapThreshold))
		i--
		dAtA[i] = 0x30
	}
	if m.Interval != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Interval))
		i--
		dAtA[i] = 0x28
	}
	if m.HighFlapThreshold != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.HighFlapThreshold))
		i--
		dAtA[i] = 0x20
	}
	if len(m.Handlers) > 0 {
		for iNdEx := len(m.Handlers) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Handlers[iNdEx])
			copy(dAtA[i:], m.Handlers[iNdEx])
			i = encodeVarintCheck(dAtA, i, uint64(len(m.Handlers[iNdEx])))
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Command) > 0 {
		i -= len(m.Command)
		copy(dAtA[i:], m.Command)
		i = encodeVarintCheck(dAtA, i, uint64(len(m.Command)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *CheckHistory) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckHistory) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CheckHistory) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.Flapping {
		i--
		if m.Flapping {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x18
	}
	if m.Executed != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Executed))
		i--
		dAtA[i] = 0x10
	}
	if m.Status != 0 {
		i = encodeVarintCheck(dAtA, i, uint64(m.Status))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintCheck(dAtA []byte, offset int, v uint64) int {
	offset -= sovCheck(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedCheckRequest(r randyCheck, easy bool) *CheckRequest {
	this := &CheckRequest{}
	if r.Intn(5) != 0 {
		this.Config = NewPopulatedCheckConfig(r, easy)
	}
	if r.Intn(5) != 0 {
		v1 := r.Intn(5)
		this.Assets = make([]Asset, v1)
		for i := 0; i < v1; i++ {
			v2 := NewPopulatedAsset(r, easy)
			this.Assets[i] = *v2
		}
	}
	if r.Intn(5) != 0 {
		v3 := r.Intn(5)
		this.Hooks = make([]HookConfig, v3)
		for i := 0; i < v3; i++ {
			v4 := NewPopulatedHookConfig(r, easy)
			this.Hooks[i] = *v4
		}
	}
	this.Issued = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Issued *= -1
	}
	if r.Intn(5) != 0 {
		v5 := r.Intn(10)
		this.HookAssets = make(map[string]*AssetList)
		for i := 0; i < v5; i++ {
			this.HookAssets[randStringCheck(r)] = NewPopulatedAssetList(r, easy)
		}
	}
	v6 := r.Intn(10)
	this.Secrets = make([]string, v6)
	for i := 0; i < v6; i++ {
		this.Secrets[i] = string(randStringCheck(r))
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedCheck(r, 7)
	}
	return this
}

func NewPopulatedAssetList(r randyCheck, easy bool) *AssetList {
	this := &AssetList{}
	if r.Intn(5) != 0 {
		v7 := r.Intn(5)
		this.Assets = make([]Asset, v7)
		for i := 0; i < v7; i++ {
			v8 := NewPopulatedAsset(r, easy)
			this.Assets[i] = *v8
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedCheck(r, 2)
	}
	return this
}

func NewPopulatedProxyRequests(r randyCheck, easy bool) *ProxyRequests {
	this := &ProxyRequests{}
	v9 := r.Intn(10)
	this.EntityAttributes = make([]string, v9)
	for i := 0; i < v9; i++ {
		this.EntityAttributes[i] = string(randStringCheck(r))
	}
	this.Splay = bool(bool(r.Intn(2) == 0))
	this.SplayCoverage = uint32(r.Uint32())
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedCheck(r, 4)
	}
	return this
}

func NewPopulatedCheckConfig(r randyCheck, easy bool) *CheckConfig {
	this := &CheckConfig{}
	this.Command = string(randStringCheck(r))
	v10 := r.Intn(10)
	this.Handlers = make([]string, v10)
	for i := 0; i < v10; i++ {
		this.Handlers[i] = string(randStringCheck(r))
	}
	this.HighFlapThreshold = uint32(r.Uint32())
	this.Interval = uint32(r.Uint32())
	this.LowFlapThreshold = uint32(r.Uint32())
	this.Publish = bool(bool(r.Intn(2) == 0))
	v11 := r.Intn(10)
	this.RuntimeAssets = make([]string, v11)
	for i := 0; i < v11; i++ {
		this.RuntimeAssets[i] = string(randStringCheck(r))
	}
	v12 := r.Intn(10)
	this.Subscriptions = make([]string, v12)
	for i := 0; i < v12; i++ {
		this.Subscriptions[i] = string(randStringCheck(r))
	}
	v13 := r.Intn(100)
	this.ExtendedAttributes = make([]byte, v13)
	for i := 0; i < v13; i++ {
		this.ExtendedAttributes[i] = byte(r.Intn(256))
	}
	this.ProxyEntityName = string(randStringCheck(r))
	if r.Intn(5) != 0 {
		v14 := r.Intn(5)
		this.CheckHooks = make([]HookList, v14)
		for i := 0; i < v14; i++ {
			v15 := NewPopulatedHookList(r, easy)
			this.CheckHooks[i] = *v15
		}
	}
	this.Stdin = bool(bool(r.Intn(2) == 0))
	if r.Intn(5) != 0 {
		this.Subdue = NewPopulatedTimeWindowWhen(r, easy)
	}
	this.Cron = string(randStringCheck(r))
	this.Ttl = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Ttl *= -1
	}
	this.Timeout = uint32(r.Uint32())
	if r.Intn(5) != 0 {
		this.ProxyRequests = NewPopulatedProxyRequests(r, easy)
	}
	this.RoundRobin = bool(bool(r.Intn(2) == 0))
	this.OutputMetricFormat = string(randStringCheck(r))
	v16 := r.Intn(10)
	this.OutputMetricHandlers = make([]string, v16)
	for i := 0; i < v16; i++ {
		this.OutputMetricHandlers[i] = string(randStringCheck(r))
	}
	v17 := r.Intn(10)
	this.EnvVars = make([]string, v17)
	for i := 0; i < v17; i++ {
		this.EnvVars[i] = string(randStringCheck(r))
	}
	v18 := NewPopulatedObjectMeta(r, easy)
	this.ObjectMeta = *v18
	this.MaxOutputSize = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.MaxOutputSize *= -1
	}
	this.DiscardOutput = bool(bool(r.Intn(2) == 0))
	if r.Intn(5) != 0 {
		v19 := r.Intn(5)
		this.Secrets = make([]*Secret, v19)
		for i := 0; i < v19; i++ {
			this.Secrets[i] = NewPopulatedSecret(r, easy)
		}
	}
	if r.Intn(5) != 0 {
		v20 := r.Intn(5)
		this.OutputMetricTags = make([]*MetricTag, v20)
		for i := 0; i < v20; i++ {
			this.OutputMetricTags[i] = NewPopulatedMetricTag(r, easy)
		}
	}
	this.Scheduler = string(randStringCheck(r))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedCheck(r, 32)
	}
	return this
}

func NewPopulatedCheck(r randyCheck, easy bool) *Check {
	this := &Check{}
	this.Command = string(randStringCheck(r))
	v21 := r.Intn(10)
	this.Handlers = make([]string, v21)
	for i := 0; i < v21; i++ {
		this.Handlers[i] = string(randStringCheck(r))
	}
	this.HighFlapThreshold = uint32(r.Uint32())
	this.Interval = uint32(r.Uint32())
	this.LowFlapThreshold = uint32(r.Uint32())
	this.Publish = bool(bool(r.Intn(2) == 0))
	v22 := r.Intn(10)
	this.RuntimeAssets = make([]string, v22)
	for i := 0; i < v22; i++ {
		this.RuntimeAssets[i] = string(randStringCheck(r))
	}
	v23 := r.Intn(10)
	this.Subscriptions = make([]string, v23)
	for i := 0; i < v23; i++ {
		this.Subscriptions[i] = string(randStringCheck(r))
	}
	this.ProxyEntityName = string(randStringCheck(r))
	if r.Intn(5) != 0 {
		v24 := r.Intn(5)
		this.CheckHooks = make([]HookList, v24)
		for i := 0; i < v24; i++ {
			v25 := NewPopulatedHookList(r, easy)
			this.CheckHooks[i] = *v25
		}
	}
	this.Stdin = bool(bool(r.Intn(2) == 0))
	if r.Intn(5) != 0 {
		this.Subdue = NewPopulatedTimeWindowWhen(r, easy)
	}
	this.Cron = string(randStringCheck(r))
	this.Ttl = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Ttl *= -1
	}
	this.Timeout = uint32(r.Uint32())
	if r.Intn(5) != 0 {
		this.ProxyRequests = NewPopulatedProxyRequests(r, easy)
	}
	this.RoundRobin = bool(bool(r.Intn(2) == 0))
	this.Duration = float64(r.Float64())
	if r.Intn(2) == 0 {
		this.Duration *= -1
	}
	this.Executed = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Executed *= -1
	}
	if r.Intn(5) != 0 {
		v26 := r.Intn(5)
		this.History = make([]CheckHistory, v26)
		for i := 0; i < v26; i++ {
			v27 := NewPopulatedCheckHistory(r, easy)
			this.History[i] = *v27
		}
	}
	this.Issued = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Issued *= -1
	}
	this.Output = string(randStringCheck(r))
	this.State = string(randStringCheck(r))
	this.Status = uint32(r.Uint32())
	this.TotalStateChange = uint32(r.Uint32())
	this.LastOK = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LastOK *= -1
	}
	this.Occurrences = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Occurrences *= -1
	}
	this.OccurrencesWatermark = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.OccurrencesWatermark *= -1
	}
	v28 := r.Intn(10)
	this.Silenced = make([]string, v28)
	for i := 0; i < v28; i++ {
		this.Silenced[i] = string(randStringCheck(r))
	}
	if r.Intn(5) != 0 {
		v29 := r.Intn(5)
		this.Hooks = make([]*Hook, v29)
		for i := 0; i < v29; i++ {
			this.Hooks[i] = NewPopulatedHook(r, easy)
		}
	}
	this.OutputMetricFormat = string(randStringCheck(r))
	v30 := r.Intn(10)
	this.OutputMetricHandlers = make([]string, v30)
	for i := 0; i < v30; i++ {
		this.OutputMetricHandlers[i] = string(randStringCheck(r))
	}
	v31 := r.Intn(10)
	this.EnvVars = make([]string, v31)
	for i := 0; i < v31; i++ {
		this.EnvVars[i] = string(randStringCheck(r))
	}
	v32 := NewPopulatedObjectMeta(r, easy)
	this.ObjectMeta = *v32
	this.MaxOutputSize = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.MaxOutputSize *= -1
	}
	this.DiscardOutput = bool(bool(r.Intn(2) == 0))
	if r.Intn(5) != 0 {
		v33 := r.Intn(5)
		this.Secrets = make([]*Secret, v33)
		for i := 0; i < v33; i++ {
			this.Secrets[i] = NewPopulatedSecret(r, easy)
		}
	}
	this.IsSilenced = bool(bool(r.Intn(2) == 0))
	if r.Intn(5) != 0 {
		v34 := r.Intn(5)
		this.OutputMetricTags = make([]*MetricTag, v34)
		for i := 0; i < v34; i++ {
			this.OutputMetricTags[i] = NewPopulatedMetricTag(r, easy)
		}
	}
	this.Scheduler = string(randStringCheck(r))
	v35 := r.Intn(100)
	this.ExtendedAttributes = make([]byte, v35)
	for i := 0; i < v35; i++ {
		this.ExtendedAttributes[i] = byte(r.Intn(256))
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedCheck(r, 100)
	}
	return this
}

func NewPopulatedCheckHistory(r randyCheck, easy bool) *CheckHistory {
	this := &CheckHistory{}
	this.Status = uint32(r.Uint32())
	this.Executed = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.Executed *= -1
	}
	this.Flapping = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedCheck(r, 4)
	}
	return this
}

type randyCheck interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneCheck(r randyCheck) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringCheck(r randyCheck) string {
	v36 := r.Intn(100)
	tmps := make([]rune, v36)
	for i := 0; i < v36; i++ {
		tmps[i] = randUTF8RuneCheck(r)
	}
	return string(tmps)
}
func randUnrecognizedCheck(r randyCheck, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldCheck(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldCheck(dAtA []byte, r randyCheck, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateCheck(dAtA, uint64(key))
		v37 := r.Int63()
		if r.Intn(2) == 0 {
			v37 *= -1
		}
		dAtA = encodeVarintPopulateCheck(dAtA, uint64(v37))
	case 1:
		dAtA = encodeVarintPopulateCheck(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateCheck(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateCheck(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateCheck(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateCheck(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *CheckRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovCheck(uint64(l))
	}
	if len(m.Assets) > 0 {
		for _, e := range m.Assets {
			l = e.Size()
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if len(m.Hooks) > 0 {
		for _, e := range m.Hooks {
			l = e.Size()
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.Issued != 0 {
		n += 1 + sovCheck(uint64(m.Issued))
	}
	if len(m.HookAssets) > 0 {
		for k, v := range m.HookAssets {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovCheck(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovCheck(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovCheck(uint64(mapEntrySize))
		}
	}
	if len(m.Secrets) > 0 {
		for _, s := range m.Secrets {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *AssetList) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Assets) > 0 {
		for _, e := range m.Assets {
			l = e.Size()
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *ProxyRequests) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.EntityAttributes) > 0 {
		for _, s := range m.EntityAttributes {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.Splay {
		n += 2
	}
	if m.SplayCoverage != 0 {
		n += 1 + sovCheck(uint64(m.SplayCoverage))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Command)
	if l > 0 {
		n += 1 + l + sovCheck(uint64(l))
	}
	if len(m.Handlers) > 0 {
		for _, s := range m.Handlers {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.HighFlapThreshold != 0 {
		n += 1 + sovCheck(uint64(m.HighFlapThreshold))
	}
	if m.Interval != 0 {
		n += 1 + sovCheck(uint64(m.Interval))
	}
	if m.LowFlapThreshold != 0 {
		n += 1 + sovCheck(uint64(m.LowFlapThreshold))
	}
	if m.Publish {
		n += 2
	}
	if len(m.RuntimeAssets) > 0 {
		for _, s := range m.RuntimeAssets {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if len(m.Subscriptions) > 0 {
		for _, s := range m.Subscriptions {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	l = len(m.ExtendedAttributes)
	if l > 0 {
		n += 1 + l + sovCheck(uint64(l))
	}
	l = len(m.ProxyEntityName)
	if l > 0 {
		n += 1 + l + sovCheck(uint64(l))
	}
	if len(m.CheckHooks) > 0 {
		for _, e := range m.CheckHooks {
			l = e.Size()
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.Stdin {
		n += 2
	}
	if m.Subdue != nil {
		l = m.Subdue.Size()
		n += 2 + l + sovCheck(uint64(l))
	}
	l = len(m.Cron)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	if m.Ttl != 0 {
		n += 2 + sovCheck(uint64(m.Ttl))
	}
	if m.Timeout != 0 {
		n += 2 + sovCheck(uint64(m.Timeout))
	}
	if m.ProxyRequests != nil {
		l = m.ProxyRequests.Size()
		n += 2 + l + sovCheck(uint64(l))
	}
	if m.RoundRobin {
		n += 3
	}
	l = len(m.OutputMetricFormat)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	if len(m.OutputMetricHandlers) > 0 {
		for _, s := range m.OutputMetricHandlers {
			l = len(s)
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	if len(m.EnvVars) > 0 {
		for _, s := range m.EnvVars {
			l = len(s)
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	l = m.ObjectMeta.Size()
	n += 2 + l + sovCheck(uint64(l))
	if m.MaxOutputSize != 0 {
		n += 2 + sovCheck(uint64(m.MaxOutputSize))
	}
	if m.DiscardOutput {
		n += 3
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	if len(m.OutputMetricTags) > 0 {
		for _, e := range m.OutputMetricTags {
			l = e.Size()
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	l = len(m.Scheduler)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Check) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Command)
	if l > 0 {
		n += 1 + l + sovCheck(uint64(l))
	}
	if len(m.Handlers) > 0 {
		for _, s := range m.Handlers {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.HighFlapThreshold != 0 {
		n += 1 + sovCheck(uint64(m.HighFlapThreshold))
	}
	if m.Interval != 0 {
		n += 1 + sovCheck(uint64(m.Interval))
	}
	if m.LowFlapThreshold != 0 {
		n += 1 + sovCheck(uint64(m.LowFlapThreshold))
	}
	if m.Publish {
		n += 2
	}
	if len(m.RuntimeAssets) > 0 {
		for _, s := range m.RuntimeAssets {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if len(m.Subscriptions) > 0 {
		for _, s := range m.Subscriptions {
			l = len(s)
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	l = len(m.ProxyEntityName)
	if l > 0 {
		n += 1 + l + sovCheck(uint64(l))
	}
	if len(m.CheckHooks) > 0 {
		for _, e := range m.CheckHooks {
			l = e.Size()
			n += 1 + l + sovCheck(uint64(l))
		}
	}
	if m.Stdin {
		n += 2
	}
	if m.Subdue != nil {
		l = m.Subdue.Size()
		n += 2 + l + sovCheck(uint64(l))
	}
	l = len(m.Cron)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	if m.Ttl != 0 {
		n += 2 + sovCheck(uint64(m.Ttl))
	}
	if m.Timeout != 0 {
		n += 2 + sovCheck(uint64(m.Timeout))
	}
	if m.ProxyRequests != nil {
		l = m.ProxyRequests.Size()
		n += 2 + l + sovCheck(uint64(l))
	}
	if m.RoundRobin {
		n += 3
	}
	if m.Duration != 0 {
		n += 10
	}
	if m.Executed != 0 {
		n += 2 + sovCheck(uint64(m.Executed))
	}
	if len(m.History) > 0 {
		for _, e := range m.History {
			l = e.Size()
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	if m.Issued != 0 {
		n += 2 + sovCheck(uint64(m.Issued))
	}
	l = len(m.Output)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	l = len(m.State)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	if m.Status != 0 {
		n += 2 + sovCheck(uint64(m.Status))
	}
	if m.TotalStateChange != 0 {
		n += 2 + sovCheck(uint64(m.TotalStateChange))
	}
	if m.LastOK != 0 {
		n += 2 + sovCheck(uint64(m.LastOK))
	}
	if m.Occurrences != 0 {
		n += 2 + sovCheck(uint64(m.Occurrences))
	}
	if m.OccurrencesWatermark != 0 {
		n += 2 + sovCheck(uint64(m.OccurrencesWatermark))
	}
	if len(m.Silenced) > 0 {
		for _, s := range m.Silenced {
			l = len(s)
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	if len(m.Hooks) > 0 {
		for _, e := range m.Hooks {
			l = e.Size()
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	l = len(m.OutputMetricFormat)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	if len(m.OutputMetricHandlers) > 0 {
		for _, s := range m.OutputMetricHandlers {
			l = len(s)
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	if len(m.EnvVars) > 0 {
		for _, s := range m.EnvVars {
			l = len(s)
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	l = m.ObjectMeta.Size()
	n += 2 + l + sovCheck(uint64(l))
	if m.MaxOutputSize != 0 {
		n += 2 + sovCheck(uint64(m.MaxOutputSize))
	}
	if m.DiscardOutput {
		n += 3
	}
	if len(m.Secrets) > 0 {
		for _, e := range m.Secrets {
			l = e.Size()
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	if m.IsSilenced {
		n += 3
	}
	if len(m.OutputMetricTags) > 0 {
		for _, e := range m.OutputMetricTags {
			l = e.Size()
			n += 2 + l + sovCheck(uint64(l))
		}
	}
	l = len(m.Scheduler)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	l = len(m.ExtendedAttributes)
	if l > 0 {
		n += 2 + l + sovCheck(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *CheckHistory) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Status != 0 {
		n += 1 + sovCheck(uint64(m.Status))
	}
	if m.Executed != 0 {
		n += 1 + sovCheck(uint64(m.Executed))
	}
	if m.Flapping {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovCheck(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozCheck(x uint64) (n int) {
	return sovCheck(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *CheckRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Config == nil {
				m.Config = &CheckConfig{}
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Assets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Assets = append(m.Assets, Asset{})
			if err := m.Assets[len(m.Assets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hooks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hooks = append(m.Hooks, HookConfig{})
			if err := m.Hooks[len(m.Hooks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issued", wireType)
			}
			m.Issued = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Issued |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HookAssets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HookAssets == nil {
				m.HookAssets = make(map[string]*AssetList)
			}
			var mapkey string
			var mapvalue *AssetList
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowCheck
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCheck
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthCheck
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthCheck
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowCheck
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthCheck
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthCheck
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &AssetList{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipCheck(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthCheck
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.HookAssets[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AssetList) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AssetList: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AssetList: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Assets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Assets = append(m.Assets, Asset{})
			if err := m.Assets[len(m.Assets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProxyRequests) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProxyRequests: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProxyRequests: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EntityAttributes", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EntityAttributes = append(m.EntityAttributes, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Splay", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Splay = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplayCoverage", wireType)
			}
			m.SplayCoverage = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SplayCoverage |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handlers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Handlers = append(m.Handlers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighFlapThreshold", wireType)
			}
			m.HighFlapThreshold = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HighFlapThreshold |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			m.Interval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Interval |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LowFlapThreshold", wireType)
			}
			m.LowFlapThreshold = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LowFlapThreshold |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Publish", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Publish = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeAssets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeAssets = append(m.RuntimeAssets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscriptions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subscriptions = append(m.Subscriptions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtendedAttributes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtendedAttributes = append(m.ExtendedAttributes[:0], dAtA[iNdEx:postIndex]...)
			if m.ExtendedAttributes == nil {
				m.ExtendedAttributes = []byte{}
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyEntityName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyEntityName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckHooks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CheckHooks = append(m.CheckHooks, HookList{})
			if err := m.CheckHooks[len(m.CheckHooks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Stdin = bool(v != 0)
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subdue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subdue == nil {
				m.Subdue = &TimeWindowWhen{}
			}
			if err := m.Subdue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cron", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cron = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			m.Ttl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ttl |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyRequests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProxyRequests == nil {
				m.ProxyRequests = &ProxyRequests{}
			}
			if err := m.ProxyRequests.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoundRobin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RoundRobin = bool(v != 0)
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputMetricFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutputMetricFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputMetricHandlers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutputMetricHandlers = append(m.OutputMetricHandlers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvVars", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnvVars = append(m.EnvVars, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 27:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxOutputSize", wireType)
			}
			m.MaxOutputSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxOutputSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 28:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscardOutput", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DiscardOutput = bool(v != 0)
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, &Secret{})
			if err := m.Secrets[len(m.Secrets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputMetricTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutputMetricTags = append(m.OutputMetricTags, &MetricTag{})
			if err := m.OutputMetricTags[len(m.OutputMetricTags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheduler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scheduler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Check) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Check: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Check: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Command", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Command = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handlers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Handlers = append(m.Handlers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighFlapThreshold", wireType)
			}
			m.HighFlapThreshold = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HighFlapThreshold |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interval", wireType)
			}
			m.Interval = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Interval |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LowFlapThreshold", wireType)
			}
			m.LowFlapThreshold = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LowFlapThreshold |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Publish", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Publish = bool(v != 0)
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RuntimeAssets", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RuntimeAssets = append(m.RuntimeAssets, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subscriptions", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subscriptions = append(m.Subscriptions, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyEntityName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ProxyEntityName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckHooks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CheckHooks = append(m.CheckHooks, HookList{})
			if err := m.CheckHooks[len(m.CheckHooks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Stdin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Stdin = bool(v != 0)
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subdue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Subdue == nil {
				m.Subdue = &TimeWindowWhen{}
			}
			if err := m.Subdue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cron", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Cron = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ttl", wireType)
			}
			m.Ttl = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Ttl |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timeout", wireType)
			}
			m.Timeout = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Timeout |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ProxyRequests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ProxyRequests == nil {
				m.ProxyRequests = &ProxyRequests{}
			}
			if err := m.ProxyRequests.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RoundRobin", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RoundRobin = bool(v != 0)
		case 22:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			v = uint64(encoding_binary.LittleEndian.Uint64(dAtA[iNdEx:]))
			iNdEx += 8
			m.Duration = float64(math.Float64frombits(v))
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executed", wireType)
			}
			m.Executed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Executed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field History", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.History = append(m.History, CheckHistory{})
			if err := m.History[len(m.History)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issued", wireType)
			}
			m.Issued = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Issued |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Output", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Output = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.State = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 28:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 29:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TotalStateChange", wireType)
			}
			m.TotalStateChange = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TotalStateChange |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 30:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastOK", wireType)
			}
			m.LastOK = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastOK |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 31:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Occurrences", wireType)
			}
			m.Occurrences = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Occurrences |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 32:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OccurrencesWatermark", wireType)
			}
			m.OccurrencesWatermark = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OccurrencesWatermark |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Silenced", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Silenced = append(m.Silenced, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hooks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Hooks = append(m.Hooks, &Hook{})
			if err := m.Hooks[len(m.Hooks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputMetricFormat", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutputMetricFormat = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputMetricHandlers", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutputMetricHandlers = append(m.OutputMetricHandlers, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EnvVars", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EnvVars = append(m.EnvVars, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 38:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ObjectMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ObjectMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 39:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxOutputSize", wireType)
			}
			m.MaxOutputSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxOutputSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 40:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DiscardOutput", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DiscardOutput = bool(v != 0)
		case 41:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secrets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secrets = append(m.Secrets, &Secret{})
			if err := m.Secrets[len(m.Secrets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 42:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IsSilenced", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IsSilenced = bool(v != 0)
		case 43:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputMetricTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OutputMetricTags = append(m.OutputMetricTags, &MetricTag{})
			if err := m.OutputMetricTags[len(m.OutputMetricTags)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 44:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scheduler", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Scheduler = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 99:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtendedAttributes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCheck
			}
			postIndex := iNdEx + byteLen
			if postIndex < 0 {
				return ErrInvalidLengthCheck
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExtendedAttributes = append(m.ExtendedAttributes[:0], dAtA[iNdEx:postIndex]...)
			if m.ExtendedAttributes == nil {
				m.ExtendedAttributes = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckHistory) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckHistory: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckHistory: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Executed", wireType)
			}
			m.Executed = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Executed |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flapping", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Flapping = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipCheck(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthCheck
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCheck(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCheck
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCheck
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthCheck
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupCheck
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthCheck
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthCheck        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCheck          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupCheck = fmt.Errorf("proto: unexpected end of group")
)
