//go:build go1.16
// +build go1.16

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azblob

import (
	"context"
	"net/http"
	"strconv"
	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
)

type directoryClient struct {
	con            *connection
	pathRenameMode *PathRenameMode
}

// Create - Create a directory. By default, the destination is overwritten and if the destination already exists and has a lease the lease is broken. This
// operation supports conditional HTTP requests. For more
// information, see Specifying Conditional Headers for Blob Service Operations [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// To
// fail if the destination already exists, use a conditional request with If-None-Match: "*".
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *directoryClient) Create(ctx context.Context, directoryCreateOptions *DirectoryCreateOptions, directoryHTTPHeaders *DirectoryHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (DirectoryCreateResponse, error) {
	req, err := client.createCreateRequest(ctx, directoryCreateOptions, directoryHTTPHeaders, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return DirectoryCreateResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return DirectoryCreateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return DirectoryCreateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createHandleResponse(resp)
}

// createCreateRequest creates the Create request.
func (client *directoryClient) createCreateRequest(ctx context.Context, directoryCreateOptions *DirectoryCreateOptions, directoryHTTPHeaders *DirectoryHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("resource", "directory")
	if directoryCreateOptions != nil && directoryCreateOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*directoryCreateOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if directoryCreateOptions != nil && directoryCreateOptions.DirectoryProperties != nil {
		req.Raw().Header.Set("x-ms-properties", *directoryCreateOptions.DirectoryProperties)
	}
	if directoryCreateOptions != nil && directoryCreateOptions.PosixPermissions != nil {
		req.Raw().Header.Set("x-ms-permissions", *directoryCreateOptions.PosixPermissions)
	}
	if directoryCreateOptions != nil && directoryCreateOptions.PosixUmask != nil {
		req.Raw().Header.Set("x-ms-umask", *directoryCreateOptions.PosixUmask)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.CacheControl != nil {
		req.Raw().Header.Set("x-ms-cache-control", *directoryHTTPHeaders.CacheControl)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentType != nil {
		req.Raw().Header.Set("x-ms-content-type", *directoryHTTPHeaders.ContentType)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header.Set("x-ms-content-encoding", *directoryHTTPHeaders.ContentEncoding)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header.Set("x-ms-content-language", *directoryHTTPHeaders.ContentLanguage)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header.Set("x-ms-content-disposition", *directoryHTTPHeaders.ContentDisposition)
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if directoryCreateOptions != nil && directoryCreateOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *directoryCreateOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *directoryClient) createHandleResponse(resp *http.Response) (DirectoryCreateResponse, error) {
	result := DirectoryCreateResponse{RawResponse: resp}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectoryCreateResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return DirectoryCreateResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectoryCreateResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// Delete - Deletes the directory
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *directoryClient) Delete(ctx context.Context, recursiveDirectoryDelete bool, directoryDeleteOptions *DirectoryDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (DirectoryDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, recursiveDirectoryDelete, directoryDeleteOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return DirectoryDeleteResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return DirectoryDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DirectoryDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return client.deleteHandleResponse(resp)
}

// deleteCreateRequest creates the Delete request.
func (client *directoryClient) deleteCreateRequest(ctx context.Context, recursiveDirectoryDelete bool, directoryDeleteOptions *DirectoryDeleteOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodDelete, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if directoryDeleteOptions != nil && directoryDeleteOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*directoryDeleteOptions.Timeout), 10))
	}
	reqQP.Set("recursive", strconv.FormatBool(recursiveDirectoryDelete))
	if directoryDeleteOptions != nil && directoryDeleteOptions.Marker != nil {
		reqQP.Set("continuation", *directoryDeleteOptions.Marker)
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if directoryDeleteOptions != nil && directoryDeleteOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *directoryDeleteOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// deleteHandleResponse handles the Delete response.
func (client *directoryClient) deleteHandleResponse(resp *http.Response) (DirectoryDeleteResponse, error) {
	result := DirectoryDeleteResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-continuation"); val != "" {
		result.Marker = &val
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectoryDeleteResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// GetAccessControl - Get the owner, group, permissions, or access control list for a directory.
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *directoryClient) GetAccessControl(ctx context.Context, directoryGetAccessControlOptions *DirectoryGetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (DirectoryGetAccessControlResponse, error) {
	req, err := client.getAccessControlCreateRequest(ctx, directoryGetAccessControlOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return DirectoryGetAccessControlResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return DirectoryGetAccessControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DirectoryGetAccessControlResponse{}, runtime.NewResponseError(resp)
	}
	return client.getAccessControlHandleResponse(resp)
}

// getAccessControlCreateRequest creates the GetAccessControl request.
func (client *directoryClient) getAccessControlCreateRequest(ctx context.Context, directoryGetAccessControlOptions *DirectoryGetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodHead, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "getAccessControl")
	if directoryGetAccessControlOptions != nil && directoryGetAccessControlOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*directoryGetAccessControlOptions.Timeout), 10))
	}
	if directoryGetAccessControlOptions != nil && directoryGetAccessControlOptions.Upn != nil {
		reqQP.Set("upn", strconv.FormatBool(*directoryGetAccessControlOptions.Upn))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if directoryGetAccessControlOptions != nil && directoryGetAccessControlOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *directoryGetAccessControlOptions.RequestID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// getAccessControlHandleResponse handles the GetAccessControl response.
func (client *directoryClient) getAccessControlHandleResponse(resp *http.Response) (DirectoryGetAccessControlResponse, error) {
	result := DirectoryGetAccessControlResponse{RawResponse: resp}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectoryGetAccessControlResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectoryGetAccessControlResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-owner"); val != "" {
		result.XMSOwner = &val
	}
	if val := resp.Header.Get("x-ms-group"); val != "" {
		result.XMSGroup = &val
	}
	if val := resp.Header.Get("x-ms-permissions"); val != "" {
		result.XMSPermissions = &val
	}
	if val := resp.Header.Get("x-ms-acl"); val != "" {
		result.XMSACL = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}

// Rename - Rename a directory. By default, the destination is overwritten and if the destination already exists and has a lease the lease is broken. This
// operation supports conditional HTTP requests. For more
// information, see Specifying Conditional Headers for Blob Service Operations [https://docs.microsoft.com/en-us/rest/api/storageservices/specifying-conditional-headers-for-blob-service-operations].
// To
// fail if the destination already exists, use a conditional request with If-None-Match: "*".
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *directoryClient) Rename(ctx context.Context, renameSource string, directoryRenameOptions *DirectoryRenameOptions, directoryHTTPHeaders *DirectoryHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, sourceModifiedAccessConditions *SourceModifiedAccessConditions) (DirectoryRenameResponse, error) {
	req, err := client.renameCreateRequest(ctx, renameSource, directoryRenameOptions, directoryHTTPHeaders, leaseAccessConditions, modifiedAccessConditions, sourceModifiedAccessConditions)
	if err != nil {
		return DirectoryRenameResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return DirectoryRenameResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusCreated) {
		return DirectoryRenameResponse{}, runtime.NewResponseError(resp)
	}
	return client.renameHandleResponse(resp)
}

// renameCreateRequest creates the Rename request.
func (client *directoryClient) renameCreateRequest(ctx context.Context, renameSource string, directoryRenameOptions *DirectoryRenameOptions, directoryHTTPHeaders *DirectoryHTTPHeaders, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions, sourceModifiedAccessConditions *SourceModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPut, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	if directoryRenameOptions != nil && directoryRenameOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*directoryRenameOptions.Timeout), 10))
	}
	if directoryRenameOptions != nil && directoryRenameOptions.Marker != nil {
		reqQP.Set("continuation", *directoryRenameOptions.Marker)
	}
	if client.pathRenameMode != nil {
		reqQP.Set("mode", string(*client.pathRenameMode))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header.Set("x-ms-rename-source", renameSource)
	if directoryRenameOptions != nil && directoryRenameOptions.DirectoryProperties != nil {
		req.Raw().Header.Set("x-ms-properties", *directoryRenameOptions.DirectoryProperties)
	}
	if directoryRenameOptions != nil && directoryRenameOptions.PosixPermissions != nil {
		req.Raw().Header.Set("x-ms-permissions", *directoryRenameOptions.PosixPermissions)
	}
	if directoryRenameOptions != nil && directoryRenameOptions.PosixUmask != nil {
		req.Raw().Header.Set("x-ms-umask", *directoryRenameOptions.PosixUmask)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.CacheControl != nil {
		req.Raw().Header.Set("x-ms-cache-control", *directoryHTTPHeaders.CacheControl)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentType != nil {
		req.Raw().Header.Set("x-ms-content-type", *directoryHTTPHeaders.ContentType)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentEncoding != nil {
		req.Raw().Header.Set("x-ms-content-encoding", *directoryHTTPHeaders.ContentEncoding)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentLanguage != nil {
		req.Raw().Header.Set("x-ms-content-language", *directoryHTTPHeaders.ContentLanguage)
	}
	if directoryHTTPHeaders != nil && directoryHTTPHeaders.ContentDisposition != nil {
		req.Raw().Header.Set("x-ms-content-disposition", *directoryHTTPHeaders.ContentDisposition)
	}
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if directoryRenameOptions != nil && directoryRenameOptions.SourceLeaseID != nil {
		req.Raw().Header.Set("x-ms-source-lease-id", *directoryRenameOptions.SourceLeaseID)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfModifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-modified-since", sourceModifiedAccessConditions.SourceIfModifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfUnmodifiedSince != nil {
		req.Raw().Header.Set("x-ms-source-if-unmodified-since", sourceModifiedAccessConditions.SourceIfUnmodifiedSince.Format(time.RFC1123))
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-match", *sourceModifiedAccessConditions.SourceIfMatch)
	}
	if sourceModifiedAccessConditions != nil && sourceModifiedAccessConditions.SourceIfNoneMatch != nil {
		req.Raw().Header.Set("x-ms-source-if-none-match", *sourceModifiedAccessConditions.SourceIfNoneMatch)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	if directoryRenameOptions != nil && directoryRenameOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *directoryRenameOptions.RequestID)
	}
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// renameHandleResponse handles the Rename response.
func (client *directoryClient) renameHandleResponse(resp *http.Response) (DirectoryRenameResponse, error) {
	result := DirectoryRenameResponse{RawResponse: resp}
	if val := resp.Header.Get("x-ms-continuation"); val != "" {
		result.Marker = &val
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectoryRenameResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-client-request-id"); val != "" {
		result.ClientRequestID = &val
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	if val := resp.Header.Get("Content-Length"); val != "" {
		contentLength, err := strconv.ParseInt(val, 10, 64)
		if err != nil {
			return DirectoryRenameResponse{}, err
		}
		result.ContentLength = &contentLength
	}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectoryRenameResponse{}, err
		}
		result.Date = &date
	}
	return result, nil
}

// SetAccessControl - Set the owner, group, permissions, or access control list for a directory.
// If the operation fails it returns the *DataLakeStorageError error type.
func (client *directoryClient) SetAccessControl(ctx context.Context, directorySetAccessControlOptions *DirectorySetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (DirectorySetAccessControlResponse, error) {
	req, err := client.setAccessControlCreateRequest(ctx, directorySetAccessControlOptions, leaseAccessConditions, modifiedAccessConditions)
	if err != nil {
		return DirectorySetAccessControlResponse{}, err
	}
	resp, err := client.con.Pipeline().Do(req)
	if err != nil {
		return DirectorySetAccessControlResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return DirectorySetAccessControlResponse{}, runtime.NewResponseError(resp)
	}
	return client.setAccessControlHandleResponse(resp)
}

// setAccessControlCreateRequest creates the SetAccessControl request.
func (client *directoryClient) setAccessControlCreateRequest(ctx context.Context, directorySetAccessControlOptions *DirectorySetAccessControlOptions, leaseAccessConditions *LeaseAccessConditions, modifiedAccessConditions *ModifiedAccessConditions) (*policy.Request, error) {
	req, err := runtime.NewRequest(ctx, http.MethodPatch, client.con.Endpoint())
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("action", "setAccessControl")
	if directorySetAccessControlOptions != nil && directorySetAccessControlOptions.Timeout != nil {
		reqQP.Set("timeout", strconv.FormatInt(int64(*directorySetAccessControlOptions.Timeout), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	if leaseAccessConditions != nil && leaseAccessConditions.LeaseID != nil {
		req.Raw().Header.Set("x-ms-lease-id", *leaseAccessConditions.LeaseID)
	}
	if directorySetAccessControlOptions != nil && directorySetAccessControlOptions.Owner != nil {
		req.Raw().Header.Set("x-ms-owner", *directorySetAccessControlOptions.Owner)
	}
	if directorySetAccessControlOptions != nil && directorySetAccessControlOptions.Group != nil {
		req.Raw().Header.Set("x-ms-group", *directorySetAccessControlOptions.Group)
	}
	if directorySetAccessControlOptions != nil && directorySetAccessControlOptions.PosixPermissions != nil {
		req.Raw().Header.Set("x-ms-permissions", *directorySetAccessControlOptions.PosixPermissions)
	}
	if directorySetAccessControlOptions != nil && directorySetAccessControlOptions.PosixACL != nil {
		req.Raw().Header.Set("x-ms-acl", *directorySetAccessControlOptions.PosixACL)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfMatch != nil {
		req.Raw().Header.Set("If-Match", *modifiedAccessConditions.IfMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfNoneMatch != nil {
		req.Raw().Header.Set("If-None-Match", *modifiedAccessConditions.IfNoneMatch)
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfModifiedSince != nil {
		req.Raw().Header.Set("If-Modified-Since", modifiedAccessConditions.IfModifiedSince.Format(time.RFC1123))
	}
	if modifiedAccessConditions != nil && modifiedAccessConditions.IfUnmodifiedSince != nil {
		req.Raw().Header.Set("If-Unmodified-Since", modifiedAccessConditions.IfUnmodifiedSince.Format(time.RFC1123))
	}
	if directorySetAccessControlOptions != nil && directorySetAccessControlOptions.RequestID != nil {
		req.Raw().Header.Set("x-ms-client-request-id", *directorySetAccessControlOptions.RequestID)
	}
	req.Raw().Header.Set("x-ms-version", "2019-12-12")
	req.Raw().Header.Set("Accept", "application/xml")
	return req, nil
}

// setAccessControlHandleResponse handles the SetAccessControl response.
func (client *directoryClient) setAccessControlHandleResponse(resp *http.Response) (DirectorySetAccessControlResponse, error) {
	result := DirectorySetAccessControlResponse{RawResponse: resp}
	if val := resp.Header.Get("Date"); val != "" {
		date, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectorySetAccessControlResponse{}, err
		}
		result.Date = &date
	}
	if val := resp.Header.Get("ETag"); val != "" {
		result.ETag = &val
	}
	if val := resp.Header.Get("Last-Modified"); val != "" {
		lastModified, err := time.Parse(time.RFC1123, val)
		if err != nil {
			return DirectorySetAccessControlResponse{}, err
		}
		result.LastModified = &lastModified
	}
	if val := resp.Header.Get("x-ms-request-id"); val != "" {
		result.RequestID = &val
	}
	if val := resp.Header.Get("x-ms-version"); val != "" {
		result.Version = &val
	}
	return result, nil
}
