/* test-umockdev-run.c generated by valac 0.40.4, the Vala compiler
 * generated from test-umockdev-run.vala, do not modify */

/*
 * test-umockdev-run.vala
 *
 * Copyright (C) 2013 Canonical Ltd.
 * Author: Martin Pitt <martin.pitt@ubuntu.com>
 *
 * umockdev is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * umockdev is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <sys/wait.h>
#include <signal.h>
#include "config.h"
#include <glib/gstdio.h>
#include <unistd.h>
#include <float.h>
#include <math.h>
#include <sys/stat.h>
#include <sys/types.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);


extern gchar* rootdir;
gchar* rootdir = NULL;

#define umockdev_run_command "env LC_ALL=C umockdev-run "
void assert_in (const gchar* needle,
                const gchar* haystack);
gboolean have_program (const gchar* program);
gboolean get_program_out (const gchar* program,
                          const gchar* command,
                          gchar* * sout,
                          gchar* * serr,
                          gint* exit);
void check_program_out (const gchar* program,
                        const gchar* run_command,
                        const gchar* expected_out);
void check_program_error (const gchar* program,
                          const gchar* run_command,
                          const gchar* expected_err);
void t_run_exit_code (void);
void t_run_version (void);
void t_run_pipes (void);
void t_run_invalid_args (void);
void t_run_invalid_device (void);
void t_run_invalid_ioctl (void);
void t_run_invalid_script (void);
void t_run_invalid_program (void);
void t_run_script_chatter (void);
void t_run_script_chatter_socket_stream (void);
void t_gphoto_detect (void);
gboolean check_gphoto_version (void);
void t_gphoto_folderlist (void);
void t_gphoto_filelist (void);
void t_gphoto_thumbs (void);
void t_gphoto_download (void);
void t_input_touchpad (void);
void t_input_evtest (void);
void t_input_evtest_evemu (void);
gint _vala_main (gchar** args,
                 int args_length1);
static void _t_run_exit_code_gtest_func (void);
static void _t_run_version_gtest_func (void);
static void _t_run_pipes_gtest_func (void);
static void _t_run_invalid_args_gtest_func (void);
static void _t_run_invalid_device_gtest_func (void);
static void _t_run_invalid_ioctl_gtest_func (void);
static void _t_run_invalid_script_gtest_func (void);
static void _t_run_invalid_program_gtest_func (void);
static void _t_run_script_chatter_gtest_func (void);
static void _t_run_script_chatter_socket_stream_gtest_func (void);
static void _t_gphoto_detect_gtest_func (void);
static void _t_input_touchpad_gtest_func (void);
static void _t_input_evtest_gtest_func (void);
static void _t_input_evtest_evemu_gtest_func (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


void
assert_in (const gchar* needle,
           const gchar* haystack)
{
	g_return_if_fail (needle != NULL);
	g_return_if_fail (haystack != NULL);
	if (!string_contains (haystack, needle)) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "'%s' not found in '%s'\n", needle, haystack);
		abort ();
	}
}


gboolean
have_program (const gchar* program)
{
	gboolean result = FALSE;
	gchar* sout = NULL;
	gint exit = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (program != NULL, FALSE);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		_tmp0_ = g_strconcat ("which ", program, NULL);
		_tmp1_ = _tmp0_;
		g_spawn_command_line_sync (_tmp1_, &_tmp2_, NULL, &_tmp3_, &_inner_error_);
		_g_free0 (sout);
		sout = _tmp2_;
		exit = _tmp3_;
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (sout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp4_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e->message;
		fprintf (_tmp5_, "cannot call which %s: %s\n", program, _tmp6_);
		abort ();
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		_g_free0 (sout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	result = exit == 0;
	_g_free0 (sout);
	return result;
}


gboolean
get_program_out (const gchar* program,
                 const gchar* command,
                 gchar* * sout,
                 gchar* * serr,
                 gint* exit)
{
	gchar* _vala_sout = NULL;
	gchar* _vala_serr = NULL;
	gint _vala_exit = 0;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (program != NULL, FALSE);
	g_return_val_if_fail (command != NULL, FALSE);
	if (!have_program (program)) {
		FILE* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: %s not installed] ", program);
		_tmp1_ = g_strdup ("");
		_g_free0 (_vala_sout);
		_vala_sout = _tmp1_;
		_tmp2_ = g_strdup ("");
		_g_free0 (_vala_serr);
		_vala_serr = _tmp2_;
		_vala_exit = -1;
		result = FALSE;
		if (sout) {
			*sout = _vala_sout;
		} else {
			_g_free0 (_vala_sout);
		}
		if (serr) {
			*serr = _vala_serr;
		} else {
			_g_free0 (_vala_serr);
		}
		if (exit) {
			*exit = _vala_exit;
		}
		return result;
	}
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		g_spawn_command_line_sync (command, &_tmp3_, &_tmp4_, &_tmp5_, &_inner_error_);
		_g_free0 (_vala_sout);
		_vala_sout = _tmp3_;
		_g_free0 (_vala_serr);
		_vala_serr = _tmp4_;
		_vala_exit = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp6_;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e->message;
		fprintf (_tmp7_, "cannot call %s: %s\n", command, _tmp8_);
		abort ();
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp9_;
	}
	result = TRUE;
	if (sout) {
		*sout = _vala_sout;
	} else {
		_g_free0 (_vala_sout);
	}
	if (serr) {
		*serr = _vala_serr;
	} else {
		_g_free0 (_vala_serr);
	}
	if (exit) {
		*exit = _vala_exit;
	}
	return result;
}


void
check_program_out (const gchar* program,
                   const gchar* run_command,
                   const gchar* expected_out)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gint _tmp9_;
	g_return_if_fail (program != NULL);
	g_return_if_fail (run_command != NULL);
	g_return_if_fail (expected_out != NULL);
	_tmp0_ = g_strconcat (umockdev_run_command, run_command, NULL);
	_tmp1_ = _tmp0_;
	_tmp5_ = get_program_out (program, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (sout);
	sout = _tmp2_;
	_g_free0 (serr);
	serr = _tmp3_;
	exit = _tmp4_;
	_tmp6_ = !_tmp5_;
	_g_free0 (_tmp1_);
	if (_tmp6_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp7_ = sout;
	g_assert_cmpstr (_tmp7_, ==, expected_out);
	_tmp8_ = serr;
	g_assert_cmpstr (_tmp8_, ==, "");
	_tmp9_ = exit;
	g_assert_cmpint (_tmp9_, ==, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}


void
check_program_error (const gchar* program,
                     const gchar* run_command,
                     const gchar* expected_err)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_;
	gboolean _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	const gchar* _tmp10_;
	g_return_if_fail (program != NULL);
	g_return_if_fail (run_command != NULL);
	g_return_if_fail (expected_err != NULL);
	_tmp0_ = g_strconcat (umockdev_run_command, run_command, NULL);
	_tmp1_ = _tmp0_;
	_tmp5_ = get_program_out (program, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	_g_free0 (sout);
	sout = _tmp2_;
	_g_free0 (serr);
	serr = _tmp3_;
	exit = _tmp4_;
	_tmp6_ = !_tmp5_;
	_g_free0 (_tmp1_);
	if (_tmp6_) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp7_ = serr;
	assert_in (expected_err, _tmp7_);
	_tmp8_ = exit;
	g_assert_cmpint (_tmp8_, !=, 0);
	_tmp9_ = exit;
	_vala_assert (WIFEXITED (_tmp9_), "Process.if_exited (exit)");
	_tmp10_ = sout;
	g_assert_cmpstr (_tmp10_, ==, "");
	_g_free0 (serr);
	_g_free0 (sout);
}


void
t_run_exit_code (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_;
	gint _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	check_program_out ("true", umockdev_run_command "true", "");
	get_program_out ("ls", umockdev_run_command "ls /nonexisting", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	_tmp3_ = exit;
	_vala_assert (WIFEXITED (_tmp3_), "Process.if_exited (exit)");
	_tmp4_ = exit;
	g_assert_cmpint (WEXITSTATUS (_tmp4_), ==, 2);
	_tmp5_ = sout;
	g_assert_cmpstr (_tmp5_, ==, "");
	_tmp6_ = serr;
	g_assert_cmpstr (_tmp6_, !=, "");
	get_program_out ("sh", umockdev_run_command "-- sh -c 'kill -SEGV $$'", &_tmp7_, &_tmp8_, &_tmp9_);
	_g_free0 (sout);
	sout = _tmp7_;
	_g_free0 (serr);
	serr = _tmp8_;
	exit = _tmp9_;
	_tmp10_ = exit;
	_vala_assert (WIFSIGNALED (_tmp10_), "Process.if_signaled (exit)");
	_tmp11_ = exit;
	g_assert_cmpint ((gint) WTERMSIG (_tmp11_), ==, (gint) SIGSEGV);
	_tmp12_ = sout;
	g_assert_cmpstr (_tmp12_, ==, "");
	_tmp13_ = serr;
	g_assert_cmpstr (_tmp13_, ==, "");
	_g_free0 (serr);
	_g_free0 (sout);
}


void
t_run_version (void)
{
	check_program_out ("true", "--version", VERSION "\n");
}


void
t_run_pipes (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	_tmp3_ = get_program_out ("echo", "sh -c 'echo hello | " umockdev_run_command "cat'", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	_vala_assert (_tmp3_, "get_program_out (\"echo\", \"sh -c 'echo hello | \" + umockdev_run_command + \"cat'\",                             out sout, out serr, out exit)");
	g_assert_cmpstr (sout, ==, "hello\n");
	g_assert_cmpstr (serr, ==, "");
	g_assert_cmpint (exit, ==, 0);
	_g_free0 (serr);
	_g_free0 (sout);
}


void
t_run_invalid_args (void)
{
	check_program_error ("true", "", "--help");
	check_program_error ("true", "--foobarize", "--help");
}


void
t_run_invalid_device (void)
{
	GError * _inner_error_ = NULL;
	check_program_error ("true", "-d non.existing", "Cannot open non.existing:");
	{
		gchar* umockdev_file = NULL;
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_;
		gint _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp1_ = g_file_open_tmp ("ttyS0.XXXXXX.umockdev", &_tmp0_, &_inner_error_);
		_g_free0 (umockdev_file);
		umockdev_file = _tmp0_;
		fd = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (umockdev_file);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = fd;
		close (_tmp2_);
		_tmp3_ = umockdev_file;
		g_file_set_contents (_tmp3_, "P: /devices/foo\n", (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (umockdev_file);
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = umockdev_file;
		_tmp5_ = g_strconcat ("-d ", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = umockdev_file;
		_tmp8_ = g_strconcat ("Invalid record file ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp9_, ": missing SUBSYSTEM", NULL);
		_tmp11_ = _tmp10_;
		check_program_error ("true", _tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp6_);
		_g_free0 (umockdev_file);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = e->message;
		fprintf (_tmp12_, "cannot create temporary file: %s\n", _tmp13_);
		abort ();
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void
t_run_invalid_ioctl (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/dev/bus/usb/001/011=/non/existing.ioctl -- gphoto2 -l", NULL);
	_tmp6_ = _tmp5_;
	check_program_error ("gphoto2", _tmp6_, "/non/existing.ioctl");
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = rootdir;
	_tmp8_ = g_strconcat ("-d ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/dev/bus/usb/001/011=/dev/null -- gphoto2 -l", NULL);
	_tmp13_ = _tmp12_;
	check_program_error ("gphoto2", _tmp13_, "001/011");
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp14_ = rootdir;
	_tmp15_ = g_strconcat ("-d ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/dev/bus/usb/001/011=", NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = rootdir;
	_tmp22_ = g_strconcat (_tmp20_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strconcat (_tmp23_, "/NEWS -- gphoto2 -l", NULL);
	_tmp25_ = _tmp24_;
	check_program_error ("gphoto2", _tmp25_, "001/011");
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_tmp26_ = rootdir;
	_tmp27_ = g_strconcat ("-d ", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "/devices/cameras/canon-powershot-sx200.umockdev -i ", NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "/dev/bus/usb/001/011 -- gphoto2 -l", NULL);
	_tmp32_ = _tmp31_;
	check_program_error ("gphoto2", _tmp32_, "--ioctl");
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
}


void
t_run_invalid_script (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -s ", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "/dev/bus/usb/001/011 -- true", NULL);
	_tmp6_ = _tmp5_;
	check_program_error ("true", _tmp6_, "--script argument must be");
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = rootdir;
	_tmp8_ = g_strconcat ("-d ", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "/devices/cameras/canon-powershot-sx200.umockdev -s ", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "/dev/bus/usb/001/011=/etc/passwd -- true", NULL);
	_tmp13_ = _tmp12_;
	check_program_error ("true", _tmp13_, "not a device suitable for scripts");
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp14_ = rootdir;
	_tmp15_ = g_strconcat ("-d ", _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "/devices/input/usbkbd.umockdev -s ", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, "/dev/input/event5=/non/existing -- true", NULL);
	_tmp20_ = _tmp19_;
	check_program_error ("true", _tmp20_, "Cannot install /non/existing for device /dev/input/event5:");
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	check_program_error ("true", "-u /dev/mysock -- true", "--unix-stream argument must be");
}


void
t_run_invalid_program (void)
{
	check_program_error ("true", "no.such.prog", "Cannot run no.such.prog: Failed to execute");
}


void
t_run_script_chatter (void)
{
	gchar* umockdev_file = NULL;
	gchar* script_file = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	{
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_ = 0;
		gchar* _tmp4_ = NULL;
		gint _tmp5_;
		gint _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp1_ = g_file_open_tmp ("ttyS0.XXXXXX.umockdev", &_tmp0_, &_inner_error_);
		_g_free0 (umockdev_file);
		umockdev_file = _tmp0_;
		fd = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = fd;
		close (_tmp2_);
		_tmp5_ = g_file_open_tmp ("chatter.XXXXXX.script", &_tmp4_, &_inner_error_);
		_g_free0 (script_file);
		script_file = _tmp4_;
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		fd = _tmp3_;
		_tmp6_ = fd;
		close (_tmp6_);
		_tmp7_ = umockdev_file;
		g_file_set_contents (_tmp7_, "P: /devices/platform/serial8250/tty/ttyS0\n" \
"N: ttyS0\n" \
"E: DEVNAME=/dev/ttyS0\n" \
"E: SUBSYSTEM=tty\n" \
"A: dev=4:64", (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp8_ = script_file;
		g_file_set_contents (_tmp8_, "w 0 Hello world!^JWhat is your name?^J\n" \
"r 300 Joe Tester^J\n" \
"w 0 I \342\231\245 Joe Tester^Ja^I tab and a^J   line break in one wri" \
"te^J\n" \
"r 200 somejunk^J\n" \
"w 0 bye!^J", (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch3_g_file_error;
			}
			_g_free0 (script_file);
			_g_free0 (umockdev_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = stderr;
		_tmp10_ = e->message;
		fprintf (_tmp9_, "cannot create temporary file: %s\n", _tmp10_);
		abort ();
		_g_error_free0 (e);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (script_file);
		_g_free0 (umockdev_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp11_ = umockdev_file;
	_tmp12_ = g_strconcat ("-d ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, " -s /dev/ttyS0=", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = script_file;
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp18_, " -- tests/chatter /dev/ttyS0", NULL);
	_tmp20_ = _tmp19_;
	check_program_out ("true", _tmp20_, "Got input: Joe Tester\nGot input: somejunk\n");
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp21_ = umockdev_file;
	g_remove (_tmp21_);
	_tmp22_ = script_file;
	g_remove (_tmp22_);
	_g_free0 (script_file);
	_g_free0 (umockdev_file);
}


void
t_run_script_chatter_socket_stream (void)
{
	gchar* script_file = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GError * _inner_error_ = NULL;
	{
		gint fd = 0;
		gchar* _tmp0_ = NULL;
		gint _tmp1_;
		gint _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = g_file_open_tmp ("chatter.XXXXXX.script", &_tmp0_, &_inner_error_);
		_g_free0 (script_file);
		script_file = _tmp0_;
		fd = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (script_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp2_ = fd;
		close (_tmp2_);
		_tmp3_ = script_file;
		g_file_set_contents (_tmp3_, "w 0 What is your name?^J\n" \
"r 307 Joe Tester^J\n" \
"w 0 hello Joe Tester^J\n" \
"w 20 send()\n" \
"r 30 somejunk", (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			_g_free0 (script_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e->message;
		fprintf (_tmp4_, "cannot create temporary file: %s\n", _tmp5_);
		abort ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (script_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = script_file;
	_tmp7_ = g_strconcat (" -u /dev/socket/chatter=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, " -- tests/chatter-socket-stream /dev/socket/chatter", NULL);
	_tmp10_ = _tmp9_;
	check_program_out ("true", _tmp10_, "Got name: Joe Tester\n\nGot recv: somejunk\n");
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = script_file;
	g_remove (_tmp11_);
	_g_free0 (script_file);
}


void
t_gphoto_detect (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 --auto-detect", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("gphoto2", _tmp9_, "Model                          Port            \n" \
"----------------------------------------------------------\n" \
"Canon PowerShot SX200 IS       usb:001,011     \n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


static gdouble
double_parse (const gchar* str)
{
	gdouble result = 0.0;
	gdouble _tmp0_;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = g_ascii_strtod (str, NULL);
	result = _tmp0_;
	return result;
}


gboolean
check_gphoto_version (void)
{
	gboolean result = FALSE;
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gboolean _tmp3_;
	gchar** words = NULL;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint words_length1;
	gint _words_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	_tmp3_ = get_program_out ("gphoto2", "gphoto2 --version", &_tmp0_, &_tmp1_, &_tmp2_);
	_g_free0 (sout);
	sout = _tmp0_;
	_g_free0 (serr);
	serr = _tmp1_;
	exit = _tmp2_;
	if (!_tmp3_) {
		result = FALSE;
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	_tmp4_ = sout;
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, " ", 3);
	words = _tmp6_;
	words_length1 = _vala_array_length (_tmp5_);
	_words_size_ = words_length1;
	_tmp7_ = words;
	_tmp7__length1 = words_length1;
	if (_tmp7__length1 < 2) {
		result = FALSE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	_tmp8_ = words;
	_tmp8__length1 = words_length1;
	_tmp9_ = _tmp8_[1];
	if (double_parse (_tmp9_) < 2.5) {
		FILE* _tmp10_;
		_tmp10_ = stdout;
		fprintf (_tmp10_, "[SKIP: needs gphoto >= 2.5] ");
		result = FALSE;
		words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (serr);
		_g_free0 (sout);
		return result;
	}
	result = TRUE;
	words = (_vala_array_free (words, words_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (serr);
	_g_free0 (sout);
	return result;
}


void
t_gphoto_folderlist (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	if (!check_gphoto_version ()) {
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -l", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("gphoto2", _tmp9_, "There is 1 folder in folder '/'.\n" \
" - store_00010001\n" \
"There is 1 folder in folder '/store_00010001'.\n" \
" - DCIM\n" \
"There is 1 folder in folder '/store_00010001/DCIM'.\n" \
" - 100CANON\n" \
"There are 0 folders in folder '/store_00010001/DCIM/100CANON'.\n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


void
t_gphoto_filelist (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	if (!check_gphoto_version ()) {
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat ("-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -L", NULL);
	_tmp9_ = _tmp8_;
	check_program_out ("gphoto2", _tmp9_, "There is no file in folder '/'.\n" \
"There is no file in folder '/store_00010001'.\n" \
"There is no file in folder '/store_00010001/DCIM'.\n" \
"There are 2 files in folder '/store_00010001/DCIM/100CANON'.\n" \
"#1     IMG_0001.JPG               rd    67 KB  640x480  image/jpeg\n" \
"#2     IMG_0002.JPG               rd    88 KB  640x480  image/jpeg\n");
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
}


void
t_gphoto_thumbs (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	struct stat st = {0};
	struct stat _tmp16_ = {0};
	gint _tmp17_;
	struct stat _tmp18_;
	gsize _tmp19_;
	struct stat _tmp20_ = {0};
	gint _tmp21_;
	struct stat _tmp22_;
	gsize _tmp23_;
	if (!check_gphoto_version ()) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat (umockdev_run_command "-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -T", NULL);
	_tmp9_ = _tmp8_;
	get_program_out ("gphoto2", _tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp13_ = exit;
	g_assert_cmpint (_tmp13_, ==, 0);
	_tmp14_ = sout;
	assert_in ("thumb_IMG_0001.jpg", _tmp14_);
	_tmp15_ = sout;
	assert_in ("thumb_IMG_0002.jpg", _tmp15_);
	_tmp17_ = stat ("thumb_IMG_0001.jpg", &_tmp16_);
	st = _tmp16_;
	_vala_assert (_tmp17_ == 0, "Posix.stat(\"thumb_IMG_0001.jpg\", out st) == 0");
	_tmp18_ = st;
	_tmp19_ = _tmp18_.st_size;
	g_assert_cmpuint ((guint) _tmp19_, >, (guint) 500);
	_tmp21_ = stat ("thumb_IMG_0002.jpg", &_tmp20_);
	st = _tmp20_;
	_vala_assert (_tmp21_ == 0, "Posix.stat(\"thumb_IMG_0002.jpg\", out st) == 0");
	_tmp22_ = st;
	_tmp23_ = _tmp22_.st_size;
	g_assert_cmpuint ((guint) _tmp23_, >, (guint) 500);
	g_remove ("thumb_IMG_0001.jpg");
	g_remove ("thumb_IMG_0002.jpg");
	_g_free0 (serr);
	_g_free0 (sout);
}


void
t_gphoto_download (void)
{
	gchar* sout = NULL;
	gchar* serr = NULL;
	gint exit = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	struct stat st = {0};
	struct stat _tmp16_ = {0};
	gint _tmp17_;
	struct stat _tmp18_;
	gsize _tmp19_;
	struct stat _tmp20_ = {0};
	gint _tmp21_;
	struct stat _tmp22_;
	gsize _tmp23_;
	if (!check_gphoto_version ()) {
		_g_free0 (serr);
		_g_free0 (sout);
		return;
	}
	_tmp0_ = rootdir;
	_tmp1_ = g_strconcat (umockdev_run_command "-d ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/devices/cameras/canon-powershot-sx200.umockdev -i /dev/bus/usb/001/01" \
"1=", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = rootdir;
	_tmp6_ = g_strconcat (_tmp4_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, "/devices/cameras/canon-powershot-sx200.ioctl -- gphoto2 -P", NULL);
	_tmp9_ = _tmp8_;
	get_program_out ("gphoto2", _tmp9_, &_tmp10_, &_tmp11_, &_tmp12_);
	_g_free0 (sout);
	sout = _tmp10_;
	_g_free0 (serr);
	serr = _tmp11_;
	exit = _tmp12_;
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp13_ = exit;
	g_assert_cmpint (_tmp13_, ==, 0);
	_tmp14_ = sout;
	assert_in ("IMG_0001.JPG", _tmp14_);
	_tmp15_ = sout;
	assert_in ("IMG_0002.JPG", _tmp15_);
	_tmp17_ = stat ("IMG_0001.JPG", &_tmp16_);
	st = _tmp16_;
	_vala_assert (_tmp17_ == 0, "Posix.stat(\"IMG_0001.JPG\", out st) == 0");
	_tmp18_ = st;
	_tmp19_ = _tmp18_.st_size;
	g_assert_cmpuint ((guint) _tmp19_, >, (guint) 5000);
	_tmp21_ = stat ("IMG_0002.JPG", &_tmp20_);
	st = _tmp20_;
	_vala_assert (_tmp21_ == 0, "Posix.stat(\"IMG_0002.JPG\", out st) == 0");
	_tmp22_ = st;
	_tmp23_ = _tmp22_.st_size;
	g_assert_cmpuint ((guint) _tmp23_, >, (guint) 5000);
	g_remove ("IMG_0001.JPG");
	g_remove ("IMG_0002.JPG");
	_g_free0 (serr);
	_g_free0 (sout);
}


void
t_input_touchpad (void)
{
	GPid xorg_pid = 0;
	gchar* logfile = NULL;
	gint timeout = 0;
	gint _tmp33_;
	gchar* xinput_out = NULL;
	gchar* xinput_err = NULL;
	gint xinput_exit = 0;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gchar* props_out = NULL;
	gchar* props_err = NULL;
	gint props_exit = 0;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	GPid _tmp42_;
	gint status = 0;
	GPid _tmp43_;
	gint _tmp44_ = 0;
	GPid _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	const gchar* _tmp50_;
	gint _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	gint _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	GError * _inner_error_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	if (!have_program ("Xorg")) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "[SKIP: Xorg not installed] ");
		return;
	}
	if (((gint64) G_MAXLONG) != G_MAXINT64) {
		FILE* _tmp2_;
		_tmp2_ = stdout;
		fprintf (_tmp2_, "[SKIP: test only works on 64 bit architectures] ");
		return;
	}
	{
		gint fd = 0;
		gchar* _tmp3_ = NULL;
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = g_file_open_tmp ("Xorg.log.XXXXXX", &_tmp3_, &_inner_error_);
		_g_free0 (logfile);
		logfile = _tmp3_;
		fd = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch5_g_file_error;
			}
			_g_free0 (logfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp5_ = fd;
		close (_tmp5_);
	}
	goto __finally5;
	__catch5_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e->message;
		fprintf (_tmp6_, "cannot create temporary file: %s\n", _tmp7_);
		abort ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (logfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		GPid _tmp28_ = 0;
		_tmp8_ = g_strdup ("umockdev-run");
		_tmp9_ = g_strdup ("-d");
		_tmp10_ = rootdir;
		_tmp11_ = g_strconcat (_tmp10_, "/devices/input/synaptics-touchpad.umockdev", NULL);
		_tmp12_ = g_strdup ("-i");
		_tmp13_ = rootdir;
		_tmp14_ = g_strconcat ("/dev/input/event12=", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, "/devices/input/synaptics-touchpad.ioctl", NULL);
		_tmp17_ = g_strdup ("--");
		_tmp18_ = g_strdup ("Xorg");
		_tmp19_ = g_strdup ("-config");
		_tmp20_ = rootdir;
		_tmp21_ = g_strconcat (_tmp20_, "/tests/xorg-dummy.conf", NULL);
		_tmp22_ = g_strdup ("-logfile");
		_tmp23_ = logfile;
		_tmp24_ = g_strdup (_tmp23_);
		_tmp25_ = g_strdup (":5");
		_tmp26_ = g_new0 (gchar*, 12 + 1);
		_tmp26_[0] = _tmp8_;
		_tmp26_[1] = _tmp9_;
		_tmp26_[2] = _tmp11_;
		_tmp26_[3] = _tmp12_;
		_tmp26_[4] = _tmp16_;
		_tmp26_[5] = _tmp17_;
		_tmp26_[6] = _tmp18_;
		_tmp26_[7] = _tmp19_;
		_tmp26_[8] = _tmp21_;
		_tmp26_[9] = _tmp22_;
		_tmp26_[10] = _tmp24_;
		_tmp26_[11] = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp27__length1 = 12;
		g_spawn_async (NULL, _tmp27_, NULL, G_SPAWN_SEARCH_PATH | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &_tmp28_, &_inner_error_);
		xorg_pid = _tmp28_;
		_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp15_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			_g_free0 (logfile);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = stderr;
		_tmp30_ = e->message;
		fprintf (_tmp29_, "cannot call Xorg: %s\n", _tmp30_);
		abort ();
		_g_error_free0 (e);
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (logfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	timeout = 50;
	while (TRUE) {
		gint _tmp31_;
		gint _tmp32_;
		_tmp31_ = timeout;
		if (!(_tmp31_ > 0)) {
			break;
		}
		_tmp32_ = timeout;
		timeout = _tmp32_ - 1;
		usleep ((guint) 100000);
		if (g_file_test ("/tmp/.X11-unix/X5", G_FILE_TEST_EXISTS)) {
			break;
		}
	}
	_tmp33_ = timeout;
	if (_tmp33_ <= 0) {
		FILE* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = stderr;
		_tmp35_ = logfile;
		fprintf (_tmp34_, "SKIP: Xorg failed to start up; please ensure you have the X.org dummy " \
"driver installed, and check the log file: %s\n", _tmp35_);
		_g_free0 (logfile);
		return;
	}
	get_program_out ("xinput", "env DISPLAY=:5 xinput", &_tmp36_, &_tmp37_, &_tmp38_);
	_g_free0 (xinput_out);
	xinput_out = _tmp36_;
	_g_free0 (xinput_err);
	xinput_err = _tmp37_;
	xinput_exit = _tmp38_;
	get_program_out ("xinput", "env DISPLAY=:5 xinput --list-props 'SynPS/2 Synaptics TouchPad'", &_tmp39_, &_tmp40_, &_tmp41_);
	_g_free0 (props_out);
	props_out = _tmp39_;
	_g_free0 (props_err);
	props_err = _tmp40_;
	props_exit = _tmp41_;
	_tmp42_ = xorg_pid;
	kill ((pid_t) _tmp42_, (gint) SIGTERM);
	_tmp43_ = xorg_pid;
	waitpid ((pid_t) _tmp43_, &_tmp44_, 0);
	status = _tmp44_;
	_tmp45_ = xorg_pid;
	g_spawn_close_pid (_tmp45_);
	_tmp46_ = logfile;
	g_remove (_tmp46_);
	_tmp47_ = logfile;
	_tmp48_ = g_strconcat (_tmp47_, ".old", NULL);
	_tmp49_ = _tmp48_;
	g_remove (_tmp49_);
	_g_free0 (_tmp49_);
	_tmp50_ = xinput_err;
	g_assert_cmpstr (_tmp50_, ==, "");
	_tmp51_ = xinput_exit;
	g_assert_cmpint (_tmp51_, ==, 0);
	_tmp52_ = xinput_out;
	assert_in ("SynPS/2 Synaptics TouchPad", _tmp52_);
	_tmp53_ = props_err;
	g_assert_cmpstr (_tmp53_, ==, "");
	_tmp54_ = props_exit;
	g_assert_cmpint (_tmp54_, ==, 0);
	_tmp55_ = props_out;
	assert_in ("Synaptics Two-Finger Scrolling", _tmp55_);
	_tmp56_ = props_out;
	assert_in ("/dev/input/event12", _tmp56_);
	_g_free0 (props_err);
	_g_free0 (props_out);
	_g_free0 (xinput_err);
	_g_free0 (xinput_out);
	_g_free0 (logfile);
}


void
t_input_evtest (void)
{
	GPid evtest_pid = 0;
	gint outfd = 0;
	gint errfd = 0;
	gchar* script_arch = NULL;
	GPid _tmp30_;
	guint8* sout = NULL;
	guint8* _tmp31_;
	gint sout_length1;
	gint _sout_size_;
	guint8* serr = NULL;
	guint8* _tmp32_;
	gint serr_length1;
	gint _serr_size_;
	gssize sout_len = 0L;
	gint _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	guint8* _tmp35_;
	gint _tmp35__length1;
	gssize serr_len = 0L;
	gint _tmp36_;
	guint8* _tmp37_;
	gint _tmp37__length1;
	guint8* _tmp38_;
	gint _tmp38__length1;
	gint status = 0;
	GPid _tmp39_;
	gint _tmp40_ = 0;
	GPid _tmp41_;
	gssize _tmp42_;
	gssize _tmp48_;
	guint8* _tmp49_;
	gint _tmp49__length1;
	gssize _tmp50_;
	guint8 _tmp51_;
	gchar* output = NULL;
	guint8* _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	GError * _inner_error_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	if (!have_program ("evtest")) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "[SKIP: evtest not installed] ");
		return;
	}
	if (((gint64) G_MAXLONG) == G_MAXINT64) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("64");
		_g_free0 (script_arch);
		script_arch = _tmp2_;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("32");
		_g_free0 (script_arch);
		script_arch = _tmp3_;
	}
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		GPid _tmp25_ = 0;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		_tmp4_ = g_strdup ("umockdev-run");
		_tmp5_ = g_strdup ("-d");
		_tmp6_ = rootdir;
		_tmp7_ = g_strconcat (_tmp6_, "/devices/input/usbkbd.umockdev", NULL);
		_tmp8_ = g_strdup ("-i");
		_tmp9_ = rootdir;
		_tmp10_ = g_strconcat ("/dev/input/event5=", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp11_, "/devices/input/usbkbd.evtest.ioctl", NULL);
		_tmp13_ = g_strdup ("-s");
		_tmp14_ = rootdir;
		_tmp15_ = g_strconcat ("/dev/input/event5=", _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, "/devices/input/usbkbd.evtest.script.", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = script_arch;
		_tmp20_ = g_strconcat (_tmp18_, _tmp19_, NULL);
		_tmp21_ = g_strdup ("evtest");
		_tmp22_ = g_strdup ("/dev/input/event5");
		_tmp23_ = g_new0 (gchar*, 9 + 1);
		_tmp23_[0] = _tmp4_;
		_tmp23_[1] = _tmp5_;
		_tmp23_[2] = _tmp7_;
		_tmp23_[3] = _tmp8_;
		_tmp23_[4] = _tmp12_;
		_tmp23_[5] = _tmp13_;
		_tmp23_[6] = _tmp20_;
		_tmp23_[7] = _tmp21_;
		_tmp23_[8] = _tmp22_;
		_tmp24_ = _tmp23_;
		_tmp24__length1 = 9;
		g_spawn_async_with_pipes (NULL, _tmp24_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp25_, NULL, &_tmp26_, &_tmp27_, &_inner_error_);
		evtest_pid = _tmp25_;
		outfd = _tmp26_;
		errfd = _tmp27_;
		_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp11_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch7_g_spawn_error;
			}
			_g_free0 (script_arch);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally7;
	__catch7_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp28_;
		const gchar* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = stderr;
		_tmp29_ = e->message;
		fprintf (_tmp28_, "cannot call evtest: %s\n", _tmp29_);
		abort ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (script_arch);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sleep ((guint) 2);
	_tmp30_ = evtest_pid;
	kill ((pid_t) _tmp30_, (gint) SIGTERM);
	_tmp31_ = g_new0 (guint8, 10000);
	sout = _tmp31_;
	sout_length1 = 10000;
	_sout_size_ = sout_length1;
	_tmp32_ = g_new0 (guint8, 10000);
	serr = _tmp32_;
	serr_length1 = 10000;
	_serr_size_ = serr_length1;
	_tmp33_ = outfd;
	_tmp34_ = sout;
	_tmp34__length1 = sout_length1;
	_tmp35_ = sout;
	_tmp35__length1 = sout_length1;
	sout_len = read (_tmp33_, _tmp34_, (gsize) _tmp35__length1);
	_tmp36_ = errfd;
	_tmp37_ = serr;
	_tmp37__length1 = serr_length1;
	_tmp38_ = sout;
	_tmp38__length1 = sout_length1;
	serr_len = read (_tmp36_, _tmp37_, (gsize) _tmp38__length1);
	_tmp39_ = evtest_pid;
	waitpid ((pid_t) _tmp39_, &_tmp40_, 0);
	status = _tmp40_;
	_tmp41_ = evtest_pid;
	g_spawn_close_pid (_tmp41_);
	_tmp42_ = serr_len;
	if (_tmp42_ > ((gssize) 0)) {
		guint8* _tmp43_;
		gint _tmp43__length1;
		gssize _tmp44_;
		guint8 _tmp45_;
		FILE* _tmp46_;
		guint8* _tmp47_;
		gint _tmp47__length1;
		_tmp43_ = serr;
		_tmp43__length1 = serr_length1;
		_tmp44_ = serr_len;
		_tmp43_[_tmp44_] = (guint8) 0;
		_tmp45_ = _tmp43_[_tmp44_];
		_tmp46_ = stderr;
		_tmp47_ = serr;
		_tmp47__length1 = serr_length1;
		fprintf (_tmp46_, "evtest error: %s\n", (const gchar*) _tmp47_);
		abort ();
	}
	_tmp48_ = sout_len;
	g_assert_cmpint ((gint) _tmp48_, >, 10);
	_tmp49_ = sout;
	_tmp49__length1 = sout_length1;
	_tmp50_ = sout_len;
	_tmp49_[_tmp50_] = (guint8) 0;
	_tmp51_ = _tmp49_[_tmp50_];
	_tmp52_ = sout;
	_tmp52__length1 = sout_length1;
	_tmp53_ = g_strdup ((const gchar*) _tmp52_);
	output = _tmp53_;
	_tmp54_ = output;
	assert_in ("Event type 1 (EV_KEY)", _tmp54_);
	_tmp55_ = output;
	assert_in ("Event code 15 (KEY_TAB)", _tmp55_);
	_tmp56_ = output;
	assert_in ("type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004", _tmp56_);
	_tmp57_ = output;
	assert_in ("type 1 (EV_KEY), code 30 (KEY_A), value 1\n", _tmp57_);
	_tmp58_ = output;
	assert_in ("type 1 (EV_KEY), code 30 (KEY_A), value 0\n", _tmp58_);
	_tmp59_ = output;
	assert_in ("type 4 (EV_MSC), code 4 (MSC_SCAN), value 700e1", _tmp59_);
	_tmp60_ = output;
	assert_in ("type 1 (EV_KEY), code 42 (KEY_LEFTSHIFT), value 1\n", _tmp60_);
	_tmp61_ = output;
	assert_in ("type 1 (EV_KEY), code 42 (KEY_LEFTSHIFT), value 0\n", _tmp61_);
	_g_free0 (output);
	serr = (g_free (serr), NULL);
	sout = (g_free (sout), NULL);
	_g_free0 (script_arch);
}


void
t_input_evtest_evemu (void)
{
	GPid evtest_pid = 0;
	gint outfd = 0;
	gint errfd = 0;
	gchar* evemu_file = NULL;
	const gchar* _tmp29_;
	GPid _tmp30_;
	guint8* sout = NULL;
	guint8* _tmp31_;
	gint sout_length1;
	gint _sout_size_;
	guint8* serr = NULL;
	guint8* _tmp32_;
	gint serr_length1;
	gint _serr_size_;
	gssize sout_len = 0L;
	gint _tmp33_;
	guint8* _tmp34_;
	gint _tmp34__length1;
	guint8* _tmp35_;
	gint _tmp35__length1;
	gssize serr_len = 0L;
	gint _tmp36_;
	guint8* _tmp37_;
	gint _tmp37__length1;
	guint8* _tmp38_;
	gint _tmp38__length1;
	gint status = 0;
	GPid _tmp39_;
	gint _tmp40_ = 0;
	GPid _tmp41_;
	gssize _tmp42_;
	gssize _tmp48_;
	guint8* _tmp49_;
	gint _tmp49__length1;
	gssize _tmp50_;
	guint8 _tmp51_;
	gchar* output = NULL;
	guint8* _tmp52_;
	gint _tmp52__length1;
	gchar* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	GError * _inner_error_ = NULL;
	if (G_BYTE_ORDER == G_BIG_ENDIAN) {
		FILE* _tmp0_;
		_tmp0_ = stdout;
		fprintf (_tmp0_, "[SKIP: this test only works on little endian machines] ");
		return;
	}
	if (!have_program ("evtest")) {
		FILE* _tmp1_;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "[SKIP: evtest not installed] ");
		return;
	}
	{
		gint fd = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = g_file_open_tmp ("evemu.XXXXXX.events", &_tmp2_, &_inner_error_);
		_g_free0 (evemu_file);
		evemu_file = _tmp2_;
		fd = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp4_ = fd;
		close (_tmp4_);
		_tmp5_ = evemu_file;
		g_file_set_contents (_tmp5_, "E: 0.000000 0000 0000 0000\t# ------------ SYN_REPORT (0) ----------\n" \
"E: 0.200000 0004 0004 458756\t# EV_MSC / MSC_SCAN             458756\n" \
"E: 0.200000 0001 001e 0001\t# EV_KEY / KEY_A                1\n" \
"E: 0.200000 0000 0000 0000\t# ------------ SYN_REPORT (0) ----------\n" \
"E: 0.500000 0004 0004 458756\t# EV_MSC / MSC_SCAN             458756\n" \
"E: 0.500000 0001 001e 0000\t# EV_KEY / KEY_A                0\n", (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch8_g_file_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally8;
	__catch8_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = stderr;
		_tmp7_ = e->message;
		fprintf (_tmp6_, "cannot create temporary file: %s\n", _tmp7_);
		abort ();
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (evemu_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar** _tmp22_;
		gchar** _tmp23_;
		gint _tmp23__length1;
		GPid _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
		_tmp8_ = g_strdup ("umockdev-run");
		_tmp9_ = g_strdup ("-d");
		_tmp10_ = rootdir;
		_tmp11_ = g_strconcat (_tmp10_, "/devices/input/usbkbd.umockdev", NULL);
		_tmp12_ = g_strdup ("-i");
		_tmp13_ = rootdir;
		_tmp14_ = g_strconcat ("/dev/input/event5=", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_tmp15_, "/devices/input/usbkbd.evtest.ioctl", NULL);
		_tmp17_ = g_strdup ("-e");
		_tmp18_ = evemu_file;
		_tmp19_ = g_strconcat ("/dev/input/event5=", _tmp18_, NULL);
		_tmp20_ = g_strdup ("evtest");
		_tmp21_ = g_strdup ("/dev/input/event5");
		_tmp22_ = g_new0 (gchar*, 9 + 1);
		_tmp22_[0] = _tmp8_;
		_tmp22_[1] = _tmp9_;
		_tmp22_[2] = _tmp11_;
		_tmp22_[3] = _tmp12_;
		_tmp22_[4] = _tmp16_;
		_tmp22_[5] = _tmp17_;
		_tmp22_[6] = _tmp19_;
		_tmp22_[7] = _tmp20_;
		_tmp22_[8] = _tmp21_;
		_tmp23_ = _tmp22_;
		_tmp23__length1 = 9;
		g_spawn_async_with_pipes (NULL, _tmp23_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp24_, NULL, &_tmp25_, &_tmp26_, &_inner_error_);
		evtest_pid = _tmp24_;
		outfd = _tmp25_;
		errfd = _tmp26_;
		_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp15_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch9_g_spawn_error;
			}
			_g_free0 (evemu_file);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally9;
	__catch9_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = stderr;
		_tmp28_ = e->message;
		fprintf (_tmp27_, "cannot call evtest: %s\n", _tmp28_);
		abort ();
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (evemu_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sleep ((guint) 1);
	_tmp29_ = evemu_file;
	g_remove (_tmp29_);
	_tmp30_ = evtest_pid;
	kill ((pid_t) _tmp30_, (gint) SIGTERM);
	_tmp31_ = g_new0 (guint8, 10000);
	sout = _tmp31_;
	sout_length1 = 10000;
	_sout_size_ = sout_length1;
	_tmp32_ = g_new0 (guint8, 10000);
	serr = _tmp32_;
	serr_length1 = 10000;
	_serr_size_ = serr_length1;
	_tmp33_ = outfd;
	_tmp34_ = sout;
	_tmp34__length1 = sout_length1;
	_tmp35_ = sout;
	_tmp35__length1 = sout_length1;
	sout_len = read (_tmp33_, _tmp34_, (gsize) _tmp35__length1);
	_tmp36_ = errfd;
	_tmp37_ = serr;
	_tmp37__length1 = serr_length1;
	_tmp38_ = sout;
	_tmp38__length1 = sout_length1;
	serr_len = read (_tmp36_, _tmp37_, (gsize) _tmp38__length1);
	_tmp39_ = evtest_pid;
	waitpid ((pid_t) _tmp39_, &_tmp40_, 0);
	status = _tmp40_;
	_tmp41_ = evtest_pid;
	g_spawn_close_pid (_tmp41_);
	_tmp42_ = serr_len;
	if (_tmp42_ > ((gssize) 0)) {
		guint8* _tmp43_;
		gint _tmp43__length1;
		gssize _tmp44_;
		guint8 _tmp45_;
		FILE* _tmp46_;
		guint8* _tmp47_;
		gint _tmp47__length1;
		_tmp43_ = serr;
		_tmp43__length1 = serr_length1;
		_tmp44_ = serr_len;
		_tmp43_[_tmp44_] = (guint8) 0;
		_tmp45_ = _tmp43_[_tmp44_];
		_tmp46_ = stderr;
		_tmp47_ = serr;
		_tmp47__length1 = serr_length1;
		fprintf (_tmp46_, "evtest error: %s\n", (const gchar*) _tmp47_);
		abort ();
	}
	_tmp48_ = sout_len;
	g_assert_cmpint ((gint) _tmp48_, >, 10);
	_tmp49_ = sout;
	_tmp49__length1 = sout_length1;
	_tmp50_ = sout_len;
	_tmp49_[_tmp50_] = (guint8) 0;
	_tmp51_ = _tmp49_[_tmp50_];
	_tmp52_ = sout;
	_tmp52__length1 = sout_length1;
	_tmp53_ = g_strdup ((const gchar*) _tmp52_);
	output = _tmp53_;
	_tmp54_ = output;
	assert_in ("Event: time 0.000000, -------------- ", _tmp54_);
	_tmp55_ = output;
	assert_in ("Event: time 0.200000, type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004\n" \
"Event: time 0.200000, type 1 (EV_KEY), code 30 (KEY_A), value 1\n", _tmp55_);
	_tmp56_ = output;
	assert_in ("Event: time 0.200000, -------------- ", _tmp56_);
	_tmp57_ = output;
	assert_in ("Event: time 0.500000, type 4 (EV_MSC), code 4 (MSC_SCAN), value 70004\n" \
"Event: time 0.500000, type 1 (EV_KEY), code 30 (KEY_A), value 0\n", _tmp57_);
	_g_free0 (output);
	serr = (g_free (serr), NULL);
	sout = (g_free (sout), NULL);
	_g_free0 (evemu_file);
}


static void
_t_run_exit_code_gtest_func (void)
{
	t_run_exit_code ();
}


static void
_t_run_version_gtest_func (void)
{
	t_run_version ();
}


static void
_t_run_pipes_gtest_func (void)
{
	t_run_pipes ();
}


static void
_t_run_invalid_args_gtest_func (void)
{
	t_run_invalid_args ();
}


static void
_t_run_invalid_device_gtest_func (void)
{
	t_run_invalid_device ();
}


static void
_t_run_invalid_ioctl_gtest_func (void)
{
	t_run_invalid_ioctl ();
}


static void
_t_run_invalid_script_gtest_func (void)
{
	t_run_invalid_script ();
}


static void
_t_run_invalid_program_gtest_func (void)
{
	t_run_invalid_program ();
}


static void
_t_run_script_chatter_gtest_func (void)
{
	t_run_script_chatter ();
}


static void
_t_run_script_chatter_socket_stream_gtest_func (void)
{
	t_run_script_chatter_socket_stream ();
}


static void
_t_gphoto_detect_gtest_func (void)
{
	t_gphoto_detect ();
}


static void
_t_input_touchpad_gtest_func (void)
{
	t_input_touchpad ();
}


static void
_t_input_evtest_gtest_func (void)
{
	t_input_evtest ();
}


static void
_t_input_evtest_evemu_gtest_func (void)
{
	t_input_evtest_evemu ();
}


gint
_vala_main (gchar** args,
            int args_length1)
{
	gint result = 0;
	gchar* top_srcdir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_getenv ("TOP_SRCDIR");
	_tmp1_ = g_strdup (_tmp0_);
	top_srcdir = _tmp1_;
	_tmp2_ = top_srcdir;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = top_srcdir;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (rootdir);
		rootdir = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (".");
		_g_free0 (rootdir);
		rootdir = _tmp5_;
	}
	g_test_add_func ("/umockdev-run/exit_code", _t_run_exit_code_gtest_func);
	g_test_add_func ("/umockdev-run/version", _t_run_version_gtest_func);
	g_test_add_func ("/umockdev-run/pipes", _t_run_pipes_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-args", _t_run_invalid_args_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-device", _t_run_invalid_device_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-ioctl", _t_run_invalid_ioctl_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-script", _t_run_invalid_script_gtest_func);
	g_test_add_func ("/umockdev-run/invalid-program", _t_run_invalid_program_gtest_func);
	g_test_add_func ("/umockdev-run/script-chatter", _t_run_script_chatter_gtest_func);
	g_test_add_func ("/umockdev-run/script-chatter-socket-stream", _t_run_script_chatter_socket_stream_gtest_func);
	g_test_add_func ("/umockdev-run/integration/gphoto-detect", _t_gphoto_detect_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-touchpad", _t_input_touchpad_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-evtest", _t_input_evtest_gtest_func);
	g_test_add_func ("/umockdev-run/integration/input-evtest-evemu", _t_input_evtest_evemu_gtest_func);
	result = g_test_run ();
	_g_free0 (top_srcdir);
	return result;
}


int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



