/* this is included from filename.c, do not include directly */
#ifndef XADMASTER_CS_C64_TO_UNICODE_C
#define XADMASTER_CS_C64_TO_UNICODE_C

/*  $Id: cs_c64_to_unicode.c,v 1.5 2005/06/23 14:54:37 stoecker Exp $
    Character set conversion from C64 font to Unicode

    XAD library system for archive handling
    Copyright (C) 1998 and later by Dirk Stcker <soft@dstoecker.de>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef UUNDEF
#define UUNDEF 0xFFFF  /* Unicode undefined character code */
#endif

/*  The code 0xFFFF is illegal in Unicode. This means it may never
 *  be part of a Unicode string.
 */

static const xadUINT16 petsciilc[] = {
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
0xF100, /* WHITE COLOR SWITCH (CUS) */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
0xF118, /* DISABLE CHARACTER SET SWITCHING (CUS) */
0xF119, /* ENABLE CHARACTER SET SWITCHING (CUS) */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
0x000D, /* CARRIAGE RETURN */
0x000E, /* SHIFT OUT */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
0xF11C, /* CURSOR DOWN (CUS) */
0xF11A, /* REVERSE VIDEO ON (CUS) */
0xF120, /* HOME (CUS) */
0x007F, /* DELETE */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
0xF101, /* RED COLOR SWITCH (CUS) */
0xF11D, /* CURSOR RIGHT (CUS) */
0xF102, /* GREEN COLOR SWITCH (CUS) */
0xF103, /* BLUE COLOR SWITCH (CUS) */
0x0020, /* SPACE */
0x0021, /* EXCLAMATION MARK */
0x0022, /* QUOTATION MARK */
0x0023, /* NUMBER SIGN */
0x0024, /* DOLLAR SIGN */
0x0025, /* PERCENT SIGN */
0x0026, /* AMPERSAND */
0x0027, /* APOSTROPHE */
0x0028, /* LEFT PARENTHESIS */
0x0029, /* RIGHT PARENTHESIS */
0x002A, /* ASTERISK */
0x002B, /* PLUS SIGN */
0x002C, /* COMMA */
0x002D, /* HYPHEN-MINUS */
0x002E, /* FULL STOP */
0x002F, /* SOLIDUS */
0x0030, /* DIGIT ZERO */
0x0031, /* DIGIT ONE */
0x0032, /* DIGIT TWO */
0x0033, /* DIGIT THREE */
0x0034, /* DIGIT FOUR */
0x0035, /* DIGIT FIVE */
0x0036, /* DIGIT SIX */
0x0037, /* DIGIT SEVEN */
0x0038, /* DIGIT EIGHT */
0x0039, /* DIGIT NINE */
0x003A, /* COLON */
0x003B, /* SEMICOLON */
0x003C, /* LESS-THAN SIGN */
0x003D, /* EQUALS SIGN */
0x003E, /* GREATER-THAN SIGN */
0x003F, /* QUESTION MARK */
0x0040, /* COMMERCIAL AT */
0x0061, /* LATIN SMALL LETTER A */
0x0062, /* LATIN SMALL LETTER B */
0x0063, /* LATIN SMALL LETTER C */
0x0064, /* LATIN SMALL LETTER D */
0x0065, /* LATIN SMALL LETTER E */
0x0066, /* LATIN SMALL LETTER F */
0x0067, /* LATIN SMALL LETTER G */
0x0068, /* LATIN SMALL LETTER H */
0x0069, /* LATIN SMALL LETTER I */
0x006A, /* LATIN SMALL LETTER J */
0x006B, /* LATIN SMALL LETTER K */
0x006C, /* LATIN SMALL LETTER L */
0x006D, /* LATIN SMALL LETTER M */
0x006E, /* LATIN SMALL LETTER N */
0x006F, /* LATIN SMALL LETTER O */
0x0070, /* LATIN SMALL LETTER P */
0x0071, /* LATIN SMALL LETTER Q */
0x0072, /* LATIN SMALL LETTER R */
0x0073, /* LATIN SMALL LETTER S */
0x0074, /* LATIN SMALL LETTER T */
0x0075, /* LATIN SMALL LETTER U */
0x0076, /* LATIN SMALL LETTER V */
0x0077, /* LATIN SMALL LETTER W */
0x0078, /* LATIN SMALL LETTER X */
0x0079, /* LATIN SMALL LETTER Y */
0x007A, /* LATIN SMALL LETTER Z */
0x005B, /* LEFT SQUARE BRACKET */
0x00A3, /* POUND SIGN */
0x005D, /* RIGHT SQUARE BRACKET */
0x2191, /* UPWARDS ARROW */
0x2190, /* LEFTWARDS ARROW */
0x2501, /* BOX DRAWINGS LIGHT HORIZONTAL */
0x0041, /* LATIN CAPITAL LETTER A */
0x0042, /* LATIN CAPITAL LETTER B */
0x0043, /* LATIN CAPITAL LETTER C */
0x0044, /* LATIN CAPITAL LETTER D */
0x0045, /* LATIN CAPITAL LETTER E */
0x0046, /* LATIN CAPITAL LETTER F */
0x0047, /* LATIN CAPITAL LETTER G */
0x0048, /* LATIN CAPITAL LETTER H */
0x0049, /* LATIN CAPITAL LETTER I */
0x004A, /* LATIN CAPITAL LETTER J */
0x004B, /* LATIN CAPITAL LETTER K */
0x004C, /* LATIN CAPITAL LETTER L */
0x004D, /* LATIN CAPITAL LETTER M */
0x004E, /* LATIN CAPITAL LETTER N */
0x004F, /* LATIN CAPITAL LETTER O */
0x0050, /* LATIN CAPITAL LETTER P */
0x0051, /* LATIN CAPITAL LETTER Q */
0x0052, /* LATIN CAPITAL LETTER R */
0x0053, /* LATIN CAPITAL LETTER S */
0x0054, /* LATIN CAPITAL LETTER T */
0x0055, /* LATIN CAPITAL LETTER U */
0x0056, /* LATIN CAPITAL LETTER V */
0x0057, /* LATIN CAPITAL LETTER W */
0x0058, /* LATIN CAPITAL LETTER X */
0x0059, /* LATIN CAPITAL LETTER Y */
0x005A, /* LATIN CAPITAL LETTER Z */
0x253C, /* BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL */
0xF12E, /* LEFT HALF BLOCK MEDIUM SHADE (CUS) */
0x2502, /* BOX DRAWINGS LIGHT VERTICAL */
0x2592, /* MEDIUM SHADE */
0xF139, /* MEDIUM SHADE SLASHED LEFT (CUS) */
UUNDEF, /* UNDEFINED */
0xF104, /* ORANGE COLOR SWITCH (CUS) */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
UUNDEF, /* UNDEFINED */
0xF110, /* FUNCTION KEY 1 (CUS) */
0xF112, /* FUNCTION KEY 3 (CUS) */
0xF114, /* FUNCTION KEY 5 (CUS) */
0xF116, /* FUNCTION KEY 7 (CUS) */
0xF111, /* FUNCTION KEY 2 (CUS) */
0xF113, /* FUNCTION KEY 4 (CUS) */
0xF115, /* FUNCTION KEY 6 (CUS) */
0xF117, /* FUNCTION KEY 8 (CUS) */
0x000A, /* LINE FEED */
0x000F, /* SHIFT IN */
UUNDEF, /* UNDEFINED */
0xF105, /* BLACK COLOR SWITCH (CUS) */
0xF11E, /* CURSOR UP (CUS) */
0xF11B, /* REVERSE VIDEO OFF (CUS) */
0x000C, /* FORM FEED */
0xF121, /* INSERT (CUS) */
0xF106, /* BROWN COLOR SWITCH (CUS) */
0xF107, /* LIGHT RED COLOR SWITCH (CUS) */
0xF108, /* GRAY 1 COLOR SWITCH (CUS) */
0xF109, /* GRAY 2 COLOR SWITCH (CUS) */
0xF10A, /* LIGHT GREEN COLOR SWITCH (CUS) */
0xF10B, /* LIGHT BLUE COLOR SWITCH (CUS) */
0xF10C, /* GRAY 3 COLOR SWITCH (CUS) */
0xF10D, /* PURPLE COLOR SWITCH (CUS) */
0xF11D, /* CURSOR LEFT (CUS) */
0xF10E, /* YELLOW COLOR SWITCH (CUS) */
0xF10F, /* CYAN COLOR SWITCH (CUS) */
0x00A0, /* NO-BREAK SPACE */
0x258C, /* LEFT HALF BLOCK */
0x2584, /* LOWER HALF BLOCK */
0x2594, /* UPPER ONE EIGHTH BLOCK */
0x2581, /* LOWER ONE EIGHTH BLOCK */
0x258F, /* LEFT ONE EIGHTH BLOCK */
0x2592, /* MEDIUM SHADE */
0x2595, /* RIGHT ONE EIGHTH BLOCK */
0xF12F, /* LOWER HALF BLOCK MEDIUM SHADE (CUS) */
0xF13A, /* MEDIUM SHADE SLASHED RIGHT (CUS) */
0xF130, /* RIGHT ONE QUARTER BLOCK (CUS) */
0x251C, /* BOX DRAWINGS LIGHT VERTICAL AND RIGHT */
0xF134, /* BLACK SMALL SQUARE LOWER RIGHT (CUS) */
0x2514, /* BOX DRAWINGS LIGHT UP AND RIGHT */
0x2510, /* BOX DRAWINGS LIGHT DOWN AND LEFT */
0x2582, /* LOWER ONE QUARTER BLOCK */
0x250C, /* BOX DRAWINGS LIGHT DOWN AND RIGHT */
0x2534, /* BOX DRAWINGS LIGHT UP AND HORIZONTAL */
0x252C, /* BOX DRAWINGS LIGHT DOWN AND HORIZONTAL */
0x2524, /* BOX DRAWINGS LIGHT VERTICAL AND LEFT */
0x258E, /* LEFT ONE QUARTER BLOCK */
0x258D, /* LEFT THREE EIGTHS BLOCK */
0xF131, /* RIGHT THREE EIGHTHS BLOCK (CUS) */
0xF132, /* UPPER ONE QUARTER BLOCK (CUS) */
0xF133, /* UPPER THREE EIGHTS BLOCK (CUS) */
0x2583, /* LOWER THREE EIGHTHS BLOCK */
0x2713, /* CHECK MARK */
0xF135, /* BLACK SMALL SQUARE LOWER LEFT (CUS) */
0xF136, /* BLACK SMALL SQUARE UPPER RIGHT (CUS) */
0x2518, /* BOX DRAWINGS LIGHT UP AND LEFT */
0xF137, /* BLACK SMALL SQUARE UPPER LEFT (CUS) */
0xF138, /* TWO SMALL BLACK SQUARES DIAGONAL LEFT TO RIGHT (CUS) */
};

static xadUINT16 petsciilc_to_unicode(xadUINT16 i) /* Lower Case charset */
{
    if      (i >= 192 && i <= 223) i = petsciilc[i-96];
    else if (i >= 224 && i <= 254) i = petsciilc[i-64];
    else if (i == 255)             i = petsciilc[126];
    else                           i = petsciilc[i];

    return i;
}

#endif /* XADMASTER_CS_C64_TO_UNICODE_C */
