/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	ValaMemberAccess* _member_name;
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
};


static gint ValaObjectCreationExpression_private_offset;
static gpointer vala_object_creation_expression_parent_class = NULL;

static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);


static inline gpointer
vala_object_creation_expression_get_instance_private (ValaObjectCreationExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaObjectCreationExpression_private_offset);
}


/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = self->priv->_member_name;
	if (_tmp4_ != NULL) {
		ValaMemberAccess* _tmp5_;
		_tmp5_ = self->priv->_member_name;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _arg_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _arg_index = 0;
		_tmp6_ = self->priv->argument_list;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_arg_list = _tmp7_;
		_tmp8_ = _arg_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_arg_size = _tmp10_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaExpression* arg = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			ValaExpression* _tmp17_;
			_tmp11_ = _arg_index;
			_arg_index = _tmp11_ + 1;
			_tmp12_ = _arg_index;
			_tmp13_ = _arg_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _arg_list;
			_tmp15_ = _arg_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			arg = (ValaExpression*) _tmp16_;
			_tmp17_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _init_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _init_index = 0;
		_tmp18_ = self->priv->object_initializer;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_init_list = _tmp19_;
		_tmp20_ = _init_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_init_size = _tmp22_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaMemberInitializer* _tmp29_;
			_tmp23_ = _init_index;
			_init_index = _tmp23_ + 1;
			_tmp24_ = _init_index;
			_tmp25_ = _init_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _init_list;
			_tmp27_ = _init_index;
			_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
			init = (ValaMemberInitializer*) _tmp28_;
			_tmp29_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	_tmp2_ = index;
	if (_tmp2_ >= 0) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		_tmp3_ = vala_code_node_get_parent_node ((ValaCodeNode*) new_node);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaList* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = index;
		vala_list_set (_tmp5_, _tmp6_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp2_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _arg_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _arg_index = 0;
		_tmp3_ = self->priv->argument_list;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_arg_list = _tmp4_;
		_tmp5_ = _arg_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_arg_size = _tmp7_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaExpression* arg = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			_tmp8_ = _arg_index;
			_arg_index = _tmp8_ + 1;
			_tmp9_ = _arg_index;
			_tmp10_ = _arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _arg_list;
			_tmp12_ = _arg_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			arg = (ValaExpression*) _tmp13_;
			_tmp14_ = arg;
			if (!vala_expression_is_accessible (_tmp14_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _init_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _init_index = 0;
		_tmp15_ = self->priv->object_initializer;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_init_list = _tmp16_;
		_tmp17_ = _init_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_init_size = _tmp19_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_;
			ValaMemberInitializer* _tmp26_;
			ValaExpression* _tmp27_;
			ValaExpression* _tmp28_;
			_tmp20_ = _init_index;
			_init_index = _tmp20_ + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = _init_index;
			_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
			init = (ValaMemberInitializer*) _tmp25_;
			_tmp26_ = init;
			_tmp27_ = vala_member_initializer_get_initializer (_tmp26_);
			_tmp28_ = _tmp27_;
			if (!vala_expression_is_accessible (_tmp28_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}


static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	ValaDataType* _tmp104_;
	ValaDataType* _tmp105_;
	ValaDataType* _tmp106_;
	ValaDataType* _tmp107_;
	gboolean may_throw = FALSE;
	gint given_num_type_args = 0;
	ValaDataType* _tmp108_;
	ValaDataType* _tmp109_;
	ValaList* _tmp110_;
	ValaList* _tmp111_;
	gint _tmp112_;
	gint _tmp113_;
	gint _tmp114_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp115_;
	gint _tmp240_;
	gint _tmp241_;
	gboolean _tmp248_ = FALSE;
	ValaSymbol* _tmp249_;
	ValaSymbol* _tmp250_;
	ValaSymbol* _tmp262_;
	ValaSymbol* _tmp263_;
	gboolean _tmp507_;
	gboolean _tmp560_;
	gboolean _tmp561_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_member_name;
	if (_tmp4_ != NULL) {
		ValaMemberAccess* _tmp5_;
		_tmp5_ = self->priv->_member_name;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp6_ = vala_object_creation_expression_get_type_reference (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		ValaMemberAccess* _tmp8_;
		ValaMemberAccess* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp22_;
		ValaList* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaSymbol* _tmp47_;
		_tmp8_ = self->priv->_member_name;
		if (_tmp8_ == NULL) {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp11_ = self->priv->_member_name;
		_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = self->priv->_member_name;
		_tmp15_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (_tmp16_);
		constructor_sym = _tmp17_;
		_tmp18_ = self->priv->_member_name;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		type_sym = _tmp21_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_member_access_get_type_arguments (_tmp22_);
		type_args = _tmp23_;
		_tmp24_ = constructor_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD)) {
			ValaSymbol* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaSymbol* _tmp27_;
			ValaSymbol* _tmp28_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp29_;
			ValaMethod* _tmp30_;
			ValaSymbol* _tmp31_;
			ValaMethod* _tmp39_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp40_;
			ValaExpression* _tmp41_;
			ValaExpression* _tmp42_;
			ValaMemberAccess* _tmp43_;
			ValaMemberAccess* _tmp44_;
			_tmp25_ = constructor_sym;
			_tmp26_ = vala_symbol_get_parent_symbol (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _vala_code_node_ref0 (_tmp27_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp28_;
			_tmp29_ = constructor_sym;
			_tmp30_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp30_;
			_tmp31_ = constructor_sym;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_CREATION_METHOD)) {
				ValaSourceReference* _tmp32_;
				ValaSourceReference* _tmp33_;
				ValaMethod* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp33_ = _tmp32_;
				_tmp34_ = constructor;
				_tmp35_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = g_strdup_printf ("`%s' is not a creation method", _tmp36_);
				_tmp38_ = _tmp37_;
				vala_report_error (_tmp33_, _tmp38_);
				_g_free0 (_tmp38_);
				_g_free0 (_tmp36_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp39_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp39_);
			_tmp40_ = self->priv->_member_name;
			_tmp41_ = vala_member_access_get_inner (_tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp42_) : NULL);
			ma = _tmp43_;
			_tmp44_ = ma;
			if (_tmp44_ != NULL) {
				ValaMemberAccess* _tmp45_;
				ValaList* _tmp46_;
				_tmp45_ = ma;
				_tmp46_ = vala_member_access_get_type_arguments (_tmp45_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp46_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp47_ = type_sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALA_TYPE_CLASS)) {
			ValaSymbol* _tmp48_;
			ValaTypeSymbol* _tmp49_;
			ValaTypeSymbol* _tmp50_;
			gboolean _tmp51_;
			gboolean _tmp52_;
			_tmp48_ = type_sym;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp49_;
			_tmp50_ = type;
			_tmp51_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_CLASS, ValaClass));
			_tmp52_ = _tmp51_;
			if (_tmp52_) {
				ValaSourceReference* _tmp53_;
				ValaSourceReference* _tmp54_;
				ValaErrorType* _tmp55_;
				ValaErrorType* _tmp56_;
				_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_error_type_new (NULL, NULL, _tmp54_);
				_tmp56_ = _tmp55_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp56_);
				_vala_code_node_unref0 (_tmp56_);
			} else {
				ValaTypeSymbol* _tmp57_;
				ValaObjectType* _tmp58_;
				ValaObjectType* _tmp59_;
				_tmp57_ = type;
				_tmp58_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, VALA_TYPE_CLASS, ValaClass));
				_tmp59_ = _tmp58_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp59_);
				_vala_code_node_unref0 (_tmp59_);
			}
		} else {
			ValaSymbol* _tmp60_;
			_tmp60_ = type_sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_STRUCT)) {
				ValaSymbol* _tmp61_;
				ValaTypeSymbol* _tmp62_;
				ValaTypeSymbol* _tmp63_;
				ValaStructValueType* _tmp64_;
				ValaStructValueType* _tmp65_;
				_tmp61_ = type_sym;
				_tmp62_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp62_;
				_tmp63_ = type;
				_tmp64_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp65_ = _tmp64_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (_tmp65_);
			} else {
				ValaSymbol* _tmp66_;
				_tmp66_ = type_sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp66_, VALA_TYPE_ERROR_CODE)) {
					ValaSymbol* _tmp67_;
					ValaSymbol* _tmp68_;
					ValaSymbol* _tmp69_;
					ValaSymbol* _tmp70_;
					ValaSourceReference* _tmp71_;
					ValaSourceReference* _tmp72_;
					ValaErrorType* _tmp73_;
					ValaErrorType* _tmp74_;
					ValaSymbol* _tmp75_;
					_tmp67_ = type_sym;
					_tmp68_ = vala_symbol_get_parent_symbol (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = type_sym;
					_tmp71_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp72_);
					_tmp74_ = _tmp73_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp74_);
					_vala_code_node_unref0 (_tmp74_);
					_tmp75_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp75_);
				} else {
					ValaSourceReference* _tmp76_;
					ValaSourceReference* _tmp77_;
					ValaSymbol* _tmp78_;
					gchar* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp76_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp77_ = _tmp76_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_symbol_get_full_name (_tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp80_);
					_tmp82_ = _tmp81_;
					vala_report_error (_tmp77_, _tmp82_);
					_g_free0 (_tmp82_);
					_g_free0 (_tmp80_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp83_;
			ValaList* _tmp84_;
			gint _type_arg_size = 0;
			ValaList* _tmp85_;
			gint _tmp86_;
			gint _tmp87_;
			gint _type_arg_index = 0;
			_tmp83_ = type_args;
			_tmp84_ = _vala_iterable_ref0 (_tmp83_);
			_type_arg_list = _tmp84_;
			_tmp85_ = _type_arg_list;
			_tmp86_ = vala_collection_get_size ((ValaCollection*) _tmp85_);
			_tmp87_ = _tmp86_;
			_type_arg_size = _tmp87_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp91_;
				gint _tmp92_;
				gpointer _tmp93_;
				ValaDataType* _tmp94_;
				ValaDataType* _tmp95_;
				ValaDataType* _tmp96_;
				_tmp88_ = _type_arg_index;
				_type_arg_index = _tmp88_ + 1;
				_tmp89_ = _type_arg_index;
				_tmp90_ = _type_arg_size;
				if (!(_tmp89_ < _tmp90_)) {
					break;
				}
				_tmp91_ = _type_arg_list;
				_tmp92_ = _type_arg_index;
				_tmp93_ = vala_list_get (_tmp91_, _tmp92_);
				type_arg = (ValaDataType*) _tmp93_;
				_tmp94_ = vala_object_creation_expression_get_type_reference (self);
				_tmp95_ = _tmp94_;
				_tmp96_ = type_arg;
				vala_data_type_add_type_argument (_tmp95_, _tmp96_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp97_;
		ValaDataType* _tmp98_;
		ValaTypeSymbol* _tmp99_;
		ValaTypeSymbol* _tmp100_;
		ValaTypeSymbol* _tmp101_;
		_tmp97_ = vala_object_creation_expression_get_type_reference (self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_data_type_get_data_type (_tmp98_);
		_tmp100_ = _tmp99_;
		_tmp101_ = _vala_code_node_ref0 (_tmp100_);
		_vala_code_node_unref0 (type);
		type = _tmp101_;
	}
	_tmp102_ = vala_object_creation_expression_get_type_reference (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = vala_data_type_copy (_tmp103_);
	_tmp105_ = _tmp104_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp105_);
	_vala_code_node_unref0 (_tmp105_);
	_tmp106_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp107_ = _tmp106_;
	vala_data_type_set_value_owned (_tmp107_, TRUE);
	may_throw = FALSE;
	_tmp108_ = vala_object_creation_expression_get_type_reference (self);
	_tmp109_ = _tmp108_;
	_tmp110_ = vala_data_type_get_type_arguments (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_collection_get_size ((ValaCollection*) _tmp111_);
	_tmp113_ = _tmp112_;
	_tmp114_ = _tmp113_;
	_vala_iterable_unref0 (_tmp111_);
	given_num_type_args = _tmp114_;
	expected_num_type_args = 0;
	_tmp115_ = type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp115_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp116_;
		ValaClass* _tmp117_;
		ValaClass* _tmp118_;
		ValaList* _tmp119_;
		ValaList* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		gboolean _tmp123_;
		ValaClass* _tmp126_;
		gboolean _tmp127_;
		gboolean _tmp128_;
		ValaSymbol* _tmp136_;
		ValaSymbol* _tmp137_;
		gboolean _tmp158_ = FALSE;
		ValaSymbol* _tmp159_;
		ValaSymbol* _tmp160_;
		_tmp116_ = type;
		_tmp117_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp117_;
		_tmp118_ = cl;
		_tmp119_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp118_);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
		_tmp122_ = _tmp121_;
		expected_num_type_args = _tmp122_;
		_vala_iterable_unref0 (_tmp120_);
		_tmp123_ = self->priv->_struct_creation;
		if (_tmp123_) {
			ValaSourceReference* _tmp124_;
			ValaSourceReference* _tmp125_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp124_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp125_ = _tmp124_;
			vala_report_error (_tmp125_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp126_ = cl;
		_tmp127_ = vala_class_get_is_abstract (_tmp126_);
		_tmp128_ = _tmp127_;
		if (_tmp128_) {
			ValaSourceReference* _tmp129_;
			ValaSourceReference* _tmp130_;
			ValaClass* _tmp131_;
			gchar* _tmp132_;
			gchar* _tmp133_;
			gchar* _tmp134_;
			gchar* _tmp135_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp130_ = _tmp129_;
			_tmp131_ = cl;
			_tmp132_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp131_);
			_tmp133_ = _tmp132_;
			_tmp134_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp133_);
			_tmp135_ = _tmp134_;
			vala_report_error (_tmp130_, _tmp135_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp133_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp136_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp137_ = _tmp136_;
		if (_tmp137_ == NULL) {
			ValaClass* _tmp138_;
			ValaCreationMethod* _tmp139_;
			ValaCreationMethod* _tmp140_;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp151_;
			ValaSymbol* _tmp152_;
			ValaSymbol* _tmp153_;
			ValaVersionAttribute* _tmp154_;
			ValaVersionAttribute* _tmp155_;
			ValaSourceReference* _tmp156_;
			ValaSourceReference* _tmp157_;
			_tmp138_ = cl;
			_tmp139_ = vala_class_get_default_construction_method (_tmp138_);
			_tmp140_ = _tmp139_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp140_);
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp142_ = _tmp141_;
			if (_tmp142_ == NULL) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				ValaClass* _tmp145_;
				gchar* _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				gchar* _tmp149_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = cl;
				_tmp146_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp145_);
				_tmp147_ = _tmp146_;
				_tmp148_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp147_);
				_tmp149_ = _tmp148_;
				vala_report_error (_tmp144_, _tmp149_);
				_g_free0 (_tmp149_);
				_g_free0 (_tmp147_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp150_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp151_ = _tmp150_;
			vala_symbol_set_used (_tmp151_, TRUE);
			_tmp152_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_symbol_get_version (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp157_ = _tmp156_;
			vala_version_attribute_check (_tmp155_, _tmp157_);
		}
		_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp160_ = _tmp159_;
		if (_tmp160_ != NULL) {
			gboolean _tmp161_ = FALSE;
			ValaSymbol* _tmp162_;
			ValaSymbol* _tmp163_;
			ValaSymbolAccessibility _tmp164_;
			ValaSymbolAccessibility _tmp165_;
			_tmp162_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_symbol_get_access (_tmp163_);
			_tmp165_ = _tmp164_;
			if (_tmp165_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp161_ = TRUE;
			} else {
				ValaSymbol* _tmp166_;
				ValaSymbol* _tmp167_;
				ValaSymbolAccessibility _tmp168_;
				ValaSymbolAccessibility _tmp169_;
				_tmp166_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_symbol_get_access (_tmp167_);
				_tmp169_ = _tmp168_;
				_tmp161_ = _tmp169_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp158_ = _tmp161_;
		} else {
			_tmp158_ = FALSE;
		}
		if (_tmp158_) {
			gboolean in_target_type = FALSE;
			gboolean _tmp183_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp170_;
				ValaSemanticAnalyzer* _tmp171_;
				ValaSymbol* _tmp172_;
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				_tmp170_ = vala_code_context_get_analyzer (context);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_semantic_analyzer_get_current_symbol (_tmp171_);
				_tmp173_ = _tmp172_;
				_tmp174_ = _vala_code_node_ref0 (_tmp173_);
				this_symbol = _tmp174_;
				{
					gboolean _tmp175_ = FALSE;
					_tmp175_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp180_;
						ValaSymbol* _tmp181_;
						ValaClass* _tmp182_;
						if (!_tmp175_) {
							ValaSymbol* _tmp176_;
							ValaSymbol* _tmp177_;
							ValaSymbol* _tmp178_;
							ValaSymbol* _tmp179_;
							_tmp176_ = this_symbol;
							_tmp177_ = vala_symbol_get_parent_symbol (_tmp176_);
							_tmp178_ = _tmp177_;
							_tmp179_ = _vala_code_node_ref0 (_tmp178_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp179_;
						}
						_tmp175_ = FALSE;
						_tmp180_ = this_symbol;
						if (!(_tmp180_ != NULL)) {
							break;
						}
						_tmp181_ = this_symbol;
						_tmp182_ = cl;
						if (_tmp181_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp182_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp183_ = in_target_type;
			if (!_tmp183_) {
				ValaSourceReference* _tmp184_;
				ValaSourceReference* _tmp185_;
				ValaSymbol* _tmp186_;
				ValaSymbol* _tmp187_;
				gchar* _tmp188_;
				gchar* _tmp189_;
				gchar* _tmp190_;
				gchar* _tmp191_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp185_ = _tmp184_;
				_tmp186_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_symbol_get_full_name (_tmp187_);
				_tmp189_ = _tmp188_;
				_tmp190_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp189_);
				_tmp191_ = _tmp190_;
				vala_report_error (_tmp185_, _tmp191_);
				_g_free0 (_tmp191_);
				_g_free0 (_tmp189_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp192_;
			ValaClass* _tmp193_;
			gchar* _tmp194_;
			gchar* _tmp195_;
			gboolean _tmp196_;
			ValaClass* _tmp199_;
			ValaClass* _tmp200_;
			ValaClass* _tmp201_;
			ValaClass* _tmp202_;
			_tmp192_ = cl;
			if (!(_tmp192_ != NULL)) {
				break;
			}
			_tmp193_ = cl;
			_tmp194_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp193_, "CCode", "ref_sink_function", NULL);
			_tmp195_ = _tmp194_;
			_tmp196_ = _tmp195_ != NULL;
			_g_free0 (_tmp195_);
			if (_tmp196_) {
				ValaDataType* _tmp197_;
				ValaDataType* _tmp198_;
				_tmp197_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp198_ = _tmp197_;
				vala_data_type_set_floating_reference (_tmp198_, TRUE);
				break;
			}
			_tmp199_ = cl;
			_tmp200_ = vala_class_get_base_class (_tmp199_);
			_tmp201_ = _tmp200_;
			_tmp202_ = _vala_code_node_ref0 (_tmp201_);
			_vala_code_node_unref0 (cl);
			cl = _tmp202_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp203_;
		_tmp203_ = type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp203_, VALA_TYPE_STRUCT)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp204_;
			ValaStruct* _tmp205_;
			ValaStruct* _tmp206_;
			ValaList* _tmp207_;
			ValaList* _tmp208_;
			gint _tmp209_;
			gint _tmp210_;
			gboolean _tmp211_ = FALSE;
			gboolean _tmp212_;
			ValaSymbol* _tmp217_;
			ValaSymbol* _tmp218_;
			gboolean _tmp222_ = FALSE;
			gboolean _tmp223_ = FALSE;
			gboolean _tmp224_ = FALSE;
			ValaProfile _tmp225_;
			ValaProfile _tmp226_;
			_tmp204_ = type;
			_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp205_;
			_tmp206_ = st;
			_tmp207_ = vala_struct_get_type_parameters (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_collection_get_size ((ValaCollection*) _tmp208_);
			_tmp210_ = _tmp209_;
			expected_num_type_args = _tmp210_;
			_vala_iterable_unref0 (_tmp208_);
			_tmp212_ = self->priv->_struct_creation;
			if (!_tmp212_) {
				gboolean _tmp213_;
				gboolean _tmp214_;
				_tmp213_ = vala_code_context_get_deprecated (context);
				_tmp214_ = _tmp213_;
				_tmp211_ = !_tmp214_;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				ValaSourceReference* _tmp215_;
				ValaSourceReference* _tmp216_;
				_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp216_ = _tmp215_;
				vala_report_warning (_tmp216_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp217_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp218_ = _tmp217_;
			if (_tmp218_ == NULL) {
				ValaStruct* _tmp219_;
				ValaMethod* _tmp220_;
				ValaMethod* _tmp221_;
				_tmp219_ = st;
				_tmp220_ = vala_struct_get_default_construction_method (_tmp219_);
				_tmp221_ = _tmp220_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp221_);
			}
			_tmp225_ = vala_code_context_get_profile (context);
			_tmp226_ = _tmp225_;
			if (_tmp226_ == VALA_PROFILE_GOBJECT) {
				ValaStruct* _tmp227_;
				_tmp227_ = st;
				_tmp224_ = vala_struct_is_simple_type (_tmp227_);
			} else {
				_tmp224_ = FALSE;
			}
			if (_tmp224_) {
				ValaSymbol* _tmp228_;
				ValaSymbol* _tmp229_;
				_tmp228_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp229_ = _tmp228_;
				_tmp223_ = _tmp229_ == NULL;
			} else {
				_tmp223_ = FALSE;
			}
			if (_tmp223_) {
				ValaList* _tmp230_;
				gint _tmp231_;
				gint _tmp232_;
				_tmp230_ = self->priv->object_initializer;
				_tmp231_ = vala_collection_get_size ((ValaCollection*) _tmp230_);
				_tmp232_ = _tmp231_;
				_tmp222_ = _tmp232_ == 0;
			} else {
				_tmp222_ = FALSE;
			}
			if (_tmp222_) {
				ValaSourceReference* _tmp233_;
				ValaSourceReference* _tmp234_;
				ValaStruct* _tmp235_;
				gchar* _tmp236_;
				gchar* _tmp237_;
				gchar* _tmp238_;
				gchar* _tmp239_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp233_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp234_ = _tmp233_;
				_tmp235_ = st;
				_tmp236_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp235_);
				_tmp237_ = _tmp236_;
				_tmp238_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp237_);
				_tmp239_ = _tmp238_;
				vala_report_error (_tmp234_, _tmp239_);
				_g_free0 (_tmp239_);
				_g_free0 (_tmp237_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp240_ = expected_num_type_args;
	_tmp241_ = given_num_type_args;
	if (_tmp240_ > _tmp241_) {
		ValaSourceReference* _tmp242_;
		ValaSourceReference* _tmp243_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp243_ = _tmp242_;
		vala_report_error (_tmp243_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gint _tmp244_;
		gint _tmp245_;
		_tmp244_ = expected_num_type_args;
		_tmp245_ = given_num_type_args;
		if (_tmp244_ < _tmp245_) {
			ValaSourceReference* _tmp246_;
			ValaSourceReference* _tmp247_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp247_ = _tmp246_;
			vala_report_error (_tmp247_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp249_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp250_ = _tmp249_;
	if (_tmp250_ == NULL) {
		ValaList* _tmp251_;
		ValaList* _tmp252_;
		gint _tmp253_;
		gint _tmp254_;
		_tmp251_ = vala_object_creation_expression_get_argument_list (self);
		_tmp252_ = _tmp251_;
		_tmp253_ = vala_collection_get_size ((ValaCollection*) _tmp252_);
		_tmp254_ = _tmp253_;
		_tmp248_ = _tmp254_ != 0;
		_vala_iterable_unref0 (_tmp252_);
	} else {
		_tmp248_ = FALSE;
	}
	if (_tmp248_) {
		ValaSourceReference* _tmp255_;
		ValaSourceReference* _tmp256_;
		ValaTypeSymbol* _tmp257_;
		gchar* _tmp258_;
		gchar* _tmp259_;
		gchar* _tmp260_;
		gchar* _tmp261_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp256_ = _tmp255_;
		_tmp257_ = type;
		_tmp258_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp257_);
		_tmp259_ = _tmp258_;
		_tmp260_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp259_);
		_tmp261_ = _tmp260_;
		vala_report_error (_tmp256_, _tmp261_);
		_g_free0 (_tmp261_);
		_g_free0 (_tmp259_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp262_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp263_ = _tmp262_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp263_, VALA_TYPE_METHOD)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp264_;
		ValaSymbol* _tmp265_;
		ValaMethod* _tmp266_;
		gboolean _tmp267_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp286_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp287_;
		ValaIterator* _tmp288_;
		ValaMethod* _tmp321_;
		gboolean _tmp322_;
		gboolean _tmp323_;
		ValaSemanticAnalyzer* _tmp388_;
		ValaSemanticAnalyzer* _tmp389_;
		ValaMethod* _tmp390_;
		ValaMethodType* _tmp391_;
		ValaMethodType* _tmp392_;
		ValaMethod* _tmp393_;
		ValaList* _tmp394_;
		ValaList* _tmp395_;
		ValaList* _tmp396_;
		_tmp264_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp265_ = _tmp264_;
		_tmp266_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp265_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp266_;
		_tmp267_ = self->priv->_is_yield_expression;
		if (_tmp267_) {
			ValaMethod* _tmp268_;
			gboolean _tmp269_;
			gboolean _tmp270_;
			gboolean _tmp273_ = FALSE;
			ValaSemanticAnalyzer* _tmp274_;
			ValaSemanticAnalyzer* _tmp275_;
			ValaMethod* _tmp276_;
			ValaMethod* _tmp277_;
			_tmp268_ = m;
			_tmp269_ = vala_method_get_coroutine (_tmp268_);
			_tmp270_ = _tmp269_;
			if (!_tmp270_) {
				ValaSourceReference* _tmp271_;
				ValaSourceReference* _tmp272_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp271_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp272_ = _tmp271_;
				vala_report_error (_tmp272_, "yield expression requires async method");
			}
			_tmp274_ = vala_code_context_get_analyzer (context);
			_tmp275_ = _tmp274_;
			_tmp276_ = vala_semantic_analyzer_get_current_method (_tmp275_);
			_tmp277_ = _tmp276_;
			if (_tmp277_ == NULL) {
				_tmp273_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp278_;
				ValaSemanticAnalyzer* _tmp279_;
				ValaMethod* _tmp280_;
				ValaMethod* _tmp281_;
				gboolean _tmp282_;
				gboolean _tmp283_;
				_tmp278_ = vala_code_context_get_analyzer (context);
				_tmp279_ = _tmp278_;
				_tmp280_ = vala_semantic_analyzer_get_current_method (_tmp279_);
				_tmp281_ = _tmp280_;
				_tmp282_ = vala_method_get_coroutine (_tmp281_);
				_tmp283_ = _tmp282_;
				_tmp273_ = !_tmp283_;
			}
			if (_tmp273_) {
				ValaSourceReference* _tmp284_;
				ValaSourceReference* _tmp285_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp285_ = _tmp284_;
				vala_report_error (_tmp285_, "yield expression not available outside async method");
			}
		}
		last_arg = NULL;
		_tmp286_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp286_;
		_tmp287_ = args;
		_tmp288_ = vala_iterable_iterator ((ValaIterable*) _tmp287_);
		arg_it = _tmp288_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp289_;
			ValaList* _tmp290_;
			gint _param_size = 0;
			ValaList* _tmp291_;
			gint _tmp292_;
			gint _tmp293_;
			gint _param_index = 0;
			_tmp289_ = m;
			_tmp290_ = vala_callable_get_parameters ((ValaCallable*) _tmp289_);
			_param_list = _tmp290_;
			_tmp291_ = _param_list;
			_tmp292_ = vala_collection_get_size ((ValaCollection*) _tmp291_);
			_tmp293_ = _tmp292_;
			_param_size = _tmp293_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp294_;
				gint _tmp295_;
				gint _tmp296_;
				ValaParameter* param = NULL;
				ValaList* _tmp297_;
				gint _tmp298_;
				gpointer _tmp299_;
				ValaParameter* _tmp300_;
				ValaParameter* _tmp301_;
				gboolean _tmp302_;
				gboolean _tmp303_;
				ValaIterator* _tmp304_;
				_tmp294_ = _param_index;
				_param_index = _tmp294_ + 1;
				_tmp295_ = _param_index;
				_tmp296_ = _param_size;
				if (!(_tmp295_ < _tmp296_)) {
					break;
				}
				_tmp297_ = _param_list;
				_tmp298_ = _param_index;
				_tmp299_ = vala_list_get (_tmp297_, _tmp298_);
				param = (ValaParameter*) _tmp299_;
				_tmp300_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp300_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp301_ = param;
				_tmp302_ = vala_parameter_get_ellipsis (_tmp301_);
				_tmp303_ = _tmp302_;
				if (_tmp303_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp304_ = arg_it;
				if (vala_iterator_next (_tmp304_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp305_;
					gpointer _tmp306_;
					ValaExpression* _tmp307_;
					ValaParameter* _tmp308_;
					ValaDataType* _tmp309_;
					ValaDataType* _tmp310_;
					ValaExpression* _tmp311_;
					ValaExpression* _tmp312_;
					ValaDataType* _tmp313_;
					ValaDataType* _tmp314_;
					ValaDataType* _tmp315_;
					ValaDataType* _tmp316_;
					ValaDataType* _tmp317_;
					ValaDataType* _tmp318_;
					ValaExpression* _tmp319_;
					ValaExpression* _tmp320_;
					_tmp305_ = arg_it;
					_tmp306_ = vala_iterator_get (_tmp305_);
					arg = (ValaExpression*) _tmp306_;
					_tmp307_ = arg;
					_tmp308_ = param;
					_tmp309_ = vala_variable_get_variable_type ((ValaVariable*) _tmp308_);
					_tmp310_ = _tmp309_;
					vala_expression_set_formal_target_type (_tmp307_, _tmp310_);
					_tmp311_ = arg;
					_tmp312_ = arg;
					_tmp313_ = vala_expression_get_formal_target_type (_tmp312_);
					_tmp314_ = _tmp313_;
					_tmp315_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp316_ = _tmp315_;
					_tmp317_ = vala_data_type_get_actual_type (_tmp314_, _tmp316_, NULL, (ValaCodeNode*) self);
					_tmp318_ = _tmp317_;
					vala_expression_set_target_type (_tmp311_, _tmp318_);
					_vala_code_node_unref0 (_tmp318_);
					_tmp319_ = arg;
					_tmp320_ = _vala_code_node_ref0 (_tmp319_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp320_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp321_ = m;
		_tmp322_ = vala_method_get_printf_format (_tmp321_);
		_tmp323_ = _tmp322_;
		if (_tmp323_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp324_;
			ValaStringLiteral* _tmp367_;
			format_literal = NULL;
			_tmp324_ = last_arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp324_, VALA_TYPE_NULL_LITERAL)) {
			} else {
				ValaExpression* _tmp325_;
				_tmp325_ = last_arg;
				if (_tmp325_ != NULL) {
					ValaExpression* _tmp326_;
					ValaStringLiteral* _tmp327_;
					gboolean _tmp328_ = FALSE;
					ValaStringLiteral* _tmp329_;
					_tmp326_ = last_arg;
					_tmp327_ = vala_string_literal_get_format_literal (_tmp326_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp327_;
					_tmp329_ = format_literal;
					if (_tmp329_ == NULL) {
						ValaList* _tmp330_;
						gint _tmp331_;
						gint _tmp332_;
						ValaMethod* _tmp333_;
						ValaList* _tmp334_;
						ValaList* _tmp335_;
						gint _tmp336_;
						gint _tmp337_;
						_tmp330_ = args;
						_tmp331_ = vala_collection_get_size ((ValaCollection*) _tmp330_);
						_tmp332_ = _tmp331_;
						_tmp333_ = m;
						_tmp334_ = vala_callable_get_parameters ((ValaCallable*) _tmp333_);
						_tmp335_ = _tmp334_;
						_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
						_tmp337_ = _tmp336_;
						_tmp328_ = _tmp332_ == (_tmp337_ - 1);
						_vala_iterable_unref0 (_tmp335_);
					} else {
						_tmp328_ = FALSE;
					}
					if (_tmp328_) {
						ValaStringLiteral* _tmp338_;
						ValaStringLiteral* _tmp339_;
						ValaSemanticAnalyzer* _tmp340_;
						ValaSemanticAnalyzer* _tmp341_;
						ValaDataType* _tmp342_;
						ValaDataType* _tmp343_;
						ValaDataType* _tmp344_;
						ValaList* _tmp345_;
						ValaList* _tmp346_;
						gint _tmp347_;
						gint _tmp348_;
						ValaStringLiteral* _tmp349_;
						ValaList* _tmp350_;
						ValaIterator* _tmp351_;
						_tmp338_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp338_;
						_tmp339_ = format_literal;
						_tmp340_ = vala_code_context_get_analyzer (context);
						_tmp341_ = _tmp340_;
						_tmp342_ = _tmp341_->string_type;
						_tmp343_ = vala_data_type_copy (_tmp342_);
						_tmp344_ = _tmp343_;
						vala_expression_set_target_type ((ValaExpression*) _tmp339_, _tmp344_);
						_vala_code_node_unref0 (_tmp344_);
						_tmp345_ = self->priv->argument_list;
						_tmp346_ = args;
						_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = format_literal;
						vala_list_insert (_tmp345_, _tmp348_ - 1, (ValaExpression*) _tmp349_);
						_tmp350_ = self->priv->argument_list;
						_tmp351_ = vala_iterable_iterator ((ValaIterable*) _tmp350_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp351_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp352_;
							ValaList* _tmp353_;
							gint _param_size = 0;
							ValaList* _tmp354_;
							gint _tmp355_;
							gint _tmp356_;
							gint _param_index = 0;
							_tmp352_ = m;
							_tmp353_ = vala_callable_get_parameters ((ValaCallable*) _tmp352_);
							_param_list = _tmp353_;
							_tmp354_ = _param_list;
							_tmp355_ = vala_collection_get_size ((ValaCollection*) _tmp354_);
							_tmp356_ = _tmp355_;
							_param_size = _tmp356_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp357_;
								gint _tmp358_;
								gint _tmp359_;
								ValaParameter* param = NULL;
								ValaList* _tmp360_;
								gint _tmp361_;
								gpointer _tmp362_;
								ValaParameter* _tmp363_;
								gboolean _tmp364_;
								gboolean _tmp365_;
								ValaIterator* _tmp366_;
								_tmp357_ = _param_index;
								_param_index = _tmp357_ + 1;
								_tmp358_ = _param_index;
								_tmp359_ = _param_size;
								if (!(_tmp358_ < _tmp359_)) {
									break;
								}
								_tmp360_ = _param_list;
								_tmp361_ = _param_index;
								_tmp362_ = vala_list_get (_tmp360_, _tmp361_);
								param = (ValaParameter*) _tmp362_;
								_tmp363_ = param;
								_tmp364_ = vala_parameter_get_ellipsis (_tmp363_);
								_tmp365_ = _tmp364_;
								if (_tmp365_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp366_ = arg_it;
								vala_iterator_next (_tmp366_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp367_ = format_literal;
			if (_tmp367_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp368_;
				gchar* _tmp369_;
				ValaSemanticAnalyzer* _tmp370_;
				ValaSemanticAnalyzer* _tmp371_;
				const gchar* _tmp372_;
				ValaIterator* _tmp373_;
				ValaSourceReference* _tmp374_;
				ValaSourceReference* _tmp375_;
				_tmp368_ = format_literal;
				_tmp369_ = vala_string_literal_eval (_tmp368_);
				format = _tmp369_;
				_tmp370_ = vala_code_context_get_analyzer (context);
				_tmp371_ = _tmp370_;
				_tmp372_ = format;
				_tmp373_ = arg_it;
				_tmp374_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp375_ = _tmp374_;
				if (!vala_semantic_analyzer_check_print_format (_tmp371_, _tmp372_, _tmp373_, _tmp375_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp376_;
			ValaList* _tmp377_;
			gint _arg_size = 0;
			ValaList* _tmp378_;
			gint _tmp379_;
			gint _tmp380_;
			gint _arg_index = 0;
			_tmp376_ = args;
			_tmp377_ = _vala_iterable_ref0 (_tmp376_);
			_arg_list = _tmp377_;
			_tmp378_ = _arg_list;
			_tmp379_ = vala_collection_get_size ((ValaCollection*) _tmp378_);
			_tmp380_ = _tmp379_;
			_arg_size = _tmp380_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp381_;
				gint _tmp382_;
				gint _tmp383_;
				ValaExpression* arg = NULL;
				ValaList* _tmp384_;
				gint _tmp385_;
				gpointer _tmp386_;
				ValaExpression* _tmp387_;
				_tmp381_ = _arg_index;
				_arg_index = _tmp381_ + 1;
				_tmp382_ = _arg_index;
				_tmp383_ = _arg_size;
				if (!(_tmp382_ < _tmp383_)) {
					break;
				}
				_tmp384_ = _arg_list;
				_tmp385_ = _arg_index;
				_tmp386_ = vala_list_get (_tmp384_, _tmp385_);
				arg = (ValaExpression*) _tmp386_;
				_tmp387_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp387_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp388_ = vala_code_context_get_analyzer (context);
		_tmp389_ = _tmp388_;
		_tmp390_ = m;
		_tmp391_ = vala_method_type_new (_tmp390_);
		_tmp392_ = _tmp391_;
		_tmp393_ = m;
		_tmp394_ = vala_callable_get_parameters ((ValaCallable*) _tmp393_);
		_tmp395_ = _tmp394_;
		_tmp396_ = args;
		vala_semantic_analyzer_check_arguments (_tmp389_, (ValaExpression*) self, (ValaDataType*) _tmp392_, _tmp395_, _tmp396_);
		_vala_iterable_unref0 (_tmp395_);
		_vala_code_node_unref0 (_tmp392_);
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp397_;
			ValaList* _tmp398_;
			gint _error_type_size = 0;
			ValaList* _tmp399_;
			gint _tmp400_;
			gint _tmp401_;
			gint _error_type_index = 0;
			_tmp397_ = m;
			_tmp398_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp397_);
			_error_type_list = _tmp398_;
			_tmp399_ = _error_type_list;
			_tmp400_ = vala_collection_get_size ((ValaCollection*) _tmp399_);
			_tmp401_ = _tmp400_;
			_error_type_size = _tmp401_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp402_;
				gint _tmp403_;
				gint _tmp404_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp405_;
				gint _tmp406_;
				gpointer _tmp407_;
				ValaDataType* call_error_type = NULL;
				ValaDataType* _tmp408_;
				ValaDataType* _tmp409_;
				ValaDataType* _tmp410_;
				ValaSourceReference* _tmp411_;
				ValaSourceReference* _tmp412_;
				ValaDataType* _tmp413_;
				_tmp402_ = _error_type_index;
				_error_type_index = _tmp402_ + 1;
				_tmp403_ = _error_type_index;
				_tmp404_ = _error_type_size;
				if (!(_tmp403_ < _tmp404_)) {
					break;
				}
				_tmp405_ = _error_type_list;
				_tmp406_ = _error_type_index;
				_tmp407_ = vala_list_get (_tmp405_, _tmp406_);
				error_type = (ValaDataType*) _tmp407_;
				may_throw = TRUE;
				_tmp408_ = error_type;
				_tmp409_ = vala_data_type_copy (_tmp408_);
				call_error_type = _tmp409_;
				_tmp410_ = call_error_type;
				_tmp411_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp412_ = _tmp411_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp410_, _tmp412_);
				_tmp413_ = call_error_type;
				vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp413_);
				_vala_code_node_unref0 (call_error_type);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp414_;
		ValaDataType* _tmp415_;
		_tmp414_ = vala_object_creation_expression_get_type_reference (self);
		_tmp415_ = _tmp414_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp415_, VALA_TYPE_ERROR_TYPE)) {
			ValaDataType* _tmp416_;
			ValaDataType* _tmp417_;
			ValaMemberAccess* _tmp420_;
			ValaList* _tmp446_;
			ValaList* _tmp447_;
			gint _tmp448_;
			gint _tmp449_;
			gboolean _tmp450_;
			_tmp416_ = vala_object_creation_expression_get_type_reference (self);
			_tmp417_ = _tmp416_;
			if (_tmp417_ != NULL) {
				ValaDataType* _tmp418_;
				ValaDataType* _tmp419_;
				_tmp418_ = vala_object_creation_expression_get_type_reference (self);
				_tmp419_ = _tmp418_;
				vala_code_node_check ((ValaCodeNode*) _tmp419_, context);
			}
			_tmp420_ = self->priv->_member_name;
			if (_tmp420_ != NULL) {
				ValaMemberAccess* _tmp421_;
				_tmp421_ = self->priv->_member_name;
				vala_code_node_check ((ValaCodeNode*) _tmp421_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp422_;
				ValaList* _tmp423_;
				gint _arg_size = 0;
				ValaList* _tmp424_;
				gint _tmp425_;
				gint _tmp426_;
				gint _arg_index = 0;
				_tmp422_ = self->priv->argument_list;
				_tmp423_ = _vala_iterable_ref0 (_tmp422_);
				_arg_list = _tmp423_;
				_tmp424_ = _arg_list;
				_tmp425_ = vala_collection_get_size ((ValaCollection*) _tmp424_);
				_tmp426_ = _tmp425_;
				_arg_size = _tmp426_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp427_;
					gint _tmp428_;
					gint _tmp429_;
					ValaExpression* arg = NULL;
					ValaList* _tmp430_;
					gint _tmp431_;
					gpointer _tmp432_;
					ValaExpression* _tmp433_;
					_tmp427_ = _arg_index;
					_arg_index = _tmp427_ + 1;
					_tmp428_ = _arg_index;
					_tmp429_ = _arg_size;
					if (!(_tmp428_ < _tmp429_)) {
						break;
					}
					_tmp430_ = _arg_list;
					_tmp431_ = _arg_index;
					_tmp432_ = vala_list_get (_tmp430_, _tmp431_);
					arg = (ValaExpression*) _tmp432_;
					_tmp433_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp433_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp434_;
				ValaList* _tmp435_;
				gint _init_size = 0;
				ValaList* _tmp436_;
				gint _tmp437_;
				gint _tmp438_;
				gint _init_index = 0;
				_tmp434_ = self->priv->object_initializer;
				_tmp435_ = _vala_iterable_ref0 (_tmp434_);
				_init_list = _tmp435_;
				_tmp436_ = _init_list;
				_tmp437_ = vala_collection_get_size ((ValaCollection*) _tmp436_);
				_tmp438_ = _tmp437_;
				_init_size = _tmp438_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp439_;
					gint _tmp440_;
					gint _tmp441_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp442_;
					gint _tmp443_;
					gpointer _tmp444_;
					ValaMemberInitializer* _tmp445_;
					_tmp439_ = _init_index;
					_init_index = _tmp439_ + 1;
					_tmp440_ = _init_index;
					_tmp441_ = _init_size;
					if (!(_tmp440_ < _tmp441_)) {
						break;
					}
					_tmp442_ = _init_list;
					_tmp443_ = _init_index;
					_tmp444_ = vala_list_get (_tmp442_, _tmp443_);
					init = (ValaMemberInitializer*) _tmp444_;
					_tmp445_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp445_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp446_ = vala_object_creation_expression_get_argument_list (self);
			_tmp447_ = _tmp446_;
			_tmp448_ = vala_collection_get_size ((ValaCollection*) _tmp447_);
			_tmp449_ = _tmp448_;
			_tmp450_ = _tmp449_ == 0;
			_vala_iterable_unref0 (_tmp447_);
			if (_tmp450_) {
				ValaSourceReference* _tmp451_;
				ValaSourceReference* _tmp452_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp451_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp452_ = _tmp451_;
				vala_report_error (_tmp452_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp453_;
				ValaList* _tmp454_;
				ValaIterator* _tmp455_;
				ValaIterator* _tmp456_;
				ValaIterator* _tmp457_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp458_;
				gpointer _tmp459_;
				gboolean _tmp460_ = FALSE;
				ValaExpression* _tmp461_;
				ValaDataType* _tmp462_;
				ValaDataType* _tmp463_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp472_;
				ValaStringLiteral* _tmp473_;
				ValaStringLiteral* _tmp474_;
				ValaList* _tmp483_;
				ValaList* _tmp484_;
				ValaIterator* _tmp485_;
				ValaIterator* _tmp486_;
				ValaSemanticAnalyzer* _tmp487_;
				ValaSemanticAnalyzer* _tmp488_;
				ValaIterator* _tmp489_;
				ValaSourceReference* _tmp490_;
				ValaSourceReference* _tmp491_;
				_tmp453_ = vala_object_creation_expression_get_argument_list (self);
				_tmp454_ = _tmp453_;
				_tmp455_ = vala_iterable_iterator ((ValaIterable*) _tmp454_);
				_tmp456_ = _tmp455_;
				_vala_iterable_unref0 (_tmp454_);
				arg_it = _tmp456_;
				_tmp457_ = arg_it;
				vala_iterator_next (_tmp457_);
				_tmp458_ = arg_it;
				_tmp459_ = vala_iterator_get (_tmp458_);
				ex = (ValaExpression*) _tmp459_;
				_tmp461_ = ex;
				_tmp462_ = vala_expression_get_value_type (_tmp461_);
				_tmp463_ = _tmp462_;
				if (_tmp463_ == NULL) {
					_tmp460_ = TRUE;
				} else {
					ValaExpression* _tmp464_;
					ValaDataType* _tmp465_;
					ValaDataType* _tmp466_;
					ValaSemanticAnalyzer* _tmp467_;
					ValaSemanticAnalyzer* _tmp468_;
					ValaDataType* _tmp469_;
					_tmp464_ = ex;
					_tmp465_ = vala_expression_get_value_type (_tmp464_);
					_tmp466_ = _tmp465_;
					_tmp467_ = vala_code_context_get_analyzer (context);
					_tmp468_ = _tmp467_;
					_tmp469_ = _tmp468_->string_type;
					_tmp460_ = !vala_data_type_compatible (_tmp466_, _tmp469_);
				}
				if (_tmp460_) {
					ValaSourceReference* _tmp470_;
					ValaSourceReference* _tmp471_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp471_ = _tmp470_;
					vala_report_error (_tmp471_, "Invalid type for argument 1");
				}
				_tmp472_ = ex;
				_tmp473_ = vala_string_literal_get_format_literal (_tmp472_);
				format_literal = _tmp473_;
				_tmp474_ = format_literal;
				if (_tmp474_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp475_;
					gchar* _tmp476_;
					ValaSemanticAnalyzer* _tmp477_;
					ValaSemanticAnalyzer* _tmp478_;
					const gchar* _tmp479_;
					ValaIterator* _tmp480_;
					ValaSourceReference* _tmp481_;
					ValaSourceReference* _tmp482_;
					_tmp475_ = format_literal;
					_tmp476_ = vala_string_literal_eval (_tmp475_);
					format = _tmp476_;
					_tmp477_ = vala_code_context_get_analyzer (context);
					_tmp478_ = _tmp477_;
					_tmp479_ = format;
					_tmp480_ = arg_it;
					_tmp481_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp482_ = _tmp481_;
					if (!vala_semantic_analyzer_check_print_format (_tmp478_, _tmp479_, _tmp480_, _tmp482_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp483_ = vala_object_creation_expression_get_argument_list (self);
				_tmp484_ = _tmp483_;
				_tmp485_ = vala_iterable_iterator ((ValaIterable*) _tmp484_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp485_;
				_vala_iterable_unref0 (_tmp484_);
				_tmp486_ = arg_it;
				vala_iterator_next (_tmp486_);
				_tmp487_ = vala_code_context_get_analyzer (context);
				_tmp488_ = _tmp487_;
				_tmp489_ = arg_it;
				_tmp490_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp491_ = _tmp490_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp488_, _tmp489_, 1, _tmp491_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp492_;
		gint _init_size = 0;
		ValaList* _tmp493_;
		gint _tmp494_;
		gint _tmp495_;
		gint _init_index = 0;
		_tmp492_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp492_;
		_tmp493_ = _init_list;
		_tmp494_ = vala_collection_get_size ((ValaCollection*) _tmp493_);
		_tmp495_ = _tmp494_;
		_init_size = _tmp495_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp496_;
			gint _tmp497_;
			gint _tmp498_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp499_;
			gint _tmp500_;
			gpointer _tmp501_;
			ValaSemanticAnalyzer* _tmp502_;
			ValaSemanticAnalyzer* _tmp503_;
			ValaMemberInitializer* _tmp504_;
			ValaDataType* _tmp505_;
			ValaDataType* _tmp506_;
			_tmp496_ = _init_index;
			_init_index = _tmp496_ + 1;
			_tmp497_ = _init_index;
			_tmp498_ = _init_size;
			if (!(_tmp497_ < _tmp498_)) {
				break;
			}
			_tmp499_ = _init_list;
			_tmp500_ = _init_index;
			_tmp501_ = vala_list_get (_tmp499_, _tmp500_);
			init = (ValaMemberInitializer*) _tmp501_;
			_tmp502_ = vala_code_context_get_analyzer (context);
			_tmp503_ = _tmp502_;
			_tmp504_ = init;
			_tmp505_ = vala_object_creation_expression_get_type_reference (self);
			_tmp506_ = _tmp505_;
			vala_semantic_analyzer_visit_member_initializer (_tmp503_, _tmp504_, _tmp506_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp507_ = may_throw;
	if (_tmp507_) {
		gboolean _tmp508_ = FALSE;
		ValaCodeNode* _tmp509_;
		ValaCodeNode* _tmp510_;
		_tmp509_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp510_ = _tmp509_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp510_, VALA_TYPE_LOCAL_VARIABLE)) {
			_tmp508_ = TRUE;
		} else {
			ValaCodeNode* _tmp511_;
			ValaCodeNode* _tmp512_;
			_tmp511_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp512_ = _tmp511_;
			_tmp508_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp512_, VALA_TYPE_EXPRESSION_STATEMENT);
		}
		if (_tmp508_) {
		} else {
			ValaSemanticAnalyzer* _tmp513_;
			ValaSemanticAnalyzer* _tmp514_;
			ValaSymbol* _tmp515_;
			ValaSymbol* _tmp516_;
			_tmp513_ = vala_code_context_get_analyzer (context);
			_tmp514_ = _tmp513_;
			_tmp515_ = vala_semantic_analyzer_get_current_symbol (_tmp514_);
			_tmp516_ = _tmp515_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp516_, VALA_TYPE_BLOCK)) {
				ValaSourceReference* _tmp517_;
				ValaSourceReference* _tmp518_;
				_tmp517_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp518_ = _tmp517_;
				vala_report_error (_tmp518_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp519_;
				ValaCodeNode* _tmp520_;
				ValaCodeNode* _tmp521_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp522_;
				ValaDataType* _tmp523_;
				ValaDataType* _tmp524_;
				ValaDataType* _tmp525_;
				gchar* _tmp526_;
				gchar* _tmp527_;
				ValaSourceReference* _tmp528_;
				ValaSourceReference* _tmp529_;
				ValaLocalVariable* _tmp530_;
				ValaLocalVariable* _tmp531_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp532_;
				ValaSourceReference* _tmp533_;
				ValaSourceReference* _tmp534_;
				ValaDeclarationStatement* _tmp535_;
				ValaSemanticAnalyzer* _tmp536_;
				ValaSemanticAnalyzer* _tmp537_;
				ValaBlock* _tmp538_;
				ValaDeclarationStatement* _tmp539_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp540_;
				ValaDataType* _tmp541_;
				ValaDataType* _tmp542_;
				ValaExpression* _tmp543_;
				ValaLocalVariable* _tmp544_;
				ValaDeclarationStatement* _tmp545_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp546_;
				ValaSemanticAnalyzer* _tmp547_;
				ValaSymbol* _tmp548_;
				ValaSymbol* _tmp549_;
				ValaBlock* _tmp550_;
				ValaBlock* _tmp551_;
				ValaLocalVariable* _tmp552_;
				ValaSemanticAnalyzer* _tmp553_;
				ValaSemanticAnalyzer* _tmp554_;
				ValaBlock* _tmp555_;
				ValaLocalVariable* _tmp556_;
				ValaCodeNode* _tmp557_;
				ValaExpression* _tmp558_;
				ValaExpression* _tmp559_;
				_tmp519_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp520_ = _tmp519_;
				_tmp521_ = _vala_code_node_ref0 (_tmp520_);
				old_parent_node = _tmp521_;
				_tmp522_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_data_type_copy (_tmp523_);
				_tmp525_ = _tmp524_;
				_tmp526_ = vala_code_node_get_temp_name ();
				_tmp527_ = _tmp526_;
				_tmp528_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_local_variable_new (_tmp525_, _tmp527_, NULL, _tmp529_);
				_tmp531_ = _tmp530_;
				_g_free0 (_tmp527_);
				_vala_code_node_unref0 (_tmp525_);
				local = _tmp531_;
				_tmp532_ = local;
				_tmp533_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp534_ = _tmp533_;
				_tmp535_ = vala_declaration_statement_new ((ValaSymbol*) _tmp532_, _tmp534_);
				decl = _tmp535_;
				_tmp536_ = vala_code_context_get_analyzer (context);
				_tmp537_ = _tmp536_;
				_tmp538_ = _tmp537_->insert_block;
				_tmp539_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp538_, (ValaStatement*) _tmp539_);
				_tmp540_ = local;
				_tmp541_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp542_ = _tmp541_;
				_tmp543_ = vala_semantic_analyzer_create_temp_access (_tmp540_, _tmp542_);
				temp_access = _tmp543_;
				_tmp544_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp544_, (ValaExpression*) self);
				_tmp545_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp545_, context);
				_tmp546_ = vala_code_context_get_analyzer (context);
				_tmp547_ = _tmp546_;
				_tmp548_ = vala_semantic_analyzer_get_current_symbol (_tmp547_);
				_tmp549_ = _tmp548_;
				_tmp550_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp549_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp550_;
				_tmp551_ = block;
				_tmp552_ = local;
				vala_block_remove_local_variable (_tmp551_, _tmp552_);
				_tmp553_ = vala_code_context_get_analyzer (context);
				_tmp554_ = _tmp553_;
				_tmp555_ = _tmp554_->insert_block;
				_tmp556_ = local;
				vala_block_add_local_variable (_tmp555_, _tmp556_);
				_tmp557_ = old_parent_node;
				_tmp558_ = temp_access;
				vala_code_node_replace_expression (_tmp557_, (ValaExpression*) self, _tmp558_);
				_tmp559_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp559_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp560_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp561_ = _tmp560_;
	result = !_tmp561_;
	_vala_code_node_unref0 (type);
	return result;
}


static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp23_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp23_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_struct_creation;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaObjectCreationExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}


static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = vala_object_creation_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}


static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_code_node_unref0 (self->priv->_member_name);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		ValaObjectCreationExpression_private_offset = g_type_add_instance_private (vala_object_creation_expression_type_id, sizeof (ValaObjectCreationExpressionPrivate));
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}



