/*
 * LogonHelper.cpp - implementation of LogonHelper class
 *
 * Copyright (c) 2019-2020 Tobias Junghans <tobydox@veyon.io>
 *
 * This file is part of Veyon - https://veyon.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program (see COPYING); if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 */

#include "LogonHelper.h"
#include "PersistentLogonCredentials.h"
#include "PlatformPluginInterface.h"
#include "PlatformUserFunctions.h"
#include "ServiceDataManager.h"


LogonHelper::LogonHelper( QObject* parent ) :
	QObject( parent )
{
	connect( VeyonCore::instance(), &VeyonCore::applicationLoaded,
			 this, &LogonHelper::checkPendingLogonTasks );
}



bool LogonHelper::prepare( const QString& username, const Password& password )
{
	if( VeyonCore::platform().userFunctions().isAnyUserLoggedOn() )
	{
		vInfo() << "Skipping user logon as a user is already logged on";
		return false;
	}

	return PersistentLogonCredentials::write( username, password );
}



void LogonHelper::checkPendingLogonTasks()
{
	if( ServiceDataManager::serviceDataTokenFromEnvironment().isEmpty() == false &&
		VeyonCore::platform().userFunctions().isAnyUserLoggedOn() == false )
	{
		vDebug() << "Reading logon credentials";
		QString username;
		Password password;
		if( PersistentLogonCredentials::read( &username, &password ) )
		{
			PersistentLogonCredentials::clear();

			VeyonCore::platform().userFunctions().performLogon( username, password );
		}
	}
}
