---
sort: 2
---

# Additional Scrape Configuration

AdditionalScrapeConfigs allows specifying a key of a Secret containing
additional Prometheus scrape configurations or define scrape configuration at CRD spec.
Scrape configurations specified
are appended to the configurations generated by the operator.

Job configurations specified must have the form as specified in the official
[Prometheus documentation](
https://prometheus.io/docs/prometheus/latest/configuration/configuration/#scrape_config).
As scrape configs are appended, the user is responsible to make sure it is
valid. 

## Creating an additional configuration inline at CRD

  Add needed scrape configuration directly to the vmagent spec.inlineScrapeConfig
 
```yaml
cat <<EOF | kubectl apply -f -
apiVersion: operator.victoriametrics.com/v1beta1
kind: VMAgent
metadata:
  name: example-vmagent
spec:
  serviceScrapeSelector: {}
  replicas: 1
  serviceAccountName: vmagent
  inlineScrapeConfig: |
    - job_name: "prometheus"
      static_configs:
      - targets: ["localhost:9090"]
  remoteWrite:
    - url: "http://vmagent-example-vmsingle.default.svc:8429/api/v1/write"
EOF
```

NOTE: Do not use password and tokens with inlineScrapeConfig.


## Creating an additional configuration with secret

First, you will need to create the additional configuration.
Below we are making a simple "prometheus" config.  Name this
`prometheus-additional.yaml` or something similar.

```yaml
cat <<EOF | kubectl apply -f -
apiVersion: v1
kind: Secret
metadata:
  name: additional-scrape-configs
stringData:
  prometheus-additional.yaml: |
    - job_name: "prometheus"
      static_configs:
      - targets: ["localhost:9090"]
EOF
```

Finally, reference this additional configuration in your `vmagent.yaml` CRD.

```yaml
cat <<EOF | kubectl apply -f -
apiVersion: operator.victoriametrics.com/v1beta1
kind: VMAgent
metadata:
  name: example-vmagent
spec:
  serviceScrapeSelector: {}
  replicas: 1
  serviceAccountName: vmagent
  additionalScrapeConfigs:
    name: additional-scrape-configs
    key: prometheus-additional.yaml
  remoteWrite:
    - url: "http://vmagent-example-vmsingle.default.svc:8429/api/v1/write"
EOF
```

NOTE: Use only one secret for ALL additional scrape configurations.

