/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.resources.JavacompilerMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;

class JavaCompilerHelper {
    private static final Class[] compileMethodSignature = new Class[]{String[].class, PrintWriter.class};

    JavaCompilerHelper() {
    }

    static File getJarFile(Class clazz) {
        URL url = null;
        try {
            url = ParallelWorldClassLoader.toJarUrl(clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class"));
            return new File(url.toURI());
        }
        catch (ClassNotFoundException e) {
            throw new Error(e);
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    static boolean compile(String[] args, OutputStream out, ErrorReceiver receiver) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> comSunToolsJavacMainClass = cl.loadClass("com.sun.tools.javac.Main");
            try {
                Method compileMethod = comSunToolsJavacMainClass.getMethod("compile", compileMethodSignature);
                Object result = compileMethod.invoke(null, args, new PrintWriter(out));
                return result instanceof Integer && (Integer)result == 0;
            }
            catch (NoSuchMethodException e2) {
                receiver.error(JavacompilerMessages.JAVACOMPILER_NOSUCHMETHOD_ERROR("getMethod(\"compile\", Class[])"), e2);
            }
            catch (IllegalAccessException e) {
                receiver.error(e);
            }
            catch (InvocationTargetException e) {
                receiver.error(e);
            }
        }
        catch (ClassNotFoundException e) {
            receiver.error(JavacompilerMessages.JAVACOMPILER_CLASSPATH_ERROR("com.sun.tools.javac.Main"), e);
        }
        catch (SecurityException e) {
            receiver.error(e);
        }
        return false;
    }
}

