/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.util;

import org.web3d.vrml.lang.InvalidFieldValueException;

public class FieldValidator {
    public static void checkColorVector(String string, float[] fArray) throws InvalidFieldValueException {
        if (fArray[0] < 0.0f || fArray[0] > 1.0f || fArray[1] < 0.0f || fArray[1] > 1.0f || fArray[2] < 0.0f || fArray[2] > 1.0f) {
            throw new InvalidFieldValueException("Color components must be [0,1]. " + string + " Value is: " + fArray[0] + "," + fArray[1] + "," + fArray[2]);
        }
    }

    public static void checkColorAlphaVector(String string, float[] fArray) throws InvalidFieldValueException {
        if (fArray[0] < 0.0f || fArray[0] > 1.0f || fArray[1] < 0.0f || fArray[1] > 1.0f || fArray[2] < 0.0f || fArray[2] > 1.0f || fArray[3] < 0.0f || fArray[3] > 1.0f) {
            throw new InvalidFieldValueException("Color components must be [0,1]. " + string + " Value is: " + fArray[0] + "," + fArray[1] + "," + fArray[2] + "," + fArray[3]);
        }
    }

    public static void checkColorArray(String string, float[] fArray) throws InvalidFieldValueException {
        for (int i = 0; i < fArray.length; ++i) {
            if (!(fArray[i] < 0.0f) && !(fArray[i] > 1.0f)) continue;
            throw new InvalidFieldValueException("Color components must be [0,1]. " + string + " Value at index " + i + " is: " + fArray[i]);
        }
    }

    public static void checkFloat(String string, float f) throws InvalidFieldValueException {
        if (f < 0.0f || f > 1.0f) {
            throw new InvalidFieldValueException("Float value must be [0,1].  " + string + " Value is: " + f);
        }
    }

    public static void checkFloatPosInfinity(String string, float f) throws InvalidFieldValueException {
        if (f < 0.0f) {
            throw new InvalidFieldValueException("Float value must be [0,infinity). " + string + " Value is: " + f);
        }
    }

    public static void checkDoublePosInfinity(String string, double d) throws InvalidFieldValueException {
        if (d < 0.0) {
            throw new InvalidFieldValueException("Double value must be [0,infinity). " + string + " Value is: " + d);
        }
    }

    public static void checkIntPosInfinity(String string, int n) throws InvalidFieldValueException {
        if (n < 0) {
            throw new InvalidFieldValueException("Integer value must be [0,infinity). " + string + " Value is: " + n);
        }
    }

    public static void checkBBoxSize(String string, float[] fArray) throws InvalidFieldValueException {
        if ((fArray[0] < 0.0f || fArray[1] < 0.0f || fArray[2] < 0.0f) && (fArray[0] != -1.0f || fArray[1] != -1.0f || fArray[2] != -1.0f)) {
            throw new InvalidFieldValueException("BBoxSize must be (0,inf) or -1, -1, -1. " + string + " Value is: " + fArray[0] + "," + fArray[1] + "," + fArray[2]);
        }
    }

    public static void checkBBoxSize2D(String string, float[] fArray) throws InvalidFieldValueException {
        if ((fArray[0] < 0.0f || fArray[1] < 0.0f) && (fArray[0] != -1.0f || fArray[1] != -1.0f)) {
            throw new InvalidFieldValueException("BBoxSize must be (0,inf) or -1, -1. " + string + " Value is: " + fArray[0] + "," + fArray[1]);
        }
    }
}

