# -*- coding: utf-8 -*-
"""
ldaputil.ldapurl - extended LDAPUrl class
(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: extldapurl.py,v 1.3 2009/12/01 18:43:08 michael Exp $
"""

__version__ = '$Revision: 1.3 $'.split(' ')[1]


import ldapurl


class ExtendedLDAPUrl(ldapurl.LDAPUrl):
  """
  Class for LDAP URLs passed as query string derived from LDAPUrl
  """
  attr2extype = {
    'who':'bindname',
    'cred':'X-BINDPW',
    'x_startTLS':'x-starttls',
    'saslMech':'x-saslmech',
    'saslAuthzId':'x-saslauthzid',
    'saslRealm':'x-saslrealm',
  }

  def getStartTLSOpt(self,minStartTLSOpt):
    """
    Returns a value indicating whether StartTLS ext.op. shall be used.
    Argument minStartTLSOpt indicates the minimum security level requested.
    0 No
    1 Yes, if possible. Proceed if not possible.
    2 Yes, mandantory. Abort if not possible.
    """
    if not self.extensions:
      return minStartTLSOpt
    try:
      e = self.extensions.get('startTLS',self.extensions['starttls'])
    except KeyError:
      try:
        result = int(self.x_startTLS or '0')
      except ValueError:
        raise w2lapp.core.ErrorExit(u'LDAP URL extension x-starttls must be integer 0, 1 or 2.')
    else:
      result = int(e.critical) + int(e.extype.lower()=='starttls')
    return max(result,minStartTLSOpt) # getStartTLSOpt()


