// File is generated by JavaScriptCore/inspector/scripts/CodeGeneratorInspector.py

// Copyright (c) 2013 Apple Inc. All Rights Reserved.
// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


#include "config.h"
#include "InspectorJSTypeBuilders.h"

#if ENABLE(INSPECTOR)

#include <wtf/text/CString.h>

namespace Inspector {

namespace TypeBuilder {

static const char* const enum_constant_values[] = {
    "log",
    "evaluate",
    "sound",
    "probe",
    "global",
    "local",
    "with",
    "closure",
    "catch",
    "object",
    "function",
    "undefined",
    "string",
    "number",
    "boolean",
    "array",
    "null",
    "node",
    "regexp",
    "date",
    "none",
    "irrecoverable",
    "unterminated-literal",
    "recoverable",
    "XHR",
    "DOM",
    "EventListener",
    "exception",
    "assert",
    "CSPViolation",
    "other"
};

String getJSEnumConstantValue(int code) {
    return enum_constant_values[code];
}

} // namespace TypeBuilder



#if !ASSERT_DISABLED

void Inspector::TypeBuilder::Debugger::Location::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator scriptIdPos;
        scriptIdPos = object->find("scriptId");
        ASSERT(scriptIdPos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(scriptIdPos->value.get());
    }
    {
        InspectorObject::iterator lineNumberPos;
        lineNumberPos = object->find("lineNumber");
        ASSERT(lineNumberPos != object->end());
        RuntimeCastHelper::assertInt(lineNumberPos->value.get());
    }
    int foundPropertiesCount = 2;
    {
        InspectorObject::iterator columnNumberPos;
        columnNumberPos = object->find("columnNumber");
        if (columnNumberPos != object->end()) {
            RuntimeCastHelper::assertInt(columnNumberPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Debugger::FunctionDetails::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator locationPos;
        locationPos = object->find("location");
        ASSERT(locationPos != object->end());
        Inspector::TypeBuilder::Debugger::Location::assertCorrectValue(locationPos->value.get());
    }
    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator namePos;
        namePos = object->find("name");
        if (namePos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(namePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator displayNamePos;
        displayNamePos = object->find("displayName");
        if (displayNamePos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(displayNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator inferredNamePos;
        inferredNamePos = object->find("inferredName");
        if (inferredNamePos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(inferredNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator scopeChainPos;
        scopeChainPos = object->find("scopeChain");
        if (scopeChainPos != object->end()) {
            Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Debugger::Scope>::assertCorrectValue(scopeChainPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Debugger::CallFrame::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator callFrameIdPos;
        callFrameIdPos = object->find("callFrameId");
        ASSERT(callFrameIdPos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(callFrameIdPos->value.get());
    }
    {
        InspectorObject::iterator functionNamePos;
        functionNamePos = object->find("functionName");
        ASSERT(functionNamePos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(functionNamePos->value.get());
    }
    {
        InspectorObject::iterator locationPos;
        locationPos = object->find("location");
        ASSERT(locationPos != object->end());
        Inspector::TypeBuilder::Debugger::Location::assertCorrectValue(locationPos->value.get());
    }
    {
        InspectorObject::iterator scopeChainPos;
        scopeChainPos = object->find("scopeChain");
        ASSERT(scopeChainPos != object->end());
        Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Debugger::Scope>::assertCorrectValue(scopeChainPos->value.get());
    }
    {
        InspectorObject::iterator thisPos;
        thisPos = object->find("this");
        ASSERT(thisPos != object->end());
        Inspector::TypeBuilder::Runtime::RemoteObject::assertCorrectValue(thisPos->value.get());
    }
    int foundPropertiesCount = 5;
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Debugger::Scope::Type::assertCorrectValue(Inspector::InspectorValue* value)
{
    WTF::String s;
    bool cast_res = value->asString(&s);
    ASSERT(cast_res);
    ASSERT(s == "global" || s == "local" || s == "with" || s == "closure" || s == "catch");
}


void Inspector::TypeBuilder::Debugger::Scope::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator typePos;
        typePos = object->find("type");
        ASSERT(typePos != object->end());
        Type::assertCorrectValue(typePos->value.get());
    }
    {
        InspectorObject::iterator objectPos;
        objectPos = object->find("object");
        ASSERT(objectPos != object->end());
        Inspector::TypeBuilder::Runtime::RemoteObject::assertCorrectValue(objectPos->value.get());
    }
    int foundPropertiesCount = 2;
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Runtime::RemoteObject::Type::assertCorrectValue(Inspector::InspectorValue* value)
{
    WTF::String s;
    bool cast_res = value->asString(&s);
    ASSERT(cast_res);
    ASSERT(s == "object" || s == "function" || s == "undefined" || s == "string" || s == "number" || s == "boolean");
}


void Inspector::TypeBuilder::Runtime::RemoteObject::Subtype::assertCorrectValue(Inspector::InspectorValue* value)
{
    WTF::String s;
    bool cast_res = value->asString(&s);
    ASSERT(cast_res);
    ASSERT(s == "array" || s == "null" || s == "node" || s == "regexp" || s == "date");
}


void Inspector::TypeBuilder::Runtime::RemoteObject::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator typePos;
        typePos = object->find("type");
        ASSERT(typePos != object->end());
        Type::assertCorrectValue(typePos->value.get());
    }
    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator subtypePos;
        subtypePos = object->find("subtype");
        if (subtypePos != object->end()) {
            Subtype::assertCorrectValue(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator classNamePos;
        classNamePos = object->find("className");
        if (classNamePos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(classNamePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator valuePos;
        valuePos = object->find("value");
        if (valuePos != object->end()) {
            RuntimeCastHelper::assertAny(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator descriptionPos;
        descriptionPos = object->find("description");
        if (descriptionPos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(descriptionPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator objectIdPos;
        objectIdPos = object->find("objectId");
        if (objectIdPos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(objectIdPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator previewPos;
        previewPos = object->find("preview");
        if (previewPos != object->end()) {
            Inspector::TypeBuilder::Runtime::ObjectPreview::assertCorrectValue(previewPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Runtime::ObjectPreview::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator losslessPos;
        losslessPos = object->find("lossless");
        ASSERT(losslessPos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeBoolean>(losslessPos->value.get());
    }
    {
        InspectorObject::iterator overflowPos;
        overflowPos = object->find("overflow");
        ASSERT(overflowPos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeBoolean>(overflowPos->value.get());
    }
    {
        InspectorObject::iterator propertiesPos;
        propertiesPos = object->find("properties");
        ASSERT(propertiesPos != object->end());
        Inspector::TypeBuilder::Array<Inspector::TypeBuilder::Runtime::PropertyPreview>::assertCorrectValue(propertiesPos->value.get());
    }
    int foundPropertiesCount = 3;
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Runtime::PropertyPreview::Type::assertCorrectValue(Inspector::InspectorValue* value)
{
    WTF::String s;
    bool cast_res = value->asString(&s);
    ASSERT(cast_res);
    ASSERT(s == "object" || s == "function" || s == "undefined" || s == "string" || s == "number" || s == "boolean");
}


void Inspector::TypeBuilder::Runtime::PropertyPreview::Subtype::assertCorrectValue(Inspector::InspectorValue* value)
{
    WTF::String s;
    bool cast_res = value->asString(&s);
    ASSERT(cast_res);
    ASSERT(s == "array" || s == "null" || s == "node" || s == "regexp" || s == "date");
}


void Inspector::TypeBuilder::Runtime::PropertyPreview::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator namePos;
        namePos = object->find("name");
        ASSERT(namePos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(namePos->value.get());
    }
    {
        InspectorObject::iterator typePos;
        typePos = object->find("type");
        ASSERT(typePos != object->end());
        Type::assertCorrectValue(typePos->value.get());
    }
    int foundPropertiesCount = 2;
    {
        InspectorObject::iterator valuePos;
        valuePos = object->find("value");
        if (valuePos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator valuePreviewPos;
        valuePreviewPos = object->find("valuePreview");
        if (valuePreviewPos != object->end()) {
            Inspector::TypeBuilder::Runtime::ObjectPreview::assertCorrectValue(valuePreviewPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator subtypePos;
        subtypePos = object->find("subtype");
        if (subtypePos != object->end()) {
            Subtype::assertCorrectValue(subtypePos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Runtime::PropertyDescriptor::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator namePos;
        namePos = object->find("name");
        ASSERT(namePos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(namePos->value.get());
    }
    {
        InspectorObject::iterator configurablePos;
        configurablePos = object->find("configurable");
        ASSERT(configurablePos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeBoolean>(configurablePos->value.get());
    }
    {
        InspectorObject::iterator enumerablePos;
        enumerablePos = object->find("enumerable");
        ASSERT(enumerablePos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeBoolean>(enumerablePos->value.get());
    }
    int foundPropertiesCount = 3;
    {
        InspectorObject::iterator valuePos;
        valuePos = object->find("value");
        if (valuePos != object->end()) {
            Inspector::TypeBuilder::Runtime::RemoteObject::assertCorrectValue(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator writablePos;
        writablePos = object->find("writable");
        if (writablePos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeBoolean>(writablePos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator getPos;
        getPos = object->find("get");
        if (getPos != object->end()) {
            Inspector::TypeBuilder::Runtime::RemoteObject::assertCorrectValue(getPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator setPos;
        setPos = object->find("set");
        if (setPos != object->end()) {
            Inspector::TypeBuilder::Runtime::RemoteObject::assertCorrectValue(setPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator wasThrownPos;
        wasThrownPos = object->find("wasThrown");
        if (wasThrownPos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeBoolean>(wasThrownPos->value.get());
            ++foundPropertiesCount;
        }
    }
    {
        InspectorObject::iterator isOwnPos;
        isOwnPos = object->find("isOwn");
        if (isOwnPos != object->end()) {
            RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeBoolean>(isOwnPos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}


void Inspector::TypeBuilder::Runtime::InternalPropertyDescriptor::assertCorrectValue(Inspector::InspectorValue* value)
{
    RefPtr<InspectorObject> object;
    bool castRes = value->asObject(&object);
    ASSERT_UNUSED(castRes, castRes);
    {
        InspectorObject::iterator namePos;
        namePos = object->find("name");
        ASSERT(namePos != object->end());
        RuntimeCastHelper::assertType<Inspector::InspectorValue::TypeString>(namePos->value.get());
    }
    int foundPropertiesCount = 1;
    {
        InspectorObject::iterator valuePos;
        valuePos = object->find("value");
        if (valuePos != object->end()) {
            Inspector::TypeBuilder::Runtime::RemoteObject::assertCorrectValue(valuePos->value.get());
            ++foundPropertiesCount;
        }
    }
    if (foundPropertiesCount != object->size())
        FATAL("Unexpected properties in object: %s\n", object->toJSONString().ascii().data());
}




#endif // !ASSERT_DISABLED

} // namespace Inspector

#endif // ENABLE(INSPECTOR)
