#ifndef TEXT_SERVER_PROTOCOL_H
#define TEXT_SERVER_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stddef.h>
#include "wayland-util.h"

struct wl_client;
struct wl_resource;

struct text_model;
struct text_model_manager;
struct input_method;

extern const struct wl_interface text_model_interface;
extern const struct wl_interface text_model_manager_interface;
extern const struct wl_interface input_method_interface;

struct text_model_interface {
	/**
	 * set_surrounding_text - (none)
	 * @text: (none)
	 */
	void (*set_surrounding_text)(struct wl_client *client,
				     struct wl_resource *resource,
				     const char *text);
	/**
	 * set_cursor_index - (none)
	 * @index: (none)
	 */
	void (*set_cursor_index)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t index);
	/**
	 * activate - (none)
	 */
	void (*activate)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * deactivate - (none)
	 */
	void (*deactivate)(struct wl_client *client,
			   struct wl_resource *resource);
	/**
	 * set_selected_text - (none)
	 * @text: (none)
	 * @index: (none)
	 */
	void (*set_selected_text)(struct wl_client *client,
				  struct wl_resource *resource,
				  const char *text,
				  int32_t index);
	/**
	 * set_micro_focus - (none)
	 * @x: (none)
	 * @y: (none)
	 * @width: (none)
	 * @height: (none)
	 */
	void (*set_micro_focus)(struct wl_client *client,
				struct wl_resource *resource,
				int32_t x,
				int32_t y,
				int32_t width,
				int32_t height);
	/**
	 * set_preedit - (none)
	 */
	void (*set_preedit)(struct wl_client *client,
			    struct wl_resource *resource);
	/**
	 * set_content_type - (none)
	 */
	void (*set_content_type)(struct wl_client *client,
				 struct wl_resource *resource);
};

#define TEXT_MODEL_COMMIT_STRING	0
#define TEXT_MODEL_PREEDIT_STRING	1
#define TEXT_MODEL_PREEDIT_STYLING	2
#define TEXT_MODEL_KEY	3
#define TEXT_MODEL_SELECTION_REPLACEMENT	4
#define TEXT_MODEL_DIRECTION	5
#define TEXT_MODEL_LOCALE	6

static inline void
text_model_send_commit_string(struct wl_resource *resource_, const char *text, uint32_t index)
{
	wl_resource_post_event(resource_, TEXT_MODEL_COMMIT_STRING, text, index);
}

static inline void
text_model_send_preedit_string(struct wl_resource *resource_, const char *text, uint32_t index)
{
	wl_resource_post_event(resource_, TEXT_MODEL_PREEDIT_STRING, text, index);
}

static inline void
text_model_send_preedit_styling(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TEXT_MODEL_PREEDIT_STYLING);
}

static inline void
text_model_send_key(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TEXT_MODEL_KEY);
}

static inline void
text_model_send_selection_replacement(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TEXT_MODEL_SELECTION_REPLACEMENT);
}

static inline void
text_model_send_direction(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TEXT_MODEL_DIRECTION);
}

static inline void
text_model_send_locale(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, TEXT_MODEL_LOCALE);
}

struct text_model_manager_interface {
	/**
	 * create_text_model - (none)
	 * @id: (none)
	 * @surface: (none)
	 */
	void (*create_text_model)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t id,
				  struct wl_resource *surface);
};

struct input_method_interface {
	/**
	 * commit_string - (none)
	 * @text: (none)
	 * @index: (none)
	 */
	void (*commit_string)(struct wl_client *client,
			      struct wl_resource *resource,
			      const char *text,
			      uint32_t index);
};

#ifdef  __cplusplus
}
#endif

#endif
