#!/bin/sh
: > version-numbers
for d in $(find modules -mindepth 3 -maxdepth 3 -type d); do
    echo $d >> version-numbers;
    grep version $d/INDEX | grep -v '#' | sort >> version-numbers;
    v1=$(grep ^version $d/INDEX| sed 's/^version *= *//');
    w1=$(grep ^wims_version $d/INDEX| sed 's/^wims_version *= *//');
    if [ -d /var/lib/wims/public_html/$d ]; then
	i=/var/lib/wims/public_html/$d/INDEX;
	grep version $i | grep -v '#' | sort >> version-numbers;
	v2=$(grep ^version $i| sed 's/^version *= *//');
	w2=$(grep ^wims_version $i| sed 's/^wims_version *= *//');
	if python -c "import sys;sys.exit('$v1'<='$v2' or '$w1'<='$w2')"; then
	    diff -ruN $d $i >> version-numbers;
	fi;
    else
	echo "-" >> version-numbers;
	echo "-" >> version-numbers;
    fi;
done

if grep -q diff version-numbers; then
    echo "================================================";
    echo " An inconsistency was found in version-numbers";
    echo "================================================";
fi
