#!/usr/bin/env python

# This file is part of Window-Switch.
# Copyright (c) 2009-2013 Antoine Martin <antoine@nagafix.co.uk>
# Window-Switch is released under the terms of the GNU GPL v3

from winswitch.util.simple_logger import Logger
from winswitch.util.common import check_remote_version, parse_version_string

logger=Logger("common_test", log_colour=Logger.RED, _debug=True)

def test_parse_version_string():
	assert parse_version_string("0.1") == [0,1]
	assert parse_version_string("1.2.3") == [1,2,3]
	assert parse_version_string("0.9.99") == [0,9,99]

def test_check_remote_version():
	check_remote_version([0,10,1])
	check_remote_version([1,0])
	check_remote_version([99])

def main():
	test_parse_version_string()
	test_check_remote_version()


if __name__ == "__main__":
	main()