/* sp_x86_64_asm
 *
 * Copyright (C) 2006-2020 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#define HAVE_INTEL_AVX2
#ifndef WOLFSSL_SP_NO_2048
#ifndef WOLFSSL_SP_NO_2048
/* Read big endian unsigned byte array into r.
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.globl	sp_2048_from_bin_bswap
.type	sp_2048_from_bin_bswap,@function
.align	16
sp_2048_from_bin_bswap:
#else
.globl	_sp_2048_from_bin_bswap
.p2align	4
_sp_2048_from_bin_bswap:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$256, %r10
        xorq	%r11, %r11
        jmp	L_2048_from_bin_bswap_64_end
L_2048_from_bin_bswap_64_start:
        subq	$64, %r9
        movq	56(%r9), %rax
        movq	48(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movq	40(%r9), %rax
        movq	32(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movq	24(%r9), %rax
        movq	16(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movq	8(%r9), %rax
        movq	(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$64, %rdi
        subq	$64, %rcx
L_2048_from_bin_bswap_64_end:
        cmpq	$63, %rcx
        jg	L_2048_from_bin_bswap_64_start
        jmp	L_2048_from_bin_bswap_8_end
L_2048_from_bin_bswap_8_start:
        subq	$8, %r9
        movq	(%r9), %rax
        bswapq	%rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_2048_from_bin_bswap_8_end:
        cmpq	$7, %rcx
        jg	L_2048_from_bin_bswap_8_start
        cmpq	%r11, %rcx
        je	L_2048_from_bin_bswap_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_2048_from_bin_bswap_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_2048_from_bin_bswap_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_2048_from_bin_bswap_hi_end:
        cmpq	%r10, %rdi
        je	L_2048_from_bin_bswap_zero_end
L_2048_from_bin_bswap_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_2048_from_bin_bswap_zero_start
L_2048_from_bin_bswap_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_2048_from_bin_bswap,.-sp_2048_from_bin_bswap
#endif /* __APPLE__ */
/* Read big endian unsigned byte array into r.
 * Uses the movbe instruction which is an optional instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.globl	sp_2048_from_bin_movbe
.type	sp_2048_from_bin_movbe,@function
.align	16
sp_2048_from_bin_movbe:
#else
.globl	_sp_2048_from_bin_movbe
.p2align	4
_sp_2048_from_bin_movbe:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$256, %r10
        xorq	%r11, %r11
        jmp	L_2048_from_bin_movbe_64_end
L_2048_from_bin_movbe_64_start:
        subq	$64, %r9
        movbeq	56(%r9), %rax
        movbeq	48(%r9), %r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movbeq	40(%r9), %rax
        movbeq	32(%r9), %r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movbeq	24(%r9), %rax
        movbeq	16(%r9), %r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movbeq	8(%r9), %rax
        movbeq	(%r9), %r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$64, %rdi
        subq	$64, %rcx
L_2048_from_bin_movbe_64_end:
        cmpq	$63, %rcx
        jg	L_2048_from_bin_movbe_64_start
        jmp	L_2048_from_bin_movbe_8_end
L_2048_from_bin_movbe_8_start:
        subq	$8, %r9
        movbeq	(%r9), %rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_2048_from_bin_movbe_8_end:
        cmpq	$7, %rcx
        jg	L_2048_from_bin_movbe_8_start
        cmpq	%r11, %rcx
        je	L_2048_from_bin_movbe_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_2048_from_bin_movbe_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_2048_from_bin_movbe_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_2048_from_bin_movbe_hi_end:
        cmpq	%r10, %rdi
        je	L_2048_from_bin_movbe_zero_end
L_2048_from_bin_movbe_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_2048_from_bin_movbe_zero_start
L_2048_from_bin_movbe_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_2048_from_bin_movbe,.-sp_2048_from_bin_movbe
#endif /* __APPLE__ */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 256
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.globl	sp_2048_to_bin_bswap
.type	sp_2048_to_bin_bswap,@function
.align	16
sp_2048_to_bin_bswap:
#else
.globl	_sp_2048_to_bin_bswap
.p2align	4
_sp_2048_to_bin_bswap:
#endif /* __APPLE__ */
        movq	248(%rdi), %rdx
        movq	240(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movq	232(%rdi), %rdx
        movq	224(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movq	216(%rdi), %rdx
        movq	208(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movq	200(%rdi), %rdx
        movq	192(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movq	184(%rdi), %rdx
        movq	176(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movq	168(%rdi), %rdx
        movq	160(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movq	152(%rdi), %rdx
        movq	144(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movq	136(%rdi), %rdx
        movq	128(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movq	120(%rdi), %rdx
        movq	112(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movq	104(%rdi), %rdx
        movq	96(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movq	88(%rdi), %rdx
        movq	80(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movq	72(%rdi), %rdx
        movq	64(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movq	56(%rdi), %rdx
        movq	48(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movq	40(%rdi), %rdx
        movq	32(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movq	24(%rdi), %rdx
        movq	16(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movq	8(%rdi), %rdx
        movq	(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_to_bin_bswap,.-sp_2048_to_bin_bswap
#endif /* __APPLE__ */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 256
 * Uses the movbe instruction which is optional.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.globl	sp_2048_to_bin_movbe
.type	sp_2048_to_bin_movbe,@function
.align	16
sp_2048_to_bin_movbe:
#else
.globl	_sp_2048_to_bin_movbe
.p2align	4
_sp_2048_to_bin_movbe:
#endif /* __APPLE__ */
        movbeq	248(%rdi), %rdx
        movbeq	240(%rdi), %rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movbeq	232(%rdi), %rdx
        movbeq	224(%rdi), %rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movbeq	216(%rdi), %rdx
        movbeq	208(%rdi), %rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movbeq	200(%rdi), %rdx
        movbeq	192(%rdi), %rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movbeq	184(%rdi), %rdx
        movbeq	176(%rdi), %rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movbeq	168(%rdi), %rdx
        movbeq	160(%rdi), %rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movbeq	152(%rdi), %rdx
        movbeq	144(%rdi), %rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movbeq	136(%rdi), %rdx
        movbeq	128(%rdi), %rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movbeq	120(%rdi), %rdx
        movbeq	112(%rdi), %rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movbeq	104(%rdi), %rdx
        movbeq	96(%rdi), %rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movbeq	88(%rdi), %rdx
        movbeq	80(%rdi), %rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movbeq	72(%rdi), %rdx
        movbeq	64(%rdi), %rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movbeq	56(%rdi), %rdx
        movbeq	48(%rdi), %rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movbeq	40(%rdi), %rdx
        movbeq	32(%rdi), %rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movbeq	24(%rdi), %rdx
        movbeq	16(%rdi), %rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movbeq	8(%rdi), %rdx
        movbeq	(%rdi), %rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_to_bin_movbe,.-sp_2048_to_bin_movbe
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_16
.type	sp_2048_mul_16,@function
.align	16
sp_2048_mul_16:
#else
.globl	_sp_2048_mul_16
.p2align	4
_sp_2048_mul_16:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        subq	$128, %rsp
        # A[0] * B[0]
        movq	(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        movq	%rax, (%rsp)
        movq	%rdx, %r9
        # A[0] * B[1]
        movq	8(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[0]
        movq	(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 8(%rsp)
        # A[0] * B[2]
        movq	16(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[1]
        movq	8(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[0]
        movq	(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 16(%rsp)
        # A[0] * B[3]
        movq	24(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[2]
        movq	16(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[1]
        movq	8(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[0]
        movq	(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 24(%rsp)
        # A[0] * B[4]
        movq	32(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[3]
        movq	24(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[2]
        movq	16(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[1]
        movq	8(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[0]
        movq	(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 32(%rsp)
        # A[0] * B[5]
        movq	40(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[4]
        movq	32(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[3]
        movq	24(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[2]
        movq	16(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[1]
        movq	8(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[0]
        movq	(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 40(%rsp)
        # A[0] * B[6]
        movq	48(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[5]
        movq	40(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[4]
        movq	32(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[3]
        movq	24(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[2]
        movq	16(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[1]
        movq	8(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[0]
        movq	(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 48(%rsp)
        # A[0] * B[7]
        movq	56(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[6]
        movq	48(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[5]
        movq	40(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[4]
        movq	32(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[3]
        movq	24(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[2]
        movq	16(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[1]
        movq	8(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[0]
        movq	(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 56(%rsp)
        # A[0] * B[8]
        movq	64(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[7]
        movq	56(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[6]
        movq	48(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[5]
        movq	40(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[4]
        movq	32(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[3]
        movq	24(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[2]
        movq	16(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[1]
        movq	8(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[0]
        movq	(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 64(%rsp)
        # A[0] * B[9]
        movq	72(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[8]
        movq	64(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[7]
        movq	56(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[6]
        movq	48(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[5]
        movq	40(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[4]
        movq	32(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[3]
        movq	24(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[2]
        movq	16(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[1]
        movq	8(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[0]
        movq	(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 72(%rsp)
        # A[0] * B[10]
        movq	80(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[9]
        movq	72(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[8]
        movq	64(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[7]
        movq	56(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[6]
        movq	48(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[5]
        movq	40(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[4]
        movq	32(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[3]
        movq	24(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[2]
        movq	16(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[1]
        movq	8(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[0]
        movq	(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 80(%rsp)
        # A[0] * B[11]
        movq	88(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[10]
        movq	80(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[9]
        movq	72(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[8]
        movq	64(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[7]
        movq	56(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[6]
        movq	48(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[5]
        movq	40(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[4]
        movq	32(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[3]
        movq	24(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[2]
        movq	16(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[1]
        movq	8(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[0]
        movq	(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 88(%rsp)
        # A[0] * B[12]
        movq	96(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[11]
        movq	88(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[10]
        movq	80(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[9]
        movq	72(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[8]
        movq	64(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[7]
        movq	56(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[6]
        movq	48(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[5]
        movq	40(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[4]
        movq	32(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[3]
        movq	24(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[2]
        movq	16(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[1]
        movq	8(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[12] * B[0]
        movq	(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 96(%rsp)
        # A[0] * B[13]
        movq	104(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[12]
        movq	96(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[11]
        movq	88(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[10]
        movq	80(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[9]
        movq	72(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[8]
        movq	64(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[7]
        movq	56(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[6]
        movq	48(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[5]
        movq	40(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[4]
        movq	32(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[3]
        movq	24(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[2]
        movq	16(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[12] * B[1]
        movq	8(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[13] * B[0]
        movq	(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 104(%rsp)
        # A[0] * B[14]
        movq	112(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[13]
        movq	104(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[12]
        movq	96(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[11]
        movq	88(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[10]
        movq	80(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[9]
        movq	72(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[8]
        movq	64(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[7]
        movq	56(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[6]
        movq	48(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[5]
        movq	40(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[4]
        movq	32(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[3]
        movq	24(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B[2]
        movq	16(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[13] * B[1]
        movq	8(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[14] * B[0]
        movq	(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 112(%rsp)
        # A[0] * B[15]
        movq	120(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[14]
        movq	112(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[13]
        movq	104(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[12]
        movq	96(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[11]
        movq	88(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[10]
        movq	80(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[9]
        movq	72(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[8]
        movq	64(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[7]
        movq	56(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[6]
        movq	48(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[5]
        movq	40(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[4]
        movq	32(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[12] * B[3]
        movq	24(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B[2]
        movq	16(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[14] * B[1]
        movq	8(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[15] * B[0]
        movq	(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 120(%rsp)
        # A[1] * B[15]
        movq	120(%rcx), %rax
        mulq	8(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[14]
        movq	112(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[13]
        movq	104(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[12]
        movq	96(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[11]
        movq	88(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[10]
        movq	80(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[9]
        movq	72(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[8]
        movq	64(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[7]
        movq	56(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[6]
        movq	48(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[5]
        movq	40(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[12] * B[4]
        movq	32(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[13] * B[3]
        movq	24(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B[2]
        movq	16(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[15] * B[1]
        movq	8(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 128(%rdi)
        # A[2] * B[15]
        movq	120(%rcx), %rax
        mulq	16(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[14]
        movq	112(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[13]
        movq	104(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[12]
        movq	96(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[11]
        movq	88(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[10]
        movq	80(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[9]
        movq	72(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[8]
        movq	64(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[7]
        movq	56(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[6]
        movq	48(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B[5]
        movq	40(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[13] * B[4]
        movq	32(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[14] * B[3]
        movq	24(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B[2]
        movq	16(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 136(%rdi)
        # A[3] * B[15]
        movq	120(%rcx), %rax
        mulq	24(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[14]
        movq	112(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[13]
        movq	104(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[12]
        movq	96(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[11]
        movq	88(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[10]
        movq	80(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[9]
        movq	72(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[8]
        movq	64(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[7]
        movq	56(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[12] * B[6]
        movq	48(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B[5]
        movq	40(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[14] * B[4]
        movq	32(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[15] * B[3]
        movq	24(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 144(%rdi)
        # A[4] * B[15]
        movq	120(%rcx), %rax
        mulq	32(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[14]
        movq	112(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[13]
        movq	104(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[12]
        movq	96(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[11]
        movq	88(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[10]
        movq	80(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[9]
        movq	72(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[8]
        movq	64(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[12] * B[7]
        movq	56(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[13] * B[6]
        movq	48(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B[5]
        movq	40(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[15] * B[4]
        movq	32(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 152(%rdi)
        # A[5] * B[15]
        movq	120(%rcx), %rax
        mulq	40(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[14]
        movq	112(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[13]
        movq	104(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[12]
        movq	96(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[11]
        movq	88(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[10]
        movq	80(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[9]
        movq	72(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B[8]
        movq	64(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[13] * B[7]
        movq	56(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[14] * B[6]
        movq	48(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B[5]
        movq	40(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 160(%rdi)
        # A[6] * B[15]
        movq	120(%rcx), %rax
        mulq	48(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[14]
        movq	112(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[13]
        movq	104(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[12]
        movq	96(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[11]
        movq	88(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[10]
        movq	80(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[12] * B[9]
        movq	72(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B[8]
        movq	64(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[14] * B[7]
        movq	56(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[15] * B[6]
        movq	48(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 168(%rdi)
        # A[7] * B[15]
        movq	120(%rcx), %rax
        mulq	56(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[14]
        movq	112(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[13]
        movq	104(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[12]
        movq	96(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[11]
        movq	88(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[12] * B[10]
        movq	80(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[13] * B[9]
        movq	72(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B[8]
        movq	64(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[15] * B[7]
        movq	56(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 176(%rdi)
        # A[8] * B[15]
        movq	120(%rcx), %rax
        mulq	64(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[14]
        movq	112(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[13]
        movq	104(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[12]
        movq	96(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B[11]
        movq	88(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[13] * B[10]
        movq	80(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[14] * B[9]
        movq	72(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B[8]
        movq	64(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 184(%rdi)
        # A[9] * B[15]
        movq	120(%rcx), %rax
        mulq	72(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[14]
        movq	112(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[13]
        movq	104(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[12] * B[12]
        movq	96(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B[11]
        movq	88(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[14] * B[10]
        movq	80(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[15] * B[9]
        movq	72(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 192(%rdi)
        # A[10] * B[15]
        movq	120(%rcx), %rax
        mulq	80(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[14]
        movq	112(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[12] * B[13]
        movq	104(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[13] * B[12]
        movq	96(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B[11]
        movq	88(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[15] * B[10]
        movq	80(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 200(%rdi)
        # A[11] * B[15]
        movq	120(%rcx), %rax
        mulq	88(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B[14]
        movq	112(%rcx), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[13] * B[13]
        movq	104(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[14] * B[12]
        movq	96(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B[11]
        movq	88(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 208(%rdi)
        # A[12] * B[15]
        movq	120(%rcx), %rax
        mulq	96(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B[14]
        movq	112(%rcx), %rax
        mulq	104(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[14] * B[13]
        movq	104(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[15] * B[12]
        movq	96(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 216(%rdi)
        # A[13] * B[15]
        movq	120(%rcx), %rax
        mulq	104(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B[14]
        movq	112(%rcx), %rax
        mulq	112(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[15] * B[13]
        movq	104(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 224(%rdi)
        # A[14] * B[15]
        movq	120(%rcx), %rax
        mulq	112(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B[14]
        movq	112(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 232(%rdi)
        # A[15] * B[15]
        movq	120(%rcx), %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r8
        movq	24(%rsp), %r9
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	%r9, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r8
        movq	56(%rsp), %r9
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r8
        movq	88(%rsp), %r9
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r8, 80(%rdi)
        movq	%r9, 88(%rdi)
        movq	96(%rsp), %rax
        movq	104(%rsp), %rdx
        movq	112(%rsp), %r8
        movq	120(%rsp), %r9
        movq	%rax, 96(%rdi)
        movq	%rdx, 104(%rdi)
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        addq	$128, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_16,.-sp_2048_mul_16
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_sqr_16
.type	sp_2048_sqr_16,@function
.align	16
sp_2048_sqr_16:
#else
.globl	_sp_2048_sqr_16
.p2align	4
_sp_2048_sqr_16:
#endif /* __APPLE__ */
        push	%r12
        subq	$128, %rsp
        # A[0] * A[0]
        movq	(%rsi), %rax
        mulq	%rax
        xorq	%r9, %r9
        movq	%rax, (%rsp)
        movq	%rdx, %r8
        # A[0] * A[1]
        movq	8(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        movq	%r8, 8(%rsp)
        # A[0] * A[2]
        movq	16(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        # A[1] * A[1]
        movq	8(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        movq	%r9, 16(%rsp)
        # A[0] * A[3]
        movq	24(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * A[2]
        movq	16(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%rcx, 24(%rsp)
        # A[0] * A[4]
        movq	32(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        # A[1] * A[3]
        movq	24(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        # A[2] * A[2]
        movq	16(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        movq	%r8, 32(%rsp)
        # A[0] * A[5]
        movq	40(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[4]
        movq	32(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[3]
        movq	24(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 40(%rsp)
        # A[0] * A[6]
        movq	48(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[5]
        movq	40(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[4]
        movq	32(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[3]
        movq	24(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 48(%rsp)
        # A[0] * A[7]
        movq	56(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[6]
        movq	48(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[5]
        movq	40(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[4]
        movq	32(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 56(%rsp)
        # A[0] * A[8]
        movq	64(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[7]
        movq	56(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[6]
        movq	48(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[5]
        movq	40(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[4]
        movq	32(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 64(%rsp)
        # A[0] * A[9]
        movq	72(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[8]
        movq	64(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[7]
        movq	56(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[6]
        movq	48(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[5]
        movq	40(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 72(%rsp)
        # A[0] * A[10]
        movq	80(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[9]
        movq	72(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[8]
        movq	64(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[7]
        movq	56(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[6]
        movq	48(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[5]
        movq	40(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 80(%rsp)
        # A[0] * A[11]
        movq	88(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[10]
        movq	80(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[9]
        movq	72(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[8]
        movq	64(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[7]
        movq	56(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[6]
        movq	48(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 88(%rsp)
        # A[0] * A[12]
        movq	96(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[11]
        movq	88(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[10]
        movq	80(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[9]
        movq	72(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[8]
        movq	64(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[7]
        movq	56(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[6]
        movq	48(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 96(%rsp)
        # A[0] * A[13]
        movq	104(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[12]
        movq	96(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[11]
        movq	88(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[10]
        movq	80(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[9]
        movq	72(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[8]
        movq	64(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[7]
        movq	56(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 104(%rsp)
        # A[0] * A[14]
        movq	112(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[13]
        movq	104(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[12]
        movq	96(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[11]
        movq	88(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[10]
        movq	80(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[9]
        movq	72(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[8]
        movq	64(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[7]
        movq	56(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 112(%rsp)
        # A[0] * A[15]
        movq	120(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[14]
        movq	112(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[13]
        movq	104(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[12]
        movq	96(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[11]
        movq	88(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[10]
        movq	80(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[9]
        movq	72(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[8]
        movq	64(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 120(%rsp)
        # A[1] * A[15]
        movq	120(%rsi), %rax
        mulq	8(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[2] * A[14]
        movq	112(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[13]
        movq	104(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[12]
        movq	96(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[11]
        movq	88(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[10]
        movq	80(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[9]
        movq	72(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[8]
        movq	64(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 128(%rdi)
        # A[2] * A[15]
        movq	120(%rsi), %rax
        mulq	16(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[3] * A[14]
        movq	112(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[13]
        movq	104(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[12]
        movq	96(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[11]
        movq	88(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[10]
        movq	80(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[9]
        movq	72(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 136(%rdi)
        # A[3] * A[15]
        movq	120(%rsi), %rax
        mulq	24(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[4] * A[14]
        movq	112(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[13]
        movq	104(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[12]
        movq	96(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[11]
        movq	88(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[10]
        movq	80(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[9] * A[9]
        movq	72(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 144(%rdi)
        # A[4] * A[15]
        movq	120(%rsi), %rax
        mulq	32(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[5] * A[14]
        movq	112(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[13]
        movq	104(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[12]
        movq	96(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[11]
        movq	88(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[9] * A[10]
        movq	80(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 152(%rdi)
        # A[5] * A[15]
        movq	120(%rsi), %rax
        mulq	40(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[6] * A[14]
        movq	112(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[13]
        movq	104(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[12]
        movq	96(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[9] * A[11]
        movq	88(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[10] * A[10]
        movq	80(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 160(%rdi)
        # A[6] * A[15]
        movq	120(%rsi), %rax
        mulq	48(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[7] * A[14]
        movq	112(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[13]
        movq	104(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[9] * A[12]
        movq	96(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[10] * A[11]
        movq	88(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 168(%rdi)
        # A[7] * A[15]
        movq	120(%rsi), %rax
        mulq	56(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[8] * A[14]
        movq	112(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[9] * A[13]
        movq	104(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[10] * A[12]
        movq	96(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[11] * A[11]
        movq	88(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 176(%rdi)
        # A[8] * A[15]
        movq	120(%rsi), %rax
        mulq	64(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[9] * A[14]
        movq	112(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[10] * A[13]
        movq	104(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[11] * A[12]
        movq	96(%rsi), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 184(%rdi)
        # A[9] * A[15]
        movq	120(%rsi), %rax
        mulq	72(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[10] * A[14]
        movq	112(%rsi), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[11] * A[13]
        movq	104(%rsi), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[12] * A[12]
        movq	96(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 192(%rdi)
        # A[10] * A[15]
        movq	120(%rsi), %rax
        mulq	80(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[11] * A[14]
        movq	112(%rsi), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[12] * A[13]
        movq	104(%rsi), %rax
        mulq	96(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 200(%rdi)
        # A[11] * A[15]
        movq	120(%rsi), %rax
        mulq	88(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        # A[12] * A[14]
        movq	112(%rsi), %rax
        mulq	96(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        # A[13] * A[13]
        movq	104(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        movq	%r9, 208(%rdi)
        # A[12] * A[15]
        movq	120(%rsi), %rax
        mulq	96(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[13] * A[14]
        movq	112(%rsi), %rax
        mulq	104(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%rcx, 216(%rdi)
        # A[13] * A[15]
        movq	120(%rsi), %rax
        mulq	104(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        # A[14] * A[14]
        movq	112(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        movq	%r8, 224(%rdi)
        # A[14] * A[15]
        movq	120(%rsi), %rax
        mulq	112(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        movq	%r9, 232(%rdi)
        # A[15] * A[15]
        movq	120(%rsi), %rax
        mulq	%rax
        addq	%rax, %rcx
        adcq	%rdx, %r8
        movq	%rcx, 240(%rdi)
        movq	%r8, 248(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r10
        movq	24(%rsp), %r11
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	%r11, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r10
        movq	56(%rsp), %r11
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r10, 48(%rdi)
        movq	%r11, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r10
        movq	88(%rsp), %r11
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r10, 80(%rdi)
        movq	%r11, 88(%rdi)
        movq	96(%rsp), %rax
        movq	104(%rsp), %rdx
        movq	112(%rsp), %r10
        movq	120(%rsp), %r11
        movq	%rax, 96(%rdi)
        movq	%rdx, 104(%rdi)
        movq	%r10, 112(%rdi)
        movq	%r11, 120(%rdi)
        addq	$128, %rsp
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_16,.-sp_2048_sqr_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Multiply a and b into r. (r = a * b)
 *
 * r   Result of multiplication.
 * a   First number to multiply.
 * b   Second number to multiply.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_avx2_16
.type	sp_2048_mul_avx2_16,@function
.align	16
sp_2048_mul_avx2_16:
#else
.globl	_sp_2048_mul_avx2_16
.p2align	4
_sp_2048_mul_avx2_16:
#endif /* __APPLE__ */
        push	%rbx
        push	%rbp
        push	%r12
        push	%r13
        push	%r14
        movq	%rdx, %rbp
        subq	$128, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbx
        cmovne	%rdi, %rbx
        cmpq	%rdi, %rbp
        cmove	%rsp, %rbx
        xorq	%r14, %r14
        movq	(%rsi), %rdx
        # A[0] * B[0]
        mulx	(%rbp), %r8, %r9
        # A[0] * B[1]
        mulx	8(%rbp), %rax, %r10
        movq	%r8, (%rbx)
        adcxq	%rax, %r9
        # A[0] * B[2]
        mulx	16(%rbp), %rax, %r11
        movq	%r9, 8(%rbx)
        adcxq	%rax, %r10
        # A[0] * B[3]
        mulx	24(%rbp), %rax, %r12
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r11
        movq	%r11, 24(%rbx)
        # A[0] * B[4]
        mulx	32(%rbp), %rax, %r8
        adcxq	%rax, %r12
        # A[0] * B[5]
        mulx	40(%rbp), %rax, %r9
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        # A[0] * B[6]
        mulx	48(%rbp), %rax, %r10
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        # A[0] * B[7]
        mulx	56(%rbp), %rax, %r11
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        movq	%r10, 56(%rbx)
        # A[0] * B[8]
        mulx	64(%rbp), %rax, %r12
        adcxq	%rax, %r11
        # A[0] * B[9]
        mulx	72(%rbp), %rax, %r8
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        # A[0] * B[10]
        mulx	80(%rbp), %rax, %r9
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        # A[0] * B[11]
        mulx	88(%rbp), %rax, %r10
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        movq	%r9, 88(%rbx)
        # A[0] * B[12]
        mulx	96(%rbp), %rax, %r11
        adcxq	%rax, %r10
        # A[0] * B[13]
        mulx	104(%rbp), %rax, %r12
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        # A[0] * B[14]
        mulx	112(%rbp), %rax, %r8
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        # A[0] * B[15]
        mulx	120(%rbp), %rax, %r9
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adcxq	%r14, %r9
        movq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r8, 120(%rbx)
        movq	%r9, 128(%rdi)
        movq	8(%rsi), %rdx
        movq	8(%rbx), %r9
        movq	16(%rbx), %r10
        movq	24(%rbx), %r11
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        # A[1] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 8(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[1] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[1] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r11, 24(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 32(%rbx)
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        # A[1] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[1] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 64(%rbx)
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        # A[1] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[1] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rbx)
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        # A[1] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[1] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[1] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        movq	%r14, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r13, %r10
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r9, 128(%rdi)
        movq	%r10, 136(%rdi)
        movq	16(%rsi), %rdx
        movq	16(%rbx), %r10
        movq	24(%rbx), %r11
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        # A[2] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[2] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[2] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r11, 24(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[2] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 40(%rbx)
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        # A[2] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[2] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[2] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 72(%rbx)
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        # A[2] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[2] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 104(%rbx)
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[2] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[2] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        movq	%r14, %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        adcxq	%r13, %r11
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r10, 136(%rdi)
        movq	%r11, 144(%rdi)
        movq	24(%rsi), %rdx
        movq	24(%rbx), %r11
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        # A[3] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[3] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r11, 24(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[3] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 48(%rbx)
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        # A[3] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[3] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[3] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[3] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 80(%rbx)
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        # A[3] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[3] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[3] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 112(%rbx)
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        # A[3] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[3] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        movq	%r14, %r12
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        adcxq	%r13, %r12
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r11, 144(%rdi)
        movq	%r12, 152(%rdi)
        movq	32(%rsi), %rdx
        movq	32(%rbx), %r12
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        # A[4] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[4] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r12, 32(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 56(%rbx)
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        # A[4] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[4] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[4] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 88(%rbx)
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        # A[4] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[4] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[4] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[4] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rbx)
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        # A[4] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[4] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[4] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        movq	%r14, %r8
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        adcxq	%r13, %r8
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r12, 152(%rdi)
        movq	%r8, 160(%rdi)
        movq	40(%rsi), %rdx
        movq	40(%rbx), %r8
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        # A[5] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 40(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[5] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 64(%rbx)
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        # A[5] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[5] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rbx)
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[5] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[5] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[5] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        # A[5] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[5] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[5] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[5] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        movq	%r14, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r13, %r9
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r8, 160(%rdi)
        movq	%r9, 168(%rdi)
        movq	48(%rsi), %rdx
        movq	48(%rbx), %r9
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        # A[6] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 48(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[6] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[6] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 72(%rbx)
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        # A[6] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[6] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 104(%rbx)
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        # A[6] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[6] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 136(%rdi)
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        # A[6] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[6] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[6] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        movq	%r14, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r13, %r10
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r9, 168(%rdi)
        movq	%r10, 176(%rdi)
        movq	56(%rsi), %rdx
        movq	56(%rbx), %r10
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        # A[7] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[7] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 56(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[7] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[7] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 80(%rbx)
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        # A[7] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[7] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[7] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 112(%rbx)
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        # A[7] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[7] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 144(%rdi)
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        movq	176(%rdi), %r10
        # A[7] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[7] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r9, 168(%rdi)
        movq	%r14, %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        adcxq	%r13, %r11
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r10, 176(%rdi)
        movq	%r11, 184(%rdi)
        movq	64(%rsi), %rdx
        movq	64(%rbx), %r11
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        # A[8] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[8] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r11, 64(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[8] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 88(%rbx)
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        # A[8] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[8] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[8] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[8] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rbx)
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        # A[8] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[8] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[8] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 152(%rdi)
        movq	168(%rdi), %r9
        movq	176(%rdi), %r10
        movq	184(%rdi), %r11
        # A[8] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r9, 168(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[8] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r10, 176(%rdi)
        movq	%r14, %r12
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        adcxq	%r13, %r12
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r11, 184(%rdi)
        movq	%r12, 192(%rdi)
        movq	72(%rsi), %rdx
        movq	72(%rbx), %r12
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        # A[9] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[9] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r12, 72(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rbx)
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[9] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[9] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[9] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        # A[9] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[9] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[9] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[9] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rdi), %r10
        movq	184(%rdi), %r11
        movq	192(%rdi), %r12
        # A[9] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r9, 168(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[9] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r10, 176(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[9] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r11, 184(%rdi)
        movq	%r14, %r8
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        adcxq	%r13, %r8
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r12, 192(%rdi)
        movq	%r8, 200(%rdi)
        movq	80(%rsi), %rdx
        movq	80(%rbx), %r8
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        # A[10] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 80(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[10] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 104(%rbx)
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        # A[10] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[10] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 136(%rdi)
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        movq	176(%rdi), %r10
        # A[10] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[10] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[10] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 168(%rdi)
        movq	184(%rdi), %r11
        movq	192(%rdi), %r12
        movq	200(%rdi), %r8
        # A[10] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[10] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r10, 176(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[10] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r11, 184(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[10] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r12, 192(%rdi)
        movq	%r14, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r13, %r9
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r8, 200(%rdi)
        movq	%r9, 208(%rdi)
        movq	88(%rsi), %rdx
        movq	88(%rbx), %r9
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        # A[11] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 88(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[11] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[11] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 112(%rbx)
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        # A[11] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[11] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 144(%rdi)
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        movq	176(%rdi), %r10
        movq	184(%rdi), %r11
        # A[11] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[11] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 168(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 176(%rdi)
        movq	192(%rdi), %r12
        movq	200(%rdi), %r8
        movq	208(%rdi), %r9
        # A[11] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[11] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r11, 184(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[11] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r12, 192(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r8, 200(%rdi)
        movq	%r14, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r13, %r10
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r9, 208(%rdi)
        movq	%r10, 216(%rdi)
        movq	96(%rsi), %rdx
        movq	96(%rbx), %r10
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        # A[12] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[12] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 96(%rbx)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[12] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[12] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rbx)
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        # A[12] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[12] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[12] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 152(%rdi)
        movq	168(%rdi), %r9
        movq	176(%rdi), %r10
        movq	184(%rdi), %r11
        movq	192(%rdi), %r12
        # A[12] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[12] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r9, 168(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[12] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 176(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 184(%rdi)
        movq	200(%rdi), %r8
        movq	208(%rdi), %r9
        movq	216(%rdi), %r10
        # A[12] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[12] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r12, 192(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[12] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r8, 200(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r9, 208(%rdi)
        movq	%r14, %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        adcxq	%r13, %r11
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r10, 216(%rdi)
        movq	%r11, 224(%rdi)
        movq	104(%rsi), %rdx
        movq	104(%rbx), %r11
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[13] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[13] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r11, 104(%rbx)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[13] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        # A[13] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[13] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[13] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[13] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rdi), %r10
        movq	184(%rdi), %r11
        movq	192(%rdi), %r12
        movq	200(%rdi), %r8
        # A[13] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 168(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[13] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r10, 176(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[13] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r11, 184(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        movq	%r12, 192(%rdi)
        movq	208(%rdi), %r9
        movq	216(%rdi), %r10
        movq	224(%rdi), %r11
        # A[13] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r8, 200(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r9, 208(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[13] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r10, 216(%rdi)
        movq	%r14, %r12
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        adcxq	%r13, %r12
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r11, 224(%rdi)
        movq	%r12, 232(%rdi)
        movq	112(%rsi), %rdx
        movq	112(%rbx), %r12
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        # A[14] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[14] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r12, 112(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[14] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 136(%rdi)
        movq	152(%rdi), %r12
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        movq	176(%rdi), %r10
        # A[14] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[14] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r11, 144(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[14] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 168(%rdi)
        movq	184(%rdi), %r11
        movq	192(%rdi), %r12
        movq	200(%rdi), %r8
        movq	208(%rdi), %r9
        # A[14] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[14] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 176(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[14] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r11, 184(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[14] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r12, 192(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 200(%rdi)
        movq	216(%rdi), %r10
        movq	224(%rdi), %r11
        movq	232(%rdi), %r12
        # A[14] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[14] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r9, 208(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[14] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r10, 216(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[14] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r11, 224(%rdi)
        movq	%r14, %r8
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        adcxq	%r13, %r8
        movq	%r14, %r13
        adoxq	%r14, %r13
        adcxq	%r14, %r13
        movq	%r12, 232(%rdi)
        movq	%r8, 240(%rdi)
        movq	120(%rsi), %rdx
        movq	120(%rbx), %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        movq	144(%rdi), %r11
        movq	152(%rdi), %r12
        # A[15] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 120(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] * B[2]
        mulx	16(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[15] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        movq	%r11, 144(%rdi)
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        movq	176(%rdi), %r10
        movq	184(%rdi), %r11
        # A[15] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[15] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r12, 152(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] * B[6]
        mulx	48(%rbp), %rax, %rcx
        movq	%r8, 160(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 168(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 176(%rdi)
        movq	192(%rdi), %r12
        movq	200(%rdi), %r8
        movq	208(%rdi), %r9
        movq	216(%rdi), %r10
        # A[15] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[15] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r11, 184(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[15] * B[10]
        mulx	80(%rbp), %rax, %rcx
        movq	%r12, 192(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 200(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 208(%rdi)
        movq	224(%rdi), %r11
        movq	232(%rdi), %r12
        movq	240(%rdi), %r8
        # A[15] * B[12]
        mulx	96(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        # A[15] * B[13]
        mulx	104(%rbp), %rax, %rcx
        movq	%r10, 216(%rdi)
        adcxq	%rax, %r11
        adoxq	%rcx, %r12
        # A[15] * B[14]
        mulx	112(%rbp), %rax, %rcx
        movq	%r11, 224(%rdi)
        adcxq	%rax, %r12
        adoxq	%rcx, %r8
        # A[15] * B[15]
        mulx	120(%rbp), %rax, %rcx
        movq	%r12, 232(%rdi)
        movq	%r14, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r13, %r9
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        cmpq	%rdi, %rsi
        je	L_start_2048_mul_avx2_16
        cmpq	%rdi, %rbp
        jne	L_end_2048_mul_avx2_16
L_start_2048_mul_avx2_16:
        vmovdqu	(%rbx), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbx), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbx), %xmm0
        vmovups	%xmm0, 32(%rdi)
        vmovdqu	48(%rbx), %xmm0
        vmovups	%xmm0, 48(%rdi)
        vmovdqu	64(%rbx), %xmm0
        vmovups	%xmm0, 64(%rdi)
        vmovdqu	80(%rbx), %xmm0
        vmovups	%xmm0, 80(%rdi)
        vmovdqu	96(%rbx), %xmm0
        vmovups	%xmm0, 96(%rdi)
        vmovdqu	112(%rbx), %xmm0
        vmovups	%xmm0, 112(%rdi)
L_end_2048_mul_avx2_16:
        addq	$128, %rsp
        pop	%r14
        pop	%r13
        pop	%r12
        pop	%rbp
        pop	%rbx
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_avx2_16,.-sp_2048_mul_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifdef HAVE_INTEL_AVX2
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_sqr_avx2_16
.type	sp_2048_sqr_avx2_16,@function
.align	16
sp_2048_sqr_avx2_16:
#else
.globl	_sp_2048_sqr_avx2_16
.p2align	4
_sp_2048_sqr_avx2_16:
#endif /* __APPLE__ */
        push	%rbp
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        push	%rbx
        subq	$128, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbp
        cmovne	%rdi, %rbp
        xorq	%r11, %r11
        # Diagonal 1
        xorq	%r10, %r10
        # A[1] x A[0]
        movq	(%rsi), %rdx
        mulxq	8(%rsi), %r8, %r9
        # A[2] x A[0]
        mulxq	16(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 8(%rbp)
        movq	%r9, 16(%rbp)
        movq	%r11, %r8
        movq	%r11, %r9
        # A[3] x A[0]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[4] x A[0]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 24(%rbp)
        movq	%r8, 32(%rbp)
        movq	%r11, %r10
        movq	%r11, %r8
        # A[5] x A[0]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] x A[0]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 40(%rbp)
        movq	%r10, 48(%rbp)
        movq	%r11, %r9
        movq	%r11, %r10
        # A[7] x A[0]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] x A[0]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 56(%rbp)
        movq	%r9, 64(%rbp)
        movq	%r11, %r8
        movq	%r11, %r9
        # A[9] x A[0]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[10] x A[0]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 72(%rbp)
        movq	%r8, 80(%rbp)
        movq	%r11, %r10
        movq	%r11, %r8
        # A[11] x A[0]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] x A[0]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 88(%rbp)
        movq	%r10, %r13
        movq	%r11, %r9
        movq	%r11, %r10
        # A[13] x A[0]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] x A[0]
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, %r14
        movq	%r9, %r15
        movq	%r11, %r8
        # A[15] x A[0]
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, %rbx
        #  Carry
        adcxq	%r11, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 128(%rdi)
        # Diagonal 2
        movq	24(%rbp), %r8
        movq	32(%rbp), %r9
        movq	40(%rbp), %r10
        # A[2] x A[1]
        movq	8(%rsi), %rdx
        mulxq	16(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] x A[1]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 24(%rbp)
        movq	%r9, 32(%rbp)
        movq	48(%rbp), %r8
        movq	56(%rbp), %r9
        # A[4] x A[1]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[5] x A[1]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 40(%rbp)
        movq	%r8, 48(%rbp)
        movq	64(%rbp), %r10
        movq	72(%rbp), %r8
        # A[6] x A[1]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] x A[1]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 56(%rbp)
        movq	%r10, 64(%rbp)
        movq	80(%rbp), %r9
        movq	88(%rbp), %r10
        # A[8] x A[1]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] x A[1]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 72(%rbp)
        movq	%r9, 80(%rbp)
        # No load %r13 - %r8
        # No load %r14 - %r9
        # A[10] x A[1]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # A[11] x A[1]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r10, 88(%rbp)
        # No store %r13
        # No load %r15 - %r10
        # No load %rbx - %r8
        # A[12] x A[1]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[13] x A[1]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14
        # No store %r15
        movq	128(%rdi), %r9
        movq	%r11, %r10
        # A[14] x A[1]
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # A[15] x A[1]
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # No store %rbx
        movq	%r9, 128(%rdi)
        movq	%r11, %r8
        # A[15] x A[2]
        movq	16(%rsi), %rdx
        mulxq	120(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 136(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 144(%rdi)
        # Diagonal 3
        movq	40(%rbp), %r8
        movq	48(%rbp), %r9
        movq	56(%rbp), %r10
        # A[3] x A[2]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] x A[2]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 40(%rbp)
        movq	%r9, 48(%rbp)
        movq	64(%rbp), %r8
        movq	72(%rbp), %r9
        # A[5] x A[2]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[6] x A[2]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 56(%rbp)
        movq	%r8, 64(%rbp)
        movq	80(%rbp), %r10
        movq	88(%rbp), %r8
        # A[7] x A[2]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] x A[2]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 72(%rbp)
        movq	%r10, 80(%rbp)
        # No load %r13 - %r9
        # No load %r14 - %r10
        # A[9] x A[2]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r13
        # A[10] x A[2]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r8, 88(%rbp)
        # No store %r13
        # No load %r15 - %r8
        # No load %rbx - %r9
        # A[11] x A[2]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[12] x A[2]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14
        # No store %r15
        movq	128(%rdi), %r10
        movq	136(%rdi), %r8
        # A[13] x A[2]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r10
        # A[14] x A[2]
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # No store %rbx
        movq	%r10, 128(%rdi)
        movq	144(%rdi), %r9
        movq	%r11, %r10
        # A[14] x A[3]
        movq	112(%rsi), %rdx
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] x A[4]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 136(%rdi)
        movq	%r9, 144(%rdi)
        movq	%r11, %r8
        # A[14] x A[5]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 152(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 160(%rdi)
        # Diagonal 4
        movq	56(%rbp), %r8
        movq	64(%rbp), %r9
        movq	72(%rbp), %r10
        # A[4] x A[3]
        movq	24(%rsi), %rdx
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] x A[3]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 56(%rbp)
        movq	%r9, 64(%rbp)
        movq	80(%rbp), %r8
        movq	88(%rbp), %r9
        # A[6] x A[3]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[7] x A[3]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 72(%rbp)
        movq	%r8, 80(%rbp)
        # No load %r13 - %r10
        # No load %r14 - %r8
        # A[8] x A[3]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r13
        # A[9] x A[3]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r9, 88(%rbp)
        # No store %r13
        # No load %r15 - %r9
        # No load %rbx - %r10
        # A[10] x A[3]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[11] x A[3]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14
        # No store %r15
        movq	128(%rdi), %r8
        movq	136(%rdi), %r9
        # A[12] x A[3]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # A[13] x A[3]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # No store %rbx
        movq	%r8, 128(%rdi)
        movq	144(%rdi), %r10
        movq	152(%rdi), %r8
        # A[13] x A[4]
        movq	104(%rsi), %rdx
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] x A[5]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 136(%rdi)
        movq	%r10, 144(%rdi)
        movq	160(%rdi), %r9
        movq	%r11, %r10
        # A[13] x A[6]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 152(%rdi)
        movq	%r9, 160(%rdi)
        movq	%r11, %r8
        # A[13] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 168(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 176(%rdi)
        # Diagonal 5
        movq	72(%rbp), %r8
        movq	80(%rbp), %r9
        movq	88(%rbp), %r10
        # A[5] x A[4]
        movq	32(%rsi), %rdx
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] x A[4]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 72(%rbp)
        movq	%r9, 80(%rbp)
        # No load %r13 - %r8
        # No load %r14 - %r9
        # A[7] x A[4]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # A[8] x A[4]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r10, 88(%rbp)
        # No store %r13
        # No load %r15 - %r10
        # No load %rbx - %r8
        # A[9] x A[4]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[10] x A[4]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14
        # No store %r15
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[11] x A[4]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # A[12] x A[4]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # No store %rbx
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r8
        movq	152(%rdi), %r9
        # A[12] x A[5]
        movq	96(%rsi), %rdx
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[12] x A[6]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 136(%rdi)
        movq	%r8, 144(%rdi)
        movq	160(%rdi), %r10
        movq	168(%rdi), %r8
        # A[12] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[12] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 152(%rdi)
        movq	%r10, 160(%rdi)
        movq	176(%rdi), %r9
        movq	%r11, %r10
        # A[12] x A[9]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[12] x A[10]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 168(%rdi)
        movq	%r9, 176(%rdi)
        movq	%r11, %r8
        # A[12] x A[11]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 184(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 192(%rdi)
        # Diagonal 6
        movq	88(%rbp), %r8
        # No load %r13 - %r9
        # No load %r14 - %r10
        # A[6] x A[5]
        movq	40(%rsi), %rdx
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r13
        # A[7] x A[5]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        movq	%r8, 88(%rbp)
        # No store %r13
        # No load %r15 - %r8
        # No load %rbx - %r9
        # A[8] x A[5]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[9] x A[5]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14
        # No store %r15
        movq	128(%rdi), %r10
        movq	136(%rdi), %r8
        # A[10] x A[5]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r10
        # A[11] x A[5]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # No store %rbx
        movq	%r10, 128(%rdi)
        movq	144(%rdi), %r9
        movq	152(%rdi), %r10
        # A[11] x A[6]
        movq	88(%rsi), %rdx
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 136(%rdi)
        movq	%r9, 144(%rdi)
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        # A[11] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[11] x A[9]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 152(%rdi)
        movq	%r8, 160(%rdi)
        movq	176(%rdi), %r10
        movq	184(%rdi), %r8
        # A[11] x A[10]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[13] x A[9]
        movq	104(%rsi), %rdx
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 168(%rdi)
        movq	%r10, 176(%rdi)
        movq	192(%rdi), %r9
        movq	%r11, %r10
        # A[13] x A[10]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[13] x A[11]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 184(%rdi)
        movq	%r9, 192(%rdi)
        movq	%r11, %r8
        # A[13] x A[12]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 200(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 208(%rdi)
        # Diagonal 7
        # No load %r14 - %r8
        # No load %r15 - %r9
        # No load %rbx - %r10
        # A[7] x A[6]
        movq	48(%rsi), %rdx
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # A[8] x A[6]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r14
        # No store %r15
        movq	128(%rdi), %r8
        movq	136(%rdi), %r9
        # A[9] x A[6]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # A[10] x A[6]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # No store %rbx
        movq	%r8, 128(%rdi)
        movq	144(%rdi), %r10
        movq	152(%rdi), %r8
        # A[10] x A[7]
        movq	80(%rsi), %rdx
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 136(%rdi)
        movq	%r10, 144(%rdi)
        movq	160(%rdi), %r9
        movq	168(%rdi), %r10
        # A[10] x A[9]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] x A[6]
        movq	112(%rsi), %rdx
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 152(%rdi)
        movq	%r9, 160(%rdi)
        movq	176(%rdi), %r8
        movq	184(%rdi), %r9
        # A[14] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[14] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 168(%rdi)
        movq	%r8, 176(%rdi)
        movq	192(%rdi), %r10
        movq	200(%rdi), %r8
        # A[14] x A[9]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[14] x A[10]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 184(%rdi)
        movq	%r10, 192(%rdi)
        movq	208(%rdi), %r9
        movq	%r11, %r10
        # A[14] x A[11]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[14] x A[12]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 200(%rdi)
        movq	%r9, 208(%rdi)
        movq	%r11, %r8
        # A[14] x A[13]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 216(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 224(%rdi)
        # Diagonal 8
        # No load %rbx - %r8
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[8] x A[7]
        movq	56(%rsi), %rdx
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # A[9] x A[7]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # No store %rbx
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r8
        movq	152(%rdi), %r9
        # A[9] x A[8]
        movq	64(%rsi), %rdx
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[15] x A[3]
        movq	120(%rsi), %rdx
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 136(%rdi)
        movq	%r8, 144(%rdi)
        movq	160(%rdi), %r10
        movq	168(%rdi), %r8
        # A[15] x A[4]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] x A[5]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 152(%rdi)
        movq	%r10, 160(%rdi)
        movq	176(%rdi), %r9
        movq	184(%rdi), %r10
        # A[15] x A[6]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 168(%rdi)
        movq	%r9, 176(%rdi)
        movq	192(%rdi), %r8
        movq	200(%rdi), %r9
        # A[15] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[15] x A[9]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r10, 184(%rdi)
        movq	%r8, 192(%rdi)
        movq	208(%rdi), %r10
        movq	216(%rdi), %r8
        # A[15] x A[10]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[15] x A[11]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r9, 200(%rdi)
        movq	%r10, 208(%rdi)
        movq	224(%rdi), %r9
        movq	%r11, %r10
        # A[15] x A[12]
        mulxq	96(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[15] x A[13]
        mulxq	104(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r8, 216(%rdi)
        movq	%r9, 224(%rdi)
        movq	%r11, %r8
        # A[15] x A[14]
        mulxq	112(%rsi), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 232(%rdi)
        #  Carry
        adcxq	%r12, %r8
        movq	%r11, %r12
        adcxq	%r11, %r12
        adoxq	%r11, %r12
        movq	%r8, 240(%rdi)
        movq	%r12, 248(%rdi)
        # Double and Add in A[i] x A[i]
        movq	8(%rbp), %r9
        # A[0] x A[0]
        movq	(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        movq	%rax, (%rbp)
        adoxq	%r9, %r9
        adcxq	%rcx, %r9
        movq	%r9, 8(%rbp)
        movq	16(%rbp), %r8
        movq	24(%rbp), %r9
        # A[1] x A[1]
        movq	8(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 16(%rbp)
        movq	%r9, 24(%rbp)
        movq	32(%rbp), %r8
        movq	40(%rbp), %r9
        # A[2] x A[2]
        movq	16(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 32(%rbp)
        movq	%r9, 40(%rbp)
        movq	48(%rbp), %r8
        movq	56(%rbp), %r9
        # A[3] x A[3]
        movq	24(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 48(%rbp)
        movq	%r9, 56(%rbp)
        movq	64(%rbp), %r8
        movq	72(%rbp), %r9
        # A[4] x A[4]
        movq	32(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 64(%rbp)
        movq	%r9, 72(%rbp)
        movq	80(%rbp), %r8
        movq	88(%rbp), %r9
        # A[5] x A[5]
        movq	40(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 80(%rbp)
        movq	%r9, 88(%rbp)
        # A[6] x A[6]
        movq	48(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r13, %r13
        adoxq	%r14, %r14
        adcxq	%rax, %r13
        adcxq	%rcx, %r14
        # A[7] x A[7]
        movq	56(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r15, %r15
        adoxq	%rbx, %rbx
        adcxq	%rax, %r15
        adcxq	%rcx, %rbx
        movq	128(%rdi), %r8
        movq	136(%rdi), %r9
        # A[8] x A[8]
        movq	64(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 128(%rdi)
        movq	%r9, 136(%rdi)
        movq	144(%rdi), %r8
        movq	152(%rdi), %r9
        # A[9] x A[9]
        movq	72(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 144(%rdi)
        movq	%r9, 152(%rdi)
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        # A[10] x A[10]
        movq	80(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 160(%rdi)
        movq	%r9, 168(%rdi)
        movq	176(%rdi), %r8
        movq	184(%rdi), %r9
        # A[11] x A[11]
        movq	88(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        movq	192(%rdi), %r8
        movq	200(%rdi), %r9
        # A[12] x A[12]
        movq	96(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 192(%rdi)
        movq	%r9, 200(%rdi)
        movq	208(%rdi), %r8
        movq	216(%rdi), %r9
        # A[13] x A[13]
        movq	104(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 208(%rdi)
        movq	%r9, 216(%rdi)
        movq	224(%rdi), %r8
        movq	232(%rdi), %r9
        # A[14] x A[14]
        movq	112(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 224(%rdi)
        movq	%r9, 232(%rdi)
        movq	240(%rdi), %r8
        movq	248(%rdi), %r9
        # A[15] x A[15]
        movq	120(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        movq	%r13, 96(%rdi)
        movq	%r14, 104(%rdi)
        movq	%r15, 112(%rdi)
        movq	%rbx, 120(%rdi)
        cmpq	%rdi, %rsi
        jne	L_end_2048_sqr_avx2_16
        vmovdqu	(%rbp), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbp), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbp), %xmm0
        vmovups	%xmm0, 32(%rdi)
        vmovdqu	48(%rbp), %xmm0
        vmovups	%xmm0, 48(%rdi)
        vmovdqu	64(%rbp), %xmm0
        vmovups	%xmm0, 64(%rdi)
        vmovdqu	80(%rbp), %xmm0
        vmovups	%xmm0, 80(%rdi)
L_end_2048_sqr_avx2_16:
        addq	$128, %rsp
        pop	%rbx
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        pop	%rbp
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_avx2_16,.-sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_add_16
.type	sp_2048_add_16,@function
.align	16
sp_2048_add_16:
#else
.globl	_sp_2048_add_16
.p2align	4
_sp_2048_add_16:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	%r8, 120(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_add_16,.-sp_2048_add_16
#endif /* __APPLE__ */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_sub_in_place_32
.type	sp_2048_sub_in_place_32,@function
.align	16
sp_2048_sub_in_place_32:
#else
.globl	_sp_2048_sub_in_place_32
.p2align	4
_sp_2048_sub_in_place_32:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        xorq	%rax, %rax
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	128(%rdi), %rdx
        movq	%rcx, 120(%rdi)
        sbbq	128(%rsi), %rdx
        movq	136(%rdi), %rcx
        movq	%rdx, 128(%rdi)
        sbbq	136(%rsi), %rcx
        movq	144(%rdi), %rdx
        movq	%rcx, 136(%rdi)
        sbbq	144(%rsi), %rdx
        movq	152(%rdi), %rcx
        movq	%rdx, 144(%rdi)
        sbbq	152(%rsi), %rcx
        movq	160(%rdi), %rdx
        movq	%rcx, 152(%rdi)
        sbbq	160(%rsi), %rdx
        movq	168(%rdi), %rcx
        movq	%rdx, 160(%rdi)
        sbbq	168(%rsi), %rcx
        movq	176(%rdi), %rdx
        movq	%rcx, 168(%rdi)
        sbbq	176(%rsi), %rdx
        movq	184(%rdi), %rcx
        movq	%rdx, 176(%rdi)
        sbbq	184(%rsi), %rcx
        movq	192(%rdi), %rdx
        movq	%rcx, 184(%rdi)
        sbbq	192(%rsi), %rdx
        movq	200(%rdi), %rcx
        movq	%rdx, 192(%rdi)
        sbbq	200(%rsi), %rcx
        movq	208(%rdi), %rdx
        movq	%rcx, 200(%rdi)
        sbbq	208(%rsi), %rdx
        movq	216(%rdi), %rcx
        movq	%rdx, 208(%rdi)
        sbbq	216(%rsi), %rcx
        movq	224(%rdi), %rdx
        movq	%rcx, 216(%rdi)
        sbbq	224(%rsi), %rdx
        movq	232(%rdi), %rcx
        movq	%rdx, 224(%rdi)
        sbbq	232(%rsi), %rcx
        movq	240(%rdi), %rdx
        movq	%rcx, 232(%rdi)
        sbbq	240(%rsi), %rdx
        movq	248(%rdi), %rcx
        movq	%rdx, 240(%rdi)
        sbbq	248(%rsi), %rcx
        movq	%rcx, 248(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_sub_in_place_32,.-sp_2048_sub_in_place_32
#endif /* __APPLE__ */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_add_32
.type	sp_2048_add_32,@function
.align	16
sp_2048_add_32:
#else
.globl	_sp_2048_add_32
.p2align	4
_sp_2048_add_32:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        adcq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        adcq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        adcq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        adcq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        adcq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        adcq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        adcq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        adcq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        adcq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        adcq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        adcq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        adcq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        adcq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        adcq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        adcq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        adcq	248(%rdx), %r8
        movq	%r8, 248(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_add_32,.-sp_2048_add_32
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_32
.type	sp_2048_mul_32,@function
.align	16
sp_2048_mul_32:
#else
.globl	_sp_2048_mul_32
.p2align	4
_sp_2048_mul_32:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$808, %rsp
        movq	%rdi, 768(%rsp)
        movq	%rsi, 776(%rsp)
        movq	%rdx, 784(%rsp)
        leaq	512(%rsp), %r10
        leaq	128(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r10)
        adcq	$0, %r13
        movq	%r13, 792(%rsp)
        leaq	640(%rsp), %r11
        leaq	128(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r11)
        adcq	$0, %r14
        movq	%r14, 800(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_16@plt
#else
        callq	_sp_2048_mul_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        leaq	256(%rsp), %rdi
        addq	$128, %rdx
        addq	$128, %rsi
#ifndef __APPLE__
        callq	sp_2048_mul_16@plt
#else
        callq	_sp_2048_mul_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        movq	768(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_16@plt
#else
        callq	_sp_2048_mul_16
#endif /* __APPLE__ */
        movq	792(%rsp), %r13
        movq	800(%rsp), %r14
        movq	768(%rsp), %r15
        movq	%r13, %r9
        leaq	512(%rsp), %r10
        leaq	640(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$256, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, (%r10)
        movq	%rcx, (%r11)
        movq	8(%r10), %rax
        movq	8(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 8(%r10)
        movq	%rcx, 8(%r11)
        movq	16(%r10), %rax
        movq	16(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 16(%r10)
        movq	%rcx, 16(%r11)
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 24(%r10)
        movq	%rcx, 24(%r11)
        movq	32(%r10), %rax
        movq	32(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 32(%r10)
        movq	%rcx, 32(%r11)
        movq	40(%r10), %rax
        movq	40(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 40(%r10)
        movq	%rcx, 40(%r11)
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 48(%r10)
        movq	%rcx, 48(%r11)
        movq	56(%r10), %rax
        movq	56(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 56(%r10)
        movq	%rcx, 56(%r11)
        movq	64(%r10), %rax
        movq	64(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 64(%r10)
        movq	%rcx, 64(%r11)
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 72(%r10)
        movq	%rcx, 72(%r11)
        movq	80(%r10), %rax
        movq	80(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 80(%r10)
        movq	%rcx, 80(%r11)
        movq	88(%r10), %rax
        movq	88(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 88(%r10)
        movq	%rcx, 88(%r11)
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 96(%r10)
        movq	%rcx, 96(%r11)
        movq	104(%r10), %rax
        movq	104(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 104(%r10)
        movq	%rcx, 104(%r11)
        movq	112(%r10), %rax
        movq	112(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 112(%r10)
        movq	%rcx, 112(%r11)
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 120(%r10)
        movq	%rcx, 120(%r11)
        movq	(%r10), %rax
        addq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	%rax, 120(%r15)
        adcq	$0, %r9
        leaq	256(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0, %r9
        subq	$128, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	%rcx, 248(%r15)
        adcq	$0, %r9
        movq	%r9, 384(%rdi)
        addq	$128, %r15
        # Add
        movq	(%r15), %rax
        xorq	%r9, %r9
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	%rcx, 128(%r15)
        adcq	$0, %r9
        # Add to zero
        movq	136(%r11), %rax
        adcq	$0, %rax
        movq	144(%r11), %rcx
        movq	%rax, 136(%r15)
        adcq	$0, %rcx
        movq	152(%r11), %r8
        movq	%rcx, 144(%r15)
        adcq	$0, %r8
        movq	160(%r11), %rax
        movq	%r8, 152(%r15)
        adcq	$0, %rax
        movq	168(%r11), %rcx
        movq	%rax, 160(%r15)
        adcq	$0, %rcx
        movq	176(%r11), %r8
        movq	%rcx, 168(%r15)
        adcq	$0, %r8
        movq	184(%r11), %rax
        movq	%r8, 176(%r15)
        adcq	$0, %rax
        movq	192(%r11), %rcx
        movq	%rax, 184(%r15)
        adcq	$0, %rcx
        movq	200(%r11), %r8
        movq	%rcx, 192(%r15)
        adcq	$0, %r8
        movq	208(%r11), %rax
        movq	%r8, 200(%r15)
        adcq	$0, %rax
        movq	216(%r11), %rcx
        movq	%rax, 208(%r15)
        adcq	$0, %rcx
        movq	224(%r11), %r8
        movq	%rcx, 216(%r15)
        adcq	$0, %r8
        movq	232(%r11), %rax
        movq	%r8, 224(%r15)
        adcq	$0, %rax
        movq	240(%r11), %rcx
        movq	%rax, 232(%r15)
        adcq	$0, %rcx
        movq	248(%r11), %r8
        movq	%rcx, 240(%r15)
        adcq	$0, %r8
        movq	%r8, 248(%r15)
        addq	$808, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_32,.-sp_2048_mul_32
#endif /* __APPLE__ */
/* Add a to a into r. (r = a + a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_dbl_16
.type	sp_2048_dbl_16,@function
.align	16
sp_2048_dbl_16:
#else
.globl	_sp_2048_dbl_16
.p2align	4
_sp_2048_dbl_16:
#endif /* __APPLE__ */
        movq	(%rsi), %rdx
        xorq	%rax, %rax
        addq	%rdx, %rdx
        movq	8(%rsi), %rcx
        movq	%rdx, (%rdi)
        adcq	%rcx, %rcx
        movq	16(%rsi), %rdx
        movq	%rcx, 8(%rdi)
        adcq	%rdx, %rdx
        movq	24(%rsi), %rcx
        movq	%rdx, 16(%rdi)
        adcq	%rcx, %rcx
        movq	32(%rsi), %rdx
        movq	%rcx, 24(%rdi)
        adcq	%rdx, %rdx
        movq	40(%rsi), %rcx
        movq	%rdx, 32(%rdi)
        adcq	%rcx, %rcx
        movq	48(%rsi), %rdx
        movq	%rcx, 40(%rdi)
        adcq	%rdx, %rdx
        movq	56(%rsi), %rcx
        movq	%rdx, 48(%rdi)
        adcq	%rcx, %rcx
        movq	64(%rsi), %rdx
        movq	%rcx, 56(%rdi)
        adcq	%rdx, %rdx
        movq	72(%rsi), %rcx
        movq	%rdx, 64(%rdi)
        adcq	%rcx, %rcx
        movq	80(%rsi), %rdx
        movq	%rcx, 72(%rdi)
        adcq	%rdx, %rdx
        movq	88(%rsi), %rcx
        movq	%rdx, 80(%rdi)
        adcq	%rcx, %rcx
        movq	96(%rsi), %rdx
        movq	%rcx, 88(%rdi)
        adcq	%rdx, %rdx
        movq	104(%rsi), %rcx
        movq	%rdx, 96(%rdi)
        adcq	%rcx, %rcx
        movq	112(%rsi), %rdx
        movq	%rcx, 104(%rdi)
        adcq	%rdx, %rdx
        movq	120(%rsi), %rcx
        movq	%rdx, 112(%rdi)
        adcq	%rcx, %rcx
        movq	%rcx, 120(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_dbl_16,.-sp_2048_dbl_16
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_sqr_32
.type	sp_2048_sqr_32,@function
.align	16
sp_2048_sqr_32:
#else
.globl	_sp_2048_sqr_32
.p2align	4
_sp_2048_sqr_32:
#endif /* __APPLE__ */
        subq	$664, %rsp
        movq	%rdi, 640(%rsp)
        movq	%rsi, 648(%rsp)
        leaq	512(%rsp), %r8
        leaq	128(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        adcq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        adcq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        adcq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        adcq	120(%r9), %rax
        movq	%rax, 120(%r8)
        adcq	$0, %rcx
        movq	%rcx, 656(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_16@plt
#else
        callq	_sp_2048_sqr_16
#endif /* __APPLE__ */
        movq	648(%rsp), %rsi
        leaq	256(%rsp), %rdi
        addq	$128, %rsi
#ifndef __APPLE__
        callq	sp_2048_sqr_16@plt
#else
        callq	_sp_2048_sqr_16
#endif /* __APPLE__ */
        movq	648(%rsp), %rsi
        movq	640(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_16@plt
#else
        callq	_sp_2048_sqr_16
#endif /* __APPLE__ */
        movq	656(%rsp), %r10
        leaq	512(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        movq	(%r8), %rdx
        movq	8(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 256(%rdi)
        movq	%rax, 264(%rdi)
        movq	16(%r8), %rdx
        movq	24(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 272(%rdi)
        movq	%rax, 280(%rdi)
        movq	32(%r8), %rdx
        movq	40(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 288(%rdi)
        movq	%rax, 296(%rdi)
        movq	48(%r8), %rdx
        movq	56(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 304(%rdi)
        movq	%rax, 312(%rdi)
        movq	64(%r8), %rdx
        movq	72(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 320(%rdi)
        movq	%rax, 328(%rdi)
        movq	80(%r8), %rdx
        movq	88(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 336(%rdi)
        movq	%rax, 344(%rdi)
        movq	96(%r8), %rdx
        movq	104(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 352(%rdi)
        movq	%rax, 360(%rdi)
        movq	112(%r8), %rdx
        movq	120(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 368(%rdi)
        movq	%rax, 376(%rdi)
        movq	256(%rdi), %rdx
        addq	%rdx, %rdx
        movq	264(%rdi), %rax
        movq	%rdx, 256(%rdi)
        adcq	%rax, %rax
        movq	272(%rdi), %rdx
        movq	%rax, 264(%rdi)
        adcq	%rdx, %rdx
        movq	280(%rdi), %rax
        movq	%rdx, 272(%rdi)
        adcq	%rax, %rax
        movq	288(%rdi), %rdx
        movq	%rax, 280(%rdi)
        adcq	%rdx, %rdx
        movq	296(%rdi), %rax
        movq	%rdx, 288(%rdi)
        adcq	%rax, %rax
        movq	304(%rdi), %rdx
        movq	%rax, 296(%rdi)
        adcq	%rdx, %rdx
        movq	312(%rdi), %rax
        movq	%rdx, 304(%rdi)
        adcq	%rax, %rax
        movq	320(%rdi), %rdx
        movq	%rax, 312(%rdi)
        adcq	%rdx, %rdx
        movq	328(%rdi), %rax
        movq	%rdx, 320(%rdi)
        adcq	%rax, %rax
        movq	336(%rdi), %rdx
        movq	%rax, 328(%rdi)
        adcq	%rdx, %rdx
        movq	344(%rdi), %rax
        movq	%rdx, 336(%rdi)
        adcq	%rax, %rax
        movq	352(%rdi), %rdx
        movq	%rax, 344(%rdi)
        adcq	%rdx, %rdx
        movq	360(%rdi), %rax
        movq	%rdx, 352(%rdi)
        adcq	%rax, %rax
        movq	368(%rdi), %rdx
        movq	%rax, 360(%rdi)
        adcq	%rdx, %rdx
        movq	376(%rdi), %rax
        movq	%rdx, 368(%rdi)
        adcq	%rax, %rax
        movq	%rax, 376(%rdi)
        adcq	$0, %rcx
        leaq	256(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rsi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rsi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rsi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rsi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rsi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rsi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rsi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rsi), %rax
        movq	%rax, 248(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rdi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rdi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rdi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rdi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rdi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rdi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rdi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rdi), %rax
        movq	%rax, 248(%r8)
        sbbq	$0, %rcx
        # Add in place
        movq	128(%rdi), %rdx
        addq	(%r8), %rdx
        movq	136(%rdi), %rax
        movq	%rdx, 128(%rdi)
        adcq	8(%r8), %rax
        movq	144(%rdi), %rdx
        movq	%rax, 136(%rdi)
        adcq	16(%r8), %rdx
        movq	152(%rdi), %rax
        movq	%rdx, 144(%rdi)
        adcq	24(%r8), %rax
        movq	160(%rdi), %rdx
        movq	%rax, 152(%rdi)
        adcq	32(%r8), %rdx
        movq	168(%rdi), %rax
        movq	%rdx, 160(%rdi)
        adcq	40(%r8), %rax
        movq	176(%rdi), %rdx
        movq	%rax, 168(%rdi)
        adcq	48(%r8), %rdx
        movq	184(%rdi), %rax
        movq	%rdx, 176(%rdi)
        adcq	56(%r8), %rax
        movq	192(%rdi), %rdx
        movq	%rax, 184(%rdi)
        adcq	64(%r8), %rdx
        movq	200(%rdi), %rax
        movq	%rdx, 192(%rdi)
        adcq	72(%r8), %rax
        movq	208(%rdi), %rdx
        movq	%rax, 200(%rdi)
        adcq	80(%r8), %rdx
        movq	216(%rdi), %rax
        movq	%rdx, 208(%rdi)
        adcq	88(%r8), %rax
        movq	224(%rdi), %rdx
        movq	%rax, 216(%rdi)
        adcq	96(%r8), %rdx
        movq	232(%rdi), %rax
        movq	%rdx, 224(%rdi)
        adcq	104(%r8), %rax
        movq	240(%rdi), %rdx
        movq	%rax, 232(%rdi)
        adcq	112(%r8), %rdx
        movq	248(%rdi), %rax
        movq	%rdx, 240(%rdi)
        adcq	120(%r8), %rax
        movq	256(%rdi), %rdx
        movq	%rax, 248(%rdi)
        adcq	128(%r8), %rdx
        movq	264(%rdi), %rax
        movq	%rdx, 256(%rdi)
        adcq	136(%r8), %rax
        movq	272(%rdi), %rdx
        movq	%rax, 264(%rdi)
        adcq	144(%r8), %rdx
        movq	280(%rdi), %rax
        movq	%rdx, 272(%rdi)
        adcq	152(%r8), %rax
        movq	288(%rdi), %rdx
        movq	%rax, 280(%rdi)
        adcq	160(%r8), %rdx
        movq	296(%rdi), %rax
        movq	%rdx, 288(%rdi)
        adcq	168(%r8), %rax
        movq	304(%rdi), %rdx
        movq	%rax, 296(%rdi)
        adcq	176(%r8), %rdx
        movq	312(%rdi), %rax
        movq	%rdx, 304(%rdi)
        adcq	184(%r8), %rax
        movq	320(%rdi), %rdx
        movq	%rax, 312(%rdi)
        adcq	192(%r8), %rdx
        movq	328(%rdi), %rax
        movq	%rdx, 320(%rdi)
        adcq	200(%r8), %rax
        movq	336(%rdi), %rdx
        movq	%rax, 328(%rdi)
        adcq	208(%r8), %rdx
        movq	344(%rdi), %rax
        movq	%rdx, 336(%rdi)
        adcq	216(%r8), %rax
        movq	352(%rdi), %rdx
        movq	%rax, 344(%rdi)
        adcq	224(%r8), %rdx
        movq	360(%rdi), %rax
        movq	%rdx, 352(%rdi)
        adcq	232(%r8), %rax
        movq	368(%rdi), %rdx
        movq	%rax, 360(%rdi)
        adcq	240(%r8), %rdx
        movq	376(%rdi), %rax
        movq	%rdx, 368(%rdi)
        adcq	248(%r8), %rax
        movq	%rax, 376(%rdi)
        adcq	$0, %rcx
        movq	%rcx, 384(%rdi)
        # Add in place
        movq	256(%rdi), %rdx
        xorq	%rcx, %rcx
        addq	(%rsi), %rdx
        movq	264(%rdi), %rax
        movq	%rdx, 256(%rdi)
        adcq	8(%rsi), %rax
        movq	272(%rdi), %rdx
        movq	%rax, 264(%rdi)
        adcq	16(%rsi), %rdx
        movq	280(%rdi), %rax
        movq	%rdx, 272(%rdi)
        adcq	24(%rsi), %rax
        movq	288(%rdi), %rdx
        movq	%rax, 280(%rdi)
        adcq	32(%rsi), %rdx
        movq	296(%rdi), %rax
        movq	%rdx, 288(%rdi)
        adcq	40(%rsi), %rax
        movq	304(%rdi), %rdx
        movq	%rax, 296(%rdi)
        adcq	48(%rsi), %rdx
        movq	312(%rdi), %rax
        movq	%rdx, 304(%rdi)
        adcq	56(%rsi), %rax
        movq	320(%rdi), %rdx
        movq	%rax, 312(%rdi)
        adcq	64(%rsi), %rdx
        movq	328(%rdi), %rax
        movq	%rdx, 320(%rdi)
        adcq	72(%rsi), %rax
        movq	336(%rdi), %rdx
        movq	%rax, 328(%rdi)
        adcq	80(%rsi), %rdx
        movq	344(%rdi), %rax
        movq	%rdx, 336(%rdi)
        adcq	88(%rsi), %rax
        movq	352(%rdi), %rdx
        movq	%rax, 344(%rdi)
        adcq	96(%rsi), %rdx
        movq	360(%rdi), %rax
        movq	%rdx, 352(%rdi)
        adcq	104(%rsi), %rax
        movq	368(%rdi), %rdx
        movq	%rax, 360(%rdi)
        adcq	112(%rsi), %rdx
        movq	376(%rdi), %rax
        movq	%rdx, 368(%rdi)
        adcq	120(%rsi), %rax
        movq	384(%rdi), %rdx
        movq	%rax, 376(%rdi)
        adcq	128(%rsi), %rdx
        movq	%rdx, 384(%rdi)
        adcq	$0, %rcx
        # Add to zero
        movq	136(%rsi), %rdx
        adcq	$0, %rdx
        movq	144(%rsi), %rax
        movq	%rdx, 392(%rdi)
        adcq	$0, %rax
        movq	152(%rsi), %rdx
        movq	%rax, 400(%rdi)
        adcq	$0, %rdx
        movq	160(%rsi), %rax
        movq	%rdx, 408(%rdi)
        adcq	$0, %rax
        movq	168(%rsi), %rdx
        movq	%rax, 416(%rdi)
        adcq	$0, %rdx
        movq	176(%rsi), %rax
        movq	%rdx, 424(%rdi)
        adcq	$0, %rax
        movq	184(%rsi), %rdx
        movq	%rax, 432(%rdi)
        adcq	$0, %rdx
        movq	192(%rsi), %rax
        movq	%rdx, 440(%rdi)
        adcq	$0, %rax
        movq	200(%rsi), %rdx
        movq	%rax, 448(%rdi)
        adcq	$0, %rdx
        movq	208(%rsi), %rax
        movq	%rdx, 456(%rdi)
        adcq	$0, %rax
        movq	216(%rsi), %rdx
        movq	%rax, 464(%rdi)
        adcq	$0, %rdx
        movq	224(%rsi), %rax
        movq	%rdx, 472(%rdi)
        adcq	$0, %rax
        movq	232(%rsi), %rdx
        movq	%rax, 480(%rdi)
        adcq	$0, %rdx
        movq	240(%rsi), %rax
        movq	%rdx, 488(%rdi)
        adcq	$0, %rax
        movq	248(%rsi), %rdx
        movq	%rax, 496(%rdi)
        adcq	$0, %rdx
        movq	%rdx, 504(%rdi)
        addq	$664, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_32,.-sp_2048_sqr_32
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_avx2_32
.type	sp_2048_mul_avx2_32,@function
.align	16
sp_2048_mul_avx2_32:
#else
.globl	_sp_2048_mul_avx2_32
.p2align	4
_sp_2048_mul_avx2_32:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$808, %rsp
        movq	%rdi, 768(%rsp)
        movq	%rsi, 776(%rsp)
        movq	%rdx, 784(%rsp)
        leaq	512(%rsp), %r10
        leaq	128(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r10)
        adcq	$0, %r13
        movq	%r13, 792(%rsp)
        leaq	640(%rsp), %r11
        leaq	128(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	%rax, 120(%r11)
        adcq	$0, %r14
        movq	%r14, 800(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_16@plt
#else
        callq	_sp_2048_mul_avx2_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        leaq	256(%rsp), %rdi
        addq	$128, %rdx
        addq	$128, %rsi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_16@plt
#else
        callq	_sp_2048_mul_avx2_16
#endif /* __APPLE__ */
        movq	784(%rsp), %rdx
        movq	776(%rsp), %rsi
        movq	768(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_16@plt
#else
        callq	_sp_2048_mul_avx2_16
#endif /* __APPLE__ */
        movq	792(%rsp), %r13
        movq	800(%rsp), %r14
        movq	768(%rsp), %r15
        movq	%r13, %r9
        leaq	512(%rsp), %r10
        leaq	640(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$256, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        addq	%rcx, %rax
        movq	8(%r10), %rcx
        movq	8(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, (%r15)
        adcq	%r8, %rcx
        movq	16(%r10), %r8
        movq	16(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 8(%r15)
        adcq	%rax, %r8
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 16(%r15)
        adcq	%rcx, %rax
        movq	32(%r10), %rcx
        movq	32(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 24(%r15)
        adcq	%r8, %rcx
        movq	40(%r10), %r8
        movq	40(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 32(%r15)
        adcq	%rax, %r8
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 40(%r15)
        adcq	%rcx, %rax
        movq	56(%r10), %rcx
        movq	56(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 48(%r15)
        adcq	%r8, %rcx
        movq	64(%r10), %r8
        movq	64(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 56(%r15)
        adcq	%rax, %r8
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 64(%r15)
        adcq	%rcx, %rax
        movq	80(%r10), %rcx
        movq	80(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 72(%r15)
        adcq	%r8, %rcx
        movq	88(%r10), %r8
        movq	88(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 80(%r15)
        adcq	%rax, %r8
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 88(%r15)
        adcq	%rcx, %rax
        movq	104(%r10), %rcx
        movq	104(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 96(%r15)
        adcq	%r8, %rcx
        movq	112(%r10), %r8
        movq	112(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 104(%r15)
        adcq	%rax, %r8
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 112(%r15)
        adcq	%rcx, %rax
        movq	%rax, 120(%r15)
        adcq	$0, %r9
        leaq	256(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	%rcx, 248(%r10)
        sbbq	$0, %r9
        subq	$128, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	%rcx, 248(%r15)
        adcq	$0, %r9
        movq	%r9, 384(%rdi)
        addq	$128, %r15
        # Add
        movq	(%r15), %rax
        xorq	%r9, %r9
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	%rcx, 128(%r15)
        adcq	$0, %r9
        # Add to zero
        movq	136(%r11), %rax
        adcq	$0, %rax
        movq	144(%r11), %rcx
        movq	%rax, 136(%r15)
        adcq	$0, %rcx
        movq	152(%r11), %r8
        movq	%rcx, 144(%r15)
        adcq	$0, %r8
        movq	160(%r11), %rax
        movq	%r8, 152(%r15)
        adcq	$0, %rax
        movq	168(%r11), %rcx
        movq	%rax, 160(%r15)
        adcq	$0, %rcx
        movq	176(%r11), %r8
        movq	%rcx, 168(%r15)
        adcq	$0, %r8
        movq	184(%r11), %rax
        movq	%r8, 176(%r15)
        adcq	$0, %rax
        movq	192(%r11), %rcx
        movq	%rax, 184(%r15)
        adcq	$0, %rcx
        movq	200(%r11), %r8
        movq	%rcx, 192(%r15)
        adcq	$0, %r8
        movq	208(%r11), %rax
        movq	%r8, 200(%r15)
        adcq	$0, %rax
        movq	216(%r11), %rcx
        movq	%rax, 208(%r15)
        adcq	$0, %rcx
        movq	224(%r11), %r8
        movq	%rcx, 216(%r15)
        adcq	$0, %r8
        movq	232(%r11), %rax
        movq	%r8, 224(%r15)
        adcq	$0, %rax
        movq	240(%r11), %rcx
        movq	%rax, 232(%r15)
        adcq	$0, %rcx
        movq	248(%r11), %r8
        movq	%rcx, 240(%r15)
        adcq	$0, %r8
        movq	%r8, 248(%r15)
        addq	$808, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_avx2_32,.-sp_2048_mul_avx2_32
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_sqr_avx2_32
.type	sp_2048_sqr_avx2_32,@function
.align	16
sp_2048_sqr_avx2_32:
#else
.globl	_sp_2048_sqr_avx2_32
.p2align	4
_sp_2048_sqr_avx2_32:
#endif /* __APPLE__ */
        subq	$664, %rsp
        movq	%rdi, 640(%rsp)
        movq	%rsi, 648(%rsp)
        leaq	512(%rsp), %r8
        leaq	128(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        adcq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        adcq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        adcq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        adcq	120(%r9), %rax
        movq	%rax, 120(%r8)
        adcq	$0, %rcx
        movq	%rcx, 656(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_16@plt
#else
        callq	_sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
        movq	648(%rsp), %rsi
        leaq	256(%rsp), %rdi
        addq	$128, %rsi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_16@plt
#else
        callq	_sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
        movq	648(%rsp), %rsi
        movq	640(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_16@plt
#else
        callq	_sp_2048_sqr_avx2_16
#endif /* __APPLE__ */
        movq	656(%rsp), %r10
        leaq	512(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        movq	(%r8), %rdx
        pextq	%r10, %rdx, %rdx
        addq	%rdx, %rdx
        movq	8(%r8), %rax
        movq	%rdx, 256(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	16(%r8), %rdx
        movq	%rax, 264(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	24(%r8), %rax
        movq	%rdx, 272(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	32(%r8), %rdx
        movq	%rax, 280(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	40(%r8), %rax
        movq	%rdx, 288(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	48(%r8), %rdx
        movq	%rax, 296(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	56(%r8), %rax
        movq	%rdx, 304(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	64(%r8), %rdx
        movq	%rax, 312(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	72(%r8), %rax
        movq	%rdx, 320(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	80(%r8), %rdx
        movq	%rax, 328(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	88(%r8), %rax
        movq	%rdx, 336(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	96(%r8), %rdx
        movq	%rax, 344(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	104(%r8), %rax
        movq	%rdx, 352(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	112(%r8), %rdx
        movq	%rax, 360(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	120(%r8), %rax
        movq	%rdx, 368(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	%rax, 376(%rdi)
        adcq	$0, %rcx
        leaq	256(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rsi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rsi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rsi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rsi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rsi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rsi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rsi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rsi), %rax
        movq	%rax, 248(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rdi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rdi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rdi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rdi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rdi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rdi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rdi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rdi), %rax
        movq	%rax, 248(%r8)
        sbbq	$0, %rcx
        # Add in place
        movq	128(%rdi), %rdx
        addq	(%r8), %rdx
        movq	136(%rdi), %rax
        movq	%rdx, 128(%rdi)
        adcq	8(%r8), %rax
        movq	144(%rdi), %rdx
        movq	%rax, 136(%rdi)
        adcq	16(%r8), %rdx
        movq	152(%rdi), %rax
        movq	%rdx, 144(%rdi)
        adcq	24(%r8), %rax
        movq	160(%rdi), %rdx
        movq	%rax, 152(%rdi)
        adcq	32(%r8), %rdx
        movq	168(%rdi), %rax
        movq	%rdx, 160(%rdi)
        adcq	40(%r8), %rax
        movq	176(%rdi), %rdx
        movq	%rax, 168(%rdi)
        adcq	48(%r8), %rdx
        movq	184(%rdi), %rax
        movq	%rdx, 176(%rdi)
        adcq	56(%r8), %rax
        movq	192(%rdi), %rdx
        movq	%rax, 184(%rdi)
        adcq	64(%r8), %rdx
        movq	200(%rdi), %rax
        movq	%rdx, 192(%rdi)
        adcq	72(%r8), %rax
        movq	208(%rdi), %rdx
        movq	%rax, 200(%rdi)
        adcq	80(%r8), %rdx
        movq	216(%rdi), %rax
        movq	%rdx, 208(%rdi)
        adcq	88(%r8), %rax
        movq	224(%rdi), %rdx
        movq	%rax, 216(%rdi)
        adcq	96(%r8), %rdx
        movq	232(%rdi), %rax
        movq	%rdx, 224(%rdi)
        adcq	104(%r8), %rax
        movq	240(%rdi), %rdx
        movq	%rax, 232(%rdi)
        adcq	112(%r8), %rdx
        movq	248(%rdi), %rax
        movq	%rdx, 240(%rdi)
        adcq	120(%r8), %rax
        movq	256(%rdi), %rdx
        movq	%rax, 248(%rdi)
        adcq	128(%r8), %rdx
        movq	264(%rdi), %rax
        movq	%rdx, 256(%rdi)
        adcq	136(%r8), %rax
        movq	272(%rdi), %rdx
        movq	%rax, 264(%rdi)
        adcq	144(%r8), %rdx
        movq	280(%rdi), %rax
        movq	%rdx, 272(%rdi)
        adcq	152(%r8), %rax
        movq	288(%rdi), %rdx
        movq	%rax, 280(%rdi)
        adcq	160(%r8), %rdx
        movq	296(%rdi), %rax
        movq	%rdx, 288(%rdi)
        adcq	168(%r8), %rax
        movq	304(%rdi), %rdx
        movq	%rax, 296(%rdi)
        adcq	176(%r8), %rdx
        movq	312(%rdi), %rax
        movq	%rdx, 304(%rdi)
        adcq	184(%r8), %rax
        movq	320(%rdi), %rdx
        movq	%rax, 312(%rdi)
        adcq	192(%r8), %rdx
        movq	328(%rdi), %rax
        movq	%rdx, 320(%rdi)
        adcq	200(%r8), %rax
        movq	336(%rdi), %rdx
        movq	%rax, 328(%rdi)
        adcq	208(%r8), %rdx
        movq	344(%rdi), %rax
        movq	%rdx, 336(%rdi)
        adcq	216(%r8), %rax
        movq	352(%rdi), %rdx
        movq	%rax, 344(%rdi)
        adcq	224(%r8), %rdx
        movq	360(%rdi), %rax
        movq	%rdx, 352(%rdi)
        adcq	232(%r8), %rax
        movq	368(%rdi), %rdx
        movq	%rax, 360(%rdi)
        adcq	240(%r8), %rdx
        movq	376(%rdi), %rax
        movq	%rdx, 368(%rdi)
        adcq	248(%r8), %rax
        movq	%rax, 376(%rdi)
        adcq	$0, %rcx
        movq	%rcx, 384(%rdi)
        # Add in place
        movq	256(%rdi), %rdx
        xorq	%rcx, %rcx
        addq	(%rsi), %rdx
        movq	264(%rdi), %rax
        movq	%rdx, 256(%rdi)
        adcq	8(%rsi), %rax
        movq	272(%rdi), %rdx
        movq	%rax, 264(%rdi)
        adcq	16(%rsi), %rdx
        movq	280(%rdi), %rax
        movq	%rdx, 272(%rdi)
        adcq	24(%rsi), %rax
        movq	288(%rdi), %rdx
        movq	%rax, 280(%rdi)
        adcq	32(%rsi), %rdx
        movq	296(%rdi), %rax
        movq	%rdx, 288(%rdi)
        adcq	40(%rsi), %rax
        movq	304(%rdi), %rdx
        movq	%rax, 296(%rdi)
        adcq	48(%rsi), %rdx
        movq	312(%rdi), %rax
        movq	%rdx, 304(%rdi)
        adcq	56(%rsi), %rax
        movq	320(%rdi), %rdx
        movq	%rax, 312(%rdi)
        adcq	64(%rsi), %rdx
        movq	328(%rdi), %rax
        movq	%rdx, 320(%rdi)
        adcq	72(%rsi), %rax
        movq	336(%rdi), %rdx
        movq	%rax, 328(%rdi)
        adcq	80(%rsi), %rdx
        movq	344(%rdi), %rax
        movq	%rdx, 336(%rdi)
        adcq	88(%rsi), %rax
        movq	352(%rdi), %rdx
        movq	%rax, 344(%rdi)
        adcq	96(%rsi), %rdx
        movq	360(%rdi), %rax
        movq	%rdx, 352(%rdi)
        adcq	104(%rsi), %rax
        movq	368(%rdi), %rdx
        movq	%rax, 360(%rdi)
        adcq	112(%rsi), %rdx
        movq	376(%rdi), %rax
        movq	%rdx, 368(%rdi)
        adcq	120(%rsi), %rax
        movq	384(%rdi), %rdx
        movq	%rax, 376(%rdi)
        adcq	128(%rsi), %rdx
        movq	%rdx, 384(%rdi)
        adcq	$0, %rcx
        # Add to zero
        movq	136(%rsi), %rdx
        adcq	$0, %rdx
        movq	144(%rsi), %rax
        movq	%rdx, 392(%rdi)
        adcq	$0, %rax
        movq	152(%rsi), %rdx
        movq	%rax, 400(%rdi)
        adcq	$0, %rdx
        movq	160(%rsi), %rax
        movq	%rdx, 408(%rdi)
        adcq	$0, %rax
        movq	168(%rsi), %rdx
        movq	%rax, 416(%rdi)
        adcq	$0, %rdx
        movq	176(%rsi), %rax
        movq	%rdx, 424(%rdi)
        adcq	$0, %rax
        movq	184(%rsi), %rdx
        movq	%rax, 432(%rdi)
        adcq	$0, %rdx
        movq	192(%rsi), %rax
        movq	%rdx, 440(%rdi)
        adcq	$0, %rax
        movq	200(%rsi), %rdx
        movq	%rax, 448(%rdi)
        adcq	$0, %rdx
        movq	208(%rsi), %rax
        movq	%rdx, 456(%rdi)
        adcq	$0, %rax
        movq	216(%rsi), %rdx
        movq	%rax, 464(%rdi)
        adcq	$0, %rdx
        movq	224(%rsi), %rax
        movq	%rdx, 472(%rdi)
        adcq	$0, %rax
        movq	232(%rsi), %rdx
        movq	%rax, 480(%rdi)
        adcq	$0, %rdx
        movq	240(%rsi), %rax
        movq	%rdx, 488(%rdi)
        adcq	$0, %rax
        movq	248(%rsi), %rdx
        movq	%rax, 496(%rdi)
        adcq	$0, %rdx
        movq	%rdx, 504(%rdi)
        addq	$664, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_sqr_avx2_32,.-sp_2048_sqr_avx2_32
#endif /* __APPLE__ */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_d_32
.type	sp_2048_mul_d_32,@function
.align	16
sp_2048_mul_d_32:
#else
.globl	_sp_2048_mul_d_32
.p2align	4
_sp_2048_mul_d_32:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	120(%rsi)
        addq	%rax, %r8
        movq	%r8, 120(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[16] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	128(%rsi)
        addq	%rax, %r9
        movq	%r9, 128(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[17] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        addq	%rax, %r10
        movq	%r10, 136(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[18] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        addq	%rax, %r8
        movq	%r8, 144(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[19] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	152(%rsi)
        addq	%rax, %r9
        movq	%r9, 152(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[20] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	160(%rsi)
        addq	%rax, %r10
        movq	%r10, 160(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[21] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	168(%rsi)
        addq	%rax, %r8
        movq	%r8, 168(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[22] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	176(%rsi)
        addq	%rax, %r9
        movq	%r9, 176(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[23] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        addq	%rax, %r10
        movq	%r10, 184(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[24] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        addq	%rax, %r8
        movq	%r8, 192(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[25] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	200(%rsi)
        addq	%rax, %r9
        movq	%r9, 200(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[26] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	208(%rsi)
        addq	%rax, %r10
        movq	%r10, 208(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[27] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	216(%rsi)
        addq	%rax, %r8
        movq	%r8, 216(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[28] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	224(%rsi)
        addq	%rax, %r9
        movq	%r9, 224(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[29] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        addq	%rax, %r10
        movq	%r10, 232(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[30] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        addq	%rax, %r8
        movq	%r8, 240(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[31] * B
        movq	%rcx, %rax
        mulq	248(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        movq	%r9, 248(%rdi)
        movq	%r10, 256(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_32,.-sp_2048_mul_d_32
#endif /* __APPLE__ */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_sub_in_place_16
.type	sp_2048_sub_in_place_16,@function
.align	16
sp_2048_sub_in_place_16:
#else
.globl	_sp_2048_sub_in_place_16
.p2align	4
_sp_2048_sub_in_place_16:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        xorq	%rax, %rax
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	%rcx, 120(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_sub_in_place_16,.-sp_2048_sub_in_place_16
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_2048_cond_sub_16
.type	sp_2048_cond_sub_16,@function
.align	16
sp_2048_cond_sub_16:
#else
.globl	_sp_2048_cond_sub_16
.p2align	4
_sp_2048_cond_sub_16:
#endif /* __APPLE__ */
        subq	$128, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        sbbq	$0, %rax
        addq	$128, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_16,.-sp_2048_cond_sub_16
#endif /* __APPLE__ */
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_2048_mont_reduce_16
.type	sp_2048_mont_reduce_16,@function
.align	16
sp_2048_mont_reduce_16:
#else
.globl	_sp_2048_mont_reduce_16
.p2align	4
_sp_2048_mont_reduce_16:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 16
        movq	$16, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_mont_loop_16:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0, %r15
        adcq	$0, %r15
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	%rdx, 128(%rdi)
        adcq	$0, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_mont_loop_16
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
        movq	%r15, %rcx
        movq	%rsi, %rdx
        movq	%rdi, %rsi
        subq	$128, %rdi
#ifndef __APPLE__
        callq	sp_2048_cond_sub_16@plt
#else
        callq	_sp_2048_cond_sub_16
#endif /* __APPLE__ */
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_16,.-sp_2048_mont_reduce_16
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_2048_cond_sub_avx2_16
.type	sp_2048_cond_sub_avx2_16,@function
.align	16
sp_2048_cond_sub_avx2_16:
#else
.globl	_sp_2048_cond_sub_avx2_16
.p2align	4
_sp_2048_cond_sub_avx2_16:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	%r8, 120(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_avx2_16,.-sp_2048_cond_sub_avx2_16
#endif /* __APPLE__ */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_d_16
.type	sp_2048_mul_d_16,@function
.align	16
sp_2048_mul_d_16:
#else
.globl	_sp_2048_mul_d_16
.p2align	4
_sp_2048_mul_d_16:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B
        movq	%rcx, %rax
        mulq	120(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        movq	%r8, 120(%rdi)
        movq	%r9, 128(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_16,.-sp_2048_mul_d_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_d_avx2_16
.type	sp_2048_mul_d_avx2_16,@function
.align	16
sp_2048_mul_d_avx2_16:
#else
.globl	_sp_2048_mul_d_avx2_16
.p2align	4
_sp_2048_mul_d_avx2_16:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 8(%rdi)
        adoxq	%r8, %r9
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 16(%rdi)
        adoxq	%r8, %r10
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 24(%rdi)
        adoxq	%r8, %r9
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 32(%rdi)
        adoxq	%r8, %r10
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 40(%rdi)
        adoxq	%r8, %r9
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 48(%rdi)
        adoxq	%r8, %r10
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 56(%rdi)
        adoxq	%r8, %r9
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 64(%rdi)
        adoxq	%r8, %r10
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 72(%rdi)
        adoxq	%r8, %r9
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 80(%rdi)
        adoxq	%r8, %r10
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 88(%rdi)
        adoxq	%r8, %r9
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 96(%rdi)
        adoxq	%r8, %r10
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 104(%rdi)
        adoxq	%r8, %r9
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 112(%rdi)
        adoxq	%r8, %r10
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 120(%rdi)
        movq	%r9, 128(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_avx2_16,.-sp_2048_mul_d_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.globl	sp_2048_cmp_16
.type	sp_2048_cmp_16,@function
.align	16
sp_2048_cmp_16:
#else
.globl	_sp_2048_cmp_16
.p2align	4
_sp_2048_cmp_16:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$1, %r8
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cmp_16,.-sp_2048_cmp_16
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_2048_mont_reduce_avx2_16
.type	sp_2048_mont_reduce_avx2_16,@function
.align	16
sp_2048_mont_reduce_avx2_16:
#else
.globl	_sp_2048_mont_reduce_avx2_16
.p2align	4
_sp_2048_mont_reduce_avx2_16:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        movq	%rdx, %r8
        xorq	%r14, %r14
        # i = 16
        movq	$16, %r9
        movq	(%rdi), %r13
        addq	$64, %rdi
        xorq	%r12, %r12
L_mont_loop_avx2_16:
        # mu = a[i] * mp
        movq	%r13, %rdx
        movq	%r13, %r10
        imulq	%r8, %rdx
        xorq	%r12, %r12
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	-56(%rdi), %r13
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	-48(%rdi), %r10
        adcxq	%rax, %r13
        adoxq	%rcx, %r10
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	-40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -48(%rdi)
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -40(%rdi)
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -32(%rdi)
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        adcxq	%r14, %r10
        movq	%r10, 64(%rdi)
        movq	%r12, %r14
        adoxq	%r12, %r14
        adcxq	%r12, %r14
        # mu = a[i] * mp
        movq	%r13, %rdx
        movq	%r13, %r10
        imulq	%r8, %rdx
        xorq	%r12, %r12
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	-48(%rdi), %r13
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	-40(%rdi), %r10
        adcxq	%rax, %r13
        adoxq	%rcx, %r10
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	-32(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -40(%rdi)
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-24(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -32(%rdi)
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-16(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -24(%rdi)
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-8(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -16(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -8(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	8(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, (%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	16(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 8(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	24(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 16(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	32(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 24(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	40(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 32(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	48(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 40(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	56(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 48(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	64(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 56(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	72(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 64(%rdi)
        adcxq	%r14, %r10
        movq	%r10, 72(%rdi)
        movq	%r12, %r14
        adoxq	%r12, %r14
        adcxq	%r12, %r14
        # a += 2
        addq	$16, %rdi
        # i -= 2
        subq	$2, %r9
        jnz	L_mont_loop_avx2_16
        subq	$64, %rdi
        negq	%r14
        movq	%rdi, %r8
        subq	$128, %rdi
        movq	(%rsi), %rcx
        movq	%r13, %rdx
        pextq	%r14, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	8(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	16(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	24(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	%rdx, 120(%rdi)
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_avx2_16,.-sp_2048_mont_reduce_avx2_16
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_2048_cond_sub_32
.type	sp_2048_cond_sub_32,@function
.align	16
sp_2048_cond_sub_32:
#else
.globl	_sp_2048_cond_sub_32
.p2align	4
_sp_2048_cond_sub_32:
#endif /* __APPLE__ */
        subq	$256, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	192(%rdx), %r8
        movq	200(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 192(%rsp)
        movq	%r9, 200(%rsp)
        movq	208(%rdx), %r8
        movq	216(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 208(%rsp)
        movq	%r9, 216(%rsp)
        movq	224(%rdx), %r8
        movq	232(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 224(%rsp)
        movq	%r9, 232(%rsp)
        movq	240(%rdx), %r8
        movq	248(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 240(%rsp)
        movq	%r9, 248(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	192(%rsi), %r8
        movq	192(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 184(%rdi)
        movq	200(%rsi), %r9
        movq	200(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 192(%rdi)
        movq	208(%rsi), %r8
        movq	208(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 200(%rdi)
        movq	216(%rsi), %r9
        movq	216(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 208(%rdi)
        movq	224(%rsi), %r8
        movq	224(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 216(%rdi)
        movq	232(%rsi), %r9
        movq	232(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 224(%rdi)
        movq	240(%rsi), %r8
        movq	240(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 232(%rdi)
        movq	248(%rsi), %r9
        movq	248(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        sbbq	$0, %rax
        addq	$256, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_32,.-sp_2048_cond_sub_32
#endif /* __APPLE__ */
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_2048_mont_reduce_32
.type	sp_2048_mont_reduce_32,@function
.align	16
sp_2048_mont_reduce_32:
#else
.globl	_sp_2048_mont_reduce_32
.p2align	4
_sp_2048_mont_reduce_32:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 32
        movq	$32, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_mont_loop_32:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	$0, %r9
        # a[i+16] += m[16] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	128(%rsi)
        movq	128(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 128(%rdi)
        adcq	$0, %r10
        # a[i+17] += m[17] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        movq	136(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 136(%rdi)
        adcq	$0, %r9
        # a[i+18] += m[18] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        movq	144(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 144(%rdi)
        adcq	$0, %r10
        # a[i+19] += m[19] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	152(%rsi)
        movq	152(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 152(%rdi)
        adcq	$0, %r9
        # a[i+20] += m[20] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	160(%rsi)
        movq	160(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 160(%rdi)
        adcq	$0, %r10
        # a[i+21] += m[21] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	168(%rsi)
        movq	168(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 168(%rdi)
        adcq	$0, %r9
        # a[i+22] += m[22] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	176(%rsi)
        movq	176(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 176(%rdi)
        adcq	$0, %r10
        # a[i+23] += m[23] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        movq	184(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 184(%rdi)
        adcq	$0, %r9
        # a[i+24] += m[24] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        movq	192(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 192(%rdi)
        adcq	$0, %r10
        # a[i+25] += m[25] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	200(%rsi)
        movq	200(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 200(%rdi)
        adcq	$0, %r9
        # a[i+26] += m[26] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	208(%rsi)
        movq	208(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 208(%rdi)
        adcq	$0, %r10
        # a[i+27] += m[27] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	216(%rsi)
        movq	216(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 216(%rdi)
        adcq	$0, %r9
        # a[i+28] += m[28] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	224(%rsi)
        movq	224(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 224(%rdi)
        adcq	$0, %r10
        # a[i+29] += m[29] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        movq	232(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 232(%rdi)
        adcq	$0, %r9
        # a[i+30] += m[30] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        movq	240(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 240(%rdi)
        adcq	$0, %r10
        # a[i+31] += m[31] * mu
        movq	%r11, %rax
        mulq	248(%rsi)
        movq	248(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0, %r15
        adcq	$0, %r15
        addq	%r10, %r12
        movq	%r12, 248(%rdi)
        adcq	%rdx, 256(%rdi)
        adcq	$0, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_mont_loop_32
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
        movq	%r15, %rcx
        movq	%rsi, %rdx
        movq	%rdi, %rsi
        subq	$256, %rdi
#ifndef __APPLE__
        callq	sp_2048_cond_sub_32@plt
#else
        callq	_sp_2048_cond_sub_32
#endif /* __APPLE__ */
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_32,.-sp_2048_mont_reduce_32
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_2048_cond_sub_avx2_32
.type	sp_2048_cond_sub_avx2_32,@function
.align	16
sp_2048_cond_sub_avx2_32:
#else
.globl	_sp_2048_cond_sub_avx2_32
.p2align	4
_sp_2048_cond_sub_avx2_32:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        sbbq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        sbbq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        sbbq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        sbbq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        sbbq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        sbbq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        sbbq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        sbbq	%r8, %r10
        movq	192(%rdx), %r9
        movq	192(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 184(%rdi)
        sbbq	%r9, %r8
        movq	200(%rdx), %r10
        movq	200(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 192(%rdi)
        sbbq	%r10, %r9
        movq	208(%rdx), %r8
        movq	208(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 200(%rdi)
        sbbq	%r8, %r10
        movq	216(%rdx), %r9
        movq	216(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 208(%rdi)
        sbbq	%r9, %r8
        movq	224(%rdx), %r10
        movq	224(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 216(%rdi)
        sbbq	%r10, %r9
        movq	232(%rdx), %r8
        movq	232(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 224(%rdi)
        sbbq	%r8, %r10
        movq	240(%rdx), %r9
        movq	240(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 232(%rdi)
        sbbq	%r9, %r8
        movq	248(%rdx), %r10
        movq	248(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 240(%rdi)
        sbbq	%r10, %r9
        movq	%r9, 248(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_sub_avx2_32,.-sp_2048_cond_sub_avx2_32
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_2048_mul_d_avx2_32
.type	sp_2048_mul_d_avx2_32,@function
.align	16
sp_2048_mul_d_avx2_32:
#else
.globl	_sp_2048_mul_d_avx2_32
.p2align	4
_sp_2048_mul_d_avx2_32:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 8(%rdi)
        adoxq	%r8, %r9
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 16(%rdi)
        adoxq	%r8, %r10
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 24(%rdi)
        adoxq	%r8, %r9
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 32(%rdi)
        adoxq	%r8, %r10
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 40(%rdi)
        adoxq	%r8, %r9
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 48(%rdi)
        adoxq	%r8, %r10
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 56(%rdi)
        adoxq	%r8, %r9
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 64(%rdi)
        adoxq	%r8, %r10
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 72(%rdi)
        adoxq	%r8, %r9
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 80(%rdi)
        adoxq	%r8, %r10
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 88(%rdi)
        adoxq	%r8, %r9
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 96(%rdi)
        adoxq	%r8, %r10
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 104(%rdi)
        adoxq	%r8, %r9
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 112(%rdi)
        adoxq	%r8, %r10
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 120(%rdi)
        adoxq	%r8, %r9
        # A[16] * B
        mulxq	128(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 128(%rdi)
        adoxq	%r8, %r10
        # A[17] * B
        mulxq	136(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 136(%rdi)
        adoxq	%r8, %r9
        # A[18] * B
        mulxq	144(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 144(%rdi)
        adoxq	%r8, %r10
        # A[19] * B
        mulxq	152(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 152(%rdi)
        adoxq	%r8, %r9
        # A[20] * B
        mulxq	160(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 160(%rdi)
        adoxq	%r8, %r10
        # A[21] * B
        mulxq	168(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 168(%rdi)
        adoxq	%r8, %r9
        # A[22] * B
        mulxq	176(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 176(%rdi)
        adoxq	%r8, %r10
        # A[23] * B
        mulxq	184(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 184(%rdi)
        adoxq	%r8, %r9
        # A[24] * B
        mulxq	192(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 192(%rdi)
        adoxq	%r8, %r10
        # A[25] * B
        mulxq	200(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 200(%rdi)
        adoxq	%r8, %r9
        # A[26] * B
        mulxq	208(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 208(%rdi)
        adoxq	%r8, %r10
        # A[27] * B
        mulxq	216(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 216(%rdi)
        adoxq	%r8, %r9
        # A[28] * B
        mulxq	224(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 224(%rdi)
        adoxq	%r8, %r10
        # A[29] * B
        mulxq	232(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 232(%rdi)
        adoxq	%r8, %r9
        # A[30] * B
        mulxq	240(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 240(%rdi)
        adoxq	%r8, %r10
        # A[31] * B
        mulxq	248(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 248(%rdi)
        movq	%r9, 256(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_2048_mul_d_avx2_32,.-sp_2048_mul_d_avx2_32
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.globl	sp_2048_cmp_32
.type	sp_2048_cmp_32,@function
.align	16
sp_2048_cmp_32:
#else
.globl	_sp_2048_cmp_32
.p2align	4
_sp_2048_cmp_32:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$1, %r8
        movq	248(%rdi), %r9
        movq	248(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	240(%rdi), %r9
        movq	240(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	232(%rdi), %r9
        movq	232(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	224(%rdi), %r9
        movq	224(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	216(%rdi), %r9
        movq	216(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	208(%rdi), %r9
        movq	208(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	200(%rdi), %r9
        movq	200(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	192(%rdi), %r9
        movq	192(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	184(%rdi), %r9
        movq	184(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	176(%rdi), %r9
        movq	176(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	168(%rdi), %r9
        movq	168(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	160(%rdi), %r9
        movq	160(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	152(%rdi), %r9
        movq	152(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	144(%rdi), %r9
        movq	144(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	136(%rdi), %r9
        movq	136(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	128(%rdi), %r9
        movq	128(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cmp_32,.-sp_2048_cmp_32
#endif /* __APPLE__ */
/* Sub b from a into r. (r = a - b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_sub_32
.type	sp_2048_sub_32,@function
.align	16
sp_2048_sub_32:
#else
.globl	_sp_2048_sub_32
.p2align	4
_sp_2048_sub_32:
#endif /* __APPLE__ */
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        subq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        sbbq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        sbbq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        sbbq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        sbbq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        sbbq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        sbbq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        sbbq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        sbbq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        sbbq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        sbbq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        sbbq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        sbbq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        sbbq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        sbbq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        sbbq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        sbbq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        sbbq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        sbbq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        sbbq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        sbbq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        sbbq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        sbbq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        sbbq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        sbbq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        sbbq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        sbbq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        sbbq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        sbbq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        sbbq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        sbbq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        sbbq	248(%rdx), %r8
        movq	%r8, 248(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_sub_32,.-sp_2048_sub_32
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 2048 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_2048_mont_reduce_avx2_32
.type	sp_2048_mont_reduce_avx2_32,@function
.align	16
sp_2048_mont_reduce_avx2_32:
#else
.globl	_sp_2048_mont_reduce_avx2_32
.p2align	4
_sp_2048_mont_reduce_avx2_32:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        movq	%rdx, %r8
        xorq	%r14, %r14
        # i = 32
        movq	$32, %r9
        movq	(%rdi), %r13
        addq	$128, %rdi
        xorq	%r12, %r12
L_mont_loop_avx2_32:
        # mu = a[i] * mp
        movq	%r13, %rdx
        movq	%r13, %r10
        imulq	%r8, %rdx
        xorq	%r12, %r12
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	-120(%rdi), %r13
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	-112(%rdi), %r10
        adcxq	%rax, %r13
        adoxq	%rcx, %r10
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	-104(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -112(%rdi)
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -104(%rdi)
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -96(%rdi)
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -88(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -80(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	-64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -72(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	-56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -64(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	-48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -56(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	-40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -48(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	-32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -40(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -32(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+16] += m[16] * mu
        mulxq	128(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+17] += m[17] * mu
        mulxq	136(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+18] += m[18] * mu
        mulxq	144(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+19] += m[19] * mu
        mulxq	152(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+20] += m[20] * mu
        mulxq	160(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+21] += m[21] * mu
        mulxq	168(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+22] += m[22] * mu
        mulxq	176(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+23] += m[23] * mu
        mulxq	184(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        # a[i+24] += m[24] * mu
        mulxq	192(%rsi), %rax, %rcx
        movq	72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 64(%rdi)
        # a[i+25] += m[25] * mu
        mulxq	200(%rsi), %rax, %rcx
        movq	80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 72(%rdi)
        # a[i+26] += m[26] * mu
        mulxq	208(%rsi), %rax, %rcx
        movq	88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 80(%rdi)
        # a[i+27] += m[27] * mu
        mulxq	216(%rsi), %rax, %rcx
        movq	96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 88(%rdi)
        # a[i+28] += m[28] * mu
        mulxq	224(%rsi), %rax, %rcx
        movq	104(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rdi)
        # a[i+29] += m[29] * mu
        mulxq	232(%rsi), %rax, %rcx
        movq	112(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 104(%rdi)
        # a[i+30] += m[30] * mu
        mulxq	240(%rsi), %rax, %rcx
        movq	120(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 112(%rdi)
        # a[i+31] += m[31] * mu
        mulxq	248(%rsi), %rax, %rcx
        movq	128(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 120(%rdi)
        adcxq	%r14, %r10
        movq	%r10, 128(%rdi)
        movq	%r12, %r14
        adoxq	%r12, %r14
        adcxq	%r12, %r14
        # a += 1
        addq	$8, %rdi
        # i -= 1
        subq	$1, %r9
        jnz	L_mont_loop_avx2_32
        subq	$128, %rdi
        negq	%r14
        movq	%rdi, %r8
        subq	$256, %rdi
        movq	(%rsi), %rcx
        movq	%r13, %rdx
        pextq	%r14, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	8(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	16(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	24(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	128(%rsi), %rcx
        movq	128(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 120(%rdi)
        sbbq	%rcx, %rax
        movq	136(%rsi), %rdx
        movq	136(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 128(%rdi)
        sbbq	%rdx, %rcx
        movq	144(%rsi), %rax
        movq	144(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 136(%rdi)
        sbbq	%rax, %rdx
        movq	152(%rsi), %rcx
        movq	152(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 144(%rdi)
        sbbq	%rcx, %rax
        movq	160(%rsi), %rdx
        movq	160(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 152(%rdi)
        sbbq	%rdx, %rcx
        movq	168(%rsi), %rax
        movq	168(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 160(%rdi)
        sbbq	%rax, %rdx
        movq	176(%rsi), %rcx
        movq	176(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 168(%rdi)
        sbbq	%rcx, %rax
        movq	184(%rsi), %rdx
        movq	184(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 176(%rdi)
        sbbq	%rdx, %rcx
        movq	192(%rsi), %rax
        movq	192(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 184(%rdi)
        sbbq	%rax, %rdx
        movq	200(%rsi), %rcx
        movq	200(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 192(%rdi)
        sbbq	%rcx, %rax
        movq	208(%rsi), %rdx
        movq	208(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 200(%rdi)
        sbbq	%rdx, %rcx
        movq	216(%rsi), %rax
        movq	216(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 208(%rdi)
        sbbq	%rax, %rdx
        movq	224(%rsi), %rcx
        movq	224(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 216(%rdi)
        sbbq	%rcx, %rax
        movq	232(%rsi), %rdx
        movq	232(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 224(%rdi)
        sbbq	%rdx, %rcx
        movq	240(%rsi), %rax
        movq	240(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 232(%rdi)
        sbbq	%rax, %rdx
        movq	248(%rsi), %rcx
        movq	248(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 240(%rdi)
        sbbq	%rcx, %rax
        movq	%rax, 248(%rdi)
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_2048_mont_reduce_avx2_32,.-sp_2048_mont_reduce_avx2_32
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_2048_cond_add_16
.type	sp_2048_cond_add_16,@function
.align	16
sp_2048_cond_add_16:
#else
.globl	_sp_2048_cond_add_16
.p2align	4
_sp_2048_cond_add_16:
#endif /* __APPLE__ */
        subq	$128, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        addq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        adcq	$0, %rax
        addq	$128, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_add_16,.-sp_2048_cond_add_16
#endif /* __APPLE__ */
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_2048_cond_add_avx2_16
.type	sp_2048_cond_add_avx2_16,@function
.align	16
sp_2048_cond_add_avx2_16:
#else
.globl	_sp_2048_cond_add_avx2_16
.p2align	4
_sp_2048_cond_add_avx2_16:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        addq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        adcq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        adcq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        adcq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        adcq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        adcq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        adcq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        adcq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        adcq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        adcq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        adcq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        adcq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        adcq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        adcq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        adcq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        adcq	%r9, %r8
        movq	%r8, 120(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_cond_add_avx2_16,.-sp_2048_cond_add_avx2_16
#endif /* __APPLE__ */
/* Shift number left by n bit. (r = a << n)
 *
 * r  Result of left shift by n.
 * a  Number to shift.
 * n  Amoutnt o shift.
 */
#ifndef __APPLE__
.globl	sp_2048_lshift_32
.type	sp_2048_lshift_32,@function
.align	16
sp_2048_lshift_32:
#else
.globl	_sp_2048_lshift_32
.p2align	4
_sp_2048_lshift_32:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        movq	$0, %r10
        movq	216(%rsi), %r11
        movq	224(%rsi), %rdx
        movq	232(%rsi), %rax
        movq	240(%rsi), %r8
        movq	248(%rsi), %r9
        shldq	%cl, %r9, %r10
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 224(%rdi)
        movq	%rax, 232(%rdi)
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        movq	%r10, 256(%rdi)
        movq	184(%rsi), %r9
        movq	192(%rsi), %rdx
        movq	200(%rsi), %rax
        movq	208(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 192(%rdi)
        movq	%rax, 200(%rdi)
        movq	%r8, 208(%rdi)
        movq	%r11, 216(%rdi)
        movq	152(%rsi), %r11
        movq	160(%rsi), %rdx
        movq	168(%rsi), %rax
        movq	176(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 160(%rdi)
        movq	%rax, 168(%rdi)
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        movq	120(%rsi), %r9
        movq	128(%rsi), %rdx
        movq	136(%rsi), %rax
        movq	144(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 128(%rdi)
        movq	%rax, 136(%rdi)
        movq	%r8, 144(%rdi)
        movq	%r11, 152(%rdi)
        movq	88(%rsi), %r11
        movq	96(%rsi), %rdx
        movq	104(%rsi), %rax
        movq	112(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 96(%rdi)
        movq	%rax, 104(%rdi)
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        movq	56(%rsi), %r9
        movq	64(%rsi), %rdx
        movq	72(%rsi), %rax
        movq	80(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 64(%rdi)
        movq	%rax, 72(%rdi)
        movq	%r8, 80(%rdi)
        movq	%r11, 88(%rdi)
        movq	24(%rsi), %r11
        movq	32(%rsi), %rdx
        movq	40(%rsi), %rax
        movq	48(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 32(%rdi)
        movq	%rax, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	(%rsi), %rdx
        movq	8(%rsi), %rax
        movq	16(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shlq	%cl, %rdx
        movq	%rdx, (%rdi)
        movq	%rax, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	%r11, 24(%rdi)
        repz retq
#endif /* !WOLFSSL_SP_NO_2048 */
#endif /* !WOLFSSL_SP_NO_2048 */
#ifndef WOLFSSL_SP_NO_3072
#ifndef WOLFSSL_SP_NO_3072
/* Read big endian unsigned byte array into r.
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.globl	sp_3072_from_bin_bswap
.type	sp_3072_from_bin_bswap,@function
.align	16
sp_3072_from_bin_bswap:
#else
.globl	_sp_3072_from_bin_bswap
.p2align	4
_sp_3072_from_bin_bswap:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$384, %r10
        xorq	%r11, %r11
        jmp	L_3072_from_bin_bswap_64_end
L_3072_from_bin_bswap_64_start:
        subq	$64, %r9
        movq	56(%r9), %rax
        movq	48(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movq	40(%r9), %rax
        movq	32(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movq	24(%r9), %rax
        movq	16(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movq	8(%r9), %rax
        movq	(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$64, %rdi
        subq	$64, %rcx
L_3072_from_bin_bswap_64_end:
        cmpq	$63, %rcx
        jg	L_3072_from_bin_bswap_64_start
        jmp	L_3072_from_bin_bswap_8_end
L_3072_from_bin_bswap_8_start:
        subq	$8, %r9
        movq	(%r9), %rax
        bswapq	%rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_3072_from_bin_bswap_8_end:
        cmpq	$7, %rcx
        jg	L_3072_from_bin_bswap_8_start
        cmpq	%r11, %rcx
        je	L_3072_from_bin_bswap_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_3072_from_bin_bswap_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_3072_from_bin_bswap_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_3072_from_bin_bswap_hi_end:
        cmpq	%r10, %rdi
        je	L_3072_from_bin_bswap_zero_end
L_3072_from_bin_bswap_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_3072_from_bin_bswap_zero_start
L_3072_from_bin_bswap_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_3072_from_bin_bswap,.-sp_3072_from_bin_bswap
#endif /* __APPLE__ */
/* Read big endian unsigned byte array into r.
 * Uses the movbe instruction which is an optional instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.globl	sp_3072_from_bin_movbe
.type	sp_3072_from_bin_movbe,@function
.align	16
sp_3072_from_bin_movbe:
#else
.globl	_sp_3072_from_bin_movbe
.p2align	4
_sp_3072_from_bin_movbe:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$384, %r10
        xorq	%r11, %r11
        jmp	L_3072_from_bin_movbe_64_end
L_3072_from_bin_movbe_64_start:
        subq	$64, %r9
        movbeq	56(%r9), %rax
        movbeq	48(%r9), %r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movbeq	40(%r9), %rax
        movbeq	32(%r9), %r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movbeq	24(%r9), %rax
        movbeq	16(%r9), %r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movbeq	8(%r9), %rax
        movbeq	(%r9), %r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$64, %rdi
        subq	$64, %rcx
L_3072_from_bin_movbe_64_end:
        cmpq	$63, %rcx
        jg	L_3072_from_bin_movbe_64_start
        jmp	L_3072_from_bin_movbe_8_end
L_3072_from_bin_movbe_8_start:
        subq	$8, %r9
        movbeq	(%r9), %rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_3072_from_bin_movbe_8_end:
        cmpq	$7, %rcx
        jg	L_3072_from_bin_movbe_8_start
        cmpq	%r11, %rcx
        je	L_3072_from_bin_movbe_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_3072_from_bin_movbe_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_3072_from_bin_movbe_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_3072_from_bin_movbe_hi_end:
        cmpq	%r10, %rdi
        je	L_3072_from_bin_movbe_zero_end
L_3072_from_bin_movbe_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_3072_from_bin_movbe_zero_start
L_3072_from_bin_movbe_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_3072_from_bin_movbe,.-sp_3072_from_bin_movbe
#endif /* __APPLE__ */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 384
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.globl	sp_3072_to_bin_bswap
.type	sp_3072_to_bin_bswap,@function
.align	16
sp_3072_to_bin_bswap:
#else
.globl	_sp_3072_to_bin_bswap
.p2align	4
_sp_3072_to_bin_bswap:
#endif /* __APPLE__ */
        movq	376(%rdi), %rdx
        movq	368(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movq	360(%rdi), %rdx
        movq	352(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movq	344(%rdi), %rdx
        movq	336(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movq	328(%rdi), %rdx
        movq	320(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movq	312(%rdi), %rdx
        movq	304(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movq	296(%rdi), %rdx
        movq	288(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movq	280(%rdi), %rdx
        movq	272(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movq	264(%rdi), %rdx
        movq	256(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movq	248(%rdi), %rdx
        movq	240(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movq	232(%rdi), %rdx
        movq	224(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movq	216(%rdi), %rdx
        movq	208(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movq	200(%rdi), %rdx
        movq	192(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movq	184(%rdi), %rdx
        movq	176(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movq	168(%rdi), %rdx
        movq	160(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movq	152(%rdi), %rdx
        movq	144(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movq	136(%rdi), %rdx
        movq	128(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        movq	120(%rdi), %rdx
        movq	112(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 256(%rsi)
        movq	%rax, 264(%rsi)
        movq	104(%rdi), %rdx
        movq	96(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 272(%rsi)
        movq	%rax, 280(%rsi)
        movq	88(%rdi), %rdx
        movq	80(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 288(%rsi)
        movq	%rax, 296(%rsi)
        movq	72(%rdi), %rdx
        movq	64(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 304(%rsi)
        movq	%rax, 312(%rsi)
        movq	56(%rdi), %rdx
        movq	48(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 320(%rsi)
        movq	%rax, 328(%rsi)
        movq	40(%rdi), %rdx
        movq	32(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 336(%rsi)
        movq	%rax, 344(%rsi)
        movq	24(%rdi), %rdx
        movq	16(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 352(%rsi)
        movq	%rax, 360(%rsi)
        movq	8(%rdi), %rdx
        movq	(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 368(%rsi)
        movq	%rax, 376(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_to_bin_bswap,.-sp_3072_to_bin_bswap
#endif /* __APPLE__ */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 384
 * Uses the movbe instruction which is optional.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.globl	sp_3072_to_bin_movbe
.type	sp_3072_to_bin_movbe,@function
.align	16
sp_3072_to_bin_movbe:
#else
.globl	_sp_3072_to_bin_movbe
.p2align	4
_sp_3072_to_bin_movbe:
#endif /* __APPLE__ */
        movbeq	376(%rdi), %rdx
        movbeq	368(%rdi), %rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movbeq	360(%rdi), %rdx
        movbeq	352(%rdi), %rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movbeq	344(%rdi), %rdx
        movbeq	336(%rdi), %rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movbeq	328(%rdi), %rdx
        movbeq	320(%rdi), %rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movbeq	312(%rdi), %rdx
        movbeq	304(%rdi), %rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movbeq	296(%rdi), %rdx
        movbeq	288(%rdi), %rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movbeq	280(%rdi), %rdx
        movbeq	272(%rdi), %rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movbeq	264(%rdi), %rdx
        movbeq	256(%rdi), %rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movbeq	248(%rdi), %rdx
        movbeq	240(%rdi), %rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movbeq	232(%rdi), %rdx
        movbeq	224(%rdi), %rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movbeq	216(%rdi), %rdx
        movbeq	208(%rdi), %rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movbeq	200(%rdi), %rdx
        movbeq	192(%rdi), %rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movbeq	184(%rdi), %rdx
        movbeq	176(%rdi), %rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movbeq	168(%rdi), %rdx
        movbeq	160(%rdi), %rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movbeq	152(%rdi), %rdx
        movbeq	144(%rdi), %rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movbeq	136(%rdi), %rdx
        movbeq	128(%rdi), %rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        movbeq	120(%rdi), %rdx
        movbeq	112(%rdi), %rax
        movq	%rdx, 256(%rsi)
        movq	%rax, 264(%rsi)
        movbeq	104(%rdi), %rdx
        movbeq	96(%rdi), %rax
        movq	%rdx, 272(%rsi)
        movq	%rax, 280(%rsi)
        movbeq	88(%rdi), %rdx
        movbeq	80(%rdi), %rax
        movq	%rdx, 288(%rsi)
        movq	%rax, 296(%rsi)
        movbeq	72(%rdi), %rdx
        movbeq	64(%rdi), %rax
        movq	%rdx, 304(%rsi)
        movq	%rax, 312(%rsi)
        movbeq	56(%rdi), %rdx
        movbeq	48(%rdi), %rax
        movq	%rdx, 320(%rsi)
        movq	%rax, 328(%rsi)
        movbeq	40(%rdi), %rdx
        movbeq	32(%rdi), %rax
        movq	%rdx, 336(%rsi)
        movq	%rax, 344(%rsi)
        movbeq	24(%rdi), %rdx
        movbeq	16(%rdi), %rax
        movq	%rdx, 352(%rsi)
        movq	%rax, 360(%rsi)
        movbeq	8(%rdi), %rdx
        movbeq	(%rdi), %rax
        movq	%rdx, 368(%rsi)
        movq	%rax, 376(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_to_bin_movbe,.-sp_3072_to_bin_movbe
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_12
.type	sp_3072_mul_12,@function
.align	16
sp_3072_mul_12:
#else
.globl	_sp_3072_mul_12
.p2align	4
_sp_3072_mul_12:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        subq	$96, %rsp
        # A[0] * B[0]
        movq	(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        movq	%rax, (%rsp)
        movq	%rdx, %r9
        # A[0] * B[1]
        movq	8(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[0]
        movq	(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 8(%rsp)
        # A[0] * B[2]
        movq	16(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[1]
        movq	8(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[0]
        movq	(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 16(%rsp)
        # A[0] * B[3]
        movq	24(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[2]
        movq	16(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[1]
        movq	8(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[0]
        movq	(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 24(%rsp)
        # A[0] * B[4]
        movq	32(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[3]
        movq	24(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[2]
        movq	16(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[1]
        movq	8(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[0]
        movq	(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 32(%rsp)
        # A[0] * B[5]
        movq	40(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[4]
        movq	32(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[3]
        movq	24(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[2]
        movq	16(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[1]
        movq	8(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[0]
        movq	(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 40(%rsp)
        # A[0] * B[6]
        movq	48(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[5]
        movq	40(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[4]
        movq	32(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[3]
        movq	24(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[2]
        movq	16(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[1]
        movq	8(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[0]
        movq	(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 48(%rsp)
        # A[0] * B[7]
        movq	56(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[6]
        movq	48(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[5]
        movq	40(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[4]
        movq	32(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[3]
        movq	24(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[2]
        movq	16(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[1]
        movq	8(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[0]
        movq	(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 56(%rsp)
        # A[0] * B[8]
        movq	64(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[7]
        movq	56(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[6]
        movq	48(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[5]
        movq	40(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[4]
        movq	32(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[3]
        movq	24(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[2]
        movq	16(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[1]
        movq	8(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[0]
        movq	(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 64(%rsp)
        # A[0] * B[9]
        movq	72(%rcx), %rax
        mulq	(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[1] * B[8]
        movq	64(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[7]
        movq	56(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[6]
        movq	48(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[5]
        movq	40(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[4]
        movq	32(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[3]
        movq	24(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[2]
        movq	16(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[1]
        movq	8(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[0]
        movq	(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 72(%rsp)
        # A[0] * B[10]
        movq	80(%rcx), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[1] * B[9]
        movq	72(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B[8]
        movq	64(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[7]
        movq	56(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[6]
        movq	48(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[5]
        movq	40(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[4]
        movq	32(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[3]
        movq	24(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[2]
        movq	16(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[1]
        movq	8(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[0]
        movq	(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 80(%rsp)
        # A[0] * B[11]
        movq	88(%rcx), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * B[10]
        movq	80(%rcx), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[2] * B[9]
        movq	72(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B[8]
        movq	64(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[7]
        movq	56(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[6]
        movq	48(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[5]
        movq	40(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[4]
        movq	32(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[3]
        movq	24(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[2]
        movq	16(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[1]
        movq	8(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[0]
        movq	(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 88(%rsp)
        # A[1] * B[11]
        movq	88(%rcx), %rax
        mulq	8(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[2] * B[10]
        movq	80(%rcx), %rax
        mulq	16(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[3] * B[9]
        movq	72(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B[8]
        movq	64(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[7]
        movq	56(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[6]
        movq	48(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[5]
        movq	40(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[4]
        movq	32(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[3]
        movq	24(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[2]
        movq	16(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[1]
        movq	8(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 96(%rdi)
        # A[2] * B[11]
        movq	88(%rcx), %rax
        mulq	16(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[3] * B[10]
        movq	80(%rcx), %rax
        mulq	24(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[4] * B[9]
        movq	72(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B[8]
        movq	64(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[7]
        movq	56(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[6]
        movq	48(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[5]
        movq	40(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[4]
        movq	32(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[3]
        movq	24(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[2]
        movq	16(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 104(%rdi)
        # A[3] * B[11]
        movq	88(%rcx), %rax
        mulq	24(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[4] * B[10]
        movq	80(%rcx), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[5] * B[9]
        movq	72(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B[8]
        movq	64(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[7]
        movq	56(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[6]
        movq	48(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[5]
        movq	40(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[4]
        movq	32(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[3]
        movq	24(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 112(%rdi)
        # A[4] * B[11]
        movq	88(%rcx), %rax
        mulq	32(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[5] * B[10]
        movq	80(%rcx), %rax
        mulq	40(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[6] * B[9]
        movq	72(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B[8]
        movq	64(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[7]
        movq	56(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[6]
        movq	48(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[5]
        movq	40(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[4]
        movq	32(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 120(%rdi)
        # A[5] * B[11]
        movq	88(%rcx), %rax
        mulq	40(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[6] * B[10]
        movq	80(%rcx), %rax
        mulq	48(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[7] * B[9]
        movq	72(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B[8]
        movq	64(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[7]
        movq	56(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[6]
        movq	48(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[5]
        movq	40(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 128(%rdi)
        # A[6] * B[11]
        movq	88(%rcx), %rax
        mulq	48(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[7] * B[10]
        movq	80(%rcx), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * B[9]
        movq	72(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B[8]
        movq	64(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[7]
        movq	56(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[6]
        movq	48(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 136(%rdi)
        # A[7] * B[11]
        movq	88(%rcx), %rax
        mulq	56(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[8] * B[10]
        movq	80(%rcx), %rax
        mulq	64(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[9] * B[9]
        movq	72(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B[8]
        movq	64(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[7]
        movq	56(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 144(%rdi)
        # A[8] * B[11]
        movq	88(%rcx), %rax
        mulq	64(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[9] * B[10]
        movq	80(%rcx), %rax
        mulq	72(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[10] * B[9]
        movq	72(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B[8]
        movq	64(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        adcq	$0, %r8
        movq	%r9, 152(%rdi)
        # A[9] * B[11]
        movq	88(%rcx), %rax
        mulq	72(%rsi)
        xorq	%r9, %r9
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[10] * B[10]
        movq	80(%rcx), %rax
        mulq	80(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[11] * B[9]
        movq	72(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%r10, 160(%rdi)
        # A[10] * B[11]
        movq	88(%rcx), %rax
        mulq	80(%rsi)
        xorq	%r10, %r10
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[11] * B[10]
        movq	80(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %r10
        movq	%r8, 168(%rdi)
        # A[11] * B[11]
        movq	88(%rcx), %rax
        mulq	88(%rsi)
        addq	%rax, %r9
        adcq	%rdx, %r10
        movq	%r9, 176(%rdi)
        movq	%r10, 184(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r8
        movq	24(%rsp), %r9
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	%r9, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r8
        movq	56(%rsp), %r9
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r8
        movq	88(%rsp), %r9
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r8, 80(%rdi)
        movq	%r9, 88(%rdi)
        addq	$96, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_12,.-sp_3072_mul_12
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sqr_12
.type	sp_3072_sqr_12,@function
.align	16
sp_3072_sqr_12:
#else
.globl	_sp_3072_sqr_12
.p2align	4
_sp_3072_sqr_12:
#endif /* __APPLE__ */
        push	%r12
        subq	$96, %rsp
        # A[0] * A[0]
        movq	(%rsi), %rax
        mulq	%rax
        xorq	%r9, %r9
        movq	%rax, (%rsp)
        movq	%rdx, %r8
        # A[0] * A[1]
        movq	8(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        movq	%r8, 8(%rsp)
        # A[0] * A[2]
        movq	16(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        # A[1] * A[1]
        movq	8(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        movq	%r9, 16(%rsp)
        # A[0] * A[3]
        movq	24(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[1] * A[2]
        movq	16(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%rcx, 24(%rsp)
        # A[0] * A[4]
        movq	32(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        # A[1] * A[3]
        movq	24(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        # A[2] * A[2]
        movq	16(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        movq	%r8, 32(%rsp)
        # A[0] * A[5]
        movq	40(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[4]
        movq	32(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[3]
        movq	24(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 40(%rsp)
        # A[0] * A[6]
        movq	48(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[5]
        movq	40(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[4]
        movq	32(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[3]
        movq	24(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 48(%rsp)
        # A[0] * A[7]
        movq	56(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[6]
        movq	48(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[5]
        movq	40(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[4]
        movq	32(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 56(%rsp)
        # A[0] * A[8]
        movq	64(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[7]
        movq	56(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[6]
        movq	48(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[5]
        movq	40(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[4]
        movq	32(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 64(%rsp)
        # A[0] * A[9]
        movq	72(%rsi), %rax
        mulq	(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[8]
        movq	64(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[7]
        movq	56(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[6]
        movq	48(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[5]
        movq	40(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 72(%rsp)
        # A[0] * A[10]
        movq	80(%rsi), %rax
        mulq	(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[9]
        movq	72(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[8]
        movq	64(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[7]
        movq	56(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[6]
        movq	48(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[5]
        movq	40(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 80(%rsp)
        # A[0] * A[11]
        movq	88(%rsi), %rax
        mulq	(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[1] * A[10]
        movq	80(%rsi), %rax
        mulq	8(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[2] * A[9]
        movq	72(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[8]
        movq	64(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[7]
        movq	56(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[6]
        movq	48(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 88(%rsp)
        # A[1] * A[11]
        movq	88(%rsi), %rax
        mulq	8(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[2] * A[10]
        movq	80(%rsi), %rax
        mulq	16(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[3] * A[9]
        movq	72(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[8]
        movq	64(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[7]
        movq	56(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[6]
        movq	48(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 96(%rdi)
        # A[2] * A[11]
        movq	88(%rsi), %rax
        mulq	16(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[3] * A[10]
        movq	80(%rsi), %rax
        mulq	24(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[4] * A[9]
        movq	72(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[8]
        movq	64(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[7]
        movq	56(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 104(%rdi)
        # A[3] * A[11]
        movq	88(%rsi), %rax
        mulq	24(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[4] * A[10]
        movq	80(%rsi), %rax
        mulq	32(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[5] * A[9]
        movq	72(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[8]
        movq	64(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[7]
        movq	56(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 112(%rdi)
        # A[4] * A[11]
        movq	88(%rsi), %rax
        mulq	32(%rsi)
        xorq	%r9, %r9
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[5] * A[10]
        movq	80(%rsi), %rax
        mulq	40(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[6] * A[9]
        movq	72(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[8]
        movq	64(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %rcx
        adcq	%r11, %r8
        adcq	%r12, %r9
        movq	%rcx, 120(%rdi)
        # A[5] * A[11]
        movq	88(%rsi), %rax
        mulq	40(%rsi)
        xorq	%rcx, %rcx
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[6] * A[10]
        movq	80(%rsi), %rax
        mulq	48(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[7] * A[9]
        movq	72(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[8]
        movq	64(%rsi), %rax
        mulq	%rax
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r8
        adcq	%r11, %r9
        adcq	%r12, %rcx
        movq	%r8, 128(%rdi)
        # A[6] * A[11]
        movq	88(%rsi), %rax
        mulq	48(%rsi)
        xorq	%r8, %r8
        xorq	%r12, %r12
        movq	%rax, %r10
        movq	%rdx, %r11
        # A[7] * A[10]
        movq	80(%rsi), %rax
        mulq	56(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        # A[8] * A[9]
        movq	72(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r11
        adcq	$0, %r12
        addq	%r10, %r10
        adcq	%r11, %r11
        adcq	%r12, %r12
        addq	%r10, %r9
        adcq	%r11, %rcx
        adcq	%r12, %r8
        movq	%r9, 136(%rdi)
        # A[7] * A[11]
        movq	88(%rsi), %rax
        mulq	56(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[8] * A[10]
        movq	80(%rsi), %rax
        mulq	64(%rsi)
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * A[9]
        movq	72(%rsi), %rax
        mulq	%rax
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%rcx, 144(%rdi)
        # A[8] * A[11]
        movq	88(%rsi), %rax
        mulq	64(%rsi)
        xorq	%rcx, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        # A[9] * A[10]
        movq	80(%rsi), %rax
        mulq	72(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        addq	%rax, %r8
        adcq	%rdx, %r9
        adcq	$0, %rcx
        movq	%r8, 152(%rdi)
        # A[9] * A[11]
        movq	88(%rsi), %rax
        mulq	72(%rsi)
        xorq	%r8, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        # A[10] * A[10]
        movq	80(%rsi), %rax
        mulq	%rax
        addq	%rax, %r9
        adcq	%rdx, %rcx
        adcq	$0, %r8
        movq	%r9, 160(%rdi)
        # A[10] * A[11]
        movq	88(%rsi), %rax
        mulq	80(%rsi)
        xorq	%r9, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        addq	%rax, %rcx
        adcq	%rdx, %r8
        adcq	$0, %r9
        movq	%rcx, 168(%rdi)
        # A[11] * A[11]
        movq	88(%rsi), %rax
        mulq	%rax
        addq	%rax, %r8
        adcq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        movq	(%rsp), %rax
        movq	8(%rsp), %rdx
        movq	16(%rsp), %r10
        movq	24(%rsp), %r11
        movq	%rax, (%rdi)
        movq	%rdx, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	%r11, 24(%rdi)
        movq	32(%rsp), %rax
        movq	40(%rsp), %rdx
        movq	48(%rsp), %r10
        movq	56(%rsp), %r11
        movq	%rax, 32(%rdi)
        movq	%rdx, 40(%rdi)
        movq	%r10, 48(%rdi)
        movq	%r11, 56(%rdi)
        movq	64(%rsp), %rax
        movq	72(%rsp), %rdx
        movq	80(%rsp), %r10
        movq	88(%rsp), %r11
        movq	%rax, 64(%rdi)
        movq	%rdx, 72(%rdi)
        movq	%r10, 80(%rdi)
        movq	%r11, 88(%rdi)
        addq	$96, %rsp
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_12,.-sp_3072_sqr_12
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Multiply a and b into r. (r = a * b)
 *
 * r   Result of multiplication.
 * a   First number to multiply.
 * b   Second number to multiply.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_avx2_12
.type	sp_3072_mul_avx2_12,@function
.align	16
sp_3072_mul_avx2_12:
#else
.globl	_sp_3072_mul_avx2_12
.p2align	4
_sp_3072_mul_avx2_12:
#endif /* __APPLE__ */
        push	%rbx
        push	%rbp
        push	%r12
        movq	%rdx, %rbp
        subq	$96, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbx
        cmovne	%rdi, %rbx
        cmpq	%rdi, %rbp
        cmove	%rsp, %rbx
        xorq	%r12, %r12
        movq	(%rsi), %rdx
        # A[0] * B[0]
        mulx	(%rbp), %r8, %r9
        # A[0] * B[1]
        mulx	8(%rbp), %rax, %r10
        movq	%r8, (%rbx)
        adcxq	%rax, %r9
        movq	%r9, 8(%rbx)
        # A[0] * B[2]
        mulx	16(%rbp), %rax, %r8
        adcxq	%rax, %r10
        # A[0] * B[3]
        mulx	24(%rbp), %rax, %r9
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r8
        movq	%r8, 24(%rbx)
        # A[0] * B[4]
        mulx	32(%rbp), %rax, %r10
        adcxq	%rax, %r9
        # A[0] * B[5]
        mulx	40(%rbp), %rax, %r8
        movq	%r9, 32(%rbx)
        adcxq	%rax, %r10
        movq	%r10, 40(%rbx)
        # A[0] * B[6]
        mulx	48(%rbp), %rax, %r9
        adcxq	%rax, %r8
        # A[0] * B[7]
        mulx	56(%rbp), %rax, %r10
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        movq	%r9, 56(%rbx)
        # A[0] * B[8]
        mulx	64(%rbp), %rax, %r8
        adcxq	%rax, %r10
        # A[0] * B[9]
        mulx	72(%rbp), %rax, %r9
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        movq	%r8, 72(%rbx)
        # A[0] * B[10]
        mulx	80(%rbp), %rax, %r10
        adcxq	%rax, %r9
        # A[0] * B[11]
        mulx	88(%rbp), %rax, %r8
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adcxq	%r12, %r8
        movq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 88(%rbx)
        movq	%r8, 96(%rdi)
        movq	8(%rsi), %rdx
        movq	8(%rbx), %r9
        movq	16(%rbx), %r10
        movq	24(%rbx), %r8
        # A[1] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 8(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 16(%rbx)
        movq	32(%rbx), %r9
        movq	40(%rbx), %r10
        # A[1] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 24(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 32(%rbx)
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        # A[1] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[1] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 40(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rbx)
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[1] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[1] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[1] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[1] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	96(%rdi), %r8
        # A[1] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[1] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, 96(%rdi)
        movq	%r9, 104(%rdi)
        movq	16(%rsi), %rdx
        movq	16(%rbx), %r10
        movq	24(%rbx), %r8
        movq	32(%rbx), %r9
        # A[2] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[2] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 16(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 24(%rbx)
        movq	40(%rbx), %r10
        movq	48(%rbx), %r8
        # A[2] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 32(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 40(%rbx)
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        # A[2] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 56(%rbx)
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[2] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[2] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	96(%rdi), %r8
        # A[2] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[2] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	104(%rdi), %r9
        # A[2] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[2] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 96(%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r9, 104(%rdi)
        movq	%r10, 112(%rdi)
        movq	24(%rsi), %rdx
        movq	24(%rbx), %r8
        movq	32(%rbx), %r9
        movq	40(%rbx), %r10
        # A[3] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 24(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 32(%rbx)
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        # A[3] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[3] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 40(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rbx)
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[3] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[3] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[3] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	96(%rdi), %r8
        movq	104(%rdi), %r9
        # A[3] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[3] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rdi), %r10
        # A[3] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[3] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 104(%rdi)
        movq	%r12, %r8
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        adcxq	%r11, %r8
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 112(%rdi)
        movq	%r8, 120(%rdi)
        movq	32(%rsi), %rdx
        movq	32(%rbx), %r9
        movq	40(%rbx), %r10
        movq	48(%rbx), %r8
        # A[4] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 32(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 40(%rbx)
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        # A[4] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 56(%rbx)
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[4] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[4] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	96(%rdi), %r8
        # A[4] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[4] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	104(%rdi), %r9
        movq	112(%rdi), %r10
        # A[4] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[4] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 96(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 104(%rdi)
        movq	120(%rdi), %r8
        # A[4] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[4] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 112(%rdi)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, 120(%rdi)
        movq	%r9, 128(%rdi)
        movq	40(%rsi), %rdx
        movq	40(%rbx), %r10
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        # A[5] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[5] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 40(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 48(%rbx)
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[5] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[5] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	96(%rdi), %r8
        movq	104(%rdi), %r9
        # A[5] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[5] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rdi), %r10
        movq	120(%rdi), %r8
        # A[5] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[5] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 104(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 112(%rdi)
        movq	128(%rdi), %r9
        # A[5] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[5] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 120(%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r9, 128(%rdi)
        movq	%r10, 136(%rdi)
        movq	48(%rsi), %rdx
        movq	48(%rbx), %r8
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        # A[6] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 48(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 56(%rbx)
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[6] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[6] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	96(%rdi), %r8
        # A[6] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	104(%rdi), %r9
        movq	112(%rdi), %r10
        # A[6] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[6] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 96(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 104(%rdi)
        movq	120(%rdi), %r8
        movq	128(%rdi), %r9
        # A[6] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[6] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 112(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rdi)
        movq	136(%rdi), %r10
        # A[6] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[6] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        movq	%r12, %r8
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        adcxq	%r11, %r8
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 136(%rdi)
        movq	%r8, 144(%rdi)
        movq	56(%rsi), %rdx
        movq	56(%rbx), %r9
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        # A[7] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 56(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 64(%rbx)
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[7] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	96(%rdi), %r8
        movq	104(%rdi), %r9
        # A[7] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[7] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rdi), %r10
        movq	120(%rdi), %r8
        # A[7] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[7] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 104(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 112(%rdi)
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[7] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[7] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 120(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r8
        # A[7] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[7] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, 144(%rdi)
        movq	%r9, 152(%rdi)
        movq	64(%rsi), %rdx
        movq	64(%rbx), %r10
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        # A[8] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[8] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 64(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 72(%rbx)
        movq	88(%rbx), %r10
        movq	96(%rdi), %r8
        # A[8] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	104(%rdi), %r9
        movq	112(%rdi), %r10
        # A[8] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 96(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 104(%rdi)
        movq	120(%rdi), %r8
        movq	128(%rdi), %r9
        # A[8] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[8] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 112(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rdi)
        movq	136(%rdi), %r10
        movq	144(%rdi), %r8
        # A[8] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[8] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 136(%rdi)
        movq	152(%rdi), %r9
        # A[8] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[8] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 144(%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r9, 152(%rdi)
        movq	%r10, 160(%rdi)
        movq	72(%rsi), %rdx
        movq	72(%rbx), %r8
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        # A[9] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r8, 72(%rbx)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 80(%rbx)
        movq	96(%rdi), %r8
        movq	104(%rdi), %r9
        # A[9] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[9] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rdi), %r10
        movq	120(%rdi), %r8
        # A[9] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r9, 104(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 112(%rdi)
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[9] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[9] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r8, 120(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r8
        movq	152(%rdi), %r9
        # A[9] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[9] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rdi), %r10
        # A[9] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[9] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r9, 152(%rdi)
        movq	%r12, %r8
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        adcxq	%r11, %r8
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r10, 160(%rdi)
        movq	%r8, 168(%rdi)
        movq	80(%rsi), %rdx
        movq	80(%rbx), %r9
        movq	88(%rbx), %r10
        movq	96(%rdi), %r8
        # A[10] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r9, 80(%rbx)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 88(%rbx)
        movq	104(%rdi), %r9
        movq	112(%rdi), %r10
        # A[10] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r8, 96(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 104(%rdi)
        movq	120(%rdi), %r8
        movq	128(%rdi), %r9
        # A[10] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[10] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r10, 112(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rdi)
        movq	136(%rdi), %r10
        movq	144(%rdi), %r8
        # A[10] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[10] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r9, 128(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 136(%rdi)
        movq	152(%rdi), %r9
        movq	160(%rdi), %r10
        # A[10] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[10] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r8, 144(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 152(%rdi)
        movq	168(%rdi), %r8
        # A[10] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[10] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r10, 160(%rdi)
        movq	%r12, %r9
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        adcxq	%r11, %r9
        movq	%r12, %r11
        adoxq	%r12, %r11
        adcxq	%r12, %r11
        movq	%r8, 168(%rdi)
        movq	%r9, 176(%rdi)
        movq	88(%rsi), %rdx
        movq	88(%rbx), %r10
        movq	96(%rdi), %r8
        movq	104(%rdi), %r9
        # A[11] * B[0]
        mulx	(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[11] * B[1]
        mulx	8(%rbp), %rax, %rcx
        movq	%r10, 88(%rbx)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rdi), %r10
        movq	120(%rdi), %r8
        # A[11] * B[2]
        mulx	16(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[3]
        mulx	24(%rbp), %rax, %rcx
        movq	%r9, 104(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 112(%rdi)
        movq	128(%rdi), %r9
        movq	136(%rdi), %r10
        # A[11] * B[4]
        mulx	32(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[5]
        mulx	40(%rbp), %rax, %rcx
        movq	%r8, 120(%rdi)
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r8
        movq	152(%rdi), %r9
        # A[11] * B[6]
        mulx	48(%rbp), %rax, %rcx
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        # A[11] * B[7]
        mulx	56(%rbp), %rax, %rcx
        movq	%r10, 136(%rdi)
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rdi), %r10
        movq	168(%rdi), %r8
        # A[11] * B[8]
        mulx	64(%rbp), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        # A[11] * B[9]
        mulx	72(%rbp), %rax, %rcx
        movq	%r9, 152(%rdi)
        adcxq	%rax, %r10
        adoxq	%rcx, %r8
        movq	%r10, 160(%rdi)
        movq	176(%rdi), %r9
        # A[11] * B[10]
        mulx	80(%rbp), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        # A[11] * B[11]
        mulx	88(%rbp), %rax, %rcx
        movq	%r8, 168(%rdi)
        movq	%r12, %r10
        adcxq	%rax, %r9
        adoxq	%rcx, %r10
        adcxq	%r11, %r10
        movq	%r9, 176(%rdi)
        movq	%r10, 184(%rdi)
        cmpq	%rdi, %rsi
        je	L_start_3072_mul_avx2_12
        cmpq	%rdi, %rbp
        jne	L_end_3072_mul_avx2_12
L_start_3072_mul_avx2_12:
        vmovdqu	(%rbx), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbx), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbx), %xmm0
        vmovups	%xmm0, 32(%rdi)
        vmovdqu	48(%rbx), %xmm0
        vmovups	%xmm0, 48(%rdi)
        vmovdqu	64(%rbx), %xmm0
        vmovups	%xmm0, 64(%rdi)
        vmovdqu	80(%rbx), %xmm0
        vmovups	%xmm0, 80(%rdi)
L_end_3072_mul_avx2_12:
        addq	$96, %rsp
        pop	%r12
        pop	%rbp
        pop	%rbx
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_avx2_12,.-sp_3072_mul_avx2_12
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
#ifdef HAVE_INTEL_AVX2
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sqr_avx2_12
.type	sp_3072_sqr_avx2_12,@function
.align	16
sp_3072_sqr_avx2_12:
#else
.globl	_sp_3072_sqr_avx2_12
.p2align	4
_sp_3072_sqr_avx2_12:
#endif /* __APPLE__ */
        push	%rbp
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        push	%rbx
        subq	$96, %rsp
        cmpq	%rdi, %rsi
        movq	%rsp, %rbp
        cmovne	%rdi, %rbp
        xorq	%r10, %r10
        # Diagonal 1
        # A[1] x A[0]
        movq	(%rsi), %rdx
        mulxq	8(%rsi), %r8, %r9
        movq	%r8, 8(%rbp)
        movq	%r10, %r8
        # A[2] x A[0]
        mulxq	16(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 16(%rbp)
        movq	%r10, %r9
        # A[3] x A[0]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 24(%rbp)
        movq	%r10, %r8
        # A[4] x A[0]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 32(%rbp)
        movq	%r10, %r9
        # A[5] x A[0]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 40(%rbp)
        movq	%r10, %r8
        # A[6] x A[0]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 48(%rbp)
        movq	%r10, %r9
        # A[7] x A[0]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, %r12
        movq	%r10, %r8
        # A[8] x A[0]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, %r13
        movq	%r10, %r9
        # A[9] x A[0]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, %r14
        movq	%r10, %r8
        # A[10] x A[0]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, %r15
        movq	%r10, %r9
        # A[11] x A[0]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, %rbx
        #  Carry
        adcxq	%r10, %r9
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r9, 96(%rdi)
        # Diagonal 2
        movq	24(%rbp), %r9
        movq	32(%rbp), %r8
        # A[2] x A[1]
        movq	8(%rsi), %rdx
        mulxq	16(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 24(%rbp)
        movq	40(%rbp), %r9
        # A[3] x A[1]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 32(%rbp)
        movq	48(%rbp), %r8
        # A[4] x A[1]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 40(%rbp)
        # No load %r12 - %r9
        # A[5] x A[1]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r12
        movq	%r8, 48(%rbp)
        # No load %r13 - %r8
        # A[6] x A[1]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # No store %r12
        # No load %r14 - %r9
        # A[7] x A[1]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # No store %r13
        # No load %r15 - %r8
        # A[8] x A[1]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14
        # No load %rbx - %r9
        # A[9] x A[1]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15
        movq	96(%rdi), %r8
        # A[10] x A[1]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # No store %rbx
        movq	%r10, %r9
        # A[11] x A[1]
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	%r10, %r8
        # A[11] x A[2]
        movq	16(%rsi), %rdx
        mulxq	88(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 104(%rdi)
        #  Carry
        adcxq	%r11, %r8
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r8, 112(%rdi)
        # Diagonal 3
        movq	40(%rbp), %r8
        movq	48(%rbp), %r9
        # A[3] x A[2]
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 40(%rbp)
        # No load %r12 - %r8
        # A[4] x A[2]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r12
        movq	%r9, 48(%rbp)
        # No load %r13 - %r9
        # A[5] x A[2]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # No store %r12
        # No load %r14 - %r8
        # A[6] x A[2]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # No store %r13
        # No load %r15 - %r9
        # A[7] x A[2]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14
        # No load %rbx - %r8
        # A[8] x A[2]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15
        movq	96(%rdi), %r9
        # A[9] x A[2]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # No store %rbx
        movq	104(%rdi), %r8
        # A[10] x A[2]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 96(%rdi)
        movq	112(%rdi), %r9
        # A[10] x A[3]
        movq	80(%rsi), %rdx
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 104(%rdi)
        movq	%r10, %r8
        # A[10] x A[4]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 112(%rdi)
        movq	%r10, %r9
        # A[10] x A[5]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rdi)
        #  Carry
        adcxq	%r11, %r9
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r9, 128(%rdi)
        # Diagonal 4
        # No load %r12 - %r9
        # No load %r13 - %r8
        # A[4] x A[3]
        movq	24(%rsi), %rdx
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r12
        adoxq	%rcx, %r13
        # No store %r12
        # No load %r14 - %r9
        # A[5] x A[3]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r13
        adoxq	%rcx, %r14
        # No store %r13
        # No load %r15 - %r8
        # A[6] x A[3]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14
        # No load %rbx - %r9
        # A[7] x A[3]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15
        movq	96(%rdi), %r8
        # A[8] x A[3]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # No store %rbx
        movq	104(%rdi), %r9
        # A[9] x A[3]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rdi), %r8
        # A[9] x A[4]
        movq	72(%rsi), %rdx
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rdi), %r9
        # A[9] x A[5]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rdi), %r8
        # A[9] x A[6]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 120(%rdi)
        movq	%r10, %r9
        # A[9] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 128(%rdi)
        movq	%r10, %r8
        # A[9] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 136(%rdi)
        #  Carry
        adcxq	%r11, %r8
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r8, 144(%rdi)
        # Diagonal 5
        # No load %r14 - %r8
        # No load %r15 - %r9
        # A[5] x A[4]
        movq	32(%rsi), %rdx
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r14
        adoxq	%rcx, %r15
        # No store %r14
        # No load %rbx - %r8
        # A[6] x A[4]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r15
        adoxq	%rcx, %rbx
        # No store %r15
        movq	96(%rdi), %r9
        # A[7] x A[4]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r9
        # No store %rbx
        movq	104(%rdi), %r8
        # A[8] x A[4]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 96(%rdi)
        movq	112(%rdi), %r9
        # A[8] x A[5]
        movq	64(%rsi), %rdx
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 104(%rdi)
        movq	120(%rdi), %r8
        # A[8] x A[6]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 112(%rdi)
        movq	128(%rdi), %r9
        # A[8] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 120(%rdi)
        movq	136(%rdi), %r8
        # A[10] x A[6]
        movq	80(%rsi), %rdx
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 128(%rdi)
        movq	144(%rdi), %r9
        # A[10] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 136(%rdi)
        movq	%r10, %r8
        # A[10] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 144(%rdi)
        movq	%r10, %r9
        # A[10] x A[9]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 152(%rdi)
        #  Carry
        adcxq	%r11, %r9
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r9, 160(%rdi)
        # Diagonal 6
        # No load %rbx - %r9
        movq	96(%rdi), %r8
        # A[6] x A[5]
        movq	40(%rsi), %rdx
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %rbx
        adoxq	%rcx, %r8
        # No store %rbx
        movq	104(%rdi), %r9
        # A[7] x A[5]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rdi), %r8
        # A[7] x A[6]
        movq	48(%rsi), %rdx
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rdi), %r9
        # A[11] x A[3]
        movq	88(%rsi), %rdx
        mulxq	24(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rdi), %r8
        # A[11] x A[4]
        mulxq	32(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rdi), %r9
        # A[11] x A[5]
        mulxq	40(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rdi), %r8
        # A[11] x A[6]
        mulxq	48(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rdi), %r9
        # A[11] x A[7]
        mulxq	56(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rdi), %r8
        # A[11] x A[8]
        mulxq	64(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 152(%rdi)
        movq	%r10, %r9
        # A[11] x A[9]
        mulxq	72(%rsi), %rax, %rcx
        adcxq	%rax, %r8
        adoxq	%rcx, %r9
        movq	%r8, 160(%rdi)
        movq	%r10, %r8
        # A[11] x A[10]
        mulxq	80(%rsi), %rax, %rcx
        adcxq	%rax, %r9
        adoxq	%rcx, %r8
        movq	%r9, 168(%rdi)
        #  Carry
        adcxq	%r11, %r8
        movq	%r10, %r11
        adcxq	%r10, %r11
        adoxq	%r10, %r11
        movq	%r8, 176(%rdi)
        movq	%r11, 184(%rdi)
        # Double and Add in A[i] x A[i]
        movq	8(%rbp), %r9
        # A[0] x A[0]
        movq	(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        movq	%rax, (%rbp)
        adoxq	%r9, %r9
        adcxq	%rcx, %r9
        movq	%r9, 8(%rbp)
        movq	16(%rbp), %r8
        movq	24(%rbp), %r9
        # A[1] x A[1]
        movq	8(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 16(%rbp)
        movq	%r9, 24(%rbp)
        movq	32(%rbp), %r8
        movq	40(%rbp), %r9
        # A[2] x A[2]
        movq	16(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 32(%rbp)
        movq	%r9, 40(%rbp)
        movq	48(%rbp), %r8
        # A[3] x A[3]
        movq	24(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r12, %r12
        adcxq	%rax, %r8
        adcxq	%rcx, %r12
        movq	%r8, 48(%rbp)
        # A[4] x A[4]
        movq	32(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r13, %r13
        adoxq	%r14, %r14
        adcxq	%rax, %r13
        adcxq	%rcx, %r14
        # A[5] x A[5]
        movq	40(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r15, %r15
        adoxq	%rbx, %rbx
        adcxq	%rax, %r15
        adcxq	%rcx, %rbx
        movq	96(%rdi), %r8
        movq	104(%rdi), %r9
        # A[6] x A[6]
        movq	48(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 96(%rdi)
        movq	%r9, 104(%rdi)
        movq	112(%rdi), %r8
        movq	120(%rdi), %r9
        # A[7] x A[7]
        movq	56(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        movq	128(%rdi), %r8
        movq	136(%rdi), %r9
        # A[8] x A[8]
        movq	64(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 128(%rdi)
        movq	%r9, 136(%rdi)
        movq	144(%rdi), %r8
        movq	152(%rdi), %r9
        # A[9] x A[9]
        movq	72(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 144(%rdi)
        movq	%r9, 152(%rdi)
        movq	160(%rdi), %r8
        movq	168(%rdi), %r9
        # A[10] x A[10]
        movq	80(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 160(%rdi)
        movq	%r9, 168(%rdi)
        movq	176(%rdi), %r8
        movq	184(%rdi), %r9
        # A[11] x A[11]
        movq	88(%rsi), %rdx
        mulxq	%rdx, %rax, %rcx
        adoxq	%r8, %r8
        adoxq	%r9, %r9
        adcxq	%rax, %r8
        adcxq	%rcx, %r9
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        movq	%r12, 56(%rdi)
        movq	%r13, 64(%rdi)
        movq	%r14, 72(%rdi)
        movq	%r15, 80(%rdi)
        movq	%rbx, 88(%rdi)
        cmpq	%rdi, %rsi
        jne	L_end_3072_sqr_avx2_12
        vmovdqu	(%rbp), %xmm0
        vmovups	%xmm0, (%rdi)
        vmovdqu	16(%rbp), %xmm0
        vmovups	%xmm0, 16(%rdi)
        vmovdqu	32(%rbp), %xmm0
        vmovups	%xmm0, 32(%rdi)
        movq	48(%rbp), %rax
        movq	%rax, 48(%rdi)
L_end_3072_sqr_avx2_12:
        addq	$96, %rsp
        pop	%rbx
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        pop	%rbp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_avx2_12,.-sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_add_12
.type	sp_3072_add_12,@function
.align	16
sp_3072_add_12:
#else
.globl	_sp_3072_add_12
.p2align	4
_sp_3072_add_12:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	%r8, 88(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_add_12,.-sp_3072_add_12
#endif /* __APPLE__ */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sub_in_place_24
.type	sp_3072_sub_in_place_24,@function
.align	16
sp_3072_sub_in_place_24:
#else
.globl	_sp_3072_sub_in_place_24
.p2align	4
_sp_3072_sub_in_place_24:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        xorq	%rax, %rax
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	128(%rdi), %rdx
        movq	%rcx, 120(%rdi)
        sbbq	128(%rsi), %rdx
        movq	136(%rdi), %rcx
        movq	%rdx, 128(%rdi)
        sbbq	136(%rsi), %rcx
        movq	144(%rdi), %rdx
        movq	%rcx, 136(%rdi)
        sbbq	144(%rsi), %rdx
        movq	152(%rdi), %rcx
        movq	%rdx, 144(%rdi)
        sbbq	152(%rsi), %rcx
        movq	160(%rdi), %rdx
        movq	%rcx, 152(%rdi)
        sbbq	160(%rsi), %rdx
        movq	168(%rdi), %rcx
        movq	%rdx, 160(%rdi)
        sbbq	168(%rsi), %rcx
        movq	176(%rdi), %rdx
        movq	%rcx, 168(%rdi)
        sbbq	176(%rsi), %rdx
        movq	184(%rdi), %rcx
        movq	%rdx, 176(%rdi)
        sbbq	184(%rsi), %rcx
        movq	%rcx, 184(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_sub_in_place_24,.-sp_3072_sub_in_place_24
#endif /* __APPLE__ */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_add_24
.type	sp_3072_add_24,@function
.align	16
sp_3072_add_24:
#else
.globl	_sp_3072_add_24
.p2align	4
_sp_3072_add_24:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        adcq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        adcq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        adcq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        adcq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        adcq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        adcq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        adcq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        adcq	184(%rdx), %r8
        movq	%r8, 184(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_add_24,.-sp_3072_add_24
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_24
.type	sp_3072_mul_24,@function
.align	16
sp_3072_mul_24:
#else
.globl	_sp_3072_mul_24
.p2align	4
_sp_3072_mul_24:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$616, %rsp
        movq	%rdi, 576(%rsp)
        movq	%rsi, 584(%rsp)
        movq	%rdx, 592(%rsp)
        leaq	384(%rsp), %r10
        leaq	96(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r10)
        adcq	$0, %r13
        movq	%r13, 600(%rsp)
        leaq	480(%rsp), %r11
        leaq	96(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r11)
        adcq	$0, %r14
        movq	%r14, 608(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_12@plt
#else
        callq	_sp_3072_mul_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        leaq	192(%rsp), %rdi
        addq	$96, %rdx
        addq	$96, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_12@plt
#else
        callq	_sp_3072_mul_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        movq	576(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_12@plt
#else
        callq	_sp_3072_mul_12
#endif /* __APPLE__ */
        movq	600(%rsp), %r13
        movq	608(%rsp), %r14
        movq	576(%rsp), %r15
        movq	%r13, %r9
        leaq	384(%rsp), %r10
        leaq	480(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$192, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, (%r10)
        movq	%rcx, (%r11)
        movq	8(%r10), %rax
        movq	8(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 8(%r10)
        movq	%rcx, 8(%r11)
        movq	16(%r10), %rax
        movq	16(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 16(%r10)
        movq	%rcx, 16(%r11)
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 24(%r10)
        movq	%rcx, 24(%r11)
        movq	32(%r10), %rax
        movq	32(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 32(%r10)
        movq	%rcx, 32(%r11)
        movq	40(%r10), %rax
        movq	40(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 40(%r10)
        movq	%rcx, 40(%r11)
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 48(%r10)
        movq	%rcx, 48(%r11)
        movq	56(%r10), %rax
        movq	56(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 56(%r10)
        movq	%rcx, 56(%r11)
        movq	64(%r10), %rax
        movq	64(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 64(%r10)
        movq	%rcx, 64(%r11)
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 72(%r10)
        movq	%rcx, 72(%r11)
        movq	80(%r10), %rax
        movq	80(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 80(%r10)
        movq	%rcx, 80(%r11)
        movq	88(%r10), %rax
        movq	88(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 88(%r10)
        movq	%rcx, 88(%r11)
        movq	(%r10), %rax
        addq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	%r8, 88(%r15)
        adcq	$0, %r9
        leaq	192(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	%r8, 184(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	%r8, 184(%r10)
        sbbq	$0, %r9
        subq	$96, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	%r8, 184(%r15)
        adcq	$0, %r9
        movq	%r9, 288(%rdi)
        addq	$96, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	%rax, 96(%r15)
        # Add to zero
        movq	104(%r11), %rax
        adcq	$0, %rax
        movq	112(%r11), %rcx
        movq	%rax, 104(%r15)
        adcq	$0, %rcx
        movq	120(%r11), %r8
        movq	%rcx, 112(%r15)
        adcq	$0, %r8
        movq	128(%r11), %rax
        movq	%r8, 120(%r15)
        adcq	$0, %rax
        movq	136(%r11), %rcx
        movq	%rax, 128(%r15)
        adcq	$0, %rcx
        movq	144(%r11), %r8
        movq	%rcx, 136(%r15)
        adcq	$0, %r8
        movq	152(%r11), %rax
        movq	%r8, 144(%r15)
        adcq	$0, %rax
        movq	160(%r11), %rcx
        movq	%rax, 152(%r15)
        adcq	$0, %rcx
        movq	168(%r11), %r8
        movq	%rcx, 160(%r15)
        adcq	$0, %r8
        movq	176(%r11), %rax
        movq	%r8, 168(%r15)
        adcq	$0, %rax
        movq	184(%r11), %rcx
        movq	%rax, 176(%r15)
        adcq	$0, %rcx
        movq	%rcx, 184(%r15)
        addq	$616, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_24,.-sp_3072_mul_24
#endif /* __APPLE__ */
/* Add a to a into r. (r = a + a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_dbl_12
.type	sp_3072_dbl_12,@function
.align	16
sp_3072_dbl_12:
#else
.globl	_sp_3072_dbl_12
.p2align	4
_sp_3072_dbl_12:
#endif /* __APPLE__ */
        movq	(%rsi), %rdx
        xorq	%rax, %rax
        addq	%rdx, %rdx
        movq	8(%rsi), %rcx
        movq	%rdx, (%rdi)
        adcq	%rcx, %rcx
        movq	16(%rsi), %rdx
        movq	%rcx, 8(%rdi)
        adcq	%rdx, %rdx
        movq	24(%rsi), %rcx
        movq	%rdx, 16(%rdi)
        adcq	%rcx, %rcx
        movq	32(%rsi), %rdx
        movq	%rcx, 24(%rdi)
        adcq	%rdx, %rdx
        movq	40(%rsi), %rcx
        movq	%rdx, 32(%rdi)
        adcq	%rcx, %rcx
        movq	48(%rsi), %rdx
        movq	%rcx, 40(%rdi)
        adcq	%rdx, %rdx
        movq	56(%rsi), %rcx
        movq	%rdx, 48(%rdi)
        adcq	%rcx, %rcx
        movq	64(%rsi), %rdx
        movq	%rcx, 56(%rdi)
        adcq	%rdx, %rdx
        movq	72(%rsi), %rcx
        movq	%rdx, 64(%rdi)
        adcq	%rcx, %rcx
        movq	80(%rsi), %rdx
        movq	%rcx, 72(%rdi)
        adcq	%rdx, %rdx
        movq	88(%rsi), %rcx
        movq	%rdx, 80(%rdi)
        adcq	%rcx, %rcx
        movq	%rcx, 88(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_dbl_12,.-sp_3072_dbl_12
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sqr_24
.type	sp_3072_sqr_24,@function
.align	16
sp_3072_sqr_24:
#else
.globl	_sp_3072_sqr_24
.p2align	4
_sp_3072_sqr_24:
#endif /* __APPLE__ */
        subq	$504, %rsp
        movq	%rdi, 480(%rsp)
        movq	%rsi, 488(%rsp)
        leaq	384(%rsp), %r8
        leaq	96(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	%rax, 88(%r8)
        adcq	$0, %rcx
        movq	%rcx, 496(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_12@plt
#else
        callq	_sp_3072_sqr_12
#endif /* __APPLE__ */
        movq	488(%rsp), %rsi
        leaq	192(%rsp), %rdi
        addq	$96, %rsi
#ifndef __APPLE__
        callq	sp_3072_sqr_12@plt
#else
        callq	_sp_3072_sqr_12
#endif /* __APPLE__ */
        movq	488(%rsp), %rsi
        movq	480(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_12@plt
#else
        callq	_sp_3072_sqr_12
#endif /* __APPLE__ */
        movq	496(%rsp), %r10
        movq	%rdi, %r9
        leaq	384(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        addq	$192, %r9
        movq	(%r8), %rdx
        movq	8(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, (%r9)
        movq	%rax, 8(%r9)
        movq	16(%r8), %rdx
        movq	24(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 16(%r9)
        movq	%rax, 24(%r9)
        movq	32(%r8), %rdx
        movq	40(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 32(%r9)
        movq	%rax, 40(%r9)
        movq	48(%r8), %rdx
        movq	56(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 48(%r9)
        movq	%rax, 56(%r9)
        movq	64(%r8), %rdx
        movq	72(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 64(%r9)
        movq	%rax, 72(%r9)
        movq	80(%r8), %rdx
        movq	88(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 80(%r9)
        movq	%rax, 88(%r9)
        movq	(%r9), %rdx
        addq	%rdx, %rdx
        movq	8(%r9), %rax
        movq	%rdx, (%r9)
        adcq	%rax, %rax
        movq	16(%r9), %rdx
        movq	%rax, 8(%r9)
        adcq	%rdx, %rdx
        movq	24(%r9), %rax
        movq	%rdx, 16(%r9)
        adcq	%rax, %rax
        movq	32(%r9), %rdx
        movq	%rax, 24(%r9)
        adcq	%rdx, %rdx
        movq	40(%r9), %rax
        movq	%rdx, 32(%r9)
        adcq	%rax, %rax
        movq	48(%r9), %rdx
        movq	%rax, 40(%r9)
        adcq	%rdx, %rdx
        movq	56(%r9), %rax
        movq	%rdx, 48(%r9)
        adcq	%rax, %rax
        movq	64(%r9), %rdx
        movq	%rax, 56(%r9)
        adcq	%rdx, %rdx
        movq	72(%r9), %rax
        movq	%rdx, 64(%r9)
        adcq	%rax, %rax
        movq	80(%r9), %rdx
        movq	%rax, 72(%r9)
        adcq	%rdx, %rdx
        movq	88(%r9), %rax
        movq	%rdx, 80(%r9)
        adcq	%rax, %rax
        movq	%rax, 88(%r9)
        adcq	$0, %rcx
        leaq	192(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	%rax, 184(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	%rax, 184(%r8)
        sbbq	$0, %rcx
        subq	$96, %r9
        # Add in place
        movq	(%r9), %rdx
        addq	(%r8), %rdx
        movq	8(%r9), %rax
        movq	%rdx, (%r9)
        adcq	8(%r8), %rax
        movq	16(%r9), %rdx
        movq	%rax, 8(%r9)
        adcq	16(%r8), %rdx
        movq	24(%r9), %rax
        movq	%rdx, 16(%r9)
        adcq	24(%r8), %rax
        movq	32(%r9), %rdx
        movq	%rax, 24(%r9)
        adcq	32(%r8), %rdx
        movq	40(%r9), %rax
        movq	%rdx, 32(%r9)
        adcq	40(%r8), %rax
        movq	48(%r9), %rdx
        movq	%rax, 40(%r9)
        adcq	48(%r8), %rdx
        movq	56(%r9), %rax
        movq	%rdx, 48(%r9)
        adcq	56(%r8), %rax
        movq	64(%r9), %rdx
        movq	%rax, 56(%r9)
        adcq	64(%r8), %rdx
        movq	72(%r9), %rax
        movq	%rdx, 64(%r9)
        adcq	72(%r8), %rax
        movq	80(%r9), %rdx
        movq	%rax, 72(%r9)
        adcq	80(%r8), %rdx
        movq	88(%r9), %rax
        movq	%rdx, 80(%r9)
        adcq	88(%r8), %rax
        movq	96(%r9), %rdx
        movq	%rax, 88(%r9)
        adcq	96(%r8), %rdx
        movq	104(%r9), %rax
        movq	%rdx, 96(%r9)
        adcq	104(%r8), %rax
        movq	112(%r9), %rdx
        movq	%rax, 104(%r9)
        adcq	112(%r8), %rdx
        movq	120(%r9), %rax
        movq	%rdx, 112(%r9)
        adcq	120(%r8), %rax
        movq	128(%r9), %rdx
        movq	%rax, 120(%r9)
        adcq	128(%r8), %rdx
        movq	136(%r9), %rax
        movq	%rdx, 128(%r9)
        adcq	136(%r8), %rax
        movq	144(%r9), %rdx
        movq	%rax, 136(%r9)
        adcq	144(%r8), %rdx
        movq	152(%r9), %rax
        movq	%rdx, 144(%r9)
        adcq	152(%r8), %rax
        movq	160(%r9), %rdx
        movq	%rax, 152(%r9)
        adcq	160(%r8), %rdx
        movq	168(%r9), %rax
        movq	%rdx, 160(%r9)
        adcq	168(%r8), %rax
        movq	176(%r9), %rdx
        movq	%rax, 168(%r9)
        adcq	176(%r8), %rdx
        movq	184(%r9), %rax
        movq	%rdx, 176(%r9)
        adcq	184(%r8), %rax
        movq	%rax, 184(%r9)
        adcq	$0, %rcx
        movq	%rcx, 288(%rdi)
        # Add in place
        movq	96(%r9), %rdx
        addq	(%rsi), %rdx
        movq	104(%r9), %rax
        movq	%rdx, 96(%r9)
        adcq	8(%rsi), %rax
        movq	112(%r9), %rdx
        movq	%rax, 104(%r9)
        adcq	16(%rsi), %rdx
        movq	120(%r9), %rax
        movq	%rdx, 112(%r9)
        adcq	24(%rsi), %rax
        movq	128(%r9), %rdx
        movq	%rax, 120(%r9)
        adcq	32(%rsi), %rdx
        movq	136(%r9), %rax
        movq	%rdx, 128(%r9)
        adcq	40(%rsi), %rax
        movq	144(%r9), %rdx
        movq	%rax, 136(%r9)
        adcq	48(%rsi), %rdx
        movq	152(%r9), %rax
        movq	%rdx, 144(%r9)
        adcq	56(%rsi), %rax
        movq	160(%r9), %rdx
        movq	%rax, 152(%r9)
        adcq	64(%rsi), %rdx
        movq	168(%r9), %rax
        movq	%rdx, 160(%r9)
        adcq	72(%rsi), %rax
        movq	176(%r9), %rdx
        movq	%rax, 168(%r9)
        adcq	80(%rsi), %rdx
        movq	184(%r9), %rax
        movq	%rdx, 176(%r9)
        adcq	88(%rsi), %rax
        movq	192(%r9), %rdx
        movq	%rax, 184(%r9)
        adcq	96(%rsi), %rdx
        movq	%rdx, 192(%r9)
        # Add to zero
        movq	104(%rsi), %rdx
        adcq	$0, %rdx
        movq	112(%rsi), %rax
        movq	%rdx, 200(%r9)
        adcq	$0, %rax
        movq	120(%rsi), %rdx
        movq	%rax, 208(%r9)
        adcq	$0, %rdx
        movq	128(%rsi), %rax
        movq	%rdx, 216(%r9)
        adcq	$0, %rax
        movq	136(%rsi), %rdx
        movq	%rax, 224(%r9)
        adcq	$0, %rdx
        movq	144(%rsi), %rax
        movq	%rdx, 232(%r9)
        adcq	$0, %rax
        movq	152(%rsi), %rdx
        movq	%rax, 240(%r9)
        adcq	$0, %rdx
        movq	160(%rsi), %rax
        movq	%rdx, 248(%r9)
        adcq	$0, %rax
        movq	168(%rsi), %rdx
        movq	%rax, 256(%r9)
        adcq	$0, %rdx
        movq	176(%rsi), %rax
        movq	%rdx, 264(%r9)
        adcq	$0, %rax
        movq	184(%rsi), %rdx
        movq	%rax, 272(%r9)
        adcq	$0, %rdx
        movq	%rdx, 280(%r9)
        addq	$504, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_24,.-sp_3072_sqr_24
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_avx2_24
.type	sp_3072_mul_avx2_24,@function
.align	16
sp_3072_mul_avx2_24:
#else
.globl	_sp_3072_mul_avx2_24
.p2align	4
_sp_3072_mul_avx2_24:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$616, %rsp
        movq	%rdi, 576(%rsp)
        movq	%rsi, 584(%rsp)
        movq	%rdx, 592(%rsp)
        leaq	384(%rsp), %r10
        leaq	96(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r10)
        adcq	$0, %r13
        movq	%r13, 600(%rsp)
        leaq	480(%rsp), %r11
        leaq	96(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	%r8, 88(%r11)
        adcq	$0, %r14
        movq	%r14, 608(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_12@plt
#else
        callq	_sp_3072_mul_avx2_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        leaq	192(%rsp), %rdi
        addq	$96, %rdx
        addq	$96, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_12@plt
#else
        callq	_sp_3072_mul_avx2_12
#endif /* __APPLE__ */
        movq	592(%rsp), %rdx
        movq	584(%rsp), %rsi
        movq	576(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_12@plt
#else
        callq	_sp_3072_mul_avx2_12
#endif /* __APPLE__ */
        movq	600(%rsp), %r13
        movq	608(%rsp), %r14
        movq	576(%rsp), %r15
        movq	%r13, %r9
        leaq	384(%rsp), %r10
        leaq	480(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$192, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        addq	%rcx, %rax
        movq	8(%r10), %rcx
        movq	8(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, (%r15)
        adcq	%r8, %rcx
        movq	16(%r10), %r8
        movq	16(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 8(%r15)
        adcq	%rax, %r8
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 16(%r15)
        adcq	%rcx, %rax
        movq	32(%r10), %rcx
        movq	32(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 24(%r15)
        adcq	%r8, %rcx
        movq	40(%r10), %r8
        movq	40(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 32(%r15)
        adcq	%rax, %r8
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 40(%r15)
        adcq	%rcx, %rax
        movq	56(%r10), %rcx
        movq	56(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 48(%r15)
        adcq	%r8, %rcx
        movq	64(%r10), %r8
        movq	64(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 56(%r15)
        adcq	%rax, %r8
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 64(%r15)
        adcq	%rcx, %rax
        movq	80(%r10), %rcx
        movq	80(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 72(%r15)
        adcq	%r8, %rcx
        movq	88(%r10), %r8
        movq	88(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 80(%r15)
        adcq	%rax, %r8
        movq	%r8, 88(%r15)
        adcq	$0, %r9
        leaq	192(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	%r8, 184(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	%r8, 184(%r10)
        sbbq	$0, %r9
        subq	$96, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	%r8, 184(%r15)
        adcq	$0, %r9
        movq	%r9, 288(%rdi)
        addq	$96, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	%rax, 96(%r15)
        # Add to zero
        movq	104(%r11), %rax
        adcq	$0, %rax
        movq	112(%r11), %rcx
        movq	%rax, 104(%r15)
        adcq	$0, %rcx
        movq	120(%r11), %r8
        movq	%rcx, 112(%r15)
        adcq	$0, %r8
        movq	128(%r11), %rax
        movq	%r8, 120(%r15)
        adcq	$0, %rax
        movq	136(%r11), %rcx
        movq	%rax, 128(%r15)
        adcq	$0, %rcx
        movq	144(%r11), %r8
        movq	%rcx, 136(%r15)
        adcq	$0, %r8
        movq	152(%r11), %rax
        movq	%r8, 144(%r15)
        adcq	$0, %rax
        movq	160(%r11), %rcx
        movq	%rax, 152(%r15)
        adcq	$0, %rcx
        movq	168(%r11), %r8
        movq	%rcx, 160(%r15)
        adcq	$0, %r8
        movq	176(%r11), %rax
        movq	%r8, 168(%r15)
        adcq	$0, %rax
        movq	184(%r11), %rcx
        movq	%rax, 176(%r15)
        adcq	$0, %rcx
        movq	%rcx, 184(%r15)
        addq	$616, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_avx2_24,.-sp_3072_mul_avx2_24
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sqr_avx2_24
.type	sp_3072_sqr_avx2_24,@function
.align	16
sp_3072_sqr_avx2_24:
#else
.globl	_sp_3072_sqr_avx2_24
.p2align	4
_sp_3072_sqr_avx2_24:
#endif /* __APPLE__ */
        subq	$504, %rsp
        movq	%rdi, 480(%rsp)
        movq	%rsi, 488(%rsp)
        leaq	384(%rsp), %r8
        leaq	96(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	%rax, 88(%r8)
        adcq	$0, %rcx
        movq	%rcx, 496(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_12@plt
#else
        callq	_sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
        movq	488(%rsp), %rsi
        leaq	192(%rsp), %rdi
        addq	$96, %rsi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_12@plt
#else
        callq	_sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
        movq	488(%rsp), %rsi
        movq	480(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_12@plt
#else
        callq	_sp_3072_sqr_avx2_12
#endif /* __APPLE__ */
        movq	496(%rsp), %r10
        movq	%rdi, %r9
        leaq	384(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        addq	$192, %r9
        movq	(%r8), %rdx
        pextq	%r10, %rdx, %rdx
        addq	%rdx, %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	%rax, 88(%r9)
        adcq	$0, %rcx
        leaq	192(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	%rax, 184(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	%rax, 184(%r8)
        sbbq	$0, %rcx
        subq	$96, %r9
        # Add in place
        movq	(%r9), %rdx
        addq	(%r8), %rdx
        movq	8(%r9), %rax
        movq	%rdx, (%r9)
        adcq	8(%r8), %rax
        movq	16(%r9), %rdx
        movq	%rax, 8(%r9)
        adcq	16(%r8), %rdx
        movq	24(%r9), %rax
        movq	%rdx, 16(%r9)
        adcq	24(%r8), %rax
        movq	32(%r9), %rdx
        movq	%rax, 24(%r9)
        adcq	32(%r8), %rdx
        movq	40(%r9), %rax
        movq	%rdx, 32(%r9)
        adcq	40(%r8), %rax
        movq	48(%r9), %rdx
        movq	%rax, 40(%r9)
        adcq	48(%r8), %rdx
        movq	56(%r9), %rax
        movq	%rdx, 48(%r9)
        adcq	56(%r8), %rax
        movq	64(%r9), %rdx
        movq	%rax, 56(%r9)
        adcq	64(%r8), %rdx
        movq	72(%r9), %rax
        movq	%rdx, 64(%r9)
        adcq	72(%r8), %rax
        movq	80(%r9), %rdx
        movq	%rax, 72(%r9)
        adcq	80(%r8), %rdx
        movq	88(%r9), %rax
        movq	%rdx, 80(%r9)
        adcq	88(%r8), %rax
        movq	96(%r9), %rdx
        movq	%rax, 88(%r9)
        adcq	96(%r8), %rdx
        movq	104(%r9), %rax
        movq	%rdx, 96(%r9)
        adcq	104(%r8), %rax
        movq	112(%r9), %rdx
        movq	%rax, 104(%r9)
        adcq	112(%r8), %rdx
        movq	120(%r9), %rax
        movq	%rdx, 112(%r9)
        adcq	120(%r8), %rax
        movq	128(%r9), %rdx
        movq	%rax, 120(%r9)
        adcq	128(%r8), %rdx
        movq	136(%r9), %rax
        movq	%rdx, 128(%r9)
        adcq	136(%r8), %rax
        movq	144(%r9), %rdx
        movq	%rax, 136(%r9)
        adcq	144(%r8), %rdx
        movq	152(%r9), %rax
        movq	%rdx, 144(%r9)
        adcq	152(%r8), %rax
        movq	160(%r9), %rdx
        movq	%rax, 152(%r9)
        adcq	160(%r8), %rdx
        movq	168(%r9), %rax
        movq	%rdx, 160(%r9)
        adcq	168(%r8), %rax
        movq	176(%r9), %rdx
        movq	%rax, 168(%r9)
        adcq	176(%r8), %rdx
        movq	184(%r9), %rax
        movq	%rdx, 176(%r9)
        adcq	184(%r8), %rax
        movq	%rax, 184(%r9)
        adcq	$0, %rcx
        movq	%rcx, 288(%rdi)
        # Add in place
        movq	96(%r9), %rdx
        addq	(%rsi), %rdx
        movq	104(%r9), %rax
        movq	%rdx, 96(%r9)
        adcq	8(%rsi), %rax
        movq	112(%r9), %rdx
        movq	%rax, 104(%r9)
        adcq	16(%rsi), %rdx
        movq	120(%r9), %rax
        movq	%rdx, 112(%r9)
        adcq	24(%rsi), %rax
        movq	128(%r9), %rdx
        movq	%rax, 120(%r9)
        adcq	32(%rsi), %rdx
        movq	136(%r9), %rax
        movq	%rdx, 128(%r9)
        adcq	40(%rsi), %rax
        movq	144(%r9), %rdx
        movq	%rax, 136(%r9)
        adcq	48(%rsi), %rdx
        movq	152(%r9), %rax
        movq	%rdx, 144(%r9)
        adcq	56(%rsi), %rax
        movq	160(%r9), %rdx
        movq	%rax, 152(%r9)
        adcq	64(%rsi), %rdx
        movq	168(%r9), %rax
        movq	%rdx, 160(%r9)
        adcq	72(%rsi), %rax
        movq	176(%r9), %rdx
        movq	%rax, 168(%r9)
        adcq	80(%rsi), %rdx
        movq	184(%r9), %rax
        movq	%rdx, 176(%r9)
        adcq	88(%rsi), %rax
        movq	192(%r9), %rdx
        movq	%rax, 184(%r9)
        adcq	96(%rsi), %rdx
        movq	%rdx, 192(%r9)
        # Add to zero
        movq	104(%rsi), %rdx
        adcq	$0, %rdx
        movq	112(%rsi), %rax
        movq	%rdx, 200(%r9)
        adcq	$0, %rax
        movq	120(%rsi), %rdx
        movq	%rax, 208(%r9)
        adcq	$0, %rdx
        movq	128(%rsi), %rax
        movq	%rdx, 216(%r9)
        adcq	$0, %rax
        movq	136(%rsi), %rdx
        movq	%rax, 224(%r9)
        adcq	$0, %rdx
        movq	144(%rsi), %rax
        movq	%rdx, 232(%r9)
        adcq	$0, %rax
        movq	152(%rsi), %rdx
        movq	%rax, 240(%r9)
        adcq	$0, %rdx
        movq	160(%rsi), %rax
        movq	%rdx, 248(%r9)
        adcq	$0, %rax
        movq	168(%rsi), %rdx
        movq	%rax, 256(%r9)
        adcq	$0, %rdx
        movq	176(%rsi), %rax
        movq	%rdx, 264(%r9)
        adcq	$0, %rax
        movq	184(%rsi), %rdx
        movq	%rax, 272(%r9)
        adcq	$0, %rdx
        movq	%rdx, 280(%r9)
        addq	$504, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_avx2_24,.-sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sub_in_place_48
.type	sp_3072_sub_in_place_48,@function
.align	16
sp_3072_sub_in_place_48:
#else
.globl	_sp_3072_sub_in_place_48
.p2align	4
_sp_3072_sub_in_place_48:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        xorq	%rax, %rax
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	128(%rdi), %rdx
        movq	%rcx, 120(%rdi)
        sbbq	128(%rsi), %rdx
        movq	136(%rdi), %rcx
        movq	%rdx, 128(%rdi)
        sbbq	136(%rsi), %rcx
        movq	144(%rdi), %rdx
        movq	%rcx, 136(%rdi)
        sbbq	144(%rsi), %rdx
        movq	152(%rdi), %rcx
        movq	%rdx, 144(%rdi)
        sbbq	152(%rsi), %rcx
        movq	160(%rdi), %rdx
        movq	%rcx, 152(%rdi)
        sbbq	160(%rsi), %rdx
        movq	168(%rdi), %rcx
        movq	%rdx, 160(%rdi)
        sbbq	168(%rsi), %rcx
        movq	176(%rdi), %rdx
        movq	%rcx, 168(%rdi)
        sbbq	176(%rsi), %rdx
        movq	184(%rdi), %rcx
        movq	%rdx, 176(%rdi)
        sbbq	184(%rsi), %rcx
        movq	192(%rdi), %rdx
        movq	%rcx, 184(%rdi)
        sbbq	192(%rsi), %rdx
        movq	200(%rdi), %rcx
        movq	%rdx, 192(%rdi)
        sbbq	200(%rsi), %rcx
        movq	208(%rdi), %rdx
        movq	%rcx, 200(%rdi)
        sbbq	208(%rsi), %rdx
        movq	216(%rdi), %rcx
        movq	%rdx, 208(%rdi)
        sbbq	216(%rsi), %rcx
        movq	224(%rdi), %rdx
        movq	%rcx, 216(%rdi)
        sbbq	224(%rsi), %rdx
        movq	232(%rdi), %rcx
        movq	%rdx, 224(%rdi)
        sbbq	232(%rsi), %rcx
        movq	240(%rdi), %rdx
        movq	%rcx, 232(%rdi)
        sbbq	240(%rsi), %rdx
        movq	248(%rdi), %rcx
        movq	%rdx, 240(%rdi)
        sbbq	248(%rsi), %rcx
        movq	256(%rdi), %rdx
        movq	%rcx, 248(%rdi)
        sbbq	256(%rsi), %rdx
        movq	264(%rdi), %rcx
        movq	%rdx, 256(%rdi)
        sbbq	264(%rsi), %rcx
        movq	272(%rdi), %rdx
        movq	%rcx, 264(%rdi)
        sbbq	272(%rsi), %rdx
        movq	280(%rdi), %rcx
        movq	%rdx, 272(%rdi)
        sbbq	280(%rsi), %rcx
        movq	288(%rdi), %rdx
        movq	%rcx, 280(%rdi)
        sbbq	288(%rsi), %rdx
        movq	296(%rdi), %rcx
        movq	%rdx, 288(%rdi)
        sbbq	296(%rsi), %rcx
        movq	304(%rdi), %rdx
        movq	%rcx, 296(%rdi)
        sbbq	304(%rsi), %rdx
        movq	312(%rdi), %rcx
        movq	%rdx, 304(%rdi)
        sbbq	312(%rsi), %rcx
        movq	320(%rdi), %rdx
        movq	%rcx, 312(%rdi)
        sbbq	320(%rsi), %rdx
        movq	328(%rdi), %rcx
        movq	%rdx, 320(%rdi)
        sbbq	328(%rsi), %rcx
        movq	336(%rdi), %rdx
        movq	%rcx, 328(%rdi)
        sbbq	336(%rsi), %rdx
        movq	344(%rdi), %rcx
        movq	%rdx, 336(%rdi)
        sbbq	344(%rsi), %rcx
        movq	352(%rdi), %rdx
        movq	%rcx, 344(%rdi)
        sbbq	352(%rsi), %rdx
        movq	360(%rdi), %rcx
        movq	%rdx, 352(%rdi)
        sbbq	360(%rsi), %rcx
        movq	368(%rdi), %rdx
        movq	%rcx, 360(%rdi)
        sbbq	368(%rsi), %rdx
        movq	376(%rdi), %rcx
        movq	%rdx, 368(%rdi)
        sbbq	376(%rsi), %rcx
        movq	%rcx, 376(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_sub_in_place_48,.-sp_3072_sub_in_place_48
#endif /* __APPLE__ */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_add_48
.type	sp_3072_add_48,@function
.align	16
sp_3072_add_48:
#else
.globl	_sp_3072_add_48
.p2align	4
_sp_3072_add_48:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        adcq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        adcq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        adcq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        adcq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        adcq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        adcq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        adcq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        adcq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        adcq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        adcq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        adcq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        adcq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        adcq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        adcq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        adcq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        adcq	248(%rdx), %r8
        movq	256(%rsi), %rcx
        movq	%r8, 248(%rdi)
        adcq	256(%rdx), %rcx
        movq	264(%rsi), %r8
        movq	%rcx, 256(%rdi)
        adcq	264(%rdx), %r8
        movq	272(%rsi), %rcx
        movq	%r8, 264(%rdi)
        adcq	272(%rdx), %rcx
        movq	280(%rsi), %r8
        movq	%rcx, 272(%rdi)
        adcq	280(%rdx), %r8
        movq	288(%rsi), %rcx
        movq	%r8, 280(%rdi)
        adcq	288(%rdx), %rcx
        movq	296(%rsi), %r8
        movq	%rcx, 288(%rdi)
        adcq	296(%rdx), %r8
        movq	304(%rsi), %rcx
        movq	%r8, 296(%rdi)
        adcq	304(%rdx), %rcx
        movq	312(%rsi), %r8
        movq	%rcx, 304(%rdi)
        adcq	312(%rdx), %r8
        movq	320(%rsi), %rcx
        movq	%r8, 312(%rdi)
        adcq	320(%rdx), %rcx
        movq	328(%rsi), %r8
        movq	%rcx, 320(%rdi)
        adcq	328(%rdx), %r8
        movq	336(%rsi), %rcx
        movq	%r8, 328(%rdi)
        adcq	336(%rdx), %rcx
        movq	344(%rsi), %r8
        movq	%rcx, 336(%rdi)
        adcq	344(%rdx), %r8
        movq	352(%rsi), %rcx
        movq	%r8, 344(%rdi)
        adcq	352(%rdx), %rcx
        movq	360(%rsi), %r8
        movq	%rcx, 352(%rdi)
        adcq	360(%rdx), %r8
        movq	368(%rsi), %rcx
        movq	%r8, 360(%rdi)
        adcq	368(%rdx), %rcx
        movq	376(%rsi), %r8
        movq	%rcx, 368(%rdi)
        adcq	376(%rdx), %r8
        movq	%r8, 376(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_add_48,.-sp_3072_add_48
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_48
.type	sp_3072_mul_48,@function
.align	16
sp_3072_mul_48:
#else
.globl	_sp_3072_mul_48
.p2align	4
_sp_3072_mul_48:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$1192, %rsp
        movq	%rdi, 1152(%rsp)
        movq	%rsi, 1160(%rsp)
        movq	%rdx, 1168(%rsp)
        leaq	768(%rsp), %r10
        leaq	192(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	128(%rsi), %rcx
        movq	%rax, 120(%r10)
        adcq	128(%r12), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%r10)
        adcq	136(%r12), %r8
        movq	144(%rsi), %rax
        movq	%r8, 136(%r10)
        adcq	144(%r12), %rax
        movq	152(%rsi), %rcx
        movq	%rax, 144(%r10)
        adcq	152(%r12), %rcx
        movq	160(%rsi), %r8
        movq	%rcx, 152(%r10)
        adcq	160(%r12), %r8
        movq	168(%rsi), %rax
        movq	%r8, 160(%r10)
        adcq	168(%r12), %rax
        movq	176(%rsi), %rcx
        movq	%rax, 168(%r10)
        adcq	176(%r12), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%r10)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r10)
        adcq	$0, %r13
        movq	%r13, 1176(%rsp)
        leaq	960(%rsp), %r11
        leaq	192(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	128(%rdx), %rcx
        movq	%rax, 120(%r11)
        adcq	128(%r12), %rcx
        movq	136(%rdx), %r8
        movq	%rcx, 128(%r11)
        adcq	136(%r12), %r8
        movq	144(%rdx), %rax
        movq	%r8, 136(%r11)
        adcq	144(%r12), %rax
        movq	152(%rdx), %rcx
        movq	%rax, 144(%r11)
        adcq	152(%r12), %rcx
        movq	160(%rdx), %r8
        movq	%rcx, 152(%r11)
        adcq	160(%r12), %r8
        movq	168(%rdx), %rax
        movq	%r8, 160(%r11)
        adcq	168(%r12), %rax
        movq	176(%rdx), %rcx
        movq	%rax, 168(%r11)
        adcq	176(%r12), %rcx
        movq	184(%rdx), %r8
        movq	%rcx, 176(%r11)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r11)
        adcq	$0, %r14
        movq	%r14, 1184(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_24@plt
#else
        callq	_sp_3072_mul_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        leaq	384(%rsp), %rdi
        addq	$192, %rdx
        addq	$192, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_24@plt
#else
        callq	_sp_3072_mul_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        movq	1152(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_24@plt
#else
        callq	_sp_3072_mul_24
#endif /* __APPLE__ */
        movq	1176(%rsp), %r13
        movq	1184(%rsp), %r14
        movq	1152(%rsp), %r15
        movq	%r13, %r9
        leaq	768(%rsp), %r10
        leaq	960(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$384, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, (%r10)
        movq	%rcx, (%r11)
        movq	8(%r10), %rax
        movq	8(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 8(%r10)
        movq	%rcx, 8(%r11)
        movq	16(%r10), %rax
        movq	16(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 16(%r10)
        movq	%rcx, 16(%r11)
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 24(%r10)
        movq	%rcx, 24(%r11)
        movq	32(%r10), %rax
        movq	32(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 32(%r10)
        movq	%rcx, 32(%r11)
        movq	40(%r10), %rax
        movq	40(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 40(%r10)
        movq	%rcx, 40(%r11)
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 48(%r10)
        movq	%rcx, 48(%r11)
        movq	56(%r10), %rax
        movq	56(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 56(%r10)
        movq	%rcx, 56(%r11)
        movq	64(%r10), %rax
        movq	64(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 64(%r10)
        movq	%rcx, 64(%r11)
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 72(%r10)
        movq	%rcx, 72(%r11)
        movq	80(%r10), %rax
        movq	80(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 80(%r10)
        movq	%rcx, 80(%r11)
        movq	88(%r10), %rax
        movq	88(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 88(%r10)
        movq	%rcx, 88(%r11)
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 96(%r10)
        movq	%rcx, 96(%r11)
        movq	104(%r10), %rax
        movq	104(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 104(%r10)
        movq	%rcx, 104(%r11)
        movq	112(%r10), %rax
        movq	112(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 112(%r10)
        movq	%rcx, 112(%r11)
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 120(%r10)
        movq	%rcx, 120(%r11)
        movq	128(%r10), %rax
        movq	128(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 128(%r10)
        movq	%rcx, 128(%r11)
        movq	136(%r10), %rax
        movq	136(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 136(%r10)
        movq	%rcx, 136(%r11)
        movq	144(%r10), %rax
        movq	144(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 144(%r10)
        movq	%rcx, 144(%r11)
        movq	152(%r10), %rax
        movq	152(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 152(%r10)
        movq	%rcx, 152(%r11)
        movq	160(%r10), %rax
        movq	160(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 160(%r10)
        movq	%rcx, 160(%r11)
        movq	168(%r10), %rax
        movq	168(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 168(%r10)
        movq	%rcx, 168(%r11)
        movq	176(%r10), %rax
        movq	176(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 176(%r10)
        movq	%rcx, 176(%r11)
        movq	184(%r10), %rax
        movq	184(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 184(%r10)
        movq	%rcx, 184(%r11)
        movq	(%r10), %rax
        addq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	%r8, 184(%r15)
        adcq	$0, %r9
        leaq	384(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%r11), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%r11), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%r11), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%r11), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%r11), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%r11), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%r11), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%r11), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%r11), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%r11), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%r11), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%r11), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%r11), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%r11), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%r11), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%r11), %r8
        movq	%r8, 376(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%rdi), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%rdi), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%rdi), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%rdi), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%rdi), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%rdi), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%rdi), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%rdi), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%rdi), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%rdi), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%rdi), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%rdi), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%rdi), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%rdi), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%rdi), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%rdi), %r8
        movq	%r8, 376(%r10)
        sbbq	$0, %r9
        subq	$192, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r10), %r8
        movq	264(%r15), %rax
        movq	%r8, 256(%r15)
        adcq	264(%r10), %rax
        movq	272(%r15), %rcx
        movq	%rax, 264(%r15)
        adcq	272(%r10), %rcx
        movq	280(%r15), %r8
        movq	%rcx, 272(%r15)
        adcq	280(%r10), %r8
        movq	288(%r15), %rax
        movq	%r8, 280(%r15)
        adcq	288(%r10), %rax
        movq	296(%r15), %rcx
        movq	%rax, 288(%r15)
        adcq	296(%r10), %rcx
        movq	304(%r15), %r8
        movq	%rcx, 296(%r15)
        adcq	304(%r10), %r8
        movq	312(%r15), %rax
        movq	%r8, 304(%r15)
        adcq	312(%r10), %rax
        movq	320(%r15), %rcx
        movq	%rax, 312(%r15)
        adcq	320(%r10), %rcx
        movq	328(%r15), %r8
        movq	%rcx, 320(%r15)
        adcq	328(%r10), %r8
        movq	336(%r15), %rax
        movq	%r8, 328(%r15)
        adcq	336(%r10), %rax
        movq	344(%r15), %rcx
        movq	%rax, 336(%r15)
        adcq	344(%r10), %rcx
        movq	352(%r15), %r8
        movq	%rcx, 344(%r15)
        adcq	352(%r10), %r8
        movq	360(%r15), %rax
        movq	%r8, 352(%r15)
        adcq	360(%r10), %rax
        movq	368(%r15), %rcx
        movq	%rax, 360(%r15)
        adcq	368(%r10), %rcx
        movq	376(%r15), %r8
        movq	%rcx, 368(%r15)
        adcq	376(%r10), %r8
        movq	%r8, 376(%r15)
        adcq	$0, %r9
        movq	%r9, 576(%rdi)
        addq	$192, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r11), %rax
        movq	%rax, 192(%r15)
        # Add to zero
        movq	200(%r11), %rax
        adcq	$0, %rax
        movq	208(%r11), %rcx
        movq	%rax, 200(%r15)
        adcq	$0, %rcx
        movq	216(%r11), %r8
        movq	%rcx, 208(%r15)
        adcq	$0, %r8
        movq	224(%r11), %rax
        movq	%r8, 216(%r15)
        adcq	$0, %rax
        movq	232(%r11), %rcx
        movq	%rax, 224(%r15)
        adcq	$0, %rcx
        movq	240(%r11), %r8
        movq	%rcx, 232(%r15)
        adcq	$0, %r8
        movq	248(%r11), %rax
        movq	%r8, 240(%r15)
        adcq	$0, %rax
        movq	256(%r11), %rcx
        movq	%rax, 248(%r15)
        adcq	$0, %rcx
        movq	264(%r11), %r8
        movq	%rcx, 256(%r15)
        adcq	$0, %r8
        movq	272(%r11), %rax
        movq	%r8, 264(%r15)
        adcq	$0, %rax
        movq	280(%r11), %rcx
        movq	%rax, 272(%r15)
        adcq	$0, %rcx
        movq	288(%r11), %r8
        movq	%rcx, 280(%r15)
        adcq	$0, %r8
        movq	296(%r11), %rax
        movq	%r8, 288(%r15)
        adcq	$0, %rax
        movq	304(%r11), %rcx
        movq	%rax, 296(%r15)
        adcq	$0, %rcx
        movq	312(%r11), %r8
        movq	%rcx, 304(%r15)
        adcq	$0, %r8
        movq	320(%r11), %rax
        movq	%r8, 312(%r15)
        adcq	$0, %rax
        movq	328(%r11), %rcx
        movq	%rax, 320(%r15)
        adcq	$0, %rcx
        movq	336(%r11), %r8
        movq	%rcx, 328(%r15)
        adcq	$0, %r8
        movq	344(%r11), %rax
        movq	%r8, 336(%r15)
        adcq	$0, %rax
        movq	352(%r11), %rcx
        movq	%rax, 344(%r15)
        adcq	$0, %rcx
        movq	360(%r11), %r8
        movq	%rcx, 352(%r15)
        adcq	$0, %r8
        movq	368(%r11), %rax
        movq	%r8, 360(%r15)
        adcq	$0, %rax
        movq	376(%r11), %rcx
        movq	%rax, 368(%r15)
        adcq	$0, %rcx
        movq	%rcx, 376(%r15)
        addq	$1192, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_48,.-sp_3072_mul_48
#endif /* __APPLE__ */
/* Add a to a into r. (r = a + a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_dbl_24
.type	sp_3072_dbl_24,@function
.align	16
sp_3072_dbl_24:
#else
.globl	_sp_3072_dbl_24
.p2align	4
_sp_3072_dbl_24:
#endif /* __APPLE__ */
        movq	(%rsi), %rdx
        xorq	%rax, %rax
        addq	%rdx, %rdx
        movq	8(%rsi), %rcx
        movq	%rdx, (%rdi)
        adcq	%rcx, %rcx
        movq	16(%rsi), %rdx
        movq	%rcx, 8(%rdi)
        adcq	%rdx, %rdx
        movq	24(%rsi), %rcx
        movq	%rdx, 16(%rdi)
        adcq	%rcx, %rcx
        movq	32(%rsi), %rdx
        movq	%rcx, 24(%rdi)
        adcq	%rdx, %rdx
        movq	40(%rsi), %rcx
        movq	%rdx, 32(%rdi)
        adcq	%rcx, %rcx
        movq	48(%rsi), %rdx
        movq	%rcx, 40(%rdi)
        adcq	%rdx, %rdx
        movq	56(%rsi), %rcx
        movq	%rdx, 48(%rdi)
        adcq	%rcx, %rcx
        movq	64(%rsi), %rdx
        movq	%rcx, 56(%rdi)
        adcq	%rdx, %rdx
        movq	72(%rsi), %rcx
        movq	%rdx, 64(%rdi)
        adcq	%rcx, %rcx
        movq	80(%rsi), %rdx
        movq	%rcx, 72(%rdi)
        adcq	%rdx, %rdx
        movq	88(%rsi), %rcx
        movq	%rdx, 80(%rdi)
        adcq	%rcx, %rcx
        movq	96(%rsi), %rdx
        movq	%rcx, 88(%rdi)
        adcq	%rdx, %rdx
        movq	104(%rsi), %rcx
        movq	%rdx, 96(%rdi)
        adcq	%rcx, %rcx
        movq	112(%rsi), %rdx
        movq	%rcx, 104(%rdi)
        adcq	%rdx, %rdx
        movq	120(%rsi), %rcx
        movq	%rdx, 112(%rdi)
        adcq	%rcx, %rcx
        movq	128(%rsi), %rdx
        movq	%rcx, 120(%rdi)
        adcq	%rdx, %rdx
        movq	136(%rsi), %rcx
        movq	%rdx, 128(%rdi)
        adcq	%rcx, %rcx
        movq	144(%rsi), %rdx
        movq	%rcx, 136(%rdi)
        adcq	%rdx, %rdx
        movq	152(%rsi), %rcx
        movq	%rdx, 144(%rdi)
        adcq	%rcx, %rcx
        movq	160(%rsi), %rdx
        movq	%rcx, 152(%rdi)
        adcq	%rdx, %rdx
        movq	168(%rsi), %rcx
        movq	%rdx, 160(%rdi)
        adcq	%rcx, %rcx
        movq	176(%rsi), %rdx
        movq	%rcx, 168(%rdi)
        adcq	%rdx, %rdx
        movq	184(%rsi), %rcx
        movq	%rdx, 176(%rdi)
        adcq	%rcx, %rcx
        movq	%rcx, 184(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_dbl_24,.-sp_3072_dbl_24
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sqr_48
.type	sp_3072_sqr_48,@function
.align	16
sp_3072_sqr_48:
#else
.globl	_sp_3072_sqr_48
.p2align	4
_sp_3072_sqr_48:
#endif /* __APPLE__ */
        subq	$984, %rsp
        movq	%rdi, 960(%rsp)
        movq	%rsi, 968(%rsp)
        leaq	768(%rsp), %r8
        leaq	192(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        adcq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        adcq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        adcq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        adcq	120(%r9), %rax
        movq	128(%rsi), %rdx
        movq	%rax, 120(%r8)
        adcq	128(%r9), %rdx
        movq	136(%rsi), %rax
        movq	%rdx, 128(%r8)
        adcq	136(%r9), %rax
        movq	144(%rsi), %rdx
        movq	%rax, 136(%r8)
        adcq	144(%r9), %rdx
        movq	152(%rsi), %rax
        movq	%rdx, 144(%r8)
        adcq	152(%r9), %rax
        movq	160(%rsi), %rdx
        movq	%rax, 152(%r8)
        adcq	160(%r9), %rdx
        movq	168(%rsi), %rax
        movq	%rdx, 160(%r8)
        adcq	168(%r9), %rax
        movq	176(%rsi), %rdx
        movq	%rax, 168(%r8)
        adcq	176(%r9), %rdx
        movq	184(%rsi), %rax
        movq	%rdx, 176(%r8)
        adcq	184(%r9), %rax
        movq	%rax, 184(%r8)
        adcq	$0, %rcx
        movq	%rcx, 976(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_24@plt
#else
        callq	_sp_3072_sqr_24
#endif /* __APPLE__ */
        movq	968(%rsp), %rsi
        leaq	384(%rsp), %rdi
        addq	$192, %rsi
#ifndef __APPLE__
        callq	sp_3072_sqr_24@plt
#else
        callq	_sp_3072_sqr_24
#endif /* __APPLE__ */
        movq	968(%rsp), %rsi
        movq	960(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_24@plt
#else
        callq	_sp_3072_sqr_24
#endif /* __APPLE__ */
        movq	976(%rsp), %r10
        movq	%rdi, %r9
        leaq	768(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        addq	$384, %r9
        movq	(%r8), %rdx
        movq	8(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, (%r9)
        movq	%rax, 8(%r9)
        movq	16(%r8), %rdx
        movq	24(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 16(%r9)
        movq	%rax, 24(%r9)
        movq	32(%r8), %rdx
        movq	40(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 32(%r9)
        movq	%rax, 40(%r9)
        movq	48(%r8), %rdx
        movq	56(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 48(%r9)
        movq	%rax, 56(%r9)
        movq	64(%r8), %rdx
        movq	72(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 64(%r9)
        movq	%rax, 72(%r9)
        movq	80(%r8), %rdx
        movq	88(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 80(%r9)
        movq	%rax, 88(%r9)
        movq	96(%r8), %rdx
        movq	104(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 96(%r9)
        movq	%rax, 104(%r9)
        movq	112(%r8), %rdx
        movq	120(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 112(%r9)
        movq	%rax, 120(%r9)
        movq	128(%r8), %rdx
        movq	136(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 128(%r9)
        movq	%rax, 136(%r9)
        movq	144(%r8), %rdx
        movq	152(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 144(%r9)
        movq	%rax, 152(%r9)
        movq	160(%r8), %rdx
        movq	168(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 160(%r9)
        movq	%rax, 168(%r9)
        movq	176(%r8), %rdx
        movq	184(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 176(%r9)
        movq	%rax, 184(%r9)
        movq	(%r9), %rdx
        addq	%rdx, %rdx
        movq	8(%r9), %rax
        movq	%rdx, (%r9)
        adcq	%rax, %rax
        movq	16(%r9), %rdx
        movq	%rax, 8(%r9)
        adcq	%rdx, %rdx
        movq	24(%r9), %rax
        movq	%rdx, 16(%r9)
        adcq	%rax, %rax
        movq	32(%r9), %rdx
        movq	%rax, 24(%r9)
        adcq	%rdx, %rdx
        movq	40(%r9), %rax
        movq	%rdx, 32(%r9)
        adcq	%rax, %rax
        movq	48(%r9), %rdx
        movq	%rax, 40(%r9)
        adcq	%rdx, %rdx
        movq	56(%r9), %rax
        movq	%rdx, 48(%r9)
        adcq	%rax, %rax
        movq	64(%r9), %rdx
        movq	%rax, 56(%r9)
        adcq	%rdx, %rdx
        movq	72(%r9), %rax
        movq	%rdx, 64(%r9)
        adcq	%rax, %rax
        movq	80(%r9), %rdx
        movq	%rax, 72(%r9)
        adcq	%rdx, %rdx
        movq	88(%r9), %rax
        movq	%rdx, 80(%r9)
        adcq	%rax, %rax
        movq	96(%r9), %rdx
        movq	%rax, 88(%r9)
        adcq	%rdx, %rdx
        movq	104(%r9), %rax
        movq	%rdx, 96(%r9)
        adcq	%rax, %rax
        movq	112(%r9), %rdx
        movq	%rax, 104(%r9)
        adcq	%rdx, %rdx
        movq	120(%r9), %rax
        movq	%rdx, 112(%r9)
        adcq	%rax, %rax
        movq	128(%r9), %rdx
        movq	%rax, 120(%r9)
        adcq	%rdx, %rdx
        movq	136(%r9), %rax
        movq	%rdx, 128(%r9)
        adcq	%rax, %rax
        movq	144(%r9), %rdx
        movq	%rax, 136(%r9)
        adcq	%rdx, %rdx
        movq	152(%r9), %rax
        movq	%rdx, 144(%r9)
        adcq	%rax, %rax
        movq	160(%r9), %rdx
        movq	%rax, 152(%r9)
        adcq	%rdx, %rdx
        movq	168(%r9), %rax
        movq	%rdx, 160(%r9)
        adcq	%rax, %rax
        movq	176(%r9), %rdx
        movq	%rax, 168(%r9)
        adcq	%rdx, %rdx
        movq	184(%r9), %rax
        movq	%rdx, 176(%r9)
        adcq	%rax, %rax
        movq	%rax, 184(%r9)
        adcq	$0, %rcx
        leaq	384(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rsi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rsi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rsi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rsi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rsi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rsi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rsi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rsi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rsi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rsi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rsi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rsi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rsi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rsi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rsi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rsi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rsi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rsi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rsi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rsi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rsi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rsi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rsi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rsi), %rax
        movq	%rax, 376(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rdi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rdi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rdi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rdi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rdi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rdi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rdi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rdi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rdi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rdi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rdi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rdi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rdi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rdi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rdi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rdi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rdi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rdi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rdi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rdi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rdi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rdi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rdi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rdi), %rax
        movq	%rax, 376(%r8)
        sbbq	$0, %rcx
        subq	$192, %r9
        # Add in place
        movq	(%r9), %rdx
        addq	(%r8), %rdx
        movq	8(%r9), %rax
        movq	%rdx, (%r9)
        adcq	8(%r8), %rax
        movq	16(%r9), %rdx
        movq	%rax, 8(%r9)
        adcq	16(%r8), %rdx
        movq	24(%r9), %rax
        movq	%rdx, 16(%r9)
        adcq	24(%r8), %rax
        movq	32(%r9), %rdx
        movq	%rax, 24(%r9)
        adcq	32(%r8), %rdx
        movq	40(%r9), %rax
        movq	%rdx, 32(%r9)
        adcq	40(%r8), %rax
        movq	48(%r9), %rdx
        movq	%rax, 40(%r9)
        adcq	48(%r8), %rdx
        movq	56(%r9), %rax
        movq	%rdx, 48(%r9)
        adcq	56(%r8), %rax
        movq	64(%r9), %rdx
        movq	%rax, 56(%r9)
        adcq	64(%r8), %rdx
        movq	72(%r9), %rax
        movq	%rdx, 64(%r9)
        adcq	72(%r8), %rax
        movq	80(%r9), %rdx
        movq	%rax, 72(%r9)
        adcq	80(%r8), %rdx
        movq	88(%r9), %rax
        movq	%rdx, 80(%r9)
        adcq	88(%r8), %rax
        movq	96(%r9), %rdx
        movq	%rax, 88(%r9)
        adcq	96(%r8), %rdx
        movq	104(%r9), %rax
        movq	%rdx, 96(%r9)
        adcq	104(%r8), %rax
        movq	112(%r9), %rdx
        movq	%rax, 104(%r9)
        adcq	112(%r8), %rdx
        movq	120(%r9), %rax
        movq	%rdx, 112(%r9)
        adcq	120(%r8), %rax
        movq	128(%r9), %rdx
        movq	%rax, 120(%r9)
        adcq	128(%r8), %rdx
        movq	136(%r9), %rax
        movq	%rdx, 128(%r9)
        adcq	136(%r8), %rax
        movq	144(%r9), %rdx
        movq	%rax, 136(%r9)
        adcq	144(%r8), %rdx
        movq	152(%r9), %rax
        movq	%rdx, 144(%r9)
        adcq	152(%r8), %rax
        movq	160(%r9), %rdx
        movq	%rax, 152(%r9)
        adcq	160(%r8), %rdx
        movq	168(%r9), %rax
        movq	%rdx, 160(%r9)
        adcq	168(%r8), %rax
        movq	176(%r9), %rdx
        movq	%rax, 168(%r9)
        adcq	176(%r8), %rdx
        movq	184(%r9), %rax
        movq	%rdx, 176(%r9)
        adcq	184(%r8), %rax
        movq	192(%r9), %rdx
        movq	%rax, 184(%r9)
        adcq	192(%r8), %rdx
        movq	200(%r9), %rax
        movq	%rdx, 192(%r9)
        adcq	200(%r8), %rax
        movq	208(%r9), %rdx
        movq	%rax, 200(%r9)
        adcq	208(%r8), %rdx
        movq	216(%r9), %rax
        movq	%rdx, 208(%r9)
        adcq	216(%r8), %rax
        movq	224(%r9), %rdx
        movq	%rax, 216(%r9)
        adcq	224(%r8), %rdx
        movq	232(%r9), %rax
        movq	%rdx, 224(%r9)
        adcq	232(%r8), %rax
        movq	240(%r9), %rdx
        movq	%rax, 232(%r9)
        adcq	240(%r8), %rdx
        movq	248(%r9), %rax
        movq	%rdx, 240(%r9)
        adcq	248(%r8), %rax
        movq	256(%r9), %rdx
        movq	%rax, 248(%r9)
        adcq	256(%r8), %rdx
        movq	264(%r9), %rax
        movq	%rdx, 256(%r9)
        adcq	264(%r8), %rax
        movq	272(%r9), %rdx
        movq	%rax, 264(%r9)
        adcq	272(%r8), %rdx
        movq	280(%r9), %rax
        movq	%rdx, 272(%r9)
        adcq	280(%r8), %rax
        movq	288(%r9), %rdx
        movq	%rax, 280(%r9)
        adcq	288(%r8), %rdx
        movq	296(%r9), %rax
        movq	%rdx, 288(%r9)
        adcq	296(%r8), %rax
        movq	304(%r9), %rdx
        movq	%rax, 296(%r9)
        adcq	304(%r8), %rdx
        movq	312(%r9), %rax
        movq	%rdx, 304(%r9)
        adcq	312(%r8), %rax
        movq	320(%r9), %rdx
        movq	%rax, 312(%r9)
        adcq	320(%r8), %rdx
        movq	328(%r9), %rax
        movq	%rdx, 320(%r9)
        adcq	328(%r8), %rax
        movq	336(%r9), %rdx
        movq	%rax, 328(%r9)
        adcq	336(%r8), %rdx
        movq	344(%r9), %rax
        movq	%rdx, 336(%r9)
        adcq	344(%r8), %rax
        movq	352(%r9), %rdx
        movq	%rax, 344(%r9)
        adcq	352(%r8), %rdx
        movq	360(%r9), %rax
        movq	%rdx, 352(%r9)
        adcq	360(%r8), %rax
        movq	368(%r9), %rdx
        movq	%rax, 360(%r9)
        adcq	368(%r8), %rdx
        movq	376(%r9), %rax
        movq	%rdx, 368(%r9)
        adcq	376(%r8), %rax
        movq	%rax, 376(%r9)
        adcq	$0, %rcx
        movq	%rcx, 576(%rdi)
        # Add in place
        movq	192(%r9), %rdx
        addq	(%rsi), %rdx
        movq	200(%r9), %rax
        movq	%rdx, 192(%r9)
        adcq	8(%rsi), %rax
        movq	208(%r9), %rdx
        movq	%rax, 200(%r9)
        adcq	16(%rsi), %rdx
        movq	216(%r9), %rax
        movq	%rdx, 208(%r9)
        adcq	24(%rsi), %rax
        movq	224(%r9), %rdx
        movq	%rax, 216(%r9)
        adcq	32(%rsi), %rdx
        movq	232(%r9), %rax
        movq	%rdx, 224(%r9)
        adcq	40(%rsi), %rax
        movq	240(%r9), %rdx
        movq	%rax, 232(%r9)
        adcq	48(%rsi), %rdx
        movq	248(%r9), %rax
        movq	%rdx, 240(%r9)
        adcq	56(%rsi), %rax
        movq	256(%r9), %rdx
        movq	%rax, 248(%r9)
        adcq	64(%rsi), %rdx
        movq	264(%r9), %rax
        movq	%rdx, 256(%r9)
        adcq	72(%rsi), %rax
        movq	272(%r9), %rdx
        movq	%rax, 264(%r9)
        adcq	80(%rsi), %rdx
        movq	280(%r9), %rax
        movq	%rdx, 272(%r9)
        adcq	88(%rsi), %rax
        movq	288(%r9), %rdx
        movq	%rax, 280(%r9)
        adcq	96(%rsi), %rdx
        movq	296(%r9), %rax
        movq	%rdx, 288(%r9)
        adcq	104(%rsi), %rax
        movq	304(%r9), %rdx
        movq	%rax, 296(%r9)
        adcq	112(%rsi), %rdx
        movq	312(%r9), %rax
        movq	%rdx, 304(%r9)
        adcq	120(%rsi), %rax
        movq	320(%r9), %rdx
        movq	%rax, 312(%r9)
        adcq	128(%rsi), %rdx
        movq	328(%r9), %rax
        movq	%rdx, 320(%r9)
        adcq	136(%rsi), %rax
        movq	336(%r9), %rdx
        movq	%rax, 328(%r9)
        adcq	144(%rsi), %rdx
        movq	344(%r9), %rax
        movq	%rdx, 336(%r9)
        adcq	152(%rsi), %rax
        movq	352(%r9), %rdx
        movq	%rax, 344(%r9)
        adcq	160(%rsi), %rdx
        movq	360(%r9), %rax
        movq	%rdx, 352(%r9)
        adcq	168(%rsi), %rax
        movq	368(%r9), %rdx
        movq	%rax, 360(%r9)
        adcq	176(%rsi), %rdx
        movq	376(%r9), %rax
        movq	%rdx, 368(%r9)
        adcq	184(%rsi), %rax
        movq	384(%r9), %rdx
        movq	%rax, 376(%r9)
        adcq	192(%rsi), %rdx
        movq	%rdx, 384(%r9)
        # Add to zero
        movq	200(%rsi), %rdx
        adcq	$0, %rdx
        movq	208(%rsi), %rax
        movq	%rdx, 392(%r9)
        adcq	$0, %rax
        movq	216(%rsi), %rdx
        movq	%rax, 400(%r9)
        adcq	$0, %rdx
        movq	224(%rsi), %rax
        movq	%rdx, 408(%r9)
        adcq	$0, %rax
        movq	232(%rsi), %rdx
        movq	%rax, 416(%r9)
        adcq	$0, %rdx
        movq	240(%rsi), %rax
        movq	%rdx, 424(%r9)
        adcq	$0, %rax
        movq	248(%rsi), %rdx
        movq	%rax, 432(%r9)
        adcq	$0, %rdx
        movq	256(%rsi), %rax
        movq	%rdx, 440(%r9)
        adcq	$0, %rax
        movq	264(%rsi), %rdx
        movq	%rax, 448(%r9)
        adcq	$0, %rdx
        movq	272(%rsi), %rax
        movq	%rdx, 456(%r9)
        adcq	$0, %rax
        movq	280(%rsi), %rdx
        movq	%rax, 464(%r9)
        adcq	$0, %rdx
        movq	288(%rsi), %rax
        movq	%rdx, 472(%r9)
        adcq	$0, %rax
        movq	296(%rsi), %rdx
        movq	%rax, 480(%r9)
        adcq	$0, %rdx
        movq	304(%rsi), %rax
        movq	%rdx, 488(%r9)
        adcq	$0, %rax
        movq	312(%rsi), %rdx
        movq	%rax, 496(%r9)
        adcq	$0, %rdx
        movq	320(%rsi), %rax
        movq	%rdx, 504(%r9)
        adcq	$0, %rax
        movq	328(%rsi), %rdx
        movq	%rax, 512(%r9)
        adcq	$0, %rdx
        movq	336(%rsi), %rax
        movq	%rdx, 520(%r9)
        adcq	$0, %rax
        movq	344(%rsi), %rdx
        movq	%rax, 528(%r9)
        adcq	$0, %rdx
        movq	352(%rsi), %rax
        movq	%rdx, 536(%r9)
        adcq	$0, %rax
        movq	360(%rsi), %rdx
        movq	%rax, 544(%r9)
        adcq	$0, %rdx
        movq	368(%rsi), %rax
        movq	%rdx, 552(%r9)
        adcq	$0, %rax
        movq	376(%rsi), %rdx
        movq	%rax, 560(%r9)
        adcq	$0, %rdx
        movq	%rdx, 568(%r9)
        addq	$984, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_48,.-sp_3072_sqr_48
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_avx2_48
.type	sp_3072_mul_avx2_48,@function
.align	16
sp_3072_mul_avx2_48:
#else
.globl	_sp_3072_mul_avx2_48
.p2align	4
_sp_3072_mul_avx2_48:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$1192, %rsp
        movq	%rdi, 1152(%rsp)
        movq	%rsi, 1160(%rsp)
        movq	%rdx, 1168(%rsp)
        leaq	768(%rsp), %r10
        leaq	192(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	128(%rsi), %rcx
        movq	%rax, 120(%r10)
        adcq	128(%r12), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%r10)
        adcq	136(%r12), %r8
        movq	144(%rsi), %rax
        movq	%r8, 136(%r10)
        adcq	144(%r12), %rax
        movq	152(%rsi), %rcx
        movq	%rax, 144(%r10)
        adcq	152(%r12), %rcx
        movq	160(%rsi), %r8
        movq	%rcx, 152(%r10)
        adcq	160(%r12), %r8
        movq	168(%rsi), %rax
        movq	%r8, 160(%r10)
        adcq	168(%r12), %rax
        movq	176(%rsi), %rcx
        movq	%rax, 168(%r10)
        adcq	176(%r12), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%r10)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r10)
        adcq	$0, %r13
        movq	%r13, 1176(%rsp)
        leaq	960(%rsp), %r11
        leaq	192(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	128(%rdx), %rcx
        movq	%rax, 120(%r11)
        adcq	128(%r12), %rcx
        movq	136(%rdx), %r8
        movq	%rcx, 128(%r11)
        adcq	136(%r12), %r8
        movq	144(%rdx), %rax
        movq	%r8, 136(%r11)
        adcq	144(%r12), %rax
        movq	152(%rdx), %rcx
        movq	%rax, 144(%r11)
        adcq	152(%r12), %rcx
        movq	160(%rdx), %r8
        movq	%rcx, 152(%r11)
        adcq	160(%r12), %r8
        movq	168(%rdx), %rax
        movq	%r8, 160(%r11)
        adcq	168(%r12), %rax
        movq	176(%rdx), %rcx
        movq	%rax, 168(%r11)
        adcq	176(%r12), %rcx
        movq	184(%rdx), %r8
        movq	%rcx, 176(%r11)
        adcq	184(%r12), %r8
        movq	%r8, 184(%r11)
        adcq	$0, %r14
        movq	%r14, 1184(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_24@plt
#else
        callq	_sp_3072_mul_avx2_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        leaq	384(%rsp), %rdi
        addq	$192, %rdx
        addq	$192, %rsi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_24@plt
#else
        callq	_sp_3072_mul_avx2_24
#endif /* __APPLE__ */
        movq	1168(%rsp), %rdx
        movq	1160(%rsp), %rsi
        movq	1152(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_mul_avx2_24@plt
#else
        callq	_sp_3072_mul_avx2_24
#endif /* __APPLE__ */
        movq	1176(%rsp), %r13
        movq	1184(%rsp), %r14
        movq	1152(%rsp), %r15
        movq	%r13, %r9
        leaq	768(%rsp), %r10
        leaq	960(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$384, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        addq	%rcx, %rax
        movq	8(%r10), %rcx
        movq	8(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, (%r15)
        adcq	%r8, %rcx
        movq	16(%r10), %r8
        movq	16(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 8(%r15)
        adcq	%rax, %r8
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 16(%r15)
        adcq	%rcx, %rax
        movq	32(%r10), %rcx
        movq	32(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 24(%r15)
        adcq	%r8, %rcx
        movq	40(%r10), %r8
        movq	40(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 32(%r15)
        adcq	%rax, %r8
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 40(%r15)
        adcq	%rcx, %rax
        movq	56(%r10), %rcx
        movq	56(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 48(%r15)
        adcq	%r8, %rcx
        movq	64(%r10), %r8
        movq	64(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 56(%r15)
        adcq	%rax, %r8
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 64(%r15)
        adcq	%rcx, %rax
        movq	80(%r10), %rcx
        movq	80(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 72(%r15)
        adcq	%r8, %rcx
        movq	88(%r10), %r8
        movq	88(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 80(%r15)
        adcq	%rax, %r8
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 88(%r15)
        adcq	%rcx, %rax
        movq	104(%r10), %rcx
        movq	104(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 96(%r15)
        adcq	%r8, %rcx
        movq	112(%r10), %r8
        movq	112(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 104(%r15)
        adcq	%rax, %r8
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 112(%r15)
        adcq	%rcx, %rax
        movq	128(%r10), %rcx
        movq	128(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 120(%r15)
        adcq	%r8, %rcx
        movq	136(%r10), %r8
        movq	136(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 128(%r15)
        adcq	%rax, %r8
        movq	144(%r10), %rax
        movq	144(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 136(%r15)
        adcq	%rcx, %rax
        movq	152(%r10), %rcx
        movq	152(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 144(%r15)
        adcq	%r8, %rcx
        movq	160(%r10), %r8
        movq	160(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 152(%r15)
        adcq	%rax, %r8
        movq	168(%r10), %rax
        movq	168(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 160(%r15)
        adcq	%rcx, %rax
        movq	176(%r10), %rcx
        movq	176(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 168(%r15)
        adcq	%r8, %rcx
        movq	184(%r10), %r8
        movq	184(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 176(%r15)
        adcq	%rax, %r8
        movq	%r8, 184(%r15)
        adcq	$0, %r9
        leaq	384(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%r11), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%r11), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%r11), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%r11), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%r11), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%r11), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%r11), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%r11), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%r11), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%r11), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%r11), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%r11), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%r11), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%r11), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%r11), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%r11), %r8
        movq	%r8, 376(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%rdi), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%rdi), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%rdi), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%rdi), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%rdi), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%rdi), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%rdi), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%rdi), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%rdi), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%rdi), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%rdi), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%rdi), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%rdi), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%rdi), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%rdi), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%rdi), %r8
        movq	%r8, 376(%r10)
        sbbq	$0, %r9
        subq	$192, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r10), %r8
        movq	264(%r15), %rax
        movq	%r8, 256(%r15)
        adcq	264(%r10), %rax
        movq	272(%r15), %rcx
        movq	%rax, 264(%r15)
        adcq	272(%r10), %rcx
        movq	280(%r15), %r8
        movq	%rcx, 272(%r15)
        adcq	280(%r10), %r8
        movq	288(%r15), %rax
        movq	%r8, 280(%r15)
        adcq	288(%r10), %rax
        movq	296(%r15), %rcx
        movq	%rax, 288(%r15)
        adcq	296(%r10), %rcx
        movq	304(%r15), %r8
        movq	%rcx, 296(%r15)
        adcq	304(%r10), %r8
        movq	312(%r15), %rax
        movq	%r8, 304(%r15)
        adcq	312(%r10), %rax
        movq	320(%r15), %rcx
        movq	%rax, 312(%r15)
        adcq	320(%r10), %rcx
        movq	328(%r15), %r8
        movq	%rcx, 320(%r15)
        adcq	328(%r10), %r8
        movq	336(%r15), %rax
        movq	%r8, 328(%r15)
        adcq	336(%r10), %rax
        movq	344(%r15), %rcx
        movq	%rax, 336(%r15)
        adcq	344(%r10), %rcx
        movq	352(%r15), %r8
        movq	%rcx, 344(%r15)
        adcq	352(%r10), %r8
        movq	360(%r15), %rax
        movq	%r8, 352(%r15)
        adcq	360(%r10), %rax
        movq	368(%r15), %rcx
        movq	%rax, 360(%r15)
        adcq	368(%r10), %rcx
        movq	376(%r15), %r8
        movq	%rcx, 368(%r15)
        adcq	376(%r10), %r8
        movq	%r8, 376(%r15)
        adcq	$0, %r9
        movq	%r9, 576(%rdi)
        addq	$192, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r11), %rax
        movq	%rax, 192(%r15)
        # Add to zero
        movq	200(%r11), %rax
        adcq	$0, %rax
        movq	208(%r11), %rcx
        movq	%rax, 200(%r15)
        adcq	$0, %rcx
        movq	216(%r11), %r8
        movq	%rcx, 208(%r15)
        adcq	$0, %r8
        movq	224(%r11), %rax
        movq	%r8, 216(%r15)
        adcq	$0, %rax
        movq	232(%r11), %rcx
        movq	%rax, 224(%r15)
        adcq	$0, %rcx
        movq	240(%r11), %r8
        movq	%rcx, 232(%r15)
        adcq	$0, %r8
        movq	248(%r11), %rax
        movq	%r8, 240(%r15)
        adcq	$0, %rax
        movq	256(%r11), %rcx
        movq	%rax, 248(%r15)
        adcq	$0, %rcx
        movq	264(%r11), %r8
        movq	%rcx, 256(%r15)
        adcq	$0, %r8
        movq	272(%r11), %rax
        movq	%r8, 264(%r15)
        adcq	$0, %rax
        movq	280(%r11), %rcx
        movq	%rax, 272(%r15)
        adcq	$0, %rcx
        movq	288(%r11), %r8
        movq	%rcx, 280(%r15)
        adcq	$0, %r8
        movq	296(%r11), %rax
        movq	%r8, 288(%r15)
        adcq	$0, %rax
        movq	304(%r11), %rcx
        movq	%rax, 296(%r15)
        adcq	$0, %rcx
        movq	312(%r11), %r8
        movq	%rcx, 304(%r15)
        adcq	$0, %r8
        movq	320(%r11), %rax
        movq	%r8, 312(%r15)
        adcq	$0, %rax
        movq	328(%r11), %rcx
        movq	%rax, 320(%r15)
        adcq	$0, %rcx
        movq	336(%r11), %r8
        movq	%rcx, 328(%r15)
        adcq	$0, %r8
        movq	344(%r11), %rax
        movq	%r8, 336(%r15)
        adcq	$0, %rax
        movq	352(%r11), %rcx
        movq	%rax, 344(%r15)
        adcq	$0, %rcx
        movq	360(%r11), %r8
        movq	%rcx, 352(%r15)
        adcq	$0, %r8
        movq	368(%r11), %rax
        movq	%r8, 360(%r15)
        adcq	$0, %rax
        movq	376(%r11), %rcx
        movq	%rax, 368(%r15)
        adcq	$0, %rcx
        movq	%rcx, 376(%r15)
        addq	$1192, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_avx2_48,.-sp_3072_mul_avx2_48
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sqr_avx2_48
.type	sp_3072_sqr_avx2_48,@function
.align	16
sp_3072_sqr_avx2_48:
#else
.globl	_sp_3072_sqr_avx2_48
.p2align	4
_sp_3072_sqr_avx2_48:
#endif /* __APPLE__ */
        subq	$984, %rsp
        movq	%rdi, 960(%rsp)
        movq	%rsi, 968(%rsp)
        leaq	768(%rsp), %r8
        leaq	192(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        adcq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        adcq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        adcq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        adcq	120(%r9), %rax
        movq	128(%rsi), %rdx
        movq	%rax, 120(%r8)
        adcq	128(%r9), %rdx
        movq	136(%rsi), %rax
        movq	%rdx, 128(%r8)
        adcq	136(%r9), %rax
        movq	144(%rsi), %rdx
        movq	%rax, 136(%r8)
        adcq	144(%r9), %rdx
        movq	152(%rsi), %rax
        movq	%rdx, 144(%r8)
        adcq	152(%r9), %rax
        movq	160(%rsi), %rdx
        movq	%rax, 152(%r8)
        adcq	160(%r9), %rdx
        movq	168(%rsi), %rax
        movq	%rdx, 160(%r8)
        adcq	168(%r9), %rax
        movq	176(%rsi), %rdx
        movq	%rax, 168(%r8)
        adcq	176(%r9), %rdx
        movq	184(%rsi), %rax
        movq	%rdx, 176(%r8)
        adcq	184(%r9), %rax
        movq	%rax, 184(%r8)
        adcq	$0, %rcx
        movq	%rcx, 976(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_24@plt
#else
        callq	_sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
        movq	968(%rsp), %rsi
        leaq	384(%rsp), %rdi
        addq	$192, %rsi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_24@plt
#else
        callq	_sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
        movq	968(%rsp), %rsi
        movq	960(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_3072_sqr_avx2_24@plt
#else
        callq	_sp_3072_sqr_avx2_24
#endif /* __APPLE__ */
        movq	976(%rsp), %r10
        movq	%rdi, %r9
        leaq	768(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        addq	$384, %r9
        movq	(%r8), %rdx
        pextq	%r10, %rdx, %rdx
        addq	%rdx, %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r9)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r9)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	%rax, 184(%r9)
        adcq	$0, %rcx
        leaq	384(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rsi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rsi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rsi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rsi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rsi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rsi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rsi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rsi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rsi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rsi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rsi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rsi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rsi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rsi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rsi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rsi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rsi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rsi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rsi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rsi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rsi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rsi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rsi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rsi), %rax
        movq	%rax, 376(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rdi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rdi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rdi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rdi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rdi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rdi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rdi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rdi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rdi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rdi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rdi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rdi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rdi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rdi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rdi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rdi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rdi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rdi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rdi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rdi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rdi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rdi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rdi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rdi), %rax
        movq	%rax, 376(%r8)
        sbbq	$0, %rcx
        subq	$192, %r9
        # Add in place
        movq	(%r9), %rdx
        addq	(%r8), %rdx
        movq	8(%r9), %rax
        movq	%rdx, (%r9)
        adcq	8(%r8), %rax
        movq	16(%r9), %rdx
        movq	%rax, 8(%r9)
        adcq	16(%r8), %rdx
        movq	24(%r9), %rax
        movq	%rdx, 16(%r9)
        adcq	24(%r8), %rax
        movq	32(%r9), %rdx
        movq	%rax, 24(%r9)
        adcq	32(%r8), %rdx
        movq	40(%r9), %rax
        movq	%rdx, 32(%r9)
        adcq	40(%r8), %rax
        movq	48(%r9), %rdx
        movq	%rax, 40(%r9)
        adcq	48(%r8), %rdx
        movq	56(%r9), %rax
        movq	%rdx, 48(%r9)
        adcq	56(%r8), %rax
        movq	64(%r9), %rdx
        movq	%rax, 56(%r9)
        adcq	64(%r8), %rdx
        movq	72(%r9), %rax
        movq	%rdx, 64(%r9)
        adcq	72(%r8), %rax
        movq	80(%r9), %rdx
        movq	%rax, 72(%r9)
        adcq	80(%r8), %rdx
        movq	88(%r9), %rax
        movq	%rdx, 80(%r9)
        adcq	88(%r8), %rax
        movq	96(%r9), %rdx
        movq	%rax, 88(%r9)
        adcq	96(%r8), %rdx
        movq	104(%r9), %rax
        movq	%rdx, 96(%r9)
        adcq	104(%r8), %rax
        movq	112(%r9), %rdx
        movq	%rax, 104(%r9)
        adcq	112(%r8), %rdx
        movq	120(%r9), %rax
        movq	%rdx, 112(%r9)
        adcq	120(%r8), %rax
        movq	128(%r9), %rdx
        movq	%rax, 120(%r9)
        adcq	128(%r8), %rdx
        movq	136(%r9), %rax
        movq	%rdx, 128(%r9)
        adcq	136(%r8), %rax
        movq	144(%r9), %rdx
        movq	%rax, 136(%r9)
        adcq	144(%r8), %rdx
        movq	152(%r9), %rax
        movq	%rdx, 144(%r9)
        adcq	152(%r8), %rax
        movq	160(%r9), %rdx
        movq	%rax, 152(%r9)
        adcq	160(%r8), %rdx
        movq	168(%r9), %rax
        movq	%rdx, 160(%r9)
        adcq	168(%r8), %rax
        movq	176(%r9), %rdx
        movq	%rax, 168(%r9)
        adcq	176(%r8), %rdx
        movq	184(%r9), %rax
        movq	%rdx, 176(%r9)
        adcq	184(%r8), %rax
        movq	192(%r9), %rdx
        movq	%rax, 184(%r9)
        adcq	192(%r8), %rdx
        movq	200(%r9), %rax
        movq	%rdx, 192(%r9)
        adcq	200(%r8), %rax
        movq	208(%r9), %rdx
        movq	%rax, 200(%r9)
        adcq	208(%r8), %rdx
        movq	216(%r9), %rax
        movq	%rdx, 208(%r9)
        adcq	216(%r8), %rax
        movq	224(%r9), %rdx
        movq	%rax, 216(%r9)
        adcq	224(%r8), %rdx
        movq	232(%r9), %rax
        movq	%rdx, 224(%r9)
        adcq	232(%r8), %rax
        movq	240(%r9), %rdx
        movq	%rax, 232(%r9)
        adcq	240(%r8), %rdx
        movq	248(%r9), %rax
        movq	%rdx, 240(%r9)
        adcq	248(%r8), %rax
        movq	256(%r9), %rdx
        movq	%rax, 248(%r9)
        adcq	256(%r8), %rdx
        movq	264(%r9), %rax
        movq	%rdx, 256(%r9)
        adcq	264(%r8), %rax
        movq	272(%r9), %rdx
        movq	%rax, 264(%r9)
        adcq	272(%r8), %rdx
        movq	280(%r9), %rax
        movq	%rdx, 272(%r9)
        adcq	280(%r8), %rax
        movq	288(%r9), %rdx
        movq	%rax, 280(%r9)
        adcq	288(%r8), %rdx
        movq	296(%r9), %rax
        movq	%rdx, 288(%r9)
        adcq	296(%r8), %rax
        movq	304(%r9), %rdx
        movq	%rax, 296(%r9)
        adcq	304(%r8), %rdx
        movq	312(%r9), %rax
        movq	%rdx, 304(%r9)
        adcq	312(%r8), %rax
        movq	320(%r9), %rdx
        movq	%rax, 312(%r9)
        adcq	320(%r8), %rdx
        movq	328(%r9), %rax
        movq	%rdx, 320(%r9)
        adcq	328(%r8), %rax
        movq	336(%r9), %rdx
        movq	%rax, 328(%r9)
        adcq	336(%r8), %rdx
        movq	344(%r9), %rax
        movq	%rdx, 336(%r9)
        adcq	344(%r8), %rax
        movq	352(%r9), %rdx
        movq	%rax, 344(%r9)
        adcq	352(%r8), %rdx
        movq	360(%r9), %rax
        movq	%rdx, 352(%r9)
        adcq	360(%r8), %rax
        movq	368(%r9), %rdx
        movq	%rax, 360(%r9)
        adcq	368(%r8), %rdx
        movq	376(%r9), %rax
        movq	%rdx, 368(%r9)
        adcq	376(%r8), %rax
        movq	%rax, 376(%r9)
        adcq	$0, %rcx
        movq	%rcx, 576(%rdi)
        # Add in place
        movq	192(%r9), %rdx
        addq	(%rsi), %rdx
        movq	200(%r9), %rax
        movq	%rdx, 192(%r9)
        adcq	8(%rsi), %rax
        movq	208(%r9), %rdx
        movq	%rax, 200(%r9)
        adcq	16(%rsi), %rdx
        movq	216(%r9), %rax
        movq	%rdx, 208(%r9)
        adcq	24(%rsi), %rax
        movq	224(%r9), %rdx
        movq	%rax, 216(%r9)
        adcq	32(%rsi), %rdx
        movq	232(%r9), %rax
        movq	%rdx, 224(%r9)
        adcq	40(%rsi), %rax
        movq	240(%r9), %rdx
        movq	%rax, 232(%r9)
        adcq	48(%rsi), %rdx
        movq	248(%r9), %rax
        movq	%rdx, 240(%r9)
        adcq	56(%rsi), %rax
        movq	256(%r9), %rdx
        movq	%rax, 248(%r9)
        adcq	64(%rsi), %rdx
        movq	264(%r9), %rax
        movq	%rdx, 256(%r9)
        adcq	72(%rsi), %rax
        movq	272(%r9), %rdx
        movq	%rax, 264(%r9)
        adcq	80(%rsi), %rdx
        movq	280(%r9), %rax
        movq	%rdx, 272(%r9)
        adcq	88(%rsi), %rax
        movq	288(%r9), %rdx
        movq	%rax, 280(%r9)
        adcq	96(%rsi), %rdx
        movq	296(%r9), %rax
        movq	%rdx, 288(%r9)
        adcq	104(%rsi), %rax
        movq	304(%r9), %rdx
        movq	%rax, 296(%r9)
        adcq	112(%rsi), %rdx
        movq	312(%r9), %rax
        movq	%rdx, 304(%r9)
        adcq	120(%rsi), %rax
        movq	320(%r9), %rdx
        movq	%rax, 312(%r9)
        adcq	128(%rsi), %rdx
        movq	328(%r9), %rax
        movq	%rdx, 320(%r9)
        adcq	136(%rsi), %rax
        movq	336(%r9), %rdx
        movq	%rax, 328(%r9)
        adcq	144(%rsi), %rdx
        movq	344(%r9), %rax
        movq	%rdx, 336(%r9)
        adcq	152(%rsi), %rax
        movq	352(%r9), %rdx
        movq	%rax, 344(%r9)
        adcq	160(%rsi), %rdx
        movq	360(%r9), %rax
        movq	%rdx, 352(%r9)
        adcq	168(%rsi), %rax
        movq	368(%r9), %rdx
        movq	%rax, 360(%r9)
        adcq	176(%rsi), %rdx
        movq	376(%r9), %rax
        movq	%rdx, 368(%r9)
        adcq	184(%rsi), %rax
        movq	384(%r9), %rdx
        movq	%rax, 376(%r9)
        adcq	192(%rsi), %rdx
        movq	%rdx, 384(%r9)
        # Add to zero
        movq	200(%rsi), %rdx
        adcq	$0, %rdx
        movq	208(%rsi), %rax
        movq	%rdx, 392(%r9)
        adcq	$0, %rax
        movq	216(%rsi), %rdx
        movq	%rax, 400(%r9)
        adcq	$0, %rdx
        movq	224(%rsi), %rax
        movq	%rdx, 408(%r9)
        adcq	$0, %rax
        movq	232(%rsi), %rdx
        movq	%rax, 416(%r9)
        adcq	$0, %rdx
        movq	240(%rsi), %rax
        movq	%rdx, 424(%r9)
        adcq	$0, %rax
        movq	248(%rsi), %rdx
        movq	%rax, 432(%r9)
        adcq	$0, %rdx
        movq	256(%rsi), %rax
        movq	%rdx, 440(%r9)
        adcq	$0, %rax
        movq	264(%rsi), %rdx
        movq	%rax, 448(%r9)
        adcq	$0, %rdx
        movq	272(%rsi), %rax
        movq	%rdx, 456(%r9)
        adcq	$0, %rax
        movq	280(%rsi), %rdx
        movq	%rax, 464(%r9)
        adcq	$0, %rdx
        movq	288(%rsi), %rax
        movq	%rdx, 472(%r9)
        adcq	$0, %rax
        movq	296(%rsi), %rdx
        movq	%rax, 480(%r9)
        adcq	$0, %rdx
        movq	304(%rsi), %rax
        movq	%rdx, 488(%r9)
        adcq	$0, %rax
        movq	312(%rsi), %rdx
        movq	%rax, 496(%r9)
        adcq	$0, %rdx
        movq	320(%rsi), %rax
        movq	%rdx, 504(%r9)
        adcq	$0, %rax
        movq	328(%rsi), %rdx
        movq	%rax, 512(%r9)
        adcq	$0, %rdx
        movq	336(%rsi), %rax
        movq	%rdx, 520(%r9)
        adcq	$0, %rax
        movq	344(%rsi), %rdx
        movq	%rax, 528(%r9)
        adcq	$0, %rdx
        movq	352(%rsi), %rax
        movq	%rdx, 536(%r9)
        adcq	$0, %rax
        movq	360(%rsi), %rdx
        movq	%rax, 544(%r9)
        adcq	$0, %rdx
        movq	368(%rsi), %rax
        movq	%rdx, 552(%r9)
        adcq	$0, %rax
        movq	376(%rsi), %rdx
        movq	%rax, 560(%r9)
        adcq	$0, %rdx
        movq	%rdx, 568(%r9)
        addq	$984, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_sqr_avx2_48,.-sp_3072_sqr_avx2_48
#endif /* __APPLE__ */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_d_48
.type	sp_3072_mul_d_48,@function
.align	16
sp_3072_mul_d_48:
#else
.globl	_sp_3072_mul_d_48
.p2align	4
_sp_3072_mul_d_48:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	120(%rsi)
        addq	%rax, %r8
        movq	%r8, 120(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[16] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	128(%rsi)
        addq	%rax, %r9
        movq	%r9, 128(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[17] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        addq	%rax, %r10
        movq	%r10, 136(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[18] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        addq	%rax, %r8
        movq	%r8, 144(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[19] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	152(%rsi)
        addq	%rax, %r9
        movq	%r9, 152(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[20] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	160(%rsi)
        addq	%rax, %r10
        movq	%r10, 160(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[21] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	168(%rsi)
        addq	%rax, %r8
        movq	%r8, 168(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[22] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	176(%rsi)
        addq	%rax, %r9
        movq	%r9, 176(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[23] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        addq	%rax, %r10
        movq	%r10, 184(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[24] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        addq	%rax, %r8
        movq	%r8, 192(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[25] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	200(%rsi)
        addq	%rax, %r9
        movq	%r9, 200(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[26] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	208(%rsi)
        addq	%rax, %r10
        movq	%r10, 208(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[27] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	216(%rsi)
        addq	%rax, %r8
        movq	%r8, 216(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[28] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	224(%rsi)
        addq	%rax, %r9
        movq	%r9, 224(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[29] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        addq	%rax, %r10
        movq	%r10, 232(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[30] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        addq	%rax, %r8
        movq	%r8, 240(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[31] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	248(%rsi)
        addq	%rax, %r9
        movq	%r9, 248(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[32] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	256(%rsi)
        addq	%rax, %r10
        movq	%r10, 256(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[33] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	264(%rsi)
        addq	%rax, %r8
        movq	%r8, 264(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[34] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	272(%rsi)
        addq	%rax, %r9
        movq	%r9, 272(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[35] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	280(%rsi)
        addq	%rax, %r10
        movq	%r10, 280(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[36] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	288(%rsi)
        addq	%rax, %r8
        movq	%r8, 288(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[37] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	296(%rsi)
        addq	%rax, %r9
        movq	%r9, 296(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[38] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	304(%rsi)
        addq	%rax, %r10
        movq	%r10, 304(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[39] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	312(%rsi)
        addq	%rax, %r8
        movq	%r8, 312(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[40] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	320(%rsi)
        addq	%rax, %r9
        movq	%r9, 320(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[41] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	328(%rsi)
        addq	%rax, %r10
        movq	%r10, 328(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[42] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	336(%rsi)
        addq	%rax, %r8
        movq	%r8, 336(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[43] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	344(%rsi)
        addq	%rax, %r9
        movq	%r9, 344(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[44] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	352(%rsi)
        addq	%rax, %r10
        movq	%r10, 352(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[45] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	360(%rsi)
        addq	%rax, %r8
        movq	%r8, 360(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[46] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	368(%rsi)
        addq	%rax, %r9
        movq	%r9, 368(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[47] * B
        movq	%rcx, %rax
        mulq	376(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        movq	%r10, 376(%rdi)
        movq	%r8, 384(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_48,.-sp_3072_mul_d_48
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_3072_cond_sub_24
.type	sp_3072_cond_sub_24,@function
.align	16
sp_3072_cond_sub_24:
#else
.globl	_sp_3072_cond_sub_24
.p2align	4
_sp_3072_cond_sub_24:
#endif /* __APPLE__ */
        subq	$192, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        sbbq	$0, %rax
        addq	$192, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_sub_24,.-sp_3072_cond_sub_24
#endif /* __APPLE__ */
/* Reduce the number back to 3072 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_3072_mont_reduce_24
.type	sp_3072_mont_reduce_24,@function
.align	16
sp_3072_mont_reduce_24:
#else
.globl	_sp_3072_mont_reduce_24
.p2align	4
_sp_3072_mont_reduce_24:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 24
        movq	$24, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_mont_loop_24:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	$0, %r9
        # a[i+16] += m[16] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	128(%rsi)
        movq	128(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 128(%rdi)
        adcq	$0, %r10
        # a[i+17] += m[17] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        movq	136(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 136(%rdi)
        adcq	$0, %r9
        # a[i+18] += m[18] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        movq	144(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 144(%rdi)
        adcq	$0, %r10
        # a[i+19] += m[19] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	152(%rsi)
        movq	152(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 152(%rdi)
        adcq	$0, %r9
        # a[i+20] += m[20] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	160(%rsi)
        movq	160(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 160(%rdi)
        adcq	$0, %r10
        # a[i+21] += m[21] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	168(%rsi)
        movq	168(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 168(%rdi)
        adcq	$0, %r9
        # a[i+22] += m[22] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	176(%rsi)
        movq	176(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 176(%rdi)
        adcq	$0, %r10
        # a[i+23] += m[23] * mu
        movq	%r11, %rax
        mulq	184(%rsi)
        movq	184(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0, %r15
        adcq	$0, %r15
        addq	%r10, %r12
        movq	%r12, 184(%rdi)
        adcq	%rdx, 192(%rdi)
        adcq	$0, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_mont_loop_24
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
        movq	%r15, %rcx
        movq	%rsi, %rdx
        movq	%rdi, %rsi
        subq	$192, %rdi
#ifndef __APPLE__
        callq	sp_3072_cond_sub_24@plt
#else
        callq	_sp_3072_cond_sub_24
#endif /* __APPLE__ */
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mont_reduce_24,.-sp_3072_mont_reduce_24
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_3072_cond_sub_avx2_24
.type	sp_3072_cond_sub_avx2_24,@function
.align	16
sp_3072_cond_sub_avx2_24:
#else
.globl	_sp_3072_cond_sub_avx2_24
.p2align	4
_sp_3072_cond_sub_avx2_24:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        sbbq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        sbbq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        sbbq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        sbbq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        sbbq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        sbbq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        sbbq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        sbbq	%r8, %r10
        movq	%r10, 184(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_sub_avx2_24,.-sp_3072_cond_sub_avx2_24
#endif /* __APPLE__ */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_d_24
.type	sp_3072_mul_d_24,@function
.align	16
sp_3072_mul_d_24:
#else
.globl	_sp_3072_mul_d_24
.p2align	4
_sp_3072_mul_d_24:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	120(%rsi)
        addq	%rax, %r8
        movq	%r8, 120(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[16] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	128(%rsi)
        addq	%rax, %r9
        movq	%r9, 128(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[17] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        addq	%rax, %r10
        movq	%r10, 136(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[18] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        addq	%rax, %r8
        movq	%r8, 144(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[19] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	152(%rsi)
        addq	%rax, %r9
        movq	%r9, 152(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[20] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	160(%rsi)
        addq	%rax, %r10
        movq	%r10, 160(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[21] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	168(%rsi)
        addq	%rax, %r8
        movq	%r8, 168(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[22] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	176(%rsi)
        addq	%rax, %r9
        movq	%r9, 176(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[23] * B
        movq	%rcx, %rax
        mulq	184(%rsi)
        addq	%rax, %r10
        adcq	%rdx, %r8
        movq	%r10, 184(%rdi)
        movq	%r8, 192(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_24,.-sp_3072_mul_d_24
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_d_avx2_24
.type	sp_3072_mul_d_avx2_24,@function
.align	16
sp_3072_mul_d_avx2_24:
#else
.globl	_sp_3072_mul_d_avx2_24
.p2align	4
_sp_3072_mul_d_avx2_24:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 8(%rdi)
        adoxq	%r8, %r9
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 16(%rdi)
        adoxq	%r8, %r10
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 24(%rdi)
        adoxq	%r8, %r9
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 32(%rdi)
        adoxq	%r8, %r10
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 40(%rdi)
        adoxq	%r8, %r9
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 48(%rdi)
        adoxq	%r8, %r10
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 56(%rdi)
        adoxq	%r8, %r9
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 64(%rdi)
        adoxq	%r8, %r10
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 72(%rdi)
        adoxq	%r8, %r9
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 80(%rdi)
        adoxq	%r8, %r10
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 88(%rdi)
        adoxq	%r8, %r9
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 96(%rdi)
        adoxq	%r8, %r10
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 104(%rdi)
        adoxq	%r8, %r9
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 112(%rdi)
        adoxq	%r8, %r10
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 120(%rdi)
        adoxq	%r8, %r9
        # A[16] * B
        mulxq	128(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 128(%rdi)
        adoxq	%r8, %r10
        # A[17] * B
        mulxq	136(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 136(%rdi)
        adoxq	%r8, %r9
        # A[18] * B
        mulxq	144(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 144(%rdi)
        adoxq	%r8, %r10
        # A[19] * B
        mulxq	152(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 152(%rdi)
        adoxq	%r8, %r9
        # A[20] * B
        mulxq	160(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 160(%rdi)
        adoxq	%r8, %r10
        # A[21] * B
        mulxq	168(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 168(%rdi)
        adoxq	%r8, %r9
        # A[22] * B
        mulxq	176(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 176(%rdi)
        adoxq	%r8, %r10
        # A[23] * B
        mulxq	184(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 184(%rdi)
        movq	%r9, 192(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_avx2_24,.-sp_3072_mul_d_avx2_24
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.globl	sp_3072_cmp_24
.type	sp_3072_cmp_24,@function
.align	16
sp_3072_cmp_24:
#else
.globl	_sp_3072_cmp_24
.p2align	4
_sp_3072_cmp_24:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$1, %r8
        movq	184(%rdi), %r9
        movq	184(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	176(%rdi), %r9
        movq	176(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	168(%rdi), %r9
        movq	168(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	160(%rdi), %r9
        movq	160(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	152(%rdi), %r9
        movq	152(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	144(%rdi), %r9
        movq	144(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	136(%rdi), %r9
        movq	136(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	128(%rdi), %r9
        movq	128(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_cmp_24,.-sp_3072_cmp_24
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 3072 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_3072_mont_reduce_avx2_24
.type	sp_3072_mont_reduce_avx2_24,@function
.align	16
sp_3072_mont_reduce_avx2_24:
#else
.globl	_sp_3072_mont_reduce_avx2_24
.p2align	4
_sp_3072_mont_reduce_avx2_24:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        movq	%rdx, %r8
        xorq	%r14, %r14
        # i = 24
        movq	$24, %r9
        movq	(%rdi), %r13
        addq	$96, %rdi
        xorq	%r12, %r12
L_mont_loop_avx2_24:
        # mu = a[i] * mp
        movq	%r13, %rdx
        movq	%r13, %r10
        imulq	%r8, %rdx
        xorq	%r12, %r12
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	-88(%rdi), %r13
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	-80(%rdi), %r10
        adcxq	%rax, %r13
        adoxq	%rcx, %r10
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	-72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -80(%rdi)
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -72(%rdi)
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -64(%rdi)
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -56(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -48(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	-32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -40(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -32(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+16] += m[16] * mu
        mulxq	128(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+17] += m[17] * mu
        mulxq	136(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+18] += m[18] * mu
        mulxq	144(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+19] += m[19] * mu
        mulxq	152(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        # a[i+20] += m[20] * mu
        mulxq	160(%rsi), %rax, %rcx
        movq	72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 64(%rdi)
        # a[i+21] += m[21] * mu
        mulxq	168(%rsi), %rax, %rcx
        movq	80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 72(%rdi)
        # a[i+22] += m[22] * mu
        mulxq	176(%rsi), %rax, %rcx
        movq	88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 80(%rdi)
        # a[i+23] += m[23] * mu
        mulxq	184(%rsi), %rax, %rcx
        movq	96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 88(%rdi)
        adcxq	%r14, %r10
        movq	%r10, 96(%rdi)
        movq	%r12, %r14
        adoxq	%r12, %r14
        adcxq	%r12, %r14
        # a += 1
        addq	$8, %rdi
        # i -= 1
        subq	$1, %r9
        jnz	L_mont_loop_avx2_24
        subq	$96, %rdi
        negq	%r14
        movq	%rdi, %r8
        subq	$192, %rdi
        movq	(%rsi), %rcx
        movq	%r13, %rdx
        pextq	%r14, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	8(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	16(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	24(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	128(%rsi), %rcx
        movq	128(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 120(%rdi)
        sbbq	%rcx, %rax
        movq	136(%rsi), %rdx
        movq	136(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 128(%rdi)
        sbbq	%rdx, %rcx
        movq	144(%rsi), %rax
        movq	144(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 136(%rdi)
        sbbq	%rax, %rdx
        movq	152(%rsi), %rcx
        movq	152(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 144(%rdi)
        sbbq	%rcx, %rax
        movq	160(%rsi), %rdx
        movq	160(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 152(%rdi)
        sbbq	%rdx, %rcx
        movq	168(%rsi), %rax
        movq	168(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 160(%rdi)
        sbbq	%rax, %rdx
        movq	176(%rsi), %rcx
        movq	176(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 168(%rdi)
        sbbq	%rcx, %rax
        movq	184(%rsi), %rdx
        movq	184(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 176(%rdi)
        sbbq	%rdx, %rcx
        movq	%rcx, 184(%rdi)
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mont_reduce_avx2_24,.-sp_3072_mont_reduce_avx2_24
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_3072_cond_sub_48
.type	sp_3072_cond_sub_48,@function
.align	16
sp_3072_cond_sub_48:
#else
.globl	_sp_3072_cond_sub_48
.p2align	4
_sp_3072_cond_sub_48:
#endif /* __APPLE__ */
        subq	$384, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	192(%rdx), %r8
        movq	200(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 192(%rsp)
        movq	%r9, 200(%rsp)
        movq	208(%rdx), %r8
        movq	216(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 208(%rsp)
        movq	%r9, 216(%rsp)
        movq	224(%rdx), %r8
        movq	232(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 224(%rsp)
        movq	%r9, 232(%rsp)
        movq	240(%rdx), %r8
        movq	248(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 240(%rsp)
        movq	%r9, 248(%rsp)
        movq	256(%rdx), %r8
        movq	264(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 256(%rsp)
        movq	%r9, 264(%rsp)
        movq	272(%rdx), %r8
        movq	280(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 272(%rsp)
        movq	%r9, 280(%rsp)
        movq	288(%rdx), %r8
        movq	296(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 288(%rsp)
        movq	%r9, 296(%rsp)
        movq	304(%rdx), %r8
        movq	312(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 304(%rsp)
        movq	%r9, 312(%rsp)
        movq	320(%rdx), %r8
        movq	328(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 320(%rsp)
        movq	%r9, 328(%rsp)
        movq	336(%rdx), %r8
        movq	344(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 336(%rsp)
        movq	%r9, 344(%rsp)
        movq	352(%rdx), %r8
        movq	360(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 352(%rsp)
        movq	%r9, 360(%rsp)
        movq	368(%rdx), %r8
        movq	376(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 368(%rsp)
        movq	%r9, 376(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	192(%rsi), %r8
        movq	192(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 184(%rdi)
        movq	200(%rsi), %r9
        movq	200(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 192(%rdi)
        movq	208(%rsi), %r8
        movq	208(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 200(%rdi)
        movq	216(%rsi), %r9
        movq	216(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 208(%rdi)
        movq	224(%rsi), %r8
        movq	224(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 216(%rdi)
        movq	232(%rsi), %r9
        movq	232(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 224(%rdi)
        movq	240(%rsi), %r8
        movq	240(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 232(%rdi)
        movq	248(%rsi), %r9
        movq	248(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	256(%rsi), %r8
        movq	256(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 248(%rdi)
        movq	264(%rsi), %r9
        movq	264(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 256(%rdi)
        movq	272(%rsi), %r8
        movq	272(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 264(%rdi)
        movq	280(%rsi), %r9
        movq	280(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 272(%rdi)
        movq	288(%rsi), %r8
        movq	288(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 280(%rdi)
        movq	296(%rsi), %r9
        movq	296(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 288(%rdi)
        movq	304(%rsi), %r8
        movq	304(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 296(%rdi)
        movq	312(%rsi), %r9
        movq	312(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 304(%rdi)
        movq	320(%rsi), %r8
        movq	320(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 312(%rdi)
        movq	328(%rsi), %r9
        movq	328(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 320(%rdi)
        movq	336(%rsi), %r8
        movq	336(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 328(%rdi)
        movq	344(%rsi), %r9
        movq	344(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 336(%rdi)
        movq	352(%rsi), %r8
        movq	352(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 344(%rdi)
        movq	360(%rsi), %r9
        movq	360(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 352(%rdi)
        movq	368(%rsi), %r8
        movq	368(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 360(%rdi)
        movq	376(%rsi), %r9
        movq	376(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 368(%rdi)
        movq	%r9, 376(%rdi)
        sbbq	$0, %rax
        addq	$384, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_sub_48,.-sp_3072_cond_sub_48
#endif /* __APPLE__ */
/* Reduce the number back to 3072 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_3072_mont_reduce_48
.type	sp_3072_mont_reduce_48,@function
.align	16
sp_3072_mont_reduce_48:
#else
.globl	_sp_3072_mont_reduce_48
.p2align	4
_sp_3072_mont_reduce_48:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 48
        movq	$48, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_mont_loop_48:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	$0, %r9
        # a[i+16] += m[16] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	128(%rsi)
        movq	128(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 128(%rdi)
        adcq	$0, %r10
        # a[i+17] += m[17] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        movq	136(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 136(%rdi)
        adcq	$0, %r9
        # a[i+18] += m[18] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        movq	144(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 144(%rdi)
        adcq	$0, %r10
        # a[i+19] += m[19] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	152(%rsi)
        movq	152(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 152(%rdi)
        adcq	$0, %r9
        # a[i+20] += m[20] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	160(%rsi)
        movq	160(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 160(%rdi)
        adcq	$0, %r10
        # a[i+21] += m[21] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	168(%rsi)
        movq	168(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 168(%rdi)
        adcq	$0, %r9
        # a[i+22] += m[22] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	176(%rsi)
        movq	176(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 176(%rdi)
        adcq	$0, %r10
        # a[i+23] += m[23] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        movq	184(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 184(%rdi)
        adcq	$0, %r9
        # a[i+24] += m[24] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        movq	192(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 192(%rdi)
        adcq	$0, %r10
        # a[i+25] += m[25] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	200(%rsi)
        movq	200(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 200(%rdi)
        adcq	$0, %r9
        # a[i+26] += m[26] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	208(%rsi)
        movq	208(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 208(%rdi)
        adcq	$0, %r10
        # a[i+27] += m[27] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	216(%rsi)
        movq	216(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 216(%rdi)
        adcq	$0, %r9
        # a[i+28] += m[28] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	224(%rsi)
        movq	224(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 224(%rdi)
        adcq	$0, %r10
        # a[i+29] += m[29] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        movq	232(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 232(%rdi)
        adcq	$0, %r9
        # a[i+30] += m[30] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        movq	240(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 240(%rdi)
        adcq	$0, %r10
        # a[i+31] += m[31] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	248(%rsi)
        movq	248(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 248(%rdi)
        adcq	$0, %r9
        # a[i+32] += m[32] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	256(%rsi)
        movq	256(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 256(%rdi)
        adcq	$0, %r10
        # a[i+33] += m[33] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	264(%rsi)
        movq	264(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 264(%rdi)
        adcq	$0, %r9
        # a[i+34] += m[34] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	272(%rsi)
        movq	272(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 272(%rdi)
        adcq	$0, %r10
        # a[i+35] += m[35] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	280(%rsi)
        movq	280(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 280(%rdi)
        adcq	$0, %r9
        # a[i+36] += m[36] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	288(%rsi)
        movq	288(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 288(%rdi)
        adcq	$0, %r10
        # a[i+37] += m[37] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	296(%rsi)
        movq	296(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 296(%rdi)
        adcq	$0, %r9
        # a[i+38] += m[38] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	304(%rsi)
        movq	304(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 304(%rdi)
        adcq	$0, %r10
        # a[i+39] += m[39] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	312(%rsi)
        movq	312(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 312(%rdi)
        adcq	$0, %r9
        # a[i+40] += m[40] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	320(%rsi)
        movq	320(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 320(%rdi)
        adcq	$0, %r10
        # a[i+41] += m[41] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	328(%rsi)
        movq	328(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 328(%rdi)
        adcq	$0, %r9
        # a[i+42] += m[42] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	336(%rsi)
        movq	336(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 336(%rdi)
        adcq	$0, %r10
        # a[i+43] += m[43] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	344(%rsi)
        movq	344(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 344(%rdi)
        adcq	$0, %r9
        # a[i+44] += m[44] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	352(%rsi)
        movq	352(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 352(%rdi)
        adcq	$0, %r10
        # a[i+45] += m[45] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	360(%rsi)
        movq	360(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 360(%rdi)
        adcq	$0, %r9
        # a[i+46] += m[46] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	368(%rsi)
        movq	368(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 368(%rdi)
        adcq	$0, %r10
        # a[i+47] += m[47] * mu
        movq	%r11, %rax
        mulq	376(%rsi)
        movq	376(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0, %r15
        adcq	$0, %r15
        addq	%r10, %r12
        movq	%r12, 376(%rdi)
        adcq	%rdx, 384(%rdi)
        adcq	$0, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_mont_loop_48
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
        movq	%r15, %rcx
        movq	%rsi, %rdx
        movq	%rdi, %rsi
        subq	$384, %rdi
#ifndef __APPLE__
        callq	sp_3072_cond_sub_48@plt
#else
        callq	_sp_3072_cond_sub_48
#endif /* __APPLE__ */
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mont_reduce_48,.-sp_3072_mont_reduce_48
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_3072_cond_sub_avx2_48
.type	sp_3072_cond_sub_avx2_48,@function
.align	16
sp_3072_cond_sub_avx2_48:
#else
.globl	_sp_3072_cond_sub_avx2_48
.p2align	4
_sp_3072_cond_sub_avx2_48:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        sbbq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        sbbq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        sbbq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        sbbq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        sbbq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        sbbq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        sbbq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        sbbq	%r8, %r10
        movq	192(%rdx), %r9
        movq	192(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 184(%rdi)
        sbbq	%r9, %r8
        movq	200(%rdx), %r10
        movq	200(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 192(%rdi)
        sbbq	%r10, %r9
        movq	208(%rdx), %r8
        movq	208(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 200(%rdi)
        sbbq	%r8, %r10
        movq	216(%rdx), %r9
        movq	216(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 208(%rdi)
        sbbq	%r9, %r8
        movq	224(%rdx), %r10
        movq	224(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 216(%rdi)
        sbbq	%r10, %r9
        movq	232(%rdx), %r8
        movq	232(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 224(%rdi)
        sbbq	%r8, %r10
        movq	240(%rdx), %r9
        movq	240(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 232(%rdi)
        sbbq	%r9, %r8
        movq	248(%rdx), %r10
        movq	248(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 240(%rdi)
        sbbq	%r10, %r9
        movq	256(%rdx), %r8
        movq	256(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 248(%rdi)
        sbbq	%r8, %r10
        movq	264(%rdx), %r9
        movq	264(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 256(%rdi)
        sbbq	%r9, %r8
        movq	272(%rdx), %r10
        movq	272(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 264(%rdi)
        sbbq	%r10, %r9
        movq	280(%rdx), %r8
        movq	280(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 272(%rdi)
        sbbq	%r8, %r10
        movq	288(%rdx), %r9
        movq	288(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 280(%rdi)
        sbbq	%r9, %r8
        movq	296(%rdx), %r10
        movq	296(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 288(%rdi)
        sbbq	%r10, %r9
        movq	304(%rdx), %r8
        movq	304(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 296(%rdi)
        sbbq	%r8, %r10
        movq	312(%rdx), %r9
        movq	312(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 304(%rdi)
        sbbq	%r9, %r8
        movq	320(%rdx), %r10
        movq	320(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 312(%rdi)
        sbbq	%r10, %r9
        movq	328(%rdx), %r8
        movq	328(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 320(%rdi)
        sbbq	%r8, %r10
        movq	336(%rdx), %r9
        movq	336(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 328(%rdi)
        sbbq	%r9, %r8
        movq	344(%rdx), %r10
        movq	344(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 336(%rdi)
        sbbq	%r10, %r9
        movq	352(%rdx), %r8
        movq	352(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 344(%rdi)
        sbbq	%r8, %r10
        movq	360(%rdx), %r9
        movq	360(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 352(%rdi)
        sbbq	%r9, %r8
        movq	368(%rdx), %r10
        movq	368(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 360(%rdi)
        sbbq	%r10, %r9
        movq	376(%rdx), %r8
        movq	376(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 368(%rdi)
        sbbq	%r8, %r10
        movq	%r10, 376(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_sub_avx2_48,.-sp_3072_cond_sub_avx2_48
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_3072_mul_d_avx2_48
.type	sp_3072_mul_d_avx2_48,@function
.align	16
sp_3072_mul_d_avx2_48:
#else
.globl	_sp_3072_mul_d_avx2_48
.p2align	4
_sp_3072_mul_d_avx2_48:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 8(%rdi)
        adoxq	%r8, %r9
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 16(%rdi)
        adoxq	%r8, %r10
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 24(%rdi)
        adoxq	%r8, %r9
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 32(%rdi)
        adoxq	%r8, %r10
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 40(%rdi)
        adoxq	%r8, %r9
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 48(%rdi)
        adoxq	%r8, %r10
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 56(%rdi)
        adoxq	%r8, %r9
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 64(%rdi)
        adoxq	%r8, %r10
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 72(%rdi)
        adoxq	%r8, %r9
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 80(%rdi)
        adoxq	%r8, %r10
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 88(%rdi)
        adoxq	%r8, %r9
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 96(%rdi)
        adoxq	%r8, %r10
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 104(%rdi)
        adoxq	%r8, %r9
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 112(%rdi)
        adoxq	%r8, %r10
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 120(%rdi)
        adoxq	%r8, %r9
        # A[16] * B
        mulxq	128(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 128(%rdi)
        adoxq	%r8, %r10
        # A[17] * B
        mulxq	136(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 136(%rdi)
        adoxq	%r8, %r9
        # A[18] * B
        mulxq	144(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 144(%rdi)
        adoxq	%r8, %r10
        # A[19] * B
        mulxq	152(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 152(%rdi)
        adoxq	%r8, %r9
        # A[20] * B
        mulxq	160(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 160(%rdi)
        adoxq	%r8, %r10
        # A[21] * B
        mulxq	168(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 168(%rdi)
        adoxq	%r8, %r9
        # A[22] * B
        mulxq	176(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 176(%rdi)
        adoxq	%r8, %r10
        # A[23] * B
        mulxq	184(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 184(%rdi)
        adoxq	%r8, %r9
        # A[24] * B
        mulxq	192(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 192(%rdi)
        adoxq	%r8, %r10
        # A[25] * B
        mulxq	200(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 200(%rdi)
        adoxq	%r8, %r9
        # A[26] * B
        mulxq	208(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 208(%rdi)
        adoxq	%r8, %r10
        # A[27] * B
        mulxq	216(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 216(%rdi)
        adoxq	%r8, %r9
        # A[28] * B
        mulxq	224(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 224(%rdi)
        adoxq	%r8, %r10
        # A[29] * B
        mulxq	232(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 232(%rdi)
        adoxq	%r8, %r9
        # A[30] * B
        mulxq	240(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 240(%rdi)
        adoxq	%r8, %r10
        # A[31] * B
        mulxq	248(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 248(%rdi)
        adoxq	%r8, %r9
        # A[32] * B
        mulxq	256(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 256(%rdi)
        adoxq	%r8, %r10
        # A[33] * B
        mulxq	264(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 264(%rdi)
        adoxq	%r8, %r9
        # A[34] * B
        mulxq	272(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 272(%rdi)
        adoxq	%r8, %r10
        # A[35] * B
        mulxq	280(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 280(%rdi)
        adoxq	%r8, %r9
        # A[36] * B
        mulxq	288(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 288(%rdi)
        adoxq	%r8, %r10
        # A[37] * B
        mulxq	296(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 296(%rdi)
        adoxq	%r8, %r9
        # A[38] * B
        mulxq	304(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 304(%rdi)
        adoxq	%r8, %r10
        # A[39] * B
        mulxq	312(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 312(%rdi)
        adoxq	%r8, %r9
        # A[40] * B
        mulxq	320(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 320(%rdi)
        adoxq	%r8, %r10
        # A[41] * B
        mulxq	328(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 328(%rdi)
        adoxq	%r8, %r9
        # A[42] * B
        mulxq	336(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 336(%rdi)
        adoxq	%r8, %r10
        # A[43] * B
        mulxq	344(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 344(%rdi)
        adoxq	%r8, %r9
        # A[44] * B
        mulxq	352(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 352(%rdi)
        adoxq	%r8, %r10
        # A[45] * B
        mulxq	360(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 360(%rdi)
        adoxq	%r8, %r9
        # A[46] * B
        mulxq	368(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 368(%rdi)
        adoxq	%r8, %r10
        # A[47] * B
        mulxq	376(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 376(%rdi)
        movq	%r9, 384(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_3072_mul_d_avx2_48,.-sp_3072_mul_d_avx2_48
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.globl	sp_3072_cmp_48
.type	sp_3072_cmp_48,@function
.align	16
sp_3072_cmp_48:
#else
.globl	_sp_3072_cmp_48
.p2align	4
_sp_3072_cmp_48:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$1, %r8
        movq	376(%rdi), %r9
        movq	376(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	368(%rdi), %r9
        movq	368(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	360(%rdi), %r9
        movq	360(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	352(%rdi), %r9
        movq	352(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	344(%rdi), %r9
        movq	344(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	336(%rdi), %r9
        movq	336(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	328(%rdi), %r9
        movq	328(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	320(%rdi), %r9
        movq	320(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	312(%rdi), %r9
        movq	312(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	304(%rdi), %r9
        movq	304(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	296(%rdi), %r9
        movq	296(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	288(%rdi), %r9
        movq	288(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	280(%rdi), %r9
        movq	280(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	272(%rdi), %r9
        movq	272(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	264(%rdi), %r9
        movq	264(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	256(%rdi), %r9
        movq	256(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	248(%rdi), %r9
        movq	248(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	240(%rdi), %r9
        movq	240(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	232(%rdi), %r9
        movq	232(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	224(%rdi), %r9
        movq	224(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	216(%rdi), %r9
        movq	216(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	208(%rdi), %r9
        movq	208(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	200(%rdi), %r9
        movq	200(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	192(%rdi), %r9
        movq	192(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	184(%rdi), %r9
        movq	184(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	176(%rdi), %r9
        movq	176(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	168(%rdi), %r9
        movq	168(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	160(%rdi), %r9
        movq	160(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	152(%rdi), %r9
        movq	152(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	144(%rdi), %r9
        movq	144(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	136(%rdi), %r9
        movq	136(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	128(%rdi), %r9
        movq	128(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_cmp_48,.-sp_3072_cmp_48
#endif /* __APPLE__ */
/* Sub b from a into r. (r = a - b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_3072_sub_48
.type	sp_3072_sub_48,@function
.align	16
sp_3072_sub_48:
#else
.globl	_sp_3072_sub_48
.p2align	4
_sp_3072_sub_48:
#endif /* __APPLE__ */
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        subq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        sbbq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        sbbq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        sbbq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        sbbq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        sbbq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        sbbq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        sbbq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        sbbq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        sbbq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        sbbq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        sbbq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        sbbq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        sbbq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        sbbq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        sbbq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        sbbq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        sbbq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        sbbq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        sbbq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        sbbq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        sbbq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        sbbq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        sbbq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        sbbq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        sbbq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        sbbq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        sbbq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        sbbq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        sbbq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        sbbq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        sbbq	248(%rdx), %r8
        movq	256(%rsi), %rcx
        movq	%r8, 248(%rdi)
        sbbq	256(%rdx), %rcx
        movq	264(%rsi), %r8
        movq	%rcx, 256(%rdi)
        sbbq	264(%rdx), %r8
        movq	272(%rsi), %rcx
        movq	%r8, 264(%rdi)
        sbbq	272(%rdx), %rcx
        movq	280(%rsi), %r8
        movq	%rcx, 272(%rdi)
        sbbq	280(%rdx), %r8
        movq	288(%rsi), %rcx
        movq	%r8, 280(%rdi)
        sbbq	288(%rdx), %rcx
        movq	296(%rsi), %r8
        movq	%rcx, 288(%rdi)
        sbbq	296(%rdx), %r8
        movq	304(%rsi), %rcx
        movq	%r8, 296(%rdi)
        sbbq	304(%rdx), %rcx
        movq	312(%rsi), %r8
        movq	%rcx, 304(%rdi)
        sbbq	312(%rdx), %r8
        movq	320(%rsi), %rcx
        movq	%r8, 312(%rdi)
        sbbq	320(%rdx), %rcx
        movq	328(%rsi), %r8
        movq	%rcx, 320(%rdi)
        sbbq	328(%rdx), %r8
        movq	336(%rsi), %rcx
        movq	%r8, 328(%rdi)
        sbbq	336(%rdx), %rcx
        movq	344(%rsi), %r8
        movq	%rcx, 336(%rdi)
        sbbq	344(%rdx), %r8
        movq	352(%rsi), %rcx
        movq	%r8, 344(%rdi)
        sbbq	352(%rdx), %rcx
        movq	360(%rsi), %r8
        movq	%rcx, 352(%rdi)
        sbbq	360(%rdx), %r8
        movq	368(%rsi), %rcx
        movq	%r8, 360(%rdi)
        sbbq	368(%rdx), %rcx
        movq	376(%rsi), %r8
        movq	%rcx, 368(%rdi)
        sbbq	376(%rdx), %r8
        movq	%r8, 376(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_sub_48,.-sp_3072_sub_48
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 3072 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_3072_mont_reduce_avx2_48
.type	sp_3072_mont_reduce_avx2_48,@function
.align	16
sp_3072_mont_reduce_avx2_48:
#else
.globl	_sp_3072_mont_reduce_avx2_48
.p2align	4
_sp_3072_mont_reduce_avx2_48:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        movq	%rdx, %r8
        xorq	%r14, %r14
        # i = 48
        movq	$48, %r9
        movq	(%rdi), %r13
        addq	$192, %rdi
        xorq	%r12, %r12
L_mont_loop_avx2_48:
        # mu = a[i] * mp
        movq	%r13, %rdx
        movq	%r13, %r10
        imulq	%r8, %rdx
        xorq	%r12, %r12
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	-184(%rdi), %r13
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	-176(%rdi), %r10
        adcxq	%rax, %r13
        adoxq	%rcx, %r10
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	-168(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -176(%rdi)
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-160(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -168(%rdi)
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-152(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -160(%rdi)
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-144(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -152(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-136(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -144(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	-128(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -136(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	-120(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -128(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	-112(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -120(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	-104(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -112(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	-96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -104(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	-88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -96(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	-80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -88(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	-72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -80(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	-64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -72(%rdi)
        # a[i+16] += m[16] * mu
        mulxq	128(%rsi), %rax, %rcx
        movq	-56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -64(%rdi)
        # a[i+17] += m[17] * mu
        mulxq	136(%rsi), %rax, %rcx
        movq	-48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -56(%rdi)
        # a[i+18] += m[18] * mu
        mulxq	144(%rsi), %rax, %rcx
        movq	-40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -48(%rdi)
        # a[i+19] += m[19] * mu
        mulxq	152(%rsi), %rax, %rcx
        movq	-32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -40(%rdi)
        # a[i+20] += m[20] * mu
        mulxq	160(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -32(%rdi)
        # a[i+21] += m[21] * mu
        mulxq	168(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+22] += m[22] * mu
        mulxq	176(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+23] += m[23] * mu
        mulxq	184(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+24] += m[24] * mu
        mulxq	192(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+25] += m[25] * mu
        mulxq	200(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+26] += m[26] * mu
        mulxq	208(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+27] += m[27] * mu
        mulxq	216(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+28] += m[28] * mu
        mulxq	224(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+29] += m[29] * mu
        mulxq	232(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+30] += m[30] * mu
        mulxq	240(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+31] += m[31] * mu
        mulxq	248(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        # a[i+32] += m[32] * mu
        mulxq	256(%rsi), %rax, %rcx
        movq	72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 64(%rdi)
        # a[i+33] += m[33] * mu
        mulxq	264(%rsi), %rax, %rcx
        movq	80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 72(%rdi)
        # a[i+34] += m[34] * mu
        mulxq	272(%rsi), %rax, %rcx
        movq	88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 80(%rdi)
        # a[i+35] += m[35] * mu
        mulxq	280(%rsi), %rax, %rcx
        movq	96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 88(%rdi)
        # a[i+36] += m[36] * mu
        mulxq	288(%rsi), %rax, %rcx
        movq	104(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rdi)
        # a[i+37] += m[37] * mu
        mulxq	296(%rsi), %rax, %rcx
        movq	112(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 104(%rdi)
        # a[i+38] += m[38] * mu
        mulxq	304(%rsi), %rax, %rcx
        movq	120(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 112(%rdi)
        # a[i+39] += m[39] * mu
        mulxq	312(%rsi), %rax, %rcx
        movq	128(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 120(%rdi)
        # a[i+40] += m[40] * mu
        mulxq	320(%rsi), %rax, %rcx
        movq	136(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 128(%rdi)
        # a[i+41] += m[41] * mu
        mulxq	328(%rsi), %rax, %rcx
        movq	144(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 136(%rdi)
        # a[i+42] += m[42] * mu
        mulxq	336(%rsi), %rax, %rcx
        movq	152(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 144(%rdi)
        # a[i+43] += m[43] * mu
        mulxq	344(%rsi), %rax, %rcx
        movq	160(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 152(%rdi)
        # a[i+44] += m[44] * mu
        mulxq	352(%rsi), %rax, %rcx
        movq	168(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 160(%rdi)
        # a[i+45] += m[45] * mu
        mulxq	360(%rsi), %rax, %rcx
        movq	176(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 168(%rdi)
        # a[i+46] += m[46] * mu
        mulxq	368(%rsi), %rax, %rcx
        movq	184(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 176(%rdi)
        # a[i+47] += m[47] * mu
        mulxq	376(%rsi), %rax, %rcx
        movq	192(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 184(%rdi)
        adcxq	%r14, %r10
        movq	%r10, 192(%rdi)
        movq	%r12, %r14
        adoxq	%r12, %r14
        adcxq	%r12, %r14
        # a += 1
        addq	$8, %rdi
        # i -= 1
        subq	$1, %r9
        jnz	L_mont_loop_avx2_48
        subq	$192, %rdi
        negq	%r14
        movq	%rdi, %r8
        subq	$384, %rdi
        movq	(%rsi), %rcx
        movq	%r13, %rdx
        pextq	%r14, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	8(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	16(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	24(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	128(%rsi), %rcx
        movq	128(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 120(%rdi)
        sbbq	%rcx, %rax
        movq	136(%rsi), %rdx
        movq	136(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 128(%rdi)
        sbbq	%rdx, %rcx
        movq	144(%rsi), %rax
        movq	144(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 136(%rdi)
        sbbq	%rax, %rdx
        movq	152(%rsi), %rcx
        movq	152(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 144(%rdi)
        sbbq	%rcx, %rax
        movq	160(%rsi), %rdx
        movq	160(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 152(%rdi)
        sbbq	%rdx, %rcx
        movq	168(%rsi), %rax
        movq	168(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 160(%rdi)
        sbbq	%rax, %rdx
        movq	176(%rsi), %rcx
        movq	176(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 168(%rdi)
        sbbq	%rcx, %rax
        movq	184(%rsi), %rdx
        movq	184(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 176(%rdi)
        sbbq	%rdx, %rcx
        movq	192(%rsi), %rax
        movq	192(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 184(%rdi)
        sbbq	%rax, %rdx
        movq	200(%rsi), %rcx
        movq	200(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 192(%rdi)
        sbbq	%rcx, %rax
        movq	208(%rsi), %rdx
        movq	208(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 200(%rdi)
        sbbq	%rdx, %rcx
        movq	216(%rsi), %rax
        movq	216(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 208(%rdi)
        sbbq	%rax, %rdx
        movq	224(%rsi), %rcx
        movq	224(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 216(%rdi)
        sbbq	%rcx, %rax
        movq	232(%rsi), %rdx
        movq	232(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 224(%rdi)
        sbbq	%rdx, %rcx
        movq	240(%rsi), %rax
        movq	240(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 232(%rdi)
        sbbq	%rax, %rdx
        movq	248(%rsi), %rcx
        movq	248(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 240(%rdi)
        sbbq	%rcx, %rax
        movq	256(%rsi), %rdx
        movq	256(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 248(%rdi)
        sbbq	%rdx, %rcx
        movq	264(%rsi), %rax
        movq	264(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 256(%rdi)
        sbbq	%rax, %rdx
        movq	272(%rsi), %rcx
        movq	272(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 264(%rdi)
        sbbq	%rcx, %rax
        movq	280(%rsi), %rdx
        movq	280(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 272(%rdi)
        sbbq	%rdx, %rcx
        movq	288(%rsi), %rax
        movq	288(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 280(%rdi)
        sbbq	%rax, %rdx
        movq	296(%rsi), %rcx
        movq	296(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 288(%rdi)
        sbbq	%rcx, %rax
        movq	304(%rsi), %rdx
        movq	304(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 296(%rdi)
        sbbq	%rdx, %rcx
        movq	312(%rsi), %rax
        movq	312(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 304(%rdi)
        sbbq	%rax, %rdx
        movq	320(%rsi), %rcx
        movq	320(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 312(%rdi)
        sbbq	%rcx, %rax
        movq	328(%rsi), %rdx
        movq	328(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 320(%rdi)
        sbbq	%rdx, %rcx
        movq	336(%rsi), %rax
        movq	336(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 328(%rdi)
        sbbq	%rax, %rdx
        movq	344(%rsi), %rcx
        movq	344(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 336(%rdi)
        sbbq	%rcx, %rax
        movq	352(%rsi), %rdx
        movq	352(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 344(%rdi)
        sbbq	%rdx, %rcx
        movq	360(%rsi), %rax
        movq	360(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 352(%rdi)
        sbbq	%rax, %rdx
        movq	368(%rsi), %rcx
        movq	368(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 360(%rdi)
        sbbq	%rcx, %rax
        movq	376(%rsi), %rdx
        movq	376(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 368(%rdi)
        sbbq	%rdx, %rcx
        movq	%rcx, 376(%rdi)
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_3072_mont_reduce_avx2_48,.-sp_3072_mont_reduce_avx2_48
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_3072_cond_add_24
.type	sp_3072_cond_add_24,@function
.align	16
sp_3072_cond_add_24:
#else
.globl	_sp_3072_cond_add_24
.p2align	4
_sp_3072_cond_add_24:
#endif /* __APPLE__ */
        subq	$192, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        addq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        adcq	$0, %rax
        addq	$192, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_add_24,.-sp_3072_cond_add_24
#endif /* __APPLE__ */
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_3072_cond_add_avx2_24
.type	sp_3072_cond_add_avx2_24,@function
.align	16
sp_3072_cond_add_avx2_24:
#else
.globl	_sp_3072_cond_add_avx2_24
.p2align	4
_sp_3072_cond_add_avx2_24:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        addq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        adcq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        adcq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        adcq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        adcq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        adcq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        adcq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        adcq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        adcq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        adcq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        adcq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        adcq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        adcq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        adcq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        adcq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        adcq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        adcq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        adcq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        adcq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        adcq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        adcq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        adcq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        adcq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        adcq	%r8, %r10
        movq	%r10, 184(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_3072_cond_add_avx2_24,.-sp_3072_cond_add_avx2_24
#endif /* __APPLE__ */
/* Shift number left by n bit. (r = a << n)
 *
 * r  Result of left shift by n.
 * a  Number to shift.
 * n  Amoutnt o shift.
 */
#ifndef __APPLE__
.globl	sp_3072_lshift_48
.type	sp_3072_lshift_48,@function
.align	16
sp_3072_lshift_48:
#else
.globl	_sp_3072_lshift_48
.p2align	4
_sp_3072_lshift_48:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        movq	$0, %r10
        movq	344(%rsi), %r11
        movq	352(%rsi), %rdx
        movq	360(%rsi), %rax
        movq	368(%rsi), %r8
        movq	376(%rsi), %r9
        shldq	%cl, %r9, %r10
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 352(%rdi)
        movq	%rax, 360(%rdi)
        movq	%r8, 368(%rdi)
        movq	%r9, 376(%rdi)
        movq	%r10, 384(%rdi)
        movq	312(%rsi), %r9
        movq	320(%rsi), %rdx
        movq	328(%rsi), %rax
        movq	336(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 320(%rdi)
        movq	%rax, 328(%rdi)
        movq	%r8, 336(%rdi)
        movq	%r11, 344(%rdi)
        movq	280(%rsi), %r11
        movq	288(%rsi), %rdx
        movq	296(%rsi), %rax
        movq	304(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 288(%rdi)
        movq	%rax, 296(%rdi)
        movq	%r8, 304(%rdi)
        movq	%r9, 312(%rdi)
        movq	248(%rsi), %r9
        movq	256(%rsi), %rdx
        movq	264(%rsi), %rax
        movq	272(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 256(%rdi)
        movq	%rax, 264(%rdi)
        movq	%r8, 272(%rdi)
        movq	%r11, 280(%rdi)
        movq	216(%rsi), %r11
        movq	224(%rsi), %rdx
        movq	232(%rsi), %rax
        movq	240(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 224(%rdi)
        movq	%rax, 232(%rdi)
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        movq	184(%rsi), %r9
        movq	192(%rsi), %rdx
        movq	200(%rsi), %rax
        movq	208(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 192(%rdi)
        movq	%rax, 200(%rdi)
        movq	%r8, 208(%rdi)
        movq	%r11, 216(%rdi)
        movq	152(%rsi), %r11
        movq	160(%rsi), %rdx
        movq	168(%rsi), %rax
        movq	176(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 160(%rdi)
        movq	%rax, 168(%rdi)
        movq	%r8, 176(%rdi)
        movq	%r9, 184(%rdi)
        movq	120(%rsi), %r9
        movq	128(%rsi), %rdx
        movq	136(%rsi), %rax
        movq	144(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 128(%rdi)
        movq	%rax, 136(%rdi)
        movq	%r8, 144(%rdi)
        movq	%r11, 152(%rdi)
        movq	88(%rsi), %r11
        movq	96(%rsi), %rdx
        movq	104(%rsi), %rax
        movq	112(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 96(%rdi)
        movq	%rax, 104(%rdi)
        movq	%r8, 112(%rdi)
        movq	%r9, 120(%rdi)
        movq	56(%rsi), %r9
        movq	64(%rsi), %rdx
        movq	72(%rsi), %rax
        movq	80(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 64(%rdi)
        movq	%rax, 72(%rdi)
        movq	%r8, 80(%rdi)
        movq	%r11, 88(%rdi)
        movq	24(%rsi), %r11
        movq	32(%rsi), %rdx
        movq	40(%rsi), %rax
        movq	48(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 32(%rdi)
        movq	%rax, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	(%rsi), %rdx
        movq	8(%rsi), %rax
        movq	16(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shlq	%cl, %rdx
        movq	%rdx, (%rdi)
        movq	%rax, 8(%rdi)
        movq	%r8, 16(%rdi)
        movq	%r11, 24(%rdi)
        repz retq
#endif /* !WOLFSSL_SP_NO_3072 */
#endif /* !WOLFSSL_SP_NO_3072 */
#ifdef WOLFSSL_SP_4096
#ifdef WOLFSSL_SP_4096
/* Read big endian unsigned byte array into r.
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.globl	sp_4096_from_bin_bswap
.type	sp_4096_from_bin_bswap,@function
.align	16
sp_4096_from_bin_bswap:
#else
.globl	_sp_4096_from_bin_bswap
.p2align	4
_sp_4096_from_bin_bswap:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$512, %r10
        xorq	%r11, %r11
        jmp	L_4096_from_bin_bswap_64_end
L_4096_from_bin_bswap_64_start:
        subq	$64, %r9
        movq	56(%r9), %rax
        movq	48(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movq	40(%r9), %rax
        movq	32(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movq	24(%r9), %rax
        movq	16(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movq	8(%r9), %rax
        movq	(%r9), %r8
        bswapq	%rax
        bswapq	%r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$64, %rdi
        subq	$64, %rcx
L_4096_from_bin_bswap_64_end:
        cmpq	$63, %rcx
        jg	L_4096_from_bin_bswap_64_start
        jmp	L_4096_from_bin_bswap_8_end
L_4096_from_bin_bswap_8_start:
        subq	$8, %r9
        movq	(%r9), %rax
        bswapq	%rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_4096_from_bin_bswap_8_end:
        cmpq	$7, %rcx
        jg	L_4096_from_bin_bswap_8_start
        cmpq	%r11, %rcx
        je	L_4096_from_bin_bswap_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_4096_from_bin_bswap_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_4096_from_bin_bswap_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_4096_from_bin_bswap_hi_end:
        cmpq	%r10, %rdi
        je	L_4096_from_bin_bswap_zero_end
L_4096_from_bin_bswap_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_4096_from_bin_bswap_zero_start
L_4096_from_bin_bswap_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_4096_from_bin_bswap,.-sp_4096_from_bin_bswap
#endif /* __APPLE__ */
/* Read big endian unsigned byte array into r.
 * Uses the movbe instruction which is an optional instruction.
 *
 * r  A single precision integer.
 * size  Maximum number of bytes to convert
 * a  Byte array.
 * n  Number of bytes in array to read.
 */
#ifndef __APPLE__
.globl	sp_4096_from_bin_movbe
.type	sp_4096_from_bin_movbe,@function
.align	16
sp_4096_from_bin_movbe:
#else
.globl	_sp_4096_from_bin_movbe
.p2align	4
_sp_4096_from_bin_movbe:
#endif /* __APPLE__ */
        movq	%rdx, %r9
        movq	%rdi, %r10
        addq	%rcx, %r9
        addq	$512, %r10
        xorq	%r11, %r11
        jmp	L_4096_from_bin_movbe_64_end
L_4096_from_bin_movbe_64_start:
        subq	$64, %r9
        movbeq	56(%r9), %rax
        movbeq	48(%r9), %r8
        movq	%rax, (%rdi)
        movq	%r8, 8(%rdi)
        movbeq	40(%r9), %rax
        movbeq	32(%r9), %r8
        movq	%rax, 16(%rdi)
        movq	%r8, 24(%rdi)
        movbeq	24(%r9), %rax
        movbeq	16(%r9), %r8
        movq	%rax, 32(%rdi)
        movq	%r8, 40(%rdi)
        movbeq	8(%r9), %rax
        movbeq	(%r9), %r8
        movq	%rax, 48(%rdi)
        movq	%r8, 56(%rdi)
        addq	$64, %rdi
        subq	$64, %rcx
L_4096_from_bin_movbe_64_end:
        cmpq	$63, %rcx
        jg	L_4096_from_bin_movbe_64_start
        jmp	L_4096_from_bin_movbe_8_end
L_4096_from_bin_movbe_8_start:
        subq	$8, %r9
        movbeq	(%r9), %rax
        movq	%rax, (%rdi)
        addq	$8, %rdi
        subq	$8, %rcx
L_4096_from_bin_movbe_8_end:
        cmpq	$7, %rcx
        jg	L_4096_from_bin_movbe_8_start
        cmpq	%r11, %rcx
        je	L_4096_from_bin_movbe_hi_end
        movq	%r11, %r8
        movq	%r11, %rax
L_4096_from_bin_movbe_hi_start:
        movb	(%rdx), %al
        shlq	$8, %r8
        incq	%rdx
        addq	%rax, %r8
        decq	%rcx
        jg	L_4096_from_bin_movbe_hi_start
        movq	%r8, (%rdi)
        addq	$8, %rdi
L_4096_from_bin_movbe_hi_end:
        cmpq	%r10, %rdi
        je	L_4096_from_bin_movbe_zero_end
L_4096_from_bin_movbe_zero_start:
        movq	%r11, (%rdi)
        addq	$8, %rdi
        cmpq	%r10, %rdi
        jl	L_4096_from_bin_movbe_zero_start
L_4096_from_bin_movbe_zero_end:
        repz retq
#ifndef __APPLE__
.size	sp_4096_from_bin_movbe,.-sp_4096_from_bin_movbe
#endif /* __APPLE__ */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 512
 * Uses the bswap instruction.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.globl	sp_4096_to_bin_bswap
.type	sp_4096_to_bin_bswap,@function
.align	16
sp_4096_to_bin_bswap:
#else
.globl	_sp_4096_to_bin_bswap
.p2align	4
_sp_4096_to_bin_bswap:
#endif /* __APPLE__ */
        movq	504(%rdi), %rdx
        movq	496(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movq	488(%rdi), %rdx
        movq	480(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movq	472(%rdi), %rdx
        movq	464(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movq	456(%rdi), %rdx
        movq	448(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movq	440(%rdi), %rdx
        movq	432(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movq	424(%rdi), %rdx
        movq	416(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movq	408(%rdi), %rdx
        movq	400(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movq	392(%rdi), %rdx
        movq	384(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movq	376(%rdi), %rdx
        movq	368(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movq	360(%rdi), %rdx
        movq	352(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movq	344(%rdi), %rdx
        movq	336(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movq	328(%rdi), %rdx
        movq	320(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movq	312(%rdi), %rdx
        movq	304(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movq	296(%rdi), %rdx
        movq	288(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movq	280(%rdi), %rdx
        movq	272(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movq	264(%rdi), %rdx
        movq	256(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        movq	248(%rdi), %rdx
        movq	240(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 256(%rsi)
        movq	%rax, 264(%rsi)
        movq	232(%rdi), %rdx
        movq	224(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 272(%rsi)
        movq	%rax, 280(%rsi)
        movq	216(%rdi), %rdx
        movq	208(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 288(%rsi)
        movq	%rax, 296(%rsi)
        movq	200(%rdi), %rdx
        movq	192(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 304(%rsi)
        movq	%rax, 312(%rsi)
        movq	184(%rdi), %rdx
        movq	176(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 320(%rsi)
        movq	%rax, 328(%rsi)
        movq	168(%rdi), %rdx
        movq	160(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 336(%rsi)
        movq	%rax, 344(%rsi)
        movq	152(%rdi), %rdx
        movq	144(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 352(%rsi)
        movq	%rax, 360(%rsi)
        movq	136(%rdi), %rdx
        movq	128(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 368(%rsi)
        movq	%rax, 376(%rsi)
        movq	120(%rdi), %rdx
        movq	112(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 384(%rsi)
        movq	%rax, 392(%rsi)
        movq	104(%rdi), %rdx
        movq	96(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 400(%rsi)
        movq	%rax, 408(%rsi)
        movq	88(%rdi), %rdx
        movq	80(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 416(%rsi)
        movq	%rax, 424(%rsi)
        movq	72(%rdi), %rdx
        movq	64(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 432(%rsi)
        movq	%rax, 440(%rsi)
        movq	56(%rdi), %rdx
        movq	48(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 448(%rsi)
        movq	%rax, 456(%rsi)
        movq	40(%rdi), %rdx
        movq	32(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 464(%rsi)
        movq	%rax, 472(%rsi)
        movq	24(%rdi), %rdx
        movq	16(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 480(%rsi)
        movq	%rax, 488(%rsi)
        movq	8(%rdi), %rdx
        movq	(%rdi), %rax
        bswapq	%rdx
        bswapq	%rax
        movq	%rdx, 496(%rsi)
        movq	%rax, 504(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_4096_to_bin_bswap,.-sp_4096_to_bin_bswap
#endif /* __APPLE__ */
/* Write r as big endian to byte array.
 * Fixed length number of bytes written: 512
 * Uses the movbe instruction which is optional.
 *
 * r  A single precision integer.
 * a  Byte array.
 */
#ifndef __APPLE__
.globl	sp_4096_to_bin_movbe
.type	sp_4096_to_bin_movbe,@function
.align	16
sp_4096_to_bin_movbe:
#else
.globl	_sp_4096_to_bin_movbe
.p2align	4
_sp_4096_to_bin_movbe:
#endif /* __APPLE__ */
        movbeq	504(%rdi), %rdx
        movbeq	496(%rdi), %rax
        movq	%rdx, (%rsi)
        movq	%rax, 8(%rsi)
        movbeq	488(%rdi), %rdx
        movbeq	480(%rdi), %rax
        movq	%rdx, 16(%rsi)
        movq	%rax, 24(%rsi)
        movbeq	472(%rdi), %rdx
        movbeq	464(%rdi), %rax
        movq	%rdx, 32(%rsi)
        movq	%rax, 40(%rsi)
        movbeq	456(%rdi), %rdx
        movbeq	448(%rdi), %rax
        movq	%rdx, 48(%rsi)
        movq	%rax, 56(%rsi)
        movbeq	440(%rdi), %rdx
        movbeq	432(%rdi), %rax
        movq	%rdx, 64(%rsi)
        movq	%rax, 72(%rsi)
        movbeq	424(%rdi), %rdx
        movbeq	416(%rdi), %rax
        movq	%rdx, 80(%rsi)
        movq	%rax, 88(%rsi)
        movbeq	408(%rdi), %rdx
        movbeq	400(%rdi), %rax
        movq	%rdx, 96(%rsi)
        movq	%rax, 104(%rsi)
        movbeq	392(%rdi), %rdx
        movbeq	384(%rdi), %rax
        movq	%rdx, 112(%rsi)
        movq	%rax, 120(%rsi)
        movbeq	376(%rdi), %rdx
        movbeq	368(%rdi), %rax
        movq	%rdx, 128(%rsi)
        movq	%rax, 136(%rsi)
        movbeq	360(%rdi), %rdx
        movbeq	352(%rdi), %rax
        movq	%rdx, 144(%rsi)
        movq	%rax, 152(%rsi)
        movbeq	344(%rdi), %rdx
        movbeq	336(%rdi), %rax
        movq	%rdx, 160(%rsi)
        movq	%rax, 168(%rsi)
        movbeq	328(%rdi), %rdx
        movbeq	320(%rdi), %rax
        movq	%rdx, 176(%rsi)
        movq	%rax, 184(%rsi)
        movbeq	312(%rdi), %rdx
        movbeq	304(%rdi), %rax
        movq	%rdx, 192(%rsi)
        movq	%rax, 200(%rsi)
        movbeq	296(%rdi), %rdx
        movbeq	288(%rdi), %rax
        movq	%rdx, 208(%rsi)
        movq	%rax, 216(%rsi)
        movbeq	280(%rdi), %rdx
        movbeq	272(%rdi), %rax
        movq	%rdx, 224(%rsi)
        movq	%rax, 232(%rsi)
        movbeq	264(%rdi), %rdx
        movbeq	256(%rdi), %rax
        movq	%rdx, 240(%rsi)
        movq	%rax, 248(%rsi)
        movbeq	248(%rdi), %rdx
        movbeq	240(%rdi), %rax
        movq	%rdx, 256(%rsi)
        movq	%rax, 264(%rsi)
        movbeq	232(%rdi), %rdx
        movbeq	224(%rdi), %rax
        movq	%rdx, 272(%rsi)
        movq	%rax, 280(%rsi)
        movbeq	216(%rdi), %rdx
        movbeq	208(%rdi), %rax
        movq	%rdx, 288(%rsi)
        movq	%rax, 296(%rsi)
        movbeq	200(%rdi), %rdx
        movbeq	192(%rdi), %rax
        movq	%rdx, 304(%rsi)
        movq	%rax, 312(%rsi)
        movbeq	184(%rdi), %rdx
        movbeq	176(%rdi), %rax
        movq	%rdx, 320(%rsi)
        movq	%rax, 328(%rsi)
        movbeq	168(%rdi), %rdx
        movbeq	160(%rdi), %rax
        movq	%rdx, 336(%rsi)
        movq	%rax, 344(%rsi)
        movbeq	152(%rdi), %rdx
        movbeq	144(%rdi), %rax
        movq	%rdx, 352(%rsi)
        movq	%rax, 360(%rsi)
        movbeq	136(%rdi), %rdx
        movbeq	128(%rdi), %rax
        movq	%rdx, 368(%rsi)
        movq	%rax, 376(%rsi)
        movbeq	120(%rdi), %rdx
        movbeq	112(%rdi), %rax
        movq	%rdx, 384(%rsi)
        movq	%rax, 392(%rsi)
        movbeq	104(%rdi), %rdx
        movbeq	96(%rdi), %rax
        movq	%rdx, 400(%rsi)
        movq	%rax, 408(%rsi)
        movbeq	88(%rdi), %rdx
        movbeq	80(%rdi), %rax
        movq	%rdx, 416(%rsi)
        movq	%rax, 424(%rsi)
        movbeq	72(%rdi), %rdx
        movbeq	64(%rdi), %rax
        movq	%rdx, 432(%rsi)
        movq	%rax, 440(%rsi)
        movbeq	56(%rdi), %rdx
        movbeq	48(%rdi), %rax
        movq	%rdx, 448(%rsi)
        movq	%rax, 456(%rsi)
        movbeq	40(%rdi), %rdx
        movbeq	32(%rdi), %rax
        movq	%rdx, 464(%rsi)
        movq	%rax, 472(%rsi)
        movbeq	24(%rdi), %rdx
        movbeq	16(%rdi), %rax
        movq	%rdx, 480(%rsi)
        movq	%rax, 488(%rsi)
        movbeq	8(%rdi), %rdx
        movbeq	(%rdi), %rax
        movq	%rdx, 496(%rsi)
        movq	%rax, 504(%rsi)
        repz retq
#ifndef __APPLE__
.size	sp_4096_to_bin_movbe,.-sp_4096_to_bin_movbe
#endif /* __APPLE__ */
/* Sub b from a into a. (a -= b)
 *
 * a  A single precision integer and result.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_4096_sub_in_place_64
.type	sp_4096_sub_in_place_64,@function
.align	16
sp_4096_sub_in_place_64:
#else
.globl	_sp_4096_sub_in_place_64
.p2align	4
_sp_4096_sub_in_place_64:
#endif /* __APPLE__ */
        movq	(%rdi), %rdx
        xorq	%rax, %rax
        subq	(%rsi), %rdx
        movq	8(%rdi), %rcx
        movq	%rdx, (%rdi)
        sbbq	8(%rsi), %rcx
        movq	16(%rdi), %rdx
        movq	%rcx, 8(%rdi)
        sbbq	16(%rsi), %rdx
        movq	24(%rdi), %rcx
        movq	%rdx, 16(%rdi)
        sbbq	24(%rsi), %rcx
        movq	32(%rdi), %rdx
        movq	%rcx, 24(%rdi)
        sbbq	32(%rsi), %rdx
        movq	40(%rdi), %rcx
        movq	%rdx, 32(%rdi)
        sbbq	40(%rsi), %rcx
        movq	48(%rdi), %rdx
        movq	%rcx, 40(%rdi)
        sbbq	48(%rsi), %rdx
        movq	56(%rdi), %rcx
        movq	%rdx, 48(%rdi)
        sbbq	56(%rsi), %rcx
        movq	64(%rdi), %rdx
        movq	%rcx, 56(%rdi)
        sbbq	64(%rsi), %rdx
        movq	72(%rdi), %rcx
        movq	%rdx, 64(%rdi)
        sbbq	72(%rsi), %rcx
        movq	80(%rdi), %rdx
        movq	%rcx, 72(%rdi)
        sbbq	80(%rsi), %rdx
        movq	88(%rdi), %rcx
        movq	%rdx, 80(%rdi)
        sbbq	88(%rsi), %rcx
        movq	96(%rdi), %rdx
        movq	%rcx, 88(%rdi)
        sbbq	96(%rsi), %rdx
        movq	104(%rdi), %rcx
        movq	%rdx, 96(%rdi)
        sbbq	104(%rsi), %rcx
        movq	112(%rdi), %rdx
        movq	%rcx, 104(%rdi)
        sbbq	112(%rsi), %rdx
        movq	120(%rdi), %rcx
        movq	%rdx, 112(%rdi)
        sbbq	120(%rsi), %rcx
        movq	128(%rdi), %rdx
        movq	%rcx, 120(%rdi)
        sbbq	128(%rsi), %rdx
        movq	136(%rdi), %rcx
        movq	%rdx, 128(%rdi)
        sbbq	136(%rsi), %rcx
        movq	144(%rdi), %rdx
        movq	%rcx, 136(%rdi)
        sbbq	144(%rsi), %rdx
        movq	152(%rdi), %rcx
        movq	%rdx, 144(%rdi)
        sbbq	152(%rsi), %rcx
        movq	160(%rdi), %rdx
        movq	%rcx, 152(%rdi)
        sbbq	160(%rsi), %rdx
        movq	168(%rdi), %rcx
        movq	%rdx, 160(%rdi)
        sbbq	168(%rsi), %rcx
        movq	176(%rdi), %rdx
        movq	%rcx, 168(%rdi)
        sbbq	176(%rsi), %rdx
        movq	184(%rdi), %rcx
        movq	%rdx, 176(%rdi)
        sbbq	184(%rsi), %rcx
        movq	192(%rdi), %rdx
        movq	%rcx, 184(%rdi)
        sbbq	192(%rsi), %rdx
        movq	200(%rdi), %rcx
        movq	%rdx, 192(%rdi)
        sbbq	200(%rsi), %rcx
        movq	208(%rdi), %rdx
        movq	%rcx, 200(%rdi)
        sbbq	208(%rsi), %rdx
        movq	216(%rdi), %rcx
        movq	%rdx, 208(%rdi)
        sbbq	216(%rsi), %rcx
        movq	224(%rdi), %rdx
        movq	%rcx, 216(%rdi)
        sbbq	224(%rsi), %rdx
        movq	232(%rdi), %rcx
        movq	%rdx, 224(%rdi)
        sbbq	232(%rsi), %rcx
        movq	240(%rdi), %rdx
        movq	%rcx, 232(%rdi)
        sbbq	240(%rsi), %rdx
        movq	248(%rdi), %rcx
        movq	%rdx, 240(%rdi)
        sbbq	248(%rsi), %rcx
        movq	256(%rdi), %rdx
        movq	%rcx, 248(%rdi)
        sbbq	256(%rsi), %rdx
        movq	264(%rdi), %rcx
        movq	%rdx, 256(%rdi)
        sbbq	264(%rsi), %rcx
        movq	272(%rdi), %rdx
        movq	%rcx, 264(%rdi)
        sbbq	272(%rsi), %rdx
        movq	280(%rdi), %rcx
        movq	%rdx, 272(%rdi)
        sbbq	280(%rsi), %rcx
        movq	288(%rdi), %rdx
        movq	%rcx, 280(%rdi)
        sbbq	288(%rsi), %rdx
        movq	296(%rdi), %rcx
        movq	%rdx, 288(%rdi)
        sbbq	296(%rsi), %rcx
        movq	304(%rdi), %rdx
        movq	%rcx, 296(%rdi)
        sbbq	304(%rsi), %rdx
        movq	312(%rdi), %rcx
        movq	%rdx, 304(%rdi)
        sbbq	312(%rsi), %rcx
        movq	320(%rdi), %rdx
        movq	%rcx, 312(%rdi)
        sbbq	320(%rsi), %rdx
        movq	328(%rdi), %rcx
        movq	%rdx, 320(%rdi)
        sbbq	328(%rsi), %rcx
        movq	336(%rdi), %rdx
        movq	%rcx, 328(%rdi)
        sbbq	336(%rsi), %rdx
        movq	344(%rdi), %rcx
        movq	%rdx, 336(%rdi)
        sbbq	344(%rsi), %rcx
        movq	352(%rdi), %rdx
        movq	%rcx, 344(%rdi)
        sbbq	352(%rsi), %rdx
        movq	360(%rdi), %rcx
        movq	%rdx, 352(%rdi)
        sbbq	360(%rsi), %rcx
        movq	368(%rdi), %rdx
        movq	%rcx, 360(%rdi)
        sbbq	368(%rsi), %rdx
        movq	376(%rdi), %rcx
        movq	%rdx, 368(%rdi)
        sbbq	376(%rsi), %rcx
        movq	384(%rdi), %rdx
        movq	%rcx, 376(%rdi)
        sbbq	384(%rsi), %rdx
        movq	392(%rdi), %rcx
        movq	%rdx, 384(%rdi)
        sbbq	392(%rsi), %rcx
        movq	400(%rdi), %rdx
        movq	%rcx, 392(%rdi)
        sbbq	400(%rsi), %rdx
        movq	408(%rdi), %rcx
        movq	%rdx, 400(%rdi)
        sbbq	408(%rsi), %rcx
        movq	416(%rdi), %rdx
        movq	%rcx, 408(%rdi)
        sbbq	416(%rsi), %rdx
        movq	424(%rdi), %rcx
        movq	%rdx, 416(%rdi)
        sbbq	424(%rsi), %rcx
        movq	432(%rdi), %rdx
        movq	%rcx, 424(%rdi)
        sbbq	432(%rsi), %rdx
        movq	440(%rdi), %rcx
        movq	%rdx, 432(%rdi)
        sbbq	440(%rsi), %rcx
        movq	448(%rdi), %rdx
        movq	%rcx, 440(%rdi)
        sbbq	448(%rsi), %rdx
        movq	456(%rdi), %rcx
        movq	%rdx, 448(%rdi)
        sbbq	456(%rsi), %rcx
        movq	464(%rdi), %rdx
        movq	%rcx, 456(%rdi)
        sbbq	464(%rsi), %rdx
        movq	472(%rdi), %rcx
        movq	%rdx, 464(%rdi)
        sbbq	472(%rsi), %rcx
        movq	480(%rdi), %rdx
        movq	%rcx, 472(%rdi)
        sbbq	480(%rsi), %rdx
        movq	488(%rdi), %rcx
        movq	%rdx, 480(%rdi)
        sbbq	488(%rsi), %rcx
        movq	496(%rdi), %rdx
        movq	%rcx, 488(%rdi)
        sbbq	496(%rsi), %rdx
        movq	504(%rdi), %rcx
        movq	%rdx, 496(%rdi)
        sbbq	504(%rsi), %rcx
        movq	%rcx, 504(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_4096_sub_in_place_64,.-sp_4096_sub_in_place_64
#endif /* __APPLE__ */
/* Add b to a into r. (r = a + b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_4096_add_64
.type	sp_4096_add_64,@function
.align	16
sp_4096_add_64:
#else
.globl	_sp_4096_add_64
.p2align	4
_sp_4096_add_64:
#endif /* __APPLE__ */
        # Add
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        addq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        adcq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        adcq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        adcq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        adcq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        adcq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        adcq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        adcq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        adcq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        adcq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        adcq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        adcq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        adcq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        adcq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        adcq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        adcq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        adcq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        adcq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        adcq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        adcq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        adcq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        adcq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        adcq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        adcq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        adcq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        adcq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        adcq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        adcq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        adcq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        adcq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        adcq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        adcq	248(%rdx), %r8
        movq	256(%rsi), %rcx
        movq	%r8, 248(%rdi)
        adcq	256(%rdx), %rcx
        movq	264(%rsi), %r8
        movq	%rcx, 256(%rdi)
        adcq	264(%rdx), %r8
        movq	272(%rsi), %rcx
        movq	%r8, 264(%rdi)
        adcq	272(%rdx), %rcx
        movq	280(%rsi), %r8
        movq	%rcx, 272(%rdi)
        adcq	280(%rdx), %r8
        movq	288(%rsi), %rcx
        movq	%r8, 280(%rdi)
        adcq	288(%rdx), %rcx
        movq	296(%rsi), %r8
        movq	%rcx, 288(%rdi)
        adcq	296(%rdx), %r8
        movq	304(%rsi), %rcx
        movq	%r8, 296(%rdi)
        adcq	304(%rdx), %rcx
        movq	312(%rsi), %r8
        movq	%rcx, 304(%rdi)
        adcq	312(%rdx), %r8
        movq	320(%rsi), %rcx
        movq	%r8, 312(%rdi)
        adcq	320(%rdx), %rcx
        movq	328(%rsi), %r8
        movq	%rcx, 320(%rdi)
        adcq	328(%rdx), %r8
        movq	336(%rsi), %rcx
        movq	%r8, 328(%rdi)
        adcq	336(%rdx), %rcx
        movq	344(%rsi), %r8
        movq	%rcx, 336(%rdi)
        adcq	344(%rdx), %r8
        movq	352(%rsi), %rcx
        movq	%r8, 344(%rdi)
        adcq	352(%rdx), %rcx
        movq	360(%rsi), %r8
        movq	%rcx, 352(%rdi)
        adcq	360(%rdx), %r8
        movq	368(%rsi), %rcx
        movq	%r8, 360(%rdi)
        adcq	368(%rdx), %rcx
        movq	376(%rsi), %r8
        movq	%rcx, 368(%rdi)
        adcq	376(%rdx), %r8
        movq	384(%rsi), %rcx
        movq	%r8, 376(%rdi)
        adcq	384(%rdx), %rcx
        movq	392(%rsi), %r8
        movq	%rcx, 384(%rdi)
        adcq	392(%rdx), %r8
        movq	400(%rsi), %rcx
        movq	%r8, 392(%rdi)
        adcq	400(%rdx), %rcx
        movq	408(%rsi), %r8
        movq	%rcx, 400(%rdi)
        adcq	408(%rdx), %r8
        movq	416(%rsi), %rcx
        movq	%r8, 408(%rdi)
        adcq	416(%rdx), %rcx
        movq	424(%rsi), %r8
        movq	%rcx, 416(%rdi)
        adcq	424(%rdx), %r8
        movq	432(%rsi), %rcx
        movq	%r8, 424(%rdi)
        adcq	432(%rdx), %rcx
        movq	440(%rsi), %r8
        movq	%rcx, 432(%rdi)
        adcq	440(%rdx), %r8
        movq	448(%rsi), %rcx
        movq	%r8, 440(%rdi)
        adcq	448(%rdx), %rcx
        movq	456(%rsi), %r8
        movq	%rcx, 448(%rdi)
        adcq	456(%rdx), %r8
        movq	464(%rsi), %rcx
        movq	%r8, 456(%rdi)
        adcq	464(%rdx), %rcx
        movq	472(%rsi), %r8
        movq	%rcx, 464(%rdi)
        adcq	472(%rdx), %r8
        movq	480(%rsi), %rcx
        movq	%r8, 472(%rdi)
        adcq	480(%rdx), %rcx
        movq	488(%rsi), %r8
        movq	%rcx, 480(%rdi)
        adcq	488(%rdx), %r8
        movq	496(%rsi), %rcx
        movq	%r8, 488(%rdi)
        adcq	496(%rdx), %rcx
        movq	504(%rsi), %r8
        movq	%rcx, 496(%rdi)
        adcq	504(%rdx), %r8
        movq	%r8, 504(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_4096_add_64,.-sp_4096_add_64
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_4096_mul_64
.type	sp_4096_mul_64,@function
.align	16
sp_4096_mul_64:
#else
.globl	_sp_4096_mul_64
.p2align	4
_sp_4096_mul_64:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$1576, %rsp
        movq	%rdi, 1536(%rsp)
        movq	%rsi, 1544(%rsp)
        movq	%rdx, 1552(%rsp)
        leaq	1024(%rsp), %r10
        leaq	256(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	128(%rsi), %rcx
        movq	%rax, 120(%r10)
        adcq	128(%r12), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%r10)
        adcq	136(%r12), %r8
        movq	144(%rsi), %rax
        movq	%r8, 136(%r10)
        adcq	144(%r12), %rax
        movq	152(%rsi), %rcx
        movq	%rax, 144(%r10)
        adcq	152(%r12), %rcx
        movq	160(%rsi), %r8
        movq	%rcx, 152(%r10)
        adcq	160(%r12), %r8
        movq	168(%rsi), %rax
        movq	%r8, 160(%r10)
        adcq	168(%r12), %rax
        movq	176(%rsi), %rcx
        movq	%rax, 168(%r10)
        adcq	176(%r12), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%r10)
        adcq	184(%r12), %r8
        movq	192(%rsi), %rax
        movq	%r8, 184(%r10)
        adcq	192(%r12), %rax
        movq	200(%rsi), %rcx
        movq	%rax, 192(%r10)
        adcq	200(%r12), %rcx
        movq	208(%rsi), %r8
        movq	%rcx, 200(%r10)
        adcq	208(%r12), %r8
        movq	216(%rsi), %rax
        movq	%r8, 208(%r10)
        adcq	216(%r12), %rax
        movq	224(%rsi), %rcx
        movq	%rax, 216(%r10)
        adcq	224(%r12), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%r10)
        adcq	232(%r12), %r8
        movq	240(%rsi), %rax
        movq	%r8, 232(%r10)
        adcq	240(%r12), %rax
        movq	248(%rsi), %rcx
        movq	%rax, 240(%r10)
        adcq	248(%r12), %rcx
        movq	%rcx, 248(%r10)
        adcq	$0, %r13
        movq	%r13, 1560(%rsp)
        leaq	1280(%rsp), %r11
        leaq	256(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	128(%rdx), %rcx
        movq	%rax, 120(%r11)
        adcq	128(%r12), %rcx
        movq	136(%rdx), %r8
        movq	%rcx, 128(%r11)
        adcq	136(%r12), %r8
        movq	144(%rdx), %rax
        movq	%r8, 136(%r11)
        adcq	144(%r12), %rax
        movq	152(%rdx), %rcx
        movq	%rax, 144(%r11)
        adcq	152(%r12), %rcx
        movq	160(%rdx), %r8
        movq	%rcx, 152(%r11)
        adcq	160(%r12), %r8
        movq	168(%rdx), %rax
        movq	%r8, 160(%r11)
        adcq	168(%r12), %rax
        movq	176(%rdx), %rcx
        movq	%rax, 168(%r11)
        adcq	176(%r12), %rcx
        movq	184(%rdx), %r8
        movq	%rcx, 176(%r11)
        adcq	184(%r12), %r8
        movq	192(%rdx), %rax
        movq	%r8, 184(%r11)
        adcq	192(%r12), %rax
        movq	200(%rdx), %rcx
        movq	%rax, 192(%r11)
        adcq	200(%r12), %rcx
        movq	208(%rdx), %r8
        movq	%rcx, 200(%r11)
        adcq	208(%r12), %r8
        movq	216(%rdx), %rax
        movq	%r8, 208(%r11)
        adcq	216(%r12), %rax
        movq	224(%rdx), %rcx
        movq	%rax, 216(%r11)
        adcq	224(%r12), %rcx
        movq	232(%rdx), %r8
        movq	%rcx, 224(%r11)
        adcq	232(%r12), %r8
        movq	240(%rdx), %rax
        movq	%r8, 232(%r11)
        adcq	240(%r12), %rax
        movq	248(%rdx), %rcx
        movq	%rax, 240(%r11)
        adcq	248(%r12), %rcx
        movq	%rcx, 248(%r11)
        adcq	$0, %r14
        movq	%r14, 1568(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_32@plt
#else
        callq	_sp_2048_mul_32
#endif /* __APPLE__ */
        movq	1552(%rsp), %rdx
        movq	1544(%rsp), %rsi
        leaq	512(%rsp), %rdi
        addq	$256, %rdx
        addq	$256, %rsi
#ifndef __APPLE__
        callq	sp_2048_mul_32@plt
#else
        callq	_sp_2048_mul_32
#endif /* __APPLE__ */
        movq	1552(%rsp), %rdx
        movq	1544(%rsp), %rsi
        movq	1536(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_32@plt
#else
        callq	_sp_2048_mul_32
#endif /* __APPLE__ */
        movq	1560(%rsp), %r13
        movq	1568(%rsp), %r14
        movq	1536(%rsp), %r15
        movq	%r13, %r9
        leaq	1024(%rsp), %r10
        leaq	1280(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$512, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, (%r10)
        movq	%rcx, (%r11)
        movq	8(%r10), %rax
        movq	8(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 8(%r10)
        movq	%rcx, 8(%r11)
        movq	16(%r10), %rax
        movq	16(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 16(%r10)
        movq	%rcx, 16(%r11)
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 24(%r10)
        movq	%rcx, 24(%r11)
        movq	32(%r10), %rax
        movq	32(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 32(%r10)
        movq	%rcx, 32(%r11)
        movq	40(%r10), %rax
        movq	40(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 40(%r10)
        movq	%rcx, 40(%r11)
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 48(%r10)
        movq	%rcx, 48(%r11)
        movq	56(%r10), %rax
        movq	56(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 56(%r10)
        movq	%rcx, 56(%r11)
        movq	64(%r10), %rax
        movq	64(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 64(%r10)
        movq	%rcx, 64(%r11)
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 72(%r10)
        movq	%rcx, 72(%r11)
        movq	80(%r10), %rax
        movq	80(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 80(%r10)
        movq	%rcx, 80(%r11)
        movq	88(%r10), %rax
        movq	88(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 88(%r10)
        movq	%rcx, 88(%r11)
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 96(%r10)
        movq	%rcx, 96(%r11)
        movq	104(%r10), %rax
        movq	104(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 104(%r10)
        movq	%rcx, 104(%r11)
        movq	112(%r10), %rax
        movq	112(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 112(%r10)
        movq	%rcx, 112(%r11)
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 120(%r10)
        movq	%rcx, 120(%r11)
        movq	128(%r10), %rax
        movq	128(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 128(%r10)
        movq	%rcx, 128(%r11)
        movq	136(%r10), %rax
        movq	136(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 136(%r10)
        movq	%rcx, 136(%r11)
        movq	144(%r10), %rax
        movq	144(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 144(%r10)
        movq	%rcx, 144(%r11)
        movq	152(%r10), %rax
        movq	152(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 152(%r10)
        movq	%rcx, 152(%r11)
        movq	160(%r10), %rax
        movq	160(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 160(%r10)
        movq	%rcx, 160(%r11)
        movq	168(%r10), %rax
        movq	168(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 168(%r10)
        movq	%rcx, 168(%r11)
        movq	176(%r10), %rax
        movq	176(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 176(%r10)
        movq	%rcx, 176(%r11)
        movq	184(%r10), %rax
        movq	184(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 184(%r10)
        movq	%rcx, 184(%r11)
        movq	192(%r10), %rax
        movq	192(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 192(%r10)
        movq	%rcx, 192(%r11)
        movq	200(%r10), %rax
        movq	200(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 200(%r10)
        movq	%rcx, 200(%r11)
        movq	208(%r10), %rax
        movq	208(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 208(%r10)
        movq	%rcx, 208(%r11)
        movq	216(%r10), %rax
        movq	216(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 216(%r10)
        movq	%rcx, 216(%r11)
        movq	224(%r10), %rax
        movq	224(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 224(%r10)
        movq	%rcx, 224(%r11)
        movq	232(%r10), %rax
        movq	232(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 232(%r10)
        movq	%rcx, 232(%r11)
        movq	240(%r10), %rax
        movq	240(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 240(%r10)
        movq	%rcx, 240(%r11)
        movq	248(%r10), %rax
        movq	248(%r11), %rcx
        andq	%r14, %rax
        andq	%r13, %rcx
        movq	%rax, 248(%r10)
        movq	%rcx, 248(%r11)
        movq	(%r10), %rax
        addq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r11), %rcx
        movq	%rcx, 248(%r15)
        adcq	$0, %r9
        leaq	512(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%r11), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%r11), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%r11), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%r11), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%r11), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%r11), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%r11), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%r11), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%r11), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%r11), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%r11), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%r11), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%r11), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%r11), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%r11), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%r11), %r8
        movq	384(%r10), %rax
        movq	%r8, 376(%r10)
        sbbq	384(%r11), %rax
        movq	392(%r10), %rcx
        movq	%rax, 384(%r10)
        sbbq	392(%r11), %rcx
        movq	400(%r10), %r8
        movq	%rcx, 392(%r10)
        sbbq	400(%r11), %r8
        movq	408(%r10), %rax
        movq	%r8, 400(%r10)
        sbbq	408(%r11), %rax
        movq	416(%r10), %rcx
        movq	%rax, 408(%r10)
        sbbq	416(%r11), %rcx
        movq	424(%r10), %r8
        movq	%rcx, 416(%r10)
        sbbq	424(%r11), %r8
        movq	432(%r10), %rax
        movq	%r8, 424(%r10)
        sbbq	432(%r11), %rax
        movq	440(%r10), %rcx
        movq	%rax, 432(%r10)
        sbbq	440(%r11), %rcx
        movq	448(%r10), %r8
        movq	%rcx, 440(%r10)
        sbbq	448(%r11), %r8
        movq	456(%r10), %rax
        movq	%r8, 448(%r10)
        sbbq	456(%r11), %rax
        movq	464(%r10), %rcx
        movq	%rax, 456(%r10)
        sbbq	464(%r11), %rcx
        movq	472(%r10), %r8
        movq	%rcx, 464(%r10)
        sbbq	472(%r11), %r8
        movq	480(%r10), %rax
        movq	%r8, 472(%r10)
        sbbq	480(%r11), %rax
        movq	488(%r10), %rcx
        movq	%rax, 480(%r10)
        sbbq	488(%r11), %rcx
        movq	496(%r10), %r8
        movq	%rcx, 488(%r10)
        sbbq	496(%r11), %r8
        movq	504(%r10), %rax
        movq	%r8, 496(%r10)
        sbbq	504(%r11), %rax
        movq	%rax, 504(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%rdi), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%rdi), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%rdi), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%rdi), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%rdi), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%rdi), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%rdi), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%rdi), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%rdi), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%rdi), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%rdi), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%rdi), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%rdi), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%rdi), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%rdi), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%rdi), %r8
        movq	384(%r10), %rax
        movq	%r8, 376(%r10)
        sbbq	384(%rdi), %rax
        movq	392(%r10), %rcx
        movq	%rax, 384(%r10)
        sbbq	392(%rdi), %rcx
        movq	400(%r10), %r8
        movq	%rcx, 392(%r10)
        sbbq	400(%rdi), %r8
        movq	408(%r10), %rax
        movq	%r8, 400(%r10)
        sbbq	408(%rdi), %rax
        movq	416(%r10), %rcx
        movq	%rax, 408(%r10)
        sbbq	416(%rdi), %rcx
        movq	424(%r10), %r8
        movq	%rcx, 416(%r10)
        sbbq	424(%rdi), %r8
        movq	432(%r10), %rax
        movq	%r8, 424(%r10)
        sbbq	432(%rdi), %rax
        movq	440(%r10), %rcx
        movq	%rax, 432(%r10)
        sbbq	440(%rdi), %rcx
        movq	448(%r10), %r8
        movq	%rcx, 440(%r10)
        sbbq	448(%rdi), %r8
        movq	456(%r10), %rax
        movq	%r8, 448(%r10)
        sbbq	456(%rdi), %rax
        movq	464(%r10), %rcx
        movq	%rax, 456(%r10)
        sbbq	464(%rdi), %rcx
        movq	472(%r10), %r8
        movq	%rcx, 464(%r10)
        sbbq	472(%rdi), %r8
        movq	480(%r10), %rax
        movq	%r8, 472(%r10)
        sbbq	480(%rdi), %rax
        movq	488(%r10), %rcx
        movq	%rax, 480(%r10)
        sbbq	488(%rdi), %rcx
        movq	496(%r10), %r8
        movq	%rcx, 488(%r10)
        sbbq	496(%rdi), %r8
        movq	504(%r10), %rax
        movq	%r8, 496(%r10)
        sbbq	504(%rdi), %rax
        movq	%rax, 504(%r10)
        sbbq	$0, %r9
        subq	$256, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r10), %r8
        movq	264(%r15), %rax
        movq	%r8, 256(%r15)
        adcq	264(%r10), %rax
        movq	272(%r15), %rcx
        movq	%rax, 264(%r15)
        adcq	272(%r10), %rcx
        movq	280(%r15), %r8
        movq	%rcx, 272(%r15)
        adcq	280(%r10), %r8
        movq	288(%r15), %rax
        movq	%r8, 280(%r15)
        adcq	288(%r10), %rax
        movq	296(%r15), %rcx
        movq	%rax, 288(%r15)
        adcq	296(%r10), %rcx
        movq	304(%r15), %r8
        movq	%rcx, 296(%r15)
        adcq	304(%r10), %r8
        movq	312(%r15), %rax
        movq	%r8, 304(%r15)
        adcq	312(%r10), %rax
        movq	320(%r15), %rcx
        movq	%rax, 312(%r15)
        adcq	320(%r10), %rcx
        movq	328(%r15), %r8
        movq	%rcx, 320(%r15)
        adcq	328(%r10), %r8
        movq	336(%r15), %rax
        movq	%r8, 328(%r15)
        adcq	336(%r10), %rax
        movq	344(%r15), %rcx
        movq	%rax, 336(%r15)
        adcq	344(%r10), %rcx
        movq	352(%r15), %r8
        movq	%rcx, 344(%r15)
        adcq	352(%r10), %r8
        movq	360(%r15), %rax
        movq	%r8, 352(%r15)
        adcq	360(%r10), %rax
        movq	368(%r15), %rcx
        movq	%rax, 360(%r15)
        adcq	368(%r10), %rcx
        movq	376(%r15), %r8
        movq	%rcx, 368(%r15)
        adcq	376(%r10), %r8
        movq	384(%r15), %rax
        movq	%r8, 376(%r15)
        adcq	384(%r10), %rax
        movq	392(%r15), %rcx
        movq	%rax, 384(%r15)
        adcq	392(%r10), %rcx
        movq	400(%r15), %r8
        movq	%rcx, 392(%r15)
        adcq	400(%r10), %r8
        movq	408(%r15), %rax
        movq	%r8, 400(%r15)
        adcq	408(%r10), %rax
        movq	416(%r15), %rcx
        movq	%rax, 408(%r15)
        adcq	416(%r10), %rcx
        movq	424(%r15), %r8
        movq	%rcx, 416(%r15)
        adcq	424(%r10), %r8
        movq	432(%r15), %rax
        movq	%r8, 424(%r15)
        adcq	432(%r10), %rax
        movq	440(%r15), %rcx
        movq	%rax, 432(%r15)
        adcq	440(%r10), %rcx
        movq	448(%r15), %r8
        movq	%rcx, 440(%r15)
        adcq	448(%r10), %r8
        movq	456(%r15), %rax
        movq	%r8, 448(%r15)
        adcq	456(%r10), %rax
        movq	464(%r15), %rcx
        movq	%rax, 456(%r15)
        adcq	464(%r10), %rcx
        movq	472(%r15), %r8
        movq	%rcx, 464(%r15)
        adcq	472(%r10), %r8
        movq	480(%r15), %rax
        movq	%r8, 472(%r15)
        adcq	480(%r10), %rax
        movq	488(%r15), %rcx
        movq	%rax, 480(%r15)
        adcq	488(%r10), %rcx
        movq	496(%r15), %r8
        movq	%rcx, 488(%r15)
        adcq	496(%r10), %r8
        movq	504(%r15), %rax
        movq	%r8, 496(%r15)
        adcq	504(%r10), %rax
        movq	%rax, 504(%r15)
        adcq	$0, %r9
        movq	%r9, 768(%rdi)
        addq	$256, %r15
        # Add
        movq	(%r15), %rax
        xorq	%r9, %r9
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r11), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r11), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r11), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r11), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r11), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r11), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r11), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r11), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r11), %r8
        movq	%r8, 256(%r15)
        adcq	$0, %r9
        # Add to zero
        movq	264(%r11), %rax
        adcq	$0, %rax
        movq	272(%r11), %rcx
        movq	%rax, 264(%r15)
        adcq	$0, %rcx
        movq	280(%r11), %r8
        movq	%rcx, 272(%r15)
        adcq	$0, %r8
        movq	288(%r11), %rax
        movq	%r8, 280(%r15)
        adcq	$0, %rax
        movq	296(%r11), %rcx
        movq	%rax, 288(%r15)
        adcq	$0, %rcx
        movq	304(%r11), %r8
        movq	%rcx, 296(%r15)
        adcq	$0, %r8
        movq	312(%r11), %rax
        movq	%r8, 304(%r15)
        adcq	$0, %rax
        movq	320(%r11), %rcx
        movq	%rax, 312(%r15)
        adcq	$0, %rcx
        movq	328(%r11), %r8
        movq	%rcx, 320(%r15)
        adcq	$0, %r8
        movq	336(%r11), %rax
        movq	%r8, 328(%r15)
        adcq	$0, %rax
        movq	344(%r11), %rcx
        movq	%rax, 336(%r15)
        adcq	$0, %rcx
        movq	352(%r11), %r8
        movq	%rcx, 344(%r15)
        adcq	$0, %r8
        movq	360(%r11), %rax
        movq	%r8, 352(%r15)
        adcq	$0, %rax
        movq	368(%r11), %rcx
        movq	%rax, 360(%r15)
        adcq	$0, %rcx
        movq	376(%r11), %r8
        movq	%rcx, 368(%r15)
        adcq	$0, %r8
        movq	384(%r11), %rax
        movq	%r8, 376(%r15)
        adcq	$0, %rax
        movq	392(%r11), %rcx
        movq	%rax, 384(%r15)
        adcq	$0, %rcx
        movq	400(%r11), %r8
        movq	%rcx, 392(%r15)
        adcq	$0, %r8
        movq	408(%r11), %rax
        movq	%r8, 400(%r15)
        adcq	$0, %rax
        movq	416(%r11), %rcx
        movq	%rax, 408(%r15)
        adcq	$0, %rcx
        movq	424(%r11), %r8
        movq	%rcx, 416(%r15)
        adcq	$0, %r8
        movq	432(%r11), %rax
        movq	%r8, 424(%r15)
        adcq	$0, %rax
        movq	440(%r11), %rcx
        movq	%rax, 432(%r15)
        adcq	$0, %rcx
        movq	448(%r11), %r8
        movq	%rcx, 440(%r15)
        adcq	$0, %r8
        movq	456(%r11), %rax
        movq	%r8, 448(%r15)
        adcq	$0, %rax
        movq	464(%r11), %rcx
        movq	%rax, 456(%r15)
        adcq	$0, %rcx
        movq	472(%r11), %r8
        movq	%rcx, 464(%r15)
        adcq	$0, %r8
        movq	480(%r11), %rax
        movq	%r8, 472(%r15)
        adcq	$0, %rax
        movq	488(%r11), %rcx
        movq	%rax, 480(%r15)
        adcq	$0, %rcx
        movq	496(%r11), %r8
        movq	%rcx, 488(%r15)
        adcq	$0, %r8
        movq	504(%r11), %rax
        movq	%r8, 496(%r15)
        adcq	$0, %rax
        movq	%rax, 504(%r15)
        addq	$1576, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_4096_mul_64,.-sp_4096_mul_64
#endif /* __APPLE__ */
/* Add a to a into r. (r = a + a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_2048_dbl_32
.type	sp_2048_dbl_32,@function
.align	16
sp_2048_dbl_32:
#else
.globl	_sp_2048_dbl_32
.p2align	4
_sp_2048_dbl_32:
#endif /* __APPLE__ */
        movq	(%rsi), %rdx
        xorq	%rax, %rax
        addq	%rdx, %rdx
        movq	8(%rsi), %rcx
        movq	%rdx, (%rdi)
        adcq	%rcx, %rcx
        movq	16(%rsi), %rdx
        movq	%rcx, 8(%rdi)
        adcq	%rdx, %rdx
        movq	24(%rsi), %rcx
        movq	%rdx, 16(%rdi)
        adcq	%rcx, %rcx
        movq	32(%rsi), %rdx
        movq	%rcx, 24(%rdi)
        adcq	%rdx, %rdx
        movq	40(%rsi), %rcx
        movq	%rdx, 32(%rdi)
        adcq	%rcx, %rcx
        movq	48(%rsi), %rdx
        movq	%rcx, 40(%rdi)
        adcq	%rdx, %rdx
        movq	56(%rsi), %rcx
        movq	%rdx, 48(%rdi)
        adcq	%rcx, %rcx
        movq	64(%rsi), %rdx
        movq	%rcx, 56(%rdi)
        adcq	%rdx, %rdx
        movq	72(%rsi), %rcx
        movq	%rdx, 64(%rdi)
        adcq	%rcx, %rcx
        movq	80(%rsi), %rdx
        movq	%rcx, 72(%rdi)
        adcq	%rdx, %rdx
        movq	88(%rsi), %rcx
        movq	%rdx, 80(%rdi)
        adcq	%rcx, %rcx
        movq	96(%rsi), %rdx
        movq	%rcx, 88(%rdi)
        adcq	%rdx, %rdx
        movq	104(%rsi), %rcx
        movq	%rdx, 96(%rdi)
        adcq	%rcx, %rcx
        movq	112(%rsi), %rdx
        movq	%rcx, 104(%rdi)
        adcq	%rdx, %rdx
        movq	120(%rsi), %rcx
        movq	%rdx, 112(%rdi)
        adcq	%rcx, %rcx
        movq	128(%rsi), %rdx
        movq	%rcx, 120(%rdi)
        adcq	%rdx, %rdx
        movq	136(%rsi), %rcx
        movq	%rdx, 128(%rdi)
        adcq	%rcx, %rcx
        movq	144(%rsi), %rdx
        movq	%rcx, 136(%rdi)
        adcq	%rdx, %rdx
        movq	152(%rsi), %rcx
        movq	%rdx, 144(%rdi)
        adcq	%rcx, %rcx
        movq	160(%rsi), %rdx
        movq	%rcx, 152(%rdi)
        adcq	%rdx, %rdx
        movq	168(%rsi), %rcx
        movq	%rdx, 160(%rdi)
        adcq	%rcx, %rcx
        movq	176(%rsi), %rdx
        movq	%rcx, 168(%rdi)
        adcq	%rdx, %rdx
        movq	184(%rsi), %rcx
        movq	%rdx, 176(%rdi)
        adcq	%rcx, %rcx
        movq	192(%rsi), %rdx
        movq	%rcx, 184(%rdi)
        adcq	%rdx, %rdx
        movq	200(%rsi), %rcx
        movq	%rdx, 192(%rdi)
        adcq	%rcx, %rcx
        movq	208(%rsi), %rdx
        movq	%rcx, 200(%rdi)
        adcq	%rdx, %rdx
        movq	216(%rsi), %rcx
        movq	%rdx, 208(%rdi)
        adcq	%rcx, %rcx
        movq	224(%rsi), %rdx
        movq	%rcx, 216(%rdi)
        adcq	%rdx, %rdx
        movq	232(%rsi), %rcx
        movq	%rdx, 224(%rdi)
        adcq	%rcx, %rcx
        movq	240(%rsi), %rdx
        movq	%rcx, 232(%rdi)
        adcq	%rdx, %rdx
        movq	248(%rsi), %rcx
        movq	%rdx, 240(%rdi)
        adcq	%rcx, %rcx
        movq	%rcx, 248(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_2048_dbl_32,.-sp_2048_dbl_32
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_4096_sqr_64
.type	sp_4096_sqr_64,@function
.align	16
sp_4096_sqr_64:
#else
.globl	_sp_4096_sqr_64
.p2align	4
_sp_4096_sqr_64:
#endif /* __APPLE__ */
        subq	$1304, %rsp
        movq	%rdi, 1280(%rsp)
        movq	%rsi, 1288(%rsp)
        leaq	1024(%rsp), %r8
        leaq	256(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        adcq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        adcq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        adcq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        adcq	120(%r9), %rax
        movq	128(%rsi), %rdx
        movq	%rax, 120(%r8)
        adcq	128(%r9), %rdx
        movq	136(%rsi), %rax
        movq	%rdx, 128(%r8)
        adcq	136(%r9), %rax
        movq	144(%rsi), %rdx
        movq	%rax, 136(%r8)
        adcq	144(%r9), %rdx
        movq	152(%rsi), %rax
        movq	%rdx, 144(%r8)
        adcq	152(%r9), %rax
        movq	160(%rsi), %rdx
        movq	%rax, 152(%r8)
        adcq	160(%r9), %rdx
        movq	168(%rsi), %rax
        movq	%rdx, 160(%r8)
        adcq	168(%r9), %rax
        movq	176(%rsi), %rdx
        movq	%rax, 168(%r8)
        adcq	176(%r9), %rdx
        movq	184(%rsi), %rax
        movq	%rdx, 176(%r8)
        adcq	184(%r9), %rax
        movq	192(%rsi), %rdx
        movq	%rax, 184(%r8)
        adcq	192(%r9), %rdx
        movq	200(%rsi), %rax
        movq	%rdx, 192(%r8)
        adcq	200(%r9), %rax
        movq	208(%rsi), %rdx
        movq	%rax, 200(%r8)
        adcq	208(%r9), %rdx
        movq	216(%rsi), %rax
        movq	%rdx, 208(%r8)
        adcq	216(%r9), %rax
        movq	224(%rsi), %rdx
        movq	%rax, 216(%r8)
        adcq	224(%r9), %rdx
        movq	232(%rsi), %rax
        movq	%rdx, 224(%r8)
        adcq	232(%r9), %rax
        movq	240(%rsi), %rdx
        movq	%rax, 232(%r8)
        adcq	240(%r9), %rdx
        movq	248(%rsi), %rax
        movq	%rdx, 240(%r8)
        adcq	248(%r9), %rax
        movq	%rax, 248(%r8)
        adcq	$0, %rcx
        movq	%rcx, 1296(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_32@plt
#else
        callq	_sp_2048_sqr_32
#endif /* __APPLE__ */
        movq	1288(%rsp), %rsi
        leaq	512(%rsp), %rdi
        addq	$256, %rsi
#ifndef __APPLE__
        callq	sp_2048_sqr_32@plt
#else
        callq	_sp_2048_sqr_32
#endif /* __APPLE__ */
        movq	1288(%rsp), %rsi
        movq	1280(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_32@plt
#else
        callq	_sp_2048_sqr_32
#endif /* __APPLE__ */
        movq	1296(%rsp), %r10
        leaq	1024(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        movq	(%r8), %rdx
        movq	8(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 512(%rdi)
        movq	%rax, 520(%rdi)
        movq	16(%r8), %rdx
        movq	24(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 528(%rdi)
        movq	%rax, 536(%rdi)
        movq	32(%r8), %rdx
        movq	40(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 544(%rdi)
        movq	%rax, 552(%rdi)
        movq	48(%r8), %rdx
        movq	56(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 560(%rdi)
        movq	%rax, 568(%rdi)
        movq	64(%r8), %rdx
        movq	72(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 576(%rdi)
        movq	%rax, 584(%rdi)
        movq	80(%r8), %rdx
        movq	88(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 592(%rdi)
        movq	%rax, 600(%rdi)
        movq	96(%r8), %rdx
        movq	104(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 608(%rdi)
        movq	%rax, 616(%rdi)
        movq	112(%r8), %rdx
        movq	120(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 624(%rdi)
        movq	%rax, 632(%rdi)
        movq	128(%r8), %rdx
        movq	136(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 640(%rdi)
        movq	%rax, 648(%rdi)
        movq	144(%r8), %rdx
        movq	152(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 656(%rdi)
        movq	%rax, 664(%rdi)
        movq	160(%r8), %rdx
        movq	168(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 672(%rdi)
        movq	%rax, 680(%rdi)
        movq	176(%r8), %rdx
        movq	184(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 688(%rdi)
        movq	%rax, 696(%rdi)
        movq	192(%r8), %rdx
        movq	200(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 704(%rdi)
        movq	%rax, 712(%rdi)
        movq	208(%r8), %rdx
        movq	216(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 720(%rdi)
        movq	%rax, 728(%rdi)
        movq	224(%r8), %rdx
        movq	232(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 736(%rdi)
        movq	%rax, 744(%rdi)
        movq	240(%r8), %rdx
        movq	248(%r8), %rax
        andq	%r10, %rdx
        andq	%r10, %rax
        movq	%rdx, 752(%rdi)
        movq	%rax, 760(%rdi)
        movq	512(%rdi), %rdx
        addq	%rdx, %rdx
        movq	520(%rdi), %rax
        movq	%rdx, 512(%rdi)
        adcq	%rax, %rax
        movq	528(%rdi), %rdx
        movq	%rax, 520(%rdi)
        adcq	%rdx, %rdx
        movq	536(%rdi), %rax
        movq	%rdx, 528(%rdi)
        adcq	%rax, %rax
        movq	544(%rdi), %rdx
        movq	%rax, 536(%rdi)
        adcq	%rdx, %rdx
        movq	552(%rdi), %rax
        movq	%rdx, 544(%rdi)
        adcq	%rax, %rax
        movq	560(%rdi), %rdx
        movq	%rax, 552(%rdi)
        adcq	%rdx, %rdx
        movq	568(%rdi), %rax
        movq	%rdx, 560(%rdi)
        adcq	%rax, %rax
        movq	576(%rdi), %rdx
        movq	%rax, 568(%rdi)
        adcq	%rdx, %rdx
        movq	584(%rdi), %rax
        movq	%rdx, 576(%rdi)
        adcq	%rax, %rax
        movq	592(%rdi), %rdx
        movq	%rax, 584(%rdi)
        adcq	%rdx, %rdx
        movq	600(%rdi), %rax
        movq	%rdx, 592(%rdi)
        adcq	%rax, %rax
        movq	608(%rdi), %rdx
        movq	%rax, 600(%rdi)
        adcq	%rdx, %rdx
        movq	616(%rdi), %rax
        movq	%rdx, 608(%rdi)
        adcq	%rax, %rax
        movq	624(%rdi), %rdx
        movq	%rax, 616(%rdi)
        adcq	%rdx, %rdx
        movq	632(%rdi), %rax
        movq	%rdx, 624(%rdi)
        adcq	%rax, %rax
        movq	640(%rdi), %rdx
        movq	%rax, 632(%rdi)
        adcq	%rdx, %rdx
        movq	648(%rdi), %rax
        movq	%rdx, 640(%rdi)
        adcq	%rax, %rax
        movq	656(%rdi), %rdx
        movq	%rax, 648(%rdi)
        adcq	%rdx, %rdx
        movq	664(%rdi), %rax
        movq	%rdx, 656(%rdi)
        adcq	%rax, %rax
        movq	672(%rdi), %rdx
        movq	%rax, 664(%rdi)
        adcq	%rdx, %rdx
        movq	680(%rdi), %rax
        movq	%rdx, 672(%rdi)
        adcq	%rax, %rax
        movq	688(%rdi), %rdx
        movq	%rax, 680(%rdi)
        adcq	%rdx, %rdx
        movq	696(%rdi), %rax
        movq	%rdx, 688(%rdi)
        adcq	%rax, %rax
        movq	704(%rdi), %rdx
        movq	%rax, 696(%rdi)
        adcq	%rdx, %rdx
        movq	712(%rdi), %rax
        movq	%rdx, 704(%rdi)
        adcq	%rax, %rax
        movq	720(%rdi), %rdx
        movq	%rax, 712(%rdi)
        adcq	%rdx, %rdx
        movq	728(%rdi), %rax
        movq	%rdx, 720(%rdi)
        adcq	%rax, %rax
        movq	736(%rdi), %rdx
        movq	%rax, 728(%rdi)
        adcq	%rdx, %rdx
        movq	744(%rdi), %rax
        movq	%rdx, 736(%rdi)
        adcq	%rax, %rax
        movq	752(%rdi), %rdx
        movq	%rax, 744(%rdi)
        adcq	%rdx, %rdx
        movq	760(%rdi), %rax
        movq	%rdx, 752(%rdi)
        adcq	%rax, %rax
        movq	%rax, 760(%rdi)
        adcq	$0, %rcx
        leaq	512(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rsi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rsi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rsi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rsi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rsi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rsi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rsi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rsi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rsi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rsi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rsi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rsi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rsi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rsi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rsi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rsi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rsi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rsi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rsi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rsi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rsi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rsi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rsi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rsi), %rax
        movq	384(%r8), %rdx
        movq	%rax, 376(%r8)
        sbbq	384(%rsi), %rdx
        movq	392(%r8), %rax
        movq	%rdx, 384(%r8)
        sbbq	392(%rsi), %rax
        movq	400(%r8), %rdx
        movq	%rax, 392(%r8)
        sbbq	400(%rsi), %rdx
        movq	408(%r8), %rax
        movq	%rdx, 400(%r8)
        sbbq	408(%rsi), %rax
        movq	416(%r8), %rdx
        movq	%rax, 408(%r8)
        sbbq	416(%rsi), %rdx
        movq	424(%r8), %rax
        movq	%rdx, 416(%r8)
        sbbq	424(%rsi), %rax
        movq	432(%r8), %rdx
        movq	%rax, 424(%r8)
        sbbq	432(%rsi), %rdx
        movq	440(%r8), %rax
        movq	%rdx, 432(%r8)
        sbbq	440(%rsi), %rax
        movq	448(%r8), %rdx
        movq	%rax, 440(%r8)
        sbbq	448(%rsi), %rdx
        movq	456(%r8), %rax
        movq	%rdx, 448(%r8)
        sbbq	456(%rsi), %rax
        movq	464(%r8), %rdx
        movq	%rax, 456(%r8)
        sbbq	464(%rsi), %rdx
        movq	472(%r8), %rax
        movq	%rdx, 464(%r8)
        sbbq	472(%rsi), %rax
        movq	480(%r8), %rdx
        movq	%rax, 472(%r8)
        sbbq	480(%rsi), %rdx
        movq	488(%r8), %rax
        movq	%rdx, 480(%r8)
        sbbq	488(%rsi), %rax
        movq	496(%r8), %rdx
        movq	%rax, 488(%r8)
        sbbq	496(%rsi), %rdx
        movq	504(%r8), %rax
        movq	%rdx, 496(%r8)
        sbbq	504(%rsi), %rax
        movq	%rax, 504(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rdi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rdi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rdi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rdi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rdi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rdi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rdi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rdi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rdi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rdi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rdi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rdi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rdi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rdi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rdi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rdi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rdi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rdi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rdi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rdi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rdi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rdi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rdi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rdi), %rax
        movq	384(%r8), %rdx
        movq	%rax, 376(%r8)
        sbbq	384(%rdi), %rdx
        movq	392(%r8), %rax
        movq	%rdx, 384(%r8)
        sbbq	392(%rdi), %rax
        movq	400(%r8), %rdx
        movq	%rax, 392(%r8)
        sbbq	400(%rdi), %rdx
        movq	408(%r8), %rax
        movq	%rdx, 400(%r8)
        sbbq	408(%rdi), %rax
        movq	416(%r8), %rdx
        movq	%rax, 408(%r8)
        sbbq	416(%rdi), %rdx
        movq	424(%r8), %rax
        movq	%rdx, 416(%r8)
        sbbq	424(%rdi), %rax
        movq	432(%r8), %rdx
        movq	%rax, 424(%r8)
        sbbq	432(%rdi), %rdx
        movq	440(%r8), %rax
        movq	%rdx, 432(%r8)
        sbbq	440(%rdi), %rax
        movq	448(%r8), %rdx
        movq	%rax, 440(%r8)
        sbbq	448(%rdi), %rdx
        movq	456(%r8), %rax
        movq	%rdx, 448(%r8)
        sbbq	456(%rdi), %rax
        movq	464(%r8), %rdx
        movq	%rax, 456(%r8)
        sbbq	464(%rdi), %rdx
        movq	472(%r8), %rax
        movq	%rdx, 464(%r8)
        sbbq	472(%rdi), %rax
        movq	480(%r8), %rdx
        movq	%rax, 472(%r8)
        sbbq	480(%rdi), %rdx
        movq	488(%r8), %rax
        movq	%rdx, 480(%r8)
        sbbq	488(%rdi), %rax
        movq	496(%r8), %rdx
        movq	%rax, 488(%r8)
        sbbq	496(%rdi), %rdx
        movq	504(%r8), %rax
        movq	%rdx, 496(%r8)
        sbbq	504(%rdi), %rax
        movq	%rax, 504(%r8)
        sbbq	$0, %rcx
        # Add in place
        movq	256(%rdi), %rdx
        addq	(%r8), %rdx
        movq	264(%rdi), %rax
        movq	%rdx, 256(%rdi)
        adcq	8(%r8), %rax
        movq	272(%rdi), %rdx
        movq	%rax, 264(%rdi)
        adcq	16(%r8), %rdx
        movq	280(%rdi), %rax
        movq	%rdx, 272(%rdi)
        adcq	24(%r8), %rax
        movq	288(%rdi), %rdx
        movq	%rax, 280(%rdi)
        adcq	32(%r8), %rdx
        movq	296(%rdi), %rax
        movq	%rdx, 288(%rdi)
        adcq	40(%r8), %rax
        movq	304(%rdi), %rdx
        movq	%rax, 296(%rdi)
        adcq	48(%r8), %rdx
        movq	312(%rdi), %rax
        movq	%rdx, 304(%rdi)
        adcq	56(%r8), %rax
        movq	320(%rdi), %rdx
        movq	%rax, 312(%rdi)
        adcq	64(%r8), %rdx
        movq	328(%rdi), %rax
        movq	%rdx, 320(%rdi)
        adcq	72(%r8), %rax
        movq	336(%rdi), %rdx
        movq	%rax, 328(%rdi)
        adcq	80(%r8), %rdx
        movq	344(%rdi), %rax
        movq	%rdx, 336(%rdi)
        adcq	88(%r8), %rax
        movq	352(%rdi), %rdx
        movq	%rax, 344(%rdi)
        adcq	96(%r8), %rdx
        movq	360(%rdi), %rax
        movq	%rdx, 352(%rdi)
        adcq	104(%r8), %rax
        movq	368(%rdi), %rdx
        movq	%rax, 360(%rdi)
        adcq	112(%r8), %rdx
        movq	376(%rdi), %rax
        movq	%rdx, 368(%rdi)
        adcq	120(%r8), %rax
        movq	384(%rdi), %rdx
        movq	%rax, 376(%rdi)
        adcq	128(%r8), %rdx
        movq	392(%rdi), %rax
        movq	%rdx, 384(%rdi)
        adcq	136(%r8), %rax
        movq	400(%rdi), %rdx
        movq	%rax, 392(%rdi)
        adcq	144(%r8), %rdx
        movq	408(%rdi), %rax
        movq	%rdx, 400(%rdi)
        adcq	152(%r8), %rax
        movq	416(%rdi), %rdx
        movq	%rax, 408(%rdi)
        adcq	160(%r8), %rdx
        movq	424(%rdi), %rax
        movq	%rdx, 416(%rdi)
        adcq	168(%r8), %rax
        movq	432(%rdi), %rdx
        movq	%rax, 424(%rdi)
        adcq	176(%r8), %rdx
        movq	440(%rdi), %rax
        movq	%rdx, 432(%rdi)
        adcq	184(%r8), %rax
        movq	448(%rdi), %rdx
        movq	%rax, 440(%rdi)
        adcq	192(%r8), %rdx
        movq	456(%rdi), %rax
        movq	%rdx, 448(%rdi)
        adcq	200(%r8), %rax
        movq	464(%rdi), %rdx
        movq	%rax, 456(%rdi)
        adcq	208(%r8), %rdx
        movq	472(%rdi), %rax
        movq	%rdx, 464(%rdi)
        adcq	216(%r8), %rax
        movq	480(%rdi), %rdx
        movq	%rax, 472(%rdi)
        adcq	224(%r8), %rdx
        movq	488(%rdi), %rax
        movq	%rdx, 480(%rdi)
        adcq	232(%r8), %rax
        movq	496(%rdi), %rdx
        movq	%rax, 488(%rdi)
        adcq	240(%r8), %rdx
        movq	504(%rdi), %rax
        movq	%rdx, 496(%rdi)
        adcq	248(%r8), %rax
        movq	512(%rdi), %rdx
        movq	%rax, 504(%rdi)
        adcq	256(%r8), %rdx
        movq	520(%rdi), %rax
        movq	%rdx, 512(%rdi)
        adcq	264(%r8), %rax
        movq	528(%rdi), %rdx
        movq	%rax, 520(%rdi)
        adcq	272(%r8), %rdx
        movq	536(%rdi), %rax
        movq	%rdx, 528(%rdi)
        adcq	280(%r8), %rax
        movq	544(%rdi), %rdx
        movq	%rax, 536(%rdi)
        adcq	288(%r8), %rdx
        movq	552(%rdi), %rax
        movq	%rdx, 544(%rdi)
        adcq	296(%r8), %rax
        movq	560(%rdi), %rdx
        movq	%rax, 552(%rdi)
        adcq	304(%r8), %rdx
        movq	568(%rdi), %rax
        movq	%rdx, 560(%rdi)
        adcq	312(%r8), %rax
        movq	576(%rdi), %rdx
        movq	%rax, 568(%rdi)
        adcq	320(%r8), %rdx
        movq	584(%rdi), %rax
        movq	%rdx, 576(%rdi)
        adcq	328(%r8), %rax
        movq	592(%rdi), %rdx
        movq	%rax, 584(%rdi)
        adcq	336(%r8), %rdx
        movq	600(%rdi), %rax
        movq	%rdx, 592(%rdi)
        adcq	344(%r8), %rax
        movq	608(%rdi), %rdx
        movq	%rax, 600(%rdi)
        adcq	352(%r8), %rdx
        movq	616(%rdi), %rax
        movq	%rdx, 608(%rdi)
        adcq	360(%r8), %rax
        movq	624(%rdi), %rdx
        movq	%rax, 616(%rdi)
        adcq	368(%r8), %rdx
        movq	632(%rdi), %rax
        movq	%rdx, 624(%rdi)
        adcq	376(%r8), %rax
        movq	640(%rdi), %rdx
        movq	%rax, 632(%rdi)
        adcq	384(%r8), %rdx
        movq	648(%rdi), %rax
        movq	%rdx, 640(%rdi)
        adcq	392(%r8), %rax
        movq	656(%rdi), %rdx
        movq	%rax, 648(%rdi)
        adcq	400(%r8), %rdx
        movq	664(%rdi), %rax
        movq	%rdx, 656(%rdi)
        adcq	408(%r8), %rax
        movq	672(%rdi), %rdx
        movq	%rax, 664(%rdi)
        adcq	416(%r8), %rdx
        movq	680(%rdi), %rax
        movq	%rdx, 672(%rdi)
        adcq	424(%r8), %rax
        movq	688(%rdi), %rdx
        movq	%rax, 680(%rdi)
        adcq	432(%r8), %rdx
        movq	696(%rdi), %rax
        movq	%rdx, 688(%rdi)
        adcq	440(%r8), %rax
        movq	704(%rdi), %rdx
        movq	%rax, 696(%rdi)
        adcq	448(%r8), %rdx
        movq	712(%rdi), %rax
        movq	%rdx, 704(%rdi)
        adcq	456(%r8), %rax
        movq	720(%rdi), %rdx
        movq	%rax, 712(%rdi)
        adcq	464(%r8), %rdx
        movq	728(%rdi), %rax
        movq	%rdx, 720(%rdi)
        adcq	472(%r8), %rax
        movq	736(%rdi), %rdx
        movq	%rax, 728(%rdi)
        adcq	480(%r8), %rdx
        movq	744(%rdi), %rax
        movq	%rdx, 736(%rdi)
        adcq	488(%r8), %rax
        movq	752(%rdi), %rdx
        movq	%rax, 744(%rdi)
        adcq	496(%r8), %rdx
        movq	760(%rdi), %rax
        movq	%rdx, 752(%rdi)
        adcq	504(%r8), %rax
        movq	%rax, 760(%rdi)
        adcq	$0, %rcx
        movq	%rcx, 768(%rdi)
        # Add in place
        movq	512(%rdi), %rdx
        xorq	%rcx, %rcx
        addq	(%rsi), %rdx
        movq	520(%rdi), %rax
        movq	%rdx, 512(%rdi)
        adcq	8(%rsi), %rax
        movq	528(%rdi), %rdx
        movq	%rax, 520(%rdi)
        adcq	16(%rsi), %rdx
        movq	536(%rdi), %rax
        movq	%rdx, 528(%rdi)
        adcq	24(%rsi), %rax
        movq	544(%rdi), %rdx
        movq	%rax, 536(%rdi)
        adcq	32(%rsi), %rdx
        movq	552(%rdi), %rax
        movq	%rdx, 544(%rdi)
        adcq	40(%rsi), %rax
        movq	560(%rdi), %rdx
        movq	%rax, 552(%rdi)
        adcq	48(%rsi), %rdx
        movq	568(%rdi), %rax
        movq	%rdx, 560(%rdi)
        adcq	56(%rsi), %rax
        movq	576(%rdi), %rdx
        movq	%rax, 568(%rdi)
        adcq	64(%rsi), %rdx
        movq	584(%rdi), %rax
        movq	%rdx, 576(%rdi)
        adcq	72(%rsi), %rax
        movq	592(%rdi), %rdx
        movq	%rax, 584(%rdi)
        adcq	80(%rsi), %rdx
        movq	600(%rdi), %rax
        movq	%rdx, 592(%rdi)
        adcq	88(%rsi), %rax
        movq	608(%rdi), %rdx
        movq	%rax, 600(%rdi)
        adcq	96(%rsi), %rdx
        movq	616(%rdi), %rax
        movq	%rdx, 608(%rdi)
        adcq	104(%rsi), %rax
        movq	624(%rdi), %rdx
        movq	%rax, 616(%rdi)
        adcq	112(%rsi), %rdx
        movq	632(%rdi), %rax
        movq	%rdx, 624(%rdi)
        adcq	120(%rsi), %rax
        movq	640(%rdi), %rdx
        movq	%rax, 632(%rdi)
        adcq	128(%rsi), %rdx
        movq	648(%rdi), %rax
        movq	%rdx, 640(%rdi)
        adcq	136(%rsi), %rax
        movq	656(%rdi), %rdx
        movq	%rax, 648(%rdi)
        adcq	144(%rsi), %rdx
        movq	664(%rdi), %rax
        movq	%rdx, 656(%rdi)
        adcq	152(%rsi), %rax
        movq	672(%rdi), %rdx
        movq	%rax, 664(%rdi)
        adcq	160(%rsi), %rdx
        movq	680(%rdi), %rax
        movq	%rdx, 672(%rdi)
        adcq	168(%rsi), %rax
        movq	688(%rdi), %rdx
        movq	%rax, 680(%rdi)
        adcq	176(%rsi), %rdx
        movq	696(%rdi), %rax
        movq	%rdx, 688(%rdi)
        adcq	184(%rsi), %rax
        movq	704(%rdi), %rdx
        movq	%rax, 696(%rdi)
        adcq	192(%rsi), %rdx
        movq	712(%rdi), %rax
        movq	%rdx, 704(%rdi)
        adcq	200(%rsi), %rax
        movq	720(%rdi), %rdx
        movq	%rax, 712(%rdi)
        adcq	208(%rsi), %rdx
        movq	728(%rdi), %rax
        movq	%rdx, 720(%rdi)
        adcq	216(%rsi), %rax
        movq	736(%rdi), %rdx
        movq	%rax, 728(%rdi)
        adcq	224(%rsi), %rdx
        movq	744(%rdi), %rax
        movq	%rdx, 736(%rdi)
        adcq	232(%rsi), %rax
        movq	752(%rdi), %rdx
        movq	%rax, 744(%rdi)
        adcq	240(%rsi), %rdx
        movq	760(%rdi), %rax
        movq	%rdx, 752(%rdi)
        adcq	248(%rsi), %rax
        movq	768(%rdi), %rdx
        movq	%rax, 760(%rdi)
        adcq	256(%rsi), %rdx
        movq	%rdx, 768(%rdi)
        adcq	$0, %rcx
        # Add to zero
        movq	264(%rsi), %rdx
        adcq	$0, %rdx
        movq	272(%rsi), %rax
        movq	%rdx, 776(%rdi)
        adcq	$0, %rax
        movq	280(%rsi), %rdx
        movq	%rax, 784(%rdi)
        adcq	$0, %rdx
        movq	288(%rsi), %rax
        movq	%rdx, 792(%rdi)
        adcq	$0, %rax
        movq	296(%rsi), %rdx
        movq	%rax, 800(%rdi)
        adcq	$0, %rdx
        movq	304(%rsi), %rax
        movq	%rdx, 808(%rdi)
        adcq	$0, %rax
        movq	312(%rsi), %rdx
        movq	%rax, 816(%rdi)
        adcq	$0, %rdx
        movq	320(%rsi), %rax
        movq	%rdx, 824(%rdi)
        adcq	$0, %rax
        movq	328(%rsi), %rdx
        movq	%rax, 832(%rdi)
        adcq	$0, %rdx
        movq	336(%rsi), %rax
        movq	%rdx, 840(%rdi)
        adcq	$0, %rax
        movq	344(%rsi), %rdx
        movq	%rax, 848(%rdi)
        adcq	$0, %rdx
        movq	352(%rsi), %rax
        movq	%rdx, 856(%rdi)
        adcq	$0, %rax
        movq	360(%rsi), %rdx
        movq	%rax, 864(%rdi)
        adcq	$0, %rdx
        movq	368(%rsi), %rax
        movq	%rdx, 872(%rdi)
        adcq	$0, %rax
        movq	376(%rsi), %rdx
        movq	%rax, 880(%rdi)
        adcq	$0, %rdx
        movq	384(%rsi), %rax
        movq	%rdx, 888(%rdi)
        adcq	$0, %rax
        movq	392(%rsi), %rdx
        movq	%rax, 896(%rdi)
        adcq	$0, %rdx
        movq	400(%rsi), %rax
        movq	%rdx, 904(%rdi)
        adcq	$0, %rax
        movq	408(%rsi), %rdx
        movq	%rax, 912(%rdi)
        adcq	$0, %rdx
        movq	416(%rsi), %rax
        movq	%rdx, 920(%rdi)
        adcq	$0, %rax
        movq	424(%rsi), %rdx
        movq	%rax, 928(%rdi)
        adcq	$0, %rdx
        movq	432(%rsi), %rax
        movq	%rdx, 936(%rdi)
        adcq	$0, %rax
        movq	440(%rsi), %rdx
        movq	%rax, 944(%rdi)
        adcq	$0, %rdx
        movq	448(%rsi), %rax
        movq	%rdx, 952(%rdi)
        adcq	$0, %rax
        movq	456(%rsi), %rdx
        movq	%rax, 960(%rdi)
        adcq	$0, %rdx
        movq	464(%rsi), %rax
        movq	%rdx, 968(%rdi)
        adcq	$0, %rax
        movq	472(%rsi), %rdx
        movq	%rax, 976(%rdi)
        adcq	$0, %rdx
        movq	480(%rsi), %rax
        movq	%rdx, 984(%rdi)
        adcq	$0, %rax
        movq	488(%rsi), %rdx
        movq	%rax, 992(%rdi)
        adcq	$0, %rdx
        movq	496(%rsi), %rax
        movq	%rdx, 1000(%rdi)
        adcq	$0, %rax
        movq	504(%rsi), %rdx
        movq	%rax, 1008(%rdi)
        adcq	$0, %rdx
        movq	%rdx, 1016(%rdi)
        addq	$1304, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_4096_sqr_64,.-sp_4096_sqr_64
#endif /* __APPLE__ */
/* Multiply a and b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_4096_mul_avx2_64
.type	sp_4096_mul_avx2_64,@function
.align	16
sp_4096_mul_avx2_64:
#else
.globl	_sp_4096_mul_avx2_64
.p2align	4
_sp_4096_mul_avx2_64:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        subq	$1576, %rsp
        movq	%rdi, 1536(%rsp)
        movq	%rsi, 1544(%rsp)
        movq	%rdx, 1552(%rsp)
        leaq	1024(%rsp), %r10
        leaq	256(%rsi), %r12
        # Add
        movq	(%rsi), %rax
        xorq	%r13, %r13
        addq	(%r12), %rax
        movq	8(%rsi), %rcx
        movq	%rax, (%r10)
        adcq	8(%r12), %rcx
        movq	16(%rsi), %r8
        movq	%rcx, 8(%r10)
        adcq	16(%r12), %r8
        movq	24(%rsi), %rax
        movq	%r8, 16(%r10)
        adcq	24(%r12), %rax
        movq	32(%rsi), %rcx
        movq	%rax, 24(%r10)
        adcq	32(%r12), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%r10)
        adcq	40(%r12), %r8
        movq	48(%rsi), %rax
        movq	%r8, 40(%r10)
        adcq	48(%r12), %rax
        movq	56(%rsi), %rcx
        movq	%rax, 48(%r10)
        adcq	56(%r12), %rcx
        movq	64(%rsi), %r8
        movq	%rcx, 56(%r10)
        adcq	64(%r12), %r8
        movq	72(%rsi), %rax
        movq	%r8, 64(%r10)
        adcq	72(%r12), %rax
        movq	80(%rsi), %rcx
        movq	%rax, 72(%r10)
        adcq	80(%r12), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%r10)
        adcq	88(%r12), %r8
        movq	96(%rsi), %rax
        movq	%r8, 88(%r10)
        adcq	96(%r12), %rax
        movq	104(%rsi), %rcx
        movq	%rax, 96(%r10)
        adcq	104(%r12), %rcx
        movq	112(%rsi), %r8
        movq	%rcx, 104(%r10)
        adcq	112(%r12), %r8
        movq	120(%rsi), %rax
        movq	%r8, 112(%r10)
        adcq	120(%r12), %rax
        movq	128(%rsi), %rcx
        movq	%rax, 120(%r10)
        adcq	128(%r12), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%r10)
        adcq	136(%r12), %r8
        movq	144(%rsi), %rax
        movq	%r8, 136(%r10)
        adcq	144(%r12), %rax
        movq	152(%rsi), %rcx
        movq	%rax, 144(%r10)
        adcq	152(%r12), %rcx
        movq	160(%rsi), %r8
        movq	%rcx, 152(%r10)
        adcq	160(%r12), %r8
        movq	168(%rsi), %rax
        movq	%r8, 160(%r10)
        adcq	168(%r12), %rax
        movq	176(%rsi), %rcx
        movq	%rax, 168(%r10)
        adcq	176(%r12), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%r10)
        adcq	184(%r12), %r8
        movq	192(%rsi), %rax
        movq	%r8, 184(%r10)
        adcq	192(%r12), %rax
        movq	200(%rsi), %rcx
        movq	%rax, 192(%r10)
        adcq	200(%r12), %rcx
        movq	208(%rsi), %r8
        movq	%rcx, 200(%r10)
        adcq	208(%r12), %r8
        movq	216(%rsi), %rax
        movq	%r8, 208(%r10)
        adcq	216(%r12), %rax
        movq	224(%rsi), %rcx
        movq	%rax, 216(%r10)
        adcq	224(%r12), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%r10)
        adcq	232(%r12), %r8
        movq	240(%rsi), %rax
        movq	%r8, 232(%r10)
        adcq	240(%r12), %rax
        movq	248(%rsi), %rcx
        movq	%rax, 240(%r10)
        adcq	248(%r12), %rcx
        movq	%rcx, 248(%r10)
        adcq	$0, %r13
        movq	%r13, 1560(%rsp)
        leaq	1280(%rsp), %r11
        leaq	256(%rdx), %r12
        # Add
        movq	(%rdx), %rax
        xorq	%r14, %r14
        addq	(%r12), %rax
        movq	8(%rdx), %rcx
        movq	%rax, (%r11)
        adcq	8(%r12), %rcx
        movq	16(%rdx), %r8
        movq	%rcx, 8(%r11)
        adcq	16(%r12), %r8
        movq	24(%rdx), %rax
        movq	%r8, 16(%r11)
        adcq	24(%r12), %rax
        movq	32(%rdx), %rcx
        movq	%rax, 24(%r11)
        adcq	32(%r12), %rcx
        movq	40(%rdx), %r8
        movq	%rcx, 32(%r11)
        adcq	40(%r12), %r8
        movq	48(%rdx), %rax
        movq	%r8, 40(%r11)
        adcq	48(%r12), %rax
        movq	56(%rdx), %rcx
        movq	%rax, 48(%r11)
        adcq	56(%r12), %rcx
        movq	64(%rdx), %r8
        movq	%rcx, 56(%r11)
        adcq	64(%r12), %r8
        movq	72(%rdx), %rax
        movq	%r8, 64(%r11)
        adcq	72(%r12), %rax
        movq	80(%rdx), %rcx
        movq	%rax, 72(%r11)
        adcq	80(%r12), %rcx
        movq	88(%rdx), %r8
        movq	%rcx, 80(%r11)
        adcq	88(%r12), %r8
        movq	96(%rdx), %rax
        movq	%r8, 88(%r11)
        adcq	96(%r12), %rax
        movq	104(%rdx), %rcx
        movq	%rax, 96(%r11)
        adcq	104(%r12), %rcx
        movq	112(%rdx), %r8
        movq	%rcx, 104(%r11)
        adcq	112(%r12), %r8
        movq	120(%rdx), %rax
        movq	%r8, 112(%r11)
        adcq	120(%r12), %rax
        movq	128(%rdx), %rcx
        movq	%rax, 120(%r11)
        adcq	128(%r12), %rcx
        movq	136(%rdx), %r8
        movq	%rcx, 128(%r11)
        adcq	136(%r12), %r8
        movq	144(%rdx), %rax
        movq	%r8, 136(%r11)
        adcq	144(%r12), %rax
        movq	152(%rdx), %rcx
        movq	%rax, 144(%r11)
        adcq	152(%r12), %rcx
        movq	160(%rdx), %r8
        movq	%rcx, 152(%r11)
        adcq	160(%r12), %r8
        movq	168(%rdx), %rax
        movq	%r8, 160(%r11)
        adcq	168(%r12), %rax
        movq	176(%rdx), %rcx
        movq	%rax, 168(%r11)
        adcq	176(%r12), %rcx
        movq	184(%rdx), %r8
        movq	%rcx, 176(%r11)
        adcq	184(%r12), %r8
        movq	192(%rdx), %rax
        movq	%r8, 184(%r11)
        adcq	192(%r12), %rax
        movq	200(%rdx), %rcx
        movq	%rax, 192(%r11)
        adcq	200(%r12), %rcx
        movq	208(%rdx), %r8
        movq	%rcx, 200(%r11)
        adcq	208(%r12), %r8
        movq	216(%rdx), %rax
        movq	%r8, 208(%r11)
        adcq	216(%r12), %rax
        movq	224(%rdx), %rcx
        movq	%rax, 216(%r11)
        adcq	224(%r12), %rcx
        movq	232(%rdx), %r8
        movq	%rcx, 224(%r11)
        adcq	232(%r12), %r8
        movq	240(%rdx), %rax
        movq	%r8, 232(%r11)
        adcq	240(%r12), %rax
        movq	248(%rdx), %rcx
        movq	%rax, 240(%r11)
        adcq	248(%r12), %rcx
        movq	%rcx, 248(%r11)
        adcq	$0, %r14
        movq	%r14, 1568(%rsp)
        movq	%r11, %rdx
        movq	%r10, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_32@plt
#else
        callq	_sp_2048_mul_avx2_32
#endif /* __APPLE__ */
        movq	1552(%rsp), %rdx
        movq	1544(%rsp), %rsi
        leaq	512(%rsp), %rdi
        addq	$256, %rdx
        addq	$256, %rsi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_32@plt
#else
        callq	_sp_2048_mul_avx2_32
#endif /* __APPLE__ */
        movq	1552(%rsp), %rdx
        movq	1544(%rsp), %rsi
        movq	1536(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_mul_avx2_32@plt
#else
        callq	_sp_2048_mul_avx2_32
#endif /* __APPLE__ */
        movq	1560(%rsp), %r13
        movq	1568(%rsp), %r14
        movq	1536(%rsp), %r15
        movq	%r13, %r9
        leaq	1024(%rsp), %r10
        leaq	1280(%rsp), %r11
        andq	%r14, %r9
        negq	%r13
        negq	%r14
        addq	$512, %r15
        movq	(%r10), %rax
        movq	(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        addq	%rcx, %rax
        movq	8(%r10), %rcx
        movq	8(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, (%r15)
        adcq	%r8, %rcx
        movq	16(%r10), %r8
        movq	16(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 8(%r15)
        adcq	%rax, %r8
        movq	24(%r10), %rax
        movq	24(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 16(%r15)
        adcq	%rcx, %rax
        movq	32(%r10), %rcx
        movq	32(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 24(%r15)
        adcq	%r8, %rcx
        movq	40(%r10), %r8
        movq	40(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 32(%r15)
        adcq	%rax, %r8
        movq	48(%r10), %rax
        movq	48(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 40(%r15)
        adcq	%rcx, %rax
        movq	56(%r10), %rcx
        movq	56(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 48(%r15)
        adcq	%r8, %rcx
        movq	64(%r10), %r8
        movq	64(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 56(%r15)
        adcq	%rax, %r8
        movq	72(%r10), %rax
        movq	72(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 64(%r15)
        adcq	%rcx, %rax
        movq	80(%r10), %rcx
        movq	80(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 72(%r15)
        adcq	%r8, %rcx
        movq	88(%r10), %r8
        movq	88(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 80(%r15)
        adcq	%rax, %r8
        movq	96(%r10), %rax
        movq	96(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 88(%r15)
        adcq	%rcx, %rax
        movq	104(%r10), %rcx
        movq	104(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 96(%r15)
        adcq	%r8, %rcx
        movq	112(%r10), %r8
        movq	112(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 104(%r15)
        adcq	%rax, %r8
        movq	120(%r10), %rax
        movq	120(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 112(%r15)
        adcq	%rcx, %rax
        movq	128(%r10), %rcx
        movq	128(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 120(%r15)
        adcq	%r8, %rcx
        movq	136(%r10), %r8
        movq	136(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 128(%r15)
        adcq	%rax, %r8
        movq	144(%r10), %rax
        movq	144(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 136(%r15)
        adcq	%rcx, %rax
        movq	152(%r10), %rcx
        movq	152(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 144(%r15)
        adcq	%r8, %rcx
        movq	160(%r10), %r8
        movq	160(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 152(%r15)
        adcq	%rax, %r8
        movq	168(%r10), %rax
        movq	168(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 160(%r15)
        adcq	%rcx, %rax
        movq	176(%r10), %rcx
        movq	176(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 168(%r15)
        adcq	%r8, %rcx
        movq	184(%r10), %r8
        movq	184(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 176(%r15)
        adcq	%rax, %r8
        movq	192(%r10), %rax
        movq	192(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 184(%r15)
        adcq	%rcx, %rax
        movq	200(%r10), %rcx
        movq	200(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 192(%r15)
        adcq	%r8, %rcx
        movq	208(%r10), %r8
        movq	208(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 200(%r15)
        adcq	%rax, %r8
        movq	216(%r10), %rax
        movq	216(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 208(%r15)
        adcq	%rcx, %rax
        movq	224(%r10), %rcx
        movq	224(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 216(%r15)
        adcq	%r8, %rcx
        movq	232(%r10), %r8
        movq	232(%r11), %rax
        pextq	%r14, %r8, %r8
        pextq	%r13, %rax, %rax
        movq	%rcx, 224(%r15)
        adcq	%rax, %r8
        movq	240(%r10), %rax
        movq	240(%r11), %rcx
        pextq	%r14, %rax, %rax
        pextq	%r13, %rcx, %rcx
        movq	%r8, 232(%r15)
        adcq	%rcx, %rax
        movq	248(%r10), %rcx
        movq	248(%r11), %r8
        pextq	%r14, %rcx, %rcx
        pextq	%r13, %r8, %r8
        movq	%rax, 240(%r15)
        adcq	%r8, %rcx
        movq	%rcx, 248(%r15)
        adcq	$0, %r9
        leaq	512(%rsp), %r11
        movq	%rsp, %r10
        movq	(%r10), %rax
        subq	(%r11), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%r11), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%r11), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%r11), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%r11), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%r11), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%r11), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%r11), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%r11), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%r11), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%r11), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%r11), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%r11), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%r11), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%r11), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%r11), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%r11), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%r11), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%r11), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%r11), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%r11), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%r11), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%r11), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%r11), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%r11), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%r11), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%r11), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%r11), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%r11), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%r11), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%r11), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%r11), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%r11), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%r11), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%r11), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%r11), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%r11), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%r11), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%r11), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%r11), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%r11), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%r11), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%r11), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%r11), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%r11), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%r11), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%r11), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%r11), %r8
        movq	384(%r10), %rax
        movq	%r8, 376(%r10)
        sbbq	384(%r11), %rax
        movq	392(%r10), %rcx
        movq	%rax, 384(%r10)
        sbbq	392(%r11), %rcx
        movq	400(%r10), %r8
        movq	%rcx, 392(%r10)
        sbbq	400(%r11), %r8
        movq	408(%r10), %rax
        movq	%r8, 400(%r10)
        sbbq	408(%r11), %rax
        movq	416(%r10), %rcx
        movq	%rax, 408(%r10)
        sbbq	416(%r11), %rcx
        movq	424(%r10), %r8
        movq	%rcx, 416(%r10)
        sbbq	424(%r11), %r8
        movq	432(%r10), %rax
        movq	%r8, 424(%r10)
        sbbq	432(%r11), %rax
        movq	440(%r10), %rcx
        movq	%rax, 432(%r10)
        sbbq	440(%r11), %rcx
        movq	448(%r10), %r8
        movq	%rcx, 440(%r10)
        sbbq	448(%r11), %r8
        movq	456(%r10), %rax
        movq	%r8, 448(%r10)
        sbbq	456(%r11), %rax
        movq	464(%r10), %rcx
        movq	%rax, 456(%r10)
        sbbq	464(%r11), %rcx
        movq	472(%r10), %r8
        movq	%rcx, 464(%r10)
        sbbq	472(%r11), %r8
        movq	480(%r10), %rax
        movq	%r8, 472(%r10)
        sbbq	480(%r11), %rax
        movq	488(%r10), %rcx
        movq	%rax, 480(%r10)
        sbbq	488(%r11), %rcx
        movq	496(%r10), %r8
        movq	%rcx, 488(%r10)
        sbbq	496(%r11), %r8
        movq	504(%r10), %rax
        movq	%r8, 496(%r10)
        sbbq	504(%r11), %rax
        movq	%rax, 504(%r10)
        sbbq	$0, %r9
        movq	(%r10), %rax
        subq	(%rdi), %rax
        movq	8(%r10), %rcx
        movq	%rax, (%r10)
        sbbq	8(%rdi), %rcx
        movq	16(%r10), %r8
        movq	%rcx, 8(%r10)
        sbbq	16(%rdi), %r8
        movq	24(%r10), %rax
        movq	%r8, 16(%r10)
        sbbq	24(%rdi), %rax
        movq	32(%r10), %rcx
        movq	%rax, 24(%r10)
        sbbq	32(%rdi), %rcx
        movq	40(%r10), %r8
        movq	%rcx, 32(%r10)
        sbbq	40(%rdi), %r8
        movq	48(%r10), %rax
        movq	%r8, 40(%r10)
        sbbq	48(%rdi), %rax
        movq	56(%r10), %rcx
        movq	%rax, 48(%r10)
        sbbq	56(%rdi), %rcx
        movq	64(%r10), %r8
        movq	%rcx, 56(%r10)
        sbbq	64(%rdi), %r8
        movq	72(%r10), %rax
        movq	%r8, 64(%r10)
        sbbq	72(%rdi), %rax
        movq	80(%r10), %rcx
        movq	%rax, 72(%r10)
        sbbq	80(%rdi), %rcx
        movq	88(%r10), %r8
        movq	%rcx, 80(%r10)
        sbbq	88(%rdi), %r8
        movq	96(%r10), %rax
        movq	%r8, 88(%r10)
        sbbq	96(%rdi), %rax
        movq	104(%r10), %rcx
        movq	%rax, 96(%r10)
        sbbq	104(%rdi), %rcx
        movq	112(%r10), %r8
        movq	%rcx, 104(%r10)
        sbbq	112(%rdi), %r8
        movq	120(%r10), %rax
        movq	%r8, 112(%r10)
        sbbq	120(%rdi), %rax
        movq	128(%r10), %rcx
        movq	%rax, 120(%r10)
        sbbq	128(%rdi), %rcx
        movq	136(%r10), %r8
        movq	%rcx, 128(%r10)
        sbbq	136(%rdi), %r8
        movq	144(%r10), %rax
        movq	%r8, 136(%r10)
        sbbq	144(%rdi), %rax
        movq	152(%r10), %rcx
        movq	%rax, 144(%r10)
        sbbq	152(%rdi), %rcx
        movq	160(%r10), %r8
        movq	%rcx, 152(%r10)
        sbbq	160(%rdi), %r8
        movq	168(%r10), %rax
        movq	%r8, 160(%r10)
        sbbq	168(%rdi), %rax
        movq	176(%r10), %rcx
        movq	%rax, 168(%r10)
        sbbq	176(%rdi), %rcx
        movq	184(%r10), %r8
        movq	%rcx, 176(%r10)
        sbbq	184(%rdi), %r8
        movq	192(%r10), %rax
        movq	%r8, 184(%r10)
        sbbq	192(%rdi), %rax
        movq	200(%r10), %rcx
        movq	%rax, 192(%r10)
        sbbq	200(%rdi), %rcx
        movq	208(%r10), %r8
        movq	%rcx, 200(%r10)
        sbbq	208(%rdi), %r8
        movq	216(%r10), %rax
        movq	%r8, 208(%r10)
        sbbq	216(%rdi), %rax
        movq	224(%r10), %rcx
        movq	%rax, 216(%r10)
        sbbq	224(%rdi), %rcx
        movq	232(%r10), %r8
        movq	%rcx, 224(%r10)
        sbbq	232(%rdi), %r8
        movq	240(%r10), %rax
        movq	%r8, 232(%r10)
        sbbq	240(%rdi), %rax
        movq	248(%r10), %rcx
        movq	%rax, 240(%r10)
        sbbq	248(%rdi), %rcx
        movq	256(%r10), %r8
        movq	%rcx, 248(%r10)
        sbbq	256(%rdi), %r8
        movq	264(%r10), %rax
        movq	%r8, 256(%r10)
        sbbq	264(%rdi), %rax
        movq	272(%r10), %rcx
        movq	%rax, 264(%r10)
        sbbq	272(%rdi), %rcx
        movq	280(%r10), %r8
        movq	%rcx, 272(%r10)
        sbbq	280(%rdi), %r8
        movq	288(%r10), %rax
        movq	%r8, 280(%r10)
        sbbq	288(%rdi), %rax
        movq	296(%r10), %rcx
        movq	%rax, 288(%r10)
        sbbq	296(%rdi), %rcx
        movq	304(%r10), %r8
        movq	%rcx, 296(%r10)
        sbbq	304(%rdi), %r8
        movq	312(%r10), %rax
        movq	%r8, 304(%r10)
        sbbq	312(%rdi), %rax
        movq	320(%r10), %rcx
        movq	%rax, 312(%r10)
        sbbq	320(%rdi), %rcx
        movq	328(%r10), %r8
        movq	%rcx, 320(%r10)
        sbbq	328(%rdi), %r8
        movq	336(%r10), %rax
        movq	%r8, 328(%r10)
        sbbq	336(%rdi), %rax
        movq	344(%r10), %rcx
        movq	%rax, 336(%r10)
        sbbq	344(%rdi), %rcx
        movq	352(%r10), %r8
        movq	%rcx, 344(%r10)
        sbbq	352(%rdi), %r8
        movq	360(%r10), %rax
        movq	%r8, 352(%r10)
        sbbq	360(%rdi), %rax
        movq	368(%r10), %rcx
        movq	%rax, 360(%r10)
        sbbq	368(%rdi), %rcx
        movq	376(%r10), %r8
        movq	%rcx, 368(%r10)
        sbbq	376(%rdi), %r8
        movq	384(%r10), %rax
        movq	%r8, 376(%r10)
        sbbq	384(%rdi), %rax
        movq	392(%r10), %rcx
        movq	%rax, 384(%r10)
        sbbq	392(%rdi), %rcx
        movq	400(%r10), %r8
        movq	%rcx, 392(%r10)
        sbbq	400(%rdi), %r8
        movq	408(%r10), %rax
        movq	%r8, 400(%r10)
        sbbq	408(%rdi), %rax
        movq	416(%r10), %rcx
        movq	%rax, 408(%r10)
        sbbq	416(%rdi), %rcx
        movq	424(%r10), %r8
        movq	%rcx, 416(%r10)
        sbbq	424(%rdi), %r8
        movq	432(%r10), %rax
        movq	%r8, 424(%r10)
        sbbq	432(%rdi), %rax
        movq	440(%r10), %rcx
        movq	%rax, 432(%r10)
        sbbq	440(%rdi), %rcx
        movq	448(%r10), %r8
        movq	%rcx, 440(%r10)
        sbbq	448(%rdi), %r8
        movq	456(%r10), %rax
        movq	%r8, 448(%r10)
        sbbq	456(%rdi), %rax
        movq	464(%r10), %rcx
        movq	%rax, 456(%r10)
        sbbq	464(%rdi), %rcx
        movq	472(%r10), %r8
        movq	%rcx, 464(%r10)
        sbbq	472(%rdi), %r8
        movq	480(%r10), %rax
        movq	%r8, 472(%r10)
        sbbq	480(%rdi), %rax
        movq	488(%r10), %rcx
        movq	%rax, 480(%r10)
        sbbq	488(%rdi), %rcx
        movq	496(%r10), %r8
        movq	%rcx, 488(%r10)
        sbbq	496(%rdi), %r8
        movq	504(%r10), %rax
        movq	%r8, 496(%r10)
        sbbq	504(%rdi), %rax
        movq	%rax, 504(%r10)
        sbbq	$0, %r9
        subq	$256, %r15
        # Add
        movq	(%r15), %rax
        addq	(%r10), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r10), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r10), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r10), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r10), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r10), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r10), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r10), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r10), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r10), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r10), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r10), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r10), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r10), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r10), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r10), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r10), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r10), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r10), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r10), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r10), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r10), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r10), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r10), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r10), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r10), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r10), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r10), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r10), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r10), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r10), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r10), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r10), %r8
        movq	264(%r15), %rax
        movq	%r8, 256(%r15)
        adcq	264(%r10), %rax
        movq	272(%r15), %rcx
        movq	%rax, 264(%r15)
        adcq	272(%r10), %rcx
        movq	280(%r15), %r8
        movq	%rcx, 272(%r15)
        adcq	280(%r10), %r8
        movq	288(%r15), %rax
        movq	%r8, 280(%r15)
        adcq	288(%r10), %rax
        movq	296(%r15), %rcx
        movq	%rax, 288(%r15)
        adcq	296(%r10), %rcx
        movq	304(%r15), %r8
        movq	%rcx, 296(%r15)
        adcq	304(%r10), %r8
        movq	312(%r15), %rax
        movq	%r8, 304(%r15)
        adcq	312(%r10), %rax
        movq	320(%r15), %rcx
        movq	%rax, 312(%r15)
        adcq	320(%r10), %rcx
        movq	328(%r15), %r8
        movq	%rcx, 320(%r15)
        adcq	328(%r10), %r8
        movq	336(%r15), %rax
        movq	%r8, 328(%r15)
        adcq	336(%r10), %rax
        movq	344(%r15), %rcx
        movq	%rax, 336(%r15)
        adcq	344(%r10), %rcx
        movq	352(%r15), %r8
        movq	%rcx, 344(%r15)
        adcq	352(%r10), %r8
        movq	360(%r15), %rax
        movq	%r8, 352(%r15)
        adcq	360(%r10), %rax
        movq	368(%r15), %rcx
        movq	%rax, 360(%r15)
        adcq	368(%r10), %rcx
        movq	376(%r15), %r8
        movq	%rcx, 368(%r15)
        adcq	376(%r10), %r8
        movq	384(%r15), %rax
        movq	%r8, 376(%r15)
        adcq	384(%r10), %rax
        movq	392(%r15), %rcx
        movq	%rax, 384(%r15)
        adcq	392(%r10), %rcx
        movq	400(%r15), %r8
        movq	%rcx, 392(%r15)
        adcq	400(%r10), %r8
        movq	408(%r15), %rax
        movq	%r8, 400(%r15)
        adcq	408(%r10), %rax
        movq	416(%r15), %rcx
        movq	%rax, 408(%r15)
        adcq	416(%r10), %rcx
        movq	424(%r15), %r8
        movq	%rcx, 416(%r15)
        adcq	424(%r10), %r8
        movq	432(%r15), %rax
        movq	%r8, 424(%r15)
        adcq	432(%r10), %rax
        movq	440(%r15), %rcx
        movq	%rax, 432(%r15)
        adcq	440(%r10), %rcx
        movq	448(%r15), %r8
        movq	%rcx, 440(%r15)
        adcq	448(%r10), %r8
        movq	456(%r15), %rax
        movq	%r8, 448(%r15)
        adcq	456(%r10), %rax
        movq	464(%r15), %rcx
        movq	%rax, 456(%r15)
        adcq	464(%r10), %rcx
        movq	472(%r15), %r8
        movq	%rcx, 464(%r15)
        adcq	472(%r10), %r8
        movq	480(%r15), %rax
        movq	%r8, 472(%r15)
        adcq	480(%r10), %rax
        movq	488(%r15), %rcx
        movq	%rax, 480(%r15)
        adcq	488(%r10), %rcx
        movq	496(%r15), %r8
        movq	%rcx, 488(%r15)
        adcq	496(%r10), %r8
        movq	504(%r15), %rax
        movq	%r8, 496(%r15)
        adcq	504(%r10), %rax
        movq	%rax, 504(%r15)
        adcq	$0, %r9
        movq	%r9, 768(%rdi)
        addq	$256, %r15
        # Add
        movq	(%r15), %rax
        xorq	%r9, %r9
        addq	(%r11), %rax
        movq	8(%r15), %rcx
        movq	%rax, (%r15)
        adcq	8(%r11), %rcx
        movq	16(%r15), %r8
        movq	%rcx, 8(%r15)
        adcq	16(%r11), %r8
        movq	24(%r15), %rax
        movq	%r8, 16(%r15)
        adcq	24(%r11), %rax
        movq	32(%r15), %rcx
        movq	%rax, 24(%r15)
        adcq	32(%r11), %rcx
        movq	40(%r15), %r8
        movq	%rcx, 32(%r15)
        adcq	40(%r11), %r8
        movq	48(%r15), %rax
        movq	%r8, 40(%r15)
        adcq	48(%r11), %rax
        movq	56(%r15), %rcx
        movq	%rax, 48(%r15)
        adcq	56(%r11), %rcx
        movq	64(%r15), %r8
        movq	%rcx, 56(%r15)
        adcq	64(%r11), %r8
        movq	72(%r15), %rax
        movq	%r8, 64(%r15)
        adcq	72(%r11), %rax
        movq	80(%r15), %rcx
        movq	%rax, 72(%r15)
        adcq	80(%r11), %rcx
        movq	88(%r15), %r8
        movq	%rcx, 80(%r15)
        adcq	88(%r11), %r8
        movq	96(%r15), %rax
        movq	%r8, 88(%r15)
        adcq	96(%r11), %rax
        movq	104(%r15), %rcx
        movq	%rax, 96(%r15)
        adcq	104(%r11), %rcx
        movq	112(%r15), %r8
        movq	%rcx, 104(%r15)
        adcq	112(%r11), %r8
        movq	120(%r15), %rax
        movq	%r8, 112(%r15)
        adcq	120(%r11), %rax
        movq	128(%r15), %rcx
        movq	%rax, 120(%r15)
        adcq	128(%r11), %rcx
        movq	136(%r15), %r8
        movq	%rcx, 128(%r15)
        adcq	136(%r11), %r8
        movq	144(%r15), %rax
        movq	%r8, 136(%r15)
        adcq	144(%r11), %rax
        movq	152(%r15), %rcx
        movq	%rax, 144(%r15)
        adcq	152(%r11), %rcx
        movq	160(%r15), %r8
        movq	%rcx, 152(%r15)
        adcq	160(%r11), %r8
        movq	168(%r15), %rax
        movq	%r8, 160(%r15)
        adcq	168(%r11), %rax
        movq	176(%r15), %rcx
        movq	%rax, 168(%r15)
        adcq	176(%r11), %rcx
        movq	184(%r15), %r8
        movq	%rcx, 176(%r15)
        adcq	184(%r11), %r8
        movq	192(%r15), %rax
        movq	%r8, 184(%r15)
        adcq	192(%r11), %rax
        movq	200(%r15), %rcx
        movq	%rax, 192(%r15)
        adcq	200(%r11), %rcx
        movq	208(%r15), %r8
        movq	%rcx, 200(%r15)
        adcq	208(%r11), %r8
        movq	216(%r15), %rax
        movq	%r8, 208(%r15)
        adcq	216(%r11), %rax
        movq	224(%r15), %rcx
        movq	%rax, 216(%r15)
        adcq	224(%r11), %rcx
        movq	232(%r15), %r8
        movq	%rcx, 224(%r15)
        adcq	232(%r11), %r8
        movq	240(%r15), %rax
        movq	%r8, 232(%r15)
        adcq	240(%r11), %rax
        movq	248(%r15), %rcx
        movq	%rax, 240(%r15)
        adcq	248(%r11), %rcx
        movq	256(%r15), %r8
        movq	%rcx, 248(%r15)
        adcq	256(%r11), %r8
        movq	%r8, 256(%r15)
        adcq	$0, %r9
        # Add to zero
        movq	264(%r11), %rax
        adcq	$0, %rax
        movq	272(%r11), %rcx
        movq	%rax, 264(%r15)
        adcq	$0, %rcx
        movq	280(%r11), %r8
        movq	%rcx, 272(%r15)
        adcq	$0, %r8
        movq	288(%r11), %rax
        movq	%r8, 280(%r15)
        adcq	$0, %rax
        movq	296(%r11), %rcx
        movq	%rax, 288(%r15)
        adcq	$0, %rcx
        movq	304(%r11), %r8
        movq	%rcx, 296(%r15)
        adcq	$0, %r8
        movq	312(%r11), %rax
        movq	%r8, 304(%r15)
        adcq	$0, %rax
        movq	320(%r11), %rcx
        movq	%rax, 312(%r15)
        adcq	$0, %rcx
        movq	328(%r11), %r8
        movq	%rcx, 320(%r15)
        adcq	$0, %r8
        movq	336(%r11), %rax
        movq	%r8, 328(%r15)
        adcq	$0, %rax
        movq	344(%r11), %rcx
        movq	%rax, 336(%r15)
        adcq	$0, %rcx
        movq	352(%r11), %r8
        movq	%rcx, 344(%r15)
        adcq	$0, %r8
        movq	360(%r11), %rax
        movq	%r8, 352(%r15)
        adcq	$0, %rax
        movq	368(%r11), %rcx
        movq	%rax, 360(%r15)
        adcq	$0, %rcx
        movq	376(%r11), %r8
        movq	%rcx, 368(%r15)
        adcq	$0, %r8
        movq	384(%r11), %rax
        movq	%r8, 376(%r15)
        adcq	$0, %rax
        movq	392(%r11), %rcx
        movq	%rax, 384(%r15)
        adcq	$0, %rcx
        movq	400(%r11), %r8
        movq	%rcx, 392(%r15)
        adcq	$0, %r8
        movq	408(%r11), %rax
        movq	%r8, 400(%r15)
        adcq	$0, %rax
        movq	416(%r11), %rcx
        movq	%rax, 408(%r15)
        adcq	$0, %rcx
        movq	424(%r11), %r8
        movq	%rcx, 416(%r15)
        adcq	$0, %r8
        movq	432(%r11), %rax
        movq	%r8, 424(%r15)
        adcq	$0, %rax
        movq	440(%r11), %rcx
        movq	%rax, 432(%r15)
        adcq	$0, %rcx
        movq	448(%r11), %r8
        movq	%rcx, 440(%r15)
        adcq	$0, %r8
        movq	456(%r11), %rax
        movq	%r8, 448(%r15)
        adcq	$0, %rax
        movq	464(%r11), %rcx
        movq	%rax, 456(%r15)
        adcq	$0, %rcx
        movq	472(%r11), %r8
        movq	%rcx, 464(%r15)
        adcq	$0, %r8
        movq	480(%r11), %rax
        movq	%r8, 472(%r15)
        adcq	$0, %rax
        movq	488(%r11), %rcx
        movq	%rax, 480(%r15)
        adcq	$0, %rcx
        movq	496(%r11), %r8
        movq	%rcx, 488(%r15)
        adcq	$0, %r8
        movq	504(%r11), %rax
        movq	%r8, 496(%r15)
        adcq	$0, %rax
        movq	%rax, 504(%r15)
        addq	$1576, %rsp
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_4096_mul_avx2_64,.-sp_4096_mul_avx2_64
#endif /* __APPLE__ */
/* Square a and put result in r. (r = a * a)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_4096_sqr_avx2_64
.type	sp_4096_sqr_avx2_64,@function
.align	16
sp_4096_sqr_avx2_64:
#else
.globl	_sp_4096_sqr_avx2_64
.p2align	4
_sp_4096_sqr_avx2_64:
#endif /* __APPLE__ */
        subq	$1304, %rsp
        movq	%rdi, 1280(%rsp)
        movq	%rsi, 1288(%rsp)
        leaq	1024(%rsp), %r8
        leaq	256(%rsi), %r9
        # Add
        movq	(%rsi), %rdx
        xorq	%rcx, %rcx
        addq	(%r9), %rdx
        movq	8(%rsi), %rax
        movq	%rdx, (%r8)
        adcq	8(%r9), %rax
        movq	16(%rsi), %rdx
        movq	%rax, 8(%r8)
        adcq	16(%r9), %rdx
        movq	24(%rsi), %rax
        movq	%rdx, 16(%r8)
        adcq	24(%r9), %rax
        movq	32(%rsi), %rdx
        movq	%rax, 24(%r8)
        adcq	32(%r9), %rdx
        movq	40(%rsi), %rax
        movq	%rdx, 32(%r8)
        adcq	40(%r9), %rax
        movq	48(%rsi), %rdx
        movq	%rax, 40(%r8)
        adcq	48(%r9), %rdx
        movq	56(%rsi), %rax
        movq	%rdx, 48(%r8)
        adcq	56(%r9), %rax
        movq	64(%rsi), %rdx
        movq	%rax, 56(%r8)
        adcq	64(%r9), %rdx
        movq	72(%rsi), %rax
        movq	%rdx, 64(%r8)
        adcq	72(%r9), %rax
        movq	80(%rsi), %rdx
        movq	%rax, 72(%r8)
        adcq	80(%r9), %rdx
        movq	88(%rsi), %rax
        movq	%rdx, 80(%r8)
        adcq	88(%r9), %rax
        movq	96(%rsi), %rdx
        movq	%rax, 88(%r8)
        adcq	96(%r9), %rdx
        movq	104(%rsi), %rax
        movq	%rdx, 96(%r8)
        adcq	104(%r9), %rax
        movq	112(%rsi), %rdx
        movq	%rax, 104(%r8)
        adcq	112(%r9), %rdx
        movq	120(%rsi), %rax
        movq	%rdx, 112(%r8)
        adcq	120(%r9), %rax
        movq	128(%rsi), %rdx
        movq	%rax, 120(%r8)
        adcq	128(%r9), %rdx
        movq	136(%rsi), %rax
        movq	%rdx, 128(%r8)
        adcq	136(%r9), %rax
        movq	144(%rsi), %rdx
        movq	%rax, 136(%r8)
        adcq	144(%r9), %rdx
        movq	152(%rsi), %rax
        movq	%rdx, 144(%r8)
        adcq	152(%r9), %rax
        movq	160(%rsi), %rdx
        movq	%rax, 152(%r8)
        adcq	160(%r9), %rdx
        movq	168(%rsi), %rax
        movq	%rdx, 160(%r8)
        adcq	168(%r9), %rax
        movq	176(%rsi), %rdx
        movq	%rax, 168(%r8)
        adcq	176(%r9), %rdx
        movq	184(%rsi), %rax
        movq	%rdx, 176(%r8)
        adcq	184(%r9), %rax
        movq	192(%rsi), %rdx
        movq	%rax, 184(%r8)
        adcq	192(%r9), %rdx
        movq	200(%rsi), %rax
        movq	%rdx, 192(%r8)
        adcq	200(%r9), %rax
        movq	208(%rsi), %rdx
        movq	%rax, 200(%r8)
        adcq	208(%r9), %rdx
        movq	216(%rsi), %rax
        movq	%rdx, 208(%r8)
        adcq	216(%r9), %rax
        movq	224(%rsi), %rdx
        movq	%rax, 216(%r8)
        adcq	224(%r9), %rdx
        movq	232(%rsi), %rax
        movq	%rdx, 224(%r8)
        adcq	232(%r9), %rax
        movq	240(%rsi), %rdx
        movq	%rax, 232(%r8)
        adcq	240(%r9), %rdx
        movq	248(%rsi), %rax
        movq	%rdx, 240(%r8)
        adcq	248(%r9), %rax
        movq	%rax, 248(%r8)
        adcq	$0, %rcx
        movq	%rcx, 1296(%rsp)
        movq	%r8, %rsi
        movq	%rsp, %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_32@plt
#else
        callq	_sp_2048_sqr_avx2_32
#endif /* __APPLE__ */
        movq	1288(%rsp), %rsi
        leaq	512(%rsp), %rdi
        addq	$256, %rsi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_32@plt
#else
        callq	_sp_2048_sqr_avx2_32
#endif /* __APPLE__ */
        movq	1288(%rsp), %rsi
        movq	1280(%rsp), %rdi
#ifndef __APPLE__
        callq	sp_2048_sqr_avx2_32@plt
#else
        callq	_sp_2048_sqr_avx2_32
#endif /* __APPLE__ */
        movq	1296(%rsp), %r10
        leaq	1024(%rsp), %r8
        movq	%r10, %rcx
        negq	%r10
        movq	(%r8), %rdx
        pextq	%r10, %rdx, %rdx
        addq	%rdx, %rdx
        movq	8(%r8), %rax
        movq	%rdx, 512(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	16(%r8), %rdx
        movq	%rax, 520(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	24(%r8), %rax
        movq	%rdx, 528(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	32(%r8), %rdx
        movq	%rax, 536(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	40(%r8), %rax
        movq	%rdx, 544(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	48(%r8), %rdx
        movq	%rax, 552(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	56(%r8), %rax
        movq	%rdx, 560(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	64(%r8), %rdx
        movq	%rax, 568(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	72(%r8), %rax
        movq	%rdx, 576(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	80(%r8), %rdx
        movq	%rax, 584(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	88(%r8), %rax
        movq	%rdx, 592(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	96(%r8), %rdx
        movq	%rax, 600(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	104(%r8), %rax
        movq	%rdx, 608(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	112(%r8), %rdx
        movq	%rax, 616(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	120(%r8), %rax
        movq	%rdx, 624(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	128(%r8), %rdx
        movq	%rax, 632(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	136(%r8), %rax
        movq	%rdx, 640(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	144(%r8), %rdx
        movq	%rax, 648(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	152(%r8), %rax
        movq	%rdx, 656(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	160(%r8), %rdx
        movq	%rax, 664(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	168(%r8), %rax
        movq	%rdx, 672(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	176(%r8), %rdx
        movq	%rax, 680(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	184(%r8), %rax
        movq	%rdx, 688(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	192(%r8), %rdx
        movq	%rax, 696(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	200(%r8), %rax
        movq	%rdx, 704(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	208(%r8), %rdx
        movq	%rax, 712(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	216(%r8), %rax
        movq	%rdx, 720(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	224(%r8), %rdx
        movq	%rax, 728(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	232(%r8), %rax
        movq	%rdx, 736(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	240(%r8), %rdx
        movq	%rax, 744(%rdi)
        pextq	%r10, %rdx, %rdx
        adcq	%rdx, %rdx
        movq	248(%r8), %rax
        movq	%rdx, 752(%rdi)
        pextq	%r10, %rax, %rax
        adcq	%rax, %rax
        movq	%rax, 760(%rdi)
        adcq	$0, %rcx
        leaq	512(%rsp), %rsi
        movq	%rsp, %r8
        movq	(%r8), %rdx
        subq	(%rsi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rsi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rsi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rsi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rsi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rsi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rsi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rsi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rsi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rsi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rsi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rsi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rsi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rsi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rsi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rsi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rsi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rsi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rsi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rsi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rsi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rsi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rsi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rsi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rsi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rsi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rsi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rsi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rsi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rsi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rsi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rsi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rsi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rsi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rsi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rsi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rsi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rsi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rsi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rsi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rsi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rsi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rsi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rsi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rsi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rsi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rsi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rsi), %rax
        movq	384(%r8), %rdx
        movq	%rax, 376(%r8)
        sbbq	384(%rsi), %rdx
        movq	392(%r8), %rax
        movq	%rdx, 384(%r8)
        sbbq	392(%rsi), %rax
        movq	400(%r8), %rdx
        movq	%rax, 392(%r8)
        sbbq	400(%rsi), %rdx
        movq	408(%r8), %rax
        movq	%rdx, 400(%r8)
        sbbq	408(%rsi), %rax
        movq	416(%r8), %rdx
        movq	%rax, 408(%r8)
        sbbq	416(%rsi), %rdx
        movq	424(%r8), %rax
        movq	%rdx, 416(%r8)
        sbbq	424(%rsi), %rax
        movq	432(%r8), %rdx
        movq	%rax, 424(%r8)
        sbbq	432(%rsi), %rdx
        movq	440(%r8), %rax
        movq	%rdx, 432(%r8)
        sbbq	440(%rsi), %rax
        movq	448(%r8), %rdx
        movq	%rax, 440(%r8)
        sbbq	448(%rsi), %rdx
        movq	456(%r8), %rax
        movq	%rdx, 448(%r8)
        sbbq	456(%rsi), %rax
        movq	464(%r8), %rdx
        movq	%rax, 456(%r8)
        sbbq	464(%rsi), %rdx
        movq	472(%r8), %rax
        movq	%rdx, 464(%r8)
        sbbq	472(%rsi), %rax
        movq	480(%r8), %rdx
        movq	%rax, 472(%r8)
        sbbq	480(%rsi), %rdx
        movq	488(%r8), %rax
        movq	%rdx, 480(%r8)
        sbbq	488(%rsi), %rax
        movq	496(%r8), %rdx
        movq	%rax, 488(%r8)
        sbbq	496(%rsi), %rdx
        movq	504(%r8), %rax
        movq	%rdx, 496(%r8)
        sbbq	504(%rsi), %rax
        movq	%rax, 504(%r8)
        sbbq	$0, %rcx
        movq	(%r8), %rdx
        subq	(%rdi), %rdx
        movq	8(%r8), %rax
        movq	%rdx, (%r8)
        sbbq	8(%rdi), %rax
        movq	16(%r8), %rdx
        movq	%rax, 8(%r8)
        sbbq	16(%rdi), %rdx
        movq	24(%r8), %rax
        movq	%rdx, 16(%r8)
        sbbq	24(%rdi), %rax
        movq	32(%r8), %rdx
        movq	%rax, 24(%r8)
        sbbq	32(%rdi), %rdx
        movq	40(%r8), %rax
        movq	%rdx, 32(%r8)
        sbbq	40(%rdi), %rax
        movq	48(%r8), %rdx
        movq	%rax, 40(%r8)
        sbbq	48(%rdi), %rdx
        movq	56(%r8), %rax
        movq	%rdx, 48(%r8)
        sbbq	56(%rdi), %rax
        movq	64(%r8), %rdx
        movq	%rax, 56(%r8)
        sbbq	64(%rdi), %rdx
        movq	72(%r8), %rax
        movq	%rdx, 64(%r8)
        sbbq	72(%rdi), %rax
        movq	80(%r8), %rdx
        movq	%rax, 72(%r8)
        sbbq	80(%rdi), %rdx
        movq	88(%r8), %rax
        movq	%rdx, 80(%r8)
        sbbq	88(%rdi), %rax
        movq	96(%r8), %rdx
        movq	%rax, 88(%r8)
        sbbq	96(%rdi), %rdx
        movq	104(%r8), %rax
        movq	%rdx, 96(%r8)
        sbbq	104(%rdi), %rax
        movq	112(%r8), %rdx
        movq	%rax, 104(%r8)
        sbbq	112(%rdi), %rdx
        movq	120(%r8), %rax
        movq	%rdx, 112(%r8)
        sbbq	120(%rdi), %rax
        movq	128(%r8), %rdx
        movq	%rax, 120(%r8)
        sbbq	128(%rdi), %rdx
        movq	136(%r8), %rax
        movq	%rdx, 128(%r8)
        sbbq	136(%rdi), %rax
        movq	144(%r8), %rdx
        movq	%rax, 136(%r8)
        sbbq	144(%rdi), %rdx
        movq	152(%r8), %rax
        movq	%rdx, 144(%r8)
        sbbq	152(%rdi), %rax
        movq	160(%r8), %rdx
        movq	%rax, 152(%r8)
        sbbq	160(%rdi), %rdx
        movq	168(%r8), %rax
        movq	%rdx, 160(%r8)
        sbbq	168(%rdi), %rax
        movq	176(%r8), %rdx
        movq	%rax, 168(%r8)
        sbbq	176(%rdi), %rdx
        movq	184(%r8), %rax
        movq	%rdx, 176(%r8)
        sbbq	184(%rdi), %rax
        movq	192(%r8), %rdx
        movq	%rax, 184(%r8)
        sbbq	192(%rdi), %rdx
        movq	200(%r8), %rax
        movq	%rdx, 192(%r8)
        sbbq	200(%rdi), %rax
        movq	208(%r8), %rdx
        movq	%rax, 200(%r8)
        sbbq	208(%rdi), %rdx
        movq	216(%r8), %rax
        movq	%rdx, 208(%r8)
        sbbq	216(%rdi), %rax
        movq	224(%r8), %rdx
        movq	%rax, 216(%r8)
        sbbq	224(%rdi), %rdx
        movq	232(%r8), %rax
        movq	%rdx, 224(%r8)
        sbbq	232(%rdi), %rax
        movq	240(%r8), %rdx
        movq	%rax, 232(%r8)
        sbbq	240(%rdi), %rdx
        movq	248(%r8), %rax
        movq	%rdx, 240(%r8)
        sbbq	248(%rdi), %rax
        movq	256(%r8), %rdx
        movq	%rax, 248(%r8)
        sbbq	256(%rdi), %rdx
        movq	264(%r8), %rax
        movq	%rdx, 256(%r8)
        sbbq	264(%rdi), %rax
        movq	272(%r8), %rdx
        movq	%rax, 264(%r8)
        sbbq	272(%rdi), %rdx
        movq	280(%r8), %rax
        movq	%rdx, 272(%r8)
        sbbq	280(%rdi), %rax
        movq	288(%r8), %rdx
        movq	%rax, 280(%r8)
        sbbq	288(%rdi), %rdx
        movq	296(%r8), %rax
        movq	%rdx, 288(%r8)
        sbbq	296(%rdi), %rax
        movq	304(%r8), %rdx
        movq	%rax, 296(%r8)
        sbbq	304(%rdi), %rdx
        movq	312(%r8), %rax
        movq	%rdx, 304(%r8)
        sbbq	312(%rdi), %rax
        movq	320(%r8), %rdx
        movq	%rax, 312(%r8)
        sbbq	320(%rdi), %rdx
        movq	328(%r8), %rax
        movq	%rdx, 320(%r8)
        sbbq	328(%rdi), %rax
        movq	336(%r8), %rdx
        movq	%rax, 328(%r8)
        sbbq	336(%rdi), %rdx
        movq	344(%r8), %rax
        movq	%rdx, 336(%r8)
        sbbq	344(%rdi), %rax
        movq	352(%r8), %rdx
        movq	%rax, 344(%r8)
        sbbq	352(%rdi), %rdx
        movq	360(%r8), %rax
        movq	%rdx, 352(%r8)
        sbbq	360(%rdi), %rax
        movq	368(%r8), %rdx
        movq	%rax, 360(%r8)
        sbbq	368(%rdi), %rdx
        movq	376(%r8), %rax
        movq	%rdx, 368(%r8)
        sbbq	376(%rdi), %rax
        movq	384(%r8), %rdx
        movq	%rax, 376(%r8)
        sbbq	384(%rdi), %rdx
        movq	392(%r8), %rax
        movq	%rdx, 384(%r8)
        sbbq	392(%rdi), %rax
        movq	400(%r8), %rdx
        movq	%rax, 392(%r8)
        sbbq	400(%rdi), %rdx
        movq	408(%r8), %rax
        movq	%rdx, 400(%r8)
        sbbq	408(%rdi), %rax
        movq	416(%r8), %rdx
        movq	%rax, 408(%r8)
        sbbq	416(%rdi), %rdx
        movq	424(%r8), %rax
        movq	%rdx, 416(%r8)
        sbbq	424(%rdi), %rax
        movq	432(%r8), %rdx
        movq	%rax, 424(%r8)
        sbbq	432(%rdi), %rdx
        movq	440(%r8), %rax
        movq	%rdx, 432(%r8)
        sbbq	440(%rdi), %rax
        movq	448(%r8), %rdx
        movq	%rax, 440(%r8)
        sbbq	448(%rdi), %rdx
        movq	456(%r8), %rax
        movq	%rdx, 448(%r8)
        sbbq	456(%rdi), %rax
        movq	464(%r8), %rdx
        movq	%rax, 456(%r8)
        sbbq	464(%rdi), %rdx
        movq	472(%r8), %rax
        movq	%rdx, 464(%r8)
        sbbq	472(%rdi), %rax
        movq	480(%r8), %rdx
        movq	%rax, 472(%r8)
        sbbq	480(%rdi), %rdx
        movq	488(%r8), %rax
        movq	%rdx, 480(%r8)
        sbbq	488(%rdi), %rax
        movq	496(%r8), %rdx
        movq	%rax, 488(%r8)
        sbbq	496(%rdi), %rdx
        movq	504(%r8), %rax
        movq	%rdx, 496(%r8)
        sbbq	504(%rdi), %rax
        movq	%rax, 504(%r8)
        sbbq	$0, %rcx
        # Add in place
        movq	256(%rdi), %rdx
        addq	(%r8), %rdx
        movq	264(%rdi), %rax
        movq	%rdx, 256(%rdi)
        adcq	8(%r8), %rax
        movq	272(%rdi), %rdx
        movq	%rax, 264(%rdi)
        adcq	16(%r8), %rdx
        movq	280(%rdi), %rax
        movq	%rdx, 272(%rdi)
        adcq	24(%r8), %rax
        movq	288(%rdi), %rdx
        movq	%rax, 280(%rdi)
        adcq	32(%r8), %rdx
        movq	296(%rdi), %rax
        movq	%rdx, 288(%rdi)
        adcq	40(%r8), %rax
        movq	304(%rdi), %rdx
        movq	%rax, 296(%rdi)
        adcq	48(%r8), %rdx
        movq	312(%rdi), %rax
        movq	%rdx, 304(%rdi)
        adcq	56(%r8), %rax
        movq	320(%rdi), %rdx
        movq	%rax, 312(%rdi)
        adcq	64(%r8), %rdx
        movq	328(%rdi), %rax
        movq	%rdx, 320(%rdi)
        adcq	72(%r8), %rax
        movq	336(%rdi), %rdx
        movq	%rax, 328(%rdi)
        adcq	80(%r8), %rdx
        movq	344(%rdi), %rax
        movq	%rdx, 336(%rdi)
        adcq	88(%r8), %rax
        movq	352(%rdi), %rdx
        movq	%rax, 344(%rdi)
        adcq	96(%r8), %rdx
        movq	360(%rdi), %rax
        movq	%rdx, 352(%rdi)
        adcq	104(%r8), %rax
        movq	368(%rdi), %rdx
        movq	%rax, 360(%rdi)
        adcq	112(%r8), %rdx
        movq	376(%rdi), %rax
        movq	%rdx, 368(%rdi)
        adcq	120(%r8), %rax
        movq	384(%rdi), %rdx
        movq	%rax, 376(%rdi)
        adcq	128(%r8), %rdx
        movq	392(%rdi), %rax
        movq	%rdx, 384(%rdi)
        adcq	136(%r8), %rax
        movq	400(%rdi), %rdx
        movq	%rax, 392(%rdi)
        adcq	144(%r8), %rdx
        movq	408(%rdi), %rax
        movq	%rdx, 400(%rdi)
        adcq	152(%r8), %rax
        movq	416(%rdi), %rdx
        movq	%rax, 408(%rdi)
        adcq	160(%r8), %rdx
        movq	424(%rdi), %rax
        movq	%rdx, 416(%rdi)
        adcq	168(%r8), %rax
        movq	432(%rdi), %rdx
        movq	%rax, 424(%rdi)
        adcq	176(%r8), %rdx
        movq	440(%rdi), %rax
        movq	%rdx, 432(%rdi)
        adcq	184(%r8), %rax
        movq	448(%rdi), %rdx
        movq	%rax, 440(%rdi)
        adcq	192(%r8), %rdx
        movq	456(%rdi), %rax
        movq	%rdx, 448(%rdi)
        adcq	200(%r8), %rax
        movq	464(%rdi), %rdx
        movq	%rax, 456(%rdi)
        adcq	208(%r8), %rdx
        movq	472(%rdi), %rax
        movq	%rdx, 464(%rdi)
        adcq	216(%r8), %rax
        movq	480(%rdi), %rdx
        movq	%rax, 472(%rdi)
        adcq	224(%r8), %rdx
        movq	488(%rdi), %rax
        movq	%rdx, 480(%rdi)
        adcq	232(%r8), %rax
        movq	496(%rdi), %rdx
        movq	%rax, 488(%rdi)
        adcq	240(%r8), %rdx
        movq	504(%rdi), %rax
        movq	%rdx, 496(%rdi)
        adcq	248(%r8), %rax
        movq	512(%rdi), %rdx
        movq	%rax, 504(%rdi)
        adcq	256(%r8), %rdx
        movq	520(%rdi), %rax
        movq	%rdx, 512(%rdi)
        adcq	264(%r8), %rax
        movq	528(%rdi), %rdx
        movq	%rax, 520(%rdi)
        adcq	272(%r8), %rdx
        movq	536(%rdi), %rax
        movq	%rdx, 528(%rdi)
        adcq	280(%r8), %rax
        movq	544(%rdi), %rdx
        movq	%rax, 536(%rdi)
        adcq	288(%r8), %rdx
        movq	552(%rdi), %rax
        movq	%rdx, 544(%rdi)
        adcq	296(%r8), %rax
        movq	560(%rdi), %rdx
        movq	%rax, 552(%rdi)
        adcq	304(%r8), %rdx
        movq	568(%rdi), %rax
        movq	%rdx, 560(%rdi)
        adcq	312(%r8), %rax
        movq	576(%rdi), %rdx
        movq	%rax, 568(%rdi)
        adcq	320(%r8), %rdx
        movq	584(%rdi), %rax
        movq	%rdx, 576(%rdi)
        adcq	328(%r8), %rax
        movq	592(%rdi), %rdx
        movq	%rax, 584(%rdi)
        adcq	336(%r8), %rdx
        movq	600(%rdi), %rax
        movq	%rdx, 592(%rdi)
        adcq	344(%r8), %rax
        movq	608(%rdi), %rdx
        movq	%rax, 600(%rdi)
        adcq	352(%r8), %rdx
        movq	616(%rdi), %rax
        movq	%rdx, 608(%rdi)
        adcq	360(%r8), %rax
        movq	624(%rdi), %rdx
        movq	%rax, 616(%rdi)
        adcq	368(%r8), %rdx
        movq	632(%rdi), %rax
        movq	%rdx, 624(%rdi)
        adcq	376(%r8), %rax
        movq	640(%rdi), %rdx
        movq	%rax, 632(%rdi)
        adcq	384(%r8), %rdx
        movq	648(%rdi), %rax
        movq	%rdx, 640(%rdi)
        adcq	392(%r8), %rax
        movq	656(%rdi), %rdx
        movq	%rax, 648(%rdi)
        adcq	400(%r8), %rdx
        movq	664(%rdi), %rax
        movq	%rdx, 656(%rdi)
        adcq	408(%r8), %rax
        movq	672(%rdi), %rdx
        movq	%rax, 664(%rdi)
        adcq	416(%r8), %rdx
        movq	680(%rdi), %rax
        movq	%rdx, 672(%rdi)
        adcq	424(%r8), %rax
        movq	688(%rdi), %rdx
        movq	%rax, 680(%rdi)
        adcq	432(%r8), %rdx
        movq	696(%rdi), %rax
        movq	%rdx, 688(%rdi)
        adcq	440(%r8), %rax
        movq	704(%rdi), %rdx
        movq	%rax, 696(%rdi)
        adcq	448(%r8), %rdx
        movq	712(%rdi), %rax
        movq	%rdx, 704(%rdi)
        adcq	456(%r8), %rax
        movq	720(%rdi), %rdx
        movq	%rax, 712(%rdi)
        adcq	464(%r8), %rdx
        movq	728(%rdi), %rax
        movq	%rdx, 720(%rdi)
        adcq	472(%r8), %rax
        movq	736(%rdi), %rdx
        movq	%rax, 728(%rdi)
        adcq	480(%r8), %rdx
        movq	744(%rdi), %rax
        movq	%rdx, 736(%rdi)
        adcq	488(%r8), %rax
        movq	752(%rdi), %rdx
        movq	%rax, 744(%rdi)
        adcq	496(%r8), %rdx
        movq	760(%rdi), %rax
        movq	%rdx, 752(%rdi)
        adcq	504(%r8), %rax
        movq	%rax, 760(%rdi)
        adcq	$0, %rcx
        movq	%rcx, 768(%rdi)
        # Add in place
        movq	512(%rdi), %rdx
        xorq	%rcx, %rcx
        addq	(%rsi), %rdx
        movq	520(%rdi), %rax
        movq	%rdx, 512(%rdi)
        adcq	8(%rsi), %rax
        movq	528(%rdi), %rdx
        movq	%rax, 520(%rdi)
        adcq	16(%rsi), %rdx
        movq	536(%rdi), %rax
        movq	%rdx, 528(%rdi)
        adcq	24(%rsi), %rax
        movq	544(%rdi), %rdx
        movq	%rax, 536(%rdi)
        adcq	32(%rsi), %rdx
        movq	552(%rdi), %rax
        movq	%rdx, 544(%rdi)
        adcq	40(%rsi), %rax
        movq	560(%rdi), %rdx
        movq	%rax, 552(%rdi)
        adcq	48(%rsi), %rdx
        movq	568(%rdi), %rax
        movq	%rdx, 560(%rdi)
        adcq	56(%rsi), %rax
        movq	576(%rdi), %rdx
        movq	%rax, 568(%rdi)
        adcq	64(%rsi), %rdx
        movq	584(%rdi), %rax
        movq	%rdx, 576(%rdi)
        adcq	72(%rsi), %rax
        movq	592(%rdi), %rdx
        movq	%rax, 584(%rdi)
        adcq	80(%rsi), %rdx
        movq	600(%rdi), %rax
        movq	%rdx, 592(%rdi)
        adcq	88(%rsi), %rax
        movq	608(%rdi), %rdx
        movq	%rax, 600(%rdi)
        adcq	96(%rsi), %rdx
        movq	616(%rdi), %rax
        movq	%rdx, 608(%rdi)
        adcq	104(%rsi), %rax
        movq	624(%rdi), %rdx
        movq	%rax, 616(%rdi)
        adcq	112(%rsi), %rdx
        movq	632(%rdi), %rax
        movq	%rdx, 624(%rdi)
        adcq	120(%rsi), %rax
        movq	640(%rdi), %rdx
        movq	%rax, 632(%rdi)
        adcq	128(%rsi), %rdx
        movq	648(%rdi), %rax
        movq	%rdx, 640(%rdi)
        adcq	136(%rsi), %rax
        movq	656(%rdi), %rdx
        movq	%rax, 648(%rdi)
        adcq	144(%rsi), %rdx
        movq	664(%rdi), %rax
        movq	%rdx, 656(%rdi)
        adcq	152(%rsi), %rax
        movq	672(%rdi), %rdx
        movq	%rax, 664(%rdi)
        adcq	160(%rsi), %rdx
        movq	680(%rdi), %rax
        movq	%rdx, 672(%rdi)
        adcq	168(%rsi), %rax
        movq	688(%rdi), %rdx
        movq	%rax, 680(%rdi)
        adcq	176(%rsi), %rdx
        movq	696(%rdi), %rax
        movq	%rdx, 688(%rdi)
        adcq	184(%rsi), %rax
        movq	704(%rdi), %rdx
        movq	%rax, 696(%rdi)
        adcq	192(%rsi), %rdx
        movq	712(%rdi), %rax
        movq	%rdx, 704(%rdi)
        adcq	200(%rsi), %rax
        movq	720(%rdi), %rdx
        movq	%rax, 712(%rdi)
        adcq	208(%rsi), %rdx
        movq	728(%rdi), %rax
        movq	%rdx, 720(%rdi)
        adcq	216(%rsi), %rax
        movq	736(%rdi), %rdx
        movq	%rax, 728(%rdi)
        adcq	224(%rsi), %rdx
        movq	744(%rdi), %rax
        movq	%rdx, 736(%rdi)
        adcq	232(%rsi), %rax
        movq	752(%rdi), %rdx
        movq	%rax, 744(%rdi)
        adcq	240(%rsi), %rdx
        movq	760(%rdi), %rax
        movq	%rdx, 752(%rdi)
        adcq	248(%rsi), %rax
        movq	768(%rdi), %rdx
        movq	%rax, 760(%rdi)
        adcq	256(%rsi), %rdx
        movq	%rdx, 768(%rdi)
        adcq	$0, %rcx
        # Add to zero
        movq	264(%rsi), %rdx
        adcq	$0, %rdx
        movq	272(%rsi), %rax
        movq	%rdx, 776(%rdi)
        adcq	$0, %rax
        movq	280(%rsi), %rdx
        movq	%rax, 784(%rdi)
        adcq	$0, %rdx
        movq	288(%rsi), %rax
        movq	%rdx, 792(%rdi)
        adcq	$0, %rax
        movq	296(%rsi), %rdx
        movq	%rax, 800(%rdi)
        adcq	$0, %rdx
        movq	304(%rsi), %rax
        movq	%rdx, 808(%rdi)
        adcq	$0, %rax
        movq	312(%rsi), %rdx
        movq	%rax, 816(%rdi)
        adcq	$0, %rdx
        movq	320(%rsi), %rax
        movq	%rdx, 824(%rdi)
        adcq	$0, %rax
        movq	328(%rsi), %rdx
        movq	%rax, 832(%rdi)
        adcq	$0, %rdx
        movq	336(%rsi), %rax
        movq	%rdx, 840(%rdi)
        adcq	$0, %rax
        movq	344(%rsi), %rdx
        movq	%rax, 848(%rdi)
        adcq	$0, %rdx
        movq	352(%rsi), %rax
        movq	%rdx, 856(%rdi)
        adcq	$0, %rax
        movq	360(%rsi), %rdx
        movq	%rax, 864(%rdi)
        adcq	$0, %rdx
        movq	368(%rsi), %rax
        movq	%rdx, 872(%rdi)
        adcq	$0, %rax
        movq	376(%rsi), %rdx
        movq	%rax, 880(%rdi)
        adcq	$0, %rdx
        movq	384(%rsi), %rax
        movq	%rdx, 888(%rdi)
        adcq	$0, %rax
        movq	392(%rsi), %rdx
        movq	%rax, 896(%rdi)
        adcq	$0, %rdx
        movq	400(%rsi), %rax
        movq	%rdx, 904(%rdi)
        adcq	$0, %rax
        movq	408(%rsi), %rdx
        movq	%rax, 912(%rdi)
        adcq	$0, %rdx
        movq	416(%rsi), %rax
        movq	%rdx, 920(%rdi)
        adcq	$0, %rax
        movq	424(%rsi), %rdx
        movq	%rax, 928(%rdi)
        adcq	$0, %rdx
        movq	432(%rsi), %rax
        movq	%rdx, 936(%rdi)
        adcq	$0, %rax
        movq	440(%rsi), %rdx
        movq	%rax, 944(%rdi)
        adcq	$0, %rdx
        movq	448(%rsi), %rax
        movq	%rdx, 952(%rdi)
        adcq	$0, %rax
        movq	456(%rsi), %rdx
        movq	%rax, 960(%rdi)
        adcq	$0, %rdx
        movq	464(%rsi), %rax
        movq	%rdx, 968(%rdi)
        adcq	$0, %rax
        movq	472(%rsi), %rdx
        movq	%rax, 976(%rdi)
        adcq	$0, %rdx
        movq	480(%rsi), %rax
        movq	%rdx, 984(%rdi)
        adcq	$0, %rax
        movq	488(%rsi), %rdx
        movq	%rax, 992(%rdi)
        adcq	$0, %rdx
        movq	496(%rsi), %rax
        movq	%rdx, 1000(%rdi)
        adcq	$0, %rax
        movq	504(%rsi), %rdx
        movq	%rax, 1008(%rdi)
        adcq	$0, %rdx
        movq	%rdx, 1016(%rdi)
        addq	$1304, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_4096_sqr_avx2_64,.-sp_4096_sqr_avx2_64
#endif /* __APPLE__ */
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_4096_mul_d_64
.type	sp_4096_mul_d_64,@function
.align	16
sp_4096_mul_d_64:
#else
.globl	_sp_4096_mul_d_64
.p2align	4
_sp_4096_mul_d_64:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        # A[0] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        movq	%rax, %r8
        movq	%rdx, %r9
        movq	%r8, (%rdi)
        # A[1] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	8(%rsi)
        addq	%rax, %r9
        movq	%r9, 8(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[2] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	16(%rsi)
        addq	%rax, %r10
        movq	%r10, 16(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[3] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	24(%rsi)
        addq	%rax, %r8
        movq	%r8, 24(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[4] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	32(%rsi)
        addq	%rax, %r9
        movq	%r9, 32(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[5] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        addq	%rax, %r10
        movq	%r10, 40(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[6] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        addq	%rax, %r8
        movq	%r8, 48(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[7] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	56(%rsi)
        addq	%rax, %r9
        movq	%r9, 56(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[8] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	64(%rsi)
        addq	%rax, %r10
        movq	%r10, 64(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[9] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	72(%rsi)
        addq	%rax, %r8
        movq	%r8, 72(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[10] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	80(%rsi)
        addq	%rax, %r9
        movq	%r9, 80(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[11] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        addq	%rax, %r10
        movq	%r10, 88(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[12] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        addq	%rax, %r8
        movq	%r8, 96(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[13] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	104(%rsi)
        addq	%rax, %r9
        movq	%r9, 104(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[14] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	112(%rsi)
        addq	%rax, %r10
        movq	%r10, 112(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[15] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	120(%rsi)
        addq	%rax, %r8
        movq	%r8, 120(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[16] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	128(%rsi)
        addq	%rax, %r9
        movq	%r9, 128(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[17] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        addq	%rax, %r10
        movq	%r10, 136(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[18] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        addq	%rax, %r8
        movq	%r8, 144(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[19] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	152(%rsi)
        addq	%rax, %r9
        movq	%r9, 152(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[20] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	160(%rsi)
        addq	%rax, %r10
        movq	%r10, 160(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[21] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	168(%rsi)
        addq	%rax, %r8
        movq	%r8, 168(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[22] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	176(%rsi)
        addq	%rax, %r9
        movq	%r9, 176(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[23] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        addq	%rax, %r10
        movq	%r10, 184(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[24] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        addq	%rax, %r8
        movq	%r8, 192(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[25] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	200(%rsi)
        addq	%rax, %r9
        movq	%r9, 200(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[26] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	208(%rsi)
        addq	%rax, %r10
        movq	%r10, 208(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[27] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	216(%rsi)
        addq	%rax, %r8
        movq	%r8, 216(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[28] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	224(%rsi)
        addq	%rax, %r9
        movq	%r9, 224(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[29] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        addq	%rax, %r10
        movq	%r10, 232(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[30] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        addq	%rax, %r8
        movq	%r8, 240(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[31] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	248(%rsi)
        addq	%rax, %r9
        movq	%r9, 248(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[32] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	256(%rsi)
        addq	%rax, %r10
        movq	%r10, 256(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[33] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	264(%rsi)
        addq	%rax, %r8
        movq	%r8, 264(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[34] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	272(%rsi)
        addq	%rax, %r9
        movq	%r9, 272(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[35] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	280(%rsi)
        addq	%rax, %r10
        movq	%r10, 280(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[36] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	288(%rsi)
        addq	%rax, %r8
        movq	%r8, 288(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[37] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	296(%rsi)
        addq	%rax, %r9
        movq	%r9, 296(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[38] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	304(%rsi)
        addq	%rax, %r10
        movq	%r10, 304(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[39] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	312(%rsi)
        addq	%rax, %r8
        movq	%r8, 312(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[40] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	320(%rsi)
        addq	%rax, %r9
        movq	%r9, 320(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[41] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	328(%rsi)
        addq	%rax, %r10
        movq	%r10, 328(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[42] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	336(%rsi)
        addq	%rax, %r8
        movq	%r8, 336(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[43] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	344(%rsi)
        addq	%rax, %r9
        movq	%r9, 344(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[44] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	352(%rsi)
        addq	%rax, %r10
        movq	%r10, 352(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[45] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	360(%rsi)
        addq	%rax, %r8
        movq	%r8, 360(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[46] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	368(%rsi)
        addq	%rax, %r9
        movq	%r9, 368(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[47] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	376(%rsi)
        addq	%rax, %r10
        movq	%r10, 376(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[48] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	384(%rsi)
        addq	%rax, %r8
        movq	%r8, 384(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[49] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	392(%rsi)
        addq	%rax, %r9
        movq	%r9, 392(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[50] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	400(%rsi)
        addq	%rax, %r10
        movq	%r10, 400(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[51] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	408(%rsi)
        addq	%rax, %r8
        movq	%r8, 408(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[52] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	416(%rsi)
        addq	%rax, %r9
        movq	%r9, 416(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[53] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	424(%rsi)
        addq	%rax, %r10
        movq	%r10, 424(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[54] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	432(%rsi)
        addq	%rax, %r8
        movq	%r8, 432(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[55] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	440(%rsi)
        addq	%rax, %r9
        movq	%r9, 440(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[56] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	448(%rsi)
        addq	%rax, %r10
        movq	%r10, 448(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[57] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	456(%rsi)
        addq	%rax, %r8
        movq	%r8, 456(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[58] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	464(%rsi)
        addq	%rax, %r9
        movq	%r9, 464(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[59] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	472(%rsi)
        addq	%rax, %r10
        movq	%r10, 472(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[60] * B
        movq	%rcx, %rax
        xorq	%r10, %r10
        mulq	480(%rsi)
        addq	%rax, %r8
        movq	%r8, 480(%rdi)
        adcq	%rdx, %r9
        adcq	$0, %r10
        # A[61] * B
        movq	%rcx, %rax
        xorq	%r8, %r8
        mulq	488(%rsi)
        addq	%rax, %r9
        movq	%r9, 488(%rdi)
        adcq	%rdx, %r10
        adcq	$0, %r8
        # A[62] * B
        movq	%rcx, %rax
        xorq	%r9, %r9
        mulq	496(%rsi)
        addq	%rax, %r10
        movq	%r10, 496(%rdi)
        adcq	%rdx, %r8
        adcq	$0, %r9
        # A[63] * B
        movq	%rcx, %rax
        mulq	504(%rsi)
        addq	%rax, %r8
        adcq	%rdx, %r9
        movq	%r8, 504(%rdi)
        movq	%r9, 512(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_4096_mul_d_64,.-sp_4096_mul_d_64
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_4096_cond_sub_64
.type	sp_4096_cond_sub_64,@function
.align	16
sp_4096_cond_sub_64:
#else
.globl	_sp_4096_cond_sub_64
.p2align	4
_sp_4096_cond_sub_64:
#endif /* __APPLE__ */
        subq	$512, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	192(%rdx), %r8
        movq	200(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 192(%rsp)
        movq	%r9, 200(%rsp)
        movq	208(%rdx), %r8
        movq	216(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 208(%rsp)
        movq	%r9, 216(%rsp)
        movq	224(%rdx), %r8
        movq	232(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 224(%rsp)
        movq	%r9, 232(%rsp)
        movq	240(%rdx), %r8
        movq	248(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 240(%rsp)
        movq	%r9, 248(%rsp)
        movq	256(%rdx), %r8
        movq	264(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 256(%rsp)
        movq	%r9, 264(%rsp)
        movq	272(%rdx), %r8
        movq	280(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 272(%rsp)
        movq	%r9, 280(%rsp)
        movq	288(%rdx), %r8
        movq	296(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 288(%rsp)
        movq	%r9, 296(%rsp)
        movq	304(%rdx), %r8
        movq	312(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 304(%rsp)
        movq	%r9, 312(%rsp)
        movq	320(%rdx), %r8
        movq	328(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 320(%rsp)
        movq	%r9, 328(%rsp)
        movq	336(%rdx), %r8
        movq	344(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 336(%rsp)
        movq	%r9, 344(%rsp)
        movq	352(%rdx), %r8
        movq	360(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 352(%rsp)
        movq	%r9, 360(%rsp)
        movq	368(%rdx), %r8
        movq	376(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 368(%rsp)
        movq	%r9, 376(%rsp)
        movq	384(%rdx), %r8
        movq	392(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 384(%rsp)
        movq	%r9, 392(%rsp)
        movq	400(%rdx), %r8
        movq	408(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 400(%rsp)
        movq	%r9, 408(%rsp)
        movq	416(%rdx), %r8
        movq	424(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 416(%rsp)
        movq	%r9, 424(%rsp)
        movq	432(%rdx), %r8
        movq	440(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 432(%rsp)
        movq	%r9, 440(%rsp)
        movq	448(%rdx), %r8
        movq	456(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 448(%rsp)
        movq	%r9, 456(%rsp)
        movq	464(%rdx), %r8
        movq	472(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 464(%rsp)
        movq	%r9, 472(%rsp)
        movq	480(%rdx), %r8
        movq	488(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 480(%rsp)
        movq	%r9, 488(%rsp)
        movq	496(%rdx), %r8
        movq	504(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 496(%rsp)
        movq	%r9, 504(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        subq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	192(%rsi), %r8
        movq	192(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 184(%rdi)
        movq	200(%rsi), %r9
        movq	200(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 192(%rdi)
        movq	208(%rsi), %r8
        movq	208(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 200(%rdi)
        movq	216(%rsi), %r9
        movq	216(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 208(%rdi)
        movq	224(%rsi), %r8
        movq	224(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 216(%rdi)
        movq	232(%rsi), %r9
        movq	232(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 224(%rdi)
        movq	240(%rsi), %r8
        movq	240(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 232(%rdi)
        movq	248(%rsi), %r9
        movq	248(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	256(%rsi), %r8
        movq	256(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 248(%rdi)
        movq	264(%rsi), %r9
        movq	264(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 256(%rdi)
        movq	272(%rsi), %r8
        movq	272(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 264(%rdi)
        movq	280(%rsi), %r9
        movq	280(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 272(%rdi)
        movq	288(%rsi), %r8
        movq	288(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 280(%rdi)
        movq	296(%rsi), %r9
        movq	296(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 288(%rdi)
        movq	304(%rsi), %r8
        movq	304(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 296(%rdi)
        movq	312(%rsi), %r9
        movq	312(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 304(%rdi)
        movq	320(%rsi), %r8
        movq	320(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 312(%rdi)
        movq	328(%rsi), %r9
        movq	328(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 320(%rdi)
        movq	336(%rsi), %r8
        movq	336(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 328(%rdi)
        movq	344(%rsi), %r9
        movq	344(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 336(%rdi)
        movq	352(%rsi), %r8
        movq	352(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 344(%rdi)
        movq	360(%rsi), %r9
        movq	360(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 352(%rdi)
        movq	368(%rsi), %r8
        movq	368(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 360(%rdi)
        movq	376(%rsi), %r9
        movq	376(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 368(%rdi)
        movq	384(%rsi), %r8
        movq	384(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 376(%rdi)
        movq	392(%rsi), %r9
        movq	392(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 384(%rdi)
        movq	400(%rsi), %r8
        movq	400(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 392(%rdi)
        movq	408(%rsi), %r9
        movq	408(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 400(%rdi)
        movq	416(%rsi), %r8
        movq	416(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 408(%rdi)
        movq	424(%rsi), %r9
        movq	424(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 416(%rdi)
        movq	432(%rsi), %r8
        movq	432(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 424(%rdi)
        movq	440(%rsi), %r9
        movq	440(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 432(%rdi)
        movq	448(%rsi), %r8
        movq	448(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 440(%rdi)
        movq	456(%rsi), %r9
        movq	456(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 448(%rdi)
        movq	464(%rsi), %r8
        movq	464(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 456(%rdi)
        movq	472(%rsi), %r9
        movq	472(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 464(%rdi)
        movq	480(%rsi), %r8
        movq	480(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 472(%rdi)
        movq	488(%rsi), %r9
        movq	488(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 480(%rdi)
        movq	496(%rsi), %r8
        movq	496(%rsp), %rdx
        sbbq	%rdx, %r8
        movq	%r9, 488(%rdi)
        movq	504(%rsi), %r9
        movq	504(%rsp), %rdx
        sbbq	%rdx, %r9
        movq	%r8, 496(%rdi)
        movq	%r9, 504(%rdi)
        sbbq	$0, %rax
        addq	$512, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_4096_cond_sub_64,.-sp_4096_cond_sub_64
#endif /* __APPLE__ */
/* Reduce the number back to 4096 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_4096_mont_reduce_64
.type	sp_4096_mont_reduce_64,@function
.align	16
sp_4096_mont_reduce_64:
#else
.globl	_sp_4096_mont_reduce_64
.p2align	4
_sp_4096_mont_reduce_64:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        push	%r15
        movq	%rdx, %rcx
        xorq	%r15, %r15
        # i = 64
        movq	$64, %r8
        movq	(%rdi), %r13
        movq	8(%rdi), %r14
L_mont_loop_64:
        # mu = a[i] * mp
        movq	%r13, %r11
        imulq	%rcx, %r11
        # a[i+0] += m[0] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	(%rsi)
        addq	%rax, %r13
        adcq	%rdx, %r10
        # a[i+1] += m[1] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	8(%rsi)
        movq	%r14, %r13
        addq	%rax, %r13
        adcq	%rdx, %r9
        addq	%r10, %r13
        adcq	$0, %r9
        # a[i+2] += m[2] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	16(%rsi)
        movq	16(%rdi), %r14
        addq	%rax, %r14
        adcq	%rdx, %r10
        addq	%r9, %r14
        adcq	$0, %r10
        # a[i+3] += m[3] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	24(%rsi)
        movq	24(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 24(%rdi)
        adcq	$0, %r9
        # a[i+4] += m[4] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	32(%rsi)
        movq	32(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 32(%rdi)
        adcq	$0, %r10
        # a[i+5] += m[5] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	40(%rsi)
        movq	40(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 40(%rdi)
        adcq	$0, %r9
        # a[i+6] += m[6] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	48(%rsi)
        movq	48(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 48(%rdi)
        adcq	$0, %r10
        # a[i+7] += m[7] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	56(%rsi)
        movq	56(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 56(%rdi)
        adcq	$0, %r9
        # a[i+8] += m[8] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	64(%rsi)
        movq	64(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 64(%rdi)
        adcq	$0, %r10
        # a[i+9] += m[9] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	72(%rsi)
        movq	72(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 72(%rdi)
        adcq	$0, %r9
        # a[i+10] += m[10] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	80(%rsi)
        movq	80(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 80(%rdi)
        adcq	$0, %r10
        # a[i+11] += m[11] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	88(%rsi)
        movq	88(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 88(%rdi)
        adcq	$0, %r9
        # a[i+12] += m[12] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	96(%rsi)
        movq	96(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 96(%rdi)
        adcq	$0, %r10
        # a[i+13] += m[13] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	104(%rsi)
        movq	104(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 104(%rdi)
        adcq	$0, %r9
        # a[i+14] += m[14] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	112(%rsi)
        movq	112(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 112(%rdi)
        adcq	$0, %r10
        # a[i+15] += m[15] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	120(%rsi)
        movq	120(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 120(%rdi)
        adcq	$0, %r9
        # a[i+16] += m[16] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	128(%rsi)
        movq	128(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 128(%rdi)
        adcq	$0, %r10
        # a[i+17] += m[17] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	136(%rsi)
        movq	136(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 136(%rdi)
        adcq	$0, %r9
        # a[i+18] += m[18] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	144(%rsi)
        movq	144(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 144(%rdi)
        adcq	$0, %r10
        # a[i+19] += m[19] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	152(%rsi)
        movq	152(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 152(%rdi)
        adcq	$0, %r9
        # a[i+20] += m[20] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	160(%rsi)
        movq	160(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 160(%rdi)
        adcq	$0, %r10
        # a[i+21] += m[21] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	168(%rsi)
        movq	168(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 168(%rdi)
        adcq	$0, %r9
        # a[i+22] += m[22] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	176(%rsi)
        movq	176(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 176(%rdi)
        adcq	$0, %r10
        # a[i+23] += m[23] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	184(%rsi)
        movq	184(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 184(%rdi)
        adcq	$0, %r9
        # a[i+24] += m[24] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	192(%rsi)
        movq	192(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 192(%rdi)
        adcq	$0, %r10
        # a[i+25] += m[25] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	200(%rsi)
        movq	200(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 200(%rdi)
        adcq	$0, %r9
        # a[i+26] += m[26] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	208(%rsi)
        movq	208(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 208(%rdi)
        adcq	$0, %r10
        # a[i+27] += m[27] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	216(%rsi)
        movq	216(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 216(%rdi)
        adcq	$0, %r9
        # a[i+28] += m[28] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	224(%rsi)
        movq	224(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 224(%rdi)
        adcq	$0, %r10
        # a[i+29] += m[29] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	232(%rsi)
        movq	232(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 232(%rdi)
        adcq	$0, %r9
        # a[i+30] += m[30] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	240(%rsi)
        movq	240(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 240(%rdi)
        adcq	$0, %r10
        # a[i+31] += m[31] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	248(%rsi)
        movq	248(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 248(%rdi)
        adcq	$0, %r9
        # a[i+32] += m[32] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	256(%rsi)
        movq	256(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 256(%rdi)
        adcq	$0, %r10
        # a[i+33] += m[33] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	264(%rsi)
        movq	264(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 264(%rdi)
        adcq	$0, %r9
        # a[i+34] += m[34] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	272(%rsi)
        movq	272(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 272(%rdi)
        adcq	$0, %r10
        # a[i+35] += m[35] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	280(%rsi)
        movq	280(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 280(%rdi)
        adcq	$0, %r9
        # a[i+36] += m[36] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	288(%rsi)
        movq	288(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 288(%rdi)
        adcq	$0, %r10
        # a[i+37] += m[37] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	296(%rsi)
        movq	296(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 296(%rdi)
        adcq	$0, %r9
        # a[i+38] += m[38] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	304(%rsi)
        movq	304(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 304(%rdi)
        adcq	$0, %r10
        # a[i+39] += m[39] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	312(%rsi)
        movq	312(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 312(%rdi)
        adcq	$0, %r9
        # a[i+40] += m[40] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	320(%rsi)
        movq	320(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 320(%rdi)
        adcq	$0, %r10
        # a[i+41] += m[41] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	328(%rsi)
        movq	328(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 328(%rdi)
        adcq	$0, %r9
        # a[i+42] += m[42] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	336(%rsi)
        movq	336(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 336(%rdi)
        adcq	$0, %r10
        # a[i+43] += m[43] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	344(%rsi)
        movq	344(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 344(%rdi)
        adcq	$0, %r9
        # a[i+44] += m[44] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	352(%rsi)
        movq	352(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 352(%rdi)
        adcq	$0, %r10
        # a[i+45] += m[45] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	360(%rsi)
        movq	360(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 360(%rdi)
        adcq	$0, %r9
        # a[i+46] += m[46] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	368(%rsi)
        movq	368(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 368(%rdi)
        adcq	$0, %r10
        # a[i+47] += m[47] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	376(%rsi)
        movq	376(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 376(%rdi)
        adcq	$0, %r9
        # a[i+48] += m[48] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	384(%rsi)
        movq	384(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 384(%rdi)
        adcq	$0, %r10
        # a[i+49] += m[49] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	392(%rsi)
        movq	392(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 392(%rdi)
        adcq	$0, %r9
        # a[i+50] += m[50] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	400(%rsi)
        movq	400(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 400(%rdi)
        adcq	$0, %r10
        # a[i+51] += m[51] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	408(%rsi)
        movq	408(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 408(%rdi)
        adcq	$0, %r9
        # a[i+52] += m[52] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	416(%rsi)
        movq	416(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 416(%rdi)
        adcq	$0, %r10
        # a[i+53] += m[53] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	424(%rsi)
        movq	424(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 424(%rdi)
        adcq	$0, %r9
        # a[i+54] += m[54] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	432(%rsi)
        movq	432(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 432(%rdi)
        adcq	$0, %r10
        # a[i+55] += m[55] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	440(%rsi)
        movq	440(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 440(%rdi)
        adcq	$0, %r9
        # a[i+56] += m[56] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	448(%rsi)
        movq	448(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 448(%rdi)
        adcq	$0, %r10
        # a[i+57] += m[57] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	456(%rsi)
        movq	456(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 456(%rdi)
        adcq	$0, %r9
        # a[i+58] += m[58] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	464(%rsi)
        movq	464(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 464(%rdi)
        adcq	$0, %r10
        # a[i+59] += m[59] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	472(%rsi)
        movq	472(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 472(%rdi)
        adcq	$0, %r9
        # a[i+60] += m[60] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	480(%rsi)
        movq	480(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 480(%rdi)
        adcq	$0, %r10
        # a[i+61] += m[61] * mu
        movq	%r11, %rax
        xorq	%r9, %r9
        mulq	488(%rsi)
        movq	488(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r9
        addq	%r10, %r12
        movq	%r12, 488(%rdi)
        adcq	$0, %r9
        # a[i+62] += m[62] * mu
        movq	%r11, %rax
        xorq	%r10, %r10
        mulq	496(%rsi)
        movq	496(%rdi), %r12
        addq	%rax, %r12
        adcq	%rdx, %r10
        addq	%r9, %r12
        movq	%r12, 496(%rdi)
        adcq	$0, %r10
        # a[i+63] += m[63] * mu
        movq	%r11, %rax
        mulq	504(%rsi)
        movq	504(%rdi), %r12
        addq	%rax, %r10
        adcq	%r15, %rdx
        movq	$0, %r15
        adcq	$0, %r15
        addq	%r10, %r12
        movq	%r12, 504(%rdi)
        adcq	%rdx, 512(%rdi)
        adcq	$0, %r15
        # i -= 1
        addq	$8, %rdi
        decq	%r8
        jnz	L_mont_loop_64
        movq	%r13, (%rdi)
        movq	%r14, 8(%rdi)
        negq	%r15
        movq	%r15, %rcx
        movq	%rsi, %rdx
        movq	%rdi, %rsi
        subq	$512, %rdi
#ifndef __APPLE__
        callq	sp_4096_cond_sub_64@plt
#else
        callq	_sp_4096_cond_sub_64
#endif /* __APPLE__ */
        pop	%r15
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_4096_mont_reduce_64,.-sp_4096_mont_reduce_64
#endif /* __APPLE__ */
/* Conditionally subtract b from a using the mask m.
 * m is -1 to subtract and 0 when not copying.
 *
 * r  A single precision number representing condition subtract result.
 * a  A single precision number to subtract from.
 * b  A single precision number to subtract.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_4096_cond_sub_avx2_64
.type	sp_4096_cond_sub_avx2_64,@function
.align	16
sp_4096_cond_sub_avx2_64:
#else
.globl	_sp_4096_cond_sub_avx2_64
.p2align	4
_sp_4096_cond_sub_avx2_64:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        subq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        sbbq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        sbbq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        sbbq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        sbbq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        sbbq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        sbbq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        sbbq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        sbbq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        sbbq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        sbbq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        sbbq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        sbbq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        sbbq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        sbbq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        sbbq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        sbbq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        sbbq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        sbbq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        sbbq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        sbbq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        sbbq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        sbbq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        sbbq	%r8, %r10
        movq	192(%rdx), %r9
        movq	192(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 184(%rdi)
        sbbq	%r9, %r8
        movq	200(%rdx), %r10
        movq	200(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 192(%rdi)
        sbbq	%r10, %r9
        movq	208(%rdx), %r8
        movq	208(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 200(%rdi)
        sbbq	%r8, %r10
        movq	216(%rdx), %r9
        movq	216(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 208(%rdi)
        sbbq	%r9, %r8
        movq	224(%rdx), %r10
        movq	224(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 216(%rdi)
        sbbq	%r10, %r9
        movq	232(%rdx), %r8
        movq	232(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 224(%rdi)
        sbbq	%r8, %r10
        movq	240(%rdx), %r9
        movq	240(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 232(%rdi)
        sbbq	%r9, %r8
        movq	248(%rdx), %r10
        movq	248(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 240(%rdi)
        sbbq	%r10, %r9
        movq	256(%rdx), %r8
        movq	256(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 248(%rdi)
        sbbq	%r8, %r10
        movq	264(%rdx), %r9
        movq	264(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 256(%rdi)
        sbbq	%r9, %r8
        movq	272(%rdx), %r10
        movq	272(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 264(%rdi)
        sbbq	%r10, %r9
        movq	280(%rdx), %r8
        movq	280(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 272(%rdi)
        sbbq	%r8, %r10
        movq	288(%rdx), %r9
        movq	288(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 280(%rdi)
        sbbq	%r9, %r8
        movq	296(%rdx), %r10
        movq	296(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 288(%rdi)
        sbbq	%r10, %r9
        movq	304(%rdx), %r8
        movq	304(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 296(%rdi)
        sbbq	%r8, %r10
        movq	312(%rdx), %r9
        movq	312(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 304(%rdi)
        sbbq	%r9, %r8
        movq	320(%rdx), %r10
        movq	320(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 312(%rdi)
        sbbq	%r10, %r9
        movq	328(%rdx), %r8
        movq	328(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 320(%rdi)
        sbbq	%r8, %r10
        movq	336(%rdx), %r9
        movq	336(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 328(%rdi)
        sbbq	%r9, %r8
        movq	344(%rdx), %r10
        movq	344(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 336(%rdi)
        sbbq	%r10, %r9
        movq	352(%rdx), %r8
        movq	352(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 344(%rdi)
        sbbq	%r8, %r10
        movq	360(%rdx), %r9
        movq	360(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 352(%rdi)
        sbbq	%r9, %r8
        movq	368(%rdx), %r10
        movq	368(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 360(%rdi)
        sbbq	%r10, %r9
        movq	376(%rdx), %r8
        movq	376(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 368(%rdi)
        sbbq	%r8, %r10
        movq	384(%rdx), %r9
        movq	384(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 376(%rdi)
        sbbq	%r9, %r8
        movq	392(%rdx), %r10
        movq	392(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 384(%rdi)
        sbbq	%r10, %r9
        movq	400(%rdx), %r8
        movq	400(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 392(%rdi)
        sbbq	%r8, %r10
        movq	408(%rdx), %r9
        movq	408(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 400(%rdi)
        sbbq	%r9, %r8
        movq	416(%rdx), %r10
        movq	416(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 408(%rdi)
        sbbq	%r10, %r9
        movq	424(%rdx), %r8
        movq	424(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 416(%rdi)
        sbbq	%r8, %r10
        movq	432(%rdx), %r9
        movq	432(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 424(%rdi)
        sbbq	%r9, %r8
        movq	440(%rdx), %r10
        movq	440(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 432(%rdi)
        sbbq	%r10, %r9
        movq	448(%rdx), %r8
        movq	448(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 440(%rdi)
        sbbq	%r8, %r10
        movq	456(%rdx), %r9
        movq	456(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 448(%rdi)
        sbbq	%r9, %r8
        movq	464(%rdx), %r10
        movq	464(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 456(%rdi)
        sbbq	%r10, %r9
        movq	472(%rdx), %r8
        movq	472(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 464(%rdi)
        sbbq	%r8, %r10
        movq	480(%rdx), %r9
        movq	480(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 472(%rdi)
        sbbq	%r9, %r8
        movq	488(%rdx), %r10
        movq	488(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 480(%rdi)
        sbbq	%r10, %r9
        movq	496(%rdx), %r8
        movq	496(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 488(%rdi)
        sbbq	%r8, %r10
        movq	504(%rdx), %r9
        movq	504(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 496(%rdi)
        sbbq	%r9, %r8
        movq	%r8, 504(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_4096_cond_sub_avx2_64,.-sp_4096_cond_sub_avx2_64
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Mul a by digit b into r. (r = a * b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision digit.
 */
#ifndef __APPLE__
.globl	sp_4096_mul_d_avx2_64
.type	sp_4096_mul_d_avx2_64,@function
.align	16
sp_4096_mul_d_avx2_64:
#else
.globl	_sp_4096_mul_d_avx2_64
.p2align	4
_sp_4096_mul_d_avx2_64:
#endif /* __APPLE__ */
        movq	%rdx, %rax
        # A[0] * B
        movq	%rax, %rdx
        xorq	%r11, %r11
        mulxq	(%rsi), %r9, %r10
        movq	%r9, (%rdi)
        # A[1] * B
        mulxq	8(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 8(%rdi)
        adoxq	%r8, %r9
        # A[2] * B
        mulxq	16(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 16(%rdi)
        adoxq	%r8, %r10
        # A[3] * B
        mulxq	24(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 24(%rdi)
        adoxq	%r8, %r9
        # A[4] * B
        mulxq	32(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 32(%rdi)
        adoxq	%r8, %r10
        # A[5] * B
        mulxq	40(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 40(%rdi)
        adoxq	%r8, %r9
        # A[6] * B
        mulxq	48(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 48(%rdi)
        adoxq	%r8, %r10
        # A[7] * B
        mulxq	56(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 56(%rdi)
        adoxq	%r8, %r9
        # A[8] * B
        mulxq	64(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 64(%rdi)
        adoxq	%r8, %r10
        # A[9] * B
        mulxq	72(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 72(%rdi)
        adoxq	%r8, %r9
        # A[10] * B
        mulxq	80(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 80(%rdi)
        adoxq	%r8, %r10
        # A[11] * B
        mulxq	88(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 88(%rdi)
        adoxq	%r8, %r9
        # A[12] * B
        mulxq	96(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 96(%rdi)
        adoxq	%r8, %r10
        # A[13] * B
        mulxq	104(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 104(%rdi)
        adoxq	%r8, %r9
        # A[14] * B
        mulxq	112(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 112(%rdi)
        adoxq	%r8, %r10
        # A[15] * B
        mulxq	120(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 120(%rdi)
        adoxq	%r8, %r9
        # A[16] * B
        mulxq	128(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 128(%rdi)
        adoxq	%r8, %r10
        # A[17] * B
        mulxq	136(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 136(%rdi)
        adoxq	%r8, %r9
        # A[18] * B
        mulxq	144(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 144(%rdi)
        adoxq	%r8, %r10
        # A[19] * B
        mulxq	152(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 152(%rdi)
        adoxq	%r8, %r9
        # A[20] * B
        mulxq	160(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 160(%rdi)
        adoxq	%r8, %r10
        # A[21] * B
        mulxq	168(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 168(%rdi)
        adoxq	%r8, %r9
        # A[22] * B
        mulxq	176(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 176(%rdi)
        adoxq	%r8, %r10
        # A[23] * B
        mulxq	184(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 184(%rdi)
        adoxq	%r8, %r9
        # A[24] * B
        mulxq	192(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 192(%rdi)
        adoxq	%r8, %r10
        # A[25] * B
        mulxq	200(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 200(%rdi)
        adoxq	%r8, %r9
        # A[26] * B
        mulxq	208(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 208(%rdi)
        adoxq	%r8, %r10
        # A[27] * B
        mulxq	216(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 216(%rdi)
        adoxq	%r8, %r9
        # A[28] * B
        mulxq	224(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 224(%rdi)
        adoxq	%r8, %r10
        # A[29] * B
        mulxq	232(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 232(%rdi)
        adoxq	%r8, %r9
        # A[30] * B
        mulxq	240(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 240(%rdi)
        adoxq	%r8, %r10
        # A[31] * B
        mulxq	248(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 248(%rdi)
        adoxq	%r8, %r9
        # A[32] * B
        mulxq	256(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 256(%rdi)
        adoxq	%r8, %r10
        # A[33] * B
        mulxq	264(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 264(%rdi)
        adoxq	%r8, %r9
        # A[34] * B
        mulxq	272(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 272(%rdi)
        adoxq	%r8, %r10
        # A[35] * B
        mulxq	280(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 280(%rdi)
        adoxq	%r8, %r9
        # A[36] * B
        mulxq	288(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 288(%rdi)
        adoxq	%r8, %r10
        # A[37] * B
        mulxq	296(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 296(%rdi)
        adoxq	%r8, %r9
        # A[38] * B
        mulxq	304(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 304(%rdi)
        adoxq	%r8, %r10
        # A[39] * B
        mulxq	312(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 312(%rdi)
        adoxq	%r8, %r9
        # A[40] * B
        mulxq	320(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 320(%rdi)
        adoxq	%r8, %r10
        # A[41] * B
        mulxq	328(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 328(%rdi)
        adoxq	%r8, %r9
        # A[42] * B
        mulxq	336(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 336(%rdi)
        adoxq	%r8, %r10
        # A[43] * B
        mulxq	344(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 344(%rdi)
        adoxq	%r8, %r9
        # A[44] * B
        mulxq	352(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 352(%rdi)
        adoxq	%r8, %r10
        # A[45] * B
        mulxq	360(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 360(%rdi)
        adoxq	%r8, %r9
        # A[46] * B
        mulxq	368(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 368(%rdi)
        adoxq	%r8, %r10
        # A[47] * B
        mulxq	376(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 376(%rdi)
        adoxq	%r8, %r9
        # A[48] * B
        mulxq	384(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 384(%rdi)
        adoxq	%r8, %r10
        # A[49] * B
        mulxq	392(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 392(%rdi)
        adoxq	%r8, %r9
        # A[50] * B
        mulxq	400(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 400(%rdi)
        adoxq	%r8, %r10
        # A[51] * B
        mulxq	408(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 408(%rdi)
        adoxq	%r8, %r9
        # A[52] * B
        mulxq	416(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 416(%rdi)
        adoxq	%r8, %r10
        # A[53] * B
        mulxq	424(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 424(%rdi)
        adoxq	%r8, %r9
        # A[54] * B
        mulxq	432(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 432(%rdi)
        adoxq	%r8, %r10
        # A[55] * B
        mulxq	440(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 440(%rdi)
        adoxq	%r8, %r9
        # A[56] * B
        mulxq	448(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 448(%rdi)
        adoxq	%r8, %r10
        # A[57] * B
        mulxq	456(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 456(%rdi)
        adoxq	%r8, %r9
        # A[58] * B
        mulxq	464(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 464(%rdi)
        adoxq	%r8, %r10
        # A[59] * B
        mulxq	472(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 472(%rdi)
        adoxq	%r8, %r9
        # A[60] * B
        mulxq	480(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 480(%rdi)
        adoxq	%r8, %r10
        # A[61] * B
        mulxq	488(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        movq	%r10, 488(%rdi)
        adoxq	%r8, %r9
        # A[62] * B
        mulxq	496(%rsi), %rcx, %r8
        movq	%r11, %r10
        adcxq	%rcx, %r9
        movq	%r9, 496(%rdi)
        adoxq	%r8, %r10
        # A[63] * B
        mulxq	504(%rsi), %rcx, %r8
        movq	%r11, %r9
        adcxq	%rcx, %r10
        adoxq	%r8, %r9
        adcxq	%r11, %r9
        movq	%r10, 504(%rdi)
        movq	%r9, 512(%rdi)
        repz retq
#ifndef __APPLE__
.size	sp_4096_mul_d_avx2_64,.-sp_4096_mul_d_avx2_64
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Compare a with b in constant time.
 *
 * a  A single precision integer.
 * b  A single precision integer.
 * return -ve, 0 or +ve if a is less than, equal to or greater than b
 * respectively.
 */
#ifndef __APPLE__
.globl	sp_4096_cmp_64
.type	sp_4096_cmp_64,@function
.align	16
sp_4096_cmp_64:
#else
.globl	_sp_4096_cmp_64
.p2align	4
_sp_4096_cmp_64:
#endif /* __APPLE__ */
        xorq	%rcx, %rcx
        movq	$-1, %rdx
        movq	$-1, %rax
        movq	$1, %r8
        movq	504(%rdi), %r9
        movq	504(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	496(%rdi), %r9
        movq	496(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	488(%rdi), %r9
        movq	488(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	480(%rdi), %r9
        movq	480(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	472(%rdi), %r9
        movq	472(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	464(%rdi), %r9
        movq	464(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	456(%rdi), %r9
        movq	456(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	448(%rdi), %r9
        movq	448(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	440(%rdi), %r9
        movq	440(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	432(%rdi), %r9
        movq	432(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	424(%rdi), %r9
        movq	424(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	416(%rdi), %r9
        movq	416(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	408(%rdi), %r9
        movq	408(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	400(%rdi), %r9
        movq	400(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	392(%rdi), %r9
        movq	392(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	384(%rdi), %r9
        movq	384(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	376(%rdi), %r9
        movq	376(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	368(%rdi), %r9
        movq	368(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	360(%rdi), %r9
        movq	360(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	352(%rdi), %r9
        movq	352(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	344(%rdi), %r9
        movq	344(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	336(%rdi), %r9
        movq	336(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	328(%rdi), %r9
        movq	328(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	320(%rdi), %r9
        movq	320(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	312(%rdi), %r9
        movq	312(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	304(%rdi), %r9
        movq	304(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	296(%rdi), %r9
        movq	296(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	288(%rdi), %r9
        movq	288(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	280(%rdi), %r9
        movq	280(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	272(%rdi), %r9
        movq	272(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	264(%rdi), %r9
        movq	264(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	256(%rdi), %r9
        movq	256(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	248(%rdi), %r9
        movq	248(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	240(%rdi), %r9
        movq	240(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	232(%rdi), %r9
        movq	232(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	224(%rdi), %r9
        movq	224(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	216(%rdi), %r9
        movq	216(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	208(%rdi), %r9
        movq	208(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	200(%rdi), %r9
        movq	200(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	192(%rdi), %r9
        movq	192(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	184(%rdi), %r9
        movq	184(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	176(%rdi), %r9
        movq	176(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	168(%rdi), %r9
        movq	168(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	160(%rdi), %r9
        movq	160(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	152(%rdi), %r9
        movq	152(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	144(%rdi), %r9
        movq	144(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	136(%rdi), %r9
        movq	136(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	128(%rdi), %r9
        movq	128(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	120(%rdi), %r9
        movq	120(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	112(%rdi), %r9
        movq	112(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	104(%rdi), %r9
        movq	104(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	96(%rdi), %r9
        movq	96(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	88(%rdi), %r9
        movq	88(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	80(%rdi), %r9
        movq	80(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	72(%rdi), %r9
        movq	72(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	64(%rdi), %r9
        movq	64(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	56(%rdi), %r9
        movq	56(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	48(%rdi), %r9
        movq	48(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	40(%rdi), %r9
        movq	40(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	32(%rdi), %r9
        movq	32(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	24(%rdi), %r9
        movq	24(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	16(%rdi), %r9
        movq	16(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	8(%rdi), %r9
        movq	8(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        movq	(%rdi), %r9
        movq	(%rsi), %r10
        andq	%rdx, %r9
        andq	%rdx, %r10
        subq	%r10, %r9
        cmova	%r8, %rax
        cmovc	%rdx, %rax
        cmovnz	%rcx, %rdx
        xorq	%rdx, %rax
        repz retq
#ifndef __APPLE__
.size	sp_4096_cmp_64,.-sp_4096_cmp_64
#endif /* __APPLE__ */
/* Sub b from a into r. (r = a - b)
 *
 * r  A single precision integer.
 * a  A single precision integer.
 * b  A single precision integer.
 */
#ifndef __APPLE__
.globl	sp_4096_sub_64
.type	sp_4096_sub_64,@function
.align	16
sp_4096_sub_64:
#else
.globl	_sp_4096_sub_64
.p2align	4
_sp_4096_sub_64:
#endif /* __APPLE__ */
        movq	(%rsi), %rcx
        xorq	%rax, %rax
        subq	(%rdx), %rcx
        movq	8(%rsi), %r8
        movq	%rcx, (%rdi)
        sbbq	8(%rdx), %r8
        movq	16(%rsi), %rcx
        movq	%r8, 8(%rdi)
        sbbq	16(%rdx), %rcx
        movq	24(%rsi), %r8
        movq	%rcx, 16(%rdi)
        sbbq	24(%rdx), %r8
        movq	32(%rsi), %rcx
        movq	%r8, 24(%rdi)
        sbbq	32(%rdx), %rcx
        movq	40(%rsi), %r8
        movq	%rcx, 32(%rdi)
        sbbq	40(%rdx), %r8
        movq	48(%rsi), %rcx
        movq	%r8, 40(%rdi)
        sbbq	48(%rdx), %rcx
        movq	56(%rsi), %r8
        movq	%rcx, 48(%rdi)
        sbbq	56(%rdx), %r8
        movq	64(%rsi), %rcx
        movq	%r8, 56(%rdi)
        sbbq	64(%rdx), %rcx
        movq	72(%rsi), %r8
        movq	%rcx, 64(%rdi)
        sbbq	72(%rdx), %r8
        movq	80(%rsi), %rcx
        movq	%r8, 72(%rdi)
        sbbq	80(%rdx), %rcx
        movq	88(%rsi), %r8
        movq	%rcx, 80(%rdi)
        sbbq	88(%rdx), %r8
        movq	96(%rsi), %rcx
        movq	%r8, 88(%rdi)
        sbbq	96(%rdx), %rcx
        movq	104(%rsi), %r8
        movq	%rcx, 96(%rdi)
        sbbq	104(%rdx), %r8
        movq	112(%rsi), %rcx
        movq	%r8, 104(%rdi)
        sbbq	112(%rdx), %rcx
        movq	120(%rsi), %r8
        movq	%rcx, 112(%rdi)
        sbbq	120(%rdx), %r8
        movq	128(%rsi), %rcx
        movq	%r8, 120(%rdi)
        sbbq	128(%rdx), %rcx
        movq	136(%rsi), %r8
        movq	%rcx, 128(%rdi)
        sbbq	136(%rdx), %r8
        movq	144(%rsi), %rcx
        movq	%r8, 136(%rdi)
        sbbq	144(%rdx), %rcx
        movq	152(%rsi), %r8
        movq	%rcx, 144(%rdi)
        sbbq	152(%rdx), %r8
        movq	160(%rsi), %rcx
        movq	%r8, 152(%rdi)
        sbbq	160(%rdx), %rcx
        movq	168(%rsi), %r8
        movq	%rcx, 160(%rdi)
        sbbq	168(%rdx), %r8
        movq	176(%rsi), %rcx
        movq	%r8, 168(%rdi)
        sbbq	176(%rdx), %rcx
        movq	184(%rsi), %r8
        movq	%rcx, 176(%rdi)
        sbbq	184(%rdx), %r8
        movq	192(%rsi), %rcx
        movq	%r8, 184(%rdi)
        sbbq	192(%rdx), %rcx
        movq	200(%rsi), %r8
        movq	%rcx, 192(%rdi)
        sbbq	200(%rdx), %r8
        movq	208(%rsi), %rcx
        movq	%r8, 200(%rdi)
        sbbq	208(%rdx), %rcx
        movq	216(%rsi), %r8
        movq	%rcx, 208(%rdi)
        sbbq	216(%rdx), %r8
        movq	224(%rsi), %rcx
        movq	%r8, 216(%rdi)
        sbbq	224(%rdx), %rcx
        movq	232(%rsi), %r8
        movq	%rcx, 224(%rdi)
        sbbq	232(%rdx), %r8
        movq	240(%rsi), %rcx
        movq	%r8, 232(%rdi)
        sbbq	240(%rdx), %rcx
        movq	248(%rsi), %r8
        movq	%rcx, 240(%rdi)
        sbbq	248(%rdx), %r8
        movq	256(%rsi), %rcx
        movq	%r8, 248(%rdi)
        sbbq	256(%rdx), %rcx
        movq	264(%rsi), %r8
        movq	%rcx, 256(%rdi)
        sbbq	264(%rdx), %r8
        movq	272(%rsi), %rcx
        movq	%r8, 264(%rdi)
        sbbq	272(%rdx), %rcx
        movq	280(%rsi), %r8
        movq	%rcx, 272(%rdi)
        sbbq	280(%rdx), %r8
        movq	288(%rsi), %rcx
        movq	%r8, 280(%rdi)
        sbbq	288(%rdx), %rcx
        movq	296(%rsi), %r8
        movq	%rcx, 288(%rdi)
        sbbq	296(%rdx), %r8
        movq	304(%rsi), %rcx
        movq	%r8, 296(%rdi)
        sbbq	304(%rdx), %rcx
        movq	312(%rsi), %r8
        movq	%rcx, 304(%rdi)
        sbbq	312(%rdx), %r8
        movq	320(%rsi), %rcx
        movq	%r8, 312(%rdi)
        sbbq	320(%rdx), %rcx
        movq	328(%rsi), %r8
        movq	%rcx, 320(%rdi)
        sbbq	328(%rdx), %r8
        movq	336(%rsi), %rcx
        movq	%r8, 328(%rdi)
        sbbq	336(%rdx), %rcx
        movq	344(%rsi), %r8
        movq	%rcx, 336(%rdi)
        sbbq	344(%rdx), %r8
        movq	352(%rsi), %rcx
        movq	%r8, 344(%rdi)
        sbbq	352(%rdx), %rcx
        movq	360(%rsi), %r8
        movq	%rcx, 352(%rdi)
        sbbq	360(%rdx), %r8
        movq	368(%rsi), %rcx
        movq	%r8, 360(%rdi)
        sbbq	368(%rdx), %rcx
        movq	376(%rsi), %r8
        movq	%rcx, 368(%rdi)
        sbbq	376(%rdx), %r8
        movq	384(%rsi), %rcx
        movq	%r8, 376(%rdi)
        sbbq	384(%rdx), %rcx
        movq	392(%rsi), %r8
        movq	%rcx, 384(%rdi)
        sbbq	392(%rdx), %r8
        movq	400(%rsi), %rcx
        movq	%r8, 392(%rdi)
        sbbq	400(%rdx), %rcx
        movq	408(%rsi), %r8
        movq	%rcx, 400(%rdi)
        sbbq	408(%rdx), %r8
        movq	416(%rsi), %rcx
        movq	%r8, 408(%rdi)
        sbbq	416(%rdx), %rcx
        movq	424(%rsi), %r8
        movq	%rcx, 416(%rdi)
        sbbq	424(%rdx), %r8
        movq	432(%rsi), %rcx
        movq	%r8, 424(%rdi)
        sbbq	432(%rdx), %rcx
        movq	440(%rsi), %r8
        movq	%rcx, 432(%rdi)
        sbbq	440(%rdx), %r8
        movq	448(%rsi), %rcx
        movq	%r8, 440(%rdi)
        sbbq	448(%rdx), %rcx
        movq	456(%rsi), %r8
        movq	%rcx, 448(%rdi)
        sbbq	456(%rdx), %r8
        movq	464(%rsi), %rcx
        movq	%r8, 456(%rdi)
        sbbq	464(%rdx), %rcx
        movq	472(%rsi), %r8
        movq	%rcx, 464(%rdi)
        sbbq	472(%rdx), %r8
        movq	480(%rsi), %rcx
        movq	%r8, 472(%rdi)
        sbbq	480(%rdx), %rcx
        movq	488(%rsi), %r8
        movq	%rcx, 480(%rdi)
        sbbq	488(%rdx), %r8
        movq	496(%rsi), %rcx
        movq	%r8, 488(%rdi)
        sbbq	496(%rdx), %rcx
        movq	504(%rsi), %r8
        movq	%rcx, 496(%rdi)
        sbbq	504(%rdx), %r8
        movq	%r8, 504(%rdi)
        sbbq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_4096_sub_64,.-sp_4096_sub_64
#endif /* __APPLE__ */
#ifdef HAVE_INTEL_AVX2
/* Reduce the number back to 4096 bits using Montgomery reduction.
 *
 * a   A single precision number to reduce in place.
 * m   The single precision number representing the modulus.
 * mp  The digit representing the negative inverse of m mod 2^n.
 */
#ifndef __APPLE__
.globl	sp_4096_mont_reduce_avx2_64
.type	sp_4096_mont_reduce_avx2_64,@function
.align	16
sp_4096_mont_reduce_avx2_64:
#else
.globl	_sp_4096_mont_reduce_avx2_64
.p2align	4
_sp_4096_mont_reduce_avx2_64:
#endif /* __APPLE__ */
        push	%r12
        push	%r13
        push	%r14
        movq	%rdx, %r8
        xorq	%r14, %r14
        # i = 64
        movq	$64, %r9
        movq	(%rdi), %r13
        addq	$256, %rdi
        xorq	%r12, %r12
L_mont_loop_avx2_64:
        # mu = a[i] * mp
        movq	%r13, %rdx
        movq	%r13, %r10
        imulq	%r8, %rdx
        xorq	%r12, %r12
        # a[i+0] += m[0] * mu
        mulxq	(%rsi), %rax, %rcx
        movq	-248(%rdi), %r13
        adcxq	%rax, %r10
        adoxq	%rcx, %r13
        # a[i+1] += m[1] * mu
        mulxq	8(%rsi), %rax, %rcx
        movq	-240(%rdi), %r10
        adcxq	%rax, %r13
        adoxq	%rcx, %r10
        # a[i+2] += m[2] * mu
        mulxq	16(%rsi), %rax, %rcx
        movq	-232(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -240(%rdi)
        # a[i+3] += m[3] * mu
        mulxq	24(%rsi), %rax, %rcx
        movq	-224(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -232(%rdi)
        # a[i+4] += m[4] * mu
        mulxq	32(%rsi), %rax, %rcx
        movq	-216(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -224(%rdi)
        # a[i+5] += m[5] * mu
        mulxq	40(%rsi), %rax, %rcx
        movq	-208(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -216(%rdi)
        # a[i+6] += m[6] * mu
        mulxq	48(%rsi), %rax, %rcx
        movq	-200(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -208(%rdi)
        # a[i+7] += m[7] * mu
        mulxq	56(%rsi), %rax, %rcx
        movq	-192(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -200(%rdi)
        # a[i+8] += m[8] * mu
        mulxq	64(%rsi), %rax, %rcx
        movq	-184(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -192(%rdi)
        # a[i+9] += m[9] * mu
        mulxq	72(%rsi), %rax, %rcx
        movq	-176(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -184(%rdi)
        # a[i+10] += m[10] * mu
        mulxq	80(%rsi), %rax, %rcx
        movq	-168(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -176(%rdi)
        # a[i+11] += m[11] * mu
        mulxq	88(%rsi), %rax, %rcx
        movq	-160(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -168(%rdi)
        # a[i+12] += m[12] * mu
        mulxq	96(%rsi), %rax, %rcx
        movq	-152(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -160(%rdi)
        # a[i+13] += m[13] * mu
        mulxq	104(%rsi), %rax, %rcx
        movq	-144(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -152(%rdi)
        # a[i+14] += m[14] * mu
        mulxq	112(%rsi), %rax, %rcx
        movq	-136(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -144(%rdi)
        # a[i+15] += m[15] * mu
        mulxq	120(%rsi), %rax, %rcx
        movq	-128(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -136(%rdi)
        # a[i+16] += m[16] * mu
        mulxq	128(%rsi), %rax, %rcx
        movq	-120(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -128(%rdi)
        # a[i+17] += m[17] * mu
        mulxq	136(%rsi), %rax, %rcx
        movq	-112(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -120(%rdi)
        # a[i+18] += m[18] * mu
        mulxq	144(%rsi), %rax, %rcx
        movq	-104(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -112(%rdi)
        # a[i+19] += m[19] * mu
        mulxq	152(%rsi), %rax, %rcx
        movq	-96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -104(%rdi)
        # a[i+20] += m[20] * mu
        mulxq	160(%rsi), %rax, %rcx
        movq	-88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -96(%rdi)
        # a[i+21] += m[21] * mu
        mulxq	168(%rsi), %rax, %rcx
        movq	-80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -88(%rdi)
        # a[i+22] += m[22] * mu
        mulxq	176(%rsi), %rax, %rcx
        movq	-72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -80(%rdi)
        # a[i+23] += m[23] * mu
        mulxq	184(%rsi), %rax, %rcx
        movq	-64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -72(%rdi)
        # a[i+24] += m[24] * mu
        mulxq	192(%rsi), %rax, %rcx
        movq	-56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -64(%rdi)
        # a[i+25] += m[25] * mu
        mulxq	200(%rsi), %rax, %rcx
        movq	-48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -56(%rdi)
        # a[i+26] += m[26] * mu
        mulxq	208(%rsi), %rax, %rcx
        movq	-40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -48(%rdi)
        # a[i+27] += m[27] * mu
        mulxq	216(%rsi), %rax, %rcx
        movq	-32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -40(%rdi)
        # a[i+28] += m[28] * mu
        mulxq	224(%rsi), %rax, %rcx
        movq	-24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -32(%rdi)
        # a[i+29] += m[29] * mu
        mulxq	232(%rsi), %rax, %rcx
        movq	-16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -24(%rdi)
        # a[i+30] += m[30] * mu
        mulxq	240(%rsi), %rax, %rcx
        movq	-8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, -16(%rdi)
        # a[i+31] += m[31] * mu
        mulxq	248(%rsi), %rax, %rcx
        movq	(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, -8(%rdi)
        # a[i+32] += m[32] * mu
        mulxq	256(%rsi), %rax, %rcx
        movq	8(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, (%rdi)
        # a[i+33] += m[33] * mu
        mulxq	264(%rsi), %rax, %rcx
        movq	16(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 8(%rdi)
        # a[i+34] += m[34] * mu
        mulxq	272(%rsi), %rax, %rcx
        movq	24(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 16(%rdi)
        # a[i+35] += m[35] * mu
        mulxq	280(%rsi), %rax, %rcx
        movq	32(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 24(%rdi)
        # a[i+36] += m[36] * mu
        mulxq	288(%rsi), %rax, %rcx
        movq	40(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 32(%rdi)
        # a[i+37] += m[37] * mu
        mulxq	296(%rsi), %rax, %rcx
        movq	48(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 40(%rdi)
        # a[i+38] += m[38] * mu
        mulxq	304(%rsi), %rax, %rcx
        movq	56(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 48(%rdi)
        # a[i+39] += m[39] * mu
        mulxq	312(%rsi), %rax, %rcx
        movq	64(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 56(%rdi)
        # a[i+40] += m[40] * mu
        mulxq	320(%rsi), %rax, %rcx
        movq	72(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 64(%rdi)
        # a[i+41] += m[41] * mu
        mulxq	328(%rsi), %rax, %rcx
        movq	80(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 72(%rdi)
        # a[i+42] += m[42] * mu
        mulxq	336(%rsi), %rax, %rcx
        movq	88(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 80(%rdi)
        # a[i+43] += m[43] * mu
        mulxq	344(%rsi), %rax, %rcx
        movq	96(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 88(%rdi)
        # a[i+44] += m[44] * mu
        mulxq	352(%rsi), %rax, %rcx
        movq	104(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 96(%rdi)
        # a[i+45] += m[45] * mu
        mulxq	360(%rsi), %rax, %rcx
        movq	112(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 104(%rdi)
        # a[i+46] += m[46] * mu
        mulxq	368(%rsi), %rax, %rcx
        movq	120(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 112(%rdi)
        # a[i+47] += m[47] * mu
        mulxq	376(%rsi), %rax, %rcx
        movq	128(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 120(%rdi)
        # a[i+48] += m[48] * mu
        mulxq	384(%rsi), %rax, %rcx
        movq	136(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 128(%rdi)
        # a[i+49] += m[49] * mu
        mulxq	392(%rsi), %rax, %rcx
        movq	144(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 136(%rdi)
        # a[i+50] += m[50] * mu
        mulxq	400(%rsi), %rax, %rcx
        movq	152(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 144(%rdi)
        # a[i+51] += m[51] * mu
        mulxq	408(%rsi), %rax, %rcx
        movq	160(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 152(%rdi)
        # a[i+52] += m[52] * mu
        mulxq	416(%rsi), %rax, %rcx
        movq	168(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 160(%rdi)
        # a[i+53] += m[53] * mu
        mulxq	424(%rsi), %rax, %rcx
        movq	176(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 168(%rdi)
        # a[i+54] += m[54] * mu
        mulxq	432(%rsi), %rax, %rcx
        movq	184(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 176(%rdi)
        # a[i+55] += m[55] * mu
        mulxq	440(%rsi), %rax, %rcx
        movq	192(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 184(%rdi)
        # a[i+56] += m[56] * mu
        mulxq	448(%rsi), %rax, %rcx
        movq	200(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 192(%rdi)
        # a[i+57] += m[57] * mu
        mulxq	456(%rsi), %rax, %rcx
        movq	208(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 200(%rdi)
        # a[i+58] += m[58] * mu
        mulxq	464(%rsi), %rax, %rcx
        movq	216(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 208(%rdi)
        # a[i+59] += m[59] * mu
        mulxq	472(%rsi), %rax, %rcx
        movq	224(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 216(%rdi)
        # a[i+60] += m[60] * mu
        mulxq	480(%rsi), %rax, %rcx
        movq	232(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 224(%rdi)
        # a[i+61] += m[61] * mu
        mulxq	488(%rsi), %rax, %rcx
        movq	240(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 232(%rdi)
        # a[i+62] += m[62] * mu
        mulxq	496(%rsi), %rax, %rcx
        movq	248(%rdi), %r11
        adcxq	%rax, %r10
        adoxq	%rcx, %r11
        movq	%r10, 240(%rdi)
        # a[i+63] += m[63] * mu
        mulxq	504(%rsi), %rax, %rcx
        movq	256(%rdi), %r10
        adcxq	%rax, %r11
        adoxq	%rcx, %r10
        movq	%r11, 248(%rdi)
        adcxq	%r14, %r10
        movq	%r10, 256(%rdi)
        movq	%r12, %r14
        adoxq	%r12, %r14
        adcxq	%r12, %r14
        # a += 1
        addq	$8, %rdi
        # i -= 1
        subq	$1, %r9
        jnz	L_mont_loop_avx2_64
        subq	$256, %rdi
        negq	%r14
        movq	%rdi, %r8
        subq	$512, %rdi
        movq	(%rsi), %rcx
        movq	%r13, %rdx
        pextq	%r14, %rcx, %rcx
        subq	%rcx, %rdx
        movq	8(%rsi), %rcx
        movq	8(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, (%rdi)
        sbbq	%rcx, %rax
        movq	16(%rsi), %rdx
        movq	16(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 8(%rdi)
        sbbq	%rdx, %rcx
        movq	24(%rsi), %rax
        movq	24(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 16(%rdi)
        sbbq	%rax, %rdx
        movq	32(%rsi), %rcx
        movq	32(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 24(%rdi)
        sbbq	%rcx, %rax
        movq	40(%rsi), %rdx
        movq	40(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 32(%rdi)
        sbbq	%rdx, %rcx
        movq	48(%rsi), %rax
        movq	48(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 40(%rdi)
        sbbq	%rax, %rdx
        movq	56(%rsi), %rcx
        movq	56(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 48(%rdi)
        sbbq	%rcx, %rax
        movq	64(%rsi), %rdx
        movq	64(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 56(%rdi)
        sbbq	%rdx, %rcx
        movq	72(%rsi), %rax
        movq	72(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 64(%rdi)
        sbbq	%rax, %rdx
        movq	80(%rsi), %rcx
        movq	80(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 72(%rdi)
        sbbq	%rcx, %rax
        movq	88(%rsi), %rdx
        movq	88(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 80(%rdi)
        sbbq	%rdx, %rcx
        movq	96(%rsi), %rax
        movq	96(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 88(%rdi)
        sbbq	%rax, %rdx
        movq	104(%rsi), %rcx
        movq	104(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 96(%rdi)
        sbbq	%rcx, %rax
        movq	112(%rsi), %rdx
        movq	112(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 104(%rdi)
        sbbq	%rdx, %rcx
        movq	120(%rsi), %rax
        movq	120(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 112(%rdi)
        sbbq	%rax, %rdx
        movq	128(%rsi), %rcx
        movq	128(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 120(%rdi)
        sbbq	%rcx, %rax
        movq	136(%rsi), %rdx
        movq	136(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 128(%rdi)
        sbbq	%rdx, %rcx
        movq	144(%rsi), %rax
        movq	144(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 136(%rdi)
        sbbq	%rax, %rdx
        movq	152(%rsi), %rcx
        movq	152(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 144(%rdi)
        sbbq	%rcx, %rax
        movq	160(%rsi), %rdx
        movq	160(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 152(%rdi)
        sbbq	%rdx, %rcx
        movq	168(%rsi), %rax
        movq	168(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 160(%rdi)
        sbbq	%rax, %rdx
        movq	176(%rsi), %rcx
        movq	176(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 168(%rdi)
        sbbq	%rcx, %rax
        movq	184(%rsi), %rdx
        movq	184(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 176(%rdi)
        sbbq	%rdx, %rcx
        movq	192(%rsi), %rax
        movq	192(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 184(%rdi)
        sbbq	%rax, %rdx
        movq	200(%rsi), %rcx
        movq	200(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 192(%rdi)
        sbbq	%rcx, %rax
        movq	208(%rsi), %rdx
        movq	208(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 200(%rdi)
        sbbq	%rdx, %rcx
        movq	216(%rsi), %rax
        movq	216(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 208(%rdi)
        sbbq	%rax, %rdx
        movq	224(%rsi), %rcx
        movq	224(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 216(%rdi)
        sbbq	%rcx, %rax
        movq	232(%rsi), %rdx
        movq	232(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 224(%rdi)
        sbbq	%rdx, %rcx
        movq	240(%rsi), %rax
        movq	240(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 232(%rdi)
        sbbq	%rax, %rdx
        movq	248(%rsi), %rcx
        movq	248(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 240(%rdi)
        sbbq	%rcx, %rax
        movq	256(%rsi), %rdx
        movq	256(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 248(%rdi)
        sbbq	%rdx, %rcx
        movq	264(%rsi), %rax
        movq	264(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 256(%rdi)
        sbbq	%rax, %rdx
        movq	272(%rsi), %rcx
        movq	272(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 264(%rdi)
        sbbq	%rcx, %rax
        movq	280(%rsi), %rdx
        movq	280(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 272(%rdi)
        sbbq	%rdx, %rcx
        movq	288(%rsi), %rax
        movq	288(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 280(%rdi)
        sbbq	%rax, %rdx
        movq	296(%rsi), %rcx
        movq	296(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 288(%rdi)
        sbbq	%rcx, %rax
        movq	304(%rsi), %rdx
        movq	304(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 296(%rdi)
        sbbq	%rdx, %rcx
        movq	312(%rsi), %rax
        movq	312(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 304(%rdi)
        sbbq	%rax, %rdx
        movq	320(%rsi), %rcx
        movq	320(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 312(%rdi)
        sbbq	%rcx, %rax
        movq	328(%rsi), %rdx
        movq	328(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 320(%rdi)
        sbbq	%rdx, %rcx
        movq	336(%rsi), %rax
        movq	336(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 328(%rdi)
        sbbq	%rax, %rdx
        movq	344(%rsi), %rcx
        movq	344(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 336(%rdi)
        sbbq	%rcx, %rax
        movq	352(%rsi), %rdx
        movq	352(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 344(%rdi)
        sbbq	%rdx, %rcx
        movq	360(%rsi), %rax
        movq	360(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 352(%rdi)
        sbbq	%rax, %rdx
        movq	368(%rsi), %rcx
        movq	368(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 360(%rdi)
        sbbq	%rcx, %rax
        movq	376(%rsi), %rdx
        movq	376(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 368(%rdi)
        sbbq	%rdx, %rcx
        movq	384(%rsi), %rax
        movq	384(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 376(%rdi)
        sbbq	%rax, %rdx
        movq	392(%rsi), %rcx
        movq	392(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 384(%rdi)
        sbbq	%rcx, %rax
        movq	400(%rsi), %rdx
        movq	400(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 392(%rdi)
        sbbq	%rdx, %rcx
        movq	408(%rsi), %rax
        movq	408(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 400(%rdi)
        sbbq	%rax, %rdx
        movq	416(%rsi), %rcx
        movq	416(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 408(%rdi)
        sbbq	%rcx, %rax
        movq	424(%rsi), %rdx
        movq	424(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 416(%rdi)
        sbbq	%rdx, %rcx
        movq	432(%rsi), %rax
        movq	432(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 424(%rdi)
        sbbq	%rax, %rdx
        movq	440(%rsi), %rcx
        movq	440(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 432(%rdi)
        sbbq	%rcx, %rax
        movq	448(%rsi), %rdx
        movq	448(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 440(%rdi)
        sbbq	%rdx, %rcx
        movq	456(%rsi), %rax
        movq	456(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 448(%rdi)
        sbbq	%rax, %rdx
        movq	464(%rsi), %rcx
        movq	464(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 456(%rdi)
        sbbq	%rcx, %rax
        movq	472(%rsi), %rdx
        movq	472(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 464(%rdi)
        sbbq	%rdx, %rcx
        movq	480(%rsi), %rax
        movq	480(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 472(%rdi)
        sbbq	%rax, %rdx
        movq	488(%rsi), %rcx
        movq	488(%r8), %rax
        pextq	%r14, %rcx, %rcx
        movq	%rdx, 480(%rdi)
        sbbq	%rcx, %rax
        movq	496(%rsi), %rdx
        movq	496(%r8), %rcx
        pextq	%r14, %rdx, %rdx
        movq	%rax, 488(%rdi)
        sbbq	%rdx, %rcx
        movq	504(%rsi), %rax
        movq	504(%r8), %rdx
        pextq	%r14, %rax, %rax
        movq	%rcx, 496(%rdi)
        sbbq	%rax, %rdx
        movq	%rdx, 504(%rdi)
        pop	%r14
        pop	%r13
        pop	%r12
        repz retq
#ifndef __APPLE__
.size	sp_4096_mont_reduce_avx2_64,.-sp_4096_mont_reduce_avx2_64
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_4096_cond_add_32
.type	sp_4096_cond_add_32,@function
.align	16
sp_4096_cond_add_32:
#else
.globl	_sp_4096_cond_add_32
.p2align	4
_sp_4096_cond_add_32:
#endif /* __APPLE__ */
        subq	$256, %rsp
        movq	$0, %rax
        movq	(%rdx), %r8
        movq	8(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, (%rsp)
        movq	%r9, 8(%rsp)
        movq	16(%rdx), %r8
        movq	24(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 16(%rsp)
        movq	%r9, 24(%rsp)
        movq	32(%rdx), %r8
        movq	40(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 32(%rsp)
        movq	%r9, 40(%rsp)
        movq	48(%rdx), %r8
        movq	56(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 48(%rsp)
        movq	%r9, 56(%rsp)
        movq	64(%rdx), %r8
        movq	72(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 64(%rsp)
        movq	%r9, 72(%rsp)
        movq	80(%rdx), %r8
        movq	88(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 80(%rsp)
        movq	%r9, 88(%rsp)
        movq	96(%rdx), %r8
        movq	104(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 96(%rsp)
        movq	%r9, 104(%rsp)
        movq	112(%rdx), %r8
        movq	120(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 112(%rsp)
        movq	%r9, 120(%rsp)
        movq	128(%rdx), %r8
        movq	136(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 128(%rsp)
        movq	%r9, 136(%rsp)
        movq	144(%rdx), %r8
        movq	152(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 144(%rsp)
        movq	%r9, 152(%rsp)
        movq	160(%rdx), %r8
        movq	168(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 160(%rsp)
        movq	%r9, 168(%rsp)
        movq	176(%rdx), %r8
        movq	184(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 176(%rsp)
        movq	%r9, 184(%rsp)
        movq	192(%rdx), %r8
        movq	200(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 192(%rsp)
        movq	%r9, 200(%rsp)
        movq	208(%rdx), %r8
        movq	216(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 208(%rsp)
        movq	%r9, 216(%rsp)
        movq	224(%rdx), %r8
        movq	232(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 224(%rsp)
        movq	%r9, 232(%rsp)
        movq	240(%rdx), %r8
        movq	248(%rdx), %r9
        andq	%rcx, %r8
        andq	%rcx, %r9
        movq	%r8, 240(%rsp)
        movq	%r9, 248(%rsp)
        movq	(%rsi), %r8
        movq	(%rsp), %rdx
        addq	%rdx, %r8
        movq	8(%rsi), %r9
        movq	8(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, (%rdi)
        movq	16(%rsi), %r8
        movq	16(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 8(%rdi)
        movq	24(%rsi), %r9
        movq	24(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 16(%rdi)
        movq	32(%rsi), %r8
        movq	32(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 24(%rdi)
        movq	40(%rsi), %r9
        movq	40(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 32(%rdi)
        movq	48(%rsi), %r8
        movq	48(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 40(%rdi)
        movq	56(%rsi), %r9
        movq	56(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 48(%rdi)
        movq	64(%rsi), %r8
        movq	64(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 56(%rdi)
        movq	72(%rsi), %r9
        movq	72(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 64(%rdi)
        movq	80(%rsi), %r8
        movq	80(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 72(%rdi)
        movq	88(%rsi), %r9
        movq	88(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 80(%rdi)
        movq	96(%rsi), %r8
        movq	96(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 88(%rdi)
        movq	104(%rsi), %r9
        movq	104(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 96(%rdi)
        movq	112(%rsi), %r8
        movq	112(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 104(%rdi)
        movq	120(%rsi), %r9
        movq	120(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 112(%rdi)
        movq	128(%rsi), %r8
        movq	128(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 120(%rdi)
        movq	136(%rsi), %r9
        movq	136(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 128(%rdi)
        movq	144(%rsi), %r8
        movq	144(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 136(%rdi)
        movq	152(%rsi), %r9
        movq	152(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 144(%rdi)
        movq	160(%rsi), %r8
        movq	160(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 152(%rdi)
        movq	168(%rsi), %r9
        movq	168(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 160(%rdi)
        movq	176(%rsi), %r8
        movq	176(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 168(%rdi)
        movq	184(%rsi), %r9
        movq	184(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 176(%rdi)
        movq	192(%rsi), %r8
        movq	192(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 184(%rdi)
        movq	200(%rsi), %r9
        movq	200(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 192(%rdi)
        movq	208(%rsi), %r8
        movq	208(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 200(%rdi)
        movq	216(%rsi), %r9
        movq	216(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 208(%rdi)
        movq	224(%rsi), %r8
        movq	224(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 216(%rdi)
        movq	232(%rsi), %r9
        movq	232(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 224(%rdi)
        movq	240(%rsi), %r8
        movq	240(%rsp), %rdx
        adcq	%rdx, %r8
        movq	%r9, 232(%rdi)
        movq	248(%rsi), %r9
        movq	248(%rsp), %rdx
        adcq	%rdx, %r9
        movq	%r8, 240(%rdi)
        movq	%r9, 248(%rdi)
        adcq	$0, %rax
        addq	$256, %rsp
        repz retq
#ifndef __APPLE__
.size	sp_4096_cond_add_32,.-sp_4096_cond_add_32
#endif /* __APPLE__ */
/* Conditionally add a and b using the mask m.
 * m is -1 to add and 0 when not.
 *
 * r  A single precision number representing conditional add result.
 * a  A single precision number to add with.
 * b  A single precision number to add.
 * m  Mask value to apply.
 */
#ifndef __APPLE__
.globl	sp_4096_cond_add_avx2_32
.type	sp_4096_cond_add_avx2_32,@function
.align	16
sp_4096_cond_add_avx2_32:
#else
.globl	_sp_4096_cond_add_avx2_32
.p2align	4
_sp_4096_cond_add_avx2_32:
#endif /* __APPLE__ */
        movq	$0, %rax
        movq	(%rdx), %r10
        movq	(%rsi), %r8
        pextq	%rcx, %r10, %r10
        addq	%r10, %r8
        movq	8(%rdx), %r10
        movq	8(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, (%rdi)
        adcq	%r10, %r9
        movq	16(%rdx), %r8
        movq	16(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 8(%rdi)
        adcq	%r8, %r10
        movq	24(%rdx), %r9
        movq	24(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 16(%rdi)
        adcq	%r9, %r8
        movq	32(%rdx), %r10
        movq	32(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 24(%rdi)
        adcq	%r10, %r9
        movq	40(%rdx), %r8
        movq	40(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 32(%rdi)
        adcq	%r8, %r10
        movq	48(%rdx), %r9
        movq	48(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 40(%rdi)
        adcq	%r9, %r8
        movq	56(%rdx), %r10
        movq	56(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 48(%rdi)
        adcq	%r10, %r9
        movq	64(%rdx), %r8
        movq	64(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 56(%rdi)
        adcq	%r8, %r10
        movq	72(%rdx), %r9
        movq	72(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 64(%rdi)
        adcq	%r9, %r8
        movq	80(%rdx), %r10
        movq	80(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 72(%rdi)
        adcq	%r10, %r9
        movq	88(%rdx), %r8
        movq	88(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 80(%rdi)
        adcq	%r8, %r10
        movq	96(%rdx), %r9
        movq	96(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 88(%rdi)
        adcq	%r9, %r8
        movq	104(%rdx), %r10
        movq	104(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 96(%rdi)
        adcq	%r10, %r9
        movq	112(%rdx), %r8
        movq	112(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 104(%rdi)
        adcq	%r8, %r10
        movq	120(%rdx), %r9
        movq	120(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 112(%rdi)
        adcq	%r9, %r8
        movq	128(%rdx), %r10
        movq	128(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 120(%rdi)
        adcq	%r10, %r9
        movq	136(%rdx), %r8
        movq	136(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 128(%rdi)
        adcq	%r8, %r10
        movq	144(%rdx), %r9
        movq	144(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 136(%rdi)
        adcq	%r9, %r8
        movq	152(%rdx), %r10
        movq	152(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 144(%rdi)
        adcq	%r10, %r9
        movq	160(%rdx), %r8
        movq	160(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 152(%rdi)
        adcq	%r8, %r10
        movq	168(%rdx), %r9
        movq	168(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 160(%rdi)
        adcq	%r9, %r8
        movq	176(%rdx), %r10
        movq	176(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 168(%rdi)
        adcq	%r10, %r9
        movq	184(%rdx), %r8
        movq	184(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 176(%rdi)
        adcq	%r8, %r10
        movq	192(%rdx), %r9
        movq	192(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 184(%rdi)
        adcq	%r9, %r8
        movq	200(%rdx), %r10
        movq	200(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 192(%rdi)
        adcq	%r10, %r9
        movq	208(%rdx), %r8
        movq	208(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 200(%rdi)
        adcq	%r8, %r10
        movq	216(%rdx), %r9
        movq	216(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 208(%rdi)
        adcq	%r9, %r8
        movq	224(%rdx), %r10
        movq	224(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 216(%rdi)
        adcq	%r10, %r9
        movq	232(%rdx), %r8
        movq	232(%rsi), %r10
        pextq	%rcx, %r8, %r8
        movq	%r9, 224(%rdi)
        adcq	%r8, %r10
        movq	240(%rdx), %r9
        movq	240(%rsi), %r8
        pextq	%rcx, %r9, %r9
        movq	%r10, 232(%rdi)
        adcq	%r9, %r8
        movq	248(%rdx), %r10
        movq	248(%rsi), %r9
        pextq	%rcx, %r10, %r10
        movq	%r8, 240(%rdi)
        adcq	%r10, %r9
        movq	%r9, 248(%rdi)
        adcq	$0, %rax
        repz retq
#ifndef __APPLE__
.size	sp_4096_cond_add_avx2_32,.-sp_4096_cond_add_avx2_32
#endif /* __APPLE__ */
/* Shift number left by n bit. (r = a << n)
 *
 * r  Result of left shift by n.
 * a  Number to shift.
 * n  Amoutnt o shift.
 */
#ifndef __APPLE__
.globl	sp_4096_lshift_64
.type	sp_4096_lshift_64,@function
.align	16
sp_4096_lshift_64:
#else
.globl	_sp_4096_lshift_64
.p2align	4
_sp_4096_lshift_64:
#endif /* __APPLE__ */
        movq	%rdx, %rcx
        movq	$0, %r10
        movq	472(%rsi), %r11
        movq	480(%rsi), %rdx
        movq	488(%rsi), %rax
        movq	496(%rsi), %r8
        movq	504(%rsi), %r9
        shldq	%cl, %r9, %r10
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 480(%rdi)
        movq	%rax, 488(%rdi)
        movq	%r8, 496(%rdi)
        movq	%r9, 504(%rdi)
        movq	%r10, 512(%rdi)
        movq	440(%rsi), %r9
        movq	448(%rsi), %rdx
        movq	456(%rsi), %rax
        movq	464(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 448(%rdi)
        movq	%rax, 456(%rdi)
        movq	%r8, 464(%rdi)
        movq	%r11, 472(%rdi)
        movq	408(%rsi), %r11
        movq	416(%rsi), %rdx
        movq	424(%rsi), %rax
        movq	432(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 416(%rdi)
        movq	%rax, 424(%rdi)
        movq	%r8, 432(%rdi)
        movq	%r9, 440(%rdi)
        movq	376(%rsi), %r9
        movq	384(%rsi), %rdx
        movq	392(%rsi), %rax
        movq	400(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %rdx
        movq	%rdx, 384(%rdi)
        movq	%rax, 392(%rdi)
        movq	%r8, 400(%rdi)
        movq	%r11, 408(%rdi)
        movq	344(%rsi), %r11
        movq	352(%rsi), %rdx
        movq	360(%rsi), %rax
        movq	368(%rsi), %r8
        shldq	%cl, %r8, %r9
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r11, %rdx
        movq	%rdx, 352(%rdi)
        movq	%rax, 360(%rdi)
        movq	%r8, 368(%rdi)
        movq	%r9, 376(%rdi)
        movq	312(%rsi), %r9
        movq	320(%rsi), %rdx
        movq	328(%rsi), %rax
        movq	336(%rsi), %r8
        shldq	%cl, %r8, %r11
        shldq	%cl, %rax, %r8
        shldq	%cl, %rdx, %rax
        shldq	%cl, %r9, %r