/********************************************************************************
 * program:     wp2latex                                                        *
 * function:    convert WordPerfect 1.x,2.x,3.x,4.x,5.x and 6.x files into LaTeX*
 * modul:       charactr.cc                                                     *
 * description: This modul contains descriptions of all extended characters     *
 *              and perform a conversion to their LaTeX ekvivalents.            *
 *                Currently there is a WP5.x character set and other charsets   *
 *              are converted into it.					        *
 * licency:     GPL		                                                *
 ********************************************************************************/
#include<stdio.h>
#include<stdlib.h>

#include<string.h>
#include<lists.h>
#include<sets.h>

#include "wp2latex.h"
#include "cp_lib/cptran.h"


CpTranslator *Convert2Target = NULL;

int UseGrStyle(const char ReqFlag)
{
  if((InputPS|1) == ReqFlag)
  {
    InputPS |= 1;
    return 1;
  }
  return 0;
}

#define UseStyle(Flag, LaTeX_str)  \
  if(Flag>=false) {Flag=true;return(LaTeX_str);}
  
#define Use2Styles(Flag1, LaTeX_str1, Flag2, LaTeX_str2)\
  if(Flag1>=true || (Flag1>=false && Flag2<=false))  \
		   {Flag1=true;return(LaTeX_str1);}  \
  if(Flag2>=false) {Flag2=true;return(LaTeX_str2);}

#define SWITCH_CYR(LaTeX_str) if(Cyrillic>=0) \
  { \
  cq->RequiredFont = FONT_CYRILLIC; /*Cyrillic font*/ \
  return LaTeX_str; \
  }

#define SWITCH_HEB if(cjHebrew>=0) \
  { \
  cq->RequiredFont=FONT_HEBREW;	  /*Hebrew font*/ \
  }


/** Get character froom User Character Set */
const char *UserCharSet(WORD char_code, TconvertedPass1 *cq)
{
  if(UserWPCharSet==NULL)
	   {
NoUserChar:cq->perc.Hide();
	   fprintf(cq->err, _("\nWarning: Please add user character No:%d into external config file!"),(int)char_code);
	   UnknownCharacters++;
	   return "Usr?";
	   }
  if(UserWPCharSet[char_code]==NULL) goto NoUserChar;
  return(UserWPCharSet[char_code]);
}


/** Return unicode character packed in ascii. */
const char *ExpandUTF8(WORD wchar)
{
static char buffer[17];
  sprintf(buffer,"\\unichar{\"%4.4X\"}", wchar);
  return buffer;
}


/*This function expands an extended WP character into LaTEX sequence*/
#include "cp_lib/charactr.cc_"


#ifdef _1
unsigned short CodePage, WPcharset;
bool Cyrillic;
signed char Verbosing;
bool TexChars;


int main(void)
{
int i;
TconvertedPass1 cq;

Table_Init(lat);
for(i=0;i<255;i++)
	{
        printf("%d %d: %s\n\r",i,1,Ext_chr_str(1,i,&cq));
        }
printf("\n\r");

return(0);
}
#endif  /**/


/* End of charactr.cc. */
