// GENERATED FILE - DO NOT EDIT.
// Generated by gen_builtin_symbols.py using data from builtin_function_declarations.txt.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// ImmutableString_test_ESSL_autogen.cpp:
//   Tests for matching script-generated hashes with runtime computed hashes.

#include "compiler/translator/ImmutableString.h"
#include "gtest/gtest.h"

namespace sh
{

TEST(ImmutableStringTest, ScriptGeneratedHashesMatch)
{
    ASSERT_EQ(0x0000029au, ImmutableString("radians(00B").mangledNameHash());
    ASSERT_EQ(0x0000015fu, ImmutableString("radians(10B").mangledNameHash());
    ASSERT_EQ(0x0000011bu, ImmutableString("radians(20B").mangledNameHash());
    ASSERT_EQ(0x000003deu, ImmutableString("radians(30B").mangledNameHash());
    ASSERT_EQ(0x000001fcu, ImmutableString("degrees(00B").mangledNameHash());
    ASSERT_EQ(0x00000356u, ImmutableString("degrees(10B").mangledNameHash());
    ASSERT_EQ(0x000001eeu, ImmutableString("degrees(20B").mangledNameHash());
    ASSERT_EQ(0x00000183u, ImmutableString("degrees(30B").mangledNameHash());
    ASSERT_EQ(0x00000385u, ImmutableString("sin(00B").mangledNameHash());
    ASSERT_EQ(0x0000022cu, ImmutableString("sin(10B").mangledNameHash());
    ASSERT_EQ(0x00000250u, ImmutableString("sin(20B").mangledNameHash());
    ASSERT_EQ(0x00000121u, ImmutableString("sin(30B").mangledNameHash());
    ASSERT_EQ(0x0000023au, ImmutableString("cos(00B").mangledNameHash());
    ASSERT_EQ(0x00000394u, ImmutableString("cos(10B").mangledNameHash());
    ASSERT_EQ(0x000003dcu, ImmutableString("cos(20B").mangledNameHash());
    ASSERT_EQ(0x000002e8u, ImmutableString("cos(30B").mangledNameHash());
    ASSERT_EQ(0x0000022fu, ImmutableString("tan(00B").mangledNameHash());
    ASSERT_EQ(0x0000038bu, ImmutableString("tan(10B").mangledNameHash());
    ASSERT_EQ(0x000003e0u, ImmutableString("tan(20B").mangledNameHash());
    ASSERT_EQ(0x00000105u, ImmutableString("tan(30B").mangledNameHash());
    ASSERT_EQ(0x0000025eu, ImmutableString("asin(00B").mangledNameHash());
    ASSERT_EQ(0x000003b9u, ImmutableString("asin(10B").mangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("asin(20B").mangledNameHash());
    ASSERT_EQ(0x0000014du, ImmutableString("asin(30B").mangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("acos(00B").mangledNameHash());
    ASSERT_EQ(0x0000031du, ImmutableString("acos(10B").mangledNameHash());
    ASSERT_EQ(0x000002bcu, ImmutableString("acos(20B").mangledNameHash());
    ASSERT_EQ(0x00000181u, ImmutableString("acos(30B").mangledNameHash());
    ASSERT_EQ(0x00000217u, ImmutableString("atan(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("atan(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001eau, ImmutableString("atan(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000147u, ImmutableString("atan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000204u, ImmutableString("atan(00B").mangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("atan(10B").mangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("atan(20B").mangledNameHash());
    ASSERT_EQ(0x0000035du, ImmutableString("atan(30B").mangledNameHash());
    ASSERT_EQ(0x000002beu, ImmutableString("sinh(00B").mangledNameHash());
    ASSERT_EQ(0x0000035cu, ImmutableString("sinh(10B").mangledNameHash());
    ASSERT_EQ(0x0000019bu, ImmutableString("sinh(20B").mangledNameHash());
    ASSERT_EQ(0x000000fdu, ImmutableString("sinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000171u, ImmutableString("cosh(00B").mangledNameHash());
    ASSERT_EQ(0x0000033eu, ImmutableString("cosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000371u, ImmutableString("cosh(20B").mangledNameHash());
    ASSERT_EQ(0x00000295u, ImmutableString("cosh(30B").mangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("tanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000182u, ImmutableString("tanh(10B").mangledNameHash());
    ASSERT_EQ(0x000002adu, ImmutableString("tanh(20B").mangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("tanh(30B").mangledNameHash());
    ASSERT_EQ(0x0000028fu, ImmutableString("asinh(00B").mangledNameHash());
    ASSERT_EQ(0x000003e4u, ImmutableString("asinh(10B").mangledNameHash());
    ASSERT_EQ(0x00000102u, ImmutableString("asinh(20B").mangledNameHash());
    ASSERT_EQ(0x00000234u, ImmutableString("asinh(30B").mangledNameHash());
    ASSERT_EQ(0x00000197u, ImmutableString("acosh(00B").mangledNameHash());
    ASSERT_EQ(0x000000bbu, ImmutableString("acosh(10B").mangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("acosh(20B").mangledNameHash());
    ASSERT_EQ(0x000002d8u, ImmutableString("acosh(30B").mangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("atanh(00B").mangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("atanh(10B").mangledNameHash());
    ASSERT_EQ(0x000002ffu, ImmutableString("atanh(20B").mangledNameHash());
    ASSERT_EQ(0x000001b3u, ImmutableString("atanh(30B").mangledNameHash());
    ASSERT_EQ(0x000001adu, ImmutableString("pow(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("pow(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000335u, ImmutableString("pow(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000243u, ImmutableString("pow(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000343u, ImmutableString("exp(00B").mangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("exp(10B").mangledNameHash());
    ASSERT_EQ(0x00000194u, ImmutableString("exp(20B").mangledNameHash());
    ASSERT_EQ(0x000002c9u, ImmutableString("exp(30B").mangledNameHash());
    ASSERT_EQ(0x000002d0u, ImmutableString("log(00B").mangledNameHash());
    ASSERT_EQ(0x00000198u, ImmutableString("log(10B").mangledNameHash());
    ASSERT_EQ(0x0000014bu, ImmutableString("log(20B").mangledNameHash());
    ASSERT_EQ(0x000000dcu, ImmutableString("log(30B").mangledNameHash());
    ASSERT_EQ(0x000003ddu, ImmutableString("exp2(00B").mangledNameHash());
    ASSERT_EQ(0x0000010au, ImmutableString("exp2(10B").mangledNameHash());
    ASSERT_EQ(0x0000015du, ImmutableString("exp2(20B").mangledNameHash());
    ASSERT_EQ(0x00000286u, ImmutableString("exp2(30B").mangledNameHash());
    ASSERT_EQ(0x0000017du, ImmutableString("log2(00B").mangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("log2(10B").mangledNameHash());
    ASSERT_EQ(0x00000350u, ImmutableString("log2(20B").mangledNameHash());
    ASSERT_EQ(0x000001d6u, ImmutableString("log2(30B").mangledNameHash());
    ASSERT_EQ(0x000001f8u, ImmutableString("sqrt(00B").mangledNameHash());
    ASSERT_EQ(0x000000c9u, ImmutableString("sqrt(10B").mangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("sqrt(20B").mangledNameHash());
    ASSERT_EQ(0x0000033fu, ImmutableString("sqrt(30B").mangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("inversesqrt(00B").mangledNameHash());
    ASSERT_EQ(0x0000031bu, ImmutableString("inversesqrt(10B").mangledNameHash());
    ASSERT_EQ(0x0000026cu, ImmutableString("inversesqrt(20B").mangledNameHash());
    ASSERT_EQ(0x0000018au, ImmutableString("inversesqrt(30B").mangledNameHash());
    ASSERT_EQ(0x000002b2u, ImmutableString("abs(00B").mangledNameHash());
    ASSERT_EQ(0x00000180u, ImmutableString("abs(10B").mangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("abs(20B").mangledNameHash());
    ASSERT_EQ(0x00000321u, ImmutableString("abs(30B").mangledNameHash());
    ASSERT_EQ(0x000002b1u, ImmutableString("abs(00D").mangledNameHash());
    ASSERT_EQ(0x0000017fu, ImmutableString("abs(10D").mangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("abs(20D").mangledNameHash());
    ASSERT_EQ(0x0000031eu, ImmutableString("abs(30D").mangledNameHash());
    ASSERT_EQ(0x000002cfu, ImmutableString("sign(00B").mangledNameHash());
    ASSERT_EQ(0x000003ceu, ImmutableString("sign(10B").mangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("sign(20B").mangledNameHash());
    ASSERT_EQ(0x000001abu, ImmutableString("sign(30B").mangledNameHash());
    ASSERT_EQ(0x000002d3u, ImmutableString("sign(00D").mangledNameHash());
    ASSERT_EQ(0x00000341u, ImmutableString("sign(10D").mangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("sign(20D").mangledNameHash());
    ASSERT_EQ(0x000001acu, ImmutableString("sign(30D").mangledNameHash());
    ASSERT_EQ(0x000003e6u, ImmutableString("floor(00B").mangledNameHash());
    ASSERT_EQ(0x0000022bu, ImmutableString("floor(10B").mangledNameHash());
    ASSERT_EQ(0x0000024au, ImmutableString("floor(20B").mangledNameHash());
    ASSERT_EQ(0x00000122u, ImmutableString("floor(30B").mangledNameHash());
    ASSERT_EQ(0x000000fbu, ImmutableString("trunc(00B").mangledNameHash());
    ASSERT_EQ(0x000003bbu, ImmutableString("trunc(10B").mangledNameHash());
    ASSERT_EQ(0x00000380u, ImmutableString("trunc(20B").mangledNameHash());
    ASSERT_EQ(0x00000220u, ImmutableString("trunc(30B").mangledNameHash());
    ASSERT_EQ(0x000000e1u, ImmutableString("round(00B").mangledNameHash());
    ASSERT_EQ(0x000003a1u, ImmutableString("round(10B").mangledNameHash());
    ASSERT_EQ(0x00000252u, ImmutableString("round(20B").mangledNameHash());
    ASSERT_EQ(0x0000011eu, ImmutableString("round(30B").mangledNameHash());
    ASSERT_EQ(0x000002fcu, ImmutableString("roundEven(00B").mangledNameHash());
    ASSERT_EQ(0x000001b1u, ImmutableString("roundEven(10B").mangledNameHash());
    ASSERT_EQ(0x00000153u, ImmutableString("roundEven(20B").mangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("roundEven(30B").mangledNameHash());
    ASSERT_EQ(0x0000025fu, ImmutableString("ceil(00B").mangledNameHash());
    ASSERT_EQ(0x0000035fu, ImmutableString("ceil(10B").mangledNameHash());
    ASSERT_EQ(0x000000a3u, ImmutableString("ceil(20B").mangledNameHash());
    ASSERT_EQ(0x00000164u, ImmutableString("ceil(30B").mangledNameHash());
    ASSERT_EQ(0x00000191u, ImmutableString("fract(00B").mangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("fract(10B").mangledNameHash());
    ASSERT_EQ(0x00000320u, ImmutableString("fract(20B").mangledNameHash());
    ASSERT_EQ(0x000001d9u, ImmutableString("fract(30B").mangledNameHash());
    ASSERT_EQ(0x000001aeu, ImmutableString("mod(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000016du, ImmutableString("mod(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000c4u, ImmutableString("mod(20B00B").mangledNameHash());
    ASSERT_EQ(0x000001c0u, ImmutableString("mod(30B00B").mangledNameHash());
    ASSERT_EQ(0x000002dfu, ImmutableString("mod(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000230u, ImmutableString("mod(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001a9u, ImmutableString("mod(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001f4u, ImmutableString("min(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000352u, ImmutableString("min(10B00B").mangledNameHash());
    ASSERT_EQ(0x000000beu, ImmutableString("min(20B00B").mangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("min(30B00B").mangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("min(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000023bu, ImmutableString("min(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("min(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000037du, ImmutableString("min(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("min(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000029eu, ImmutableString("min(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000026eu, ImmutableString("min(30D30D").mangledNameHash());
    ASSERT_EQ(0x000002f8u, ImmutableString("min(10D00D").mangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("min(20D00D").mangledNameHash());
    ASSERT_EQ(0x000003ccu, ImmutableString("min(30D00D").mangledNameHash());
    ASSERT_EQ(0x00000344u, ImmutableString("min(00E00E").mangledNameHash());
    ASSERT_EQ(0x0000039au, ImmutableString("min(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("min(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001efu, ImmutableString("min(30E30E").mangledNameHash());
    ASSERT_EQ(0x000000dbu, ImmutableString("min(10E00E").mangledNameHash());
    ASSERT_EQ(0x000001feu, ImmutableString("min(20E00E").mangledNameHash());
    ASSERT_EQ(0x00000193u, ImmutableString("min(30E00E").mangledNameHash());
    ASSERT_EQ(0x00000152u, ImmutableString("max(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000027fu, ImmutableString("max(10B00B").mangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("max(20B00B").mangledNameHash());
    ASSERT_EQ(0x0000029du, ImmutableString("max(30B00B").mangledNameHash());
    ASSERT_EQ(0x000003b3u, ImmutableString("max(10B10B").mangledNameHash());
    ASSERT_EQ(0x000002c4u, ImmutableString("max(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000131u, ImmutableString("max(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000162u, ImmutableString("max(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000023fu, ImmutableString("max(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000023du, ImmutableString("max(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000345u, ImmutableString("max(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000011du, ImmutableString("max(10D00D").mangledNameHash());
    ASSERT_EQ(0x000000cdu, ImmutableString("max(20D00D").mangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("max(30D00D").mangledNameHash());
    ASSERT_EQ(0x000003cfu, ImmutableString("max(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000130u, ImmutableString("max(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000174u, ImmutableString("max(20E20E").mangledNameHash());
    ASSERT_EQ(0x000001e5u, ImmutableString("max(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000020eu, ImmutableString("max(10E00E").mangledNameHash());
    ASSERT_EQ(0x000002fau, ImmutableString("max(20E00E").mangledNameHash());
    ASSERT_EQ(0x0000015cu, ImmutableString("max(30E00E").mangledNameHash());
    ASSERT_EQ(0x0000018du, ImmutableString("clamp(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000003c4u, ImmutableString("clamp(10B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002acu, ImmutableString("clamp(20B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000111u, ImmutableString("clamp(30B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("clamp(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000376u, ImmutableString("clamp(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("clamp(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x00000120u, ImmutableString("clamp(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("clamp(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000303u, ImmutableString("clamp(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000003c3u, ImmutableString("clamp(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000a5u, ImmutableString("clamp(10D10D10D").mangledNameHash());
    ASSERT_EQ(0x0000020au, ImmutableString("clamp(20D20D20D").mangledNameHash());
    ASSERT_EQ(0x00000329u, ImmutableString("clamp(30D30D30D").mangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("clamp(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000300u, ImmutableString("clamp(10E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000032fu, ImmutableString("clamp(20E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000025du, ImmutableString("clamp(30E00E00E").mangledNameHash());
    ASSERT_EQ(0x00000132u, ImmutableString("clamp(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000000cbu, ImmutableString("clamp(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000000b1u, ImmutableString("clamp(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x0000024cu, ImmutableString("mix(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000327u, ImmutableString("mix(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("mix(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000353u, ImmutableString("mix(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x000001d1u, ImmutableString("mix(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000027du, ImmutableString("mix(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000395u, ImmutableString("mix(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("mix(00B00B00F").mangledNameHash());
    ASSERT_EQ(0x000001d0u, ImmutableString("mix(10B10B10F").mangledNameHash());
    ASSERT_EQ(0x0000027au, ImmutableString("mix(20B20B20F").mangledNameHash());
    ASSERT_EQ(0x00000332u, ImmutableString("mix(30B30B30F").mangledNameHash());
    ASSERT_EQ(0x000001a4u, ImmutableString("mix(00D00D00F").mangledNameHash());
    ASSERT_EQ(0x00000146u, ImmutableString("mix(10D10D10F").mangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("mix(20D20D20F").mangledNameHash());
    ASSERT_EQ(0x000002f1u, ImmutableString("mix(30D30D30F").mangledNameHash());
    ASSERT_EQ(0x000001a2u, ImmutableString("mix(00E00E00F").mangledNameHash());
    ASSERT_EQ(0x0000021fu, ImmutableString("mix(10E10E10F").mangledNameHash());
    ASSERT_EQ(0x000003c5u, ImmutableString("mix(20E20E20F").mangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("mix(30E30E30F").mangledNameHash());
    ASSERT_EQ(0x000002d1u, ImmutableString("mix(00F00F00F").mangledNameHash());
    ASSERT_EQ(0x00000355u, ImmutableString("mix(10F10F10F").mangledNameHash());
    ASSERT_EQ(0x0000034bu, ImmutableString("mix(20F20F20F").mangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("mix(30F30F30F").mangledNameHash());
    ASSERT_EQ(0x000001b7u, ImmutableString("step(00B00B").mangledNameHash());
    ASSERT_EQ(0x000002a0u, ImmutableString("step(10B10B").mangledNameHash());
    ASSERT_EQ(0x000002b4u, ImmutableString("step(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002a3u, ImmutableString("step(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("step(00B10B").mangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("step(00B20B").mangledNameHash());
    ASSERT_EQ(0x000002ccu, ImmutableString("step(00B30B").mangledNameHash());
    ASSERT_EQ(0x0000036eu, ImmutableString("smoothstep(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x00000245u, ImmutableString("smoothstep(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003d2u, ImmutableString("smoothstep(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000374u, ImmutableString("smoothstep(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x0000020fu, ImmutableString("smoothstep(00B00B10B").mangledNameHash());
    ASSERT_EQ(0x000000e2u, ImmutableString("smoothstep(00B00B20B").mangledNameHash());
    ASSERT_EQ(0x0000034du, ImmutableString("smoothstep(00B00B30B").mangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("modf(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("modf(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000266u, ImmutableString("modf(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000014fu, ImmutableString("modf(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000259u, ImmutableString("isnan(00B").mangledNameHash());
    ASSERT_EQ(0x000003b1u, ImmutableString("isnan(10B").mangledNameHash());
    ASSERT_EQ(0x00000151u, ImmutableString("isnan(20B").mangledNameHash());
    ASSERT_EQ(0x000001e7u, ImmutableString("isnan(30B").mangledNameHash());
    ASSERT_EQ(0x000001bbu, ImmutableString("isinf(00B").mangledNameHash());
    ASSERT_EQ(0x00000305u, ImmutableString("isinf(10B").mangledNameHash());
    ASSERT_EQ(0x00000393u, ImmutableString("isinf(20B").mangledNameHash());
    ASSERT_EQ(0x000000d2u, ImmutableString("isinf(30B").mangledNameHash());
    ASSERT_EQ(0x000003cdu, ImmutableString("floatBitsToInt(00B").mangledNameHash());
    ASSERT_EQ(0x0000027eu, ImmutableString("floatBitsToInt(10B").mangledNameHash());
    ASSERT_EQ(0x000000c7u, ImmutableString("floatBitsToInt(20B").mangledNameHash());
    ASSERT_EQ(0x00000158u, ImmutableString("floatBitsToInt(30B").mangledNameHash());
    ASSERT_EQ(0x000003d8u, ImmutableString("floatBitsToUint(00B").mangledNameHash());
    ASSERT_EQ(0x000000f2u, ImmutableString("floatBitsToUint(10B").mangledNameHash());
    ASSERT_EQ(0x00000148u, ImmutableString("floatBitsToUint(20B").mangledNameHash());
    ASSERT_EQ(0x0000028cu, ImmutableString("floatBitsToUint(30B").mangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("intBitsToFloat(00D").mangledNameHash());
    ASSERT_EQ(0x000001c9u, ImmutableString("intBitsToFloat(10D").mangledNameHash());
    ASSERT_EQ(0x00000190u, ImmutableString("intBitsToFloat(20D").mangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("intBitsToFloat(30D").mangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("uintBitsToFloat(00E").mangledNameHash());
    ASSERT_EQ(0x0000016eu, ImmutableString("uintBitsToFloat(10E").mangledNameHash());
    ASSERT_EQ(0x000002dbu, ImmutableString("uintBitsToFloat(20E").mangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("uintBitsToFloat(30E").mangledNameHash());
    ASSERT_EQ(0x000003aeu, ImmutableString("fma(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x0000019cu, ImmutableString("fma(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002c2u, ImmutableString("fma(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000035bu, ImmutableString("fma(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x0000009eu, ImmutableString("frexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x0000020cu, ImmutableString("frexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x0000018fu, ImmutableString("frexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x000001edu, ImmutableString("frexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("ldexp(00B00D").mangledNameHash());
    ASSERT_EQ(0x00000351u, ImmutableString("ldexp(10B10D").mangledNameHash());
    ASSERT_EQ(0x0000038eu, ImmutableString("ldexp(20B20D").mangledNameHash());
    ASSERT_EQ(0x0000029cu, ImmutableString("ldexp(30B30D").mangledNameHash());
    ASSERT_EQ(0x0000028bu, ImmutableString("packSnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x0000030bu, ImmutableString("packHalf2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000214u, ImmutableString("unpackSnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x00000116u, ImmutableString("unpackHalf2x16(00E").mangledNameHash());
    ASSERT_EQ(0x000002e4u, ImmutableString("packUnorm2x16(10B").mangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("unpackUnorm2x16(00E").mangledNameHash());
    ASSERT_EQ(0x0000009cu, ImmutableString("packUnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x00000326u, ImmutableString("packSnorm4x8(30B").mangledNameHash());
    ASSERT_EQ(0x000002dcu, ImmutableString("unpackUnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("unpackSnorm4x8(00E").mangledNameHash());
    ASSERT_EQ(0x00000222u, ImmutableString("length(00B").mangledNameHash());
    ASSERT_EQ(0x000000feu, ImmutableString("length(10B").mangledNameHash());
    ASSERT_EQ(0x000003bfu, ImmutableString("length(20B").mangledNameHash());
    ASSERT_EQ(0x00000276u, ImmutableString("length(30B").mangledNameHash());
    ASSERT_EQ(0x00000261u, ImmutableString("distance(00B00B").mangledNameHash());
    ASSERT_EQ(0x0000016bu, ImmutableString("distance(10B10B").mangledNameHash());
    ASSERT_EQ(0x000001bdu, ImmutableString("distance(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000f7u, ImmutableString("distance(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000101u, ImmutableString("dot(00B00B").mangledNameHash());
    ASSERT_EQ(0x00000114u, ImmutableString("dot(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000365u, ImmutableString("dot(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000103u, ImmutableString("dot(30B30B").mangledNameHash());
    ASSERT_EQ(0x000002aau, ImmutableString("cross(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000b6u, ImmutableString("normalize(00B").mangledNameHash());
    ASSERT_EQ(0x00000213u, ImmutableString("normalize(10B").mangledNameHash());
    ASSERT_EQ(0x000001f9u, ImmutableString("normalize(20B").mangledNameHash());
    ASSERT_EQ(0x00000373u, ImmutableString("normalize(30B").mangledNameHash());
    ASSERT_EQ(0x000002e5u, ImmutableString("faceforward(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000002f0u, ImmutableString("faceforward(10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000002b8u, ImmutableString("faceforward(20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000025bu, ImmutableString("faceforward(30B30B30B").mangledNameHash());
    ASSERT_EQ(0x000000c3u, ImmutableString("reflect(00B00B").mangledNameHash());
    ASSERT_EQ(0x000000c6u, ImmutableString("reflect(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000016cu, ImmutableString("reflect(20B20B").mangledNameHash());
    ASSERT_EQ(0x0000019du, ImmutableString("reflect(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001cdu, ImmutableString("refract(00B00B00B").mangledNameHash());
    ASSERT_EQ(0x000000e9u, ImmutableString("refract(10B10B00B").mangledNameHash());
    ASSERT_EQ(0x000001cbu, ImmutableString("refract(20B20B00B").mangledNameHash());
    ASSERT_EQ(0x00000248u, ImmutableString("refract(30B30B00B").mangledNameHash());
    ASSERT_EQ(0x000003a7u, ImmutableString("matrixCompMult(50B50B").mangledNameHash());
    ASSERT_EQ(0x00000117u, ImmutableString("matrixCompMult(A0BA0B").mangledNameHash());
    ASSERT_EQ(0x000002afu, ImmutableString("matrixCompMult(F0BF0B").mangledNameHash());
    ASSERT_EQ(0x00000253u, ImmutableString("matrixCompMult(90B90B").mangledNameHash());
    ASSERT_EQ(0x00000211u, ImmutableString("matrixCompMult(60B60B").mangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("matrixCompMult(D0BD0B").mangledNameHash());
    ASSERT_EQ(0x00000175u, ImmutableString("matrixCompMult(70B70B").mangledNameHash());
    ASSERT_EQ(0x00000221u, ImmutableString("matrixCompMult(E0BE0B").mangledNameHash());
    ASSERT_EQ(0x000002a8u, ImmutableString("matrixCompMult(B0BB0B").mangledNameHash());
    ASSERT_EQ(0x0000037eu, ImmutableString("outerProduct(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000145u, ImmutableString("outerProduct(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002c6u, ImmutableString("outerProduct(30B30B").mangledNameHash());
    ASSERT_EQ(0x000001a1u, ImmutableString("outerProduct(20B10B").mangledNameHash());
    ASSERT_EQ(0x0000010du, ImmutableString("outerProduct(10B20B").mangledNameHash());
    ASSERT_EQ(0x00000157u, ImmutableString("outerProduct(30B10B").mangledNameHash());
    ASSERT_EQ(0x00000236u, ImmutableString("outerProduct(10B30B").mangledNameHash());
    ASSERT_EQ(0x0000019eu, ImmutableString("outerProduct(30B20B").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("outerProduct(20B30B").mangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("transpose(50B").mangledNameHash());
    ASSERT_EQ(0x00000334u, ImmutableString("transpose(A0B").mangledNameHash());
    ASSERT_EQ(0x000000a8u, ImmutableString("transpose(F0B").mangledNameHash());
    ASSERT_EQ(0x000002d5u, ImmutableString("transpose(60B").mangledNameHash());
    ASSERT_EQ(0x00000366u, ImmutableString("transpose(90B").mangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("transpose(70B").mangledNameHash());
    ASSERT_EQ(0x000001d5u, ImmutableString("transpose(D0B").mangledNameHash());
    ASSERT_EQ(0x00000349u, ImmutableString("transpose(B0B").mangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("transpose(E0B").mangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("determinant(50B").mangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("determinant(A0B").mangledNameHash());
    ASSERT_EQ(0x00000333u, ImmutableString("determinant(F0B").mangledNameHash());
    ASSERT_EQ(0x00000112u, ImmutableString("inverse(50B").mangledNameHash());
    ASSERT_EQ(0x000001e3u, ImmutableString("inverse(A0B").mangledNameHash());
    ASSERT_EQ(0x000001fdu, ImmutableString("inverse(F0B").mangledNameHash());
    ASSERT_EQ(0x00000322u, ImmutableString("lessThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("lessThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000002a9u, ImmutableString("lessThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000139u, ImmutableString("lessThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000c5u, ImmutableString("lessThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000216u, ImmutableString("lessThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x000000a2u, ImmutableString("lessThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000113u, ImmutableString("lessThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("lessThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("lessThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("lessThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("lessThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000037fu, ImmutableString("lessThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000033bu, ImmutableString("lessThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000028du, ImmutableString("lessThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x0000026bu, ImmutableString("lessThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000002c7u, ImmutableString("lessThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x000000d9u, ImmutableString("lessThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x000003b8u, ImmutableString("greaterThan(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("greaterThan(20B20B").mangledNameHash());
    ASSERT_EQ(0x000000fau, ImmutableString("greaterThan(30B30B").mangledNameHash());
    ASSERT_EQ(0x000000ecu, ImmutableString("greaterThan(10D10D").mangledNameHash());
    ASSERT_EQ(0x000000f8u, ImmutableString("greaterThan(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000ebu, ImmutableString("greaterThan(30D30D").mangledNameHash());
    ASSERT_EQ(0x000003c8u, ImmutableString("greaterThan(10E10E").mangledNameHash());
    ASSERT_EQ(0x000001c6u, ImmutableString("greaterThan(20E20E").mangledNameHash());
    ASSERT_EQ(0x0000020bu, ImmutableString("greaterThan(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000362u, ImmutableString("greaterThanEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x0000024eu, ImmutableString("greaterThanEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x00000311u, ImmutableString("greaterThanEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x00000178u, ImmutableString("greaterThanEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("greaterThanEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x0000038fu, ImmutableString("greaterThanEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000291u, ImmutableString("greaterThanEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x00000138u, ImmutableString("greaterThanEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000277u, ImmutableString("greaterThanEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x000003adu, ImmutableString("equal(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000195u, ImmutableString("equal(20B20B").mangledNameHash());
    ASSERT_EQ(0x000003aau, ImmutableString("equal(30B30B").mangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("equal(10D10D").mangledNameHash());
    ASSERT_EQ(0x000002edu, ImmutableString("equal(20D20D").mangledNameHash());
    ASSERT_EQ(0x00000288u, ImmutableString("equal(30D30D").mangledNameHash());
    ASSERT_EQ(0x00000399u, ImmutableString("equal(10E10E").mangledNameHash());
    ASSERT_EQ(0x0000024bu, ImmutableString("equal(20E20E").mangledNameHash());
    ASSERT_EQ(0x000002ceu, ImmutableString("equal(30E30E").mangledNameHash());
    ASSERT_EQ(0x00000170u, ImmutableString("equal(10F10F").mangledNameHash());
    ASSERT_EQ(0x000003a8u, ImmutableString("equal(20F20F").mangledNameHash());
    ASSERT_EQ(0x00000315u, ImmutableString("equal(30F30F").mangledNameHash());
    ASSERT_EQ(0x0000021au, ImmutableString("notEqual(10B10B").mangledNameHash());
    ASSERT_EQ(0x00000390u, ImmutableString("notEqual(20B20B").mangledNameHash());
    ASSERT_EQ(0x000001b0u, ImmutableString("notEqual(30B30B").mangledNameHash());
    ASSERT_EQ(0x000002e1u, ImmutableString("notEqual(10D10D").mangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("notEqual(20D20D").mangledNameHash());
    ASSERT_EQ(0x000000e8u, ImmutableString("notEqual(30D30D").mangledNameHash());
    ASSERT_EQ(0x000003a4u, ImmutableString("notEqual(10E10E").mangledNameHash());
    ASSERT_EQ(0x000001e1u, ImmutableString("notEqual(20E20E").mangledNameHash());
    ASSERT_EQ(0x00000268u, ImmutableString("notEqual(30E30E").mangledNameHash());
    ASSERT_EQ(0x0000036bu, ImmutableString("notEqual(10F10F").mangledNameHash());
    ASSERT_EQ(0x000001a8u, ImmutableString("notEqual(20F20F").mangledNameHash());
    ASSERT_EQ(0x00000318u, ImmutableString("notEqual(30F30F").mangledNameHash());
    ASSERT_EQ(0x00000282u, ImmutableString("any(10F").mangledNameHash());
    ASSERT_EQ(0x00000223u, ImmutableString("any(20F").mangledNameHash());
    ASSERT_EQ(0x000000f6u, ImmutableString("any(30F").mangledNameHash());
    ASSERT_EQ(0x000002abu, ImmutableString("all(10F").mangledNameHash());
    ASSERT_EQ(0x00000304u, ImmutableString("all(20F").mangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("all(30F").mangledNameHash());
    ASSERT_EQ(0x000000a0u, ImmutableString("not(10F").mangledNameHash());
    ASSERT_EQ(0x0000013eu, ImmutableString("not(20F").mangledNameHash());
    ASSERT_EQ(0x00000368u, ImmutableString("not(30F").mangledNameHash());
    ASSERT_EQ(0x00000316u, ImmutableString("bitfieldExtract(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001aau, ImmutableString("bitfieldExtract(10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000218u, ImmutableString("bitfieldExtract(20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000002f7u, ImmutableString("bitfieldExtract(30D00D00D").mangledNameHash());
    ASSERT_EQ(0x0000021du, ImmutableString("bitfieldExtract(00E00D00D").mangledNameHash());
    ASSERT_EQ(0x000000efu, ImmutableString("bitfieldExtract(10E00D00D").mangledNameHash());
    ASSERT_EQ(0x000002dau, ImmutableString("bitfieldExtract(20E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000176u, ImmutableString("bitfieldExtract(30E00D00D").mangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("bitfieldInsert(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000375u, ImmutableString("bitfieldInsert(10D10D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("bitfieldInsert(20D20D00D00D").mangledNameHash());
    ASSERT_EQ(0x000000e5u, ImmutableString("bitfieldInsert(30D30D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("bitfieldInsert(00E00E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000325u, ImmutableString("bitfieldInsert(10E10E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000249u, ImmutableString("bitfieldInsert(20E20E00D00D").mangledNameHash());
    ASSERT_EQ(0x000003c0u, ImmutableString("bitfieldInsert(30E30E00D00D").mangledNameHash());
    ASSERT_EQ(0x00000172u, ImmutableString("bitfieldReverse(00D").mangledNameHash());
    ASSERT_EQ(0x000002a5u, ImmutableString("bitfieldReverse(10D").mangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("bitfieldReverse(20D").mangledNameHash());
    ASSERT_EQ(0x00000188u, ImmutableString("bitfieldReverse(30D").mangledNameHash());
    ASSERT_EQ(0x00000173u, ImmutableString("bitfieldReverse(00E").mangledNameHash());
    ASSERT_EQ(0x000002a4u, ImmutableString("bitfieldReverse(10E").mangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("bitfieldReverse(20E").mangledNameHash());
    ASSERT_EQ(0x00000187u, ImmutableString("bitfieldReverse(30E").mangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("bitCount(00D").mangledNameHash());
    ASSERT_EQ(0x000002cdu, ImmutableString("bitCount(10D").mangledNameHash());
    ASSERT_EQ(0x000001b6u, ImmutableString("bitCount(20D").mangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("bitCount(30D").mangledNameHash());
    ASSERT_EQ(0x00000104u, ImmutableString("bitCount(00E").mangledNameHash());
    ASSERT_EQ(0x00000167u, ImmutableString("bitCount(10E").mangledNameHash());
    ASSERT_EQ(0x000002ebu, ImmutableString("bitCount(20E").mangledNameHash());
    ASSERT_EQ(0x00000149u, ImmutableString("bitCount(30E").mangledNameHash());
    ASSERT_EQ(0x0000030eu, ImmutableString("findLSB(00D").mangledNameHash());
    ASSERT_EQ(0x000001ceu, ImmutableString("findLSB(10D").mangledNameHash());
    ASSERT_EQ(0x0000009au, ImmutableString("findLSB(20D").mangledNameHash());
    ASSERT_EQ(0x000002e9u, ImmutableString("findLSB(30D").mangledNameHash());
    ASSERT_EQ(0x0000030du, ImmutableString("findLSB(00E").mangledNameHash());
    ASSERT_EQ(0x000001cfu, ImmutableString("findLSB(10E").mangledNameHash());
    ASSERT_EQ(0x00000099u, ImmutableString("findLSB(20E").mangledNameHash());
    ASSERT_EQ(0x000002eau, ImmutableString("findLSB(30E").mangledNameHash());
    ASSERT_EQ(0x000002d6u, ImmutableString("findMSB(00D").mangledNameHash());
    ASSERT_EQ(0x00000100u, ImmutableString("findMSB(10D").mangledNameHash());
    ASSERT_EQ(0x00000140u, ImmutableString("findMSB(20D").mangledNameHash());
    ASSERT_EQ(0x00000274u, ImmutableString("findMSB(30D").mangledNameHash());
    ASSERT_EQ(0x000002d9u, ImmutableString("findMSB(00E").mangledNameHash());
    ASSERT_EQ(0x000000ffu, ImmutableString("findMSB(10E").mangledNameHash());
    ASSERT_EQ(0x00000141u, ImmutableString("findMSB(20E").mangledNameHash());
    ASSERT_EQ(0x00000273u, ImmutableString("findMSB(30E").mangledNameHash());
    ASSERT_EQ(0x0000024fu, ImmutableString("uaddCarry(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x0000038au, ImmutableString("uaddCarry(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000003b2u, ImmutableString("uaddCarry(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x000001bfu, ImmutableString("uaddCarry(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000001ebu, ImmutableString("usubBorrow(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000003acu, ImmutableString("usubBorrow(10E10E10E").mangledNameHash());
    ASSERT_EQ(0x00000108u, ImmutableString("usubBorrow(20E20E20E").mangledNameHash());
    ASSERT_EQ(0x00000299u, ImmutableString("usubBorrow(30E30E30E").mangledNameHash());
    ASSERT_EQ(0x00000346u, ImmutableString("umulExtended(00E00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000001a3u, ImmutableString("umulExtended(10E10E10E10E").mangledNameHash());
    ASSERT_EQ(0x000002e6u, ImmutableString("umulExtended(20E20E20E20E").mangledNameHash());
    ASSERT_EQ(0x0000025au, ImmutableString("umulExtended(30E30E30E30E").mangledNameHash());
    ASSERT_EQ(0x000001e8u, ImmutableString("imulExtended(00D00D00D00D").mangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("imulExtended(10D10D10D10D").mangledNameHash());
    ASSERT_EQ(0x000000f5u, ImmutableString("imulExtended(20D20D20D20D").mangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("imulExtended(30D30D30D30D").mangledNameHash());
    ASSERT_EQ(0x0000009fu, ImmutableString("texture2D(00I10B").mangledNameHash());
    ASSERT_EQ(0x0000013cu, ImmutableString("texture2DProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x00000265u, ImmutableString("texture2DProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x00000237u, ImmutableString("textureCube(00K20B").mangledNameHash());
    ASSERT_EQ(0x0000037cu, ImmutableString("texture2D(00M10B").mangledNameHash());
    ASSERT_EQ(0x000002ddu, ImmutableString("texture2DProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x000002e2u, ImmutableString("texture2DProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x000000f4u, ImmutableString("texture2DRect(00O10B").mangledNameHash());
    ASSERT_EQ(0x000003dfu, ImmutableString("texture2DRectProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x0000011au, ImmutableString("texture2DRectProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x000000a7u, ImmutableString("texture(00O10B").mangledNameHash());
    ASSERT_EQ(0x0000010bu, ImmutableString("textureProj(00O20B").mangledNameHash());
    ASSERT_EQ(0x00000246u, ImmutableString("textureProj(00O30B").mangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("texture2DGradEXT(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000336u, ImmutableString("texture2DProjGradEXT(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("texture2DProjGradEXT(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001f2u, ImmutableString("textureCubeGradEXT(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000208u, ImmutableString("texture2D(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x0000030cu, ImmutableString("texture2DProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f1u, ImmutableString("texture2DProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000364u, ImmutableString("textureCube(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000002aeu, ImmutableString("dFdx(00B").mangledNameHash());
    ASSERT_EQ(0x00000185u, ImmutableString("dFdx(10B").mangledNameHash());
    ASSERT_EQ(0x0000012du, ImmutableString("dFdx(20B").mangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("dFdx(30B").mangledNameHash());
    ASSERT_EQ(0x000003cbu, ImmutableString("dFdy(00B").mangledNameHash());
    ASSERT_EQ(0x00000156u, ImmutableString("dFdy(10B").mangledNameHash());
    ASSERT_EQ(0x000001b4u, ImmutableString("dFdy(20B").mangledNameHash());
    ASSERT_EQ(0x000002feu, ImmutableString("dFdy(30B").mangledNameHash());
    ASSERT_EQ(0x00000154u, ImmutableString("fwidth(00B").mangledNameHash());
    ASSERT_EQ(0x000000e6u, ImmutableString("fwidth(10B").mangledNameHash());
    ASSERT_EQ(0x0000034au, ImmutableString("fwidth(20B").mangledNameHash());
    ASSERT_EQ(0x00000278u, ImmutableString("fwidth(30B").mangledNameHash());
    ASSERT_EQ(0x000002fdu, ImmutableString("texture2DLodEXT(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000317u, ImmutableString("texture2DProjLodEXT(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000001b2u, ImmutableString("texture2DProjLodEXT(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000387u, ImmutableString("textureCubeLodEXT(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000001d3u, ImmutableString("texture3D(00J20B").mangledNameHash());
    ASSERT_EQ(0x000002a6u, ImmutableString("texture3DProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x00000260u, ImmutableString("texture3D(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000289u, ImmutableString("texture3DProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000003eau, ImmutableString("texture3DLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000013du, ImmutableString("texture3DProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000002c0u, ImmutableString("texture2DLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000118u, ImmutableString("texture2DProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000003b0u, ImmutableString("texture2DProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000003d3u, ImmutableString("textureCubeLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000001f3u, ImmutableString("texture(00I10B").mangledNameHash());
    ASSERT_EQ(0x00000297u, ImmutableString("texture(00R10B").mangledNameHash());
    ASSERT_EQ(0x00000330u, ImmutableString("texture(00X10B").mangledNameHash());
    ASSERT_EQ(0x0000012au, ImmutableString("texture(00J20B").mangledNameHash());
    ASSERT_EQ(0x000001a0u, ImmutableString("texture(00S20B").mangledNameHash());
    ASSERT_EQ(0x0000009bu, ImmutableString("texture(00Y20B").mangledNameHash());
    ASSERT_EQ(0x00000359u, ImmutableString("texture(00K20B").mangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("texture(00T20B").mangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("texture(00Z20B").mangledNameHash());
    ASSERT_EQ(0x00000135u, ImmutableString("texture(00L20B").mangledNameHash());
    ASSERT_EQ(0x000000edu, ImmutableString("texture(00U20B").mangledNameHash());
    ASSERT_EQ(0x00000262u, ImmutableString("texture(00a20B").mangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("texture(00d20B").mangledNameHash());
    ASSERT_EQ(0x00000396u, ImmutableString("texture(00e30B").mangledNameHash());
    ASSERT_EQ(0x0000036du, ImmutableString("texture(00f30B").mangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("textureProj(00I20B").mangledNameHash());
    ASSERT_EQ(0x000003c6u, ImmutableString("textureProj(00R20B").mangledNameHash());
    ASSERT_EQ(0x0000012fu, ImmutableString("textureProj(00X20B").mangledNameHash());
    ASSERT_EQ(0x0000023eu, ImmutableString("textureProj(00I30B").mangledNameHash());
    ASSERT_EQ(0x000003a6u, ImmutableString("textureProj(00R30B").mangledNameHash());
    ASSERT_EQ(0x000003bdu, ImmutableString("textureProj(00X30B").mangledNameHash());
    ASSERT_EQ(0x00000159u, ImmutableString("textureProj(00J30B").mangledNameHash());
    ASSERT_EQ(0x000002fbu, ImmutableString("textureProj(00S30B").mangledNameHash());
    ASSERT_EQ(0x000001b5u, ImmutableString("textureProj(00Y30B").mangledNameHash());
    ASSERT_EQ(0x00000331u, ImmutableString("textureProj(00d30B").mangledNameHash());
    ASSERT_EQ(0x00000177u, ImmutableString("textureLod(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x000002b3u, ImmutableString("textureLod(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x000002c8u, ImmutableString("textureLod(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000000c8u, ImmutableString("textureLod(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x0000033cu, ImmutableString("textureLod(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("textureLod(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000003dau, ImmutableString("textureLod(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x00000106u, ImmutableString("textureLod(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000002d2u, ImmutableString("textureLod(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("textureLod(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x000003abu, ImmutableString("textureLod(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x00000281u, ImmutableString("textureLod(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x0000015eu, ImmutableString("textureLod(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x000000ceu, ImmutableString("textureSize(00I00D").mangledNameHash());
    ASSERT_EQ(0x000000b4u, ImmutableString("textureSize(00R00D").mangledNameHash());
    ASSERT_EQ(0x000003b7u, ImmutableString("textureSize(00X00D").mangledNameHash());
    ASSERT_EQ(0x000001dbu, ImmutableString("textureSize(00J00D").mangledNameHash());
    ASSERT_EQ(0x00000360u, ImmutableString("textureSize(00S00D").mangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("textureSize(00Y00D").mangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("textureSize(00K00D").mangledNameHash());
    ASSERT_EQ(0x00000397u, ImmutableString("textureSize(00T00D").mangledNameHash());
    ASSERT_EQ(0x000002f5u, ImmutableString("textureSize(00Z00D").mangledNameHash());
    ASSERT_EQ(0x000001dfu, ImmutableString("textureSize(00L00D").mangledNameHash());
    ASSERT_EQ(0x00000312u, ImmutableString("textureSize(00U00D").mangledNameHash());
    ASSERT_EQ(0x000000eeu, ImmutableString("textureSize(00a00D").mangledNameHash());
    ASSERT_EQ(0x00000384u, ImmutableString("textureSize(00d00D").mangledNameHash());
    ASSERT_EQ(0x000001e0u, ImmutableString("textureSize(00e00D").mangledNameHash());
    ASSERT_EQ(0x0000032bu, ImmutableString("textureSize(00f00D").mangledNameHash());
    ASSERT_EQ(0x00000361u, ImmutableString("textureProjLod(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000000e7u, ImmutableString("textureProjLod(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x00000256u, ImmutableString("textureProjLod(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000001ccu, ImmutableString("textureProjLod(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x000001ffu, ImmutableString("textureProjLod(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("textureProjLod(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x000000f3u, ImmutableString("textureProjLod(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x000000cau, ImmutableString("textureProjLod(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x0000033du, ImmutableString("textureProjLod(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x00000254u, ImmutableString("textureProjLod(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("texelFetch(00I10D00D").mangledNameHash());
    ASSERT_EQ(0x00000370u, ImmutableString("texelFetch(00R10D00D").mangledNameHash());
    ASSERT_EQ(0x000002bdu, ImmutableString("texelFetch(00X10D00D").mangledNameHash());
    ASSERT_EQ(0x000003d6u, ImmutableString("texelFetch(00J20D00D").mangledNameHash());
    ASSERT_EQ(0x0000027bu, ImmutableString("texelFetch(00S20D00D").mangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("texelFetch(00Y20D00D").mangledNameHash());
    ASSERT_EQ(0x000001b8u, ImmutableString("texelFetch(00L20D00D").mangledNameHash());
    ASSERT_EQ(0x00000160u, ImmutableString("texelFetch(00U20D00D").mangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("texelFetch(00a20D00D").mangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("textureGrad(00I10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000378u, ImmutableString("textureGrad(00R10B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000275u, ImmutableString("textureGrad(00X10B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001d7u, ImmutableString("textureGrad(00J20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000011cu, ImmutableString("textureGrad(00S20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000124u, ImmutableString("textureGrad(00Y20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000279u, ImmutableString("textureGrad(00K20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000039cu, ImmutableString("textureGrad(00T20B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000016fu, ImmutableString("textureGrad(00Z20B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("textureGrad(00d20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000270u, ImmutableString("textureGrad(00e30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000377u, ImmutableString("textureGrad(00L20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001beu, ImmutableString("textureGrad(00U20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001c7u, ImmutableString("textureGrad(00a20B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000264u, ImmutableString("textureGrad(00f30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000379u, ImmutableString("textureProjGrad(00I20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000036cu, ImmutableString("textureProjGrad(00R20B10B10B").mangledNameHash());
    ASSERT_EQ(0x000001e4u, ImmutableString("textureProjGrad(00X20B10B10B").mangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("textureProjGrad(00I30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000109u, ImmutableString("textureProjGrad(00R30B10B10B").mangledNameHash());
    ASSERT_EQ(0x000003e5u, ImmutableString("textureProjGrad(00X30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000155u, ImmutableString("textureProjGrad(00J30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("textureProjGrad(00S30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("textureProjGrad(00Y30B20B20B").mangledNameHash());
    ASSERT_EQ(0x000001d8u, ImmutableString("textureProjGrad(00d30B10B10B").mangledNameHash());
    ASSERT_EQ(0x00000200u, ImmutableString("textureSize(00P").mangledNameHash());
    ASSERT_EQ(0x000002e3u, ImmutableString("textureSize(00V").mangledNameHash());
    ASSERT_EQ(0x00000239u, ImmutableString("textureSize(00b").mangledNameHash());
    ASSERT_EQ(0x00000251u, ImmutableString("textureSize(00Q").mangledNameHash());
    ASSERT_EQ(0x00000255u, ImmutableString("textureSize(00W").mangledNameHash());
    ASSERT_EQ(0x00000238u, ImmutableString("textureSize(00c").mangledNameHash());
    ASSERT_EQ(0x0000016au, ImmutableString("textureSize(00k00D").mangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("textureSize(00s00D").mangledNameHash());
    ASSERT_EQ(0x000002bbu, ImmutableString("textureSize(00x00D").mangledNameHash());
    ASSERT_EQ(0x000002b9u, ImmutableString("textureSize(00l00D").mangledNameHash());
    ASSERT_EQ(0x00000231u, ImmutableString("texture(00k30B").mangledNameHash());
    ASSERT_EQ(0x0000015au, ImmutableString("texture(00s30B").mangledNameHash());
    ASSERT_EQ(0x0000020du, ImmutableString("texture(00x30B").mangledNameHash());
    ASSERT_EQ(0x00000358u, ImmutableString("texture(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x0000034eu, ImmutableString("texture(00s30B00B").mangledNameHash());
    ASSERT_EQ(0x000001b9u, ImmutableString("texture(00x30B00B").mangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("texture(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x0000017au, ImmutableString("textureLod(00k30B00B").mangledNameHash());
    ASSERT_EQ(0x0000028eu, ImmutableString("textureLod(00s30B00B").mangledNameHash());
    ASSERT_EQ(0x00000233u, ImmutableString("textureLod(00x30B00B").mangledNameHash());
    ASSERT_EQ(0x00000235u, ImmutableString("textureGrad(00k30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000269u, ImmutableString("textureGrad(00s30B20B20B").mangledNameHash());
    ASSERT_EQ(0x00000125u, ImmutableString("textureGrad(00x30B20B20B").mangledNameHash());
    ASSERT_EQ(0x0000037bu, ImmutableString("textureGather(00k30B").mangledNameHash());
    ASSERT_EQ(0x00000224u, ImmutableString("textureGather(00s30B").mangledNameHash());
    ASSERT_EQ(0x00000383u, ImmutableString("textureGather(00x30B").mangledNameHash());
    ASSERT_EQ(0x0000013fu, ImmutableString("textureGather(00k30B00D").mangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("textureGather(00s30B00D").mangledNameHash());
    ASSERT_EQ(0x00000232u, ImmutableString("textureGather(00x30B00D").mangledNameHash());
    ASSERT_EQ(0x0000014cu, ImmutableString("textureGather(00l30B00B").mangledNameHash());
    ASSERT_EQ(0x000000a1u, ImmutableString("texelFetch(00P10D00D").mangledNameHash());
    ASSERT_EQ(0x00000144u, ImmutableString("texelFetch(00V10D00D").mangledNameHash());
    ASSERT_EQ(0x000002c1u, ImmutableString("texelFetch(00b10D00D").mangledNameHash());
    ASSERT_EQ(0x000002f9u, ImmutableString("texelFetch(00Q20D00D").mangledNameHash());
    ASSERT_EQ(0x00000119u, ImmutableString("texelFetch(00W20D00D").mangledNameHash());
    ASSERT_EQ(0x000001f6u, ImmutableString("texelFetch(00c20D00D").mangledNameHash());
    ASSERT_EQ(0x000000c2u, ImmutableString("texture(00I10B00B").mangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("texture(00R10B00B").mangledNameHash());
    ASSERT_EQ(0x0000009du, ImmutableString("texture(00X10B00B").mangledNameHash());
    ASSERT_EQ(0x000001cau, ImmutableString("texture(00J20B00B").mangledNameHash());
    ASSERT_EQ(0x00000168u, ImmutableString("texture(00S20B00B").mangledNameHash());
    ASSERT_EQ(0x000001afu, ImmutableString("texture(00Y20B00B").mangledNameHash());
    ASSERT_EQ(0x000001c1u, ImmutableString("texture(00K20B00B").mangledNameHash());
    ASSERT_EQ(0x000000d7u, ImmutableString("texture(00T20B00B").mangledNameHash());
    ASSERT_EQ(0x000000fcu, ImmutableString("texture(00Z20B00B").mangledNameHash());
    ASSERT_EQ(0x00000219u, ImmutableString("texture(00L20B00B").mangledNameHash());
    ASSERT_EQ(0x0000019fu, ImmutableString("texture(00U20B00B").mangledNameHash());
    ASSERT_EQ(0x000003d0u, ImmutableString("texture(00a20B00B").mangledNameHash());
    ASSERT_EQ(0x000003c7u, ImmutableString("textureProj(00I20B00B").mangledNameHash());
    ASSERT_EQ(0x000002b7u, ImmutableString("textureProj(00R20B00B").mangledNameHash());
    ASSERT_EQ(0x00000209u, ImmutableString("textureProj(00X20B00B").mangledNameHash());
    ASSERT_EQ(0x000000bau, ImmutableString("textureProj(00I30B00B").mangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("textureProj(00R30B00B").mangledNameHash());
    ASSERT_EQ(0x00000226u, ImmutableString("textureProj(00X30B00B").mangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("textureProj(00J30B00B").mangledNameHash());
    ASSERT_EQ(0x00000123u, ImmutableString("textureProj(00S30B00B").mangledNameHash());
    ASSERT_EQ(0x000001d2u, ImmutableString("textureProj(00Y30B00B").mangledNameHash());
    ASSERT_EQ(0x000002e0u, ImmutableString("texture(00d20B00B").mangledNameHash());
    ASSERT_EQ(0x0000017bu, ImmutableString("texture(00e30B00B").mangledNameHash());
    ASSERT_EQ(0x0000032eu, ImmutableString("textureProj(00d30B00B").mangledNameHash());
    ASSERT_EQ(0x000003d1u, ImmutableString("texture(00M10B00B").mangledNameHash());
    ASSERT_EQ(0x000003d7u, ImmutableString("textureProj(00M20B00B").mangledNameHash());
    ASSERT_EQ(0x000000bfu, ImmutableString("textureProj(00M30B00B").mangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("texture(00N10B00B").mangledNameHash());
    ASSERT_EQ(0x0000032cu, ImmutableString("textureProj(00N20B00B").mangledNameHash());
    ASSERT_EQ(0x000000b2u, ImmutableString("textureProj(00N30B00B").mangledNameHash());
    ASSERT_EQ(0x000000b8u, ImmutableString("textureOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x00000290u, ImmutableString("textureOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x00000294u, ImmutableString("textureOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x000003d4u, ImmutableString("textureOffset(00J20B20D").mangledNameHash());
    ASSERT_EQ(0x000003c1u, ImmutableString("textureOffset(00S20B20D").mangledNameHash());
    ASSERT_EQ(0x000002d4u, ImmutableString("textureOffset(00Y20B20D").mangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("textureOffset(00d20B10D").mangledNameHash());
    ASSERT_EQ(0x000000d8u, ImmutableString("textureOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("textureOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x000000f9u, ImmutableString("textureOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x000000eau, ImmutableString("textureProjOffset(00I20B10D").mangledNameHash());
    ASSERT_EQ(0x000000afu, ImmutableString("textureProjOffset(00R20B10D").mangledNameHash());
    ASSERT_EQ(0x000003c2u, ImmutableString("textureProjOffset(00X20B10D").mangledNameHash());
    ASSERT_EQ(0x00000186u, ImmutableString("textureProjOffset(00I30B10D").mangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("textureProjOffset(00R30B10D").mangledNameHash());
    ASSERT_EQ(0x0000030fu, ImmutableString("textureProjOffset(00X30B10D").mangledNameHash());
    ASSERT_EQ(0x0000039eu, ImmutableString("textureProjOffset(00J30B20D").mangledNameHash());
    ASSERT_EQ(0x000000dfu, ImmutableString("textureProjOffset(00S30B20D").mangledNameHash());
    ASSERT_EQ(0x000002b0u, ImmutableString("textureProjOffset(00Y30B20D").mangledNameHash());
    ASSERT_EQ(0x000003a3u, ImmutableString("textureProjOffset(00d30B10D").mangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("textureLodOffset(00I10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000a4u, ImmutableString("textureLodOffset(00R10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000d6u, ImmutableString("textureLodOffset(00X10B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000026du, ImmutableString("textureLodOffset(00J20B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("textureLodOffset(00S20B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000017cu, ImmutableString("textureLodOffset(00Y20B00B20D").mangledNameHash());
    ASSERT_EQ(0x000001e2u, ImmutableString("textureLodOffset(00d20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000038cu, ImmutableString("textureLodOffset(00L20B00B10D").mangledNameHash());
    ASSERT_EQ(0x000002b6u, ImmutableString("textureLodOffset(00U20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("textureLodOffset(00a20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000036au, ImmutableString("textureProjLodOffset(00I20B00B10D").mangledNameHash());
    ASSERT_EQ(0x0000014au, ImmutableString("textureProjLodOffset(00R20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000196u, ImmutableString("textureProjLodOffset(00X20B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000372u, ImmutableString("textureProjLodOffset(00I30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000203u, ImmutableString("textureProjLodOffset(00R30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000392u, ImmutableString("textureProjLodOffset(00X30B00B10D").mangledNameHash());
    ASSERT_EQ(0x000001ecu, ImmutableString("textureProjLodOffset(00J30B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000019au, ImmutableString("textureProjLodOffset(00S30B00B20D").mangledNameHash());
    ASSERT_EQ(0x00000115u, ImmutableString("textureProjLodOffset(00Y30B00B20D").mangledNameHash());
    ASSERT_EQ(0x0000036fu, ImmutableString("textureProjLodOffset(00d30B00B10D").mangledNameHash());
    ASSERT_EQ(0x00000142u, ImmutableString("texelFetchOffset(00I10D00D10D").mangledNameHash());
    ASSERT_EQ(0x000000d1u, ImmutableString("texelFetchOffset(00R10D00D10D").mangledNameHash());
    ASSERT_EQ(0x000002deu, ImmutableString("texelFetchOffset(00X10D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000022eu, ImmutableString("texelFetchOffset(00J20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000133u, ImmutableString("texelFetchOffset(00S20D00D20D").mangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("texelFetchOffset(00Y20D00D20D").mangledNameHash());
    ASSERT_EQ(0x00000287u, ImmutableString("texelFetchOffset(00L20D00D10D").mangledNameHash());
    ASSERT_EQ(0x000001deu, ImmutableString("texelFetchOffset(00U20D00D10D").mangledNameHash());
    ASSERT_EQ(0x0000013au, ImmutableString("texelFetchOffset(00a20D00D10D").mangledNameHash());
    ASSERT_EQ(0x00000267u, ImmutableString("textureGradOffset(00I10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000313u, ImmutableString("textureGradOffset(00R10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("textureGradOffset(00X10B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("textureGradOffset(00J20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x000000abu, ImmutableString("textureGradOffset(00S20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000025cu, ImmutableString("textureGradOffset(00Y20B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000201u, ImmutableString("textureGradOffset(00d20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000035eu, ImmutableString("textureGradOffset(00L20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000027cu, ImmutableString("textureGradOffset(00U20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000001a7u, ImmutableString("textureGradOffset(00a20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000023cu, ImmutableString("textureGradOffset(00f30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003afu,
              ImmutableString("textureProjGradOffset(00I20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000005fu,
              ImmutableString("textureProjGradOffset(00R20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000013bu,
              ImmutableString("textureProjGradOffset(00X20B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000292u,
              ImmutableString("textureProjGradOffset(00I30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003d9u,
              ImmutableString("textureProjGradOffset(00R30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x0000010fu,
              ImmutableString("textureProjGradOffset(00X30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x000003e3u,
              ImmutableString("textureProjGradOffset(00J30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000127u,
              ImmutableString("textureProjGradOffset(00S30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x0000039bu,
              ImmutableString("textureProjGradOffset(00Y30B20B20B20D").mangledNameHash());
    ASSERT_EQ(0x00000283u,
              ImmutableString("textureProjGradOffset(00d30B10B10B10D").mangledNameHash());
    ASSERT_EQ(0x00000110u, ImmutableString("textureOffset(00I10B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000026fu, ImmutableString("textureOffset(00R10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000002e7u, ImmutableString("textureOffset(00X10B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000dau, ImmutableString("textureOffset(00J20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000298u, ImmutableString("textureOffset(00S20B20D00B").mangledNameHash());
    ASSERT_EQ(0x000000a9u, ImmutableString("textureOffset(00Y20B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000296u, ImmutableString("textureOffset(00d20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000000d5u, ImmutableString("textureOffset(00L20B10D00B").mangledNameHash());
    ASSERT_EQ(0x000001c8u, ImmutableString("textureOffset(00U20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000240u, ImmutableString("textureOffset(00a20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("textureProjOffset(00I20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000029bu, ImmutableString("textureProjOffset(00R20B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000010cu, ImmutableString("textureProjOffset(00X20B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000382u, ImmutableString("textureProjOffset(00I30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000003cau, ImmutableString("textureProjOffset(00R30B10D00B").mangledNameHash());
    ASSERT_EQ(0x000003dbu, ImmutableString("textureProjOffset(00X30B10D00B").mangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("textureProjOffset(00J30B20D00B").mangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("textureProjOffset(00S30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000002eeu, ImmutableString("textureProjOffset(00Y30B20D00B").mangledNameHash());
    ASSERT_EQ(0x000003a0u, ImmutableString("textureProjOffset(00d30B10D00B").mangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("texture(00M10B").mangledNameHash());
    ASSERT_EQ(0x000000c1u, ImmutableString("textureProj(00M20B").mangledNameHash());
    ASSERT_EQ(0x00000342u, ImmutableString("textureProj(00M30B").mangledNameHash());
    ASSERT_EQ(0x0000034fu, ImmutableString("textureSize(00M00D").mangledNameHash());
    ASSERT_EQ(0x000000a6u, ImmutableString("texelFetch(00M10D00D").mangledNameHash());
    ASSERT_EQ(0x00000134u, ImmutableString("texture(00N10B").mangledNameHash());
    ASSERT_EQ(0x00000389u, ImmutableString("textureProj(00N20B").mangledNameHash());
    ASSERT_EQ(0x00000284u, ImmutableString("textureProj(00N30B").mangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("rgb_2_yuv(20B00H").mangledNameHash());
    ASSERT_EQ(0x000001c4u, ImmutableString("yuv_2_rgb(20B00H").mangledNameHash());
    ASSERT_EQ(0x0000022du, ImmutableString("textureSize(00N00D").mangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("texelFetch(00N10D00D").mangledNameHash());
    ASSERT_EQ(0x0000026au, ImmutableString("textureGather(00I10B").mangledNameHash());
    ASSERT_EQ(0x0000033au, ImmutableString("textureGather(00R10B").mangledNameHash());
    ASSERT_EQ(0x00000241u, ImmutableString("textureGather(00X10B").mangledNameHash());
    ASSERT_EQ(0x00000143u, ImmutableString("textureGather(00I10B00D").mangledNameHash());
    ASSERT_EQ(0x000002f3u, ImmutableString("textureGather(00R10B00D").mangledNameHash());
    ASSERT_EQ(0x000001ddu, ImmutableString("textureGather(00X10B00D").mangledNameHash());
    ASSERT_EQ(0x00000229u, ImmutableString("textureGather(00L20B").mangledNameHash());
    ASSERT_EQ(0x000002f6u, ImmutableString("textureGather(00U20B").mangledNameHash());
    ASSERT_EQ(0x00000244u, ImmutableString("textureGather(00a20B").mangledNameHash());
    ASSERT_EQ(0x00000126u, ImmutableString("textureGather(00L20B00D").mangledNameHash());
    ASSERT_EQ(0x0000032au, ImmutableString("textureGather(00U20B00D").mangledNameHash());
    ASSERT_EQ(0x000003e2u, ImmutableString("textureGather(00a20B00D").mangledNameHash());
    ASSERT_EQ(0x000000e4u, ImmutableString("textureGather(00K20B").mangledNameHash());
    ASSERT_EQ(0x000003e1u, ImmutableString("textureGather(00T20B").mangledNameHash());
    ASSERT_EQ(0x00000293u, ImmutableString("textureGather(00Z20B").mangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("textureGather(00K20B00D").mangledNameHash());
    ASSERT_EQ(0x00000388u, ImmutableString("textureGather(00T20B00D").mangledNameHash());
    ASSERT_EQ(0x00000339u, ImmutableString("textureGather(00Z20B00D").mangledNameHash());
    ASSERT_EQ(0x0000018eu, ImmutableString("textureGather(00d10B").mangledNameHash());
    ASSERT_EQ(0x000003bau, ImmutableString("textureGather(00d10B00B").mangledNameHash());
    ASSERT_EQ(0x0000014eu, ImmutableString("textureGather(00f20B").mangledNameHash());
    ASSERT_EQ(0x000001c5u, ImmutableString("textureGather(00f20B00B").mangledNameHash());
    ASSERT_EQ(0x0000037au, ImmutableString("textureGather(00e20B").mangledNameHash());
    ASSERT_EQ(0x00000169u, ImmutableString("textureGather(00e20B00B").mangledNameHash());
    ASSERT_EQ(0x00000363u,
              ImmutableString("textureGatherOffsets(00I10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000003e8u,
              ImmutableString("textureGatherOffsets(00R10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000002eu,
              ImmutableString("textureGatherOffsets(00X10B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x000002a2u,
              ImmutableString("textureGatherOffsets(00L20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000013u,
              ImmutableString("textureGatherOffsets(00U20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x0000021eu,
              ImmutableString("textureGatherOffsets(00a20B10Dx400D").mangledNameHash());
    ASSERT_EQ(0x00000257u, ImmutableString("textureGatherOffsets(00I10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000202u, ImmutableString("textureGatherOffsets(00R10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("textureGatherOffsets(00X10B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000242u, ImmutableString("textureGatherOffsets(00L20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("textureGatherOffsets(00U20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000012cu, ImmutableString("textureGatherOffsets(00a20B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000003a2u,
              ImmutableString("textureGatherOffsets(00d10B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x0000029fu,
              ImmutableString("textureGatherOffsets(00f20B00B10Dx4").mangledNameHash());
    ASSERT_EQ(0x000001dcu, ImmutableString("textureGatherOffset(00I10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000206u, ImmutableString("textureGatherOffset(00R10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000398u, ImmutableString("textureGatherOffset(00X10B10D00D").mangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("textureGatherOffset(00L20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000f1u, ImmutableString("textureGatherOffset(00U20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000d3u, ImmutableString("textureGatherOffset(00a20B10D00D").mangledNameHash());
    ASSERT_EQ(0x000000d4u, ImmutableString("textureGatherOffset(00I10B10D").mangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("textureGatherOffset(00R10B10D").mangledNameHash());
    ASSERT_EQ(0x00000323u, ImmutableString("textureGatherOffset(00X10B10D").mangledNameHash());
    ASSERT_EQ(0x00000280u, ImmutableString("textureGatherOffset(00L20B10D").mangledNameHash());
    ASSERT_EQ(0x000002efu, ImmutableString("textureGatherOffset(00U20B10D").mangledNameHash());
    ASSERT_EQ(0x00000263u, ImmutableString("textureGatherOffset(00a20B10D").mangledNameHash());
    ASSERT_EQ(0x00000247u, ImmutableString("textureGatherOffset(00d10B00B10D").mangledNameHash());
    ASSERT_EQ(0x000002c5u, ImmutableString("textureGatherOffset(00f20B00B10D").mangledNameHash());
    ASSERT_EQ(0x000000deu, ImmutableString("atomicCounter(00G").mangledNameHash());
    ASSERT_EQ(0x0000038du, ImmutableString("atomicCounterIncrement(00G").mangledNameHash());
    ASSERT_EQ(0x000000aau, ImmutableString("atomicCounterDecrement(00G").mangledNameHash());
    ASSERT_EQ(0x00000271u, ImmutableString("atomicAdd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("atomicAdd(00D00D").mangledNameHash());
    ASSERT_EQ(0x00000165u, ImmutableString("atomicMin(00E00E").mangledNameHash());
    ASSERT_EQ(0x000003b6u, ImmutableString("atomicMin(00D00D").mangledNameHash());
    ASSERT_EQ(0x000003b4u, ImmutableString("atomicMax(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000228u, ImmutableString("atomicMax(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000ccu, ImmutableString("atomicAnd(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("atomicAnd(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000bdu, ImmutableString("atomicOr(00E00E").mangledNameHash());
    ASSERT_EQ(0x000003e9u, ImmutableString("atomicOr(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000aeu, ImmutableString("atomicXor(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("atomicXor(00D00D").mangledNameHash());
    ASSERT_EQ(0x000000b9u, ImmutableString("atomicExchange(00E00E").mangledNameHash());
    ASSERT_EQ(0x00000205u, ImmutableString("atomicExchange(00D00D").mangledNameHash());
    ASSERT_EQ(0x0000035au, ImmutableString("atomicCompSwap(00E00E00E").mangledNameHash());
    ASSERT_EQ(0x000001c3u, ImmutableString("atomicCompSwap(00D00D00D").mangledNameHash());
    ASSERT_EQ(0x000001bcu, ImmutableString("imageSize(00z").mangledNameHash());
    ASSERT_EQ(0x000002bfu, ImmutableString("imageSize(01A").mangledNameHash());
    ASSERT_EQ(0x0000024du, ImmutableString("imageSize(01B").mangledNameHash());
    ASSERT_EQ(0x00000310u, ImmutableString("imageSize(01C").mangledNameHash());
    ASSERT_EQ(0x000002cbu, ImmutableString("imageSize(01D").mangledNameHash());
    ASSERT_EQ(0x000002bau, ImmutableString("imageSize(01E").mangledNameHash());
    ASSERT_EQ(0x00000179u, ImmutableString("imageSize(01F").mangledNameHash());
    ASSERT_EQ(0x00000314u, ImmutableString("imageSize(01G").mangledNameHash());
    ASSERT_EQ(0x00000309u, ImmutableString("imageSize(01H").mangledNameHash());
    ASSERT_EQ(0x0000030au, ImmutableString("imageSize(01I").mangledNameHash());
    ASSERT_EQ(0x00000307u, ImmutableString("imageSize(01J").mangledNameHash());
    ASSERT_EQ(0x00000308u, ImmutableString("imageSize(01K").mangledNameHash());
    ASSERT_EQ(0x00000285u, ImmutableString("imageSize(01a").mangledNameHash());
    ASSERT_EQ(0x00000328u, ImmutableString("imageSize(01b").mangledNameHash());
    ASSERT_EQ(0x00000324u, ImmutableString("imageSize(01c").mangledNameHash());
    ASSERT_EQ(0x00000215u, ImmutableString("imageLoad(00z10D").mangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("imageLoad(01A10D").mangledNameHash());
    ASSERT_EQ(0x000001f0u, ImmutableString("imageLoad(01B10D").mangledNameHash());
    ASSERT_EQ(0x00000306u, ImmutableString("imageLoad(01C20D").mangledNameHash());
    ASSERT_EQ(0x00000391u, ImmutableString("imageLoad(01D20D").mangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("imageLoad(01E20D").mangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("imageLoad(01F20D").mangledNameHash());
    ASSERT_EQ(0x0000021bu, ImmutableString("imageLoad(01G20D").mangledNameHash());
    ASSERT_EQ(0x000000e3u, ImmutableString("imageLoad(01H20D").mangledNameHash());
    ASSERT_EQ(0x000000e0u, ImmutableString("imageLoad(01I20D").mangledNameHash());
    ASSERT_EQ(0x000001e6u, ImmutableString("imageLoad(01J20D").mangledNameHash());
    ASSERT_EQ(0x000003c9u, ImmutableString("imageLoad(01K20D").mangledNameHash());
    ASSERT_EQ(0x000003d5u, ImmutableString("imageLoad(01a20D").mangledNameHash());
    ASSERT_EQ(0x000000c0u, ImmutableString("imageLoad(01b20D").mangledNameHash());
    ASSERT_EQ(0x000000adu, ImmutableString("imageLoad(01c20D").mangledNameHash());
    ASSERT_EQ(0x00000107u, ImmutableString("imageStore(00z10D30B").mangledNameHash());
    ASSERT_EQ(0x00000128u, ImmutableString("imageStore(01A10D30D").mangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("imageStore(01B10D30E").mangledNameHash());
    ASSERT_EQ(0x00000302u, ImmutableString("imageStore(01C20D30B").mangledNameHash());
    ASSERT_EQ(0x0000028au, ImmutableString("imageStore(01D20D30D").mangledNameHash());
    ASSERT_EQ(0x00000184u, ImmutableString("imageStore(01E20D30E").mangledNameHash());
    ASSERT_EQ(0x0000012eu, ImmutableString("imageStore(01F20D30B").mangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("imageStore(01G20D30D").mangledNameHash());
    ASSERT_EQ(0x000002f4u, ImmutableString("imageStore(01H20D30E").mangledNameHash());
    ASSERT_EQ(0x000000acu, ImmutableString("imageStore(01I20D30B").mangledNameHash());
    ASSERT_EQ(0x000000ddu, ImmutableString("imageStore(01J20D30D").mangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("imageStore(01K20D30E").mangledNameHash());
    ASSERT_EQ(0x000001a5u, ImmutableString("imageStore(01a20D30B").mangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("imageStore(01b20D30D").mangledNameHash());
    ASSERT_EQ(0x000003a5u, ImmutableString("imageStore(01c20D30E").mangledNameHash());
    ASSERT_EQ(0x00000369u, ImmutableString("memoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("memoryBarrierAtomicCounter(").mangledNameHash());
    ASSERT_EQ(0x000001bau, ImmutableString("memoryBarrierBuffer(").mangledNameHash());
    ASSERT_EQ(0x0000039du, ImmutableString("memoryBarrierImage(").mangledNameHash());
    ASSERT_EQ(0x00000136u, ImmutableString("barrier(").mangledNameHash());
    ASSERT_EQ(0x00000212u, ImmutableString("memoryBarrierShared(").mangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("groupMemoryBarrier(").mangledNameHash());
    ASSERT_EQ(0x0000039fu, ImmutableString("EmitVertex(").mangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("EndPrimitive(").mangledNameHash());
    ASSERT_EQ(0x00000199u, ImmutableString("textureVideoWEBGL(00y10B").mangledNameHash());
    ASSERT_EQ(0x00000150u, ImmutableString("texture(00y10B").mangledNameHash());
    ASSERT_EQ(0x000000b7u, ImmutableString("gl_DepthRangeParameters").mangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("gl_DepthRange").mangledNameHash());
    ASSERT_EQ(0x00000347u, ImmutableString("gl_MaxVertexAttribs").mangledNameHash());
    ASSERT_EQ(0x00000386u, ImmutableString("gl_MaxVertexUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("gl_MaxVertexTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000166u, ImmutableString("gl_MaxCombinedTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000357u, ImmutableString("gl_MaxTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x0000031fu, ImmutableString("gl_MaxFragmentUniformVectors").mangledNameHash());
    ASSERT_EQ(0x00000381u, ImmutableString("gl_MaxVaryingVectors").mangledNameHash());
    ASSERT_EQ(0x000000f0u, ImmutableString("gl_MaxDrawBuffers").mangledNameHash());
    ASSERT_EQ(0x000002a1u, ImmutableString("gl_MaxDualSourceDrawBuffersEXT").mangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("gl_MaxVertexOutputVectors").mangledNameHash());
    ASSERT_EQ(0x000003a9u, ImmutableString("gl_MaxFragmentInputVectors").mangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("gl_MinProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x000000b3u, ImmutableString("gl_MaxProgramTexelOffset").mangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("gl_MaxImageUnits").mangledNameHash());
    ASSERT_EQ(0x000001f7u, ImmutableString("gl_MaxVertexImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000000b5u, ImmutableString("gl_MaxFragmentImageUniforms").mangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("gl_MaxComputeImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000001c2u, ImmutableString("gl_MaxCombinedImageUniforms").mangledNameHash());
    ASSERT_EQ(0x000000bcu,
              ImmutableString("gl_MaxCombinedShaderOutputResources").mangledNameHash());
    ASSERT_EQ(0x0000031cu, ImmutableString("gl_MaxComputeWorkGroupCount").mangledNameHash());
    ASSERT_EQ(0x00000161u, ImmutableString("gl_MaxComputeWorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x000002f2u, ImmutableString("gl_MaxComputeUniformComponents").mangledNameHash());
    ASSERT_EQ(0x0000011fu, ImmutableString("gl_MaxComputeTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x000003bcu, ImmutableString("gl_MaxComputeAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x000000cfu, ImmutableString("gl_MaxComputeAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000003beu, ImmutableString("gl_MaxVertexAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x000002b5u, ImmutableString("gl_MaxFragmentAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000301u, ImmutableString("gl_MaxCombinedAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("gl_MaxAtomicCounterBindings").mangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("gl_MaxVertexAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000001fau, ImmutableString("gl_MaxFragmentAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x00000258u, ImmutableString("gl_MaxCombinedAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000002c3u, ImmutableString("gl_MaxAtomicCounterBufferSize").mangledNameHash());
    ASSERT_EQ(0x00000272u, ImmutableString("gl_MaxGeometryInputComponents").mangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("gl_MaxGeometryOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000367u, ImmutableString("gl_MaxGeometryImageUniforms").mangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("gl_MaxGeometryTextureImageUnits").mangledNameHash());
    ASSERT_EQ(0x00000129u, ImmutableString("gl_MaxGeometryOutputVertices").mangledNameHash());
    ASSERT_EQ(0x000002d7u,
              ImmutableString("gl_MaxGeometryTotalOutputComponents").mangledNameHash());
    ASSERT_EQ(0x00000137u, ImmutableString("gl_MaxGeometryUniformComponents").mangledNameHash());
    ASSERT_EQ(0x00000207u, ImmutableString("gl_MaxGeometryAtomicCounters").mangledNameHash());
    ASSERT_EQ(0x0000010eu, ImmutableString("gl_MaxGeometryAtomicCounterBuffers").mangledNameHash());
    ASSERT_EQ(0x000000b0u, ImmutableString("gl_FragCoord").mangledNameHash());
    ASSERT_EQ(0x00000319u, ImmutableString("gl_FrontFacing").mangledNameHash());
    ASSERT_EQ(0x0000012bu, ImmutableString("gl_PointCoord").mangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("gl_FragColor").mangledNameHash());
    ASSERT_EQ(0x0000032du, ImmutableString("gl_FragData").mangledNameHash());
    ASSERT_EQ(0x00000192u, ImmutableString("gl_FragDepth").mangledNameHash());
    ASSERT_EQ(0x00000227u, ImmutableString("gl_HelperInvocation").mangledNameHash());
    ASSERT_EQ(0x0000031au, ImmutableString("gl_SecondaryFragColorEXT").mangledNameHash());
    ASSERT_EQ(0x000001d4u, ImmutableString("gl_SecondaryFragDataEXT").mangledNameHash());
    ASSERT_EQ(0x000002a7u, ImmutableString("gl_FragDepthEXT").mangledNameHash());
    ASSERT_EQ(0x00000163u, ImmutableString("gl_LastFragData").mangledNameHash());
    ASSERT_EQ(0x0000017eu, ImmutableString("gl_LastFragColor").mangledNameHash());
    ASSERT_EQ(0x00000338u, ImmutableString("gl_LastFragColorARM").mangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("gl_PrimitiveID").mangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("gl_Layer").mangledNameHash());
    ASSERT_EQ(0x000001a6u, ImmutableString("gl_Position").mangledNameHash());
    ASSERT_EQ(0x000003b5u, ImmutableString("gl_PointSize").mangledNameHash());
    ASSERT_EQ(0x000001f5u, ImmutableString("gl_InstanceID").mangledNameHash());
    ASSERT_EQ(0x00000340u, ImmutableString("gl_VertexID").mangledNameHash());
    ASSERT_EQ(0x000003e7u, ImmutableString("gl_DrawID").mangledNameHash());
    ASSERT_EQ(0x000002cau, ImmutableString("gl_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x00000348u, ImmutableString("gl_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("angle_BaseVertex").mangledNameHash());
    ASSERT_EQ(0x00000354u, ImmutableString("angle_BaseInstance").mangledNameHash());
    ASSERT_EQ(0x00000189u, ImmutableString("gl_ClipDistance").mangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("gl_MaxClipDistances").mangledNameHash());
    ASSERT_EQ(0x000002ecu, ImmutableString("gl_NumWorkGroups").mangledNameHash());
    ASSERT_EQ(0x00000337u, ImmutableString("gl_WorkGroupSize").mangledNameHash());
    ASSERT_EQ(0x000001fbu, ImmutableString("gl_WorkGroupID").mangledNameHash());
    ASSERT_EQ(0x0000018bu, ImmutableString("gl_LocalInvocationID").mangledNameHash());
    ASSERT_EQ(0x00000210u, ImmutableString("gl_GlobalInvocationID").mangledNameHash());
    ASSERT_EQ(0x000001dau, ImmutableString("gl_LocalInvocationIndex").mangledNameHash());
    ASSERT_EQ(0x000000d0u, ImmutableString("gl_PrimitiveIDIn").mangledNameHash());
    ASSERT_EQ(0x0000015bu, ImmutableString("gl_InvocationID").mangledNameHash());
    ASSERT_EQ(0x00000225u, ImmutableString("gl_PerVertex").mangledNameHash());
    ASSERT_EQ(0x000001e9u, ImmutableString("gl_in").mangledNameHash());
    ASSERT_EQ(0x0000022au, ImmutableString("gl_ViewID_OVR").mangledNameHash());
    ASSERT_EQ(0x0000001du, ImmutableString("radians").unmangledNameHash());
    ASSERT_EQ(0x00000010u, ImmutableString("degrees").unmangledNameHash());
    ASSERT_EQ(0x00000080u, ImmutableString("sin").unmangledNameHash());
    ASSERT_EQ(0x00000043u, ImmutableString("cos").unmangledNameHash());
    ASSERT_EQ(0x00000075u, ImmutableString("tan").unmangledNameHash());
    ASSERT_EQ(0x0000002cu, ImmutableString("asin").unmangledNameHash());
    ASSERT_EQ(0x0000004au, ImmutableString("acos").unmangledNameHash());
    ASSERT_EQ(0x00000083u, ImmutableString("atan").unmangledNameHash());
    ASSERT_EQ(0x00000040u, ImmutableString("sinh").unmangledNameHash());
    ASSERT_EQ(0x0000002au, ImmutableString("cosh").unmangledNameHash());
    ASSERT_EQ(0x0000006au, ImmutableString("tanh").unmangledNameHash());
    ASSERT_EQ(0x00000072u, ImmutableString("asinh").unmangledNameHash());
    ASSERT_EQ(0x00000029u, ImmutableString("acosh").unmangledNameHash());
    ASSERT_EQ(0x0000007cu, ImmutableString("atanh").unmangledNameHash());
    ASSERT_EQ(0x0000004fu, ImmutableString("pow").unmangledNameHash());
    ASSERT_EQ(0x00000093u, ImmutableString("exp").unmangledNameHash());
    ASSERT_EQ(0x00000058u, ImmutableString("log").unmangledNameHash());
    ASSERT_EQ(0x0000005au, ImmutableString("exp2").unmangledNameHash());
    ASSERT_EQ(0x00000038u, ImmutableString("log2").unmangledNameHash());
    ASSERT_EQ(0x0000007eu, ImmutableString("sqrt").unmangledNameHash());
    ASSERT_EQ(0x00000068u, ImmutableString("inversesqrt").unmangledNameHash());
    ASSERT_EQ(0x00000035u, ImmutableString("abs").unmangledNameHash());
    ASSERT_EQ(0x00000067u, ImmutableString("sign").unmangledNameHash());
    ASSERT_EQ(0x0000007au, ImmutableString("floor").unmangledNameHash());
    ASSERT_EQ(0x00000042u, ImmutableString("trunc").unmangledNameHash());
    ASSERT_EQ(0x00000024u, ImmutableString("round").unmangledNameHash());
    ASSERT_EQ(0x00000015u, ImmutableString("roundEven").unmangledNameHash());
    ASSERT_EQ(0x00000018u, ImmutableString("ceil").unmangledNameHash());
    ASSERT_EQ(0x0000005cu, ImmutableString("fract").unmangledNameHash());
    ASSERT_EQ(0x0000001bu, ImmutableString("mod").unmangledNameHash());
    ASSERT_EQ(0x00000090u, ImmutableString("min").unmangledNameHash());
    ASSERT_EQ(0x00000036u, ImmutableString("max").unmangledNameHash());
    ASSERT_EQ(0x00000026u, ImmutableString("clamp").unmangledNameHash());
    ASSERT_EQ(0x0000007fu, ImmutableString("mix").unmangledNameHash());
    ASSERT_EQ(0x0000003fu, ImmutableString("step").unmangledNameHash());
    ASSERT_EQ(0x0000001eu, ImmutableString("smoothstep").unmangledNameHash());
    ASSERT_EQ(0x00000022u, ImmutableString("modf").unmangledNameHash());
    ASSERT_EQ(0x0000002du, ImmutableString("isnan").unmangledNameHash());
    ASSERT_EQ(0x00000086u, ImmutableString("isinf").unmangledNameHash());
    ASSERT_EQ(0x0000001cu, ImmutableString("floatBitsToInt").unmangledNameHash());
    ASSERT_EQ(0x00000052u, ImmutableString("floatBitsToUint").unmangledNameHash());
    ASSERT_EQ(0x0000006eu, ImmutableString("intBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000004bu, ImmutableString("uintBitsToFloat").unmangledNameHash());
    ASSERT_EQ(0x0000005fu, ImmutableString("fma").unmangledNameHash());
    ASSERT_EQ(0x0000000fu, ImmutableString("frexp").unmangledNameHash());
    ASSERT_EQ(0x00000051u, ImmutableString("ldexp").unmangledNameHash());
    ASSERT_EQ(0x00000092u, ImmutableString("packSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000096u, ImmutableString("packHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x00000037u, ImmutableString("unpackSnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x0000004du, ImmutableString("unpackHalf2x16").unmangledNameHash());
    ASSERT_EQ(0x0000004cu, ImmutableString("packUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000084u, ImmutableString("unpackUnorm2x16").unmangledNameHash());
    ASSERT_EQ(0x00000066u, ImmutableString("packUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x0000000bu, ImmutableString("packSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000002u, ImmutableString("unpackUnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000023u, ImmutableString("unpackSnorm4x8").unmangledNameHash());
    ASSERT_EQ(0x00000048u, ImmutableString("length").unmangledNameHash());
    ASSERT_EQ(0x00000069u, ImmutableString("distance").unmangledNameHash());
    ASSERT_EQ(0x00000098u, ImmutableString("dot").unmangledNameHash());
    ASSERT_EQ(0x0000007du, ImmutableString("cross").unmangledNameHash());
    ASSERT_EQ(0x00000078u, ImmutableString("normalize").unmangledNameHash());
    ASSERT_EQ(0x00000034u, ImmutableString("faceforward").unmangledNameHash());
    ASSERT_EQ(0x00000085u, ImmutableString("reflect").unmangledNameHash());
    ASSERT_EQ(0x0000008fu, ImmutableString("refract").unmangledNameHash());
    ASSERT_EQ(0x0000004eu, ImmutableString("matrixCompMult").unmangledNameHash());
    ASSERT_EQ(0x0000008du, ImmutableString("outerProduct").unmangledNameHash());
    ASSERT_EQ(0x0000003eu, ImmutableString("transpose").unmangledNameHash());
    ASSERT_EQ(0x00000060u, ImmutableString("determinant").unmangledNameHash());
    ASSERT_EQ(0x0000000cu, ImmutableString("inverse").unmangledNameHash());
    ASSERT_EQ(0x00000020u, ImmutableString("lessThan").unmangledNameHash());
    ASSERT_EQ(0x0000003du, ImmutableString("lessThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000063u, ImmutableString("greaterThan").unmangledNameHash());
    ASSERT_EQ(0x00000062u, ImmutableString("greaterThanEqual").unmangledNameHash());
    ASSERT_EQ(0x00000044u, ImmutableString("equal").unmangledNameHash());
    ASSERT_EQ(0x0000008cu, ImmutableString("notEqual").unmangledNameHash());
    ASSERT_EQ(0x00000076u, ImmutableString("any").unmangledNameHash());
    ASSERT_EQ(0x00000000u, ImmutableString("all").unmangledNameHash());
    ASSERT_EQ(0x00000019u, ImmutableString("not").unmangledNameHash());
    ASSERT_EQ(0x0000006fu, ImmutableString("bitfieldExtract").unmangledNameHash());
    ASSERT_EQ(0x00000064u, ImmutableString("bitfieldInsert").unmangledNameHash());
    ASSERT_EQ(0x0000002fu, ImmutableString("bitfieldReverse").unmangledNameHash());
    ASSERT_EQ(0x00000059u, ImmutableString("bitCount").unmangledNameHash());
    ASSERT_EQ(0x00000008u, ImmutableString("findLSB").unmangledNameHash());
    ASSERT_EQ(0x00000027u, ImmutableString("findMSB").unmangledNameHash());
    ASSERT_EQ(0x0000002bu, ImmutableString("uaddCarry").unmangledNameHash());
    ASSERT_EQ(0x00000046u, ImmutableString("usubBorrow").unmangledNameHash());
    ASSERT_EQ(0x00000088u, ImmutableString("umulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000011u, ImmutableString("imulExtended").unmangledNameHash());
    ASSERT_EQ(0x00000073u, ImmutableString("texture2D").unmangledNameHash());
    ASSERT_EQ(0x0000003bu, ImmutableString("texture2DProj").unmangledNameHash());
    ASSERT_EQ(0x00000091u, ImmutableString("textureCube").unmangledNameHash());
    ASSERT_EQ(0x00000028u, ImmutableString("texture2DRect").unmangledNameHash());
    ASSERT_EQ(0x0000001au, ImmutableString("texture2DRectProj").unmangledNameHash());
    ASSERT_EQ(0x0000000eu, ImmutableString("texture").unmangledNameHash());
    ASSERT_EQ(0x00000001u, ImmutableString("textureProj").unmangledNameHash());
    ASSERT_EQ(0x0000006bu, ImmutableString("texture2DGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000012u, ImmutableString("texture2DProjGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000009u, ImmutableString("textureCubeGradEXT").unmangledNameHash());
    ASSERT_EQ(0x00000030u, ImmutableString("dFdx").unmangledNameHash());
    ASSERT_EQ(0x00000021u, ImmutableString("dFdy").unmangledNameHash());
    ASSERT_EQ(0x00000004u, ImmutableString("fwidth").unmangledNameHash());
    ASSERT_EQ(0x00000045u, ImmutableString("texture2DLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000016u, ImmutableString("texture2DProjLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000054u, ImmutableString("textureCubeLodEXT").unmangledNameHash());
    ASSERT_EQ(0x00000087u, ImmutableString("texture3D").unmangledNameHash());
    ASSERT_EQ(0x00000065u, ImmutableString("texture3DProj").unmangledNameHash());
    ASSERT_EQ(0x00000032u, ImmutableString("texture3DLod").unmangledNameHash());
    ASSERT_EQ(0x00000070u, ImmutableString("texture3DProjLod").unmangledNameHash());
    ASSERT_EQ(0x00000097u, ImmutableString("texture2DLod").unmangledNameHash());
    ASSERT_EQ(0x00000050u, ImmutableString("texture2DProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000000du, ImmutableString("textureCubeLod").unmangledNameHash());
    ASSERT_EQ(0x00000033u, ImmutableString("textureLod").unmangledNameHash());
    ASSERT_EQ(0x00000049u, ImmutableString("textureSize").unmangledNameHash());
    ASSERT_EQ(0x00000053u, ImmutableString("textureProjLod").unmangledNameHash());
    ASSERT_EQ(0x0000008au, ImmutableString("texelFetch").unmangledNameHash());
    ASSERT_EQ(0x00000039u, ImmutableString("textureGrad").unmangledNameHash());
    ASSERT_EQ(0x0000001fu, ImmutableString("textureProjGrad").unmangledNameHash());
    ASSERT_EQ(0x00000061u, ImmutableString("textureGather").unmangledNameHash());
    ASSERT_EQ(0x00000025u, ImmutableString("textureOffset").unmangledNameHash());
    ASSERT_EQ(0x00000041u, ImmutableString("textureProjOffset").unmangledNameHash());
    ASSERT_EQ(0x0000007bu, ImmutableString("textureLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000057u, ImmutableString("textureProjLodOffset").unmangledNameHash());
    ASSERT_EQ(0x00000047u, ImmutableString("texelFetchOffset").unmangledNameHash());
    ASSERT_EQ(0x00000082u, ImmutableString("textureGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000014u, ImmutableString("textureProjGradOffset").unmangledNameHash());
    ASSERT_EQ(0x00000005u, ImmutableString("rgb_2_yuv").unmangledNameHash());
    ASSERT_EQ(0x00000007u, ImmutableString("yuv_2_rgb").unmangledNameHash());
    ASSERT_EQ(0x0000005eu, ImmutableString("textureGatherOffsets").unmangledNameHash());
    ASSERT_EQ(0x00000056u, ImmutableString("textureGatherOffset").unmangledNameHash());
    ASSERT_EQ(0x0000006du, ImmutableString("atomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000006u, ImmutableString("atomicCounterIncrement").unmangledNameHash());
    ASSERT_EQ(0x0000003cu, ImmutableString("atomicCounterDecrement").unmangledNameHash());
    ASSERT_EQ(0x00000071u, ImmutableString("atomicAdd").unmangledNameHash());
    ASSERT_EQ(0x00000095u, ImmutableString("atomicMin").unmangledNameHash());
    ASSERT_EQ(0x0000002eu, ImmutableString("atomicMax").unmangledNameHash());
    ASSERT_EQ(0x00000013u, ImmutableString("atomicAnd").unmangledNameHash());
    ASSERT_EQ(0x00000089u, ImmutableString("atomicOr").unmangledNameHash());
    ASSERT_EQ(0x00000077u, ImmutableString("atomicXor").unmangledNameHash());
    ASSERT_EQ(0x00000081u, ImmutableString("atomicExchange").unmangledNameHash());
    ASSERT_EQ(0x0000005bu, ImmutableString("atomicCompSwap").unmangledNameHash());
    ASSERT_EQ(0x0000008eu, ImmutableString("imageSize").unmangledNameHash());
    ASSERT_EQ(0x00000079u, ImmutableString("imageLoad").unmangledNameHash());
    ASSERT_EQ(0x00000055u, ImmutableString("imageStore").unmangledNameHash());
    ASSERT_EQ(0x0000006cu, ImmutableString("memoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x00000017u, ImmutableString("memoryBarrierAtomicCounter").unmangledNameHash());
    ASSERT_EQ(0x00000074u, ImmutableString("memoryBarrierBuffer").unmangledNameHash());
    ASSERT_EQ(0x0000000au, ImmutableString("memoryBarrierImage").unmangledNameHash());
    ASSERT_EQ(0x0000003au, ImmutableString("barrier").unmangledNameHash());
    ASSERT_EQ(0x00000031u, ImmutableString("memoryBarrierShared").unmangledNameHash());
    ASSERT_EQ(0x00000094u, ImmutableString("groupMemoryBarrier").unmangledNameHash());
    ASSERT_EQ(0x0000005du, ImmutableString("EmitVertex").unmangledNameHash());
    ASSERT_EQ(0x0000008bu, ImmutableString("EndPrimitive").unmangledNameHash());
    ASSERT_EQ(0x00000003u, ImmutableString("textureVideoWEBGL").unmangledNameHash());
}

}  // namespace sh
