/*
 * Copyright (C) 2013 ~ 2014 National University of Defense Technology(NUDT) & Kylin Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef HTTPDOWNLOAD_H
#define HTTPDOWNLOAD_H

#include <QObject>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QFile>

class HttpDownLoad : public QObject
{
    Q_OBJECT
public:
    explicit HttpDownLoad(QObject *parent = 0);
     ~HttpDownLoad();
    void sendDownLoadRequest(const QUrl &url);
    void startRequest(QUrl url);//请求链接

public slots:
    void httpFinished();//完成下载
    void httpReadyRead();//接收到数据
//    void updateDataReadProgress(qint64,qint64);//更新进度

signals:
    void downloadok();
    
private:
    QNetworkAccessManager *mManager;
    QNetworkReply *reply;
    QUrl url;//存储网络地址
    QFile *file;//文件指针
};

#endif // HTTPDOWNLOAD_H
