/*
 * Copyright (C) 2013 ~ 2015 National University of Defense Technology(NUDT) & Kylin Ltd.
 *
 * Authors:
 *  Kobe Lee    xiangli@ubuntukylin.com/kobe24_lixiang@126.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "windowwidget.h"
#include <QLabel>
#include <QComboBox>
#include <QHBoxLayout>
#include "../dbusproxy/youkersessiondbus.h"

WindowWidget::WindowWidget(QWidget *parent, SessionDispatcher *proxy) :
    QWidget(parent),
    sessionproxy(proxy)
{
    icon_label = new QLabel();
    wheel_label = new QLabel();
    double_click_label = new QLabel();
    middle_click_label = new QLabel();
    right_click_label = new QLabel();
    icon_switcher = new KylinSwitcher();
    wheel_combo = new QComboBox();
    double_click_combo = new QComboBox();
    middle_click_combo = new QComboBox();
    right_click_combo = new QComboBox();

    icon_label->setFixedWidth(200);
    wheel_label->setFixedWidth(200);
    double_click_label->setFixedWidth(200);
    middle_click_label->setFixedWidth(200);
    right_click_label->setFixedWidth(200);

    QHBoxLayout *layout1 = new QHBoxLayout();
    layout1->setSpacing(10);
    layout1->addWidget(icon_label);
    layout1->addWidget(icon_switcher);
    layout1->addStretch();
    QHBoxLayout *layout2 = new QHBoxLayout();
    layout2->setSpacing(10);
    layout2->addWidget(wheel_label);
    layout2->addWidget(wheel_combo);
    layout2->addStretch();
    QHBoxLayout *layout3 = new QHBoxLayout();
    layout3->setSpacing(10);
    layout3->addWidget(double_click_label);
    layout3->addWidget(double_click_combo);
    layout3->addStretch();
    QHBoxLayout *layout4 = new QHBoxLayout();
    layout4->setSpacing(10);
    layout4->addWidget(middle_click_label);
    layout4->addWidget(middle_click_combo);
    layout4->addStretch();
    QHBoxLayout *layout5 = new QHBoxLayout();
    layout5->setSpacing(10);
    layout5->addWidget(right_click_label);
    layout5->addWidget(right_click_combo);
    layout5->addStretch();
    QVBoxLayout *layout = new QVBoxLayout();
    layout->addLayout(layout1);
    layout->addLayout(layout2);
    layout->addLayout(layout3);
    layout->addLayout(layout4);
    layout->addLayout(layout5);
    layout->addStretch();
    setLayout(layout);
    layout->setSpacing(10);
    layout->setContentsMargins(20, 20, 0, 0);

//    splitter->addWidget(top_widget);
//    splitter->addWidget(bottom_widget);

//    QHBoxLayout *main_layout = new QHBoxLayout;
//    main_layout->addStretch();
//    main_layout->addWidget(splitter);
//    main_layout->setSpacing(0);
//    main_layout->setContentsMargins(0, 0, 0, 0);
//    setLayout(main_layout);
    this->initData();
    this->setLanguage();
    this->initConnect();
}

WindowWidget::~WindowWidget()
{
//    if(label != NULL)
//    {
//        delete label;
//        label = NULL;
//    }
//    if(back_btn != NULL)
//    {
//        delete back_btn;
//        back_btn = NULL;
//    }
}

void WindowWidget::setLanguage() {
//    title_label->setText(tr("Window"));
//    description_label->setText(tr("Window Manager settings."));
//    back_btn->setText(tr("Back"));
    icon_label->setText(tr("Menu with icons") + ":");
    wheel_label->setText(tr("Titlebar mouse wheel action") + ":");
    double_click_label->setText(tr("Titlebar double-click action") + ":");
    middle_click_label->setText(tr("Titlebar middle-click action") + ":");
    right_click_label->setText(tr("Titlebar right-click action") + ":");

}

void WindowWidget::initData()
{

    icon_switcher->switchedOn = sessionproxy->get_menus_have_icons_qt();

    QString current_wheel_type = sessionproxy->get_current_titlebar_wheel_qt();
    QStringList wheellist  = sessionproxy->get_titlebar_wheel_qt();
    wheel_combo->clear();
    wheel_combo->clearEditText();
    wheel_combo->addItems(wheellist);
    QList<QString>::Iterator it1 = wheellist.begin(), itend1 = wheellist.end();
    int initIndex1 = 0;
    for(;it1 != itend1; it1++,initIndex1++)
    {
        if(*it1 == current_wheel_type)
            break;
    }
    wheel_combo->setCurrentIndex(initIndex1);

    QString current_double_type = sessionproxy->get_current_titlebar_double_qt();
    QStringList doublelist  = sessionproxy->get_titlebar_double_qt();
    double_click_combo->clear();
    double_click_combo->clearEditText();
    double_click_combo->addItems(doublelist);
    QList<QString>::Iterator it2 = doublelist.begin(), itend2 = doublelist.end();
    int initIndex2 = 0;
    for(;it2 != itend2; it2++,initIndex2++)
    {
        if(*it2 == current_double_type)
            break;
    }
    double_click_combo->setCurrentIndex(initIndex2);

    QString current_middle_type = sessionproxy->get_current_titlebar_middle_qt();
    QStringList middlelist  = sessionproxy->get_titlebar_middle_qt();
    middle_click_combo->clear();
    middle_click_combo->clearEditText();
    middle_click_combo->addItems(middlelist);
    QList<QString>::Iterator it3 = middlelist.begin(), itend3 = middlelist.end();
    int initIndex3 = 0;
    for(;it3 != itend3; it3++,initIndex3++)
    {
        if(*it3 == current_middle_type)
            break;
    }
    middle_click_combo->setCurrentIndex(initIndex3);

    QString current_right_type = sessionproxy->get_current_titlebar_right_qt();
    QStringList rightlist  = sessionproxy->get_titlebar_right_qt();
    right_click_combo->clear();
    right_click_combo->clearEditText();
    right_click_combo->addItems(rightlist);
    QList<QString>::Iterator it4 = rightlist.begin(), itend4 = rightlist.end();
    int initIndex4 = 0;
    for(;it4 != itend4; it4++,initIndex4++)
    {
        if(*it4 == current_right_type)
            break;
    }
    right_click_combo->setCurrentIndex(initIndex4);
}

void WindowWidget::initConnect() {
//    connect(back_btn, SIGNAL(clicked()), this, SIGNAL(showSettingMainWidget()));
    connect(icon_switcher, SIGNAL(clicked()), this, SLOT(setMenuIcon()));
    connect(wheel_combo, SIGNAL(currentIndexChanged(QString)), this, SLOT(setMouseWheel(QString)));
    connect(double_click_combo, SIGNAL(currentIndexChanged(QString)), this, SLOT(setMouseDoubleClick(QString)));
    connect(middle_click_combo, SIGNAL(currentIndexChanged(QString)), this, SLOT(setMouseMiddleClick(QString)));
    connect(right_click_combo, SIGNAL(currentIndexChanged(QString)), this, SLOT(setMouseRightClick(QString)));
}

void WindowWidget::setMenuIcon()
{
    sessionproxy->set_menus_have_icons_qt(icon_switcher->switchedOn);

}

void WindowWidget::setMouseWheel(QString selected)
{
    sessionproxy->set_titlebar_wheel_qt(selected);
}

void WindowWidget::setMouseDoubleClick(QString selected)
{
    sessionproxy->set_titlebar_double_qt(selected);
}

void WindowWidget::setMouseMiddleClick(QString selected)
{
    sessionproxy->set_titlebar_middle_qt(selected);
}

void WindowWidget::setMouseRightClick(QString selected)
{
    sessionproxy->set_titlebar_right_qt(selected);
}
