
# Remote Zabbix server health

## Overview

For Zabbix version: 6.0 and higher  

## Setup

Refer to the vendor documentation.

## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$ADDRESS} |<p>-</p> |`` |
|{$PORT} |<p>-</p> |`` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|High availability cluster node discovery |<p>LLD rule with item and trigger prototypes for node discovery.</p> |DEPENDENT |zabbix.nodes.discovery<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.ha`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Cluster |Cluster node [{#NODE.NAME}]: Address |<p>Node IPv4 address.</p> |DEPENDENT |zabbix.nodes.address[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.ha[?(@.id=="{#NODE.ID}")].address.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `12h`</p> |
|Cluster |Cluster node [{#NODE.NAME}]: Last access time |<p>Last access time.</p> |DEPENDENT |zabbix.nodes.lastaccess.time[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.ha[?(@.id=="{#NODE.ID}")].lastaccess.first()`</p> |
|Cluster |Cluster node [{#NODE.NAME}]: Last access age |<p>Time between database unix_timestamp() and last access time.</p> |DEPENDENT |zabbix.nodes.lastaccess.age[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.ha[?(@.id=="{#NODE.ID}")].lastaccess_age.first()`</p> |
|Cluster |Cluster node [{#NODE.NAME}]: Status |<p>Node status.</p> |DEPENDENT |zabbix.nodes.status[{#NODE.ID}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.ha[?(@.id=="{#NODE.ID}")].status.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `12h`</p> |
|Zabbix raw items |Remote Zabbix server: Zabbix stats |<p>Zabbix server statistics master item.</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT}] |
|Zabbix server |Remote Zabbix server: Zabbix stats queue over 10m |<p>Number of monitored items in the queue which are delayed at least by 10 minutes.</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT},queue,10m]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix server |Remote Zabbix server: Zabbix stats queue |<p>Number of monitored items in the queue which are delayed at least by 6 seconds.</p> |INTERNAL |zabbix[stats,{$ADDRESS},{$PORT},queue]<p>**Preprocessing**:</p><p>- JSONPATH: `$.queue`</p> |
|Zabbix server |Remote Zabbix server: Utilization of alert manager internal processes, in % |<p>Average percentage of time alert manager processes have been busy in the last minute</p> |DEPENDENT |process.alert_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alert manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes alert manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of alert syncer internal processes, in % |<p>Average percentage of time alert syncer processes have been busy in the last minute</p> |DEPENDENT |process.alert_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alert syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes alert syncer not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of alerter internal processes, in % |<p>Average percentage of time alerter processes have been busy in the last minute</p> |DEPENDENT |process.alerter.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['alerter'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes alerter not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of availability manager internal processes, in % |<p>Average percentage of time availability manager processes have been busy in the last minute</p> |DEPENDENT |process.availability_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['availability manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes availability manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of configuration syncer internal processes, in % |<p>Average percentage of time configuration syncer processes have been busy in the last minute</p> |DEPENDENT |process.configuration_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['configuration syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes configuration syncer not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of discoverer data collector processes, in % |<p>Average percentage of time discoverer processes have been busy in the last minute</p> |DEPENDENT |process.discoverer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['discoverer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes discoverer not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of escalator internal processes, in % |<p>Average percentage of time escalator processes have been busy in the last minute</p> |DEPENDENT |process.escalator.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['escalator'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes escalator not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of history poller data collector processes, in % |<p>Average percentage of time history poller processes have been busy in the last minute</p> |DEPENDENT |process.history_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['history poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes history poller not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of ODBC poller data collector processes, in % |<p>Average percentage of time ODBC poller processes have been busy in the last minute</p> |DEPENDENT |process.odbc_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['odbc poller'].busy.avg`</p> |
|Zabbix server |Remote Zabbix server: Utilization of history syncer internal processes, in % |<p>Average percentage of time history syncer processes have been busy in the last minute</p> |DEPENDENT |process.history_syncer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['history syncer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes history syncer not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of housekeeper internal processes, in % |<p>Average percentage of time housekeeper processes have been busy in the last minute</p> |DEPENDENT |process.housekeeper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['housekeeper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes housekeeper not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of http poller data collector processes, in % |<p>Average percentage of time http poller processes have been busy in the last minute</p> |DEPENDENT |process.http_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['http poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes http poller not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of icmp pinger data collector processes, in % |<p>Average percentage of time icmp pinger processes have been busy in the last minute</p> |DEPENDENT |process.icmp_pinger.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['icmp pinger'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes icmp pinger not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of ipmi manager internal processes, in % |<p>Average percentage of time ipmi manager processes have been busy in the last minute</p> |DEPENDENT |process.ipmi_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes ipmi manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of ipmi poller data collector processes, in % |<p>Average percentage of time ipmi poller processes have been busy in the last minute</p> |DEPENDENT |process.ipmi_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['ipmi poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes ipmi poller not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of java poller data collector processes, in % |<p>Average percentage of time java poller processes have been busy in the last minute</p> |DEPENDENT |process.java_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['java poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes java poller not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of LLD manager internal processes, in % |<p>Average percentage of time lld manager processes have been busy in the last minute</p> |DEPENDENT |process.lld_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['lld manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes LLD manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of LLD worker internal processes, in % |<p>Average percentage of time lld worker processes have been busy in the last minute</p> |DEPENDENT |process.lld_worker.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['lld worker'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes LLD worker not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of poller data collector processes, in % |<p>Average percentage of time poller processes have been busy in the last minute</p> |DEPENDENT |process.poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes poller not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of preprocessing worker internal processes, in % |<p>Average percentage of time preprocessing worker processes have been busy in the last minute</p> |DEPENDENT |process.preprocessing_worker.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing worker'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes preprocessing worker not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of preprocessing manager internal processes, in % |<p>Average percentage of time preprocessing manager processes have been busy in the last minute</p> |DEPENDENT |process.preprocessing_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['preprocessing manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes preprocessing manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of proxy poller data collector processes, in % |<p>Average percentage of time proxy poller processes have been busy in the last minute</p> |DEPENDENT |process.proxy_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['proxy poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes proxy poller not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of report manager internal processes, in % |<p>Average percentage of time report manager processes have been busy in the last minute</p> |DEPENDENT |process.report_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['report manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes report manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of report writer internal processes, in % |<p>Average percentage of time report writer processes have been busy in the last minute</p> |DEPENDENT |process.report_writer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['report writer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes report writer not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of self-monitoring internal processes, in % |<p>Average percentage of time self-monitoring processes have been busy in the last minute</p> |DEPENDENT |process.self-monitoring.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['self-monitoring'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes self-monitoring not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of snmp trapper data collector processes, in % |<p>Average percentage of time snmp trapper processes have been busy in the last minute</p> |DEPENDENT |process.snmp_trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['snmp trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes snmp trapper not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of task manager internal processes, in % |<p>Average percentage of time task manager processes have been busy in the last minute</p> |DEPENDENT |process.task_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['task manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes task manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of timer internal processes, in % |<p>Average percentage of time timer processes have been busy in the last minute</p> |DEPENDENT |process.timer.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['timer'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes timer not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of service manager internal processes, in % |<p>Average percentage of time service manager processes have been busy in the last minute</p> |DEPENDENT |process.service_manager.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['service manager'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes service manager not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of trigger housekeeper internal processes, in % |<p>Average percentage of time trigger housekeeper processes have been busy in the last minute</p> |DEPENDENT |process.trigger_housekeeper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['trigger housekeeper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes trigger housekeeper not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of trapper data collector processes, in % |<p>Average percentage of time trapper processes have been busy in the last minute</p> |DEPENDENT |process.trapper.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['trapper'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes trapper not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of unreachable poller data collector processes, in % |<p>Average percentage of time unreachable poller processes have been busy in the last minute</p> |DEPENDENT |process.unreachable_poller.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['unreachable poller'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes unreachable poller not started`</p> |
|Zabbix server |Remote Zabbix server: Utilization of vmware data collector processes, in % |<p>Average percentage of time vmware collector processes have been busy in the last minute</p> |DEPENDENT |process.vmware_collector.avg.busy<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.process['vmware collector'].busy.avg`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Processes vmware collector not started`</p> |
|Zabbix server |Remote Zabbix server: Configuration cache, % used |<p>Availability statistics of Zabbix configuration cache. Percentage of used buffer.</p> |DEPENDENT |rcache.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.rcache.pused`</p> |
|Zabbix server |Remote Zabbix server: Trend function cache, % unique requests |<p>Effectiveness statistics of the Zabbix trend function cache. Percentage</p><p>of cached items from cached items + requests. Low percentage most likely means</p><p>that the cache size can be reduced.</p> |DEPENDENT |tcache.pitems<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.tcache.pitems`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Not supported this version`</p> |
|Zabbix server |Remote Zabbix server: Trend function cache, % misses |<p>Effectiveness statistics of the Zabbix trend function cache. Percentage of cache misses.</p> |DEPENDENT |tcache.pmisses<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.tcache.pmisses`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> Not supported this version`</p> |
|Zabbix server |Remote Zabbix server: Value cache, % used |<p>Availability statistics of Zabbix value cache. Percentage of used buffer.</p> |DEPENDENT |vcache.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.buffer.pused`</p> |
|Zabbix server |Remote Zabbix server: Value cache hits |<p>Effectiveness statistics of Zabbix value cache. Number of cache hits</p><p>(history values taken from the cache).</p> |DEPENDENT |vcache.cache.hits<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.hits`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Value cache misses |<p>Effectiveness statistics of Zabbix value cache. Number of cache misses</p><p>(history values taken from the database).</p> |DEPENDENT |vcache.cache.misses<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.misses`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Value cache operating mode |<p>Value cache operating mode.</p> |DEPENDENT |vcache.cache.mode<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vcache.cache.mode`</p> |
|Zabbix server |Remote Zabbix server: Version |<p>Version of Zabbix server.</p> |DEPENDENT |version<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.version`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1d`</p> |
|Zabbix server |Remote Zabbix server: VMware cache, % used |<p>Availability statistics of Zabbix vmware cache. Percentage of used buffer.</p> |DEPENDENT |vmware.buffer.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.vmware.pused`</p><p>⛔️ON_FAIL: `CUSTOM_ERROR -> No vmware collector processes started`</p> |
|Zabbix server |Remote Zabbix server: History write cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used history buffer.</p><p>History cache is used to store item values. A high number indicates performance problems on the database side.</p> |DEPENDENT |wcache.history.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.history.pused`</p> |
|Zabbix server |Remote Zabbix server: History index cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used history index buffer.</p><p>History index cache is used to index values stored in history cache.</p> |DEPENDENT |wcache.index.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.index.pused`</p> |
|Zabbix server |Remote Zabbix server: Trend write cache, % used |<p>Statistics and availability of Zabbix write cache. Percentage of used trend buffer.</p><p>Trend cache stores aggregate for the current hour for all items that receive data.</p> |DEPENDENT |wcache.trend.pused<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.trend.pused`</p> |
|Zabbix server |Remote Zabbix server: Number of processed values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Total number of values processed by Zabbix server or Zabbix proxy, except unsupported items.</p> |DEPENDENT |wcache.values<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.all`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed numeric (float) values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed float values.</p> |DEPENDENT |wcache.values.float<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.float`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed log values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed log values.</p> |DEPENDENT |wcache.values.log<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.log`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed not supported values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of times item processing resulted in item becoming unsupported or keeping that state.</p> |DEPENDENT |wcache.values.not_supported<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values['not supported']`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed character values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed character/string values.</p> |DEPENDENT |wcache.values.str<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.str`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: Number of processed text values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed text values.</p> |DEPENDENT |wcache.values.text<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.text`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix server |Remote Zabbix server: LLD queue |<p>Count of values enqueued in the low-level discovery processing queue.</p> |DEPENDENT |lld_queue<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.lld_queue`</p> |
|Zabbix server |Remote Zabbix server: Preprocessing queue |<p>Count of values enqueued in the preprocessing queue.</p> |DEPENDENT |preprocessing_queue<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.preprocessing_queue`</p> |
|Zabbix server |Remote Zabbix server: Number of processed numeric (unsigned) values per second |<p>Statistics and availability of Zabbix write cache.</p><p>Number of processed numeric (unsigned) values.</p> |DEPENDENT |wcache.values.uint<p>**Preprocessing**:</p><p>- JSONPATH: `$.data.wcache.values.uint`</p><p>- CHANGE_PER_SECOND</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|Cluster node [{#NODE.NAME}]: Status changed |<p>The state of the node has changed. Confirm to close.</p> |`last(/Remote Zabbix server health/zabbix.nodes.status[{#NODE.ID}],#1)<>last(/Remote Zabbix server health/zabbix.nodes.status[{#NODE.ID}],#2)` |INFO |<p>Manual close: YES</p> |
|Remote Zabbix server: More than 100 items having missing data for more than 10 minutes |<p>zabbix[stats,{$IP},{$PORT},queue,10m] item is collecting data about</p><p>how many items are missing data for more than 10 minutes.</p> |`min(/Remote Zabbix server health/zabbix[stats,{$ADDRESS},{$PORT},queue,10m],10m)>100` |WARNING | |
|Remote Zabbix server: Utilization of alert manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.alert_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.alert_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of alert syncer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.alert_syncer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.alert_syncer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of alerter processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.alerter.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.alerter.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of availability manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.availability_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.availability_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of configuration syncer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.configuration_syncer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.configuration_syncer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of discoverer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.discoverer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.discoverer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of escalator processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.escalator.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.escalator.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of history poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.history_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.history_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ODBC poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.odbc_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.odbc_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of history syncer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.history_syncer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.history_syncer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of housekeeper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.housekeeper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.housekeeper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of http poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.http_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.http_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of icmp pinger processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.icmp_pinger.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.icmp_pinger.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ipmi manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.ipmi_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.ipmi_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of ipmi poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.ipmi_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.ipmi_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of java poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.java_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.java_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of lld manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.lld_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.lld_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of lld worker processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.lld_worker.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.lld_worker.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of preprocessing worker processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.preprocessing_worker.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.preprocessing_worker.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of preprocessing manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.preprocessing_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.preprocessing_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of proxy poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.proxy_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.proxy_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of report manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.report_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.report_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of report writer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.report_writer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.report_writer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of self-monitoring processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.self-monitoring.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.self-monitoring.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of snmp trapper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.snmp_trapper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.snmp_trapper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of task manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.task_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.task_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of timer processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.timer.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.timer.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of service manager processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.service_manager.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.service_manager.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of trigger housekeeper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.trigger_housekeeper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.trigger_housekeeper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of trapper processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.trapper.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.trapper.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of unreachable poller processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.unreachable_poller.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.unreachable_poller.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: Utilization of vmware collector processes is high |<p>-</p> |`avg(/Remote Zabbix server health/process.vmware_collector.avg.busy,10m)>75`<p>Recovery expression:</p>`avg(/Remote Zabbix server health/process.vmware_collector.avg.busy,10m)<65` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the configuration cache |<p>Consider increasing CacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix server health/rcache.buffer.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 95% used in the value cache |<p>Consider increasing ValueCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix server health/vcache.buffer.pused,10m)>95` |AVERAGE | |
|Remote Zabbix server: Zabbix value cache working in low memory mode |<p>Once the low memory mode has been switched on, the value cache will remain in this state for 24 hours, even if the problem that triggered this mode is resolved sooner.</p> |`last(/Remote Zabbix server health/vcache.cache.mode)=1` |HIGH | |
|Remote Zabbix server: Version has changed |<p>Remote Zabbix server version has changed. Ack to close.</p> |`last(/Remote Zabbix server health/version,#1)<>last(/Remote Zabbix server health/version,#2) and length(last(/Remote Zabbix server health/version))>0` |INFO |<p>Manual close: YES</p> |
|Remote Zabbix server: More than 75% used in the vmware cache |<p>Consider increasing VMwareCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix server health/vmware.buffer.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the history cache |<p>Consider increasing HistoryCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix server health/wcache.history.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the history index cache |<p>Consider increasing HistoryIndexCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix server health/wcache.index.pused,10m)>75` |AVERAGE | |
|Remote Zabbix server: More than 75% used in the trends cache |<p>Consider increasing TrendCacheSize in the zabbix_server.conf configuration file.</p> |`max(/Remote Zabbix server health/wcache.trend.pused,10m)>75` |AVERAGE | |

## Feedback

Please report any issues with the template at https://support.zabbix.com

