
# Jenkins by HTTP

## Overview

For Zabbix version: 6.0 and higher  
The template to monitor Apache Jenkins by Zabbix that work without any external scripts.
Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.



This template was tested on:

- Jenkins, version 2.263.1

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/6.0/manual/config/templates_out_of_the_box/http) for basic instructions.

Metrics are collected by requests to [Metrics API](https://plugins.jenkins.io/metrics/).
For common metrics:
 Install and configure Metrics plugin parameters according [official documentations](https://plugins.jenkins.io/metrics/). Do not forget to configure access to the Metrics Servlet by issuing API key and change macro {$JENKINS.API.KEY}.

For monitoring computers and builds:
 Create API token for monitoring user according [official documentations](https://www.jenkins.io/doc/book/system-administration/authenticating-scripted-clients/) and change macro {$JENKINS.USER}, {$JENKINS.API.TOKEN}.
Don't forget to change macros {$JENKINS.URL}.


## Zabbix configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$JENKINS.API.KEY} |<p>API key to access Metrics Servlet</p> |`` |
|{$JENKINS.API.TOKEN} |<p>API token for HTTP BASIC authentication.</p> |`` |
|{$JENKINS.FILE_DESCRIPTORS.MAX.WARN} |<p>Maximum percentage of file descriptors usage alert threshold (for trigger expression).</p> |`85` |
|{$JENKINS.JOB.HEALTH.SCORE.MIN.WARN} |<p>Minimum job's health score (for trigger expression).</p> |`50` |
|{$JENKINS.PING.REPLY} |<p>Expected reply to the ping.</p> |`pong` |
|{$JENKINS.URL} |<p>Jenkins URL in the format `<scheme>://<host>:<port>`</p> |`` |
|{$JENKINS.USER} |<p>Username for HTTP BASIC authentication</p> |`zabbix` |

## Template links

There are no template links in this template.

## Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|Computers discovery |<p>-</p> |HTTP_AGENT |jenkins.computers<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[*]`</p> |
|Jobs discovery |<p>-</p> |HTTP_AGENT |jenkins.jobs<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[*]`</p> |

## Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Jenkins |Jenkins: Disk space check message |<p>The message will reference the first node which fails this check.  There may be other nodes that fail the check, but this health check is designed to fail fast.</p> |DEPENDENT |jenkins.disk_space.message<p>**Preprocessing**:</p><p>- JSONPATH: `$['disk-space'].message`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Jenkins |Jenkins: Temporary space check message |<p>The message will reference the first node which fails this check. There may be other nodes that fail the check, but this health check is designed to fail fast.</p> |DEPENDENT |jenkins.temporary_space.message<p>**Preprocessing**:</p><p>- JSONPATH: `$['temporary-space'].message`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Jenkins |Jenkins: Plugins check message |<p>The message of plugins health check.</p> |DEPENDENT |jenkins.plugins.message<p>**Preprocessing**:</p><p>- JSONPATH: `$['plugins'].message`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Jenkins |Jenkins: Thread deadlock check message |<p>The message of thread deadlock health check.</p> |DEPENDENT |jenkins.thread_deadlock.message<p>**Preprocessing**:</p><p>- JSONPATH: `$['thread-deadlock'].message`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Jenkins |Jenkins: Disk space check |<p>Returns FAIL if any of the Jenkins disk space monitors are reporting the disk space as less than the configured threshold.</p> |DEPENDENT |jenkins.disk_space<p>**Preprocessing**:</p><p>- JSONPATH: `$['disk-space'].healthy`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Plugins check |<p>Returns FAIL if any of the Jenkins plugins failed to start.</p> |DEPENDENT |jenkins.plugins<p>**Preprocessing**:</p><p>- JSONPATH: `$.plugins.healthy`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Temporary space check |<p>Returns FAIL if any of the Jenkins temporary space monitors are reporting the temporary space as less than the configured threshold.</p> |DEPENDENT |jenkins.temporary_space<p>**Preprocessing**:</p><p>- JSONPATH: `$['temporary-space'].healthy`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Thread deadlock check |<p>Returns FAIL if there are any deadlocked threads in the Jenkins master JVM.</p> |DEPENDENT |jenkins.thread_deadlock<p>**Preprocessing**:</p><p>- JSONPATH: `$['thread-deadlock'].healthy`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Executors count |<p>The number of executors available to Jenkins. This is corresponds to the sum of all the executors of all the on-line nodes.</p> |DEPENDENT |jenkins.executor.count<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.executor.count.value'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Executors free |<p>The number of executors available to Jenkins that are not currently in use.</p> |DEPENDENT |jenkins.executor.free<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.executor.free.value'].value`</p> |
|Jenkins |Jenkins: Executors in use |<p>The number of executors available to Jenkins that are currently in use.</p> |DEPENDENT |jenkins.executor.in_use<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.executor.in-use.value'].value`</p> |
|Jenkins |Jenkins: Nodes count |<p>The number of build nodes available to Jenkins, both on-line and off-line.</p> |DEPENDENT |jenkins.node.count<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.node.count.value'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Nodes offline |<p>The number of build nodes available to Jenkins but currently off-line.</p> |DEPENDENT |jenkins.node.offline<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.node.offline.value'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Nodes online |<p>The number of build nodes available to Jenkins and currently on-line.</p> |DEPENDENT |jenkins.node.online<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.node.online.value'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Plugins active |<p>The number of plugins in the Jenkins instance that started successfully.</p> |DEPENDENT |jenkins.plugins.active<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.plugins.active'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Plugins failed |<p>The number of plugins in the Jenkins instance that failed to start. A value other than 0 is typically indicative of a potential issue within the Jenkins installation that will either be solved by explicitly disabling the plugin(s) or by resolving the plugin dependency issues.</p> |DEPENDENT |jenkins.plugins.failed<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.plugins.failed'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Plugins inactive |<p>The number of plugins in the Jenkins instance that are not currently enabled.</p> |DEPENDENT |jenkins.plugins.inactive<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.plugins.inactive'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Plugins with update |<p>The number of plugins in the Jenkins instance that have an newer version reported as available in the current Jenkins update center metadata held by Jenkins. This value is not indicative of an issue with Jenkins but high values can be used as a trigger to review the plugins with updates with a view to seeing whether those updates potentially contain fixes for issues that could be affecting your Jenkins instance.</p> |DEPENDENT |jenkins.plugins.with_update<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.plugins.withUpdate'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Projects count |<p>The number of projects.</p> |DEPENDENT |jenkins.project.count<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.project.count.value'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Jobs count |<p>The number of jobs in Jenkins.</p> |DEPENDENT |jenkins.job.count.value<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.job.count.value'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Jenkins |Jenkins: Job scheduled, m1 rate |<p>The rate at which jobs are scheduled. If a job is already in the queue and an identical request for scheduling the job is received then Jenkins will coalesce the two requests. This metric gives a reasonably pure measure of the load requirements of the Jenkins master as it is unaffected by the number of executors available to the system.</p> |DEPENDENT |jenkins.job.scheduled.m1.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['jenkins.job.scheduled'].m1_rate`</p> |
|Jenkins |Jenkins: Jobs scheduled, m5 rate |<p>The rate at which jobs are scheduled. If a job is already in the queue and an identical request for scheduling the job is received then Jenkins will coalesce the two requests. This metric gives a reasonably pure measure of the load requirements of the Jenkins master as it is unaffected by the number of executors available to the system.</p> |DEPENDENT |jenkins.job.scheduled.m5.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['jenkins.job.scheduled'].m5_rate`</p> |
|Jenkins |Jenkins: Job blocked, m1 rate |<p>The rate at which jobs in the build queue enter the blocked state.</p> |DEPENDENT |jenkins.job.blocked.m1.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.blocked.duration'].m1_rate`</p> |
|Jenkins |Jenkins: Job blocked, m5 rate |<p>The rate at which jobs in the build queue enter the blocked state.</p> |DEPENDENT |jenkins.job.blocked.m5.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.blocked.duration'].m5_rate`</p> |
|Jenkins |Jenkins: Job blocked duration, p95 |<p>The amount of time which jobs spend in the blocked state.</p> |DEPENDENT |jenkins.job.blocked.duration.p95<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.blocked.duration'].p95`</p> |
|Jenkins |Jenkins: Job blocked duration, median |<p>The amount of time which jobs spend in the blocked state.</p> |DEPENDENT |jenkins.job.blocked.duration.p50<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.blocked.duration'].p50`</p> |
|Jenkins |Jenkins: Job building, m1 rate |<p>The rate at which jobs are built.</p> |DEPENDENT |jenkins.job.building.m1.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.building.duration'].m1_rate`</p> |
|Jenkins |Jenkins: Job building, m5 rate |<p>The rate at which jobs are built.</p> |DEPENDENT |jenkins.job.building.m5.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.building.duration'].m5_rate`</p> |
|Jenkins |Jenkins: Job building duration, p95 |<p>The amount of time which jobs spend building.</p> |DEPENDENT |jenkins.job.building.duration.p95<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.building.duration'].p95`</p> |
|Jenkins |Jenkins: Job building duration, median |<p>The amount of time which jobs spend building.</p> |DEPENDENT |jenkins.job.building.duration.p50<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.building.duration'].p50`</p> |
|Jenkins |Jenkins: Job buildable, m1 rate |<p>The rate at which jobs in the build queue enter the buildable state.</p> |DEPENDENT |jenkins.job.buildable.m1.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.buildable.duration'].m1_rate`</p> |
|Jenkins |Jenkins: Job buildable, m5 rate |<p>The rate at which jobs in the build queue enter the buildable state.</p> |DEPENDENT |jenkins.job.buildable.m5.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.buildable.duration'].m5_rate`</p> |
|Jenkins |Jenkins: Job buildable duration, p95 |<p>The amount of time which jobs spend in the buildable state.</p> |DEPENDENT |jenkins.job.buildable.duration.p95<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.buildable.duration'].p95`</p> |
|Jenkins |Jenkins: Job buildable duration, median |<p>The amount of time which jobs spend in the buildable state.</p> |DEPENDENT |jenkins.job.buildable.duration.p50<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.buildable.duration'].p50`</p> |
|Jenkins |Jenkins: Job queuing, m1 rate |<p>The rate at which jobs are queued.</p> |DEPENDENT |jenkins.job.queuing.m1.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.queuing.duration'].m1_rate`</p> |
|Jenkins |Jenkins: Job queuing, m5 rate |<p>The rate at which jobs are queued.</p> |DEPENDENT |jenkins.job.queuing.m5.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.queuing.duration'].m5_rate`</p> |
|Jenkins |Jenkins: Job queuing duration, p95 |<p>The total time which jobs spend in the build queue.</p> |DEPENDENT |jenkins.job.queuing.duration.p95<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.queuing.duration'].p95`</p> |
|Jenkins |Jenkins: Job queuing duration, median |<p>The total time which jobs spend in the build queue.</p> |DEPENDENT |jenkins.job.queuing.duration.p50<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.queuing.duration'].p50`</p> |
|Jenkins |Jenkins: Job total, m1 rate |<p>The rate at which jobs are queued.</p> |DEPENDENT |jenkins.job.total.m1.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.total.duration'].m1_rate`</p> |
|Jenkins |Jenkins: Job total, m5 rate |<p>The rate at which jobs are queued.</p> |DEPENDENT |jenkins.job.total.m5.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.total.duration'].m5_rate`</p> |
|Jenkins |Jenkins: Job total duration, p95 |<p>The total time which jobs spend from entering the build queue to completing building.</p> |DEPENDENT |jenkins.job.total.duration.p95<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.total.duration'].p95`</p> |
|Jenkins |Jenkins: Job total duration, median |<p>The total time which jobs spend from entering the build queue to completing building.</p> |DEPENDENT |jenkins.job.total.duration.p50<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.total.duration'].p50`</p> |
|Jenkins |Jenkins: Job waiting, m1 rate |<p>The rate at which jobs enter the quiet period.</p> |DEPENDENT |jenkins.job.waiting.m1.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.waiting.duration'].m1_rate`</p> |
|Jenkins |Jenkins: Job waiting, m5 rate |<p>The rate at which jobs enter the quiet period.</p> |DEPENDENT |jenkins.job.waiting.m5.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.waiting.duration'].m5_rate`</p> |
|Jenkins |Jenkins: Job waiting duration, p95 |<p>The total amount of time that jobs spend in their quiet period.</p> |DEPENDENT |jenkins.job.waiting.duration.p95<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.waiting.duration'].p95`</p> |
|Jenkins |Jenkins: Job waiting duration, median |<p>The total amount of time that jobs spend in their quiet period.</p> |DEPENDENT |jenkins.job.waiting.duration.p50<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['jenkins.job.waiting.duration'].p50`</p> |
|Jenkins |Jenkins: Build queue, blocked |<p>The number of jobs that are in the Jenkins build queue and currently in the blocked state.</p> |DEPENDENT |jenkins.queue.blocked<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.queue.blocked.value'].value`</p> |
|Jenkins |Jenkins: Build queue, size |<p>The number of jobs that are in the Jenkins build queue.</p> |DEPENDENT |jenkins.queue.size<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.queue.size.value'].value`</p> |
|Jenkins |Jenkins: Build queue, buildable |<p>The number of jobs that are in the Jenkins build queue and currently in the blocked state.</p> |DEPENDENT |jenkins.queue.buildable<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.queue.buildable.value'].value`</p> |
|Jenkins |Jenkins: Build queue, pending |<p>The number of jobs that are in the Jenkins build queue and currently in the blocked state.</p> |DEPENDENT |jenkins.queue.pending<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.queue.pending.value'].value`</p> |
|Jenkins |Jenkins: Build queue, stuck |<p>The number of jobs that are in the Jenkins build queue and currently in the blocked state.</p> |DEPENDENT |jenkins.queue.stuck<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.queue.stuck.value'].value`</p> |
|Jenkins |Jenkins: HTTP active requests, rate |<p>The number of currently active requests against the Jenkins master Web UI.</p> |DEPENDENT |jenkins.http.active_requests.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.counters.['http.activeRequests'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 400, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/400 status code.</p> |DEPENDENT |jenkins.http.bad_request.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.badRequest'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 500, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/500 status code.</p> |DEPENDENT |jenkins.http.server_error.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.serverError'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 503, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/503 status code.</p> |DEPENDENT |jenkins.http.service_unavailable.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.serviceUnavailable'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 200, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/200 status code.</p> |DEPENDENT |jenkins.http.ok.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.ok'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response other, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a non-informational status code that is not in the list: HTTP/200, HTTP/201, HTTP/204, HTTP/304, HTTP/400, HTTP/403, HTTP/404, HTTP/500, or HTTP/503.</p> |DEPENDENT |jenkins.http.other.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.other'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 201, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/201 status code.</p> |DEPENDENT |jenkins.http.created.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.created'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 204, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/204 status code.</p> |DEPENDENT |jenkins.http.no_content.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.noContent'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 404, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/404 status code.</p> |DEPENDENT |jenkins.http.not_found.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.notFound'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 304, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/304 status code.</p> |DEPENDENT |jenkins.http.not_modified.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.notModified'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP response 403, rate |<p>The rate at which the Jenkins master Web UI is responding to requests with a HTTP/403 status code.</p> |DEPENDENT |jenkins.http.forbidden.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.meters.['http.responseCodes.forbidden'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP requests, rate |<p>The rate at which the Jenkins master Web UI is receiving requests.</p> |DEPENDENT |jenkins.http.requests.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['http.requests'].count`</p><p>- CHANGE_PER_SECOND</p> |
|Jenkins |Jenkins: HTTP requests, p95 |<p>The time spent generating the corresponding responses.</p> |DEPENDENT |jenkins.http.requests_p95.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['http.requests'].p95`</p> |
|Jenkins |Jenkins: HTTP requests, median |<p>The time spent generating the corresponding responses.</p> |DEPENDENT |jenkins.http.requests_p50.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.timers.['http.requests'].p50`</p> |
|Jenkins |Jenkins: Version |<p>Version of Jenkins server.</p> |DEPENDENT |jenkins.version<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['jenkins.versions.core'].value`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Jenkins |Jenkins: CPU Load |<p>The system load on the Jenkins master as reported by the JVM's Operating System JMX bean. The calculation of system load is operating system dependent. Typically this is the sum of the number of processes that are currently running plus the number that are waiting to run. This is typically comparable against the number of CPU cores.</p> |DEPENDENT |jenkins.system.cpu.load<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['system.cpu.load'].value`</p> |
|Jenkins |Jenkins: Uptime |<p>The number of seconds since the Jenkins master JVM started.</p> |DEPENDENT |jenkins.system.uptime<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['vm.uptime.milliseconds'].value`</p><p>- MULTIPLIER: `0.001`</p> |
|Jenkins |Jenkins: File descriptor ratio |<p>The ratio of used to total file descriptors</p> |DEPENDENT |jenkins.descriptor.ratio<p>**Preprocessing**:</p><p>- JSONPATH: `$.gauges.['vm.file.descriptor.ratio'].value`</p><p>- MULTIPLIER: `100`</p> |
|Jenkins |Jenkins: Service ping | |HTTP_AGENT |jenkins.ping<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 0`</p><p>- REGEX: `{$JENKINS.PING.REPLY}$ 1`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> 0`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Health score |<p>Represents health of project. A number between 0-100.</p><p>Job Description: {#DESCRIPTION}</p><p>Job Url: {#URL}</p> |DEPENDENT |jenkins.build.health[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].healthReport..score.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Build number |<p>Details: {#URL}/lastBuild/</p> |DEPENDENT |jenkins.last_build.number[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastBuild.number.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Build duration |<p>Build duration (in seconds).</p> |DEPENDENT |jenkins.last_build.duration[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastBuild.duration.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Build timestamp | |DEPENDENT |jenkins.last_build.timestamp[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastBuild.timestamp.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Build result | |DEPENDENT |jenkins.last_build.result[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastBuild.result.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Failed Build number |<p>Details: {#URL}/lastFailedBuild/</p> |DEPENDENT |jenkins.last_failed_build.number[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastFailedBuild.number.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Failed Build duration |<p>Build duration (in seconds).</p> |DEPENDENT |jenkins.last_failed_build.duration[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastFailedBuild.duration.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Failed Build timestamp |<p>-</p> |DEPENDENT |jenkins.last_failed_build.timestamp[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastFailedBuild.timestamp.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Successful Build number |<p>Details: {#URL}/lastSuccessfulBuild/</p> |DEPENDENT |jenkins.last_successful_build.number[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastSuccessfulBuild.number.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Successful Build duration |<p>Build duration (in seconds).</p> |DEPENDENT |jenkins.last_successful_build.duration[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastSuccessfulBuild.duration.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins job [{#NAME}]: Last Successful Build timestamp |<p>-</p> |DEPENDENT |jenkins.last_successful_build.timestamp[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.jobs.[?(@.name == "{#NAME}")].lastSuccessfulBuild.timestamp.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Executors |<p>The maximum number of concurrent builds that Jenkins may perform on this node.</p> |DEPENDENT |jenkins.computer.numExecutors[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].numExecutors.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: State |<p>Represents the actual online/offline state.</p><p>Node description: {#DESCRIPTION}</p> |DEPENDENT |jenkins.computer.state[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].offline.first()`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Offline cause reason |<p>If the computer was offline (either temporarily or not), will return the cause as a string (without user info). Empty string if the system was put offline without given a cause.</p> |DEPENDENT |jenkins.computer.offline.reason[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].offlineCauseReason.first()`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Idle |<p>Returns true if all the executors of this computer are idle.</p> |DEPENDENT |jenkins.computer.idle[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].idle.first()`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Temporarily offline |<p>Returns true if this node is marked temporarily offline.</p> |DEPENDENT |jenkins.computer.temp_offline[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].temporarilyOffline.first()`</p><p>- BOOL_TO_DECIMAL</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Available disk space |<p>The available disk space of $JENKINS_HOME on agent.</p> |DEPENDENT |jenkins.computer.disk_space[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.DiskSpaceMonitor'].size.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Available temp space |<p>The available disk space of the temporary directory. Java tools and tests/builds often create files in the temporary directory, and may not function properly if there's no available space.</p> |DEPENDENT |jenkins.computer.temp_space[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.TemporarySpaceMonitor'].size.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Response time average |<p>The round trip network response time from the master to the agent</p> |DEPENDENT |jenkins.computer.response_time[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.ResponseTimeMonitor'].average.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Available physical memory |<p>The total physical memory of the system, available bytes.</p> |DEPENDENT |jenkins.computer.available_physical_memory[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.SwapSpaceMonitor'].availablePhysicalMemory.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Available swap space |<p>Available swap space in bytes.</p> |DEPENDENT |jenkins.computer.available_swap_space[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.SwapSpaceMonitor'].availableSwapSpace.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Total physical memory |<p>Total physical memory of the system, in bytes.</p> |DEPENDENT |jenkins.computer.total_physical_memory[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.SwapSpaceMonitor'].totalPhysicalMemory.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Total swap space |<p>Total number of swap space in bytes.</p> |DEPENDENT |jenkins.computer.total_swap_space[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.SwapSpaceMonitor'].totalSwapSpace.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Jenkins |Jenkins: Computer [{#DISPLAY_NAME}]: Clock difference |<p>The clock difference between the master and nodes.</p> |DEPENDENT |jenkins.computer.clock_difference[{#DISPLAY_NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.computer.[?(@.displayName == "{#DISPLAY_NAME}")].monitorData['hudson.node_monitors.ClockMonitor'].diff.first()`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- MULTIPLIER: `0.001`</p> |
|Zabbix raw items |Jenkins: Get service metrics |<p>-</p> |HTTP_AGENT |jenkins.get_metrics<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Zabbix raw items |Jenkins: Get healthcheck | |HTTP_AGENT |jenkins.healthcheck<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Zabbix raw items |Jenkins: Get jobs info |<p>-</p> |HTTP_AGENT |jenkins.job_info<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Zabbix raw items |Jenkins: Get computer info |<p>-</p> |HTTP_AGENT |jenkins.computer_info<p>**Preprocessing**:</p><p>- CHECK_NOT_SUPPORTED</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |

## Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|Jenkins: Disk space is too low |<p>Jenkins disk space monitors are reporting the disk space as less than the configured threshold. The message will reference the first node which fails this check.</p><p>Health check message: {{ITEM.LASTVALUE2}.regsub("(.*)",\1)}</p> |`last(/Jenkins by HTTP/jenkins.disk_space)=0 and length(last(/Jenkins by HTTP/jenkins.disk_space.message))>0` |WARNING | |
|Jenkins: One or more Jenkins plugins failed to start |<p>A failure is typically indicative of a potential issue within the Jenkins installation that will either be solved by explicitly disabling the failing plugin(s) or by resolving the corresponding plugin dependency issues.</p><p>Health check message: {{ITEM.LASTVALUE2}.regsub("(.*)",\1)}</p> |`last(/Jenkins by HTTP/jenkins.plugins)=0 and length(last(/Jenkins by HTTP/jenkins.plugins.message))>0` |INFO |<p>Manual close: YES</p> |
|Jenkins: Temporary space is too low |<p>Jenkins temporary space monitors are reporting the temporary space as less than the configured threshold. The message will reference the first node which fails this check.</p><p>Health check message: {{ITEM.LASTVALUE2}.regsub("(.*)",\1)}</p> |`last(/Jenkins by HTTP/jenkins.temporary_space)=0 and length(last(/Jenkins by HTTP/jenkins.temporary_space.message))>0` |WARNING | |
|Jenkins: There are deadlocked threads in Jenkins master JVM |<p>There are any deadlocked threads in the Jenkins master JVM.</p><p>Health check message: {{ITEM.LASTVALUE2}.regsub('(.*)',\1)}</p> |`last(/Jenkins by HTTP/jenkins.thread_deadlock)=0 and length(last(/Jenkins by HTTP/jenkins.thread_deadlock.message))>0` |WARNING | |
|Jenkins: Service has no online nodes |<p>-</p> |`last(/Jenkins by HTTP/jenkins.node.online)=0` |AVERAGE | |
|Jenkins: Version has changed |<p>Jenkins version has changed. Ack to close.</p> |`last(/Jenkins by HTTP/jenkins.version,#1)<>last(/Jenkins by HTTP/jenkins.version,#2) and length(last(/Jenkins by HTTP/jenkins.version))>0` |INFO |<p>Manual close: YES</p> |
|Jenkins: has been restarted |<p>Uptime is less than 10 minutes</p> |`last(/Jenkins by HTTP/jenkins.system.uptime)<10m` |INFO |<p>Manual close: YES</p> |
|Jenkins: Current number of used files is too high |<p>-</p> |`min(/Jenkins by HTTP/jenkins.descriptor.ratio,5m)>{$JENKINS.FILE_DESCRIPTORS.MAX.WARN}` |WARNING | |
|Jenkins: Service is down |<p>-</p> |`last(/Jenkins by HTTP/jenkins.ping)=0` |AVERAGE |<p>Manual close: YES</p> |
|Jenkins job [{#NAME}]: Job is unhealthy |<p>-</p> |`last(/Jenkins by HTTP/jenkins.build.health[{#NAME}])<{$JENKINS.JOB.HEALTH.SCORE.MIN.WARN}` |WARNING |<p>Manual close: YES</p> |
|Jenkins: Computer [{#DISPLAY_NAME}]: Node is down |<p>Node down with reason: {{ITEM.LASTVALUE2}.regsub("(.*)",\1)}</p> |`last(/Jenkins by HTTP/jenkins.computer.state[{#DISPLAY_NAME}])=1 and length(last(/Jenkins by HTTP/jenkins.computer.offline.reason[{#DISPLAY_NAME}]))>0` |AVERAGE |<p>**Depends on**:</p><p>- Jenkins: Computer [{#DISPLAY_NAME}]: Node is temporarily offline</p><p>- Jenkins: Service has no online nodes</p> |
|Jenkins: Computer [{#DISPLAY_NAME}]: Node is temporarily offline |<p>Node is temporarily Offline with reason: {{ITEM.LASTVALUE2}.regsub("(.*)",\1)}</p> |`last(/Jenkins by HTTP/jenkins.computer.temp_offline[{#DISPLAY_NAME}])=1 and length(last(/Jenkins by HTTP/jenkins.computer.offline.reason[{#DISPLAY_NAME}]))>0` |INFO |<p>Manual close: YES</p> |

## Feedback

Please report any issues with the template at https://support.zabbix.com

You can also provide feedback, discuss the template or ask for help with it at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback).

