; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -verify-machineinstrs -o - %s | FileCheck %s
; LSR used to pick a sub-optimal solution due to the target responding
; conservatively to isLegalAddImmediate for negative values.

declare void @foo(i32)

define void @test(i32 %px) {
; CHECK-LABEL: test:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-32]! // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w20, -16
; CHECK-NEXT:    .cfi_offset w30, -32
; CHECK-NEXT:    subs w8, w0, #1
; CHECK-NEXT:    mov w19, w0
; CHECK-NEXT:    csel w20, wzr, w8, lt
; CHECK-NEXT:    b .LBB0_2
; CHECK-NEXT:  .LBB0_1: // %for.inc
; CHECK-NEXT:    // in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    add w8, w20, #1
; CHECK-NEXT:    cmp w20, w19
; CHECK-NEXT:    mov w20, w8
; CHECK-NEXT:    b.gt .LBB0_4
; CHECK-NEXT:  .LBB0_2: // %for.body
; CHECK-NEXT:    // =>This Inner Loop Header: Depth=1
; CHECK-NEXT:    cmp w19, w20
; CHECK-NEXT:    b.eq .LBB0_1
; CHECK-NEXT:  // %bb.3: // %if.then3
; CHECK-NEXT:    // in Loop: Header=BB0_2 Depth=1
; CHECK-NEXT:    mov w0, w20
; CHECK-NEXT:    bl foo
; CHECK-NEXT:    b .LBB0_1
; CHECK-NEXT:  .LBB0_4: // %for.cond.cleanup
; CHECK-NEXT:    ldp x20, x19, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp], #32 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %sub = add nsw i32 %px, -1
  %cmp = icmp slt i32 %px, 1
  %.sub = select i1 %cmp, i32 0, i32 %sub
  br label %for.body

for.body:
  %x.015 = phi i32 [ %inc, %for.inc ], [ %.sub, %entry ]
  %cmp2 = icmp eq i32 %x.015, %px
  br i1 %cmp2, label %for.inc, label %if.then3

if.then3:
  tail call void @foo(i32 %x.015)
  br label %for.inc

for.inc:
  %inc = add nsw i32 %x.015, 1
  %cmp1 = icmp sgt i32 %x.015, %px
  br i1 %cmp1, label %for.cond.cleanup.loopexit, label %for.body

for.cond.cleanup.loopexit:
  br label %for.cond.cleanup

for.cond.cleanup:
  ret void
}
